/*
 * Decompiled with CFR 0.152.
 */
package jdos;

import jdos.cpu.CPU;
import jdos.cpu.Callback;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.Compiler;
import jdos.dos.CDRomImage;
import jdos.dos.Dos;
import jdos.dos.DosKeyboardLayout;
import jdos.dos.DosMSCDEX;
import jdos.dos.Drives;
import jdos.fpu.FPU;
import jdos.gui.Main;
import jdos.gui.Mapper;
import jdos.gui.Midi;
import jdos.gui.Render;
import jdos.hardware.Cmos;
import jdos.hardware.DMA;
import jdos.hardware.Disney;
import jdos.hardware.Gus;
import jdos.hardware.Hardware;
import jdos.hardware.IO;
import jdos.hardware.IPX;
import jdos.hardware.Joystick;
import jdos.hardware.Keyboard;
import jdos.hardware.MPU401;
import jdos.hardware.Memory;
import jdos.hardware.Mixer;
import jdos.hardware.NE2000;
import jdos.hardware.PCSpeaker;
import jdos.hardware.Pic;
import jdos.hardware.SBlaster;
import jdos.hardware.TandySound;
import jdos.hardware.Timer;
import jdos.hardware.VGA;
import jdos.hardware.serialport.Serialports;
import jdos.ints.Bios;
import jdos.ints.EMS;
import jdos.ints.Int10;
import jdos.ints.Mouse;
import jdos.ints.XMS;
import jdos.misc.Log;
import jdos.misc.Msg;
import jdos.misc.Program;
import jdos.misc.setup.Config;
import jdos.misc.setup.Hex;
import jdos.misc.setup.Prop_bool;
import jdos.misc.setup.Prop_hex;
import jdos.misc.setup.Prop_int;
import jdos.misc.setup.Prop_multival;
import jdos.misc.setup.Prop_multival_remain;
import jdos.misc.setup.Prop_string;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_line;
import jdos.misc.setup.Section_prop;
import jdos.shell.Shell;

public class Dosbox {
    public static boolean applet = false;
    public static Config control;
    public static int machine;
    public static int svgaCard;
    private static LoopHandler loop;
    public static boolean SDLNetInited;
    private static long ticksRemain;
    private static long ticksLast;
    private static long ticksAdded;
    public static int ticksDone;
    public static long ticksScheduled;
    public static boolean ticksLocked;
    private static LoopHandler Normal_Loop;
    private static boolean autoadjust;
    private static Mapper.MAPPER_Handler DOSBOX_UnlockSpeed;
    private static Section.SectionFunction DOSBOX_RealInit;

    public static boolean IS_TANDY_ARCH() {
        return machine == 2 || machine == 3;
    }

    public static boolean IS_EGAVGA_ARCH() {
        return machine == 4 || machine == 5;
    }

    public static boolean IS_VGA_ARCH() {
        return machine == 5;
    }

    private static void DOSBOX_SetLoop(LoopHandler handler2) {
        loop = handler2;
    }

    private static void DOSBOX_SetNormalLoop() {
        loop = Normal_Loop;
    }

    public static void DOSBOX_RunMachinePF() {
        int ret;
        while ((ret = loop.call()) == 0) {
        }
    }

    public static void DOSBOX_RunMachine() {
        int ret;
        do {
            try {
                ret = loop.call();
            }
            catch (Paging.PageFaultException e) {
                ret = 0;
            }
        } while (ret == 0);
    }

    public static void Init() {
        SDLNetInited = false;
        String[] rates = new String[]{"44100", "48000", "32000", "22050", "16000", "11025", "8000", "49716"};
        String[] oplrates = new String[]{"44100", "49716", "48000", "32000", "22050", "16000", "11025", "8000"};
        String[] ios = new String[]{"220", "240", "260", "280", "2a0", "2c0", "2e0", "300"};
        String[] irqssb = new String[]{"7", "5", "3", "9", "10", "11", "12"};
        String[] dmassb = new String[]{"1", "5", "0", "3", "6", "7"};
        String[] iosgus = new String[]{"240", "220", "260", "280", "2a0", "2c0", "2e0", "300"};
        String[] irqsgus = new String[]{"5", "3", "7", "9", "10", "11", "12"};
        String[] dmasgus = new String[]{"3", "0", "1", "5", "6", "7"};
        String[] machines = new String[]{"hercules", "cga", "tandy", "pcjr", "ega", "vgaonly", "svga_s3", "svga_et3000", "svga_et4000", "svga_paradise", "vesa_nolfb", "vesa_oldvbe"};
        Section_prop secprop = control.AddSection_prop("dosbox", DOSBOX_RealInit);
        Prop_string Pstring = secprop.Add_path("language", 0, "");
        Pstring.Set_help("Select another language file.");
        Pstring = secprop.Add_string("machine", 2, "svga_s3");
        Pstring.Set_values(machines);
        Pstring.Set_help("The type of machine tries to emulate.");
        Prop_int Pint = secprop.Add_int("vmemsize", 1, applet ? 1 : 2);
        Pint.SetMinMax(0, 8);
        Pint.Set_help("Amount of video memory in megabytes.\n  The maximum resolution and color depth the svga_s3 will be able to display\n  is determined by this value.\n   0: 512k (800x600  at 256 colors)\n  1: 1024x768  at 256 colors or 800x600  at 64k colors\n  2: 1600x1200 at 256 colors or 1024x768 at 64k colors or 640x480 at 16M colors\n  4: 1600x1200 at 64k colors or 1024x768 at 16M colors\n  8: up to 1600x1200 at 16M colors\nFor build engine games, use more memory than in the list above so it can\nuse triple buffering and thus won't flicker.\n");
        Pstring = secprop.Add_path("captures", 0, "capture");
        Pstring.Set_help("Directory where things like wave, midi, screenshot get captured.");
        secprop.AddInitFunction(IO.IO_Init);
        secprop.AddInitFunction(Paging.PAGING_Init);
        secprop.AddInitFunction(Memory.MEM_Init);
        secprop.AddInitFunction(Hardware.HARDWARE_Init);
        Pint = secprop.Add_int("memsize", 1, applet ? 8 : 16);
        Pint.SetMinMax(1, 63);
        Pint.Set_help("Amount of memory DOSBox has in megabytes.\n  This value is best left at its default to avoid problems with some games,\n  though few games might require a higher value.\n  There is generally no speed advantage when raising this value.");
        secprop.AddInitFunction(Callback.CALLBACK_Init);
        secprop.AddInitFunction(Pic.PIC_Init);
        secprop.AddInitFunction(Program.PROGRAMS_Init);
        secprop.AddInitFunction(Timer.TIMER_Init);
        secprop.AddInitFunction(Cmos.CMOS_Init);
        secprop.AddInitFunction(VGA.VGA_Init);
        secprop = control.AddSection_prop("render", Render.RENDER_Init, true);
        Pint = secprop.Add_int("frameskip", 0, -1);
        Pint.SetMinMax(0, 10);
        Pint.Set_help("How many frames DOSBox skips before drawing one. Use -1 for auto");
        Prop_bool Pbool = secprop.Add_bool("aspect", 0, false);
        Pbool.Set_help("Do aspect correction, if your output method doesn't support scaling this can slow things down!.");
        Prop_multival Pmulti = secprop.Add_multi("scaler", 0, " ");
        Pmulti.SetValue("normal2x");
        Pmulti.Set_help("Scaler used to enlarge/enhance low resolution modes.\n  If 'forced' is appended, then the scaler will be used even if the result might not be desired.");
        Pstring = Pmulti.GetSection().Add_string("type", 0, "normal2x");
        String[] scalers = new String[]{"none", "normal2x", "normal3x"};
        Pstring.Set_values(scalers);
        String[] force = new String[]{"", "forced"};
        Pstring = Pmulti.GetSection().Add_string("force", 0, "");
        Pstring.Set_values(force);
        secprop = control.AddSection_prop("cpu", CPU.CPU_Init, true);
        String[] cores = new String[]{"auto", "dynamic", "normal", "simple"};
        Pstring = secprop.Add_string("core", 1, "auto");
        Pstring.Set_values(cores);
        Pstring.Set_help("CPU Core used in emulation. auto will switch to dynamic if available and appropriate.");
        String[] cputype_values = new String[]{"auto", "386", "486", "pentium", "386_prefetch", "486_prefetch"};
        Pstring = secprop.Add_string("cputype", 0, "auto");
        Pstring.Set_values(cputype_values);
        Pstring.Set_help("CPU Type used in emulation. auto emulates a 486 which tolerates Pentium instructions.");
        Prop_multival_remain Pmulti_remain = secprop.Add_multiremain("cycles", 0, " ");
        Pmulti_remain.Set_help("Amount of instructions DOSBox tries to emulate each millisecond.\nSetting this value too high results in sound dropouts and lags.\nCycles can be set in 3 ways:\n  'auto'          tries to guess what a game needs.\n                  It usually works, but can fail for certain games.\n  'fixed #number' will set a fixed amount of cycles. This is what you usually need if 'auto' fails.\n                  (Example: fixed 4000).\n  'max'           will allocate as much cycles as your computer is able to handle.\n");
        String[] cyclest = new String[]{"auto", "fixed", "max", "%u"};
        Pstring = Pmulti_remain.GetSection().Add_string("type", 0, "auto");
        Pmulti_remain.SetValue("auto");
        Pstring.Set_values(cyclest);
        Pstring = Pmulti_remain.GetSection().Add_string("parameters", 0, "");
        Pint = secprop.Add_int("cycleup", 0, 10);
        Pint.SetMinMax(1, 1000000);
        Pint.Set_help("Amount of cycles to decrease/increase with keycombo.(CTRL-F11/CTRL-F12)");
        Pint = secprop.Add_int("cycledown", 0, 20);
        Pint.SetMinMax(1, 1000000);
        Pint.Set_help("Setting it lower than 100 will be a percentage.");
        secprop = control.AddSection_prop("compiler", Compiler.Compiler_Init, true);
        Pint = secprop.Add_int("threshold", 0, 1000);
        Pint.Set_help("How many times a block is seen before it is compiled.  0 turns off the compiler, 1 compiles everything.\nOnly used when dynamic_core is active. Values between 100-1000 yield the best results.");
        Pint = secprop.Add_int("min_block_size", 0, 2);
        Pint.Set_help("The minimum number of ops the block must contain in order to be compiled.  In general 2 is a good value.");
        secprop.AddInitFunction(FPU.FPU_Init);
        secprop.AddInitFunction(DMA.DMA_Init);
        secprop.AddInitFunction(Keyboard.KEYBOARD_Init);
        secprop = control.AddSection_prop("mixer", Mixer.MIXER_Init);
        Pbool = secprop.Add_bool("nosound", 2, false);
        Pbool.Set_help("Enable silent mode, sound is still emulated though.");
        Pint = secprop.Add_int("rate", 2, 44100);
        Pint.Set_values(rates);
        Pint.Set_help("Mixer sample rate, setting any device's rate higher than this will probably lower their sound quality.");
        String[] blocksizes = new String[]{"1024", "2048", "4096", "8192", "512", "256"};
        Pint = secprop.Add_int("blocksize", 2, 512);
        Pint.Set_values(blocksizes);
        Pint.Set_help("Mixer block size, larger blocks might help sound stuttering but sound will also be more lagged.");
        Pint = secprop.Add_int("prebuffer", 2, 20);
        Pint.SetMinMax(0, 100);
        Pint.Set_help("How many milliseconds of data to keep on top of the blocksize.");
        Pint = secprop.Add_int("javabuffer", 2, 8820);
        Pint.SetMinMax(0, 100);
        Pint.Set_help("Buffer parameter passed to Java's SourceDataLine.open call. At 44100Hz, 16-bit stereo a value of 8820 represents 50ms");
        secprop = control.AddSection_prop("midi", Midi.MIDI_Init, true);
        secprop.AddInitFunction(MPU401.MPU401_Init, true);
        String[] mputypes = new String[]{"intelligent", "uart", "none"};
        String[] devices = new String[]{"default", "win32", "alsa", "oss", "coreaudio", "coremidi", "none"};
        Pstring = secprop.Add_string("mpu401", 1, "intelligent");
        Pstring.Set_values(mputypes);
        Pstring.Set_help("Type of MPU-401 to emulate.");
        Pstring = secprop.Add_string("mididevice", 1, "default");
        Pstring.Set_values(devices);
        Pstring.Set_help("Device that will receive the MIDI data from MPU-401.");
        Pstring = secprop.Add_string("midiconfig", 1, "");
        Pstring.Set_help("Special configuration options for the device driver. This is usually the id of the device you want to use.\n  See the README/Manual for more details.");
        secprop = control.AddSection_prop("sblaster", SBlaster.SBLASTER_Init, true);
        String[] sbtypes = new String[]{"sb1", "sb2", "sbpro1", "sbpro2", "sb16", "gb", "none"};
        Pstring = secprop.Add_string("sbtype", 1, "sb16");
        Pstring.Set_values(sbtypes);
        Pstring.Set_help("Type of Soundblaster to emulate. gb is Gameblaster.");
        Prop_hex Phex = secprop.Add_hex("sbbase", 1, new Hex(544));
        Phex.Set_values(ios);
        Phex.Set_help("The IO address of the soundblaster.");
        Pint = secprop.Add_int("irq", 1, 7);
        Pint.Set_values(irqssb);
        Pint.Set_help("The IRQ number of the soundblaster.");
        Pint = secprop.Add_int("dma", 1, 1);
        Pint.Set_values(dmassb);
        Pint.Set_help("The DMA number of the soundblaster.");
        Pint = secprop.Add_int("hdma", 1, 5);
        Pint.Set_values(dmassb);
        Pint.Set_help("The High DMA number of the soundblaster.");
        Pbool = secprop.Add_bool("sbmixer", 1, true);
        Pbool.Set_help("Allow the soundblaster mixer to modify the DOSBox mixer.");
        String[] oplmodes = new String[]{"auto", "cms", "opl2", "dualopl2", "opl3", "none"};
        Pstring = secprop.Add_string("oplmode", 1, "auto");
        Pstring.Set_values(oplmodes);
        Pstring.Set_help("Type of OPL emulation. On 'auto' the mode is determined by sblaster type. All OPL modes are Adlib-compatible, except for 'cms'.");
        String[] oplemus = new String[]{"default", "compat", "fast"};
        Pstring = secprop.Add_string("oplemu", 1, "default");
        Pstring.Set_values(oplemus);
        Pstring.Set_help("Provider for the OPL emulation. compat might provide better quality (see oplrate as well).");
        Pint = secprop.Add_int("oplrate", 1, 44100);
        Pint.Set_values(oplrates);
        Pint.Set_help("Sample rate of OPL music emulation. Use 49716 for highest quality (set the mixer rate accordingly).");
        secprop = control.AddSection_prop("gus", Gus.GUS_Init, true);
        Pbool = secprop.Add_bool("gus", 1, false);
        Pbool.Set_help("Enable the Gravis Ultrasound emulation.");
        Pint = secprop.Add_int("gusrate", 1, 44100);
        Pint.Set_values(rates);
        Pint.Set_help("Sample rate of Ultrasound emulation.");
        Phex = secprop.Add_hex("gusbase", 1, new Hex(576));
        Phex.Set_values(iosgus);
        Phex.Set_help("The IO base address of the Gravis Ultrasound.");
        Pint = secprop.Add_int("gusirq", 1, 5);
        Pint.Set_values(irqsgus);
        Pint.Set_help("The IRQ number of the Gravis Ultrasound.");
        Pint = secprop.Add_int("gusdma", 1, 3);
        Pint.Set_values(dmasgus);
        Pint.Set_help("The DMA channel of the Gravis Ultrasound.");
        Pstring = secprop.Add_string("ultradir", 1, "C:\\ULTRASND");
        Pstring.Set_help("Path to Ultrasound directory. In this directory\nthere should be a MIDI directory that contains\nthe patch files for GUS playback. Patch sets used\nwith Timidity should work fine.");
        secprop = control.AddSection_prop("speaker", PCSpeaker.PCSPEAKER_Init, true);
        Pbool = secprop.Add_bool("pcspeaker", 1, true);
        Pbool.Set_help("Enable PC-Speaker emulation.");
        Pint = secprop.Add_int("pcrate", 1, 44100);
        Pint.Set_values(rates);
        Pint.Set_help("Sample rate of the PC-Speaker sound generation.");
        secprop.AddInitFunction(TandySound.TANDYSOUND_Init, true);
        String[] tandys = new String[]{"auto", "on", "off"};
        Pstring = secprop.Add_string("tandy", 1, "auto");
        Pstring.Set_values(tandys);
        Pstring.Set_help("Enable Tandy Sound System emulation. For 'auto', emulation is present only if machine is set to 'tandy'.");
        Pint = secprop.Add_int("tandyrate", 1, 44100);
        Pint.Set_values(rates);
        Pint.Set_help("Sample rate of the Tandy 3-Voice generation.");
        secprop.AddInitFunction(Disney.DISNEY_Init, true);
        Pbool = secprop.Add_bool("disney", 1, true);
        Pbool.Set_help("Enable Disney Sound Source emulation. (Covox Voice Master and Speech Thing compatible).");
        secprop = control.AddSection_prop("joystick", Bios.BIOS_Init, false);
        secprop.AddInitFunction(Int10.INT10_Init);
        secprop.AddInitFunction(Mouse.MOUSE_Init);
        secprop.AddInitFunction(Joystick.JOYSTICK_Init);
        String[] joytypes = new String[]{"auto", "2axis", "4axis", "4axis_2", "fcs", "ch", "none"};
        Pstring = secprop.Add_string("joysticktype", 1, "auto");
        Pstring.Set_values(joytypes);
        Pstring.Set_help("Type of joystick to emulate: auto (default), none,\n2axis (supports two joysticks),\n4axis (supports one joystick, first joystick used),\n4axis_2 (supports one joystick, second joystick used),\nfcs (Thrustmaster), ch (CH Flightstick).\nnone disables joystick emulation.\nauto chooses emulation depending on real joystick(s).\n(Remember to reset dosbox's mapperfile if you saved it earlier)");
        Pbool = secprop.Add_bool("timed", 1, true);
        Pbool.Set_help("enable timed intervals for axis. Experiment with this option, if your joystick drifts (away).");
        Pbool = secprop.Add_bool("autofire", 1, false);
        Pbool.Set_help("continuously fires as long as you keep the button pressed.");
        Pbool = secprop.Add_bool("swap34", 1, false);
        Pbool.Set_help("swap the 3rd and the 4th axis. can be useful for certain joysticks.");
        Pbool = secprop.Add_bool("buttonwrap", 1, false);
        Pbool.Set_help("enable button wrapping at the number of emulated buttons.");
        secprop = control.AddSection_prop("serial", Serialports.SERIAL_Init, true);
        String[] serials = new String[]{"dummy", "disabled", "modem", "nullmodem", "directserial"};
        Pmulti_remain = secprop.Add_multiremain("serial1", 1, " ");
        Pstring = Pmulti_remain.GetSection().Add_string("type", 1, "dummy");
        Pmulti_remain.SetValue("dummy");
        Pstring.Set_values(serials);
        Pstring = Pmulti_remain.GetSection().Add_string("parameters", 1, "");
        Pmulti_remain.Set_help("set type of device connected to com port.\nCan be disabled, dummy, modem, nullmodem, directserial.\nAdditional parameters must be in the same line in the form of\nparameter:value. Parameter for all types is irq (optional).\nfor directserial: realport (required), rxdelay (optional).\n                 (realport:COM1 realport:ttyS0).\nfor modem: listenport (optional).\nfor nullmodem: server, rxdelay, txdelay, telnet, usedtr,\n               transparent, port, inhsocket (all optional).\nExample: serial1=modem listenport:5000");
        Pmulti_remain = secprop.Add_multiremain("serial2", 1, " ");
        Pstring = Pmulti_remain.GetSection().Add_string("type", 1, "dummy");
        Pmulti_remain.SetValue("dummy");
        Pstring.Set_values(serials);
        Pstring = Pmulti_remain.GetSection().Add_string("parameters", 1, "");
        Pmulti_remain.Set_help("see serial1");
        Pmulti_remain = secprop.Add_multiremain("serial3", 1, " ");
        Pstring = Pmulti_remain.GetSection().Add_string("type", 1, "disabled");
        Pmulti_remain.SetValue("disabled");
        Pstring.Set_values(serials);
        Pstring = Pmulti_remain.GetSection().Add_string("parameters", 1, "");
        Pmulti_remain.Set_help("see serial1");
        Pmulti_remain = secprop.Add_multiremain("serial4", 1, " ");
        Pstring = Pmulti_remain.GetSection().Add_string("type", 1, "disabled");
        Pmulti_remain.SetValue("disabled");
        Pstring.Set_values(serials);
        Pstring = Pmulti_remain.GetSection().Add_string("parameters", 1, "");
        Pmulti_remain.Set_help("see serial1");
        secprop = control.AddSection_prop("dos", Dos.DOS_Init, false);
        secprop.AddInitFunction(XMS.XMS_Init, true);
        Pbool = secprop.Add_bool("xms", 1, true);
        Pbool.Set_help("Enable XMS support.");
        secprop.AddInitFunction(EMS.EMS_Init, true);
        String[] ems_settings = new String[]{"true", "emsboard", "emm386", "false"};
        Pstring = secprop.Add_string("ems", 1, "true");
        Pstring.Set_values(ems_settings);
        Pstring.Set_help("Enable EMS support. The default (=true) provides the best\ncompatibility but certain applications may run better with\nother choices, or require EMS support to be disabled (=false)\nto work at all.");
        Pbool = secprop.Add_bool("ems", 1, true);
        Pbool.Set_help("Enable EMS support.");
        Pbool = secprop.Add_bool("umb", 1, true);
        Pbool.Set_help("Enable UMB support.");
        secprop.AddInitFunction(DosKeyboardLayout.DOS_KeyboardLayout_Init, true);
        Pstring = secprop.Add_string("keyboardlayout", 1, "auto");
        Pstring.Set_help("Language code of the keyboard layout (or none).");
        secprop.AddInitFunction(DosMSCDEX.MSCDEX_Init);
        secprop.AddInitFunction(Drives.DRIVES_Init);
        secprop.AddInitFunction(CDRomImage.CDROM_Image_Init);
        secprop = control.AddSection_prop("ipx", IPX.IPX_Init, true);
        Pbool = secprop.Add_bool("ipx", 1, false);
        Pbool.Set_help("Enable ipx over UDP/IP emulation.");
        secprop = control.AddSection_prop("ne2000", NE2000.NE2000_Init, true);
        Msg.add("NE2000_CONFIGFILE_HELP", "macaddr -- The physical address the emulator will use on your network.\n           If you have multiple DOSBoxes running on your network,\n           this has to be changed. Modify the last three number blocks.\n           I.e. AC:DE:48:88:99:AB.\nrealnic -- Specifies which of your network interfaces is used.\n           Write 'list' here to see the list of devices in the\n           Status Window. Then make your choice and put either the\n           interface number (2 or something) or a part of your adapters\n           name, e.g. VIA here.\n");
        Pbool = secprop.Add_bool("ne2000", 1, true);
        Pbool.Set_help("Enable Ethernet passthrough. Requires [Win]Pcap.");
        Pbool = secprop.Add_bool("pcap", 1, false);
        Pbool.Set_help("Use pcap to access the host ethernet card.  This requires\njnetpcap.jar, the appropriate native jnetpcap libaries and [Win]Pcap\ninstalled on the host computer.");
        Pstring = secprop.Add_string("pcaphost", 1, "");
        Pstring.Set_help("When set, pcap passthrough requests will be fowarded.  This is a good optionto use when you want an unsigned applet to work with ne2000 or you just don't want to bother a client to install pcap.  With an unsigned applet, thepcaphost must be set to the same server that is hosting the applet.  Also keepin mind that pcap is bound to the server and the network will be visible tojdosbox, you may want to set up a virtual network.  To run jDosbox in pcapforward mode, just start it with a -pcap <device> -pcapport <port> where <device>is the index from the pcap list or a partial name for the device.  You can passin -pcap list to see all the devices");
        Pint = secprop.Add_int("pcapport", 1, 15654);
        Pint.Set_help("Port to connect to when forwarding pcap requests");
        Phex = secprop.Add_hex("nicbase", 1, new Hex(768));
        Phex.Set_help("The base address of the NE2000 board.");
        Pint = secprop.Add_int("nicirq", 1, 3);
        Pint.Set_help("The interrupt it uses. Note serial2 uses IRQ3 as default.");
        Pstring = secprop.Add_string("macaddr", 1, "AC:DE:48:88:99:AA");
        Pstring.Set_help("The physical address the emulator will use on your network.\nIf you have multiple DOSBoxes running on your network,\nthis has to be changed for each. AC:DE:48 is an address range reserved for\nprivate use, so modify the last three number blocks.\nI.e. AC:DE:48:88:99:AB.");
        Pstring = secprop.Add_string("realnic", 1, "list");
        Pstring.Set_help("Specifies which of your network interfaces is used.\nWrite 'list' here to see the list of devices in the\nStatus Window. Then make your choice and put either the\ninterface number (2 or something) or a part of your adapters\nname, e.g. VIA here.");
        Section_line secline = control.AddSection_line("autoexec", Shell.AUTOEXEC_Init);
        Msg.add("AUTOEXEC_CONFIGFILE_HELP", "\n#Lines in this section will be run at startup.\n#You can put your MOUNT lines here.\n");
        Msg.add("CONFIGFILE_INTRO", "# This is the configurationfile for DOSBox %s. (Please use the latest version of DOSBox)\n# Lines starting with a # are commentlines and are ignored by DOSBox.\n# They are used to (briefly) document the effect of each option.\n");
        Msg.add("CONFIG_SUGGESTED_VALUES", "Possible values");
        control.SetStartUp(Shell.SHELL_Init);
    }

    static /* synthetic */ long access$000() {
        return ticksRemain;
    }

    static /* synthetic */ long access$010() {
        return ticksRemain--;
    }

    static /* synthetic */ long access$202(long x0) {
        ticksAdded = x0;
        return ticksAdded;
    }

    static /* synthetic */ long access$200() {
        return ticksAdded;
    }

    static /* synthetic */ long access$100() {
        return ticksLast;
    }

    static {
        Normal_Loop = new LoopHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public int call() {
                while (true) lbl-1000:
                // 6 sources

                {
                    if (Pic.PIC_RunQueue()) {
                        ret = CPU.cpudecoder.call();
                        if (ret < 0) {
                            return 1;
                        }
                        if (ret <= 0) continue;
                        try {
                            ++Callback.inHandler;
                            blah = Callback.CallBack_Handlers[ret].call();
                            if (blah == 0) ** GOTO lbl-1000
                            var3_5 = blah;
                            return var3_5;
                        }
                        catch (Paging.PageFaultException e) {
                            Log.exit("This should not happen");
                        }
                        finally {
                            --Callback.inHandler;
                        }
                        continue;
                    }
                    Main.GFX_Events();
                    if (Dosbox.access$000() <= 0L) break;
                    Timer.TIMER_AddTick();
                    Dosbox.access$010();
                }
                if (Dosbox.ticksLocked) {
                    Dosbox.access$002(5L);
                    Dosbox.access$102(Main.GetTicks());
                    Dosbox.access$202(0L);
                    Dosbox.ticksDone = 0;
                    Dosbox.ticksScheduled = 0L;
                } else {
                    ticksNew = Main.GetTicks();
                    Dosbox.ticksScheduled += Dosbox.access$200();
                    if (ticksNew > Dosbox.access$100()) {
                        Dosbox.access$002(ticksNew - Dosbox.access$100());
                        Dosbox.access$102(ticksNew);
                        Dosbox.ticksDone = (int)((long)Dosbox.ticksDone + Dosbox.access$000());
                        if (Dosbox.access$000() > 20L) {
                            Dosbox.access$002(20L);
                        }
                        Dosbox.access$202(Dosbox.access$000());
                        if (CPU.CPU_CycleAutoAdjust && !CPU.CPU_SkipCycleAutoAdjust) {
                            if (Dosbox.ticksScheduled >= 250L || Dosbox.ticksDone >= 250 || Dosbox.access$200() > 15L && Dosbox.ticksScheduled >= 5L) {
                                if (Dosbox.ticksDone < 1) {
                                    Dosbox.ticksDone = 1;
                                }
                                ratio = (int)(Dosbox.ticksScheduled * (long)(CPU.CPU_CyclePercUsed * 90 * 1024 / 100 / 100) / (long)Dosbox.ticksDone);
                                new_cmax = CPU.CPU_CycleMax;
                                cproc = (long)CPU.CPU_CycleMax * Dosbox.ticksScheduled;
                                if (cproc > 0L && (ratioremoved = (double)CPU.CPU_IODelayRemoved / (double)cproc) < 1.0) {
                                    ratio = (int)((double)ratio * (1.0 - ratioremoved));
                                    if (Dosbox.ticksScheduled >= 250L && Dosbox.ticksDone < 10 && ratio > 20480) {
                                        ratio = 20480;
                                    }
                                    cmax_scaled = (long)CPU.CPU_CycleMax * (long)ratio;
                                    new_cmax = ratio <= 1024 ? (int)(cmax_scaled / 1024L) : (int)((long)(1 + (CPU.CPU_CycleMax >> 1)) + cmax_scaled / 2048L);
                                }
                                if (new_cmax < 100) {
                                    new_cmax = 100;
                                }
                                if (ratio > 10 && (ratio > 120 || Dosbox.ticksDone < 700)) {
                                    CPU.CPU_CycleMax = new_cmax;
                                    if (CPU.CPU_CycleLimit > 0 && CPU.CPU_CycleMax > CPU.CPU_CycleLimit) {
                                        CPU.CPU_CycleMax = CPU.CPU_CycleLimit;
                                    }
                                }
                                CPU.CPU_IODelayRemoved = 0;
                                Dosbox.ticksDone = 0;
                                Dosbox.ticksScheduled = 0L;
                            } else if (Dosbox.access$200() > 15L && (CPU.CPU_CycleMax /= 3) < 100) {
                                CPU.CPU_CycleMax = 100;
                            }
                        }
                    } else {
                        Dosbox.access$202(0L);
                        Main.Delay(1L);
                        Dosbox.ticksDone = (int)((long)Dosbox.ticksDone - (Main.GetTicks() - ticksNew));
                        if (Dosbox.ticksDone < 0) {
                            Dosbox.ticksDone = 0;
                        }
                    }
                }
                return 0;
            }
        };
        autoadjust = false;
        DOSBOX_UnlockSpeed = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (pressed) {
                    Log.log_msg("Fast Forward ON");
                    ticksLocked = true;
                    if (CPU.CPU_CycleAutoAdjust) {
                        autoadjust = true;
                        CPU.CPU_CycleAutoAdjust = false;
                        if ((CPU.CPU_CycleMax /= 3) < 1000) {
                            CPU.CPU_CycleMax = 1000;
                        }
                    }
                } else {
                    Log.log_msg("Fast Forward OFF");
                    ticksLocked = false;
                    if (autoadjust) {
                        autoadjust = false;
                        CPU.CPU_CycleAutoAdjust = true;
                    }
                }
            }
        };
        DOSBOX_RealInit = new Section.SectionFunction(){

            public void call(Section sec) {
                System.out.println("DOSBOX_RealInit");
                Section_prop section = (Section_prop)sec;
                ticksRemain = 0L;
                ticksLast = Main.GetTicks();
                ticksLocked = false;
                Dosbox.DOSBOX_SetLoop(Normal_Loop);
                Msg.init(section);
                Mapper.MAPPER_AddHandler(DOSBOX_UnlockSpeed, 11, 2, "speedlock", "Speedlock");
                String cmd_machine = Dosbox.control.cmdline.FindString("-machine", true);
                if (cmd_machine != null) {
                    section.HandleInputline("machine=" + cmd_machine);
                }
                String mtype = section.Get_string("machine");
                svgaCard = 0;
                machine = 5;
                Int10.int10 = new Int10.Int10Data();
                Int10.int10.vesa_nolfb = false;
                Int10.int10.vesa_oldvbe = false;
                if (mtype.equals("cga")) {
                    machine = 1;
                } else if (mtype.equals("tandy")) {
                    machine = 2;
                } else if (mtype.equals("pcjr")) {
                    machine = 3;
                } else if (mtype.equals("hercules")) {
                    machine = 0;
                } else if (mtype.equals("ega")) {
                    machine = 4;
                } else if (mtype.equals("svga_s3")) {
                    svgaCard = 1;
                } else if (mtype.equals("vesa_nolfb")) {
                    svgaCard = 1;
                    Int10.int10.vesa_nolfb = true;
                } else if (mtype.equals("vesa_oldvbe")) {
                    svgaCard = 1;
                    Int10.int10.vesa_oldvbe = true;
                } else if (mtype.equals("svga_et4000")) {
                    svgaCard = 2;
                } else if (mtype.equals("svga_et3000")) {
                    svgaCard = 3;
                } else if (mtype.equals("svga_paradise")) {
                    svgaCard = 4;
                } else if (mtype.equals("vgaonly")) {
                    svgaCard = 0;
                } else {
                    Log.exit("DOSBOX:Unknown machine type " + mtype);
                }
                VGA.VGA_Init();
            }
        };
    }

    private static interface LoopHandler {
        public int call();
    }
}

