/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.Dosbox;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core_dynamic;
import jdos.cpu.Core_full;
import jdos.cpu.Core_normal;
import jdos.cpu.Core_prefetch;
import jdos.cpu.Flags;
import jdos.cpu.Paging;
import jdos.gui.Main;
import jdos.gui.Mapper;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.setup.CommandLine;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Prop_multival;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.IntRef;

public class CPU
extends Module_base {
    public static final int CPU_AUTODETERMINE_NONE = 0;
    public static final int CPU_AUTODETERMINE_CORE = 1;
    public static final int CPU_AUTODETERMINE_CYCLES = 2;
    public static final int CPU_AUTODETERMINE_SHIFT = 2;
    public static final int CPU_AUTODETERMINE_MASK = 3;
    public static final int CPU_CYCLES_LOWER_LIMIT = 100;
    public static final int CPU_ARCHTYPE_MIXED = 255;
    public static final int CPU_ARCHTYPE_386 = 53;
    public static final int CPU_ARCHTYPE_486OLD = 64;
    public static final int CPU_ARCHTYPE_486NEW = 69;
    public static final int CPU_ARCHTYPE_PENTIUM = 80;
    public static final int CPU_INT_SOFTWARE = 1;
    public static final int CPU_INT_EXCEPTION = 2;
    public static final int CPU_INT_HAS_ERROR = 4;
    public static final int CPU_INT_NOIOPLCHECK = 8;
    public static final int EXCEPTION_UD = 6;
    public static final int EXCEPTION_TS = 10;
    public static final int EXCEPTION_NP = 11;
    public static final int EXCEPTION_SS = 12;
    public static final int EXCEPTION_GP = 13;
    public static final int EXCEPTION_PF = 14;
    public static final int CR0_PROTECTION = 1;
    public static final int CR0_MONITORPROCESSOR = 2;
    public static final int CR0_FPUEMULATION = 4;
    public static final int CR0_TASKSWITCH = 8;
    public static final int CR0_FPUPRESENT = 16;
    public static final int CR0_WRITEPROTECT = 65536;
    public static final long CR0_PAGING = 0x80000000L;
    public static final int DESC_INVALID = 0;
    public static final int DESC_286_TSS_A = 1;
    public static final int DESC_LDT = 2;
    public static final int DESC_286_TSS_B = 3;
    public static final int DESC_286_CALL_GATE = 4;
    public static final int DESC_TASK_GATE = 5;
    public static final int DESC_286_INT_GATE = 6;
    public static final int DESC_286_TRAP_GATE = 7;
    public static final int DESC_386_TSS_A = 9;
    public static final int DESC_386_TSS_B = 11;
    public static final int DESC_386_CALL_GATE = 12;
    public static final int DESC_386_INT_GATE = 14;
    public static final int DESC_386_TRAP_GATE = 15;
    public static final int DESC_DATA_EU_RO_NA = 16;
    public static final int DESC_DATA_EU_RO_A = 17;
    public static final int DESC_DATA_EU_RW_NA = 18;
    public static final int DESC_DATA_EU_RW_A = 19;
    public static final int DESC_DATA_ED_RO_NA = 20;
    public static final int DESC_DATA_ED_RO_A = 21;
    public static final int DESC_DATA_ED_RW_NA = 22;
    public static final int DESC_DATA_ED_RW_A = 23;
    public static final int DESC_CODE_N_NC_A = 24;
    public static final int DESC_CODE_N_NC_NA = 25;
    public static final int DESC_CODE_R_NC_A = 26;
    public static final int DESC_CODE_R_NC_NA = 27;
    public static final int DESC_CODE_N_C_A = 28;
    public static final int DESC_CODE_N_C_NA = 29;
    public static final int DESC_CODE_R_C_A = 30;
    public static final int DESC_CODE_R_C_NA = 31;
    private static final int TSS_16_back_offset = 0;
    private static final int TSS_16_sp0_offset = 2;
    private static final int TSS_32_back_offset = 0;
    private static final int TSS_32_esp0_offset = 4;
    private static final int TSS_32_cr3_offset = 28;
    private static final int TSS_32_eip_offset = 32;
    private static final int TSS_32_eflags_offset = 36;
    private static final int TSS_32_eax_offset = 40;
    private static final int TSS_32_ecx_offset = 44;
    private static final int TSS_32_edx_offset = 48;
    private static final int TSS_32_ebx_offset = 52;
    private static final int TSS_32_esp_offset = 56;
    private static final int TSS_32_ebp_offset = 60;
    private static final int TSS_32_esi_offset = 64;
    private static final int TSS_32_edi_offset = 68;
    private static final int TSS_32_es_offset = 72;
    private static final int TSS_32_cs_offset = 76;
    private static final int TSS_32_ss_offset = 80;
    private static final int TSS_32_ds_offset = 84;
    private static final int TSS_32_fs_offset = 88;
    private static final int TSS_32_gs_offset = 92;
    private static final int TSS_32_ldt_offset = 96;
    public static CPU_Regs regs = new CPU_Regs();
    public static CPUBlock cpu;
    public static int Segs_ESval;
    public static int Segs_CSval;
    public static int Segs_SSval;
    public static int Segs_DSval;
    public static int Segs_FSval;
    public static int Segs_GSval;
    public static int Segs_ESphys;
    public static int Segs_CSphys;
    public static int Segs_SSphys;
    public static int Segs_DSphys;
    public static int Segs_FSphys;
    public static int Segs_GSphys;
    public static int CPU_Cycles;
    public static int CPU_CycleLeft;
    public static int CPU_CycleMax;
    public static int CPU_OldCycleMax;
    public static int CPU_CyclePercUsed;
    public static int CPU_CycleLimit;
    public static int CPU_CycleUp;
    public static int CPU_CycleDown;
    public static int CPU_IODelayRemoved;
    public static CPU_Decoder cpudecoder;
    public static boolean CPU_CycleAutoAdjust;
    public static boolean CPU_SkipCycleAutoAdjust;
    public static int CPU_AutoDetermineMode;
    public static int CPU_ArchitectureType;
    public static int CPU_flag_id_toggle;
    public static int CPU_PrefetchQueueSize;
    static Descriptor desc_temp_1;
    private static final TaskStateSegment cpu_tss;
    private static final TaskStateSegment new_tss_temp;
    private static final Descriptor cs_desc_temp;
    public static int lastint;
    private static final Descriptor gate_temp_1;
    private static final Descriptor cs_desc_temp_1;
    private static final Descriptor n_ss_desc_temp_1;
    private static final IntRef n_ss_1;
    private static final IntRef n_esp_1;
    private static final IntRef o_ss_1;
    private static final Descriptor n_cs_desc_2;
    private static final Descriptor n_ss_desc_2;
    public static boolean iret;
    private static final Descriptor desc_3;
    private static final Descriptor call_4;
    private static final Descriptor n_cs_desc_4;
    private static final Descriptor n_ss_desc_4;
    private static final IntRef n_ss_sel_4;
    private static final IntRef n_esp_4;
    private static final Descriptor desc_5;
    private static final Descriptor n_ss_desc_5;
    private static final TSS_Descriptor desc_6;
    static boolean printed_cycles_auto_info;
    private static final Descriptor desc_17;
    private static final Descriptor desc_7;
    private static final Descriptor desc_9;
    private static final Descriptor desc_10;
    private static final Descriptor desc_11;
    private static final Descriptor desc_12;
    private static final Descriptor desc_13;
    private static final Descriptor desc_14;
    private static final Descriptor desc_15;
    private static final Descriptor desc_16;
    private static final CPU_Decoder HLT_Decode;
    private static final Mapper.MAPPER_Handler CPU_CycleIncrease;
    private static final Mapper.MAPPER_Handler CPU_CycleDecrease;
    private static boolean inited;
    private static CPU test;
    private static final Section.SectionFunction CPU_ShutDown;
    public static final Section.SectionFunction CPU_Init;

    public static void CPU_HW_Interrupt(int num) {
        CPU.CPU_Interrupt(num, 0, CPU_Regs.reg_eip);
    }

    public static void CPU_SW_Interrupt(int num, int oldeip) {
        CPU.CPU_Interrupt(num, 1, oldeip);
    }

    public static void CPU_SW_Interrupt_NoIOPLCheck(int num, int oldeip) {
        CPU.CPU_Interrupt(num, 9, oldeip);
    }

    public static void CPU_SetFlagsd(int word) {
        int mask = CPU.cpu.cpl != 0 ? 266197 : 294869;
        CPU.CPU_SetFlags(word, mask);
    }

    public static void CPU_SetFlagsw(int word) {
        int mask = (CPU.cpu.cpl != 0 ? 266197 : 294869) & 0xFFFF;
        CPU.CPU_SetFlags(word, mask);
    }

    public static int seg_value(int index) {
        switch (index) {
            case 0: {
                return Segs_ESval;
            }
            case 1: {
                return Segs_CSval;
            }
            case 2: {
                return Segs_SSval;
            }
            case 3: {
                return Segs_DSval;
            }
            case 4: {
                return Segs_FSval;
            }
            case 5: {
                return Segs_GSval;
            }
        }
        Log.exit("Unknown segment");
        return 0;
    }

    public static void CPU_Push16(int value) {
        int new_esp = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword - 2 & CPU.cpu.stack.mask;
        Memory.mem_writew(Segs_SSphys + (new_esp & CPU.cpu.stack.mask), value & 0xFFFF);
        CPU_Regs.reg_esp.dword = new_esp;
    }

    public static void CPU_Push32(int value) {
        int new_esp = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword - 4 & CPU.cpu.stack.mask;
        Memory.mem_writed(Segs_SSphys + (new_esp & CPU.cpu.stack.mask), value);
        CPU_Regs.reg_esp.dword = new_esp;
    }

    public static int CPU_Pop16() {
        int val = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + 2 & CPU.cpu.stack.mask;
        return val;
    }

    public static int CPU_Pop32() {
        int val = Memory.mem_readd(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + 4 & CPU.cpu.stack.mask;
        return val;
    }

    public static void CPU_SetFlags(int word, int mask) {
        CPU_Regs.flags = CPU_Regs.flags & ~(mask |= CPU_flag_id_toggle) | word & mask | 2;
        CPU.cpu.direction = 1 - ((CPU_Regs.flags & 0x400) >> 9);
    }

    private static boolean CPU_PrepareException(int which, int error) {
        CPU.cpu.exception.which = which;
        CPU.cpu.exception.error = error;
        return true;
    }

    public static boolean CPU_CLI() {
        if (CPU.cpu.pmode && (CPU_Regs.GETFLAG(131072) == 0 && CPU_Regs.GETFLAG_IOPL() < CPU.cpu.cpl || CPU_Regs.GETFLAG(131072) != 0 && CPU_Regs.GETFLAG_IOPL() < 3)) {
            return CPU.CPU_PrepareException(13, 0);
        }
        CPU_Regs.SETFLAGBIT(512, false);
        return false;
    }

    public static boolean CPU_STI() {
        if (CPU.cpu.pmode && (CPU_Regs.GETFLAG(131072) == 0 && CPU_Regs.GETFLAG_IOPL() < CPU.cpu.cpl || CPU_Regs.GETFLAG(131072) != 0 && CPU_Regs.GETFLAG_IOPL() < 3)) {
            return CPU.CPU_PrepareException(13, 0);
        }
        CPU_Regs.SETFLAGBIT(512, true);
        return false;
    }

    public static boolean CPU_POPF(boolean use32) {
        if (CPU.cpu.pmode && CPU_Regs.GETFLAG(131072) != 0 && CPU_Regs.GETFLAG(12288) != 12288) {
            return CPU.CPU_PrepareException(13, 0);
        }
        int mask = 294869;
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            mask &= 0xFFFFCFFF;
        }
        if (CPU.cpu.pmode && CPU_Regs.GETFLAG(131072) == 0 && CPU_Regs.GETFLAG_IOPL() < CPU.cpu.cpl) {
            mask &= 0xFFFFFDFF;
        }
        if (use32) {
            CPU.CPU_SetFlags(CPU.CPU_Pop32(), mask);
        } else {
            CPU.CPU_SetFlags(CPU.CPU_Pop16(), mask & 0xFFFF);
        }
        Flags.DestroyConditionFlags();
        return false;
    }

    public static boolean CPU_PUSHF(boolean use32) {
        if (CPU.cpu.pmode && CPU_Regs.GETFLAG(131072) != 0 && CPU_Regs.GETFLAG(12288) != 12288) {
            return CPU.CPU_PrepareException(13, 0);
        }
        Flags.FillFlags();
        if (use32) {
            CPU.CPU_Push32(CPU_Regs.flags & 0xFCFFFF);
        } else {
            CPU.CPU_Push16(CPU_Regs.flags);
        }
        return false;
    }

    private static void CPU_CheckSegments() {
        boolean needs_invalidation = false;
        if (!CPU.cpu.gdt.GetDescriptor(Segs_ESval, desc_temp_1)) {
            needs_invalidation = true;
        } else {
            switch (desc_temp_1.Type()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (CPU.cpu.cpl <= desc_temp_1.DPL()) break;
                    needs_invalidation = true;
                    break;
                }
            }
        }
        if (needs_invalidation) {
            CPU.CPU_SetSegGeneralES(0);
        }
        needs_invalidation = false;
        if (!CPU.cpu.gdt.GetDescriptor(Segs_DSval, desc_temp_1)) {
            needs_invalidation = true;
        } else {
            switch (desc_temp_1.Type()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (CPU.cpu.cpl <= desc_temp_1.DPL()) break;
                    needs_invalidation = true;
                    break;
                }
            }
        }
        if (needs_invalidation) {
            CPU.CPU_SetSegGeneralDS(0);
        }
        needs_invalidation = false;
        if (!CPU.cpu.gdt.GetDescriptor(Segs_FSval, desc_temp_1)) {
            needs_invalidation = true;
        } else {
            switch (desc_temp_1.Type()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (CPU.cpu.cpl <= desc_temp_1.DPL()) break;
                    needs_invalidation = true;
                    break;
                }
            }
        }
        if (needs_invalidation) {
            CPU.CPU_SetSegGeneralFS(0);
        }
        needs_invalidation = false;
        if (!CPU.cpu.gdt.GetDescriptor(Segs_GSval, desc_temp_1)) {
            needs_invalidation = true;
        } else {
            switch (desc_temp_1.Type()) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (CPU.cpu.cpl <= desc_temp_1.DPL()) break;
                    needs_invalidation = true;
                    break;
                }
            }
        }
        if (needs_invalidation) {
            CPU.CPU_SetSegGeneralGS(0);
        }
    }

    private static boolean CPU_SwitchTask(int new_tss_selector, int tstype, int old_eip) {
        int new_ldt;
        int new_gs;
        int new_fs;
        int new_ds;
        int new_ss;
        int new_cs;
        int new_es;
        int new_esi;
        int new_edi;
        int new_ebp;
        int new_esp;
        int new_ebx;
        int new_edx;
        int new_ecx;
        int new_eax;
        int new_eflags;
        int new_eip;
        int new_cr3;
        Flags.FillFlags();
        if (!new_tss_temp.SetSelector(new_tss_selector)) {
            Log.exit("Illegal TSS for switch, selector=" + Integer.toString(new_tss_selector, 16) + ", switchtype=" + Integer.toString(tstype, 16));
        }
        if (tstype == 2) {
            if (CPU.new_tss_temp.desc.IsBusy() == 0) {
                Log.exit("TSS not busy for IRET");
            }
        } else if (CPU.new_tss_temp.desc.IsBusy() != 0) {
            Log.exit("TSS busy for JMP/CALL/INT");
        }
        if (CPU.new_tss_temp.is386 != 0) {
            new_cr3 = Memory.mem_readd(CPU.new_tss_temp.base + 28);
            new_eip = Memory.mem_readd(CPU.new_tss_temp.base + 32);
            new_eflags = Memory.mem_readd(CPU.new_tss_temp.base + 36);
            new_eax = Memory.mem_readd(CPU.new_tss_temp.base + 40);
            new_ecx = Memory.mem_readd(CPU.new_tss_temp.base + 44);
            new_edx = Memory.mem_readd(CPU.new_tss_temp.base + 48);
            new_ebx = Memory.mem_readd(CPU.new_tss_temp.base + 52);
            new_esp = Memory.mem_readd(CPU.new_tss_temp.base + 56);
            new_ebp = Memory.mem_readd(CPU.new_tss_temp.base + 60);
            new_edi = Memory.mem_readd(CPU.new_tss_temp.base + 68);
            new_esi = Memory.mem_readd(CPU.new_tss_temp.base + 64);
            new_es = Memory.mem_readw(CPU.new_tss_temp.base + 72);
            new_cs = Memory.mem_readw(CPU.new_tss_temp.base + 76);
            new_ss = Memory.mem_readw(CPU.new_tss_temp.base + 80);
            new_ds = Memory.mem_readw(CPU.new_tss_temp.base + 84);
            new_fs = Memory.mem_readw(CPU.new_tss_temp.base + 88);
            new_gs = Memory.mem_readw(CPU.new_tss_temp.base + 92);
            new_ldt = Memory.mem_readw(CPU.new_tss_temp.base + 96);
        } else {
            Log.exit("286 task switch");
            new_cr3 = 0;
            new_eip = 0;
            new_eflags = 0;
            new_eax = 0;
            new_ecx = 0;
            new_edx = 0;
            new_ebx = 0;
            new_esp = 0;
            new_ebp = 0;
            new_edi = 0;
            new_esi = 0;
            new_es = 0;
            new_cs = 0;
            new_ss = 0;
            new_ds = 0;
            new_fs = 0;
            new_gs = 0;
            new_ldt = 0;
        }
        if (tstype == 0 || tstype == 2) {
            CPU.cpu_tss.desc.SetBusy(false);
            cpu_tss.SaveSelector();
        }
        int old_flags = CPU_Regs.flags;
        if (tstype == 2) {
            old_flags &= 0xFFFFBFFF;
        }
        if (CPU.cpu_tss.is386 != 0) {
            Memory.mem_writed(CPU.cpu_tss.base + 36, old_flags);
            Memory.mem_writed(CPU.cpu_tss.base + 32, old_eip);
            Memory.mem_writed(CPU.cpu_tss.base + 40, CPU_Regs.reg_eax.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 44, CPU_Regs.reg_ecx.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 48, CPU_Regs.reg_edx.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 52, CPU_Regs.reg_ebx.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 56, CPU_Regs.reg_esp.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 60, CPU_Regs.reg_ebp.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 64, CPU_Regs.reg_esi.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 68, CPU_Regs.reg_edi.dword);
            Memory.mem_writed(CPU.cpu_tss.base + 72, Segs_ESval);
            Memory.mem_writed(CPU.cpu_tss.base + 76, Segs_CSval);
            Memory.mem_writed(CPU.cpu_tss.base + 80, Segs_SSval);
            Memory.mem_writed(CPU.cpu_tss.base + 84, Segs_DSval);
            Memory.mem_writed(CPU.cpu_tss.base + 88, Segs_FSval);
            Memory.mem_writed(CPU.cpu_tss.base + 92, Segs_GSval);
        } else {
            Log.exit("286 task switch");
        }
        if (tstype == 1) {
            if (CPU.new_tss_temp.is386 != 0) {
                Memory.mem_writed(CPU.new_tss_temp.base + 0, CPU.cpu_tss.selector);
            } else {
                Memory.mem_writew(CPU.new_tss_temp.base + 0, CPU.cpu_tss.selector);
            }
            new_eflags |= 0x4000;
        }
        if (tstype == 0 || tstype == 1) {
            CPU.new_tss_temp.desc.SetBusy(true);
            new_tss_temp.SaveSelector();
        }
        if (new_tss_selector == CPU.cpu_tss.selector) {
            CPU_Regs.reg_eip = old_eip;
            new_cs = Segs_CSval;
            new_ss = Segs_SSval;
            new_ds = Segs_DSval;
            new_es = Segs_ESval;
            new_fs = Segs_FSval;
            new_gs = Segs_GSval;
        } else {
            if (Paging.paging.cr3 != new_cr3) {
                Paging.PAGING_SetDirBase(new_cr3);
            }
            if (CPU.new_tss_temp.is386 != 0) {
                CPU_Regs.reg_eip = new_eip;
                CPU.CPU_SetFlags(new_eflags, 425941);
                CPU_Regs.reg_eax.dword = new_eax;
                CPU_Regs.reg_ecx.dword = new_ecx;
                CPU_Regs.reg_edx.dword = new_edx;
                CPU_Regs.reg_ebx.dword = new_ebx;
                CPU_Regs.reg_esp.dword = new_esp;
                CPU_Regs.reg_ebp.dword = new_ebp;
                CPU_Regs.reg_edi.dword = new_edi;
                CPU_Regs.reg_esi.dword = new_esi;
            } else {
                Log.exit("286 task switch");
            }
        }
        if ((CPU_Regs.flags & 0x20000) != 0) {
            CPU_Regs.SegSet16CS(new_cs);
            CPU.cpu.code.big = false;
            CPU.CPU_SetCPL(3);
        } else {
            if (new_ldt != 0) {
                CPU.CPU_LLDT(new_ldt);
            }
            CPU.CPU_SetCPL(new_cs & 3);
            if (!CPU.cpu.gdt.GetDescriptor(new_cs, cs_desc_temp)) {
                Log.exit("Task switch with CS beyond limits");
            }
            if (CPU.cs_desc_temp.saved.seg.p() == 0) {
                Log.exit("Task switch with non present code-segment");
            }
            switch (cs_desc_temp.Type()) {
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (CPU.cpu.cpl != cs_desc_temp.DPL()) {
                        Log.exit("Task CS RPL != DPL");
                    }
                    Segs_CSphys = cs_desc_temp.GetBase();
                    CPU.cpu.code.big = cs_desc_temp.Big() > 0;
                    Segs_CSval = new_cs;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    if (CPU.cpu.cpl < cs_desc_temp.DPL()) {
                        Log.exit("Task CS RPL < DPL");
                    }
                    Segs_CSphys = cs_desc_temp.GetBase();
                    CPU.cpu.code.big = cs_desc_temp.Big() > 0;
                    Segs_CSval = new_cs;
                    break;
                }
                default: {
                    Log.exit("Task switch CS Type " + cs_desc_temp.Type());
                }
            }
        }
        CPU.CPU_SetSegGeneralES(new_es);
        CPU.CPU_SetSegGeneralSS(new_ss);
        CPU.CPU_SetSegGeneralDS(new_ds);
        CPU.CPU_SetSegGeneralFS(new_fs);
        CPU.CPU_SetSegGeneralGS(new_gs);
        if (!cpu_tss.SetSelector(new_tss_selector)) {
            // empty if block
        }
        return true;
    }

    static boolean doexception(int port) {
        CPU.cpu.mpl = 3;
        return CPU.CPU_PrepareException(13, 0);
    }

    public static boolean CPU_IO_Exception(int port, int size) {
        if (CPU.cpu.pmode && (CPU_Regs.GETFLAG_IOPL() < CPU.cpu.cpl || CPU_Regs.GETFLAG(131072) != 0)) {
            int mask;
            CPU.cpu.mpl = 0;
            if (CPU.cpu_tss.is386 == 0) {
                return CPU.doexception(port);
            }
            int bwhere = CPU.cpu_tss.base + 102;
            int ofs = Memory.mem_readw(bwhere);
            if ((long)ofs > CPU.cpu_tss.limit) {
                return CPU.doexception(port);
            }
            bwhere = CPU.cpu_tss.base + ofs + port / 8;
            int map = Memory.mem_readw(bwhere);
            if ((map & (mask = 65535 >> 16 - size << (port & 7))) != 0) {
                return CPU.doexception(port);
            }
            CPU.cpu.mpl = 3;
        }
        return false;
    }

    public static void CPU_Exception(int which) {
        CPU.CPU_Exception(which, 0);
    }

    public static void CPU_Exception(int which, int error) {
        CPU.cpu.exception.error = error;
        CPU.CPU_Interrupt(which, 2 | (which >= 8 ? 4 : 0), CPU_Regs.reg_eip);
    }

    private static void CPU_CHECK_COND(boolean cond, String msg, int exc, int sel) {
        if (cond) {
            Log.exit(msg + " " + exc + " " + sel);
        }
    }

    private static void CPU_Interrupt(int num, int type, int oldeip) {
        lastint = num;
        Flags.FillFlags();
        if (!CPU.cpu.pmode) {
            CPU.CPU_Push16(CPU_Regs.flags & 0xFFFF);
            CPU.CPU_Push16(Segs_CSval);
            CPU.CPU_Push16(oldeip & 0xFFFF);
            CPU_Regs.SETFLAGBIT(512, false);
            CPU_Regs.SETFLAGBIT(256, false);
            int base = CPU.cpu.idt.GetBase();
            CPU_Regs.reg_eip = Memory.mem_readw(base + (num << 2));
            Segs_CSval = Memory.mem_readw(base + (num << 2) + 2);
            Segs_CSphys = Segs_CSval << 4;
            CPU.cpu.code.big = false;
            return;
        }
        if ((CPU_Regs.flags & 0x20000) != 0 && (type & 1) != 0 && (type & 8) == 0 && (CPU_Regs.flags & 0x3000) != 12288) {
            CPU.CPU_Exception(13, 0);
            return;
        }
        if (!CPU.cpu.idt.GetDescriptor(num << 3, gate_temp_1)) {
            CPU.CPU_Exception(13, num * 8 + 2 + ((type & 1) != 0 ? 0 : 1));
            return;
        }
        if ((type & 1) != 0 && gate_temp_1.DPL() < CPU.cpu.cpl) {
            CPU.CPU_Exception(13, num * 8 + 2);
            return;
        }
        switch (gate_temp_1.Type()) {
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                int gate_sel = gate_temp_1.GetSelector();
                int gate_off = (int)gate_temp_1.GetOffset();
                boolean success = CPU.cpu.gdt.GetDescriptor(gate_sel, cs_desc_temp_1);
                int cs_dpl = cs_desc_temp_1.DPL();
                switch (cs_desc_temp_1.Type()) {
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        if (cs_dpl < CPU.cpu.cpl) {
                            CPU.o_ss_1.value = Segs_SSval;
                            int o_esp = CPU_Regs.reg_esp.dword;
                            cpu_tss.Get_SSx_ESPx(cs_dpl, n_ss_1, n_esp_1);
                            success = CPU.cpu.gdt.GetDescriptor(CPU.n_ss_1.value, n_ss_desc_temp_1);
                            switch (n_ss_desc_temp_1.Type()) {
                                case 18: 
                                case 19: 
                                case 22: 
                                case 23: {
                                    break;
                                }
                                default: {
                                    Log.exit("INT:Inner level:Stack segment not writable.");
                                }
                            }
                            Segs_SSphys = n_ss_desc_temp_1.GetBase();
                            Segs_SSval = CPU.n_ss_1.value;
                            if (n_ss_desc_temp_1.Big() != 0) {
                                CPU.cpu.stack.big = true;
                                CPU.cpu.stack.mask = -1;
                                CPU.cpu.stack.notmask = 0;
                                CPU_Regs.reg_esp.dword = CPU.n_esp_1.value;
                            } else {
                                CPU.cpu.stack.big = false;
                                CPU.cpu.stack.mask = 65535;
                                CPU.cpu.stack.notmask = -65536;
                                CPU_Regs.reg_esp.word(CPU.n_esp_1.value & 0xFFFF);
                            }
                            CPU.CPU_SetCPL(cs_dpl);
                            if ((gate_temp_1.Type() & 8) != 0) {
                                if ((CPU_Regs.flags & 0x20000) != 0) {
                                    CPU.CPU_Push32(Segs_GSval);
                                    CPU_Regs.SegSet16GS(0);
                                    CPU.CPU_Push32(Segs_FSval);
                                    CPU_Regs.SegSet16FS(0);
                                    CPU.CPU_Push32(Segs_DSval);
                                    CPU_Regs.SegSet16DS(0);
                                    CPU.CPU_Push32(Segs_ESval);
                                    CPU_Regs.SegSet16ES(0);
                                }
                                CPU.CPU_Push32(CPU.o_ss_1.value);
                                CPU.CPU_Push32(o_esp);
                            } else {
                                if ((CPU_Regs.flags & 0x20000) != 0) {
                                    Log.exit("V86 to 16-bit gate");
                                }
                                CPU.CPU_Push16(CPU.o_ss_1.value);
                                CPU.CPU_Push16(o_esp);
                            }
                            if ((gate_temp_1.Type() & 8) != 0) {
                                CPU.CPU_Push32(CPU_Regs.flags);
                                CPU.CPU_Push32(Segs_CSval);
                                CPU.CPU_Push32(oldeip);
                                if ((type & 4) == 0) break;
                                CPU.CPU_Push32(CPU.cpu.exception.error);
                                break;
                            }
                            CPU.CPU_Push16(CPU_Regs.flags & 0xFFFF);
                            CPU.CPU_Push16(Segs_CSval);
                            CPU.CPU_Push16(oldeip & 0xFFFF);
                            if ((type & 4) == 0) break;
                            CPU.CPU_Push16(CPU.cpu.exception.error);
                            break;
                        }
                        if (cs_dpl != CPU.cpu.cpl) {
                            Log.exit("Non-conforming intra privilege INT with DPL!=CPL");
                        }
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        if ((CPU_Regs.flags & 0x20000) != 0 && cs_dpl < CPU.cpu.cpl) {
                            Log.exit("V86 interrupt doesn't change to pl0");
                        }
                        if ((gate_temp_1.Type() & 8) != 0) {
                            CPU.CPU_Push32(CPU_Regs.flags);
                            CPU.CPU_Push32(Segs_CSval);
                            CPU.CPU_Push32(oldeip);
                            if ((type & 4) == 0) break;
                            CPU.CPU_Push32(CPU.cpu.exception.error);
                            break;
                        }
                        CPU.CPU_Push16(CPU_Regs.flags & 0xFFFF);
                        CPU.CPU_Push16(Segs_CSval);
                        CPU.CPU_Push16(oldeip & 0xFFFF);
                        if ((type & 4) == 0) break;
                        CPU.CPU_Push16(CPU.cpu.exception.error);
                        break;
                    }
                    default: {
                        Log.exit("INT:Gate Selector points to illegal descriptor with type " + Integer.toString(cs_desc_temp_1.Type(), 16));
                    }
                }
                Segs_CSval = gate_sel & 0xFFFC | CPU.cpu.cpl;
                Segs_CSphys = cs_desc_temp_1.GetBase();
                CPU.cpu.code.big = cs_desc_temp_1.Big() > 0;
                CPU_Regs.reg_eip = gate_off;
                if ((gate_temp_1.Type() & 1) == 0) {
                    CPU_Regs.SETFLAGBIT(512, false);
                }
                CPU_Regs.SETFLAGBIT(256, false);
                CPU_Regs.SETFLAGBIT(16384, false);
                CPU_Regs.SETFLAGBIT(131072, false);
                return;
            }
            case 5: {
                CPU.CPU_SwitchTask(gate_temp_1.GetSelector(), 1, oldeip);
                if ((type & 4) != 0) {
                    if (CPU.cpu_tss.is386 != 0) {
                        CPU.CPU_Push32(CPU.cpu.exception.error);
                    } else {
                        CPU.CPU_Push16(CPU.cpu.exception.error);
                    }
                }
                return;
            }
        }
        Log.exit("Illegal descriptor type " + Integer.toString(gate_temp_1.Type(), 16) + " for int " + Integer.toString(num, 16));
        throw new RuntimeException();
    }

    public static void CPU_IRET(boolean use32, int oldeip) {
        iret = true;
        if (!CPU.cpu.pmode) {
            if (use32) {
                CPU_Regs.reg_eip = CPU.CPU_Pop32();
                CPU_Regs.SegSet16CS(CPU.CPU_Pop32());
                CPU.CPU_SetFlags(CPU.CPU_Pop32(), 294869);
            } else {
                CPU_Regs.reg_eip = CPU.CPU_Pop16();
                CPU_Regs.SegSet16CS(CPU.CPU_Pop16());
                CPU.CPU_SetFlags(CPU.CPU_Pop16(), 32725);
            }
            CPU.cpu.code.big = false;
            Flags.DestroyConditionFlags();
        } else {
            int n_flags;
            int n_cs_sel;
            int tempesp;
            int n_eip;
            if ((CPU_Regs.flags & 0x20000) != 0) {
                if ((CPU_Regs.flags & 0x3000) != 12288) {
                    CPU.CPU_Exception(13, 0);
                    return;
                }
                if (use32) {
                    int new_eip = Memory.mem_readd(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
                    int tempesp2 = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + 4 & CPU.cpu.stack.mask;
                    int new_cs = Memory.mem_readd(Segs_SSphys + (tempesp2 & CPU.cpu.stack.mask));
                    tempesp2 = tempesp2 & CPU.cpu.stack.notmask | tempesp2 + 4 & CPU.cpu.stack.mask;
                    int new_flags = Memory.mem_readd(Segs_SSphys + (tempesp2 & CPU.cpu.stack.mask));
                    CPU_Regs.reg_esp.dword = tempesp2 & CPU.cpu.stack.notmask | tempesp2 + 4 & CPU.cpu.stack.mask;
                    CPU_Regs.reg_eip = new_eip;
                    CPU_Regs.SegSet16CS(new_cs & 0xFFFF);
                    CPU.CPU_SetFlags(new_flags, 282581);
                } else {
                    int new_eip = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
                    int tempesp3 = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + 2 & CPU.cpu.stack.mask;
                    int new_cs = Memory.mem_readw(Segs_SSphys + (tempesp3 & CPU.cpu.stack.mask));
                    tempesp3 = tempesp3 & CPU.cpu.stack.notmask | tempesp3 + 2 & CPU.cpu.stack.mask;
                    int new_flags = Memory.mem_readw(Segs_SSphys + (tempesp3 & CPU.cpu.stack.mask));
                    CPU_Regs.reg_esp.dword = tempesp3 & CPU.cpu.stack.notmask | tempesp3 + 2 & CPU.cpu.stack.mask;
                    CPU_Regs.reg_eip = new_eip;
                    CPU_Regs.SegSet16CS(new_cs);
                    CPU.CPU_SetFlags(new_flags, 282581);
                }
                CPU.cpu.code.big = false;
                Flags.DestroyConditionFlags();
                return;
            }
            if (CPU_Regs.GETFLAG(16384) != 0) {
                if (CPU_Regs.GETFLAG(131072) != 0) {
                    Log.exit("Pmode IRET with VM bit set");
                }
                if (CPU.cpu_tss.desc.IsBusy() == 0) {
                    Log.log(8, 2, "TASK Iret:TSS not busy");
                }
                int back_link = cpu_tss.Get_back();
                CPU.CPU_SwitchTask(back_link, 2, oldeip);
                return;
            }
            if (use32) {
                n_eip = Memory.mem_readd(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
                tempesp = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + 4 & CPU.cpu.stack.mask;
                n_cs_sel = Memory.mem_readd(Segs_SSphys + (tempesp & CPU.cpu.stack.mask)) & 0xFFFF;
                tempesp = tempesp & CPU.cpu.stack.notmask | tempesp + 4 & CPU.cpu.stack.mask;
                n_flags = Memory.mem_readd(Segs_SSphys + (tempesp & CPU.cpu.stack.mask));
                tempesp = tempesp & CPU.cpu.stack.notmask | tempesp + 4 & CPU.cpu.stack.mask;
                if ((n_flags & 0x20000) != 0 && CPU.cpu.cpl == 0) {
                    CPU_Regs.reg_esp.dword = tempesp;
                    CPU_Regs.reg_eip = n_eip & 0xFFFF;
                    int n_esp = CPU.CPU_Pop32();
                    int n_ss = CPU.CPU_Pop32() & 0xFFFF;
                    int n_es = CPU.CPU_Pop32() & 0xFFFF;
                    int n_ds = CPU.CPU_Pop32() & 0xFFFF;
                    int n_fs = CPU.CPU_Pop32() & 0xFFFF;
                    int n_gs = CPU.CPU_Pop32() & 0xFFFF;
                    CPU.CPU_SetFlags(n_flags, 425941);
                    Flags.DestroyConditionFlags();
                    CPU.CPU_SetCPL(3);
                    CPU.CPU_SetSegGeneralSS(n_ss);
                    CPU.CPU_SetSegGeneralES(n_es);
                    CPU.CPU_SetSegGeneralDS(n_ds);
                    CPU.CPU_SetSegGeneralFS(n_fs);
                    CPU.CPU_SetSegGeneralGS(n_gs);
                    CPU_Regs.reg_esp.dword = n_esp;
                    CPU.cpu.code.big = false;
                    CPU_Regs.SegSet16CS(n_cs_sel);
                    return;
                }
                if ((n_flags & 0x20000) != 0) {
                    Log.exit("IRET from pmode to v86 with CPL!=0");
                }
            } else {
                n_eip = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
                tempesp = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + 2 & CPU.cpu.stack.mask;
                n_cs_sel = Memory.mem_readw(Segs_SSphys + (tempesp & CPU.cpu.stack.mask));
                tempesp = tempesp & CPU.cpu.stack.notmask | tempesp + 2 & CPU.cpu.stack.mask;
                n_flags = Memory.mem_readw(Segs_SSphys + (tempesp & CPU.cpu.stack.mask));
                tempesp = tempesp & CPU.cpu.stack.notmask | tempesp + 2 & CPU.cpu.stack.mask;
                if (((n_flags |= CPU_Regs.flags & 0xFFFF0000) & 0x20000) != 0) {
                    Log.exit("VM Flag in 16-bit iret");
                }
            }
            int n_cs_rpl = n_cs_sel & 3;
            boolean success = CPU.cpu.gdt.GetDescriptor(n_cs_sel, n_cs_desc_2);
            switch (n_cs_desc_2.Type()) {
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    break;
                }
                default: {
                    Log.exit("IRET:Illegal descriptor type " + Integer.toString(n_cs_desc_2.Type(), 16));
                }
            }
            if (n_cs_rpl == CPU.cpu.cpl) {
                int mask;
                CPU_Regs.reg_esp.dword = tempesp;
                Segs_CSphys = n_cs_desc_2.GetBase();
                CPU.cpu.code.big = n_cs_desc_2.Big() > 0;
                Segs_CSval = n_cs_sel;
                CPU_Regs.reg_eip = n_eip;
                int n = mask = CPU.cpu.cpl != 0 ? 282581 : 294869;
                if (CPU_Regs.GETFLAG_IOPL() < CPU.cpu.cpl) {
                    mask &= 0xFFFFFDFF;
                }
                CPU.CPU_SetFlags(n_flags, mask);
                Flags.DestroyConditionFlags();
            } else {
                int mask;
                int n_ss;
                int n_esp;
                if (use32) {
                    n_esp = Memory.mem_readd(Segs_SSphys + (tempesp & CPU.cpu.stack.mask));
                    tempesp = tempesp & CPU.cpu.stack.notmask | tempesp + 4 & CPU.cpu.stack.mask;
                    n_ss = Memory.mem_readd(Segs_SSphys + (tempesp & CPU.cpu.stack.mask)) & 0xFFFF;
                } else {
                    n_esp = Memory.mem_readw(Segs_SSphys + (tempesp & CPU.cpu.stack.mask));
                    tempesp = tempesp & CPU.cpu.stack.notmask | tempesp + 2 & CPU.cpu.stack.mask;
                    n_ss = Memory.mem_readw(Segs_SSphys + (tempesp & CPU.cpu.stack.mask));
                }
                success = CPU.cpu.gdt.GetDescriptor(n_ss, n_ss_desc_2);
                switch (n_ss_desc_2.Type()) {
                    case 18: 
                    case 19: 
                    case 22: 
                    case 23: {
                        break;
                    }
                    default: {
                        Log.exit("IRET:Outer level:Stack segment not writable");
                    }
                }
                Segs_CSphys = n_cs_desc_2.GetBase();
                CPU.cpu.code.big = n_cs_desc_2.Big() > 0;
                Segs_CSval = n_cs_sel;
                int n = mask = CPU.cpu.cpl != 0 ? 282581 : 294869;
                if (CPU_Regs.GETFLAG_IOPL() < CPU.cpu.cpl) {
                    mask &= 0xFFFFFDFF;
                }
                CPU.CPU_SetFlags(n_flags, mask);
                Flags.DestroyConditionFlags();
                CPU.CPU_SetCPL(n_cs_rpl);
                CPU_Regs.reg_eip = n_eip;
                Segs_SSval = n_ss;
                Segs_SSphys = n_ss_desc_2.GetBase();
                if (n_ss_desc_2.Big() != 0) {
                    CPU.cpu.stack.big = true;
                    CPU.cpu.stack.mask = -1;
                    CPU.cpu.stack.notmask = 0;
                    CPU_Regs.reg_esp.dword = n_esp;
                } else {
                    CPU.cpu.stack.big = false;
                    CPU.cpu.stack.mask = 65535;
                    CPU.cpu.stack.notmask = -65536;
                    CPU_Regs.reg_esp.word((int)((long)n_esp & 0xFFFFL));
                }
                CPU.CPU_CheckSegments();
            }
        }
    }

    public static void CPU_JMP(boolean use32, int selector, int offset, int oldeip) {
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            CPU_Regs.reg_eip = !use32 ? offset & 0xFFFF : offset;
            CPU_Regs.SegSet16CS(selector);
            CPU.cpu.code.big = false;
        } else {
            int rpl = selector & 3;
            boolean success = CPU.cpu.gdt.GetDescriptor(selector, desc_3);
            switch (desc_3.Type()) {
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (CPU.desc_3.saved.seg.p() == 0) {
                        CPU.CPU_Exception(11, selector & 0xFFFC);
                        return;
                    }
                    Segs_CSphys = desc_3.GetBase();
                    CPU.cpu.code.big = desc_3.Big() > 0;
                    Segs_CSval = selector & 0xFFFC | CPU.cpu.cpl;
                    CPU_Regs.reg_eip = offset;
                    return;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    if (CPU.desc_3.saved.seg.p() == 0) {
                        CPU.CPU_Exception(11, selector & 0xFFFC);
                        return;
                    }
                    Segs_CSphys = desc_3.GetBase();
                    CPU.cpu.code.big = desc_3.Big() > 0;
                    Segs_CSval = selector & 0xFFFC | CPU.cpu.cpl;
                    CPU_Regs.reg_eip = offset;
                    return;
                }
                case 9: {
                    CPU.CPU_SwitchTask(selector, 0, oldeip);
                    break;
                }
                default: {
                    Log.exit("JMP Illegal descriptor type " + Integer.toString(desc_3.Type(), 16));
                }
            }
        }
    }

    public static void CPU_CALL(boolean use32, int selector, int offset, int oldeip) {
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            if (!use32) {
                CPU.CPU_Push16(Segs_CSval);
                CPU.CPU_Push16(oldeip & 0xFFFF);
                CPU_Regs.reg_eip = offset & 0xFFFF;
            } else {
                CPU.CPU_Push32(Segs_CSval);
                CPU.CPU_Push32(oldeip);
                CPU_Regs.reg_eip = offset;
            }
            CPU.cpu.code.big = false;
            CPU_Regs.SegSet16CS(selector);
        } else {
            int rpl = selector & 3;
            boolean success = CPU.cpu.gdt.GetDescriptor(selector, call_4);
            block0 : switch (call_4.Type()) {
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    if (CPU.call_4.saved.seg.p() == 0) {
                        CPU.CPU_Exception(11, selector & 0xFFFC);
                        return;
                    }
                    if (!use32) {
                        CPU.CPU_Push16(Segs_CSval);
                        CPU.CPU_Push16(oldeip);
                        CPU_Regs.reg_eip = offset & 0xFFFF;
                    } else {
                        CPU.CPU_Push32(Segs_CSval);
                        CPU.CPU_Push32(oldeip);
                        CPU_Regs.reg_eip = offset;
                    }
                    Segs_CSphys = call_4.GetBase();
                    CPU.cpu.code.big = call_4.Big() > 0;
                    Segs_CSval = selector & 0xFFFC | CPU.cpu.cpl;
                    return;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    if (CPU.call_4.saved.seg.p() == 0) {
                        CPU.CPU_Exception(11, selector & 0xFFFC);
                        return;
                    }
                    if (!use32) {
                        CPU.CPU_Push16(Segs_CSval);
                        CPU.CPU_Push16(oldeip);
                        CPU_Regs.reg_eip = offset & 0xFFFF;
                    } else {
                        CPU.CPU_Push32(Segs_CSval);
                        CPU.CPU_Push32(oldeip);
                        CPU_Regs.reg_eip = offset;
                    }
                    Segs_CSphys = call_4.GetBase();
                    CPU.cpu.code.big = call_4.Big() > 0;
                    Segs_CSval = selector & 0xFFFC | CPU.cpu.cpl;
                    return;
                }
                case 4: 
                case 12: {
                    int n_cs_sel = call_4.GetSelector();
                    success = CPU.cpu.gdt.GetDescriptor(n_cs_sel, n_cs_desc_4);
                    int n_cs_dpl = n_cs_desc_4.DPL();
                    int n_eip = (int)call_4.GetOffset();
                    switch (n_cs_desc_4.Type()) {
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: {
                            if (n_cs_dpl < CPU.cpu.cpl) {
                                cpu_tss.Get_SSx_ESPx(n_cs_dpl, n_ss_sel_4, n_esp_4);
                                success = CPU.cpu.gdt.GetDescriptor(CPU.n_ss_sel_4.value, n_ss_desc_4);
                                switch (n_ss_desc_4.Type()) {
                                    case 18: 
                                    case 19: 
                                    case 22: 
                                    case 23: {
                                        break;
                                    }
                                    default: {
                                        Log.exit("Call:Gate:SS no writable data segment");
                                    }
                                }
                                int o_esp = CPU_Regs.reg_esp.dword;
                                int o_ss = Segs_SSval;
                                int o_stack = Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask);
                                if ((CPU.call_4.saved.gate.paramcount() & 0x1F) != 0) {
                                    int i;
                                    if (call_4.Type() == 12) {
                                        for (i = (CPU.call_4.saved.gate.paramcount() & 0x1F) - 1; i >= 0; --i) {
                                            Memory.mem_readd(o_stack + i * 4);
                                        }
                                    } else {
                                        for (i = (CPU.call_4.saved.gate.paramcount() & 0x1F) - 1; i >= 0; --i) {
                                            Memory.mem_readw(o_stack + i * 2);
                                        }
                                    }
                                }
                                Segs_SSval = CPU.n_ss_sel_4.value;
                                Segs_SSphys = n_ss_desc_4.GetBase();
                                if (n_ss_desc_4.Big() != 0) {
                                    CPU.cpu.stack.big = true;
                                    CPU.cpu.stack.mask = -1;
                                    CPU.cpu.stack.notmask = 0;
                                    CPU_Regs.reg_esp.dword = CPU.n_esp_4.value;
                                } else {
                                    CPU.cpu.stack.big = false;
                                    CPU.cpu.stack.mask = 65535;
                                    CPU.cpu.stack.notmask = -65536;
                                    CPU_Regs.reg_esp.word((int)((long)CPU.n_esp_4.value & 0xFFFFL));
                                }
                                CPU.CPU_SetCPL(n_cs_desc_4.DPL());
                                int oldcs = Segs_CSval;
                                Segs_CSphys = n_cs_desc_4.GetBase();
                                Segs_CSval = n_cs_sel & 0xFFFC | CPU.cpu.cpl;
                                CPU.cpu.code.big = n_cs_desc_4.Big() > 0;
                                CPU_Regs.reg_eip = n_eip;
                                if (!use32) {
                                    CPU_Regs.reg_eip &= 0xFFFF;
                                }
                                if (call_4.Type() == 12) {
                                    CPU.CPU_Push32(o_ss);
                                    CPU.CPU_Push32(o_esp);
                                    if ((CPU.call_4.saved.gate.paramcount() & 0x1F) != 0) {
                                        for (int i = (CPU.call_4.saved.gate.paramcount() & 0x1F) - 1; i >= 0; --i) {
                                            CPU.CPU_Push32(Memory.mem_readd(o_stack + i * 4));
                                        }
                                    }
                                    CPU.CPU_Push32(oldcs);
                                    CPU.CPU_Push32(oldeip);
                                    break;
                                }
                                CPU.CPU_Push16(o_ss);
                                CPU.CPU_Push16(o_esp & 0xFFFF);
                                if ((CPU.call_4.saved.gate.paramcount() & 0x1F) != 0) {
                                    for (int i = (CPU.call_4.saved.gate.paramcount() & 0x1F) - 1; i >= 0; --i) {
                                        CPU.CPU_Push16(Memory.mem_readw(o_stack + i * 2));
                                    }
                                }
                                CPU.CPU_Push16(oldcs);
                                CPU.CPU_Push16((int)((long)oldeip & 0xFFFFL));
                                break;
                            }
                            if (n_cs_dpl > CPU.cpu.cpl) {
                                Log.exit("CALL:GATE:CS DPL>CPL");
                            }
                        }
                        case 28: 
                        case 29: 
                        case 30: 
                        case 31: {
                            if (call_4.Type() == 12) {
                                CPU.CPU_Push32(Segs_CSval);
                                CPU.CPU_Push32(oldeip);
                            } else {
                                CPU.CPU_Push16(Segs_CSval);
                                CPU.CPU_Push16((int)((long)oldeip & 0xFFFFL));
                            }
                            Segs_CSphys = n_cs_desc_4.GetBase();
                            Segs_CSval = n_cs_sel & 0xFFFC | CPU.cpu.cpl;
                            CPU.cpu.code.big = n_cs_desc_4.Big() > 0;
                            CPU_Regs.reg_eip = n_eip;
                            if (use32) break block0;
                            CPU_Regs.reg_eip &= 0xFFFF;
                            break;
                        }
                        default: {
                            Log.exit("CALL:GATE:CS no executable segment");
                            break;
                        }
                    }
                    break;
                }
                case 9: {
                    CPU.CPU_SwitchTask(selector, 1, oldeip);
                    break;
                }
                case 0: 
                case 18: {
                    CPU.CPU_Exception(13, selector & 0xFFFC);
                    return;
                }
                default: {
                    Log.exit("CALL:Descriptor type " + Integer.toString(call_4.Type(), 16) + " unsupported");
                }
            }
        }
    }

    public static void CPU_RET(boolean use32, int bytes, int oldeip) {
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            int new_cs;
            int new_ip;
            if (!use32) {
                new_ip = CPU.CPU_Pop16();
                new_cs = CPU.CPU_Pop16();
            } else {
                new_ip = CPU.CPU_Pop32();
                new_cs = CPU.CPU_Pop32() & 0xFFFF;
            }
            CPU_Regs.reg_esp.dword += bytes;
            CPU_Regs.SegSet16CS(new_cs);
            CPU_Regs.reg_eip = new_ip;
            CPU.cpu.code.big = false;
        } else {
            int selector = !use32 ? Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask) + 2) : Memory.mem_readd(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask) + 4) & 0xFFFF;
            int rpl = selector & 3;
            if (rpl < CPU.cpu.cpl) {
                CPU.CPU_Exception(13, selector & 0xFFFC);
                return;
            }
            boolean success = CPU.cpu.gdt.GetDescriptor(selector, desc_5);
            if (CPU.cpu.cpl == rpl) {
                int offset;
                switch (desc_5.Type()) {
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        int offset2;
                        if (CPU.desc_5.saved.seg.p() == 0) {
                            CPU.CPU_Exception(11, selector & 0xFFFC);
                            return;
                        }
                        if (!use32) {
                            offset2 = CPU.CPU_Pop16();
                            selector = CPU.CPU_Pop16();
                        } else {
                            offset2 = CPU.CPU_Pop32();
                            selector = CPU.CPU_Pop32() & 0xFFFF;
                        }
                        Segs_CSphys = desc_5.GetBase();
                        CPU.cpu.code.big = desc_5.Big() > 0;
                        Segs_CSval = selector;
                        CPU_Regs.reg_eip = offset2;
                        if (CPU.cpu.stack.big) {
                            CPU_Regs.reg_esp.dword += bytes;
                        } else {
                            CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() + bytes);
                        }
                        return;
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        break;
                    }
                    default: {
                        Log.exit("RET from illegal descriptor type " + Integer.toString(desc_5.Type(), 16));
                    }
                }
                if (CPU.desc_5.saved.seg.p() == 0) {
                    CPU.CPU_Exception(11, selector & 0xFFFC);
                    return;
                }
                if (!use32) {
                    offset = CPU.CPU_Pop16();
                    selector = CPU.CPU_Pop16();
                } else {
                    offset = CPU.CPU_Pop32();
                    selector = CPU.CPU_Pop32() & 0xFFFF;
                }
                Segs_CSphys = desc_5.GetBase();
                CPU.cpu.code.big = desc_5.Big() > 0;
                Segs_CSval = selector;
                CPU_Regs.reg_eip = offset;
                if (CPU.cpu.stack.big) {
                    CPU_Regs.reg_esp.dword += bytes;
                } else {
                    CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() + bytes);
                }
            } else {
                int n_ss;
                int n_esp;
                int offset;
                switch (desc_5.Type()) {
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        break;
                    }
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        break;
                    }
                    default: {
                        Log.exit("RET from illegal descriptor type " + Integer.toString(desc_5.Type(), 16));
                    }
                }
                if (use32) {
                    offset = CPU.CPU_Pop32();
                    selector = CPU.CPU_Pop32() & 0xFFFF;
                    CPU_Regs.reg_esp.dword += bytes;
                    n_esp = CPU.CPU_Pop32();
                    n_ss = CPU.CPU_Pop32() & 0xFFFF;
                } else {
                    offset = CPU.CPU_Pop16();
                    selector = CPU.CPU_Pop16();
                    CPU_Regs.reg_esp.dword += bytes;
                    n_esp = CPU.CPU_Pop16();
                    n_ss = CPU.CPU_Pop16();
                }
                boolean sucess = CPU.cpu.gdt.GetDescriptor(n_ss, n_ss_desc_5);
                switch (n_ss_desc_5.Type()) {
                    case 18: 
                    case 19: 
                    case 22: 
                    case 23: {
                        break;
                    }
                    default: {
                        Log.exit("RET:SS selector type no writable data segment");
                    }
                }
                CPU.CPU_SetCPL(rpl);
                Segs_CSphys = desc_5.GetBase();
                CPU.cpu.code.big = desc_5.Big() > 0;
                Segs_CSval = selector & 0xFFFC | CPU.cpu.cpl;
                CPU_Regs.reg_eip = offset;
                Segs_SSval = n_ss;
                Segs_SSphys = n_ss_desc_5.GetBase();
                if (n_ss_desc_5.Big() != 0) {
                    CPU.cpu.stack.big = true;
                    CPU.cpu.stack.mask = -1;
                    CPU.cpu.stack.notmask = 0;
                    CPU_Regs.reg_esp.dword = n_esp + bytes;
                } else {
                    CPU.cpu.stack.big = false;
                    CPU.cpu.stack.mask = 65535;
                    CPU.cpu.stack.notmask = -65536;
                    CPU_Regs.reg_esp.word((n_esp & 0xFFFF) + bytes);
                }
                CPU.CPU_CheckSegments();
            }
        }
    }

    public static int CPU_SLDT() {
        return CPU.cpu.gdt.SLDT();
    }

    public static void CPU_SetCPL(int newcpl) {
        if (newcpl != CPU.cpu.cpl) {
            if (Paging.paging.enabled && (CPU.cpu.cpl < 3 && newcpl == 3 || CPU.cpu.cpl == 3 && newcpl < 3)) {
                Paging.PAGING_SwitchCPL(newcpl == 3);
            }
            CPU.cpu.cpl = newcpl;
        }
    }

    public static boolean CPU_LLDT(int selector) {
        if (!CPU.cpu.gdt.LLDT(selector)) {
            Log.log(8, 2, "LLDT failed, selector=" + Integer.toString(selector, 16));
            return true;
        }
        return false;
    }

    public static int CPU_STR() {
        return CPU.cpu_tss.selector;
    }

    public static boolean CPU_LTR(int selector) {
        if ((selector & 0xFFFC) == 0) {
            cpu_tss.SetSelector(selector);
            return false;
        }
        if ((selector & 4) != 0 || !CPU.cpu.gdt.GetDescriptor(selector, desc_6)) {
            Log.log(8, 2, "LTR failed, selector=" + Integer.toString(selector, 16));
            return CPU.CPU_PrepareException(13, selector);
        }
        if (desc_6.Type() == 1 || desc_6.Type() == 9) {
            if (CPU.desc_6.saved.seg.p() == 0) {
                Log.log(8, 2, "LTR failed, selector=" + Integer.toString(selector, 16) + " (not present)");
                return CPU.CPU_PrepareException(11, selector);
            }
            if (!cpu_tss.SetSelector(selector)) {
                Log.exit("LTR failed, selector=" + Integer.toString(selector, 16));
            }
        } else {
            return CPU.CPU_PrepareException(13, selector);
        }
        CPU.cpu_tss.desc.SetBusy(true);
        cpu_tss.SaveSelector();
        return false;
    }

    public static void CPU_LGDT(int limit, int base) {
        CPU.cpu.gdt.SetLimit(limit);
        CPU.cpu.gdt.SetBase(base);
    }

    public static void CPU_LIDT(int limit, int base) {
        CPU.cpu.idt.SetLimit(limit);
        CPU.cpu.idt.SetBase(base);
    }

    public static int CPU_SGDT_base() {
        return CPU.cpu.gdt.GetBase();
    }

    public static int CPU_SGDT_limit() {
        return CPU.cpu.gdt.GetLimit();
    }

    public static int CPU_SIDT_base() {
        return CPU.cpu.idt.GetBase();
    }

    public static int CPU_SIDT_limit() {
        return CPU.cpu.idt.GetLimit();
    }

    public static void CPU_SET_CRX(int cr, int value) {
        switch (cr) {
            case 0: {
                long changed = CPU.cpu.cr0 ^ (value |= 0x10);
                if (changed == 0L) {
                    return;
                }
                if ((changed & 0x10000L) != 0L && CPU_ArchitectureType >= 64) {
                    Paging.PAGING_SetWP((value & 0x10000) != 0);
                }
                CPU.cpu.cr0 = value;
                if ((value & 1) != 0) {
                    CPU.cpu.pmode = true;
                    Paging.PAGING_Enable(((long)value & 0x80000000L) != 0L);
                    if ((CPU_AutoDetermineMode & 3) == 0) break;
                    if ((CPU_AutoDetermineMode & 2) != 0) {
                        CPU_CycleAutoAdjust = true;
                        CPU_CycleLeft = 0;
                        CPU_Cycles = 0;
                        CPU_OldCycleMax = CPU_CycleMax;
                        Main.GFX_SetTitle(CPU_CyclePercUsed, -1, false);
                        if (!printed_cycles_auto_info) {
                            printed_cycles_auto_info = true;
                            Log.log_msg("DOSBox switched to max cycles, because of the setting: cycles=auto. If the game runs too fast try a fixed cycles amount in DOSBox's options.");
                        }
                    } else {
                        Main.GFX_SetTitle(-1, -1, false);
                    }
                    if ((CPU_AutoDetermineMode & 1) != 0) {
                        Core_dynamic.CPU_Core_Dynamic_Cache_Init(true);
                        cpudecoder = Core_dynamic.CPU_Core_Dynamic_Run;
                    }
                    CPU_AutoDetermineMode <<= 2;
                    break;
                }
                CPU.cpu.pmode = false;
                if (((long)value & 0x80000000L) != 0L) {
                    Log.log_msg("Paging requested without PE=1");
                }
                Paging.PAGING_Enable(false);
                break;
            }
            case 2: {
                Paging.paging.cr2 = value;
                break;
            }
            case 3: {
                Paging.PAGING_SetDirBase(value);
                break;
            }
            default: {
                Log.log(8, 2, "Unhandled MOV CR" + cr + "," + Integer.toString(value, 16));
            }
        }
    }

    public static boolean CPU_WRITE_CRX(int cr, int value) {
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            return CPU.CPU_PrepareException(13, 0);
        }
        if (cr == 1 || cr > 4) {
            return CPU.CPU_PrepareException(6, 0);
        }
        if (CPU_ArchitectureType < 64 && cr == 4) {
            return CPU.CPU_PrepareException(6, 0);
        }
        CPU.CPU_SET_CRX(cr, value);
        return false;
    }

    public static int CPU_GET_CRX(int cr) {
        switch (cr) {
            case 0: {
                if (CPU_ArchitectureType >= 80) {
                    return CPU.cpu.cr0;
                }
                if (CPU_ArchitectureType >= 64) {
                    return CPU.cpu.cr0 & 0xE005003F;
                }
                return CPU.cpu.cr0 | 0x7FFFFFF0;
            }
            case 2: {
                return Paging.paging.cr2;
            }
            case 3: {
                return Paging.PAGING_GetDirBase() & 0xFFFFF000;
            }
        }
        Log.log(8, 2, "Unhandled MOV XXX, CR" + cr);
        return 0;
    }

    public static boolean CPU_READ_CRX(int cr, CPU_Regs.Reg retvalue) {
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            return CPU.CPU_PrepareException(13, 0);
        }
        if (cr == 1 || cr > 4) {
            return CPU.CPU_PrepareException(6, 0);
        }
        retvalue.dword = CPU.CPU_GET_CRX(cr);
        return false;
    }

    public static boolean CPU_WRITE_DRX(int dr, int value) {
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            return CPU.CPU_PrepareException(13, 0);
        }
        switch (dr) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                CPU.cpu.drx[dr] = value;
                break;
            }
            case 4: 
            case 6: {
                CPU.cpu.drx[6] = (value | 0xFFFF0FF0) & 0xFFFFEFFF;
                break;
            }
            case 5: 
            case 7: {
                if (CPU_ArchitectureType < 80) {
                    CPU.cpu.drx[7] = (value | 0x400) & 0xFFFF2FFF;
                    break;
                }
                CPU.cpu.drx[7] = value | 0x400;
                break;
            }
            default: {
                Log.log(8, 2, "Unhandled MOV DR" + dr + "," + Integer.toString(value, 16));
            }
        }
        return false;
    }

    public static boolean CPU_READ_DRX(int dr, CPU_Regs.Reg retvalue) {
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            return CPU.CPU_PrepareException(13, 0);
        }
        switch (dr) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                retvalue.dword = CPU.cpu.drx[dr];
                break;
            }
            case 4: {
                retvalue.dword = CPU.cpu.drx[6];
                break;
            }
            case 5: {
                retvalue.dword = CPU.cpu.drx[7];
                break;
            }
            default: {
                Log.log(8, 2, "Unhandled MOV XXX, DR" + dr);
                retvalue.dword = 0;
            }
        }
        return false;
    }

    public static boolean CPU_WRITE_TRX(int tr, int value) {
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            return CPU.CPU_PrepareException(13, 0);
        }
        switch (tr) {
            case 6: 
            case 7: {
                CPU.cpu.trx[tr] = value;
                return false;
            }
        }
        Log.log(8, 2, "Unhandled MOV TR" + tr + "," + Long.toString(value, 16));
        return CPU.CPU_PrepareException(6, 0);
    }

    public static boolean CPU_READ_TRX(int tr, CPU_Regs.Reg retvalue) {
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            return CPU.CPU_PrepareException(13, 0);
        }
        switch (tr) {
            case 6: 
            case 7: {
                retvalue.dword = CPU.cpu.trx[tr];
                return false;
            }
        }
        Log.log(8, 2, "Unhandled MOV XXX, TR" + tr);
        return CPU.CPU_PrepareException(6, 0);
    }

    public static int CPU_SMSW() {
        return CPU.cpu.cr0;
    }

    public static boolean CPU_LMSW(int word) {
        if (CPU.cpu.pmode && CPU.cpu.cpl > 0) {
            return CPU.CPU_PrepareException(13, 0);
        }
        word &= 0xF;
        if ((CPU.cpu.cr0 & 1) != 0) {
            word |= 1;
        }
        word = (int)((long)word | (long)CPU.cpu.cr0 & 0xFFFFFFF0L);
        CPU.CPU_SET_CRX(0, word);
        return false;
    }

    public static void CPU_ARPL(IntRef dest_sel, int src_sel) {
        Flags.FillFlags();
        if ((dest_sel.value & 3) < (src_sel & 3)) {
            dest_sel.value = (dest_sel.value & 0xFFFC) + (src_sel & 3);
            CPU_Regs.SETFLAGBIT(64, true);
        } else {
            CPU_Regs.SETFLAGBIT(64, false);
        }
    }

    public static void CPU_LAR(int selector, IntRef ar) {
        Flags.FillFlags();
        if (selector == 0) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        int rpl = selector & 3;
        if (!CPU.cpu.gdt.GetDescriptor(selector, desc_17)) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        switch (desc_17.Type()) {
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (desc_17.DPL() >= CPU.cpu.cpl && desc_17.DPL() >= rpl) break;
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
            default: {
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
        }
        ar.value = CPU.desc_17.saved.get_fill(1) & 0xFFFF00;
        CPU_Regs.SETFLAGBIT(64, true);
    }

    public static void CPU_LSL(int selector, IntRef limit) {
        Flags.FillFlags();
        if (selector == 0) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        int rpl = selector & 3;
        if (!CPU.cpu.gdt.GetDescriptor(selector, desc_7)) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        switch (desc_7.Type()) {
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                if (desc_7.DPL() >= CPU.cpu.cpl && desc_7.DPL() >= rpl) break;
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
            default: {
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
        }
        limit.value = (int)desc_7.GetLimit();
        CPU_Regs.SETFLAGBIT(64, true);
    }

    public static void CPU_VERR(int selector) {
        Flags.FillFlags();
        if (selector == 0) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        int rpl = selector & 3;
        if (!CPU.cpu.gdt.GetDescriptor(selector, desc_9)) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        switch (desc_9.Type()) {
            case 30: 
            case 31: {
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                if (desc_9.DPL() >= CPU.cpu.cpl && desc_9.DPL() >= rpl) break;
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
            default: {
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
        }
        CPU_Regs.SETFLAGBIT(64, true);
    }

    public static void CPU_VERW(int selector) {
        Flags.FillFlags();
        if (selector == 0) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        int rpl = selector & 3;
        if (!CPU.cpu.gdt.GetDescriptor(selector, desc_10)) {
            CPU_Regs.SETFLAGBIT(64, false);
            return;
        }
        switch (desc_10.Type()) {
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                if (desc_10.DPL() >= CPU.cpu.cpl && desc_10.DPL() >= rpl) break;
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
            default: {
                CPU_Regs.SETFLAGBIT(64, false);
                return;
            }
        }
        CPU_Regs.SETFLAGBIT(64, true);
    }

    public static boolean CPU_SetSegGeneralES(int value) {
        value &= 0xFFFF;
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            Segs_ESval = value;
            Segs_ESphys = value << 4;
            return false;
        }
        if ((value & 0xFFFC) == 0) {
            Segs_ESval = value;
            Segs_ESphys = 0;
            return false;
        }
        if (!CPU.cpu.gdt.GetDescriptor(value, desc_11)) {
            return CPU.CPU_PrepareException(13, value & 0xFFFC);
        }
        switch (desc_11.Type()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                if ((value & 3) <= desc_11.DPL() && CPU.cpu.cpl <= desc_11.DPL()) break;
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
            case 30: 
            case 31: {
                break;
            }
            default: {
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
        }
        if (CPU.desc_11.saved.seg.p() == 0) {
            return CPU.CPU_PrepareException(11, value & 0xFFFC);
        }
        Segs_ESval = value;
        Segs_ESphys = desc_11.GetBase();
        return false;
    }

    public static boolean CPU_SetSegGeneralCS(int value) {
        value &= 0xFFFF;
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            Segs_CSval = value;
            Segs_CSphys = value << 4;
            return false;
        }
        if ((value & 0xFFFC) == 0) {
            Segs_CSval = value;
            Segs_CSphys = 0;
            return false;
        }
        if (!CPU.cpu.gdt.GetDescriptor(value, desc_12)) {
            return CPU.CPU_PrepareException(13, value & 0xFFFC);
        }
        switch (desc_12.Type()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                if ((value & 3) <= desc_12.DPL() && CPU.cpu.cpl <= desc_12.DPL()) break;
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
            case 30: 
            case 31: {
                break;
            }
            default: {
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
        }
        if (CPU.desc_12.saved.seg.p() == 0) {
            return CPU.CPU_PrepareException(11, value & 0xFFFC);
        }
        Segs_CSval = value;
        Segs_CSphys = desc_12.GetBase();
        return false;
    }

    public static boolean CPU_SetSegGeneralDS(int value) {
        value &= 0xFFFF;
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            Segs_DSval = value;
            Segs_DSphys = value << 4;
            return false;
        }
        if ((value & 0xFFFC) == 0) {
            Segs_DSval = value;
            Segs_DSphys = 0;
            return false;
        }
        if (!CPU.cpu.gdt.GetDescriptor(value, desc_13)) {
            return CPU.CPU_PrepareException(13, value & 0xFFFC);
        }
        switch (desc_13.Type()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                if ((value & 3) <= desc_13.DPL() && CPU.cpu.cpl <= desc_13.DPL()) break;
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
            case 30: 
            case 31: {
                break;
            }
            default: {
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
        }
        if (CPU.desc_13.saved.seg.p() == 0) {
            return CPU.CPU_PrepareException(11, value & 0xFFFC);
        }
        Segs_DSval = value;
        Segs_DSphys = desc_13.GetBase();
        return false;
    }

    public static boolean CPU_SetSegGeneralFS(int value) {
        value &= 0xFFFF;
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            Segs_FSval = value;
            Segs_FSphys = value << 4;
            return false;
        }
        if ((value & 0xFFFC) == 0) {
            Segs_FSval = value;
            Segs_FSphys = 0;
            return false;
        }
        if (!CPU.cpu.gdt.GetDescriptor(value, desc_14)) {
            return CPU.CPU_PrepareException(13, value & 0xFFFC);
        }
        switch (desc_14.Type()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                if ((value & 3) <= desc_14.DPL() && CPU.cpu.cpl <= desc_14.DPL()) break;
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
            case 30: 
            case 31: {
                break;
            }
            default: {
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
        }
        if (CPU.desc_14.saved.seg.p() == 0) {
            return CPU.CPU_PrepareException(11, value & 0xFFFC);
        }
        Segs_FSval = value;
        Segs_FSphys = desc_14.GetBase();
        return false;
    }

    public static boolean CPU_SetSegGeneralGS(int value) {
        value &= 0xFFFF;
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            Segs_GSval = value;
            Segs_GSphys = value << 4;
            return false;
        }
        if ((value & 0xFFFC) == 0) {
            Segs_GSval = value;
            Segs_GSphys = 0;
            return false;
        }
        if (!CPU.cpu.gdt.GetDescriptor(value, desc_15)) {
            return CPU.CPU_PrepareException(13, value & 0xFFFC);
        }
        switch (desc_15.Type()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                if ((value & 3) <= desc_15.DPL() && CPU.cpu.cpl <= desc_15.DPL()) break;
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
            case 30: 
            case 31: {
                break;
            }
            default: {
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
        }
        if (CPU.desc_15.saved.seg.p() == 0) {
            return CPU.CPU_PrepareException(11, value & 0xFFFC);
        }
        Segs_GSval = value;
        Segs_GSphys = desc_15.GetBase();
        return false;
    }

    public static boolean CPU_SetSegGeneralSS(int value) {
        value &= 0xFFFF;
        if (!CPU.cpu.pmode || (CPU_Regs.flags & 0x20000) != 0) {
            Segs_SSval = value;
            Segs_SSphys = value << 4;
            CPU.cpu.stack.big = false;
            CPU.cpu.stack.mask = 65535;
            CPU.cpu.stack.notmask = -65536;
            return false;
        }
        if ((value & 0xFFFC) == 0) {
            Log.exit("CPU_SetSegGeneral: Stack segment zero");
        }
        if (!CPU.cpu.gdt.GetDescriptor(value, desc_16)) {
            Log.exit("CPU_SetSegGeneral: Stack segment beyond limits");
        }
        if ((value & 3) != CPU.cpu.cpl || desc_16.DPL() != CPU.cpu.cpl) {
            Log.exit("CPU_SetSegGeneral: Stack segment with invalid privileges");
        }
        switch (desc_16.Type()) {
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                return CPU.CPU_PrepareException(13, value & 0xFFFC);
            }
        }
        if (CPU.desc_16.saved.seg.p() == 0) {
            return CPU.CPU_PrepareException(12, value & 0xFFFC);
        }
        Segs_SSval = value;
        Segs_SSphys = desc_16.GetBase();
        if (desc_16.Big() != 0) {
            CPU.cpu.stack.big = true;
            CPU.cpu.stack.mask = -1;
            CPU.cpu.stack.notmask = 0;
        } else {
            CPU.cpu.stack.big = false;
            CPU.cpu.stack.mask = 65535;
            CPU.cpu.stack.notmask = -65536;
        }
        return false;
    }

    public static boolean CPU_SetSegGeneral_index(int seg, int value) {
        switch (seg) {
            case 0: {
                return CPU.CPU_SetSegGeneralES(value);
            }
            case 1: {
                return CPU.CPU_SetSegGeneralCS(value);
            }
            case 2: {
                return CPU.CPU_SetSegGeneralSS(value);
            }
            case 3: {
                return CPU.CPU_SetSegGeneralDS(value);
            }
            case 4: {
                return CPU.CPU_SetSegGeneralFS(value);
            }
            case 5: {
                return CPU.CPU_SetSegGeneralGS(value);
            }
        }
        Log.exit("Unknown segment");
        return false;
    }

    public static boolean CPU_PopSegES(boolean use32) {
        int val = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        if (CPU.CPU_SetSegGeneralES(val)) {
            return true;
        }
        int addsp = use32 ? 4 : 2;
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + addsp & CPU.cpu.stack.mask;
        return false;
    }

    public static boolean CPU_PopSegCS(boolean use32) {
        int val = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        if (CPU.CPU_SetSegGeneralCS(val)) {
            return true;
        }
        int addsp = use32 ? 4 : 2;
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + addsp & CPU.cpu.stack.mask;
        return false;
    }

    public static boolean CPU_PopSegSS(boolean use32) {
        int val = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        if (CPU.CPU_SetSegGeneralSS(val)) {
            return true;
        }
        int addsp = use32 ? 4 : 2;
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + addsp & CPU.cpu.stack.mask;
        return false;
    }

    public static boolean CPU_PopSegDS(boolean use32) {
        int val = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        if (CPU.CPU_SetSegGeneralDS(val)) {
            return true;
        }
        int addsp = use32 ? 4 : 2;
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + addsp & CPU.cpu.stack.mask;
        return false;
    }

    public static boolean CPU_PopSegFS(boolean use32) {
        int val = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        if (CPU.CPU_SetSegGeneralFS(val)) {
            return true;
        }
        int addsp = use32 ? 4 : 2;
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + addsp & CPU.cpu.stack.mask;
        return false;
    }

    public static boolean CPU_PopSegGS(boolean use32) {
        int val = Memory.mem_readw(Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
        if (CPU.CPU_SetSegGeneralGS(val)) {
            return true;
        }
        int addsp = use32 ? 4 : 2;
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | CPU_Regs.reg_esp.dword + addsp & CPU.cpu.stack.mask;
        return false;
    }

    public static boolean CPU_CPUID() {
        if (CPU_ArchitectureType < 69) {
            return false;
        }
        switch (CPU_Regs.reg_eax.dword) {
            case 0: {
                CPU_Regs.reg_eax.dword = 1;
                CPU_Regs.reg_ebx.dword = 1970169159;
                CPU_Regs.reg_edx.dword = 1231384169;
                CPU_Regs.reg_ecx.dword = 1818588270;
                break;
            }
            case 1: {
                if (CPU_ArchitectureType == 69 || CPU_ArchitectureType == 255) {
                    CPU_Regs.reg_eax.dword = 1026;
                    CPU_Regs.reg_ebx.dword = 0;
                    CPU_Regs.reg_ecx.dword = 0;
                    CPU_Regs.reg_edx.dword = 1;
                    break;
                }
                if (CPU_ArchitectureType == 80) {
                    CPU_Regs.reg_eax.dword = 1299;
                    CPU_Regs.reg_ebx.dword = 0;
                    CPU_Regs.reg_ecx.dword = 0;
                    CPU_Regs.reg_edx.dword = 17;
                    break;
                }
                return false;
            }
            default: {
                Log.log(8, 2, "Unhandled CPUID Function " + Integer.toString(CPU_Regs.reg_eax.dword, 16));
                CPU_Regs.reg_eax.dword = 0;
                CPU_Regs.reg_ebx.dword = 0;
                CPU_Regs.reg_ecx.dword = 0;
                CPU_Regs.reg_edx.dword = 0;
            }
        }
        return true;
    }

    public static void CPU_HLT(int oldeip) {
        CPU_Regs.reg_eip = oldeip;
        CPU_Cycles = 0;
        CPU.cpu.hlt.cs = Segs_CSval;
        CPU.cpu.hlt.eip = CPU_Regs.reg_eip;
        CPU.cpu.hlt.old_decoder = cpudecoder;
        cpudecoder = HLT_Decode;
    }

    public static void CPU_ENTER(boolean use32, int bytes, int level) {
        level &= 0x1F;
        int sp_index = CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask;
        int bp_index = CPU_Regs.reg_ebp.dword & CPU.cpu.stack.mask;
        if (!use32) {
            Memory.mem_writew(Segs_SSphys + (sp_index -= 2), CPU_Regs.reg_ebp.word());
            CPU_Regs.reg_ebp.word(CPU_Regs.reg_esp.dword - 2);
            if (level != 0) {
                for (int i = 1; i < level; ++i) {
                    Memory.mem_writew(Segs_SSphys + (sp_index -= 2), Memory.mem_readw(Segs_SSphys + (bp_index -= 2)));
                }
                Memory.mem_writew(Segs_SSphys + (sp_index -= 2), CPU_Regs.reg_ebp.word());
            }
        } else {
            Memory.mem_writed(Segs_SSphys + (sp_index -= 4), CPU_Regs.reg_ebp.dword);
            CPU_Regs.reg_ebp.dword = CPU_Regs.reg_esp.dword - 4;
            if (level != 0) {
                for (int i = 1; i < level; ++i) {
                    Memory.mem_writed(Segs_SSphys + (sp_index -= 4), Memory.mem_readd(Segs_SSphys + (bp_index -= 4)));
                }
                Memory.mem_writed(Segs_SSphys + (sp_index -= 4), CPU_Regs.reg_ebp.dword);
            }
        }
        CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.dword & CPU.cpu.stack.notmask | (sp_index -= bytes) & CPU.cpu.stack.mask;
    }

    void CPU_Enable_SkipAutoAdjust() {
        if (CPU_CycleAutoAdjust && (CPU_CycleMax /= 2) < 100) {
            CPU_CycleMax = 100;
        }
        CPU_SkipCycleAutoAdjust = true;
    }

    void CPU_Disable_SkipAutoAdjust() {
        CPU_SkipCycleAutoAdjust = false;
    }

    void CPU_Reset_AutoAdjust() {
        CPU_IODelayRemoved = 0;
        Dosbox.ticksDone = 0;
        Dosbox.ticksScheduled = 0L;
    }

    public static void initialize() {
        inited = false;
        cpu = new CPUBlock();
    }

    public CPU(Section configuration) {
        super(configuration);
        if (inited) {
            this.Change_Config(configuration);
            return;
        }
        inited = true;
        CPU_Regs.reg_eax.dword = 0;
        CPU_Regs.reg_ebx.dword = 0;
        CPU_Regs.reg_ecx.dword = 0;
        CPU_Regs.reg_edx.dword = 0;
        CPU_Regs.reg_edi.dword = 0;
        CPU_Regs.reg_esi.dword = 0;
        CPU_Regs.reg_ebp.dword = 0;
        CPU_Regs.reg_esp.dword = 0;
        CPU_Regs.SegSet16CS(0);
        CPU_Regs.SegSet16DS(0);
        CPU_Regs.SegSet16ES(0);
        CPU_Regs.SegSet16FS(0);
        CPU_Regs.SegSet16GS(0);
        CPU_Regs.SegSet16SS(0);
        CPU.CPU_SetFlags(512, 294869);
        CPU.cpu.cr0 = -1;
        CPU.CPU_SET_CRX(0, 0);
        CPU.cpu.code.big = false;
        CPU.cpu.stack.mask = 65535;
        CPU.cpu.stack.notmask = -65536;
        CPU.cpu.stack.big = false;
        CPU.cpu.trap_skip = false;
        CPU.cpu.idt.SetBase(0);
        CPU.cpu.idt.SetLimit(1023);
        for (int i = 0; i < 7; ++i) {
            CPU.cpu.drx[i] = 0;
            CPU.cpu.trx[i] = 0;
        }
        CPU.cpu.drx[6] = CPU_ArchitectureType == 80 ? -61456 : -57360;
        CPU.cpu.drx[7] = 1024;
        Core_normal.CPU_Core_Normal_Init();
        Core_full.CPU_Core_Full_Init();
        Core_dynamic.CPU_Core_Dynamic_Init();
        Mapper.MAPPER_AddHandler(CPU_CycleDecrease, 10, 1, "cycledown", "Dec Cycles");
        Mapper.MAPPER_AddHandler(CPU_CycleIncrease, 11, 1, "cycleup", "Inc Cycles");
        this.Change_Config(configuration);
        CPU.CPU_JMP(false, 0, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean Change_Config(Section newconfig) {
        block43: {
            String cputype;
            block53: {
                String core;
                block52: {
                    block51: {
                        block50: {
                            block49: {
                                Section_prop section;
                                block48: {
                                    block42: {
                                        CommandLine cmd;
                                        block47: {
                                            block45: {
                                                String type;
                                                block46: {
                                                    block44: {
                                                        section = (Section_prop)newconfig;
                                                        CPU_AutoDetermineMode = 0;
                                                        CPU_Cycles = 0;
                                                        CPU_SkipCycleAutoAdjust = false;
                                                        Prop_multival p = section.Get_multival("cycles");
                                                        type = p.GetSection().Get_string("type");
                                                        cmd = new CommandLine(null, p.GetSection().Get_string("parameters"));
                                                        if (!type.equals("max")) break block44;
                                                        CPU_CycleMax = 0;
                                                        CPU_CyclePercUsed = 100;
                                                        CPU_CycleAutoAdjust = true;
                                                        CPU_CycleLimit = -1;
                                                        break block45;
                                                    }
                                                    if (!type.equals("auto")) break block46;
                                                    CPU_AutoDetermineMode |= 2;
                                                    CPU_CycleMax = 3000;
                                                    CPU_OldCycleMax = 3000;
                                                    CPU_CyclePercUsed = 100;
                                                    break block47;
                                                }
                                                if (type.equals("fixed")) {
                                                    String str = cmd.FindCommand(1);
                                                    try {
                                                        CPU_CycleMax = Integer.parseInt(str);
                                                    }
                                                    catch (Exception e) {}
                                                    break block42;
                                                } else {
                                                    int rmdval = 0;
                                                    try {
                                                        rmdval = Integer.parseInt(type);
                                                        if (rmdval != 0) {
                                                            CPU_CycleMax = rmdval;
                                                        }
                                                        break block42;
                                                    }
                                                    catch (Exception e) {
                                                        // empty catch block
                                                    }
                                                }
                                                break block42;
                                            }
                                            for (int cmdnum = 1; cmdnum <= cmd.GetCount(); ++cmdnum) {
                                                String str = cmd.FindCommand(cmdnum);
                                                if (str == null) continue;
                                                if (str.endsWith("%")) {
                                                    try {
                                                        int percval = Integer.parseInt(str.substring(0, str.length() - 1));
                                                        if (percval <= 0 || percval > 105) continue;
                                                        CPU_CyclePercUsed = percval;
                                                    }
                                                    catch (Exception e) {}
                                                    continue;
                                                }
                                                if (!str.equals("limit") || (str = cmd.FindCommand(++cmdnum)) == null) continue;
                                                try {
                                                    int cyclimit = Integer.parseInt(str);
                                                    if (cyclimit <= 0) continue;
                                                    CPU_CycleLimit = cyclimit;
                                                    continue;
                                                }
                                                catch (Exception e) {
                                                    // empty catch block
                                                }
                                            }
                                            break block48;
                                        }
                                        for (int cmdnum = 0; cmdnum <= cmd.GetCount(); ++cmdnum) {
                                            String str = cmd.FindCommand(cmdnum);
                                            if (str == null) continue;
                                            if (str.endsWith("%")) {
                                                try {
                                                    int percval = Integer.parseInt(str.substring(0, str.length() - 1));
                                                    if (percval <= 0 || percval > 105) continue;
                                                    CPU_CyclePercUsed = percval;
                                                }
                                                catch (Exception e) {}
                                                continue;
                                            }
                                            if (str.equals("limit")) {
                                                if ((str = cmd.FindCommand(++cmdnum)) == null) continue;
                                                try {
                                                    int cyclimit = Integer.parseInt(str);
                                                    if (cyclimit <= 0) continue;
                                                    CPU_CycleLimit = cyclimit;
                                                }
                                                catch (Exception e) {}
                                                continue;
                                            }
                                            try {
                                                int rmdval = Integer.parseInt(str);
                                                if (rmdval <= 0) continue;
                                                CPU_CycleMax = rmdval;
                                                CPU_OldCycleMax = rmdval;
                                                continue;
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    CPU_CycleAutoAdjust = false;
                                }
                                CPU_CycleUp = section.Get_int("cycleup");
                                CPU_CycleDown = section.Get_int("cycledown");
                                core = section.Get_string("core");
                                cpudecoder = Core_normal.CPU_Core_Normal_Run;
                                if (core.equals("normal")) {
                                    cpudecoder = Core_normal.CPU_Core_Normal_Run;
                                } else if (core.equals("full")) {
                                    cpudecoder = Core_full.CPU_Core_Full_Run;
                                } else if (core.equals("auto")) {
                                    cpudecoder = Core_normal.CPU_Core_Normal_Run;
                                    CPU_AutoDetermineMode |= 1;
                                } else if (core.equals("dynamic")) {
                                    cpudecoder = Core_dynamic.CPU_Core_Dynamic_Run;
                                }
                                Core_dynamic.CPU_Core_Dynamic_Cache_Init(core.equals("dynamic"));
                                CPU_ArchitectureType = 255;
                                cputype = section.Get_string("cputype");
                                if (!cputype.equals("auto")) break block49;
                                CPU_ArchitectureType = 255;
                                break block43;
                            }
                            if (!cputype.equals("386")) break block50;
                            CPU_ArchitectureType = 53;
                            break block43;
                        }
                        if (!cputype.equals("386_prefetch")) break block51;
                        CPU_ArchitectureType = 53;
                        if (core.equals("normal")) {
                            cpudecoder = Core_prefetch.CPU_Core_Prefetch_Run;
                            CPU_PrefetchQueueSize = 16;
                            break block43;
                        } else if (core.equals("auto")) {
                            cpudecoder = Core_prefetch.CPU_Core_Prefetch_Run;
                            CPU_PrefetchQueueSize = 16;
                            CPU_AutoDetermineMode &= 0xFFFFFFFE;
                            break block43;
                        } else {
                            Log.exit("prefetch queue emulation requires the normal core setting.");
                        }
                        break block43;
                    }
                    if (!cputype.equals("486")) break block52;
                    CPU_ArchitectureType = 69;
                    break block43;
                }
                if (!cputype.equals("486_prefetch")) break block53;
                CPU_ArchitectureType = 69;
                if (core.equals("normal")) {
                    cpudecoder = Core_prefetch.CPU_Core_Prefetch_Run;
                    CPU_PrefetchQueueSize = 32;
                    break block43;
                } else if (core.equals("auto")) {
                    cpudecoder = Core_prefetch.CPU_Core_Prefetch_Run;
                    CPU_PrefetchQueueSize = 32;
                    CPU_AutoDetermineMode &= 0xFFFFFFFE;
                    break block43;
                } else {
                    Log.exit("prefetch queue emulation requires the normal core setting.");
                }
                break block43;
            }
            if (cputype.equals("pentium")) {
                CPU_ArchitectureType = 80;
            }
        }
        CPU_flag_id_toggle = CPU_ArchitectureType >= 69 ? 0x240000 : 262144;
        if (CPU_CycleMax <= 0) {
            CPU_CycleMax = 3000;
        }
        if (CPU_CycleUp <= 0) {
            CPU_CycleUp = 500;
        }
        if (CPU_CycleDown <= 0) {
            CPU_CycleDown = 20;
        }
        if (CPU_CycleAutoAdjust) {
            Main.GFX_SetTitle(CPU_CyclePercUsed, -1, false);
            return true;
        }
        Main.GFX_SetTitle(CPU_CycleMax, -1, false);
        return true;
    }

    static {
        CPU_Cycles = 0;
        CPU_CycleLeft = 3000;
        CPU_CycleMax = 3000;
        CPU_OldCycleMax = 3000;
        CPU_CyclePercUsed = 100;
        CPU_CycleLimit = -1;
        CPU_CycleUp = 0;
        CPU_CycleDown = 0;
        CPU_IODelayRemoved = 0;
        CPU_CycleAutoAdjust = false;
        CPU_SkipCycleAutoAdjust = false;
        CPU_AutoDetermineMode = 0;
        CPU_ArchitectureType = 255;
        CPU_flag_id_toggle = 0;
        CPU_PrefetchQueueSize = 0;
        desc_temp_1 = new Descriptor();
        cpu_tss = new TaskStateSegment();
        new_tss_temp = new TaskStateSegment();
        cs_desc_temp = new Descriptor();
        gate_temp_1 = new Descriptor();
        cs_desc_temp_1 = new Descriptor();
        n_ss_desc_temp_1 = new Descriptor();
        n_ss_1 = new IntRef(0);
        n_esp_1 = new IntRef(0);
        o_ss_1 = new IntRef(0);
        n_cs_desc_2 = new Descriptor();
        n_ss_desc_2 = new Descriptor();
        iret = false;
        desc_3 = new Descriptor();
        call_4 = new Descriptor();
        n_cs_desc_4 = new Descriptor();
        n_ss_desc_4 = new Descriptor();
        n_ss_sel_4 = new IntRef(0);
        n_esp_4 = new IntRef(0);
        desc_5 = new Descriptor();
        n_ss_desc_5 = new Descriptor();
        desc_6 = new TSS_Descriptor();
        printed_cycles_auto_info = false;
        desc_17 = new Descriptor();
        desc_7 = new Descriptor();
        desc_9 = new Descriptor();
        desc_10 = new Descriptor();
        desc_11 = new Descriptor();
        desc_12 = new Descriptor();
        desc_13 = new Descriptor();
        desc_14 = new Descriptor();
        desc_15 = new Descriptor();
        desc_16 = new Descriptor();
        HLT_Decode = new CPU_Decoder(){

            public int call() {
                if (CPU_Regs.reg_eip != CPU.cpu.hlt.eip || Segs_CSval != CPU.cpu.hlt.cs) {
                    cpudecoder = CPU.cpu.hlt.old_decoder;
                } else {
                    CPU_Cycles = 0;
                }
                return 0;
            }
        };
        CPU_CycleIncrease = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (!pressed) {
                    return;
                }
                if (CPU_CycleAutoAdjust) {
                    if ((CPU_CyclePercUsed += 5) > 105) {
                        CPU_CyclePercUsed = 105;
                    }
                    Log.log_msg("CPU speed: max " + CPU_CyclePercUsed + " percent.");
                    Main.GFX_SetTitle(CPU_CyclePercUsed, -1, false);
                } else {
                    int old_cycles = CPU_CycleMax;
                    CPU_CycleMax = CPU_CycleUp < 100 ? (int)((double)CPU_CycleMax * (1.0 + (double)CPU_CycleUp / 100.0)) : (CPU_CycleMax += CPU_CycleUp);
                    CPU_CycleLeft = 0;
                    CPU_Cycles = 0;
                    if (CPU_CycleMax == old_cycles) {
                        ++CPU_CycleMax;
                    }
                    if (CPU_CycleMax > 15000) {
                        Log.log_msg("CPU speed: fixed " + CPU_CycleMax + " cycles. If you need more than 20000, try core=dynamic in DOSBox's options.");
                    } else {
                        Log.log_msg("CPU speed: fixed " + CPU_CycleMax + " cycles.");
                    }
                    Main.GFX_SetTitle(CPU_CycleMax, -1, false);
                }
            }
        };
        CPU_CycleDecrease = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (!pressed) {
                    return;
                }
                if (CPU_CycleAutoAdjust) {
                    if ((CPU_CyclePercUsed -= 5) <= 0) {
                        CPU_CyclePercUsed = 1;
                    }
                    if (CPU_CyclePercUsed <= 70) {
                        Log.log_msg("CPU speed: max " + CPU_CyclePercUsed + " percent. If the game runs too fast, try a fixed cycles amount in DOSBox's options.");
                    } else {
                        Log.log_msg("CPU speed: max " + CPU_CyclePercUsed + " percent.");
                    }
                    Main.GFX_SetTitle(CPU_CyclePercUsed, -1, false);
                } else {
                    CPU_CycleMax = CPU_CycleDown < 100 ? (int)((double)CPU_CycleMax / (1.0 + (double)CPU_CycleDown / 100.0)) : (CPU_CycleMax -= CPU_CycleDown);
                    CPU_CycleLeft = 0;
                    CPU_Cycles = 0;
                    if (CPU_CycleMax <= 0) {
                        CPU_CycleMax = 1;
                    }
                    Log.log_msg("CPU speed: fixed " + CPU_CycleMax + " cycles.");
                    Main.GFX_SetTitle(CPU_CycleMax, -1, false);
                }
            }
        };
        inited = false;
        CPU_ShutDown = new Section.SectionFunction(){

            public void call(Section sec) {
                Core_dynamic.CPU_Core_Dynamic_Cache_Close();
                test = null;
            }
        };
        CPU_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new CPU(section);
                section.AddDestroyFunction(CPU_ShutDown, true);
            }
        };
    }

    static final class TSwitchType {
        public static final int TSwitch_JMP = 0;
        public static final int TSwitch_CALL_INT = 1;
        public static final int TSwitch_IRET = 2;

        TSwitchType() {
        }
    }

    private static final class TaskStateSegment {
        TSS_Descriptor desc = new TSS_Descriptor();
        int selector;
        int base;
        long limit;
        int is386;
        boolean valid = false;

        public final boolean IsValid() {
            return this.valid;
        }

        final int Get_back() {
            CPU.cpu.mpl = 0;
            int backlink = Memory.mem_readw(this.base);
            CPU.cpu.mpl = 3;
            return backlink;
        }

        final void SaveSelector() {
            CPU.cpu.gdt.SetDescriptor(this.selector, this.desc);
        }

        final void Get_SSx_ESPx(int level, IntRef _ss, IntRef _esp) {
            CPU.cpu.mpl = 0;
            if (this.is386 != 0) {
                int where = this.base + 4 + level * 8;
                _esp.value = Memory.mem_readd(where);
                _ss.value = Memory.mem_readw(where + 4);
            } else {
                int where = this.base + 2 + level * 4;
                _esp.value = Memory.mem_readw(where);
                _ss.value = Memory.mem_readw(where + 2);
            }
            CPU.cpu.mpl = 3;
        }

        final boolean SetSelector(int new_sel) {
            this.valid = false;
            if ((new_sel & 0xFFFC) == 0) {
                this.selector = 0;
                this.base = 0;
                this.limit = 0L;
                this.is386 = 1;
                return true;
            }
            if ((new_sel & 4) != 0) {
                return false;
            }
            if (!CPU.cpu.gdt.GetDescriptor(new_sel, this.desc)) {
                return false;
            }
            switch (this.desc.Type()) {
                case 1: 
                case 3: 
                case 9: 
                case 11: {
                    break;
                }
                default: {
                    return false;
                }
            }
            if (this.desc.saved.seg.p() == 0) {
                return false;
            }
            this.selector = new_sel;
            this.valid = true;
            this.base = this.desc.GetBase();
            this.limit = this.desc.GetLimit();
            this.is386 = this.desc.Is386();
            return true;
        }
    }

    public static final class CPUBlock {
        public int cpl;
        public int mpl;
        public int cr0;
        public boolean pmode;
        public final GDTDescriptorTable gdt = new GDTDescriptorTable();
        public final DescriptorTable idt = new DescriptorTable();
        public final Stack stack = new Stack();
        public final Code code = new Code();
        public final Hlt hlt = new Hlt();
        public final Exception exception = new Exception();
        public int direction;
        public boolean trap_skip;
        public final int[] drx = new int[8];
        public final int[] trx = new int[8];

        public final class Exception {
            public int which;
            public int error;
        }

        public final class Hlt {
            public int cs;
            public int eip;
            public CPU_Decoder old_decoder;
        }

        public final class Code {
            public boolean big;
        }

        public final class Stack {
            public int mask;
            public int notmask;
            public boolean big;
        }
    }

    private static final class TSS_Descriptor
    extends Descriptor {
        private TSS_Descriptor() {
        }

        public final int IsBusy() {
            return this.saved.seg.type() & 2;
        }

        public final int Is386() {
            return this.saved.seg.type() & 8;
        }

        final void SetBusy(boolean busy) {
            if (busy) {
                this.saved.setType(this.saved.getType() | 2);
            } else {
                this.saved.setType(this.saved.getType() & 0xFFFFFFFD);
            }
        }
    }

    public static class GDTDescriptorTable
    extends DescriptorTable {
        private final Descriptor desc_temp = new Descriptor();
        private int ldt_base;
        private long ldt_limit;
        private int ldt_value;

        public boolean GetDescriptor(int selector, Descriptor desc) {
            int address = selector & 0xFFFFFFF8;
            if ((selector & 4) != 0) {
                if ((long)address >= this.ldt_limit) {
                    return false;
                }
                desc.Load(this.ldt_base + address);
                return true;
            }
            if (address >= this.table_limit) {
                return false;
            }
            desc.Load(this.table_base + address);
            return true;
        }

        public boolean SetDescriptor(int selector, Descriptor desc) {
            int address = selector & 0xFFFFFFF8;
            if ((selector & 4) != 0) {
                if ((long)address >= this.ldt_limit) {
                    return false;
                }
                desc.Save(this.ldt_base + address);
                return true;
            }
            if (address >= this.table_limit) {
                return false;
            }
            desc.Save(this.table_base + address);
            return true;
        }

        public int SLDT() {
            return this.ldt_value;
        }

        public boolean LLDT(int value) {
            if ((value & 0xFFFC) == 0) {
                this.ldt_value = 0;
                this.ldt_base = 0;
                this.ldt_limit = 0L;
                return true;
            }
            if (!this.GetDescriptor(value, this.desc_temp)) {
                return !CPU.CPU_PrepareException(13, value);
            }
            if (this.desc_temp.Type() != 2) {
                return !CPU.CPU_PrepareException(13, value);
            }
            if (this.desc_temp.saved.seg.p() == 0) {
                return !CPU.CPU_PrepareException(11, value);
            }
            this.ldt_base = this.desc_temp.GetBase();
            this.ldt_limit = this.desc_temp.GetLimit();
            this.ldt_value = value;
            return true;
        }
    }

    static class DescriptorTable {
        protected int table_base;
        protected int table_limit;

        DescriptorTable() {
        }

        public final int GetBase() {
            return this.table_base;
        }

        public final int GetLimit() {
            return this.table_limit;
        }

        public final void SetBase(int _base) {
            this.table_base = _base;
        }

        public final void SetLimit(int _limit) {
            this.table_limit = _limit;
        }

        public boolean GetDescriptor(int selector, Descriptor desc) {
            if ((selector &= 0xFFFFFFF8) >= this.table_limit) {
                return false;
            }
            desc.Load(this.table_base + selector);
            return true;
        }
    }

    public static class Descriptor {
        public final Descriptor_union saved = new Descriptor_union();

        public final void Load(int address) {
            CPU.cpu.mpl = 0;
            this.saved.fill((long)Memory.mem_readd(address) & 0xFFFFFFFFL | (long)Memory.mem_readd(address + 4) << 32);
            CPU.cpu.mpl = 3;
        }

        public final void Save(int address) {
            CPU.cpu.mpl = 0;
            Memory.mem_writed(address, (int)this.saved.gate.fill);
            Memory.mem_writed(address + 4, (int)(this.saved.gate.fill >>> 32));
            CPU.cpu.mpl = 3;
        }

        public final int GetBase() {
            return this.saved.seg.base_24_31() << 24 | this.saved.seg.base_16_23() << 16 | this.saved.seg.base_0_15();
        }

        public final long GetLimit() {
            long limit = this.saved.seg.limit_16_19() << 16 | this.saved.seg.limit_0_15();
            if (this.saved.seg.g() != 0) {
                limit = limit << 12 | 0xFFFL;
            }
            return limit;
        }

        public final long GetOffset() {
            return (long)this.saved.gate.offset_16_31() << 16 | (long)this.saved.gate.offset_0_15();
        }

        public final int GetSelector() {
            return this.saved.gate.selector();
        }

        public final int Type() {
            return this.saved.seg.type();
        }

        public final int Conforming() {
            return this.saved.seg.type() & 8;
        }

        public final int DPL() {
            return this.saved.seg.dpl();
        }

        public final int Big() {
            return this.saved.seg.big();
        }

        public final class Descriptor_union {
            S_Descriptor seg = new S_Descriptor();
            G_Descriptor gate = new G_Descriptor();

            public final void setType(int type) {
                this.seg.fill &= 0xFFFFE0FFFFFFFFFFL;
                this.seg.fill |= (long)type << 40;
                this.gate.fill = this.seg.fill;
            }

            public final int getType() {
                return (int)(this.seg.fill >> 40 & 0x1FL);
            }

            public final void fill(long l) {
                this.seg.fill = l;
                this.gate.fill = l;
            }

            public final int get_fill(int index) {
                if (index == 0) {
                    return (int)this.seg.fill;
                }
                return (int)(this.seg.fill >>> 32);
            }
        }
    }

    private static class G_Descriptor {
        public long fill;

        private G_Descriptor() {
        }

        public int offset_0_15() {
            return (int)(this.fill & 0xFFFFL);
        }

        public int selector() {
            return (int)(this.fill >> 16 & 0xFFFFL);
        }

        public int paramcount() {
            return (int)(this.fill >> 32 & 0x1FL);
        }

        public int reserved() {
            return (int)(this.fill >> 37 & 7L);
        }

        public int type() {
            return (int)(this.fill >> 40 & 0x1FL);
        }

        public int dpl() {
            return (int)(this.fill >> 45 & 3L);
        }

        public int p() {
            return (int)(this.fill >> 47 & 1L);
        }

        public int offset_16_31() {
            return (int)(this.fill >> 48 & 0xFFFFL);
        }
    }

    private static class S_Descriptor {
        public static final int TYPE_OFFSET = 40;
        public long fill;

        private S_Descriptor() {
        }

        public int limit_0_15() {
            return (int)(this.fill & 0xFFFFL);
        }

        public int base_0_15() {
            return (int)(this.fill >> 16 & 0xFFFFL);
        }

        public int base_16_23() {
            return (int)(this.fill >> 32 & 0xFFL);
        }

        public int type() {
            return (int)(this.fill >> 40 & 0x1FL);
        }

        public int dpl() {
            return (int)(this.fill >> 45 & 3L);
        }

        public int p() {
            return (int)(this.fill >> 47 & 1L);
        }

        public int limit_16_19() {
            return (int)(this.fill >> 48 & 0xFL);
        }

        public int avl() {
            return (int)(this.fill >> 52 & 1L);
        }

        public int r() {
            return (int)(this.fill >> 53 & 1L);
        }

        public int big() {
            return (int)(this.fill >> 54 & 1L);
        }

        public int g() {
            return (int)(this.fill >> 55 & 1L);
        }

        public int base_24_31() {
            return (int)(this.fill >>> 56 & 0xFFL);
        }
    }

    public static interface CPU_Decoder {
        public int call();
    }
}

