/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.setup.Section;

public class Callback {
    public static int inHandler = 0;
    public static final int CB_RETN = 0;
    public static final int CB_RETF = 1;
    public static final int CB_RETF8 = 2;
    public static final int CB_IRET = 3;
    public static final int CB_IRETD = 4;
    public static final int CB_IRET_STI = 5;
    public static final int CB_IRET_EOI_PIC1 = 6;
    public static final int CB_IRQ0 = 7;
    public static final int CB_IRQ1 = 8;
    public static final int CB_IRQ9 = 9;
    public static final int CB_IRQ12 = 10;
    public static final int CB_IRQ12_RET = 11;
    public static final int CB_IRQ6_PCJR = 12;
    public static final int CB_MOUSE = 13;
    public static final int CB_INT29 = 14;
    public static final int CB_INT16 = 15;
    public static final int CB_HOOKABLE = 16;
    public static final int CB_TDE_IRET = 17;
    public static final int CB_IPXESR = 18;
    public static final int CB_IPXESR_RET = 19;
    public static final int CB_INT21 = 20;
    public static final int CB_MAX = 128;
    public static final int CB_SIZE = 32;
    public static final int CB_SEG = 61440;
    public static final int CB_SOFFSET = 4096;
    public static final int CBRET_NONE = 0;
    public static final int CBRET_STOP = 1;
    public static Handler[] CallBack_Handlers = new Handler[128];
    public static String[] CallBack_Description = new String[128];
    private static int call_stop;
    private static int call_idle;
    public static int call_priv_io;
    private static Handler illegal_handler;
    private boolean installed = false;
    private int m_callback;
    private static final int NONE = 0;
    private static final int SETUP = 1;
    private static final int SETUPAT = 2;
    private int m_type = 0;
    private VectorHandler vectorhandler = new VectorHandler();
    private static Handler default_handler;
    private static Handler stop_handler;
    public static Section.SectionFunction CALLBACK_Init;

    public static int CALLBACK_RealPointer(int callback) {
        return Memory.RealMake(61440, 4096 + callback * 32);
    }

    public static int CALLBACK_PhysPointer(int callback) {
        return Memory.PhysMake(61440, 4096 + callback * 32);
    }

    public static int CALLBACK_GetBase() {
        return 987136;
    }

    public static int CALLBACK_Allocate() {
        for (int i = 1; i < CallBack_Handlers.length; ++i) {
            if (CallBack_Handlers[i] != illegal_handler) continue;
            Callback.CallBack_Handlers[i] = null;
            return i;
        }
        Log.exit("CALLBACK:Can't allocate handler.");
        return 0;
    }

    private static void CALLBACK_DeAllocate(int in) {
        Callback.CallBack_Handlers[in] = illegal_handler;
    }

    public static void CALLBACK_Idle() {
        int oldIF = CPU_Regs.GETFLAG(512);
        CPU_Regs.SETFLAGBIT(512, true);
        int oldcs = CPU.Segs_CSval;
        int oldeip = CPU_Regs.reg_eip;
        CPU_Regs.SegSet16CS(61440);
        CPU_Regs.reg_eip = call_idle * 32;
        Dosbox.DOSBOX_RunMachine();
        CPU_Regs.reg_eip = oldeip;
        CPU_Regs.SegSet16CS(oldcs);
        CPU_Regs.SETFLAGBIT(512, oldIF != 0);
        if (!CPU.CPU_CycleAutoAdjust && CPU.CPU_Cycles > 0) {
            CPU.CPU_Cycles = 0;
        }
    }

    public static void CALLBACK_RunRealFar(int seg, int off) {
        CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() - 4);
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word(), Memory.RealOff(Callback.CALLBACK_RealPointer(call_stop)));
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 2, Memory.RealSeg(Callback.CALLBACK_RealPointer(call_stop)));
        int oldeip = CPU_Regs.reg_eip;
        int oldcs = CPU.Segs_CSval;
        CPU_Regs.reg_eip = off;
        CPU_Regs.SegSet16CS(seg);
        Dosbox.DOSBOX_RunMachine();
        CPU_Regs.reg_eip = oldeip;
        CPU_Regs.SegSet16CS(oldcs);
    }

    public static void CALLBACK_RunRealInt(int intnum) {
        int oldeip = CPU_Regs.reg_eip;
        int oldcs = CPU.Segs_CSval;
        CPU_Regs.reg_eip = 8192 + intnum * 6;
        CPU_Regs.SegSet16CS(61440);
        Dosbox.DOSBOX_RunMachine();
        CPU_Regs.reg_eip = oldeip;
        CPU_Regs.SegSet16CS(oldcs);
    }

    public static void CALLBACK_SZF(boolean val) {
        int tempf = Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4);
        tempf = val ? (tempf |= 0x40) : (tempf &= 0xFFFFFFBF);
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4, tempf);
    }

    public static void CALLBACK_SCF(boolean val) {
        int tempf = Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4);
        tempf = val ? (tempf |= 1) : (tempf &= 0xFFFFFFFE);
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4, tempf);
    }

    public static void CALLBACK_SIF(boolean val) {
        int tempf = Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4);
        tempf = val ? (tempf |= 0x200) : (tempf &= 0xFFFFFDFF);
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4, tempf);
    }

    public static void CALLBACK_SetDescription(int nr, String descr) {
        Callback.CallBack_Description[nr] = descr;
    }

    public static String CALLBACK_GetDescription(int nr) {
        if (nr >= 128) {
            return null;
        }
        return CallBack_Description[nr];
    }

    public static int CALLBACK_SetupExtra(int callback, int type, int lphysAddress) {
        return Callback.CALLBACK_SetupExtra(callback, type, lphysAddress, true);
    }

    public static int CALLBACK_SetupExtra(int callback, int type, int lphysAddress, boolean use_cb) {
        int physAddress = lphysAddress;
        if (callback >= 128) {
            return 0;
        }
        switch (type) {
            case 0: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 195);
                return use_cb ? 5 : 1;
            }
            case 1: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 203);
                return use_cb ? 5 : 1;
            }
            case 2: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 202);
                Memory.phys_writew(physAddress + 1, 8);
                return use_cb ? 7 : 3;
            }
            case 3: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 207);
                return use_cb ? 5 : 1;
            }
            case 4: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 102);
                Memory.phys_writeb(physAddress + 1, 207);
                return use_cb ? 6 : 2;
            }
            case 5: {
                Memory.phys_writeb(physAddress, 251);
                if (use_cb) {
                    Memory.phys_writeb(physAddress + 1, 254);
                    Memory.phys_writeb(physAddress + 2, 56);
                    Memory.phys_writew(physAddress + 3, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress + 1, 207);
                return use_cb ? 6 : 2;
            }
            case 6: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 80);
                Memory.phys_writeb(physAddress + 1, 176);
                Memory.phys_writeb(physAddress + 2, 32);
                Memory.phys_writeb(physAddress + 3, 230);
                Memory.phys_writeb(physAddress + 4, 32);
                Memory.phys_writeb(physAddress + 5, 88);
                Memory.phys_writeb(physAddress + 6, 207);
                return use_cb ? 11 : 7;
            }
            case 7: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 80);
                Memory.phys_writeb(physAddress + 1, 82);
                Memory.phys_writeb(physAddress + 2, 30);
                Memory.phys_writew(physAddress + 3, 7373);
                Memory.phys_writeb(physAddress + 5, 250);
                Memory.phys_writeb(physAddress + 6, 31);
                Memory.phys_writeb(physAddress + 7, 90);
                Memory.phys_writew(physAddress + 8, 8368);
                Memory.phys_writew(physAddress + 10, 8422);
                Memory.phys_writeb(physAddress + 12, 88);
                Memory.phys_writeb(physAddress + 13, 207);
                return use_cb ? 18 : 14;
            }
            case 8: {
                Memory.phys_writeb(physAddress, 80);
                Memory.phys_writew(physAddress + 1, 24804);
                Memory.phys_writew(physAddress + 3, 20404);
                Memory.phys_writeb(physAddress + 5, 249);
                Memory.phys_writew(physAddress + 6, 5581);
                if (use_cb) {
                    Memory.phys_writew(physAddress + 8, 1139);
                    Memory.phys_writeb(physAddress + 10, 254);
                    Memory.phys_writeb(physAddress + 11, 56);
                    Memory.phys_writew(physAddress + 12, callback);
                    physAddress += 6;
                }
                Memory.phys_writeb(physAddress + 8, 250);
                Memory.phys_writew(physAddress + 9, 8368);
                Memory.phys_writew(physAddress + 11, 8422);
                Memory.phys_writeb(physAddress + 13, 88);
                Memory.phys_writeb(physAddress + 14, 207);
                return use_cb ? 21 : 15;
            }
            case 9: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 80);
                Memory.phys_writew(physAddress + 1, 25008);
                Memory.phys_writew(physAddress + 3, 41190);
                Memory.phys_writew(physAddress + 5, 2765);
                Memory.phys_writeb(physAddress + 7, 250);
                Memory.phys_writeb(physAddress + 8, 88);
                Memory.phys_writeb(physAddress + 9, 207);
                return use_cb ? 14 : 10;
            }
            case 10: {
                if (!use_cb) {
                    Log.exit("int74 callback must implement a callback handler!");
                }
                Memory.phys_writeb(physAddress, 30);
                Memory.phys_writeb(physAddress + 1, 6);
                Memory.phys_writew(physAddress + 2, 24678);
                Memory.phys_writeb(physAddress + 4, 252);
                Memory.phys_writeb(physAddress + 5, 251);
                Memory.phys_writeb(physAddress + 6, 254);
                Memory.phys_writeb(physAddress + 7, 56);
                Memory.phys_writew(physAddress + 8, callback);
                return 10;
            }
            case 11: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 250);
                Memory.phys_writew(physAddress + 1, 8368);
                Memory.phys_writew(physAddress + 3, 41190);
                Memory.phys_writew(physAddress + 5, 8422);
                Memory.phys_writew(physAddress + 7, 24934);
                Memory.phys_writeb(physAddress + 9, 7);
                Memory.phys_writeb(physAddress + 10, 31);
                Memory.phys_writeb(physAddress + 11, 207);
                return use_cb ? 16 : 12;
            }
            case 12: {
                Memory.phys_writeb(physAddress, 80);
                Memory.phys_writew(physAddress + 1, 24804);
                Memory.phys_writew(physAddress + 3, 57404);
                if (use_cb) {
                    Memory.phys_writew(physAddress + 5, 1652);
                    Memory.phys_writeb(physAddress + 7, 254);
                    Memory.phys_writeb(physAddress + 8, 56);
                    Memory.phys_writew(physAddress + 9, callback);
                    physAddress += 4;
                } else {
                    Memory.phys_writew(physAddress + 5, 628);
                }
                Memory.phys_writew(physAddress + 7, 2509);
                Memory.phys_writeb(physAddress + 9, 250);
                Memory.phys_writew(physAddress + 10, 8368);
                Memory.phys_writew(physAddress + 12, 8422);
                Memory.phys_writeb(physAddress + 14, 88);
                Memory.phys_writeb(physAddress + 15, 207);
                return use_cb ? 20 : 16;
            }
            case 13: {
                Memory.phys_writew(physAddress, 2027);
                physAddress += 9;
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 207);
                return use_cb ? 14 : 10;
            }
            case 15: {
                Memory.phys_writeb(physAddress, 251);
                if (use_cb) {
                    Memory.phys_writeb(physAddress + 1, 254);
                    Memory.phys_writeb(physAddress + 2, 56);
                    Memory.phys_writew(physAddress + 3, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress + 1, 207);
                for (int i = 0; i <= 11; ++i) {
                    Memory.phys_writeb(physAddress + 2 + i, 144);
                }
                Memory.phys_writew(physAddress + 14, 60907);
                return use_cb ? 16 : 12;
            }
            case 14: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 80);
                Memory.phys_writeb(physAddress + 1, 83);
                Memory.phys_writew(physAddress + 2, 3764);
                Memory.phys_writeb(physAddress + 4, 187);
                Memory.phys_writew(physAddress + 5, 7);
                Memory.phys_writew(physAddress + 7, 4301);
                Memory.phys_writeb(physAddress + 9, 91);
                Memory.phys_writeb(physAddress + 10, 88);
                Memory.phys_writeb(physAddress + 11, 207);
                return use_cb ? 16 : 12;
            }
            case 16: {
                Memory.phys_writeb(physAddress, 235);
                Memory.phys_writeb(physAddress + 1, 3);
                Memory.phys_writeb(physAddress + 2, 144);
                Memory.phys_writeb(physAddress + 3, 144);
                Memory.phys_writeb(physAddress + 4, 144);
                if (use_cb) {
                    Memory.phys_writeb(physAddress + 5, 254);
                    Memory.phys_writeb(physAddress + 6, 56);
                    Memory.phys_writew(physAddress + 7, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress + 5, 203);
                return use_cb ? 10 : 6;
            }
            case 17: {
                if (use_cb) {
                    Memory.phys_writeb(physAddress, 254);
                    Memory.phys_writeb(physAddress + 1, 56);
                    Memory.phys_writew(physAddress + 2, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress, 80);
                Memory.phys_writeb(physAddress + 1, 184);
                Memory.phys_writew(physAddress + 2, 37371);
                Memory.phys_writew(physAddress + 4, 5581);
                Memory.phys_writeb(physAddress + 6, 250);
                Memory.phys_writew(physAddress + 7, 8368);
                Memory.phys_writew(physAddress + 9, 8422);
                Memory.phys_writeb(physAddress + 11, 88);
                Memory.phys_writeb(physAddress + 12, 207);
                return use_cb ? 17 : 13;
            }
            case 20: {
                Memory.phys_writeb(physAddress, 251);
                if (use_cb) {
                    Memory.phys_writeb(physAddress + 1, 254);
                    Memory.phys_writeb(physAddress + 2, 56);
                    Memory.phys_writew(physAddress + 3, callback);
                    physAddress += 4;
                }
                Memory.phys_writeb(physAddress + 1, 207);
                Memory.phys_writeb(physAddress + 2, 203);
                Memory.phys_writeb(physAddress + 3, 81);
                Memory.phys_writeb(physAddress + 4, 185);
                Memory.phys_writew(physAddress + 5, 320);
                Memory.phys_writew(physAddress + 7, 65250);
                Memory.phys_writeb(physAddress + 9, 89);
                Memory.phys_writeb(physAddress + 10, 207);
                return use_cb ? 15 : 11;
            }
        }
        Log.exit("CALLBACK:Setup:Illegal type " + type);
        return 0;
    }

    public static boolean CALLBACK_Setup(int callback, Handler handler2, int type, String descr) {
        if (callback >= 128) {
            return false;
        }
        Callback.CALLBACK_SetupExtra(callback, type, Callback.CALLBACK_PhysPointer(callback) + 0, handler2 != null);
        Callback.CallBack_Handlers[callback] = handler2;
        Callback.CALLBACK_SetDescription(callback, descr);
        return true;
    }

    public static int CALLBACK_Setup(int callback, Handler handler2, int type, int addr, String descr) {
        if (callback >= 128) {
            return 0;
        }
        int csize = Callback.CALLBACK_SetupExtra(callback, type, addr, handler2 != null);
        if (csize > 0) {
            Callback.CallBack_Handlers[callback] = handler2;
            Callback.CALLBACK_SetDescription(callback, descr);
        }
        return csize;
    }

    public static void CALLBACK_RemoveSetup(int callback) {
        for (int i = 0; i < 32; ++i) {
            Memory.phys_writeb(Callback.CALLBACK_PhysPointer(callback) + i, 0);
        }
    }

    public int Get_callback() {
        return this.m_callback;
    }

    public int Get_RealPointer() {
        return Callback.CALLBACK_RealPointer(this.m_callback);
    }

    public void destroy() {
        if (!this.installed) {
            return;
        }
        if (this.m_type == 1) {
            if (this.vectorhandler.installed) {
                if (Memory.RealGetVec(this.vectorhandler.interrupt) == this.Get_RealPointer()) {
                    Memory.RealSetVec(this.vectorhandler.interrupt, this.vectorhandler.old_vector);
                } else {
                    Log.log(21, 1, "Interrupt vector changed on " + Integer.toString(this.vectorhandler.interrupt, 16) + " " + Callback.CALLBACK_GetDescription(this.m_callback));
                }
            }
            Callback.CALLBACK_RemoveSetup(this.m_callback);
        } else if (this.m_type == 2) {
            Log.exit("Callback:SETUP at not handled yet.");
        } else if (this.m_type != 0) {
            Log.exit("what kind of callback is this!");
        }
        Callback.CallBack_Description[this.m_callback] = null;
        Callback.CALLBACK_DeAllocate(this.m_callback);
    }

    public void Install(Handler handler2, int type, String description) {
        if (!this.installed) {
            this.installed = true;
            this.m_type = 1;
            this.m_callback = Callback.CALLBACK_Allocate();
            Callback.CALLBACK_Setup(this.m_callback, handler2, type, description);
        } else {
            Log.exit("Allready installed");
        }
    }

    public void Install(Handler handler2, int type, int addr, String description) {
        if (!this.installed) {
            this.installed = true;
            this.m_type = 1;
            this.m_callback = Callback.CALLBACK_Allocate();
            Callback.CALLBACK_Setup(this.m_callback, handler2, type, addr, description);
        } else {
            Log.exit("Allready installed");
        }
    }

    public void Allocate(Handler handler2, String description) {
        if (!this.installed) {
            this.installed = true;
            this.m_type = 0;
            this.m_callback = Callback.CALLBACK_Allocate();
            Callback.CALLBACK_SetDescription(this.m_callback, description);
            Callback.CallBack_Handlers[this.m_callback] = handler2;
        } else {
            Log.exit("Allready installed");
        }
    }

    public void Set_RealVec(int vec) {
        if (!this.vectorhandler.installed) {
            this.vectorhandler.installed = true;
            this.vectorhandler.interrupt = (short)vec;
            this.vectorhandler.old_vector = Memory.RealSetVec2(vec, this.Get_RealPointer());
        } else {
            Log.exit("double usage of vector handler");
        }
    }

    static {
        illegal_handler = new Handler(){

            public int call() {
                Log.exit("Illegal CallBack Called");
                return 1;
            }

            public String getName() {
                return "Callback.illegal_handler";
            }
        };
        default_handler = new Handler(){

            public int call() {
                Log.log(8, 2, "Illegal Unhandled Interrupt Called " + Integer.toString(CPU.lastint, 16));
                return 0;
            }

            public String getName() {
                return "Callback.default_handler";
            }
        };
        stop_handler = new Handler(){

            public int call() {
                return 1;
            }

            public String getName() {
                return "Callback.stop_handler";
            }
        };
        CALLBACK_Init = new Section.SectionFunction(){

            public void call(Section section) {
                int ct;
                int i;
                for (i = 0; i < 128; ++i) {
                    Callback.CallBack_Handlers[i] = illegal_handler;
                }
                call_stop = Callback.CALLBACK_Allocate();
                Callback.CallBack_Handlers[call_stop] = stop_handler;
                Callback.CALLBACK_SetDescription(call_stop, "stop");
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_stop), 254);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_stop) + 1, 56);
                Memory.phys_writew(Callback.CALLBACK_PhysPointer(call_stop) + 2, call_stop);
                call_idle = Callback.CALLBACK_Allocate();
                Callback.CallBack_Handlers[call_idle] = stop_handler;
                Callback.CALLBACK_SetDescription(call_idle, "idle");
                for (i = 0; i <= 11; ++i) {
                    Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_idle) + i, 144);
                }
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_idle) + 12, 254);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_idle) + 13, 56);
                Memory.phys_writew(Callback.CALLBACK_PhysPointer(call_idle) + 14, call_idle);
                int call_default = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(call_default, default_handler, 3, "default");
                int call_default2 = Callback.CALLBACK_Allocate();
                Callback.CALLBACK_Setup(call_default2, default_handler, 3, "default");
                for (ct = 0; ct < 96; ++ct) {
                    Memory.real_writed(0, ct * 4, Callback.CALLBACK_RealPointer(call_default));
                }
                for (ct = 104; ct < 112; ++ct) {
                    Memory.real_writed(0, ct * 4, Callback.CALLBACK_RealPointer(call_default));
                }
                int rint_base = Callback.CALLBACK_GetBase() + 4096;
                for (i = 0; i <= 255; ++i) {
                    Memory.phys_writeb(rint_base, 205);
                    Memory.phys_writeb(rint_base + 1, i);
                    Memory.phys_writeb(rint_base + 2, 254);
                    Memory.phys_writeb(rint_base + 3, 56);
                    Memory.phys_writew(rint_base + 4, call_stop);
                    rint_base += 6;
                }
                Memory.real_writed(0, 56, Callback.CALLBACK_RealPointer(call_default2));
                Memory.real_writed(0, 408, Callback.CALLBACK_RealPointer(call_default));
                Memory.real_writed(0, 412, Callback.CALLBACK_RealPointer(call_default));
                Memory.real_writed(0, 416, Callback.CALLBACK_RealPointer(call_default));
                Memory.real_writed(0, 368, Callback.CALLBACK_RealPointer(call_default));
                call_priv_io = Callback.CALLBACK_Allocate();
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 0, 236);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 1, 203);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 2, 237);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 3, 203);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 4, 102);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 5, 237);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 6, 203);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 8, 238);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 9, 203);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 10, 239);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 11, 203);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 12, 102);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 13, 239);
                Memory.phys_writeb(Callback.CALLBACK_PhysPointer(call_priv_io) + 14, 203);
            }
        };
    }

    private class VectorHandler {
        int old_vector;
        short interrupt;
        boolean installed = false;

        private VectorHandler() {
        }
    }

    public static interface Handler {
        public int call();

        public String getName();
    }
}

