/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.cpu.Core_dynamic;
import jdos.cpu.Core_full;
import jdos.cpu.Flags;
import jdos.cpu.LazyFlags;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.util.IntRef;

public class Paging
extends Module_base {
    public static final int MEM_PAGE_SIZE = 4096;
    public static final int XMS_START = 272;
    public static final int PFLAG_READABLE = 1;
    public static final int PFLAG_WRITEABLE = 2;
    public static final int PFLAG_HASROM = 4;
    public static final int PFLAG_HASCODE = 8;
    public static final int PFLAG_NOCODE = 16;
    public static final int PFLAG_INIT = 32;
    public static final int PAGING_LINKS = 32768;
    public static final int TLB_SIZE = 0x100000;
    public static final int BANK_SHIFT = 28;
    public static final int BANK_MASK = 65535;
    public static final int TLB_BANKS = 0x100000 / TLB_SIZE - 1;
    public static final int LINK_START = 272;
    public static final int INVALID_ADDRESS = -1;
    private static final int LINK_TOTAL = 65536;
    public static PagingBlock paging;
    private static final int PF_QUEUESIZE = 16;
    private static Pf_queue pf_queue;
    private static CPU.CPU_Decoder PageFaultCore;
    private static final int ACCESS_KR = 0;
    private static final int ACCESS_KRW = 1;
    private static final int ACCESS_UR = 2;
    private static final int ACCESS_URW = 3;
    private static final int ACCESS_TABLEFAULT = 4;
    private static final String[] mtr;
    private static final int[] translate_array;
    private static final int ACMAP_RW = 0;
    private static final int ACMAP_RE = 1;
    private static final int ACMAP_EE = 2;
    private static final String[] lnm;
    private static final int[] xlat_mapping;
    private static final int[] fault_table;
    private static final int PHYSPAGE_DITRY = 0x10000000;
    private static final int PHYSPAGE_ADDR = 1048575;
    public static boolean pageFault;
    static NewInitPageHandler init_page_handler;
    static ExceptionPageHandler exception_handler;
    static PageFoilHandler foiling_handler;
    private static Paging test;
    public static Section.SectionFunction PAGING_ShutDown;
    public static Section.SectionFunction PAGING_Init;

    private static int get_tlb_read(int address) {
        return Paging.paging.tlb.read[address >>> 12];
    }

    private static int get_tlb_write(int address) {
        return Paging.paging.tlb.write[address >>> 12];
    }

    public static PageHandler get_tlb_readhandler(int address) {
        return Paging.paging.tlb.readhandler[address >>> 12];
    }

    private static PageHandler get_tlb_writehandler(int address) {
        return Paging.paging.tlb.writehandler[address >>> 12];
    }

    public static int PAGING_GetPhysicalPage(int linePage) {
        return Paging.paging.tlb.phys_page[linePage >>> 12] << 12;
    }

    public static int PAGING_GetPhysicalAddress(int linAddr) {
        return Paging.paging.tlb.phys_page[linAddr >>> 12] << 12 | linAddr & 0xFFF;
    }

    public static int getDirectIndex(int address) {
        int tlb_addr = Paging.get_tlb_read(address);
        if (tlb_addr != -1) {
            tlb_addr = Paging.get_tlb_write(address);
            if (tlb_addr == -1) {
                return -1;
            }
            if ((Paging.get_tlb_writehandler((int)address).flags & 8) != 0) {
                return -1;
            }
        }
        if (tlb_addr != -1) {
            return tlb_addr + address;
        }
        Paging.get_tlb_readhandler(address).readb(address);
        tlb_addr = Paging.get_tlb_read(address);
        if (tlb_addr == -1) {
            return -1;
        }
        tlb_addr = Paging.get_tlb_write(address);
        if (tlb_addr == -1) {
            return -1;
        }
        if ((Paging.get_tlb_writehandler((int)address).flags & 8) != 0) {
            return -1;
        }
        return tlb_addr + address;
    }

    public static int getDirectIndexRO(int address) {
        int tlb_addr = Paging.get_tlb_read(address);
        if (tlb_addr != -1) {
            return tlb_addr + address;
        }
        Paging.get_tlb_readhandler(address).readb(address);
        tlb_addr = Paging.get_tlb_read(address);
        if (tlb_addr == -1) {
            return -1;
        }
        return tlb_addr + address;
    }

    public static short mem_readb_inline(int address) {
        int tlb_addr = Paging.get_tlb_read(address);
        if (tlb_addr != -1) {
            return Memory.host_readb(tlb_addr + address);
        }
        return (short)Paging.get_tlb_readhandler(address).readb(address);
    }

    public static int mem_readw_inline(int address) {
        if ((address & 0xFFF) < 4095) {
            int tlb_addr = Paging.get_tlb_read(address);
            if (tlb_addr != -1) {
                return Memory.host_readw(tlb_addr + address);
            }
            return Paging.get_tlb_readhandler(address).readw(address);
        }
        return Memory.mem_unalignedreadw(address);
    }

    public static int mem_readd_inline(int address) {
        if ((address & 0xFFF) < 4093) {
            int tlb_addr = Paging.get_tlb_read(address);
            if (tlb_addr != -1) {
                return Memory.host_readd(tlb_addr + address);
            }
            return Paging.get_tlb_readhandler(address).readd(address);
        }
        return Memory.mem_unalignedreadd(address);
    }

    public static void mem_writeb_inline(int address, short val) {
        int tlb_addr = Paging.get_tlb_write(address);
        if (tlb_addr != -1) {
            Memory.host_writeb(tlb_addr + address, val);
        } else {
            Paging.get_tlb_writehandler(address).writeb(address, val);
        }
    }

    public static void mem_writew_inline(int address, int val) {
        if ((address & 0xFFF) < 4095) {
            int tlb_addr = Paging.get_tlb_write(address);
            if (tlb_addr != -1) {
                Memory.host_writew(tlb_addr + address, val);
            } else {
                Paging.get_tlb_writehandler(address).writew(address, val);
            }
        } else {
            Memory.mem_unalignedwritew(address, val);
        }
    }

    public static void mem_writed_inline(int address, int val) {
        if ((address & 0xFFF) < 4093) {
            int tlb_addr = Paging.get_tlb_write(address);
            if (tlb_addr != -1) {
                Memory.host_writed(tlb_addr + address, val);
            } else {
                Paging.get_tlb_writehandler(address).writed(address, val);
            }
        } else {
            Memory.mem_unalignedwrited(address, val);
        }
    }

    private static boolean USERWRITE_PROHIBITED() {
        return (CPU.cpu.cpl & CPU.cpu.mpl) == 3;
    }

    private static int GetPageDirectoryEntryAddr(int lin_addr) {
        return Paging.paging.base.addr | lin_addr >>> 22 << 2;
    }

    private static int GetPageTableEntryAddr(int lin_addr, X86PageEntry dir_entry) {
        return dir_entry.block.base << 12 | lin_addr >>> 10 & 0xFFC;
    }

    static void PAGING_NewPageFault(int lin_addr, int page_addr, boolean prepare_only, int faultcode) {
        Paging.paging.cr2 = lin_addr;
        if (pageFault) {
            Log.exit("Double PageFault");
        }
        if (prepare_only) {
            CPU.cpu.exception.which = 14;
            CPU.cpu.exception.error = faultcode;
        } else {
            CPU.iret = false;
            if (Callback.inHandler == 0) {
                CPU_Regs.FillFlags();
                pageFault = true;
                CPU.CPU_Exception(14, faultcode);
                pageFault = false;
                throw new PageFaultException();
            }
            LazyFlags old_lflags = new LazyFlags(Flags.lflags);
            CPU.CPU_Decoder old_cpudecoder = CPU.cpudecoder;
            CPU.cpudecoder = PageFaultCore;
            if (Paging.pf_queue.used >= 16) {
                Log.exit("PF queue overrun.");
            }
            PF_Entry entry = Paging.pf_queue.entries[Paging.pf_queue.used++];
            entry.cs = CPU.Segs_CSval;
            entry.eip = CPU_Regs.reg_eip;
            entry.page_addr = page_addr;
            entry.mpl = CPU.cpu.mpl;
            CPU.cpu.mpl = 3;
            pageFault = true;
            CPU.CPU_Exception(14, faultcode);
            pageFault = false;
            Core_full.pushState();
            Dosbox.DOSBOX_RunMachinePF();
            Core_full.popState();
            --Paging.pf_queue.used;
            Flags.lflags.copy(old_lflags);
            CPU.cpudecoder = old_cpudecoder;
        }
    }

    public static boolean PAGING_MakePhysPage(IntRef page) {
        if (Paging.paging.enabled) {
            int d_index = page.value >>> 10;
            int t_index = page.value & 0x3FF;
            X86PageEntry table = new X86PageEntry();
            table.load(Memory.phys_readd((Paging.paging.base.page << 12) + d_index * 4));
            if (table.block.p == 0) {
                return false;
            }
            X86PageEntry entry = new X86PageEntry();
            entry.load(Memory.phys_readd((table.block.base << 12) + t_index * 4));
            if (entry.block.p == 0) {
                return false;
            }
            page.value = entry.block.base;
        } else if (page.value < 272) {
            page.value = (int)Paging.paging.firstmb[page.value];
        }
        return true;
    }

    public static int PAGING_GetDirBase() {
        return Paging.paging.cr3;
    }

    private static void PAGING_InitTLB() {
        for (int i = 0; i < TLB_SIZE; ++i) {
            Paging.paging.tlb.read[i] = -1;
            Paging.paging.tlb.write[i] = -1;
            Paging.paging.tlb.readhandler[i] = init_page_handler;
            Paging.paging.tlb.writehandler[i] = init_page_handler;
        }
        Paging.paging.ur_links.used = 0;
        Paging.paging.krw_links.used = 0;
        Paging.paging.kr_links.used = 0;
        Paging.paging.links.used = 0;
    }

    public static void PAGING_ClearTLB() {
        int i = 0;
        while (Paging.paging.links.used > 0) {
            int page = Paging.paging.links.entries[i];
            Paging.paging.tlb.read[page] = -1;
            Paging.paging.tlb.write[page] = -1;
            Paging.paging.tlb.readhandler[page] = init_page_handler;
            Paging.paging.tlb.writehandler[page] = init_page_handler;
            --Paging.paging.links.used;
            ++i;
        }
        Paging.paging.ur_links.used = 0;
        Paging.paging.krw_links.used = 0;
        Paging.paging.kr_links.used = 0;
        Paging.paging.links.used = 0;
    }

    public static void PAGING_UnlinkPages(int lin_page, int pages) {
        while (pages > 0) {
            Paging.paging.tlb.read[lin_page] = -1;
            Paging.paging.tlb.write[lin_page] = -1;
            Paging.paging.tlb.readhandler[lin_page] = init_page_handler;
            Paging.paging.tlb.writehandler[lin_page] = init_page_handler;
            ++lin_page;
            --pages;
        }
    }

    public static void PAGING_MapPage(int lin_page, int phys_page) {
        if (lin_page < 272) {
            Paging.paging.firstmb[lin_page] = phys_page;
            Paging.paging.tlb.read[lin_page] = -1;
            Paging.paging.tlb.write[lin_page] = -1;
            Paging.paging.tlb.readhandler[lin_page] = init_page_handler;
            Paging.paging.tlb.writehandler[lin_page] = init_page_handler;
        } else {
            Paging.PAGING_LinkPage(lin_page, phys_page);
        }
    }

    private static void PAGING_LinkPageNew(int lin_page, int phys_page, int linkmode, boolean dirty) {
        int xlat_index = linkmode | (Paging.paging.wp ? 8 : 0) | (CPU.cpu.cpl == 3 ? 4 : 0);
        int outcome = xlat_mapping[xlat_index];
        PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
        int lin_base = lin_page << 12;
        if (lin_page >= TLB_SIZE || phys_page >= TLB_SIZE) {
            Log.exit("Illegal page");
        }
        if (Paging.paging.links.used >= 32768) {
            Log.log(9, 0, "Not enough paging links, resetting cache");
            Paging.PAGING_ClearTLB();
        }
        Paging.paging.tlb.phys_page[lin_page] = phys_page | linkmode << 30 | (dirty ? 0x10000000 : 0);
        switch (outcome) {
            case 0: {
                Paging.paging.tlb.read[lin_page] = (handler2.flags & 1) != 0 ? handler2.GetHostReadPt(phys_page) - lin_base : -1;
                Paging.paging.tlb.readhandler[lin_page] = handler2;
                if (dirty) {
                    Paging.paging.tlb.write[lin_page] = (handler2.flags & 2) != 0 ? handler2.GetHostWritePt(phys_page) - lin_base : -1;
                    Paging.paging.tlb.writehandler[lin_page] = handler2;
                    break;
                }
                Paging.paging.tlb.writehandler[lin_page] = foiling_handler;
                Paging.paging.tlb.write[lin_page] = -1;
                break;
            }
            case 1: {
                Paging.paging.tlb.read[lin_page] = (handler2.flags & 1) != 0 ? handler2.GetHostReadPt(phys_page) - lin_base : -1;
                Paging.paging.tlb.readhandler[lin_page] = handler2;
                Paging.paging.tlb.writehandler[lin_page] = exception_handler;
                Paging.paging.tlb.write[lin_page] = -1;
                break;
            }
            case 2: {
                Paging.paging.tlb.readhandler[lin_page] = exception_handler;
                Paging.paging.tlb.writehandler[lin_page] = exception_handler;
                Paging.paging.tlb.read[lin_page] = -1;
                Paging.paging.tlb.write[lin_page] = -1;
            }
        }
        switch (linkmode) {
            case 0: {
                Paging.paging.kr_links.entries[Paging.paging.kr_links.used++] = lin_page;
                break;
            }
            case 1: {
                Paging.paging.krw_links.entries[Paging.paging.krw_links.used++] = lin_page;
                break;
            }
            case 2: {
                Paging.paging.ur_links.entries[Paging.paging.ur_links.used++] = lin_page;
                break;
            }
        }
        Paging.paging.links.entries[Paging.paging.links.used++] = lin_page;
    }

    private static void PAGING_LinkPage(int lin_page, int phys_page) {
        PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
        int lin_base = lin_page << 12;
        if (lin_page >= TLB_SIZE || phys_page >= TLB_SIZE) {
            Log.exit("Illegal page");
        }
        if (Paging.paging.links.used >= 32768) {
            Log.log(9, 0, "Not enough paging links, resetting cache");
            Paging.PAGING_ClearTLB();
        }
        Paging.paging.tlb.phys_page[lin_page] = phys_page;
        Paging.paging.tlb.read[lin_page] = (handler2.flags & 1) != 0 ? handler2.GetHostReadPt(phys_page) - lin_base : -1;
        Paging.paging.tlb.write[lin_page] = (handler2.flags & 2) != 0 ? handler2.GetHostWritePt(phys_page) - lin_base : -1;
        Paging.paging.links.entries[Paging.paging.links.used++] = lin_page;
        Paging.paging.tlb.readhandler[lin_page] = handler2;
        Paging.paging.tlb.writehandler[lin_page] = handler2;
    }

    public static void PAGING_SwitchCPL(boolean isUser) {
        int phys_page;
        int tlb_index;
        int i;
        if (isUser) {
            for (i = 0; i < Paging.paging.krw_links.used; ++i) {
                tlb_index = Paging.paging.krw_links.entries[i];
                Paging.paging.tlb.readhandler[tlb_index] = exception_handler;
                Paging.paging.tlb.writehandler[tlb_index] = exception_handler;
                Paging.paging.tlb.read[tlb_index] = -1;
                Paging.paging.tlb.write[tlb_index] = -1;
            }
        } else {
            for (i = 0; i < Paging.paging.krw_links.used; ++i) {
                PageHandler handler2;
                tlb_index = Paging.paging.krw_links.entries[i];
                phys_page = Paging.paging.tlb.phys_page[tlb_index];
                int lin_base = tlb_index << 12;
                boolean dirty = (phys_page & 0x10000000) != 0;
                Paging.paging.tlb.readhandler[tlb_index] = handler2 = Memory.MEM_GetPageHandler(phys_page &= 0xFFFFF);
                Paging.paging.tlb.read[tlb_index] = (handler2.flags & 1) != 0 ? handler2.GetHostReadPt(phys_page) - lin_base : -1;
                if (dirty) {
                    Paging.paging.tlb.writehandler[tlb_index] = handler2;
                    if ((handler2.flags & 2) != 0) {
                        Paging.paging.tlb.write[tlb_index] = handler2.GetHostWritePt(phys_page) - lin_base;
                        continue;
                    }
                    Paging.paging.tlb.write[tlb_index] = -1;
                    continue;
                }
                Paging.paging.tlb.writehandler[tlb_index] = foiling_handler;
                Paging.paging.tlb.write[tlb_index] = -1;
            }
        }
        if (Paging.paging.wp) {
            if (isUser) {
                for (i = 0; i < Paging.paging.kr_links.used; ++i) {
                    tlb_index = Paging.paging.kr_links.entries[i];
                    Paging.paging.tlb.readhandler[tlb_index] = exception_handler;
                    Paging.paging.tlb.read[tlb_index] = -1;
                }
            } else {
                for (i = 0; i < Paging.paging.kr_links.used; ++i) {
                    PageHandler handler3;
                    tlb_index = Paging.paging.kr_links.entries[i];
                    int lin_base = tlb_index << 12;
                    int phys_page2 = Paging.paging.tlb.phys_page[tlb_index] & 0xFFFFF;
                    Paging.paging.tlb.readhandler[tlb_index] = handler3 = Memory.MEM_GetPageHandler(phys_page2);
                    Paging.paging.tlb.read[tlb_index] = (handler3.flags & 1) != 0 ? handler3.GetHostReadPt(phys_page2) - lin_base : -1;
                }
            }
        } else if (isUser) {
            for (i = 0; i < Paging.paging.ur_links.used; ++i) {
                tlb_index = Paging.paging.ur_links.entries[i];
                Paging.paging.tlb.writehandler[tlb_index] = exception_handler;
                Paging.paging.tlb.write[tlb_index] = -1;
            }
        } else {
            for (i = 0; i < Paging.paging.ur_links.used; ++i) {
                tlb_index = Paging.paging.ur_links.entries[i];
                phys_page = Paging.paging.tlb.phys_page[tlb_index];
                boolean dirty = (phys_page & 0x10000000) != 0;
                PageHandler handler4 = Memory.MEM_GetPageHandler(phys_page &= 0xFFFFF);
                if (dirty) {
                    int lin_base = tlb_index << 12;
                    Paging.paging.tlb.writehandler[tlb_index] = handler4;
                    if ((handler4.flags & 2) != 0) {
                        Paging.paging.tlb.write[tlb_index] = handler4.GetHostWritePt(phys_page) - lin_base;
                        continue;
                    }
                    Paging.paging.tlb.write[tlb_index] = -1;
                    continue;
                }
                Paging.paging.tlb.writehandler[tlb_index] = foiling_handler;
                Paging.paging.tlb.write[tlb_index] = -1;
            }
        }
    }

    public static void PAGING_SetDirBase(int cr3) {
        Paging.paging.cr3 = cr3;
        Paging.paging.base.page = cr3 >>> 12;
        Paging.paging.base.addr = cr3 & 0xFFFFF000;
        if (Paging.paging.enabled) {
            Paging.PAGING_ClearTLB();
        }
    }

    public static void PAGING_SetWP(boolean wp) {
        Paging.paging.wp = wp;
        if (Paging.paging.enabled) {
            Paging.PAGING_ClearTLB();
        }
    }

    public static void PAGING_Enable(boolean enabled) {
        if (Paging.paging.enabled == enabled) {
            return;
        }
        Paging.paging.enabled = enabled;
        if (enabled) {
            Paging.PAGING_SetDirBase(Paging.paging.cr3);
        }
        Paging.PAGING_ClearTLB();
    }

    public static boolean PAGING_Enabled() {
        return Paging.paging.enabled;
    }

    public Paging(Section configuration) {
        super(configuration);
        paging = new PagingBlock();
        Paging.paging.enabled = false;
        Paging.paging.wp = false;
        Paging.PAGING_InitTLB();
        for (int i = 0; i < 272; ++i) {
            Paging.paging.firstmb[i] = i;
        }
        Paging.pf_queue.used = 0;
    }

    static /* synthetic */ int[] access$500() {
        return fault_table;
    }

    static /* synthetic */ void access$600(int x0, int x1, int x2, boolean x3) {
        Paging.PAGING_LinkPageNew(x0, x1, x2, x3);
    }

    static /* synthetic */ void access$700(int x0, int x1) {
        Paging.PAGING_LinkPage(x0, x1);
    }

    static {
        pf_queue = new Pf_queue();
        PageFaultCore = new CPU.CPU_Decoder(){

            public int call() {
                CPU.CPU_CycleLeft += CPU.CPU_Cycles;
                CPU.CPU_Cycles = 1;
                int ret = Core_full.CPU_Core_Full_Run.call();
                CPU.CPU_CycleLeft += CPU.CPU_Cycles;
                if (ret < 0) {
                    Log.exit("Got a dosbox close machine in pagefault core?");
                }
                if (ret != 0) {
                    return ret;
                }
                if (pf_queue.used == 0) {
                    Log.exit("PF Core without PF");
                }
                PF_Entry entry = pf_queue.entries[pf_queue.used - 1];
                X86PageEntry pentry = new X86PageEntry();
                pentry.load(Memory.phys_readd(entry.page_addr));
                if (pentry.block.p != 0 && entry.cs == CPU.Segs_CSval && entry.eip == CPU_Regs.reg_eip) {
                    CPU.cpu.mpl = entry.mpl;
                    return -1;
                }
                if (CPU.iret) {
                    CPU.iret = false;
                    if (Callback.inHandler == 0) {
                        CPU.cpu.mpl = pf_queue.entries[0].mpl;
                        while (pf_queue.used > 0) {
                            Core_full.removeState();
                            --pf_queue.used;
                        }
                        CPU.cpudecoder = Core_dynamic.CPU_Core_Dynamic_Run;
                        System.out.println("Forcing PF exit");
                        throw new PageFaultException();
                    }
                }
                return 0;
            }
        };
        mtr = new String[]{"KR ", "KRW", "UR ", "URW", "PFL"};
        translate_array = new int[]{0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 2, 2, 0, 1, 2, 3};
        lnm = new String[]{"RW ", "RE ", "EE "};
        xlat_mapping = new int[]{0, 0, 0, 0, 2, 2, 1, 0, 1, 0, 1, 0, 2, 2, 1, 0};
        fault_table = new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0};
        pageFault = false;
        init_page_handler = new NewInitPageHandler();
        exception_handler = new ExceptionPageHandler();
        foiling_handler = new PageFoilHandler();
        PAGING_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                paging = null;
            }
        };
        PAGING_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new Paging(section);
                section.AddDestroyFunction(PAGING_ShutDown);
            }
        };
    }

    private static class NewInitPageHandler
    extends PageHandler {
        public NewInitPageHandler() {
            this.flags = 48;
        }

        public int readb(int addr) {
            this.InitPage(addr, false, false);
            return Memory.mem_readb(addr);
        }

        public int readw(int addr) {
            this.InitPage(addr, false, false);
            return Memory.mem_readw(addr);
        }

        public int readd(int addr) {
            this.InitPage(addr, false, false);
            return Memory.mem_readd(addr);
        }

        public void writeb(int addr, int val) {
            this.InitPage(addr, true, false);
            Memory.mem_writeb(addr, val);
        }

        public void writew(int addr, int val) {
            this.InitPage(addr, true, false);
            Memory.mem_writew(addr, val);
        }

        public void writed(int addr, int val) {
            this.InitPage(addr, true, false);
            Memory.mem_writed(addr, val);
        }

        /*
         * Unable to fully structure code
         */
        boolean InitPage(int lin_addr, boolean writing, boolean prepare_only) {
            block8: {
                block5: {
                    block4: {
                        lin_page = lin_addr >>> 12;
                        if (!Paging.paging.enabled) break block5;
                        do lbl-1000:
                        // 4 sources

                        {
                            block7: {
                                block6: {
                                    dir_entry = new X86PageEntry();
                                    table_entry = new X86PageEntry();
                                    isUser = (CPU.cpu.cpl & CPU.cpu.mpl) == 3;
                                    dirEntryAddr = Paging.access$200(lin_addr);
                                    dir_entry.load(Memory.phys_readd(dirEntryAddr));
                                    if (dir_entry.block.p != 0) break block6;
                                    Paging.PAGING_NewPageFault(lin_addr, dirEntryAddr, prepare_only, (writing != false ? 2 : 0) | (isUser != false ? 4 : 0));
                                    if (!prepare_only) ** GOTO lbl-1000
                                    return true;
                                }
                                tableEntryAddr = Paging.access$300(lin_addr, dir_entry);
                                table_entry.load(Memory.phys_readd(tableEntryAddr));
                                if (dir_entry.block.a == 0) {
                                    dir_entry.block.a = 1;
                                    Memory.phys_writed(dirEntryAddr, dir_entry.load());
                                }
                                if (table_entry.block.p != 0) break block7;
                                Paging.PAGING_NewPageFault(lin_addr, tableEntryAddr, prepare_only, (writing != false ? 2 : 0) | (isUser != false ? 4 : 0));
                                if (!prepare_only) ** GOTO lbl-1000
                                return true;
                            }
                            result = Paging.access$400()[dir_entry.load() << 1 & 12 | table_entry.load() >> 1 & 3];
                            ft_index = result | (writing != false ? 8 : 0) | (isUser != false ? 4 : 0) | (Paging.paging.wp != false ? 16 : 0);
                            if (Paging.access$500()[ft_index] == 0) break block4;
                            Paging.PAGING_NewPageFault(lin_addr, tableEntryAddr, prepare_only, 1 | (writing != false ? 2 : 0) | (isUser != false ? 4 : 0));
                        } while (!prepare_only);
                        return true;
                    }
                    table_load = table_entry.load();
                    if (writing) {
                        table_entry.block.d = 1;
                    }
                    table_entry.block.a = 1;
                    if (table_load != table_entry.load()) {
                        Memory.phys_writed(tableEntryAddr, table_entry.load());
                    }
                    dirty = table_entry.block.d != 0;
                    Paging.access$600(lin_page, table_entry.block.base, result, dirty);
                    break block8;
                }
                phys_page = lin_page < 272 ? (int)Paging.paging.firstmb[lin_page] : lin_page;
                Paging.access$700(lin_page, phys_page);
            }
            return false;
        }
    }

    private static class ExceptionPageHandler
    extends PageHandler {
        private PageHandler getHandler(int addr) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            return handler2;
        }

        private boolean hack_check(int addr) {
            int old_attirbs = Paging.paging.tlb.phys_page[addr >>> 12] >> 30;
            X86PageEntry dir_entry = new X86PageEntry();
            X86PageEntry table_entry = new X86PageEntry();
            dir_entry.load(Memory.phys_readd(Paging.GetPageDirectoryEntryAddr(addr)));
            if (dir_entry.block.p == 0) {
                return false;
            }
            table_entry.load(Memory.phys_readd(Paging.GetPageTableEntryAddr(addr, dir_entry)));
            if (table_entry.block.p == 0) {
                return false;
            }
            int result = translate_array[dir_entry.load() << 1 & 0xC | table_entry.load() >> 1 & 3];
            return result != old_attirbs;
        }

        void Exception(int addr, boolean writing, boolean checked) {
            int tableaddr = 0;
            if (!checked) {
                X86PageEntry dir_entry = new X86PageEntry();
                dir_entry.load(Memory.phys_readd(Paging.GetPageDirectoryEntryAddr(addr)));
                if (dir_entry.block.p == 0) {
                    Log.exit("Undesired situation 1 in exception handler.");
                }
                tableaddr = Paging.GetPageTableEntryAddr(addr, dir_entry);
            }
            Paging.PAGING_NewPageFault(addr, tableaddr, checked, 1 | (writing ? 2 : 0) | ((CPU.cpu.cpl & CPU.cpu.mpl) == 3 ? 4 : 0));
            Paging.PAGING_ClearTLB();
        }

        int readb_through(int addr) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            if ((handler2.flags & 1) != 0) {
                return Memory.host_readb(handler2.GetHostReadPt(phys_page) + (addr & 0xFFF));
            }
            return handler2.readb(addr);
        }

        int readw_through(int addr) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            if ((handler2.flags & 1) != 0) {
                return Memory.host_readw(handler2.GetHostReadPt(phys_page) + (addr & 0xFFF));
            }
            return handler2.readw(addr);
        }

        int readd_through(int addr) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            if ((handler2.flags & 1) != 0) {
                return Memory.host_readd(handler2.GetHostReadPt(phys_page) + (addr & 0xFFF));
            }
            return handler2.readd(addr);
        }

        void writeb_through(int addr, int val) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            if ((handler2.flags & 2) != 0) {
                Memory.host_writeb(handler2.GetHostWritePt(phys_page) + (addr & 0xFFF), (short)val);
            } else {
                handler2.writeb(addr, val);
            }
        }

        void writew_through(int addr, int val) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            if ((handler2.flags & 2) != 0) {
                Memory.host_writew(handler2.GetHostWritePt(phys_page) + (addr & 0xFFF), val);
            } else {
                handler2.writew(addr, val);
            }
        }

        void writed_through(int addr, int val) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            if ((handler2.flags & 2) != 0) {
                Memory.host_writed(handler2.GetHostWritePt(phys_page) + (addr & 0xFFF), val);
            } else {
                handler2.writed(addr, val);
            }
        }

        public ExceptionPageHandler() {
            this.flags = 48;
        }

        public int readb(int addr) {
            if (CPU.cpu.mpl == 0) {
                return this.readb_through(addr);
            }
            this.Exception(addr, false, false);
            return Memory.mem_readb(addr);
        }

        public int readw(int addr) {
            if (CPU.cpu.mpl == 0) {
                return this.readw_through(addr);
            }
            this.Exception(addr, false, false);
            return Memory.mem_readw(addr);
        }

        public int readd(int addr) {
            if (CPU.cpu.mpl == 0) {
                return this.readd_through(addr);
            }
            this.Exception(addr, false, false);
            return Memory.mem_readd(addr);
        }

        public void writeb(int addr, int val) {
            if (CPU.cpu.mpl == 0) {
                this.writeb_through(addr, val);
                return;
            }
            this.Exception(addr, true, false);
            Memory.mem_writeb(addr, val);
        }

        public void writew(int addr, int val) {
            if (CPU.cpu.mpl == 0) {
                this.writew_through(addr, val);
                return;
            }
            if (this.hack_check(addr)) {
                Log.log_msg("Page attributes modified without clear");
                Paging.PAGING_ClearTLB();
                Memory.mem_writew(addr, val);
                return;
            }
            this.Exception(addr, true, false);
            Memory.mem_writew(addr, val);
        }

        public void writed(int addr, int val) {
            if (CPU.cpu.mpl == 0) {
                this.writed_through(addr, val);
                return;
            }
            this.Exception(addr, true, false);
            Memory.mem_writed(addr, val);
        }
    }

    private static class PageFoilHandler
    extends PageHandler {
        private void work(int addr) {
            int lin_page = addr >>> 12;
            int phys_page = Paging.paging.tlb.phys_page[lin_page] & 0xFFFFF;
            int n = lin_page;
            Paging.paging.tlb.phys_page[n] = Paging.paging.tlb.phys_page[n] | 0x10000000;
            X86PageEntry dir_entry = new X86PageEntry();
            X86PageEntry table_entry = new X86PageEntry();
            int dirEntryAddr = Paging.GetPageDirectoryEntryAddr(addr);
            dir_entry.load(Memory.phys_readd(dirEntryAddr));
            if (dir_entry.block.p == 0) {
                Log.exit("Undesired situation 1 in page foiler.");
            }
            int tableEntryAddr = Paging.GetPageTableEntryAddr(addr, dir_entry);
            table_entry.load(Memory.phys_readd(tableEntryAddr));
            if (table_entry.block.p == 0) {
                Log.exit("Undesired situation 2 in page foiler.");
            }
            if (table_entry.block.base != phys_page && table_entry.block.p == 0) {
                Log.exit("Undesired situation 3 in page foiler.");
            }
            PageHandler handler2 = Memory.MEM_GetPageHandler(phys_page);
            table_entry.block.d = 1;
            Memory.phys_writed(tableEntryAddr, table_entry.load());
            Paging.paging.tlb.write[lin_page] = (handler2.flags & 2) != 0 ? handler2.GetHostWritePt(phys_page) - (lin_page << 12) : -1;
            Paging.paging.tlb.writehandler[lin_page] = handler2;
        }

        private void read() {
            Log.exit("The page foiler shouldn't be read.");
        }

        public PageFoilHandler() {
            this.flags = 48;
        }

        public int readb(int addr) {
            this.read();
            return 0;
        }

        public int readw(int addr) {
            this.read();
            return 0;
        }

        public int readd(int addr) {
            this.read();
            return 0;
        }

        public void writeb(int addr, int val) {
            this.work(addr);
            Memory.mem_writeb(addr, val);
        }

        public void writew(int addr, int val) {
            this.work(addr);
            Memory.mem_writew(addr, val);
        }

        public void writed(int addr, int val) {
            this.work(addr);
            Memory.mem_writed(addr, val);
        }
    }

    public static class PageFaultException
    extends RuntimeException {
    }

    private static class Pf_queue {
        int used;
        PF_Entry[] entries = new PF_Entry[16];

        public Pf_queue() {
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i] = new PF_Entry();
            }
        }
    }

    private static class PF_Entry {
        int cs;
        int eip;
        int page_addr;
        int mpl;

        private PF_Entry() {
        }
    }

    public static class PagingBlock {
        public int cr3;
        public int cr2;
        public boolean wp;
        public Base base = new Base();
        public Tlb tlb;
        public Links links = new Links();
        public UR_Links ur_links = new UR_Links();
        public KRW_Links krw_links = new KRW_Links();
        public KR_Links kr_links = new KR_Links();
        public long[] firstmb = new long[272];
        public boolean enabled;

        public PagingBlock() {
            this.tlb = new Tlb();
        }

        public class KR_Links {
            public int used;
            public int[] entries = new int[32768];
        }

        public class KRW_Links {
            public int used;
            public int[] entries = new int[32768];
        }

        public class UR_Links {
            public int used;
            public int[] entries = new int[32768];
        }

        public class Links {
            public int used;
            public int[] entries = new int[32768];
        }

        public class Tlb {
            public int[] read = new int[TLB_SIZE];
            public int[] write = new int[TLB_SIZE];
            public PageHandler[] readhandler = new PageHandler[TLB_SIZE];
            public PageHandler[] writehandler = new PageHandler[TLB_SIZE];
            public int[] phys_page = new int[TLB_SIZE];
        }

        public class Base {
            public int page;
            public int addr;
        }
    }

    public static class X86PageEntry {
        X86_PageEntryBlock block = new X86_PageEntryBlock();

        public int load() {
            int load = 0;
            load |= this.block.p & 1;
            load |= (this.block.wr & 1) << 1;
            load |= (this.block.us & 1) << 2;
            load |= (this.block.pwt & 1) << 3;
            load |= (this.block.pcd & 1) << 4;
            load |= (this.block.a & 1) << 5;
            load |= (this.block.d & 1) << 6;
            load |= (this.block.pat & 1) << 7;
            load |= (this.block.g & 1) << 8;
            load |= (this.block.avl & 7) << 9;
            return load |= (this.block.base & 0xFFFFF) << 12;
        }

        public void load(int value) {
            this.block.p = value & 1;
            this.block.wr = value >> 1 & 1;
            this.block.us = value >> 2 & 1;
            this.block.pwt = value >> 3 & 1;
            this.block.pcd = value >> 4 & 1;
            this.block.a = value >> 5 & 1;
            this.block.d = value >> 6 & 1;
            this.block.pat = value >> 7 & 1;
            this.block.g = value >> 8 & 1;
            this.block.avl = value >> 9 & 7;
            this.block.base = value >>> 12 & 0xFFFFF;
        }
    }

    public static class X86_PageEntryBlock {
        int p;
        int wr;
        int us;
        int pwt;
        int pcd;
        int a;
        int d;
        int pat;
        int g;
        int avl;
        int base;
    }

    public static class PageHandler {
        public int flags;

        public int readb(int addr) {
            Log.exit("No byte handler for read from " + Long.toString(addr, 16));
            return 0;
        }

        public int readw(int addr) {
            return this.readb(addr + 0) | this.readb(addr + 1) << 8;
        }

        public int readd(int addr) {
            return this.readb(addr + 0) | this.readb(addr + 1) << 8 | this.readb(addr + 2) << 16 | this.readb(addr + 3) << 24;
        }

        public void writeb(int addr, int val) {
            Log.exit("No byte handler for write to " + Long.toString(addr, 16));
        }

        public void writew(int addr, int val) {
            this.writeb(addr + 0, val);
            this.writeb(addr + 1, val >> 8);
        }

        public void writed(int addr, int val) {
            this.writeb(addr + 0, val);
            this.writeb(addr + 1, val >> 8);
            this.writeb(addr + 2, val >> 16);
            this.writeb(addr + 3, val >> 24);
        }

        public int GetHostReadPt(int phys_page) {
            return 0;
        }

        public int GetHostWritePt(int phys_page) {
            return 0;
        }
    }
}

