/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import java.util.Vector;
import jdos.cpu.core_dynamic.Cache;
import jdos.cpu.core_dynamic.CodePageHandlerDynRec;
import jdos.cpu.core_dynamic.DecodeBlock;
import jdos.misc.Log;

public class CacheBlockDynRec {
    public Page page = new Page();
    public _Cache cache = new _Cache();
    public _Hash hash = new _Hash();
    public _Link[] link = new _Link[2];
    public _Link link1;
    public _Link link2;
    CacheBlockDynRec crossblock;
    public DecodeBlock code;
    public byte[] originalByteCode = null;

    public CacheBlockDynRec() {
        for (int i = 0; i < this.link.length; ++i) {
            this.link[i] = new _Link();
        }
        this.link1 = this.link[0];
        this.link2 = this.link[1];
    }

    public void Clear() {
        if (this.hash.index != 0) {
            for (int ind = 0; ind < 2; ++ind) {
                Vector fromlink = this.link[ind].from;
                if (this.link[ind].from != null) {
                    for (int i = 0; i < this.link[ind].from.size(); ++i) {
                        CacheBlockDynRec from = (CacheBlockDynRec)this.link[ind].from.elementAt(i);
                        if (from.link[ind].to != this) {
                            Log.exit("Bad Dynamic cache");
                        }
                        from.link[ind].to = null;
                    }
                    this.link[ind].from = null;
                }
                if (this.link[ind].to == null || this.link[ind].to == this) continue;
                this.link[ind].to.link[ind].from.remove(this);
                if (this.link[ind].to.link[ind].from.size() == 0) {
                    this.link[ind].to.link[ind].from = null;
                }
                this.link[ind].to = null;
            }
        }
        Cache.cache_addunusedblock(this);
        if (this.crossblock != null) {
            this.crossblock.crossblock = null;
            this.crossblock.Clear();
            this.crossblock = null;
        }
        if (this.page.handler != null) {
            this.page.handler.DelCacheBlock(this);
            this.page.handler = null;
        }
        this.cache.wmapmask = null;
    }

    public void LinkTo(int index, CacheBlockDynRec toblock) {
        if (toblock == null) {
            throw new NullPointerException();
        }
        if (this.link[index].to != null) {
            Log.exit("Dynamic cache failure");
        }
        this.link[index].to = toblock;
        if (toblock.link[index].from == null) {
            toblock.link[index].from = new Vector();
        }
        toblock.link[index].from.add(this);
    }

    public static class _Link {
        public CacheBlockDynRec to;
        public Vector from = new Vector();
    }

    public static class _Hash {
        int index;
        CacheBlockDynRec next;
    }

    public static class _Cache {
        public CacheBlockDynRec next;
        public byte[] wmapmask;
        public int maskstart;
        public int masklen;
    }

    public class Page {
        int start;
        int end;
        CodePageHandlerDynRec handler;
    }
}

