/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.Compiler;
import jdos.cpu.core_dynamic.Loader;
import jdos.cpu.core_dynamic.Op;
import jdos.hardware.Memory;

public final class DecodeBlock
extends Op {
    public Op op;
    public boolean active = true;
    public int codeStart;
    public int codeLen;
    public int runCount = 0;
    public static int compileThreshold = 0;
    public static boolean compilerEnabled = true;
    public static boolean smc = false;
    private boolean compiled = false;

    private static byte[] getOpCode(int start, int len) {
        byte[] opCode = new byte[len];
        int src = Paging.getDirectIndexRO(start);
        if (src >= 0) {
            Memory.host_memcpy(opCode, 0, src, len);
        } else {
            Memory.MEM_BlockRead(start, opCode, len);
        }
        return opCode;
    }

    public DecodeBlock(Op op, int start, int len) {
        Op o;
        this.op = op;
        this.next = op;
        this.codeStart = start;
        this.codeLen = len;
        if (Loader.isLoaded() && (o = Loader.load(this.codeStart, DecodeBlock.getOpCode(this.codeStart, this.codeLen))) != null) {
            this.op = o;
            this.next = o;
            this.compiled = true;
        }
    }

    public final int call() {
        ++this.runCount;
        if (compilerEnabled && this.runCount == compileThreshold && !this.compiled) {
            Compiler.compile(this);
        }
        Op o = this.op;
        int result = 4;
        Core.base_ds = CPU.Segs_DSphys;
        Core.base_ss = CPU.Segs_SSphys;
        Core.base_val_ds = 3;
        while ((result = o.call()) == 4) {
            CPU_Regs.reg_eip += o.eip_count;
            o = o.next;
            if (!smc) continue;
            smc = false;
            System.out.println("SMC");
            CPU.CPU_Cycles -= this.op.cycle;
            return 3;
        }
        CPU.CPU_Cycles -= this.op.cycle;
        return result;
    }
}

