/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.Core;
import jdos.cpu.Paging;
import jdos.cpu.core_dynamic.Cache;
import jdos.cpu.core_dynamic.CacheBlockDynRec;
import jdos.cpu.core_dynamic.CodePageHandlerDynRec;
import jdos.cpu.core_dynamic.Decode;
import jdos.cpu.core_dynamic.DecodeBlock;
import jdos.cpu.core_dynamic.Decoder_basic;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Inst1;
import jdos.cpu.core_dynamic.Op;
import jdos.cpu.core_dynamic.Prefix_0f;
import jdos.cpu.core_dynamic.Prefix_66;
import jdos.cpu.core_dynamic.Prefix_66_0f;
import jdos.cpu.core_dynamic.Prefix_none;
import jdos.cpu.core_share.ModifiedDecode;
import jdos.misc.Log;

public class Decoder
extends Inst1 {
    public static final Decode[] ops = new Decode[1024];
    private static int count;

    public static CacheBlockDynRec CreateCacheBlock(CodePageHandlerDynRec codepage, int start, int max_opcodes) {
        Op op;
        StartDecode start_op;
        Decoder.decode.code_start = start;
        Decoder.decode.code = start;
        Decoder.decode.page.code = codepage;
        Decoder.decode.page.index = start & 0xFFF;
        Decoder.decode.page.wmap = codepage.write_map;
        Decoder.decode.page.invmap = codepage.invalidation_map;
        Decoder.decode.page.first = start >>> 12;
        Decoder.decode.active_block = Decoder.decode.block = Cache.cache_openblock();
        Decoder.decode.block.page.start = Decoder.decode.page.index;
        codepage.AddCacheBlock(Decoder.decode.block);
        Decoder_basic.InitFlagsOptimization();
        Decoder.decode.cycles = 0;
        int result = 0;
        if (CPU.cpu.code.big) {
            opcode_index = 512;
            prefixes = 1;
            EA16 = false;
        } else {
            opcode_index = 0;
            prefixes = 0;
            EA16 = true;
        }
        StartDecode begin_op = start_op = (op = new StartDecode());
        boolean seg_changed = false;
        int opcode = 0;
        int count = 0;
        int cycles = 0;
        try {
            while (max_opcodes-- > 0 && result == 0) {
                ++Decoder.decode.cycles;
                Decoder.decode.op_start = Decoder.decode.code;
                Decoder.decode.modifiedAlot = false;
                opcode = opcode_index + Decoder.decode_fetchb();
                result = ops[opcode].call(op);
                if (Decoder.decode.modifiedAlot) {
                    result = 1;
                    break;
                }
                count += Decoder.decode.code - Decoder.decode.op_start;
                if (result == 3) {
                    result = 0;
                    ++max_opcodes;
                    continue;
                }
                op = op.next;
                op.c = opcode;
                op.cycle = ++cycles;
                if (result == 7) {
                    result = 0;
                    ++max_opcodes;
                    seg_changed = true;
                    continue;
                }
                begin_op = op;
                op.eip_count = count;
                count = 0;
                if (result == 5) {
                    result = 0;
                    ++max_opcodes;
                }
                if (CPU.cpu.code.big) {
                    opcode_index = 512;
                    prefixes = 1;
                    EA16 = false;
                } else {
                    opcode_index = 0;
                    prefixes = 0;
                    EA16 = true;
                }
                if (!seg_changed || result != 0) continue;
                seg_changed = false;
                op.next = new HandledSegChange();
                op = op.next;
                op.c = -1;
                op.cycle = cycles;
                begin_op = op;
            }
        }
        catch (Helper.ChangePageException e) {
            result = Decoder.decode.code - Decoder.decode.op_start + count == 0 ? 0 : 1;
        }
        catch (Paging.PageFaultException e) {
            Log.exit("Oops");
        }
        Cache.cache_closeblock();
        switch (result) {
            case 0: {
                op.next = new HandledDecode();
                op.cycle = cycles;
                op = op.next;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 1: {
                Decoder.decode_putback(Decoder.decode.code - Decoder.decode.op_start + count);
                op = begin_op;
                op.next = new ModifiedDecodeOp();
                op.cycle = ++cycles;
                op = op.next;
            }
        }
        Decoder.decode.active_block.page.end = --Decoder.decode.page.index;
        Decoder.decode.block.code = new DecodeBlock(start_op.next, start, Decoder.decode.block.page.end - Decoder.decode.block.page.start + 1);
        return Decoder.decode.block;
    }

    static {
        Decode not_handled = new Decode(){

            public int call(Op prev) {
                prev.next = new Op(){

                    public int call() {
                        CPU.CPU_Exception(6, 0);
                        return 3;
                    }
                };
                return 6;
            }
        };
        for (int i = 0; i < ops.length; ++i) {
            Decoder.ops[i] = not_handled;
        }
        count = 0;
        Prefix_none.init(ops);
        Prefix_0f.init(ops);
        Prefix_66.init(ops);
        Prefix_66_0f.init(ops);
    }

    public static class ModifiedDecodeOp
    extends Op {
        public int call() {
            return ModifiedDecode.call();
        }
    }

    public static class HandledSegChange
    extends Op {
        public int call() {
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static class HandledDecode
    extends Op {
        public int call() {
            return 3;
        }
    }

    private static class StartDecode
    extends Op {
        private StartDecode() {
        }

        public int call() {
            return 4;
        }
    }
}

