/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Core_dynamic;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.StringOp;
import jdos.cpu.core_dynamic.EaaBase;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Mod;
import jdos.cpu.core_dynamic.Op;
import jdos.cpu.core_share.Data;
import jdos.fpu.FPU;
import jdos.hardware.IO;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.util.IntRef;

public class Inst1
extends Helper {
    static final CPU.Descriptor desc = new CPU.Descriptor();

    public static final class Wait
    extends Op {
        public int call() {
            return 4;
        }

        public boolean compile(StringBuffer method) {
            return true;
        }
    }

    public static final class Cwd
    extends Op {
        public int call() {
            if ((CPU_Regs.reg_eax.word() & 0x8000) != 0) {
                CPU_Regs.reg_edx.word(65535);
            } else {
                CPU_Regs.reg_edx.word(0);
            }
            return 4;
        }
    }

    public static final class Cbw
    extends Op {
        public int call() {
            CPU_Regs.reg_eax.word((byte)CPU_Regs.reg_eax.low());
            return 4;
        }
    }

    public static final class PushEv_mem
    extends Op {
        EaaBase get_eaa;

        public PushEv_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            CPU.CPU_Push16(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class PushEv_reg
    extends Op {
        CPU_Regs.Reg earw;

        public PushEv_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            CPU.CPU_Push16(this.earw.word());
            return 4;
        }
    }

    public static final class JmpEp
    extends Op {
        EaaBase get_eaa;

        public JmpEp(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int newip = Memory.mem_readw(eaa);
            int newcs = Memory.mem_readw(eaa + 2);
            Flags.FillFlags();
            CPU.CPU_JMP(false, newcs, newip, CPU_Regs.reg_eip + this.eip_count & 0xFFFF);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class JmpEv_mem
    extends Op {
        EaaBase get_eaa;

        public JmpEv_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            CPU_Regs.reg_eip = Memory.mem_readw(eaa);
            return 3;
        }
    }

    public static final class JmpEv_reg
    extends Op {
        CPU_Regs.Reg earw;

        public JmpEv_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            CPU_Regs.reg_eip = this.earw.word();
            return 3;
        }
    }

    public static final class CallEp
    extends Op {
        EaaBase get_eaa;

        public CallEp(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int newip = Memory.mem_readw(eaa);
            int newcs = Memory.mem_readw(eaa + 2);
            Flags.FillFlags();
            CPU.CPU_CALL(false, newcs, newip, CPU_Regs.reg_eip + this.eip_count & 0xFFFF);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class CallEv_mem
    extends Op {
        EaaBase get_eaa;

        public CallEv_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int old = CPU_Regs.reg_eip + this.eip_count;
            int eip = Memory.mem_readw(eaa);
            CPU.CPU_Push16(old & 0xFFFF);
            CPU_Regs.reg_eip = eip;
            return 3;
        }
    }

    public static final class CallEv_reg
    extends Op {
        CPU_Regs.Reg earw;

        public CallEv_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int old = CPU_Regs.reg_eip + this.eip_count;
            CPU.CPU_Push16(old & 0xFFFF);
            CPU_Regs.reg_eip = this.earw.word();
            return 3;
        }
    }

    public static final class Decw_mem
    extends Op {
        EaaBase get_eaa;

        public Decw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.DECW(Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Decw_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Decw_reg(int rm) {
            this.reg = Mod.ew(rm);
        }

        public int call() {
            this.reg.word(Instructions.DECW(this.reg.word()));
            return 4;
        }
    }

    public static final class Incw_mem
    extends Op {
        EaaBase get_eaa;

        public Incw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.INCW(Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Incw_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Incw_reg(int rm) {
            this.reg = Mod.ew(rm);
        }

        public int call() {
            this.reg.word(Instructions.INCW(this.reg.word()));
            return 4;
        }
    }

    public static final class Callback
    extends Op {
        int val;

        public Callback(int val) {
            this.val = val;
        }

        public int call() {
            CPU_Regs.reg_eip += this.eip_count;
            Data.callback = this.val;
            return 5;
        }
    }

    public static final class Decb_mem
    extends Op {
        EaaBase get_eaa;

        public Decb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.DECB(Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Decb_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Decb_reg(int rm) {
            this.reg = Mod.eb(rm);
        }

        public int call() {
            this.reg.set8(Instructions.DECB(this.reg.get8()));
            return 4;
        }
    }

    public static final class Incb_mem
    extends Op {
        EaaBase get_eaa;

        public Incb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.INCB(Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Incb_reg
    extends Op {
        CPU_Regs.Reg reg;

        public Incb_reg(int rm) {
            this.reg = Mod.eb(rm);
        }

        public int call() {
            this.reg.set8(Instructions.INCB(this.reg.get8()));
            return 4;
        }
    }

    public static final class Std
    extends Op {
        public int call() {
            CPU_Regs.SETFLAGBIT(1024, true);
            CPU.cpu.direction = -1;
            return 4;
        }
    }

    public static final class Cld
    extends Op {
        public int call() {
            CPU_Regs.SETFLAGBIT(1024, false);
            CPU.cpu.direction = 1;
            return 4;
        }
    }

    public static final class Sti
    extends Op {
        public int call() {
            if (CPU.CPU_STI()) {
                return this.RUNEXCEPTION();
            }
            if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                return this.DECODE_END(this.eip_count);
            }
            return 4;
        }
    }

    public static final class Cli
    extends Op {
        public int call() {
            if (CPU.CPU_CLI()) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Stc
    extends Op {
        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, true);
            return 4;
        }
    }

    public static final class Clc
    extends Op {
        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, false);
            return 4;
        }
    }

    public static final class Cmc
    extends Op {
        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (CPU_Regs.flags & 1) == 0);
            return 4;
        }
    }

    public static final class Hlt
    extends Op {
        public int call() {
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            Flags.FillFlags();
            CPU.CPU_HLT(CPU_Regs.reg_eip + this.eip_count);
            return this.CB_NONE();
        }
    }

    public static final class Icebp
    extends Op {
        public int call() {
            CPU.CPU_SW_Interrupt_NoIOPLCheck(1, CPU_Regs.reg_eip + this.eip_count);
            CPU.cpu.trap_skip = true;
            return 3;
        }
    }

    public static final class Lock
    extends Op {
        public int call() {
            return 4;
        }
    }

    public static final class OutAxDx
    extends Op {
        public int call() {
            if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 2)) {
                return this.RUNEXCEPTION();
            }
            IO.IO_WriteW(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.word());
            return 4;
        }
    }

    public static final class OutAlDx
    extends Op {
        public int call() {
            if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 1)) {
                return this.RUNEXCEPTION();
            }
            IO.IO_WriteB(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.low());
            return 4;
        }
    }

    public static final class InAxDx
    extends Op {
        public int call() {
            if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 2)) {
                return this.RUNEXCEPTION();
            }
            CPU_Regs.reg_eax.word(IO.IO_ReadW(CPU_Regs.reg_edx.word()));
            return 4;
        }
    }

    public static final class InAlDx
    extends Op {
        public int call() {
            if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 1)) {
                return this.RUNEXCEPTION();
            }
            CPU_Regs.reg_eax.low(IO.IO_ReadB(CPU_Regs.reg_edx.word()));
            return 4;
        }
    }

    public static final class JmpJb
    extends Op {
        int addip = Helper.decode_fetchbs();

        public int call() {
            CPU_Regs.reg_ip((CPU_Regs.reg_eip += this.eip_count) + this.addip);
            return 1;
        }
    }

    public static final class JmpAp
    extends Op {
        int newip = Helper.decode_fetchw();
        int newcs = Helper.decode_fetchw();

        public int call() {
            Flags.FillFlags();
            CPU.CPU_JMP(false, this.newcs, this.newip, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class JmpJw
    extends Op {
        int addip = Helper.decode_fetchws();

        public int call() {
            CPU_Regs.reg_ip((CPU_Regs.reg_eip += this.eip_count) + this.addip);
            return 1;
        }
    }

    public static final class CallJw
    extends Op {
        int addip = Helper.decode_fetchws();

        public int call() {
            CPU.CPU_Push16(CPU_Regs.reg_eip + this.eip_count);
            CPU_Regs.reg_ip(CPU_Regs.reg_eip + this.eip_count + this.addip);
            return 1;
        }
    }

    public static final class OutAxIb
    extends Op {
        int port = Helper.decode_fetchb();

        public int call() {
            if (CPU.CPU_IO_Exception(this.port, 2)) {
                return this.RUNEXCEPTION();
            }
            IO.IO_WriteW(this.port, CPU_Regs.reg_eax.word());
            return 4;
        }
    }

    public static final class OutAlIb
    extends Op {
        int port = Helper.decode_fetchb();

        public int call() {
            if (CPU.CPU_IO_Exception(this.port, 1)) {
                return this.RUNEXCEPTION();
            }
            IO.IO_WriteB(this.port, CPU_Regs.reg_eax.low());
            return 4;
        }
    }

    public static final class InAxIb
    extends Op {
        int port = Helper.decode_fetchb();

        public int call() {
            if (CPU.CPU_IO_Exception(this.port, 2)) {
                return this.RUNEXCEPTION();
            }
            CPU_Regs.reg_eax.word(IO.IO_ReadW(this.port));
            return 4;
        }
    }

    public static final class InAlIb
    extends Op {
        int port = Helper.decode_fetchb();

        public int call() {
            if (CPU.CPU_IO_Exception(this.port, 1)) {
                return this.RUNEXCEPTION();
            }
            CPU_Regs.reg_eax.low(IO.IO_ReadB(this.port));
            return 4;
        }
    }

    public static final class Jcxz
    extends JumpCond16_b {
        int mask;

        public Jcxz(int mask) {
            this.mask = mask;
        }

        public int call() {
            return this.jump((CPU_Regs.reg_ecx.dword & this.mask) == 0, this.offset);
        }
    }

    public static final class Loop16
    extends JumpCond16_b {
        public int call() {
            CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
            return this.jump(CPU_Regs.reg_ecx.word() != 0, this.offset);
        }
    }

    public static final class Loop32
    extends JumpCond16_b {
        public int call() {
            --CPU_Regs.reg_ecx.dword;
            return this.jump(CPU_Regs.reg_ecx.dword != 0, this.offset);
        }
    }

    public static final class Loopz16
    extends JumpCond16_b {
        public int call() {
            CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
            return this.jump(CPU_Regs.reg_ecx.word() != 0 && Flags.get_ZF(), this.offset);
        }
    }

    public static final class Loopz32
    extends JumpCond16_b {
        public int call() {
            --CPU_Regs.reg_ecx.dword;
            return this.jump(CPU_Regs.reg_ecx.dword != 0 && Flags.get_ZF(), this.offset);
        }
    }

    public static final class Loopnz16
    extends JumpCond16_b {
        public int call() {
            CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
            return this.jump(CPU_Regs.reg_ecx.word() != 0 && !Flags.get_ZF(), this.offset);
        }
    }

    public static final class Loopnz32
    extends JumpCond16_b {
        public int call() {
            --CPU_Regs.reg_ecx.dword;
            return this.jump(CPU_Regs.reg_ecx.dword != 0 && !Flags.get_ZF(), this.offset);
        }
    }

    public static final class FPU7_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU7_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC7_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU7_normal
    extends Op {
        int rm;

        public FPU7_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC7_Normal(this.rm);
            return 4;
        }
    }

    public static final class FPU6_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU6_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC6_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU6_normal
    extends Op {
        int rm;

        public FPU6_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC6_Normal(this.rm);
            return 4;
        }
    }

    public static final class FPU5_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU5_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC5_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU5_normal
    extends Op {
        int rm;

        public FPU5_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC5_Normal(this.rm);
            return 4;
        }
    }

    public static final class FPU4_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU4_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC4_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU4_normal
    extends Op {
        int rm;

        public FPU4_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC4_Normal(this.rm);
            return 4;
        }
    }

    public static final class FPU3_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU3_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC3_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU3_normal
    extends Op {
        int rm;

        public FPU3_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC3_Normal(this.rm);
            return 4;
        }
    }

    public static final class FPU2_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU2_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC2_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU2_normal
    extends Op {
        int rm;

        public FPU2_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC2_Normal(this.rm);
            return 4;
        }
    }

    public static final class FPU1_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU1_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC1_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU1_normal
    extends Op {
        int rm;

        public FPU1_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC1_Normal(this.rm);
            return 4;
        }
    }

    public static final class FPU0_ea
    extends Op {
        int rm;
        EaaBase get_eaa;

        public FPU0_ea(int rm) {
            this.rm = rm;
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            FPU.FPU_ESC0_EA(this.rm, this.get_eaa.call());
            return 4;
        }
    }

    public static final class FPU0_normal
    extends Op {
        int rm;

        public FPU0_normal(int rm) {
            this.rm = rm;
        }

        public int call() {
            FPU.FPU_ESC0_Normal(this.rm);
            return 4;
        }
    }

    public static final class Xlat16
    extends Op {
        public int call() {
            CPU_Regs.reg_eax.low(Memory.mem_readb(Core.base_ds + (CPU_Regs.reg_ebx.word() + CPU_Regs.reg_eax.low() & 0xFFFF)));
            return 4;
        }
    }

    public static final class Xlat32
    extends Op {
        public int call() {
            CPU_Regs.reg_eax.low(Memory.mem_readb(Core.base_ds + CPU_Regs.reg_ebx.dword + CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class Salc
    extends Op {
        public int call() {
            CPU_Regs.reg_eax.low(Flags.get_CF() ? 255 : 0);
            return 4;
        }
    }

    public static final class AadIb
    extends Op {
        int ib = Helper.decode_fetchb();

        public int call() {
            Instructions.AAD(this.ib);
            return 4;
        }
    }

    public static final class AamIb
    extends Op {
        int ib = Helper.decode_fetchb();

        public int call() {
            return Instructions.AAMr(this, this.ib);
        }
    }

    public static final class IRet
    extends Op {
        public int call() {
            CPU.CPU_IRET(false, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class Int0
    extends Op {
        public int call() {
            if (Flags.get_OF()) {
                CPU.CPU_SW_Interrupt(4, CPU_Regs.reg_eip + this.eip_count);
                CPU.cpu.trap_skip = true;
                return 3;
            }
            return 4;
        }
    }

    public static final class IntIb
    extends Op {
        int num = Helper.decode_fetchb();

        public int call() {
            CPU.CPU_SW_Interrupt(this.num, CPU_Regs.reg_eip + this.eip_count);
            CPU.cpu.trap_skip = true;
            return 3;
        }
    }

    public static final class Int3
    extends Op {
        public int call() {
            CPU.CPU_SW_Interrupt_NoIOPLCheck(3, CPU_Regs.reg_eip + this.eip_count);
            CPU.cpu.trap_skip = true;
            return 3;
        }
    }

    public static final class Retf
    extends Op {
        public int call() {
            Flags.FillFlags();
            CPU.CPU_RET(false, 0, CPU_Regs.reg_eip + this.eip_count);
            return 3;
        }
    }

    public static final class RetfIw
    extends Op {
        int words = Helper.decode_fetchw();

        public int call() {
            Flags.FillFlags();
            CPU.CPU_RET(false, this.words, CPU_Regs.reg_eip + this.eip_count);
            return 3;
        }
    }

    public static final class Leave
    extends Op {
        public int call() {
            CPU_Regs.reg_esp.dword &= CPU.cpu.stack.notmask;
            CPU_Regs.reg_esp.dword |= CPU_Regs.reg_ebp.dword & CPU.cpu.stack.mask;
            CPU_Regs.reg_ebp.word(CPU.CPU_Pop16());
            return 4;
        }
    }

    public static final class EnterIwIb
    extends Op {
        int bytes = Helper.decode_fetchw();
        int level = Helper.decode_fetchb();

        public int call() {
            CPU.CPU_ENTER(false, this.bytes, this.level);
            return 4;
        }
    }

    public static final class Lds
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public Lds(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa + 2))) {
                return this.RUNEXCEPTION();
            }
            this.rw.word(Memory.mem_readw(eaa));
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class Les
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rw;

        public Les(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa + 2))) {
                return this.RUNEXCEPTION();
            }
            this.rw.word(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class Retn
    extends Op {
        public int call() {
            CPU_Regs.reg_eip = CPU.CPU_Pop16();
            return 3;
        }
    }

    public static final class RetnIw
    extends Op {
        int offset = Helper.decode_fetchw();

        public int call() {
            CPU_Regs.reg_eip = CPU.CPU_Pop16();
            CPU_Regs.reg_esp.dword += this.offset;
            return 3;
        }
    }

    public static final class MovIw_mem
    extends Op {
        int ib;
        EaaBase get_eaa;

        public MovIw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, this.ib);
            return 4;
        }
    }

    public static final class MovIw
    extends Op {
        int ib = Helper.decode_fetchw();
        CPU_Regs.Reg reg;

        public MovIw(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.word(this.ib);
            return 4;
        }
    }

    public static final class MovIb_mem
    extends Op {
        short ib;
        EaaBase get_eaa;

        public MovIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, this.ib);
            return 4;
        }
    }

    public static final class MovIb
    extends Op {
        short ib = Helper.decode_fetchb();
        CPU_Regs.Reg reg;

        public MovIb(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.set8(this.ib);
            return 4;
        }
    }

    public static final class TestAxIw
    extends Op {
        int iw = Helper.decode_fetchw();

        public int call() {
            Instructions.TESTW(this.iw, CPU_Regs.reg_eax.word());
            return 4;
        }
    }

    public static final class TestAlIb
    extends Op {
        short ib = Helper.decode_fetchb();

        public int call() {
            Instructions.TESTB(this.ib, CPU_Regs.reg_eax.low());
            return 4;
        }
    }

    public static final class MovOwAX
    extends GetEADirect {
        public int call() {
            int eaa = Core.base_ds + this.value;
            Memory.mem_writew(eaa, CPU_Regs.reg_eax.word());
            return 4;
        }
    }

    public static final class MovObAL
    extends GetEADirect {
        public int call() {
            int eaa = Core.base_ds + this.value;
            Memory.mem_writeb(eaa, CPU_Regs.reg_eax.low());
            return 4;
        }
    }

    public static final class MovAXOw
    extends GetEADirect {
        public int call() {
            int eaa = Core.base_ds + this.value;
            CPU_Regs.reg_eax.word(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class MovALOb
    extends GetEADirect {
        public int call() {
            int eaa = Core.base_ds + this.value;
            CPU_Regs.reg_eax.low(Memory.mem_readb(eaa));
            return 4;
        }
    }

    public static abstract class GetEADirect
    extends Op {
        int value = (Helper.prefixes & 1) != 0 ? Helper.decode_fetchd() : Helper.decode_fetchw();
    }

    public static final class Lahf
    extends Op {
        public int call() {
            Flags.FillFlags();
            CPU_Regs.reg_eax.high(CPU_Regs.flags & 0xFF);
            return 4;
        }
    }

    public static final class Sahf
    extends Op {
        public int call() {
            Flags.SETFLAGSb(CPU_Regs.reg_eax.high());
            return 4;
        }
    }

    public static final class PopF
    extends Op {
        public int call() {
            if (CPU.CPU_POPF(false)) {
                return this.RUNEXCEPTION();
            }
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.DECODE_END(this.eip_count);
            }
            if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                return this.DECODE_END(this.eip_count);
            }
            return 4;
        }
    }

    public static final class PushF
    extends Op {
        public int call() {
            if (CPU.CPU_PUSHF(false)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class CallAp
    extends Op {
        int newcs;
        int newip;

        public CallAp(int newcs, int newip) {
            this.newcs = newcs;
            this.newip = newip;
        }

        public int call() {
            Flags.FillFlags();
            CPU.CPU_CALL(false, this.newcs, this.newip, CPU_Regs.reg_eip + this.eip_count);
            if (CPU_Regs.GETFLAG(256) != 0) {
                CPU.cpudecoder = Core_dynamic.CPU_Core_Dynrec_Trap_Run;
                return this.CB_NONE();
            }
            return 3;
        }
    }

    public static final class XchgAx
    extends Op {
        CPU_Regs.Reg reg;

        public XchgAx(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            int old = this.reg.word();
            this.reg.word(CPU_Regs.reg_eax.word());
            CPU_Regs.reg_eax.word(old);
            return 4;
        }
    }

    public static final class Noop
    extends Op {
        public int call() {
            return 4;
        }
    }

    public static final class PopEw_mem
    extends Op {
        EaaBase get_eaa;

        public PopEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int val = CPU.CPU_Pop16();
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, val);
            return 4;
        }
    }

    public static final class PopEw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public PopEw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.CPU_Pop16());
            return 4;
        }
    }

    public static final class MovGsEw_mem
    extends Op {
        EaaBase get_eaa;

        public MovGsEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa))) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovGsEw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovGsEw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (CPU.CPU_SetSegGeneralGS(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovFsEw_mem
    extends Op {
        EaaBase get_eaa;

        public MovFsEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa))) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovFsEw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovFsEw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (CPU.CPU_SetSegGeneralFS(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovDsEw_mem
    extends Op {
        EaaBase get_eaa;

        public MovDsEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa))) {
                return this.RUNEXCEPTION();
            }
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class MovDsEw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovDsEw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (CPU.CPU_SetSegGeneralDS(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class MovSsEw_mem
    extends Op {
        EaaBase get_eaa;

        public MovSsEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa))) {
                return this.RUNEXCEPTION();
            }
            Core.base_ss = CPU.Segs_SSphys;
            return 4;
        }
    }

    public static final class MovSsEw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovSsEw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (CPU.CPU_SetSegGeneralSS(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            Core.base_ss = CPU.Segs_SSphys;
            return 4;
        }
    }

    public static final class MovEsEw_mem
    extends Op {
        EaaBase get_eaa;

        public MovEsEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa))) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class MovEsEw_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovEsEw_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            if (CPU.CPU_SetSegGeneralES(this.earw.word())) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class LeaGw_32
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public LeaGw_32(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa32(rm);
        }

        public int call() {
            Core.base_ss = 0;
            Core.base_ds = 0;
            int eaa = this.get_eaa.call();
            this.rw.word(eaa);
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class LeaGw_16
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public LeaGw_16(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa16(rm);
        }

        public int call() {
            Core.base_ss = 0;
            Core.base_ds = 0;
            int eaa = this.get_eaa.call();
            this.rw.word(eaa);
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class Illegal
    extends Op {
        String msg;

        public Illegal(String msg) {
            this.msg = msg;
        }

        public int call() {
            Log.log(8, 2, this.msg);
            return 6;
        }
    }

    public static final class MovEwGs_mem
    extends Op {
        EaaBase get_eaa;

        public MovEwGs_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.Segs_GSval);
            return 4;
        }
    }

    public static final class MovEwGs_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovEwGs_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.Segs_GSval);
            return 4;
        }
    }

    public static final class MovEwFs_mem
    extends Op {
        EaaBase get_eaa;

        public MovEwFs_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.Segs_FSval);
            return 4;
        }
    }

    public static final class MovEwFs_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovEwFs_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.Segs_FSval);
            return 4;
        }
    }

    public static final class MovEwDs_mem
    extends Op {
        EaaBase get_eaa;

        public MovEwDs_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.Segs_DSval);
            return 4;
        }
    }

    public static final class MovEwDs_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovEwDs_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.Segs_DSval);
            return 4;
        }
    }

    public static final class MovEwSs_mem
    extends Op {
        EaaBase get_eaa;

        public MovEwSs_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.Segs_SSval);
            return 4;
        }
    }

    public static final class MovEwSs_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovEwSs_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.Segs_SSval);
            return 4;
        }
    }

    public static final class MovEwCs_mem
    extends Op {
        EaaBase get_eaa;

        public MovEwCs_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.Segs_CSval);
            return 4;
        }
    }

    public static final class MovEwCs_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovEwCs_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.Segs_CSval);
            return 4;
        }
    }

    public static final class MovEwEs_mem
    extends Op {
        EaaBase get_eaa;

        public MovEwEs_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, CPU.Segs_ESval);
            return 4;
        }
    }

    public static final class MovEwEs_reg
    extends Op {
        CPU_Regs.Reg earw;

        public MovEwEs_reg(int rm) {
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(CPU.Segs_ESval);
            return 4;
        }
    }

    public static final class MovGwEw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public MovGwEw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rw.word(Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class MovGwEw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public MovGwEw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.rw.word(this.earw.word());
            return 4;
        }
    }

    public static final class MovGbEb_mem
    extends Op {
        CPU_Regs.Reg rb;
        EaaBase get_eaa;

        public MovGbEb_mem(int rm) {
            this.rb = Mod.gb(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rb.set8(Memory.mem_readb(eaa));
            return 4;
        }
    }

    public static final class MovGbEb_reg
    extends Op {
        CPU_Regs.Reg rb;
        CPU_Regs.Reg earb;

        public MovGbEb_reg(int rm) {
            this.rb = Mod.gb(rm);
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.rb.set8(this.earb.get8());
            return 4;
        }
    }

    public static final class MovEwGw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public MovEwGw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, this.rw.word());
            return 4;
        }
    }

    public static final class MovEwGw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public MovEwGw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.earw.word(this.rw.word());
            return 4;
        }
    }

    public static final class MovEbGb_mem_5
    extends Op {
        CPU_Regs.Reg rb;
        EaaBase get_eaa;

        public MovEbGb_mem_5(int rm) {
            this.rb = Mod.gb(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            if (CPU.cpu.pmode && !CPU.cpu.code.big) {
                CPU.cpu.gdt.GetDescriptor(CPU.seg_value(Core.base_val_ds), desc);
                if (desc.Type() == 26 || desc.Type() == 27) {
                    CPU.CPU_Exception(13, CPU.seg_value(Core.base_val_ds) & 0xFFFC);
                    return 3;
                }
            }
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, this.rb.get8());
            return 4;
        }
    }

    public static final class MovEbGb_mem
    extends Op {
        CPU_Regs.Reg rb;
        EaaBase get_eaa;

        public MovEbGb_mem(int rm) {
            this.rb = Mod.gb(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, this.rb.get8());
            return 4;
        }
    }

    public static final class MovEbGb_reg
    extends Op {
        CPU_Regs.Reg rb;
        CPU_Regs.Reg earb;

        public MovEbGb_reg(int rm) {
            this.rb = Mod.gb(rm);
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.earb.set8(this.rb.get8());
            return 4;
        }
    }

    public static final class XchgEwGw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public XchgEwGw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int oldrmrw = this.rw.word();
            int eaa = this.get_eaa.call();
            int newrw = Memory.mem_readw(eaa);
            Memory.mem_writew(eaa, oldrmrw);
            this.rw.word(newrw);
            return 4;
        }
    }

    public static final class XchgEwGw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public XchgEwGw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            int oldrmrw = this.rw.word();
            this.rw.word(this.earw.word());
            this.earw.word(oldrmrw);
            return 4;
        }
    }

    public static final class XchgEbGb_mem
    extends Op {
        CPU_Regs.Reg rb;
        EaaBase get_eaa;

        public XchgEbGb_mem(int rm) {
            this.rb = Mod.gb(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            short oldrmrb = this.rb.get8();
            int eaa = this.get_eaa.call();
            short newrb = Memory.mem_readb(eaa);
            Memory.mem_writeb(eaa, oldrmrb);
            this.rb.set8(newrb);
            return 4;
        }
    }

    public static final class XchgEbGb_reg
    extends Op {
        CPU_Regs.Reg rb;
        CPU_Regs.Reg earb;

        public XchgEbGb_reg(int rm) {
            this.rb = Mod.gb(rm);
            this.earb = Mod.eb(rm);
        }

        public int call() {
            short oldrmrb = this.rb.get8();
            this.rb.set8(this.earb.get8());
            this.earb.set8(oldrmrb);
            return 4;
        }
    }

    public static final class TestEwGw_mem
    extends Op {
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public TestEwGw_mem(int rm) {
            this.rw = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Instructions.TESTW(this.rw.word(), Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class TestEwGw_reg
    extends Op {
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public TestEwGw_reg(int rm) {
            this.rw = Mod.gw(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            Instructions.TESTW(this.rw.word(), this.earw.word());
            return 4;
        }
    }

    public static final class TestEbGb_mem
    extends Op {
        CPU_Regs.Reg rb;
        EaaBase get_eaa;

        public TestEbGb_mem(int rm) {
            this.rb = Mod.gb(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Instructions.TESTB(this.rb.get8(), Memory.mem_readb(eaa));
            return 4;
        }
    }

    public static final class TestEbGb_reg
    extends Op {
        CPU_Regs.Reg rb;
        CPU_Regs.Reg earb;

        public TestEbGb_reg(int rm) {
            this.rb = Mod.gb(rm);
            this.earb = Mod.eb(rm);
        }

        public int call() {
            Instructions.TESTB(this.rb.get8(), this.earb.get8());
            return 4;
        }
    }

    public static final class GrplEwIw_mem_cmp
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_cmp(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Instructions.CMPW(this.ib, Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class GrplEwIw_mem_xor
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_xor(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.XORW(this.ib, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class GrplEwIw_mem_sub
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_sub(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.SUBW(this.ib, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class GrplEwIw_mem_and
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_and(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.ANDW(this.ib, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class GrplEwIw_mem_sbb
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_sbb(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.SBBW(this.ib, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class GrplEwIw_mem_adc
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_adc(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.ADCW(this.ib, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class GrplEwIw_mem_or
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_or(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.ORW(this.ib, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class GrplEwIw_mem_add
    extends Op {
        int ib;
        EaaBase get_eaa;

        public GrplEwIw_mem_add(int rm, boolean signed) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writew(eaa, Instructions.ADDW(this.ib, Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class GrplEwIw_reg_cmp
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_cmp(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            Instructions.CMPW(this.ib, this.earw.word());
            return 4;
        }
    }

    public static final class GrplEwIw_reg_xor
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_xor(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            this.earw.word(Instructions.XORW(this.ib, this.earw.word()));
            return 4;
        }
    }

    public static final class GrplEwIw_reg_sub
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_sub(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            this.earw.word(Instructions.SUBW(this.ib, this.earw.word()));
            return 4;
        }
    }

    public static final class GrplEwIw_reg_and
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_and(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            this.earw.word(Instructions.ANDW(this.ib, this.earw.word()));
            return 4;
        }
    }

    public static final class GrplEwIw_reg_sbb
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_sbb(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            this.earw.word(Instructions.SBBW(this.ib, this.earw.word()));
            return 4;
        }
    }

    public static final class GrplEwIw_reg_adc
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_adc(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            this.earw.word(Instructions.ADCW(this.ib, this.earw.word()));
            return 4;
        }
    }

    public static final class GrplEwIw_reg_or
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_or(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            this.earw.word(Instructions.ORW(this.ib, this.earw.word()));
            return 4;
        }
    }

    public static final class GrplEwIw_reg_add
    extends Op {
        CPU_Regs.Reg earw;
        int ib;

        public GrplEwIw_reg_add(int rm, boolean signed) {
            this.earw = Mod.ew(rm);
            this.ib = signed ? (short)Helper.decode_fetchbs() & 0xFFFF : Helper.decode_fetchw();
        }

        public int call() {
            this.earw.word(Instructions.ADDW(this.ib, this.earw.word()));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_cmp
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_cmp(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Instructions.CMPB(this.ib, Memory.mem_readb(eaa));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_xor
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_xor(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.XORB(this.ib, Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_sub
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_sub(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.SUBB(this.ib, Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_and
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_and(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.ANDB(this.ib, Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_sbb
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_sbb(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.SBBB(this.ib, Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_adc
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_adc(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.ADCB(this.ib, Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_or
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_or(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.ORB(this.ib, Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class GrplEbIb_mem_add
    extends Op {
        short ib;
        EaaBase get_eaa;

        public GrplEbIb_mem_add(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Memory.mem_writeb(eaa, Instructions.ADDB(this.ib, Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class GrplEbIb_reg_cmp
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_cmp(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            Instructions.CMPB(this.ib, this.earb.get8());
            return 4;
        }
    }

    public static final class GrplEbIb_reg_xor
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_xor(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            this.earb.set8(Instructions.XORB(this.ib, this.earb.get8()));
            return 4;
        }
    }

    public static final class GrplEbIb_reg_sub
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_sub(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            this.earb.set8(Instructions.SUBB(this.ib, this.earb.get8()));
            return 4;
        }
    }

    public static final class GrplEbIb_reg_and
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_and(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            this.earb.set8(Instructions.ANDB(this.ib, this.earb.get8()));
            return 4;
        }
    }

    public static final class GrplEbIb_reg_sbb
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_sbb(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            this.earb.set8(Instructions.SBBB(this.ib, this.earb.get8()));
            return 4;
        }
    }

    public static final class GrplEbIb_reg_adc
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_adc(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            this.earb.set8(Instructions.ADCB(this.ib, this.earb.get8()));
            return 4;
        }
    }

    public static final class GrplEbIb_reg_or
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_or(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            this.earb.set8(Instructions.ORB(this.ib, this.earb.get8()));
            return 4;
        }
    }

    public static final class GrplEbIb_reg_add
    extends Op {
        CPU_Regs.Reg earb;
        short ib;

        public GrplEbIb_reg_add(int rm) {
            this.earb = Mod.eb(rm);
            this.ib = Helper.decode_fetchb();
        }

        public int call() {
            this.earb.set8(Instructions.ADDB(this.ib, this.earb.get8()));
            return 4;
        }
    }

    public static final class JumpCond16_b_nle
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NLE(), this.offset);
        }
    }

    public static final class JumpCond16_b_le
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_LE(), this.offset);
        }
    }

    public static final class JumpCond16_b_nl
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NL(), this.offset);
        }
    }

    public static final class JumpCond16_b_l
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_L(), this.offset);
        }
    }

    public static final class JumpCond16_b_np
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NP(), this.offset);
        }
    }

    public static final class JumpCond16_b_p
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_P(), this.offset);
        }
    }

    public static final class JumpCond16_b_ns
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NS(), this.offset);
        }
    }

    public static final class JumpCond16_b_s
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_S(), this.offset);
        }
    }

    public static final class JumpCond16_b_nbe
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NBE(), this.offset);
        }
    }

    public static final class JumpCond16_b_be
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_BE(), this.offset);
        }
    }

    public static final class JumpCond16_b_nz
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NZ(), this.offset);
        }
    }

    public static final class JumpCond16_b_z
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_Z(), this.offset);
        }
    }

    public static final class JumpCond16_b_nb
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NB(), this.offset);
        }
    }

    public static final class JumpCond16_b_b
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_B(), this.offset);
        }
    }

    public static final class JumpCond16_b_no
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_NO(), this.offset);
        }
    }

    public static final class JumpCond16_b_o
    extends JumpCond16_b {
        public int call() {
            return this.jump(Flags.TFLG_O(), this.offset);
        }
    }

    public static abstract class JumpCond16_b
    extends Op {
        int offset = Helper.decode_fetchbs();

        protected final int jump(boolean COND, int off) {
            if (COND) {
                CPU_Regs.reg_ip(CPU_Regs.reg_ip() + off + this.eip_count);
                return 1;
            }
            CPU_Regs.reg_ip(CPU_Regs.reg_ip() + this.eip_count);
            return 2;
        }
    }

    public static final class IMULGwEwIb_mem
    extends Op {
        int op3;
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public IMULGwEwIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.op3 = Helper.decode_fetchbs();
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rw.word(Instructions.DIMULW(Memory.mem_readw(eaa), this.op3));
            return 4;
        }
    }

    public static final class IMULGwEwIb_reg
    extends Op {
        int op3 = Helper.decode_fetchbs();
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public IMULGwEwIb_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            this.rw.word(Instructions.DIMULW(this.earw.word(), this.op3));
            return 4;
        }
    }

    public static final class IMULGwEwIw_mem
    extends Op {
        int op3;
        CPU_Regs.Reg rw;
        EaaBase get_eaa;

        public IMULGwEwIw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.op3 = Helper.decode_fetchws();
            this.rw = Mod.gw(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rw.word(Instructions.DIMULW(Memory.mem_readw(eaa), this.op3));
            return 4;
        }
    }

    public static final class IMULGwEwIw_reg
    extends Op {
        int op3 = Helper.decode_fetchws();
        CPU_Regs.Reg rw;
        CPU_Regs.Reg earw;

        public IMULGwEwIw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            this.rw.word(Instructions.DIMULW(this.earw.word(), this.op3));
            return 4;
        }
    }

    public static final class Push16
    extends Op {
        int value;

        public Push16(int value) {
            this.value = value;
        }

        public int call() {
            CPU.CPU_Push16(this.value);
            return 4;
        }
    }

    public static final class ArplEwRw_mem
    extends Op {
        EaaBase get_eaa;
        IntRef ref = new IntRef(0);
        CPU_Regs.Reg rw;

        public ArplEwRw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            int eaa = this.get_eaa.call();
            this.ref.value = Memory.mem_readw(eaa);
            CPU.CPU_ARPL(this.ref, this.rw.word());
            Memory.mem_writew(eaa, this.ref.value);
            return 4;
        }
    }

    public static final class ArplEwRw_reg
    extends Op {
        IntRef ref = new IntRef(0);
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rw;

        public ArplEwRw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rw = Mod.gw(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.ref.value = this.earw.word();
            CPU.CPU_ARPL(this.ref, this.rw.word());
            this.earw.word(this.ref.value);
            return 4;
        }
    }

    public static final class Bound
    extends Op {
        CPU_Regs.Reg reg;
        EaaBase get_eaa;

        public Bound() {
            short rm = Helper.decode_fetchb();
            this.reg = Mod.gw(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            short bound_min = (short)Memory.mem_readw(eaa);
            short bound_max = (short)Memory.mem_readw(eaa + 2);
            if ((short)this.reg.word() < bound_min || (short)this.reg.word() > bound_max) {
                return this.EXCEPTION(5);
            }
            return 4;
        }
    }

    public static final class Popa
    extends Op {
        public int call() {
            CPU_Regs.reg_edi.word(CPU.CPU_Pop16());
            CPU_Regs.reg_esi.word(CPU.CPU_Pop16());
            CPU_Regs.reg_ebp.word(CPU.CPU_Pop16());
            CPU.CPU_Pop16();
            CPU_Regs.reg_ebx.word(CPU.CPU_Pop16());
            CPU_Regs.reg_edx.word(CPU.CPU_Pop16());
            CPU_Regs.reg_ecx.word(CPU.CPU_Pop16());
            CPU_Regs.reg_eax.word(CPU.CPU_Pop16());
            return 4;
        }
    }

    public static final class Pusha
    extends Op {
        public int call() {
            int old_sp = CPU_Regs.reg_esp.word();
            CPU.CPU_Push16(CPU_Regs.reg_eax.word());
            CPU.CPU_Push16(CPU_Regs.reg_ecx.word());
            CPU.CPU_Push16(CPU_Regs.reg_edx.word());
            CPU.CPU_Push16(CPU_Regs.reg_ebx.word());
            CPU.CPU_Push16(old_sp);
            CPU.CPU_Push16(CPU_Regs.reg_ebp.word());
            CPU.CPU_Push16(CPU_Regs.reg_esi.word());
            CPU.CPU_Push16(CPU_Regs.reg_edi.word());
            return 4;
        }
    }

    public static final class DoString
    extends Op {
        int type;
        int prefixes = Helper.prefixes;
        boolean rep_zero;

        public DoString(int type) {
            this.type = type;
            this.rep_zero = Core.rep_zero;
        }

        public int call() {
            Core.rep_zero = this.rep_zero;
            StringOp.DoString(this.prefixes, this.type);
            return 4;
        }
    }

    public static final class DoStringException
    extends Op {
        int type;
        int width;
        int prefixes;
        boolean rep_zero;

        public DoStringException(int type, int width) {
            this.type = type;
            this.width = width;
            this.prefixes = Helper.prefixes;
            this.rep_zero = Core.rep_zero;
        }

        public int call() {
            if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), this.width)) {
                return this.RUNEXCEPTION();
            }
            Core.rep_zero = this.rep_zero;
            StringOp.DoString(this.prefixes, this.type);
            return 4;
        }
    }

    public static final class Popw
    extends Op {
        CPU_Regs.Reg reg;

        public Popw(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.word(CPU.CPU_Pop16());
            return 4;
        }
    }

    public static final class Pushw
    extends Op {
        CPU_Regs.Reg reg;

        public Pushw(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            CPU.CPU_Push16(this.reg.word());
            return 4;
        }
    }

    public static final class Decw
    extends Op {
        CPU_Regs.Reg reg;

        public Decw(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            Flags.LoadCF();
            Flags.lf_var1w(this.reg.word());
            Flags.lf_resw(Flags.lf_var1w() - 1);
            this.reg.word(Flags.lf_resw());
            Flags.lflags.type = 29;
            return 4;
        }
    }

    public static final class Incw
    extends Op {
        CPU_Regs.Reg reg;

        public Incw(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            Flags.LoadCF();
            Flags.lf_var1w(this.reg.word());
            Flags.lf_resw(Flags.lf_var1w() + 1);
            this.reg.word(Flags.lf_resw());
            Flags.lflags.type = 26;
            return 4;
        }
    }

    public static final class Aas
    extends Op {
        public int call() {
            Instructions.AAS();
            return 4;
        }
    }

    public static final class Aaa
    extends Op {
        public int call() {
            Instructions.AAA();
            return 4;
        }
    }

    public static final class Das
    extends Op {
        public int call() {
            Instructions.DAS();
            return 4;
        }
    }

    public static final class Daa
    extends Op {
        public int call() {
            Instructions.DAA();
            return 4;
        }
    }

    public static final class SegGS
    extends Op {
        public int call() {
            Core.DO_PREFIX_SEG_GS();
            return 4;
        }
    }

    public static final class SegFS
    extends Op {
        public int call() {
            Core.DO_PREFIX_SEG_FS();
            return 4;
        }
    }

    public static final class SegDS
    extends Op {
        public int call() {
            Core.DO_PREFIX_SEG_DS();
            return 4;
        }
    }

    public static final class SegSS
    extends Op {
        public int call() {
            Core.DO_PREFIX_SEG_SS();
            return 4;
        }
    }

    public static final class SegCS
    extends Op {
        public int call() {
            Core.DO_PREFIX_SEG_CS();
            return 4;
        }
    }

    public static final class SegES
    extends Op {
        public int call() {
            Core.DO_PREFIX_SEG_ES();
            return 4;
        }
    }

    public static final class PopDS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegDS(false)) {
                return this.RUNEXCEPTION();
            }
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class PushDS
    extends Op {
        public int call() {
            CPU.CPU_Push16(CPU.Segs_DSval);
            return 4;
        }
    }

    public static final class PopSS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegSS(false)) {
                return this.RUNEXCEPTION();
            }
            Core.base_ss = CPU.Segs_SSphys;
            return 4;
        }
    }

    public static final class PushSS
    extends Op {
        public int call() {
            CPU.CPU_Push16(CPU.Segs_SSval);
            return 4;
        }
    }

    public static final class PushCS
    extends Op {
        public int call() {
            CPU.CPU_Push16(CPU.Segs_CSval);
            return 4;
        }
    }

    public static final class PopES
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegES(false)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class PushES
    extends Op {
        public int call() {
            CPU.CPU_Push16(CPU.Segs_ESval);
            return 4;
        }
    }

    public static final class CmpAxIw
    extends Op {
        int i;

        public CmpAxIw(int i) {
            this.i = i;
        }

        public int call() {
            Instructions.CMPW(this.i, CPU_Regs.reg_eax.word());
            return 4;
        }
    }

    public static final class CmpAlIb
    extends Op {
        short i;

        public CmpAlIb(short i) {
            this.i = i;
        }

        public int call() {
            Instructions.CMPB(this.i, CPU_Regs.reg_eax.low());
            return 4;
        }
    }

    public static final class CmpGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public CmpGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            Instructions.CMPW(Memory.mem_readw(eaa), this.e.word());
            return 4;
        }
    }

    public static final class CmpEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public CmpEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Instructions.CMPW(this.g.word(), Memory.mem_readw(eaa));
            return 4;
        }
    }

    public static final class Cmpw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Cmpw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            Instructions.CMPW(this.g.word(), this.e.word());
            return 4;
        }
    }

    public static final class CmpGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public CmpGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            Instructions.CMPB(Memory.mem_readb(eaa), this.e.get8());
            return 4;
        }
    }

    public static final class CmpEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public CmpEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Instructions.CMPB(this.g.get8(), Memory.mem_readb(eaa));
            return 4;
        }
    }

    public static final class Cmpb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Cmpb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            Instructions.CMPB(this.g.get8(), this.e.get8());
            return 4;
        }
    }

    public static final class XorAxIw
    extends Op {
        int i;

        public XorAxIw(int i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.word(Instructions.XORW(this.i, CPU_Regs.reg_eax.word()));
            return 4;
        }
    }

    public static final class XorAlIb
    extends Op {
        short i;

        public XorAlIb(short i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.low(Instructions.XORB(this.i, CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class XorGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public XorGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.word(Instructions.XORW(Memory.mem_readw(eaa), this.e.word()));
            return 4;
        }
    }

    public static final class XorEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public XorEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writew(eaa, Instructions.XORW(this.g.word(), Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Xorw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Xorw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.word(Instructions.XORW(this.g.word(), this.e.word()));
            return 4;
        }
    }

    public static final class XorGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public XorGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.set8(Instructions.XORB(Memory.mem_readb(eaa), this.e.get8()));
            return 4;
        }
    }

    public static final class XorEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public XorEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writeb(eaa, Instructions.XORB(this.g.get8(), Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Xorb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Xorb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.set8(Instructions.XORB(this.g.get8(), this.e.get8()));
            return 4;
        }
    }

    public static final class SubAxIw
    extends Op {
        int i;

        public SubAxIw(int i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.word(Instructions.SUBW(this.i, CPU_Regs.reg_eax.word()));
            return 4;
        }
    }

    public static final class SubAlIb
    extends Op {
        short i;

        public SubAlIb(short i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.low(Instructions.SUBB(this.i, CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class SubGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public SubGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.word(Instructions.SUBW(Memory.mem_readw(eaa), this.e.word()));
            return 4;
        }
    }

    public static final class SubEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public SubEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writew(eaa, Instructions.SUBW(this.g.word(), Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Subw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Subw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.word(Instructions.SUBW(this.g.word(), this.e.word()));
            return 4;
        }
    }

    public static final class SubGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public SubGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.set8(Instructions.SUBB(Memory.mem_readb(eaa), this.e.get8()));
            return 4;
        }
    }

    public static final class SubEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public SubEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writeb(eaa, Instructions.SUBB(this.g.get8(), Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Subb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Subb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.set8(Instructions.SUBB(this.g.get8(), this.e.get8()));
            return 4;
        }
    }

    public static final class AndAxIw
    extends Op {
        int i;

        public AndAxIw(int i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.word(Instructions.ANDW(this.i, CPU_Regs.reg_eax.word()));
            return 4;
        }
    }

    public static final class AndAlIb
    extends Op {
        short i;

        public AndAlIb(short i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.low(Instructions.ANDB(this.i, CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class AndGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AndGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.word(Instructions.ANDW(Memory.mem_readw(eaa), this.e.word()));
            return 4;
        }
    }

    public static final class AndEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AndEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writew(eaa, Instructions.ANDW(this.g.word(), Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Andw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Andw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.word(Instructions.ANDW(this.g.word(), this.e.word()));
            return 4;
        }
    }

    public static final class AndGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AndGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.set8(Instructions.ANDB(Memory.mem_readb(eaa), this.e.get8()));
            return 4;
        }
    }

    public static final class AndEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AndEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writeb(eaa, Instructions.ANDB(this.g.get8(), Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Andb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Andb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.set8(Instructions.ANDB(this.g.get8(), this.e.get8()));
            return 4;
        }
    }

    public static final class SbbAxIw
    extends Op {
        int i;

        public SbbAxIw(int i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.word(Instructions.SBBW(this.i, CPU_Regs.reg_eax.word()));
            return 4;
        }
    }

    public static final class SbbAlIb
    extends Op {
        short i;

        public SbbAlIb(short i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.low(Instructions.SBBB(this.i, CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class SbbGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public SbbGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.word(Instructions.SBBW(Memory.mem_readw(eaa), this.e.word()));
            return 4;
        }
    }

    public static final class SbbEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public SbbEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writew(eaa, Instructions.SBBW(this.g.word(), Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Sbbw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Sbbw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.word(Instructions.SBBW(this.g.word(), this.e.word()));
            return 4;
        }
    }

    public static final class SbbGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public SbbGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.set8(Instructions.SBBB(Memory.mem_readb(eaa), this.e.get8()));
            return 4;
        }
    }

    public static final class SbbEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public SbbEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writeb(eaa, Instructions.SBBB(this.g.get8(), Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Sbbb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Sbbb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.set8(Instructions.SBBB(this.g.get8(), this.e.get8()));
            return 4;
        }
    }

    public static final class AdcAxIw
    extends Op {
        int i;

        public AdcAxIw(int i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.word(Instructions.ADCW(this.i, CPU_Regs.reg_eax.word()));
            return 4;
        }
    }

    public static final class AdcAlIb
    extends Op {
        short i;

        public AdcAlIb(short i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.low(Instructions.ADCB(this.i, CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class AdcGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AdcGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.word(Instructions.ADCW(Memory.mem_readw(eaa), this.e.word()));
            return 4;
        }
    }

    public static final class AdcEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AdcEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writew(eaa, Instructions.ADCW(this.g.word(), Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Adcw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Adcw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.word(Instructions.ADCW(this.g.word(), this.e.word()));
            return 4;
        }
    }

    public static final class AdcGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AdcGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.set8(Instructions.ADCB(Memory.mem_readb(eaa), this.e.get8()));
            return 4;
        }
    }

    public static final class AdcEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AdcEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writeb(eaa, Instructions.ADCB(this.g.get8(), Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Adcb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Adcb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.set8(Instructions.ADCB(this.g.get8(), this.e.get8()));
            return 4;
        }
    }

    public static final class OrAxIw
    extends Op {
        int i;

        public OrAxIw(int i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.word(Instructions.ORW(this.i, CPU_Regs.reg_eax.word()));
            return 4;
        }
    }

    public static final class OrAlIb
    extends Op {
        short i;

        public OrAlIb(short i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.low(Instructions.ORB(this.i, CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class OrGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public OrGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.word(Instructions.ORW(Memory.mem_readw(eaa), this.e.word()));
            return 4;
        }
    }

    public static final class OrEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public OrEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writew(eaa, Instructions.ORW(this.g.word(), Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Orw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Orw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.word(Instructions.ORW(this.g.word(), this.e.word()));
            return 4;
        }
    }

    public static final class OrGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public OrGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.set8(Instructions.ORB(Memory.mem_readb(eaa), this.e.get8()));
            return 4;
        }
    }

    public static final class OrEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public OrEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writeb(eaa, Instructions.ORB(this.g.get8(), Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Orb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Orb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.set8(Instructions.ORB(this.g.get8(), this.e.get8()));
            return 4;
        }
    }

    public static final class AddAxIw
    extends Op {
        int i;

        public AddAxIw(int i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.word(Instructions.ADDW(this.i, CPU_Regs.reg_eax.word()));
            return 4;
        }
    }

    public static final class AddAlIb
    extends Op {
        short i;

        public AddAlIb(short i) {
            this.i = i;
        }

        public int call() {
            CPU_Regs.reg_eax.low(Instructions.ADDB(this.i, CPU_Regs.reg_eax.low()));
            return 4;
        }
    }

    public static final class AddGwEw_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AddGwEw_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.word(Instructions.ADDW(Memory.mem_readw(eaa), this.e.word()));
            return 4;
        }
    }

    public static final class AddEwGw_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AddEwGw_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writew(eaa, Instructions.ADDW(this.g.word(), Memory.mem_readw(eaa)));
            return 4;
        }
    }

    public static final class Addw_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Addw_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.word(Instructions.ADDW(this.g.word(), this.e.word()));
            return 4;
        }
    }

    public static final class AddGbEb_mem
    extends Op {
        EaaBase g;
        CPU_Regs.Reg e;

        public AddGbEb_mem(CPU_Regs.Reg e, EaaBase g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.g.call();
            this.e.set8(Instructions.ADDB(Memory.mem_readb(eaa), this.e.get8()));
            return 4;
        }
    }

    public static final class AddEbGb_mem
    extends Op {
        EaaBase e;
        CPU_Regs.Reg g;

        public AddEbGb_mem(EaaBase e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            int eaa = this.e.call();
            Memory.mem_writeb(eaa, Instructions.ADDB(this.g.get8(), Memory.mem_readb(eaa)));
            return 4;
        }
    }

    public static final class Addb_reg
    extends Op {
        CPU_Regs.Reg e;
        CPU_Regs.Reg g;

        public Addb_reg(CPU_Regs.Reg e, CPU_Regs.Reg g) {
            this.e = e;
            this.g = g;
        }

        public int call() {
            this.e.set8(Instructions.ADDB(this.g.get8(), this.e.get8()));
            return 4;
        }
    }
}

