/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.core_dynamic.EaaBase;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Mod;
import jdos.cpu.core_dynamic.Op;
import jdos.hardware.Memory;
import jdos.util.IntRef;

public class Inst4
extends Helper {

    public static final class Bswapd
    extends Op {
        CPU_Regs.Reg reg;

        public Bswapd(CPU_Regs.Reg reg) {
            this.reg = reg;
        }

        public int call() {
            this.reg.dword = Instructions.BSWAPD(this.reg.dword);
            return 4;
        }
    }

    public static final class XaddGdEd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public XaddGdEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int oldrmrd = this.rd.dword;
            int val = Memory.mem_readd(eaa);
            Memory.mem_writed(eaa, val + oldrmrd);
            this.rd.dword = val;
            return 4;
        }
    }

    public static final class XaddGdEd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public XaddGdEd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int oldrmrd = this.rd.dword;
            this.rd.dword = this.eard.dword;
            this.eard.dword += oldrmrd;
            return 4;
        }
    }

    public static final class MovsxGdEw_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public MovsxGdEw_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = (short)Memory.mem_readw(eaa);
            return 4;
        }
    }

    public static final class MovsxGdEw_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rd;

        public MovsxGdEw_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            this.rd.dword = (short)this.earw.word();
            return 4;
        }
    }

    public static final class MovsxGdEb_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public MovsxGdEb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = (byte)Memory.mem_readb(eaa);
            return 4;
        }
    }

    public static final class MovsxGdEb_reg
    extends Op {
        CPU_Regs.Reg earb;
        CPU_Regs.Reg rd;

        public MovsxGdEb_reg(int rm) {
            this.earb = Mod.eb(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            this.rd.dword = (byte)this.earb.get8();
            return 4;
        }
    }

    public static final class BsrGdEd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public BsrGdEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int value = Memory.mem_readd(eaa);
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 31;
                while ((value & Integer.MIN_VALUE) == 0) {
                    --result;
                    value <<= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rd.dword = result;
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BsrGdEd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public BsrGdEd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int value = this.eard.dword;
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 31;
                while ((value & Integer.MIN_VALUE) == 0) {
                    --result;
                    value <<= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rd.dword = result;
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BsfGdEd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public BsfGdEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            int value = Memory.mem_readd(eaa);
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 0;
                while ((value & 1) == 0) {
                    ++result;
                    value >>>= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rd.dword = result;
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BsfGdEd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public BsfGdEd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int value = this.eard.dword;
            if (value == 0) {
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                int result = 0;
                while ((value & 1) == 0) {
                    ++result;
                    value >>>= 1;
                }
                CPU_Regs.SETFLAGBIT(64, false);
                this.rd.dword = result;
            }
            Flags.lflags.type = 0;
            return 4;
        }
    }

    public static final class BtcEdGd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public BtcEdGd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rd.dword & 0x1F);
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readd(eaa += (this.rd.dword >> 5) * 4);
            CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
            Memory.mem_writed(eaa, old ^ mask);
            return 4;
        }
    }

    public static final class BtcEdGd_reg
    extends Op {
        CPU_Regs.Reg eard;
        CPU_Regs.Reg rd;

        public BtcEdGd_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rd.dword & 0x1F);
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & mask) != 0);
            this.eard.dword ^= mask;
            return 4;
        }
    }

    public static final class BtcEdIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtcEdIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readd(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            old = CPU_Regs.GETFLAG(1) != 0 ? (old &= ~this.mask) : (old |= this.mask);
            Memory.mem_writed(eaa, old);
            return 4;
        }
    }

    public static final class BtrEdIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtrEdIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readd(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            Memory.mem_writed(eaa, old & ~this.mask);
            return 4;
        }
    }

    public static final class BtsEdIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtsEdIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readd(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            Memory.mem_writed(eaa, old | this.mask);
            return 4;
        }
    }

    public static final class BtEdIb_mem
    extends Op {
        EaaBase get_eaa;
        int mask;

        public BtEdIb_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readd(eaa);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            return 4;
        }
    }

    public static final class BtcEdIb_reg
    extends Op {
        CPU_Regs.Reg eard;
        int mask;

        public BtcEdIb_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & this.mask) != 0);
            this.eard.dword = CPU_Regs.GETFLAG(1) != 0 ? (this.eard.dword &= ~this.mask) : (this.eard.dword |= this.mask);
            return 4;
        }
    }

    public static final class BtrEdIb_reg
    extends Op {
        CPU_Regs.Reg eard;
        int mask;

        public BtrEdIb_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & this.mask) != 0);
            this.eard.dword &= ~this.mask;
            return 4;
        }
    }

    public static final class BtsEdIb_reg
    extends Op {
        CPU_Regs.Reg eard;
        int mask;

        public BtsEdIb_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & this.mask) != 0);
            this.eard.dword |= this.mask;
            return 4;
        }
    }

    public static final class BtEdIb_reg
    extends Op {
        CPU_Regs.Reg eard;
        int mask;

        public BtEdIb_reg(int rm) {
            this.eard = Mod.ed(rm);
            this.mask = 1 << (Helper.decode_fetchb() & 0x1F);
        }

        public int call() {
            Flags.FillFlags();
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & this.mask) != 0);
            return 4;
        }
    }

    public static final class MovzxGdEw_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public MovzxGdEw_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = Memory.mem_readw(eaa);
            return 4;
        }
    }

    public static final class MovzxGdEw_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg earw;

        public MovzxGdEw_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.earw = Mod.ew(rm);
        }

        public int call() {
            this.rd.dword = this.earw.word();
            return 4;
        }
    }

    public static final class MovzxGdEb_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public MovzxGdEb_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = Memory.mem_readb(eaa);
            return 4;
        }
    }

    public static final class MovzxGdEb_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg earb;

        public MovzxGdEb_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.earb = Mod.eb(rm);
        }

        public int call() {
            this.rd.dword = this.earb.get8();
            return 4;
        }
    }

    public static final class LgsEd
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public LgsEd(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa + 4))) {
                return this.RUNEXCEPTION();
            }
            this.rd.dword = Memory.mem_readd(eaa);
            return 4;
        }
    }

    public static final class LfsEd
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public LfsEd(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa + 4))) {
                return this.RUNEXCEPTION();
            }
            this.rd.dword = Memory.mem_readd(eaa);
            return 4;
        }
    }

    public static final class BtrEdGd_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public BtrEdGd_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            Flags.FillFlags();
            int mask = 1 << (this.rd.dword & 0x1F);
            int old = Memory.mem_readd(eaa += (this.rd.dword >> 5) * 4);
            CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
            Memory.mem_writed(eaa, old & ~mask);
            return 4;
        }
    }

    public static final class BtrEdGd_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public BtrEdGd_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            Flags.FillFlags();
            int mask = 1 << (this.rd.dword & 0x1F);
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & mask) != 0);
            this.eard.dword &= ~mask;
            return 4;
        }
    }

    public static final class LssEd
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public LssEd(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa + 4))) {
                return this.RUNEXCEPTION();
            }
            this.rd.dword = Memory.mem_readd(eaa);
            Core.base_ds = CPU.Segs_DSphys;
            Core.base_ss = CPU.Segs_SSphys;
            Core.base_val_ds = 3;
            return 4;
        }
    }

    public static final class CmpxchgEdGd_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public CmpxchgEdGd_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            Flags.FillFlags();
            int eaa = this.get_eaa.call();
            int val = Memory.mem_readd(eaa);
            if (CPU_Regs.reg_eax.dword == val) {
                Memory.mem_writed(eaa, this.rd.dword);
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                Memory.mem_writed(eaa, val);
                CPU_Regs.reg_eax.dword = val;
                CPU_Regs.SETFLAGBIT(64, false);
            }
            return 4;
        }
    }

    public static final class CmpxchgEdGd_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public CmpxchgEdGd_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            Flags.FillFlags();
            if (CPU_Regs.reg_eax.dword == this.eard.dword) {
                this.eard.dword = this.rd.dword;
                CPU_Regs.SETFLAGBIT(64, true);
            } else {
                CPU_Regs.reg_eax.dword = this.eard.dword;
                CPU_Regs.SETFLAGBIT(64, false);
            }
            return 4;
        }
    }

    public static final class ImulGdEd_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public ImulGdEd_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            this.rd.dword = Instructions.DIMULD(Memory.mem_readd(eaa), this.rd.dword);
            return 4;
        }
    }

    public static final class ImulGdEd_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public ImulGdEd_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.rd.dword = Instructions.DIMULD(this.eard.dword, this.rd.dword);
            return 4;
        }
    }

    public static final class ShrdEdGdCl_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public ShrdEdGdCl_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int op3 = CPU_Regs.reg_ecx.low() & 0x1F;
            if (op3 != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.DSHRD(this.rd.dword, op3, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static final class ShrdEdGdCl_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public ShrdEdGdCl_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int op3 = CPU_Regs.reg_ecx.low() & 0x1F;
            if (op3 != 0) {
                this.eard.dword = Instructions.DSHRD(this.rd.dword, op3, this.eard.dword);
            }
            return 4;
        }
    }

    public static final class ShrdEdGdIb_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;
        int op3;

        public ShrdEdGdIb_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
            this.op3 = Helper.decode_fetchb() & 0x1F;
        }

        public int call() {
            if (this.op3 != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.DSHRD(this.rd.dword, this.op3, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static final class ShrdEdGdIb_reg
    extends Op {
        int op3;
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public ShrdEdGdIb_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
            this.op3 = Helper.decode_fetchb() & 0x1F;
        }

        public int call() {
            if (this.op3 != 0) {
                this.eard.dword = Instructions.DSHRD(this.rd.dword, this.op3, this.eard.dword);
            }
            return 4;
        }
    }

    public static final class BtsEdGd_mem
    extends Op {
        int mask;
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public BtsEdGd_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            Flags.FillFlags();
            this.mask = 1 << (this.rd.dword & 0x1F);
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readd(eaa += (this.rd.dword >> 5) * 4);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            Memory.mem_writed(eaa, old | this.mask);
            return 4;
        }
    }

    public static final class BtsEdGd_reg
    extends Op {
        int mask;
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public BtsEdGd_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            Flags.FillFlags();
            this.mask = 1 << (this.rd.dword & 0x1F);
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & this.mask) != 0);
            this.eard.dword |= this.mask;
            return 4;
        }
    }

    public static final class PopGS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegGS(true)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class PushGS
    extends Op {
        public int call() {
            CPU.CPU_Push32(CPU.Segs_GSval);
            return 4;
        }
    }

    public static final class ShldEdGdCl_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public ShldEdGdCl_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int op3 = CPU_Regs.reg_ecx.low() & 0x1F;
            if (op3 != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.DSHLD(this.rd.dword, op3, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static final class ShldEdGdCl_reg
    extends Op {
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public ShldEdGdCl_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            int op3 = CPU_Regs.reg_ecx.low() & 0x1F;
            if (op3 != 0) {
                this.eard.dword = Instructions.DSHLD(this.rd.dword, op3, this.eard.dword);
            }
            return 4;
        }
    }

    public static final class ShldEdGdIb_mem
    extends Op {
        CPU_Regs.Reg rd;
        EaaBase get_eaa;
        int op3;

        public ShldEdGdIb_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
            this.op3 = Helper.decode_fetchb() & 0x1F;
        }

        public int call() {
            if (this.op3 != 0) {
                int eaa = this.get_eaa.call();
                Memory.mem_writed(eaa, Instructions.DSHLD(this.rd.dword, this.op3, Memory.mem_readd(eaa)));
            }
            return 4;
        }
    }

    public static final class ShldEdGdIb_reg
    extends Op {
        int op3;
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public ShldEdGdIb_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
            this.op3 = Helper.decode_fetchb() & 0x1F;
        }

        public int call() {
            if (this.op3 != 0) {
                this.eard.dword = Instructions.DSHLD(this.rd.dword, this.op3, this.eard.dword);
            }
            return 4;
        }
    }

    public static final class BtEdGd_mem
    extends Op {
        int mask;
        CPU_Regs.Reg rd;
        EaaBase get_eaa;

        public BtEdGd_mem(int rm) {
            this.rd = Mod.gd(rm);
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            Flags.FillFlags();
            this.mask = 1 << (this.rd.dword & 0x1F);
            int eaa = this.get_eaa.call();
            int old = Memory.mem_readd(eaa += (this.rd.dword >> 5) * 4);
            CPU_Regs.SETFLAGBIT(1, (old & this.mask) != 0);
            return 4;
        }
    }

    public static final class BtEdGd_reg
    extends Op {
        int mask;
        CPU_Regs.Reg rd;
        CPU_Regs.Reg eard;

        public BtEdGd_reg(int rm) {
            this.rd = Mod.gd(rm);
            this.eard = Mod.ed(rm);
        }

        public int call() {
            Flags.FillFlags();
            this.mask = 1 << (this.rd.dword & 0x1F);
            CPU_Regs.SETFLAGBIT(1, (this.eard.dword & this.mask) != 0);
            return 4;
        }
    }

    public static final class PopFS
    extends Op {
        public int call() {
            if (CPU.CPU_PopSegFS(true)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class PushFS
    extends Op {
        public int call() {
            CPU.CPU_Push32(CPU.Segs_FSval);
            return 4;
        }
    }

    public static final class JumpCond32_d_nle
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NLE(), this.offset);
        }
    }

    public static final class JumpCond32_d_le
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_LE(), this.offset);
        }
    }

    public static final class JumpCond32_d_nl
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NL(), this.offset);
        }
    }

    public static final class JumpCond32_d_l
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_L(), this.offset);
        }
    }

    public static final class JumpCond32_d_np
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NP(), this.offset);
        }
    }

    public static final class JumpCond32_d_p
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_P(), this.offset);
        }
    }

    public static final class JumpCond32_d_ns
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NS(), this.offset);
        }
    }

    public static final class JumpCond32_d_s
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_S(), this.offset);
        }
    }

    public static final class JumpCond32_d_nbe
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NBE(), this.offset);
        }
    }

    public static final class JumpCond32_d_be
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_BE(), this.offset);
        }
    }

    public static final class JumpCond32_d_nz
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NZ(), this.offset);
        }
    }

    public static final class JumpCond32_d_z
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_Z(), this.offset);
        }
    }

    public static final class JumpCond32_d_nb
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NB(), this.offset);
        }
    }

    public static final class JumpCond32_d_b
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_B(), this.offset);
        }
    }

    public static final class JumpCond32_d_no
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_NO(), this.offset);
        }
    }

    public static final class JumpCond32_d_o
    extends JumpCond32_d {
        public int call() {
            return this.jump(Flags.TFLG_O(), this.offset);
        }
    }

    public static abstract class JumpCond32_d
    extends Op {
        int offset = Helper.decode_fetchds();

        protected final int jump(boolean COND, int off) {
            if (COND) {
                CPU_Regs.reg_eip += off + this.eip_count;
                return 1;
            }
            CPU_Regs.reg_eip += this.eip_count;
            return 2;
        }
    }

    public static final class LslGdEd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;
        IntRef value = new IntRef(0);

        public LslGdEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.value.value = this.rd.dword;
            CPU.CPU_LSL(Memory.mem_readw(eaa), this.value);
            this.rd.dword = this.value.value;
            return 4;
        }
    }

    public static final class LslGdEd_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rd;
        IntRef value = new IntRef(0);

        public LslGdEd_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            this.value.value = this.rd.dword;
            CPU.CPU_LSL(this.earw.word(), this.value);
            this.rd.dword = this.value.value;
            return 4;
        }
    }

    public static final class LarGdEd_mem
    extends Op {
        EaaBase get_eaa;
        CPU_Regs.Reg rd;

        public LarGdEd_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            IntRef value = new IntRef(this.rd.dword);
            CPU.CPU_LAR(Memory.mem_readw(eaa), value);
            this.rd.dword = value.value;
            return 4;
        }
    }

    public static final class LarGdEd_reg
    extends Op {
        CPU_Regs.Reg earw;
        CPU_Regs.Reg rd;

        public LarGdEd_reg(int rm) {
            this.earw = Mod.ew(rm);
            this.rd = Mod.gd(rm);
        }

        public int call() {
            if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                return 6;
            }
            IntRef value = new IntRef(this.rd.dword);
            CPU.CPU_LAR(this.earw.word(), value);
            this.rd.dword = value.value;
            return 4;
        }
    }

    public static final class Lmsw_reg
    extends Op {
        CPU_Regs.Reg eard;

        public Lmsw_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            if (CPU.CPU_LMSW(this.eard.dword)) {
                return this.RUNEXCEPTION();
            }
            return 4;
        }
    }

    public static final class Smsw_reg
    extends Op {
        CPU_Regs.Reg eard;

        public Smsw_reg(int rm) {
            this.eard = Mod.ed(rm);
        }

        public int call() {
            this.eard.dword = CPU.CPU_SMSW();
            return 4;
        }
    }

    public static final class Lidt_mem
    extends Op {
        EaaBase get_eaa;

        public Lidt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            int v1 = Memory.mem_readd(eaa + 2);
            int v0 = Memory.mem_readw(eaa);
            CPU.CPU_LIDT(v0, v1);
            return 4;
        }
    }

    public static final class Lgdt_mem
    extends Op {
        EaaBase get_eaa;

        public Lgdt_mem(int rm) {
            this.get_eaa = Mod.getEaa(rm);
        }

        public int call() {
            int eaa = this.get_eaa.call();
            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                return this.EXCEPTION(13);
            }
            int v1 = Memory.mem_readd(eaa + 2);
            int v0 = Memory.mem_readw(eaa);
            CPU.CPU_LGDT(v0, v1);
            return 4;
        }
    }
}

