/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_dynamic;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Instructions;
import jdos.cpu.core_dynamic.Decode;
import jdos.cpu.core_dynamic.EaaBase;
import jdos.cpu.core_dynamic.Helper;
import jdos.cpu.core_dynamic.Inst1;
import jdos.cpu.core_dynamic.Inst2;
import jdos.cpu.core_dynamic.Mod;
import jdos.cpu.core_dynamic.Op;
import jdos.misc.Log;

public class Prefix_0f
extends Helper {
    public static void init(Decode[] ops) {
        ops[256] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: {
                        if (rm >= 192) {
                            prev.next = new Inst2.Sldt_reg(rm);
                            break;
                        }
                        prev.next = new Inst2.Sldt_mem(rm);
                        break;
                    }
                    case 1: {
                        if (rm >= 192) {
                            prev.next = new Inst2.Str_reg(rm);
                            break;
                        }
                        prev.next = new Inst2.Str_mem(rm);
                        break;
                    }
                    case 2: {
                        if (rm >= 192) {
                            prev.next = new Inst2.Lldt_reg(rm);
                            break;
                        }
                        prev.next = new Inst2.Lldt_mem(rm);
                        break;
                    }
                    case 3: {
                        if (rm >= 192) {
                            prev.next = new Inst2.Ltr_reg(rm);
                            break;
                        }
                        prev.next = new Inst2.Ltr_mem(rm);
                        break;
                    }
                    case 4: {
                        if (rm >= 192) {
                            prev.next = new Inst2.Verr_reg(rm);
                            break;
                        }
                        prev.next = new Inst2.Verr_mem(rm);
                        break;
                    }
                    case 5: {
                        if (rm >= 192) {
                            prev.next = new Inst2.Verw_reg(rm);
                            break;
                        }
                        prev.next = new Inst2.Verw_mem(rm);
                        break;
                    }
                    default: {
                        prev.next = new Inst1.Illegal("");
                    }
                }
                return 0;
            }
        };
        ops[257] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    switch (which) {
                        case 0: {
                            prev.next = new Inst2.Sgdt_mem(rm);
                            break;
                        }
                        case 1: {
                            prev.next = new Inst2.Sidt_mem(rm);
                            break;
                        }
                        case 2: {
                            prev.next = new Inst2.Lgdt_mem(rm);
                            break;
                        }
                        case 3: {
                            prev.next = new Inst2.Lidt_mem(rm);
                            break;
                        }
                        case 4: {
                            prev.next = new Inst2.Smsw_mem(rm);
                            break;
                        }
                        case 6: {
                            prev.next = new Inst2.Lmsw_mem(rm);
                            break;
                        }
                        case 7: {
                            prev.next = new Inst2.Invlpg();
                        }
                    }
                } else {
                    switch (which) {
                        case 2: {
                            prev.next = new Inst2.Lgdt_reg();
                            break;
                        }
                        case 3: {
                            prev.next = new Inst2.Lidt_reg();
                            break;
                        }
                        case 4: {
                            prev.next = new Inst2.Smsw_reg(rm);
                            break;
                        }
                        case 6: {
                            prev.next = new Inst2.Lmsw_reg(rm);
                            break;
                        }
                        default: {
                            prev.next = new Inst1.Illegal("");
                        }
                    }
                }
                return 0;
            }
        };
        ops[258] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.LarGwEw_reg(rm) : new Inst2.LarGwEw_mem(rm);
                return 0;
            }
        };
        ops[259] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.LslGwEw_reg(rm) : new Inst2.LslGwEw_mem(rm);
                return 0;
            }
        };
        ops[262] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.Clts();
                return 0;
            }
        };
        ops[774] = ops[262];
        ops[264] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Invd();
                return 0;
            }
        };
        ops[776] = ops[264];
        ops[265] = ops[264];
        ops[777] = ops[264];
        ops[288] = new Decode(){

            public final int call(Op prev) {
                int rm = Helper.decode_fetchb();
                if (rm < 192) {
                    int which = rm >> 3 & 7;
                    rm |= 0xC0;
                    Log.log(8, 2, "MOV XXX,CR" + which + " with non-register");
                }
                prev.next = new Inst2.MovRdCr(rm);
                return 0;
            }
        };
        ops[800] = ops[288];
        ops[289] = new Decode(){

            public final int call(Op prev) {
                int rm = Helper.decode_fetchb();
                if (rm < 192) {
                    int which = rm >> 3 & 7;
                    rm |= 0xC0;
                    Log.log(8, 2, "MOV XXX,DR" + which + " with non-register");
                }
                prev.next = new Inst2.MovRdDr(rm);
                return 0;
            }
        };
        ops[801] = ops[289];
        ops[290] = new Decode(){

            public final int call(Op prev) {
                int rm = Helper.decode_fetchb();
                if (rm < 192) {
                    int which = rm >> 3 & 7;
                    rm |= 0xC0;
                    Log.log(8, 2, "MOV XXX,CR" + which + " with non-register");
                }
                prev.next = new Inst2.MovCrRd(rm);
                return 0;
            }
        };
        ops[802] = ops[290];
        ops[291] = new Decode(){

            public final int call(Op prev) {
                int rm = Helper.decode_fetchb();
                if (rm < 192) {
                    int which = rm >> 3 & 7;
                    rm |= 0xC0;
                    Log.log(8, 2, "MOV DR" + which + ",XXX with non-register");
                }
                prev.next = new Inst2.MovDrRd(rm);
                return 0;
            }
        };
        ops[803] = ops[291];
        ops[292] = new Decode(){

            public final int call(Op prev) {
                int rm = Helper.decode_fetchb();
                if (rm < 192) {
                    int which = rm >> 3 & 7;
                    rm |= 0xC0;
                    Log.log(8, 2, "MOV XXX,TR" + which + " with non-register");
                }
                prev.next = new Inst2.MovRdTr(rm);
                return 0;
            }
        };
        ops[804] = ops[292];
        ops[294] = new Decode(){

            public final int call(Op prev) {
                int rm = Helper.decode_fetchb();
                if (rm < 192) {
                    int which = rm >> 3 & 7;
                    rm |= 0xC0;
                    Log.log(8, 2, "MOV TR" + which + ",XXX with non-register");
                }
                prev.next = new Inst2.MovTrRd(rm);
                return 0;
            }
        };
        ops[806] = ops[294];
        ops[305] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.Rdtsc();
                return 0;
            }
        };
        ops[817] = ops[305];
        ops[384] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_o();
                return 6;
            }
        };
        ops[385] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_no();
                return 6;
            }
        };
        ops[386] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_b();
                return 6;
            }
        };
        ops[387] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_nb();
                return 6;
            }
        };
        ops[388] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_z();
                return 6;
            }
        };
        ops[389] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_nz();
                return 6;
            }
        };
        ops[390] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_be();
                return 6;
            }
        };
        ops[391] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_nbe();
                return 6;
            }
        };
        ops[392] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_s();
                return 6;
            }
        };
        ops[393] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_ns();
                return 6;
            }
        };
        ops[394] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_p();
                return 6;
            }
        };
        ops[395] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_np();
                return 6;
            }
        };
        ops[396] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_l();
                return 6;
            }
        };
        ops[397] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_nl();
                return 6;
            }
        };
        ops[398] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_le();
                return 6;
            }
        };
        ops[399] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.JumpCond16_w_nle();
                return 6;
            }
        };
        ops[400] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_o(rm) : new Inst2.SETcc_mem_o(rm);
                return 0;
            }
        };
        ops[912] = ops[400];
        ops[401] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_no(rm) : new Inst2.SETcc_mem_no(rm);
                return 0;
            }
        };
        ops[913] = ops[401];
        ops[402] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_b(rm) : new Inst2.SETcc_mem_b(rm);
                return 0;
            }
        };
        ops[914] = ops[402];
        ops[403] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_nb(rm) : new Inst2.SETcc_mem_nb(rm);
                return 0;
            }
        };
        ops[915] = ops[403];
        ops[404] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_z(rm) : new Inst2.SETcc_mem_z(rm);
                return 0;
            }
        };
        ops[916] = ops[404];
        ops[405] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_nz(rm) : new Inst2.SETcc_mem_nz(rm);
                return 0;
            }
        };
        ops[917] = ops[405];
        ops[406] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_be(rm) : new Inst2.SETcc_mem_be(rm);
                return 0;
            }
        };
        ops[918] = ops[406];
        ops[407] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_nbe(rm) : new Inst2.SETcc_mem_nbe(rm);
                return 0;
            }
        };
        ops[919] = ops[407];
        ops[408] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_s(rm) : new Inst2.SETcc_mem_s(rm);
                return 0;
            }
        };
        ops[920] = ops[408];
        ops[409] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_ns(rm) : new Inst2.SETcc_mem_ns(rm);
                return 0;
            }
        };
        ops[921] = ops[409];
        ops[410] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_p(rm) : new Inst2.SETcc_mem_p(rm);
                return 0;
            }
        };
        ops[922] = ops[410];
        ops[411] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_np(rm) : new Inst2.SETcc_mem_np(rm);
                return 0;
            }
        };
        ops[923] = ops[411];
        ops[412] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_l(rm) : new Inst2.SETcc_mem_l(rm);
                return 0;
            }
        };
        ops[924] = ops[412];
        ops[413] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_nl(rm) : new Inst2.SETcc_mem_nl(rm);
                return 0;
            }
        };
        ops[925] = ops[413];
        ops[414] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_le(rm) : new Inst2.SETcc_mem_le(rm);
                return 0;
            }
        };
        ops[926] = ops[414];
        ops[415] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.SETcc_reg_nle(rm) : new Inst2.SETcc_mem_nle(rm);
                return 0;
            }
        };
        ops[927] = ops[415];
        ops[416] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.PushFS();
                return 0;
            }
        };
        ops[417] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.PopFS();
                return 0;
            }
        };
        ops[418] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.CPUID();
                return 0;
            }
        };
        ops[930] = ops[418];
        ops[419] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.BtEwGw_reg(rm) : new Inst2.BtEwGw_mem(rm);
                return 0;
            }
        };
        ops[420] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg earw = Mod.ew(rm);
                    short op3 = Helper.decode_fetchb();
                    if (Instructions.valid_DSHLW(op3)) {
                        prev.next = new Inst2.ShldEwGwIb_reg(rm, earw, op3);
                    }
                } else {
                    EaaBase get_eaa = Mod.getEaa(rm);
                    short op3 = Helper.decode_fetchb();
                    if (Instructions.valid_DSHLW(op3)) {
                        prev.next = new Inst2.ShldEwGwIb_mem(rm, get_eaa, op3);
                    }
                }
                return 0;
            }
        };
        ops[421] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.ShldEwGwCl_reg(rm) : new Inst2.ShldEwGwCl_mem(rm);
                return 0;
            }
        };
        ops[424] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.PushGS();
                return 0;
            }
        };
        ops[425] = new Decode(){

            public final int call(Op prev) {
                prev.next = new Inst2.PopGS();
                return 0;
            }
        };
        ops[427] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.BtsEwGw_reg(rm) : new Inst2.BtsEwGw_mem(rm);
                return 0;
            }
        };
        ops[428] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg earw = Mod.ew(rm);
                    short op3 = Helper.decode_fetchb();
                    if (Instructions.valid_DSHRW(op3)) {
                        prev.next = new Inst2.ShrdEwGwIb_reg(rm, earw, op3);
                    }
                } else {
                    EaaBase get_eaa = Mod.getEaa(rm);
                    short op3 = Helper.decode_fetchb();
                    if (Instructions.valid_DSHRW(op3)) {
                        prev.next = new Inst2.ShrdEwGwIb_mem(rm, get_eaa, op3);
                    }
                }
                return 0;
            }
        };
        ops[429] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.ShrdEwGwCl_reg(rm) : new Inst2.ShrdEwGwCl_mem(rm);
                return 0;
            }
        };
        ops[431] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.ImulGwEw_reg(rm) : new Inst2.ImulGwEw_mem(rm);
                return 0;
            }
        };
        ops[432] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.CmpxchgEbGb_reg(rm) : new Inst2.CmpxchgEbGb_mem(rm);
                return 0;
            }
        };
        ops[944] = ops[432];
        ops[433] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.CmpxchgEwGw_reg(rm) : new Inst2.CmpxchgEwGw_mem(rm);
                return 0;
            }
        };
        ops[434] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst1.Illegal("") : new Inst2.LssEw(rm);
                return 0;
            }
        };
        ops[435] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.BtrEwGw_reg(rm) : new Inst2.BtrEwGw_mem(rm);
                return 0;
            }
        };
        ops[436] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst1.Illegal("") : new Inst2.LfsEw(rm);
                return 0;
            }
        };
        ops[437] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst1.Illegal("") : new Inst2.LgsEw(rm);
                return 0;
            }
        };
        ops[438] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.MovzxGwEb_reg(rm) : new Inst2.MovzxGwEb_mem(rm);
                return 0;
            }
        };
        ops[439] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.MovzxGwEw_reg(rm) : new Inst2.MovzxGwEw_mem(rm);
                return 0;
            }
        };
        ops[447] = ops[439];
        ops[442] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                if (rm >= 192) {
                    switch (rm & 0x38) {
                        case 32: {
                            prev.next = new Inst2.BtEwIb_reg(rm);
                            break;
                        }
                        case 40: {
                            prev.next = new Inst2.BtsEwIb_reg(rm);
                            break;
                        }
                        case 48: {
                            prev.next = new Inst2.BtrEwIb_reg(rm);
                            break;
                        }
                        case 56: {
                            prev.next = new Inst2.BtcEwIb_reg(rm);
                            break;
                        }
                        default: {
                            Log.exit("CPU:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                            break;
                        }
                    }
                } else {
                    switch (rm & 0x38) {
                        case 32: {
                            prev.next = new Inst2.BtEwIb_mem(rm);
                            break;
                        }
                        case 40: {
                            prev.next = new Inst2.BtsEwIb_mem(rm);
                            break;
                        }
                        case 48: {
                            prev.next = new Inst2.BtrEwIb_mem(rm);
                            break;
                        }
                        case 56: {
                            prev.next = new Inst2.BtcEwIb_mem(rm);
                            break;
                        }
                        default: {
                            Log.exit("CPU:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                        }
                    }
                }
                return 0;
            }
        };
        ops[443] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.BtcEwGw_reg(rm) : new Inst2.BtcEwGw_mem(rm);
                return 0;
            }
        };
        ops[444] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.BsfGwEw_reg(rm) : new Inst2.BsfGwEw_mem(rm);
                return 0;
            }
        };
        ops[445] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.BsrGwEw_reg(rm) : new Inst2.BsrGwEw_mem(rm);
                return 0;
            }
        };
        ops[446] = new Decode(){

            public final int call(Op prev) {
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.MovsxGwEb_reg(rm) : new Inst2.MovsxGwEb_mem(rm);
                return 0;
            }
        };
        ops[448] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.XaddGbEb_reg(rm) : new Inst2.XaddGbEb_mem(rm);
                return 0;
            }
        };
        ops[960] = ops[448];
        ops[449] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                short rm = Helper.decode_fetchb();
                prev.next = rm >= 192 ? new Inst2.XaddGwEw_reg(rm) : new Inst2.XaddGwEw_mem(rm);
                return 0;
            }
        };
        ops[456] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_eax);
                return 0;
            }
        };
        ops[457] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_ecx);
                return 0;
            }
        };
        ops[458] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_edx);
                return 0;
            }
        };
        ops[459] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_ebx);
                return 0;
            }
        };
        ops[460] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_esp);
                return 0;
            }
        };
        ops[461] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_ebp);
                return 0;
            }
        };
        ops[462] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_esi);
                return 0;
            }
        };
        ops[463] = new Decode(){

            public final int call(Op prev) {
                if (CPU.CPU_ArchitectureType < 64) {
                    prev.next = new Inst1.Illegal("");
                    return 6;
                }
                prev.next = new Inst2.Bswapw(CPU_Regs.reg_edi);
                return 0;
            }
        };
    }
}

