/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_normal;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.Modrm;
import jdos.cpu.Paging;
import jdos.cpu.Table_ea;
import jdos.cpu.core_normal.Prefix_helpers;
import jdos.cpu.core_normal.Prefix_none;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.util.IntRef;
import jdos.util.LongRef;

public class Prefix_0f
extends Prefix_none {
    private static final IntRef int_ref_1 = new IntRef(0);
    private static final LongRef long_ref_1 = new LongRef(0L);

    static {
        Prefix_0f.ops[256] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: 
                    case 1: {
                        int saveval = which == 0 ? CPU.CPU_SLDT() : CPU.CPU_STR();
                        if (rm >= 192) {
                            Modrm.GetEArw[rm].word(saveval);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writew(eaa, saveval);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int loadval;
                        if (rm >= 192) {
                            loadval = Modrm.GetEArw[rm].word();
                        } else {
                            int eaa = Table_ea.getEaa(rm);
                            loadval = Memory.mem_readw(eaa);
                        }
                        switch (which) {
                            case 2: {
                                if (CPU.cpu.cpl != 0) {
                                    return Prefix_helpers.EXCEPTION(13);
                                }
                                if (!CPU.CPU_LLDT(loadval)) break;
                                return Prefix_helpers.RUNEXCEPTION();
                            }
                            case 3: {
                                if (CPU.cpu.cpl != 0) {
                                    return Prefix_helpers.EXCEPTION(13);
                                }
                                if (!CPU.CPU_LTR(loadval)) break;
                                return Prefix_helpers.RUNEXCEPTION();
                            }
                            case 4: {
                                CPU.CPU_VERR(loadval);
                                break;
                            }
                            case 5: {
                                CPU.CPU_VERW(loadval);
                            }
                        }
                        break;
                    }
                    default: {
                        return 1;
                    }
                }
                return 3;
            }
        };
        Prefix_0f.ops[257] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    int eaa = Table_ea.getEaa(rm);
                    switch (which) {
                        case 0: {
                            Memory.mem_writew(eaa, CPU.CPU_SGDT_limit());
                            Memory.mem_writed(eaa + 2, CPU.CPU_SGDT_base());
                            break;
                        }
                        case 1: {
                            Memory.mem_writew(eaa, CPU.CPU_SIDT_limit());
                            Memory.mem_writed(eaa + 2, CPU.CPU_SIDT_base());
                            break;
                        }
                        case 2: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            int v1 = Memory.mem_readd(eaa + 2) & 0xFFFFFF;
                            int v0 = Memory.mem_readw(eaa);
                            CPU.CPU_LGDT(v0, v1);
                            break;
                        }
                        case 3: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            int v1 = Memory.mem_readd(eaa + 2) & 0xFFFFFF;
                            int v0 = Memory.mem_readw(eaa);
                            CPU.CPU_LIDT(v0, v1);
                            break;
                        }
                        case 4: {
                            Memory.mem_writew(eaa, CPU.CPU_SMSW() & 0xFFFF);
                            break;
                        }
                        case 6: {
                            int limit = Memory.mem_readw(eaa);
                            if (!CPU.CPU_LMSW(limit)) break;
                            return Prefix_helpers.RUNEXCEPTION();
                        }
                        case 7: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            Paging.PAGING_ClearTLB();
                        }
                    }
                } else {
                    switch (which) {
                        case 2: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            return 1;
                        }
                        case 3: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            return 1;
                        }
                        case 4: {
                            Modrm.GetEArw[rm].word(CPU.CPU_SMSW() & 0xFFFF);
                            break;
                        }
                        case 6: {
                            if (!CPU.CPU_LMSW(Modrm.GetEArw[rm].word())) break;
                            return Prefix_helpers.RUNEXCEPTION();
                        }
                        default: {
                            return 1;
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_0f.ops[258] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int_ref_1.value = Modrm.Getrw[rm].word();
                if (rm >= 192) {
                    CPU.CPU_LAR(Modrm.GetEArw[rm].word(), int_ref_1);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    CPU.CPU_LAR(Memory.mem_readw(eaa), int_ref_1);
                }
                Modrm.Getrw[rm].word(int_ref_1.value);
                return 3;
            }
        };
        Prefix_0f.ops[259] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int_ref_1.value = Modrm.Getrw[rm].word();
                if (rm >= 192) {
                    CPU.CPU_LSL(Modrm.GetEArw[rm].word(), int_ref_1);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    CPU.CPU_LSL(Memory.mem_readw(eaa), int_ref_1);
                }
                Modrm.Getrw[rm].word(int_ref_1.value);
                return 3;
            }
        };
        Prefix_0f.ops[262] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                    return Prefix_helpers.EXCEPTION(13);
                }
                CPU.cpu.cr0 &= 0xFFFFFFF7;
                return 3;
            }
        };
        Prefix_0f.ops[774] = ops[262];
        Prefix_0f.ops[264] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                    return Prefix_helpers.EXCEPTION(13);
                }
                return 3;
            }
        };
        Prefix_0f.ops[776] = ops[264];
        Prefix_0f.ops[265] = ops[264];
        Prefix_0f.ops[777] = ops[264];
        Prefix_0f.ops[288] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    rm = (short)(rm | 0xC0);
                    Log.log(8, 2, "MOV XXX,CR" + which + " with non-register");
                }
                if (CPU.CPU_READ_CRX(which, Modrm.GetEArd[rm])) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[800] = ops[288];
        Prefix_0f.ops[289] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    rm = (short)(rm | 0xC0);
                    Log.log(8, 2, "MOV XXX,DR" + which + " with non-register");
                }
                if (CPU.CPU_READ_DRX(which, Modrm.GetEArd[rm])) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[801] = ops[289];
        Prefix_0f.ops[290] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    rm = (short)(rm | 0xC0);
                    Log.log(8, 2, "MOV XXX,CR" + which + " with non-register");
                }
                if (CPU.CPU_WRITE_CRX(which, Modrm.GetEArd[rm].dword)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[802] = ops[290];
        Prefix_0f.ops[291] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    rm = (short)(rm | 0xC0);
                    Log.log(8, 2, "MOV DR" + which + ",XXX with non-register");
                }
                if (CPU.CPU_WRITE_DRX(which, Modrm.GetEArd[rm].dword)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[803] = ops[291];
        Prefix_0f.ops[292] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    rm = (short)(rm | 0xC0);
                    Log.log(8, 2, "MOV XXX,TR" + which + " with non-register");
                }
                if (CPU.CPU_READ_TRX(which, Modrm.GetEArd[rm])) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[804] = ops[292];
        Prefix_0f.ops[294] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    rm = (short)(rm | 0xC0);
                    Log.log(8, 2, "MOV TR" + which + ",XXX with non-register");
                }
                if (CPU.CPU_WRITE_TRX(which, Modrm.GetEArd[rm].dword)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[806] = ops[294];
        Prefix_0f.ops[305] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 80) {
                    return 1;
                }
                long tsc = (long)(Pic.PIC_FullIndex() * (double)CPU.CPU_CycleMax);
                CPU_Regs.reg_edx.dword = (int)(tsc >>> 32);
                CPU_Regs.reg_eax.dword = (int)(tsc & 0xFFFFFFFFL);
                return 3;
            }
        };
        Prefix_0f.ops[817] = ops[305];
        Prefix_0f.ops[384] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_O());
                return 6;
            }
        };
        Prefix_0f.ops[385] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NO());
                return 6;
            }
        };
        Prefix_0f.ops[386] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_B());
                return 6;
            }
        };
        Prefix_0f.ops[387] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NB());
                return 6;
            }
        };
        Prefix_0f.ops[388] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_Z());
                return 6;
            }
        };
        Prefix_0f.ops[389] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NZ());
                return 6;
            }
        };
        Prefix_0f.ops[390] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_BE());
                return 6;
            }
        };
        Prefix_0f.ops[391] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NBE());
                return 6;
            }
        };
        Prefix_0f.ops[392] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_S());
                return 6;
            }
        };
        Prefix_0f.ops[393] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NS());
                return 6;
            }
        };
        Prefix_0f.ops[394] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_P());
                return 6;
            }
        };
        Prefix_0f.ops[395] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NP());
                return 6;
            }
        };
        Prefix_0f.ops[396] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_L());
                return 6;
            }
        };
        Prefix_0f.ops[397] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NL());
                return 6;
            }
        };
        Prefix_0f.ops[398] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_LE());
                return 6;
            }
        };
        Prefix_0f.ops[399] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_w(Flags.TFLG_NLE());
                return 6;
            }
        };
        Prefix_0f.ops[400] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_O());
                return 3;
            }
        };
        Prefix_0f.ops[912] = ops[400];
        Prefix_0f.ops[401] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NO());
                return 3;
            }
        };
        Prefix_0f.ops[913] = ops[401];
        Prefix_0f.ops[402] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_B());
                return 3;
            }
        };
        Prefix_0f.ops[914] = ops[402];
        Prefix_0f.ops[403] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NB());
                return 3;
            }
        };
        Prefix_0f.ops[915] = ops[403];
        Prefix_0f.ops[404] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_Z());
                return 3;
            }
        };
        Prefix_0f.ops[916] = ops[404];
        Prefix_0f.ops[405] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NZ());
                return 3;
            }
        };
        Prefix_0f.ops[917] = ops[405];
        Prefix_0f.ops[406] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_BE());
                return 3;
            }
        };
        Prefix_0f.ops[918] = ops[406];
        Prefix_0f.ops[407] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NBE());
                return 3;
            }
        };
        Prefix_0f.ops[919] = ops[407];
        Prefix_0f.ops[408] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_S());
                return 3;
            }
        };
        Prefix_0f.ops[920] = ops[408];
        Prefix_0f.ops[409] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NS());
                return 3;
            }
        };
        Prefix_0f.ops[921] = ops[409];
        Prefix_0f.ops[410] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_P());
                return 3;
            }
        };
        Prefix_0f.ops[922] = ops[410];
        Prefix_0f.ops[411] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NP());
                return 3;
            }
        };
        Prefix_0f.ops[923] = ops[411];
        Prefix_0f.ops[412] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_L());
                return 3;
            }
        };
        Prefix_0f.ops[924] = ops[412];
        Prefix_0f.ops[413] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NL());
                return 3;
            }
        };
        Prefix_0f.ops[925] = ops[413];
        Prefix_0f.ops[414] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_LE());
                return 3;
            }
        };
        Prefix_0f.ops[926] = ops[414];
        Prefix_0f.ops[415] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.SETcc(Flags.TFLG_NLE());
                return 3;
            }
        };
        Prefix_0f.ops[927] = ops[415];
        Prefix_0f.ops[416] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU.Segs_FSval);
                return 3;
            }
        };
        Prefix_0f.ops[417] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegFS(false)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[418] = new Prefix_helpers.OP(){

            public final int call() {
                if (!CPU.CPU_CPUID()) {
                    return 1;
                }
                return 3;
            }
        };
        Prefix_0f.ops[930] = ops[418];
        Prefix_0f.ops[419] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                int rw = Modrm.Getrw[rm].word();
                int mask = 1 << (rw & 0xF);
                if (rm >= 192) {
                    CPU_Regs.SETFLAGBIT(1, (Modrm.GetEArw[rm].word() & mask) != 0);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readw(eaa += ((short)rw >> 4) * 2);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                }
                return 3;
            }
        };
        Prefix_0f.ops[420] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Prefix_helpers.r = rm;
                    short op3 = Core.Fetchb();
                    Instructions.DSHLW(Modrm.Getrw[rm].word(), op3, Prefix_helpers.earw_l, Prefix_helpers.earw_s);
                } else {
                    Prefix_helpers.m = Table_ea.getEaa(rm);
                    short op3 = Core.Fetchb();
                    Instructions.DSHLW(Modrm.Getrw[rm].word(), op3, Prefix_helpers.w_l, Prefix_helpers.w_s);
                }
                return 3;
            }
        };
        Prefix_0f.ops[421] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Prefix_helpers.r = rm;
                    Instructions.DSHLW(Modrm.Getrw[rm].word(), CPU_Regs.reg_ecx.low(), Prefix_helpers.earw_l, Prefix_helpers.earw_s);
                } else {
                    Prefix_helpers.m = Table_ea.getEaa(rm);
                    Instructions.DSHLW(Modrm.Getrw[rm].word(), CPU_Regs.reg_ecx.low(), Prefix_helpers.w_l, Prefix_helpers.w_s);
                }
                return 3;
            }
        };
        Prefix_0f.ops[424] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU.Segs_GSval);
                return 3;
            }
        };
        Prefix_0f.ops[425] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegGS(false)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_0f.ops[427] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                int mask = 1 << (Modrm.Getrw[rm].word() & 0xF);
                if (rm >= 192) {
                    CPU_Regs.SETFLAGBIT(1, (Modrm.GetEArw[rm].word() & mask) != 0);
                    Modrm.GetEArw[rm].word(Modrm.GetEArw[rm].word() | mask);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readw(eaa += ((short)Modrm.Getrw[rm].word() >> 4) * 2);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                    Memory.mem_writew(eaa, old | mask);
                }
                return 3;
            }
        };
        Prefix_0f.ops[428] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Prefix_helpers.r = rm;
                    short op3 = Core.Fetchb();
                    Instructions.DSHRW(Modrm.Getrw[rm].word(), op3, Prefix_helpers.earw_l, Prefix_helpers.earw_s);
                } else {
                    Prefix_helpers.m = Table_ea.getEaa(rm);
                    short op3 = Core.Fetchb();
                    Instructions.DSHRW(Modrm.Getrw[rm].word(), op3, Prefix_helpers.w_l, Prefix_helpers.w_s);
                }
                return 3;
            }
        };
        Prefix_0f.ops[429] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Prefix_helpers.r = rm;
                    Instructions.DSHRW(Modrm.Getrw[rm].word(), CPU_Regs.reg_ecx.low(), Prefix_helpers.earw_l, Prefix_helpers.earw_s);
                } else {
                    Prefix_helpers.m = Table_ea.getEaa(rm);
                    Instructions.DSHRW(Modrm.Getrw[rm].word(), CPU_Regs.reg_ecx.low(), Prefix_helpers.w_l, Prefix_helpers.w_s);
                }
                return 3;
            }
        };
        Prefix_0f.ops[431] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrw[rm];
                if (rm >= 192) {
                    r.word(Instructions.DIMULW(Modrm.GetEArw[rm].word(), r.word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    r.word(Instructions.DIMULW(Memory.mem_readw(eaa), r.word()));
                }
                return 3;
            }
        };
        Prefix_0f.ops[432] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                Flags.FillFlags();
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb_interface r = Modrm.GetEArb[rm];
                    if (CPU_Regs.reg_eax.low() == r.get()) {
                        r.set(Modrm.Getrb[rm].get());
                        CPU_Regs.SETFLAGBIT(64, true);
                    } else {
                        CPU_Regs.reg_eax.low(r.get());
                        CPU_Regs.SETFLAGBIT(64, false);
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    short val = Memory.mem_readb(eaa);
                    if (CPU_Regs.reg_eax.low() == val) {
                        Memory.mem_writeb(eaa, Modrm.Getrb[rm].get());
                        CPU_Regs.SETFLAGBIT(64, true);
                    } else {
                        Memory.mem_writeb(eaa, val);
                        CPU_Regs.reg_eax.low(val);
                        CPU_Regs.SETFLAGBIT(64, false);
                    }
                }
                return 3;
            }
        };
        Prefix_0f.ops[944] = ops[432];
        Prefix_0f.ops[433] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                Flags.FillFlags();
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    if (CPU_Regs.reg_eax.word() == Modrm.GetEArw[rm].word()) {
                        Modrm.GetEArw[rm].word(Modrm.Getrw[rm].word());
                        CPU_Regs.SETFLAGBIT(64, true);
                    } else {
                        CPU_Regs.reg_eax.word(Modrm.GetEArw[rm].word());
                        CPU_Regs.SETFLAGBIT(64, false);
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int val = Memory.mem_readw(eaa);
                    if (CPU_Regs.reg_eax.word() == val) {
                        Memory.mem_writew(eaa, Modrm.Getrw[rm].word());
                        CPU_Regs.SETFLAGBIT(64, true);
                    } else {
                        Memory.mem_writew(eaa, val);
                        CPU_Regs.reg_eax.word(val);
                        CPU_Regs.SETFLAGBIT(64, false);
                    }
                }
                return 3;
            }
        };
        Prefix_0f.ops[434] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa + 2))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                return 3;
            }
        };
        Prefix_0f.ops[435] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                int mask = 1 << (Modrm.Getrw[rm].word() & 0xF);
                if (rm >= 192) {
                    CPU_Regs.SETFLAGBIT(1, (Modrm.GetEArw[rm].word() & mask) != 0);
                    Modrm.GetEArw[rm].word(Modrm.GetEArw[rm].word() & ~mask);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readw(eaa += ((short)Modrm.Getrw[rm].word() >> 4) * 2);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                    Memory.mem_writew(eaa, old & ~mask);
                }
                return 3;
            }
        };
        Prefix_0f.ops[436] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa + 2))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                return 3;
            }
        };
        Prefix_0f.ops[437] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa + 2))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                return 3;
            }
        };
        Prefix_0f.ops[438] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Modrm.GetEArb[rm].get());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrw[rm].word(Memory.mem_readb(eaa));
                }
                return 3;
            }
        };
        Prefix_0f.ops[439] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Modrm.GetEArw[rm].word());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                }
                return 3;
            }
        };
        Prefix_0f.ops[447] = ops[439];
        Prefix_0f.ops[442] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    int mask = 1 << (Core.Fetchb() & 0xF);
                    CPU_Regs.SETFLAGBIT(1, (Modrm.GetEArw[rm].word() & mask) != 0);
                    switch (rm & 0x38) {
                        case 32: {
                            break;
                        }
                        case 40: {
                            Modrm.GetEArw[rm].word(Modrm.GetEArw[rm].word() | mask);
                            break;
                        }
                        case 48: {
                            Modrm.GetEArw[rm].word(Modrm.GetEArw[rm].word() & ~mask);
                            break;
                        }
                        case 56: {
                            Modrm.GetEArw[rm].word(Modrm.GetEArw[rm].word() ^ mask);
                            break;
                        }
                        default: {
                            Log.exit("CPU:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                            break;
                        }
                    }
                } else {
                    int mask;
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readw(eaa);
                    CPU_Regs.SETFLAGBIT(1, (old & (mask = 1 << (Core.Fetchb() & 0xF))) != 0);
                    switch (rm & 0x38) {
                        case 32: {
                            break;
                        }
                        case 40: {
                            Memory.mem_writew(eaa, old | mask);
                            break;
                        }
                        case 48: {
                            Memory.mem_writew(eaa, old & ~mask);
                            break;
                        }
                        case 56: {
                            Memory.mem_writew(eaa, old ^ mask);
                            break;
                        }
                        default: {
                            Log.exit("CPU:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_0f.ops[443] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                int mask = 1 << (Modrm.Getrw[rm].word() & 0xF);
                if (rm >= 192) {
                    CPU_Regs.SETFLAGBIT(1, (Modrm.GetEArw[rm].word() & mask) != 0);
                    Modrm.GetEArw[rm].word(Modrm.GetEArw[rm].word() ^ mask);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readw(eaa += ((short)Modrm.Getrw[rm].word() >> 4) * 2);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                    Memory.mem_writew(eaa, old ^ mask);
                }
                return 3;
            }
        };
        Prefix_0f.ops[444] = new Prefix_helpers.OP(){

            public final int call() {
                int value;
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    value = Modrm.GetEArw[rm].word();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    value = Memory.mem_readw(eaa);
                }
                if (value == 0) {
                    CPU_Regs.SETFLAGBIT(64, true);
                } else {
                    int result = 0;
                    while ((value & 1) == 0) {
                        ++result;
                        value >>= 1;
                    }
                    CPU_Regs.SETFLAGBIT(64, false);
                    Modrm.Getrw[rm].word(result);
                }
                Flags.lflags.type = 0;
                return 3;
            }
        };
        Prefix_0f.ops[445] = new Prefix_helpers.OP(){

            public final int call() {
                int value;
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    value = Modrm.GetEArw[rm].word();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    value = Memory.mem_readw(eaa);
                }
                if (value == 0) {
                    CPU_Regs.SETFLAGBIT(64, true);
                } else {
                    int result = 15;
                    while ((value & 0x8000) == 0) {
                        --result;
                        value <<= 1;
                    }
                    CPU_Regs.SETFLAGBIT(64, false);
                    Modrm.Getrw[rm].word(result);
                }
                Flags.lflags.type = 0;
                return 3;
            }
        };
        Prefix_0f.ops[446] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Modrm.GetEArb[rm].get());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrw[rm].word((byte)Memory.mem_readb(eaa));
                }
                return 3;
            }
        };
        Prefix_0f.ops[448] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                short rm = Core.Fetchb();
                short oldrmrb = Modrm.Getrb[rm].get();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Modrm.GetEArb[rm].get());
                    Modrm.GetEArb[rm].set((short)(Modrm.GetEArb[rm].get() + oldrmrb));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrb[rm].set(Memory.mem_readb(eaa));
                    Memory.mem_writeb(eaa, Memory.mem_readb(eaa) + oldrmrb);
                }
                return 3;
            }
        };
        Prefix_0f.ops[960] = ops[448];
        Prefix_0f.ops[449] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int oldrmrw = Modrm.Getrw[rm].word();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Modrm.GetEArw[rm].word());
                    Modrm.GetEArw[rm].word(Modrm.GetEArw[rm].word() + oldrmrw);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                    Memory.mem_writew(eaa, Memory.mem_readw(eaa) + oldrmrw);
                }
                return 3;
            }
        };
        Prefix_0f.ops[456] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_eax.word(Instructions.BSWAPW(CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_0f.ops[457] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_ecx.word(Instructions.BSWAPW(CPU_Regs.reg_ecx.word()));
                return 3;
            }
        };
        Prefix_0f.ops[458] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_edx.word(Instructions.BSWAPW(CPU_Regs.reg_edx.word()));
                return 3;
            }
        };
        Prefix_0f.ops[459] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_ebx.word(Instructions.BSWAPW(CPU_Regs.reg_ebx.word()));
                return 3;
            }
        };
        Prefix_0f.ops[460] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_esp.word(Instructions.BSWAPW(CPU_Regs.reg_esp.word()));
                return 3;
            }
        };
        Prefix_0f.ops[461] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_ebp.word(Instructions.BSWAPW(CPU_Regs.reg_ebp.word()));
                return 3;
            }
        };
        Prefix_0f.ops[462] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_esi.word(Instructions.BSWAPW(CPU_Regs.reg_esi.word()));
                return 3;
            }
        };
        Prefix_0f.ops[462] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_edi.word(Instructions.BSWAPW(CPU_Regs.reg_edi.word()));
                return 3;
            }
        };
    }
}

