/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_normal;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.Modrm;
import jdos.cpu.Paging;
import jdos.cpu.Table_ea;
import jdos.cpu.core_normal.Prefix_66;
import jdos.cpu.core_normal.Prefix_helpers;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.util.IntRef;
import jdos.util.LongRef;

public class Prefix_66_0f
extends Prefix_66 {
    private static final IntRef int_ref_1 = new IntRef(0);
    private static final LongRef long_ref_1 = new LongRef(0L);

    static {
        Prefix_66_0f.ops[768] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: 
                    case 1: {
                        int saveval = which == 0 ? CPU.CPU_SLDT() : CPU.CPU_STR();
                        if (rm >= 192) {
                            Modrm.GetEArw[rm].word(saveval);
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writew(eaa, saveval);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        int loadval;
                        if (rm >= 192) {
                            loadval = Modrm.GetEArw[rm].word();
                        } else {
                            int eaa = Table_ea.getEaa(rm);
                            loadval = Memory.mem_readw(eaa);
                        }
                        switch (which) {
                            case 2: {
                                if (CPU.cpu.cpl != 0) {
                                    return Prefix_helpers.EXCEPTION(13);
                                }
                                if (!CPU.CPU_LLDT(loadval)) break;
                                return Prefix_helpers.RUNEXCEPTION();
                            }
                            case 3: {
                                if (CPU.cpu.cpl != 0) {
                                    return Prefix_helpers.EXCEPTION(13);
                                }
                                if (!CPU.CPU_LTR(loadval)) break;
                                return Prefix_helpers.RUNEXCEPTION();
                            }
                            case 4: {
                                CPU.CPU_VERR(loadval);
                                break;
                            }
                            case 5: {
                                CPU.CPU_VERW(loadval);
                            }
                        }
                        break;
                    }
                    default: {
                        Log.log(8, 2, "GRP6:Illegal call " + Integer.toString(which, 16));
                        return 1;
                    }
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[769] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm < 192) {
                    int eaa = Table_ea.getEaa(rm);
                    switch (which) {
                        case 0: {
                            Memory.mem_writew(eaa, CPU.CPU_SGDT_limit());
                            Memory.mem_writed(eaa + 2, CPU.CPU_SGDT_base());
                            break;
                        }
                        case 1: {
                            Memory.mem_writew(eaa, CPU.CPU_SIDT_limit());
                            Memory.mem_writed(eaa + 2, CPU.CPU_SIDT_base());
                            break;
                        }
                        case 2: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            CPU.CPU_LGDT(Memory.mem_readw(eaa), Memory.mem_readd(eaa + 2));
                            break;
                        }
                        case 3: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            CPU.CPU_LIDT(Memory.mem_readw(eaa), Memory.mem_readd(eaa + 2));
                            break;
                        }
                        case 4: {
                            Memory.mem_writew(eaa, CPU.CPU_SMSW() & 0xFFFF);
                            break;
                        }
                        case 6: {
                            int limit = Memory.mem_readw(eaa);
                            if (!CPU.CPU_LMSW(limit)) break;
                            return Prefix_helpers.RUNEXCEPTION();
                        }
                        case 7: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            Paging.PAGING_ClearTLB();
                        }
                    }
                } else {
                    switch (which) {
                        case 2: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            return 1;
                        }
                        case 3: {
                            if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                                return Prefix_helpers.EXCEPTION(13);
                            }
                            return 1;
                        }
                        case 4: {
                            Modrm.GetEArd[rm].dword = CPU.CPU_SMSW();
                            break;
                        }
                        case 6: {
                            if (!CPU.CPU_LMSW(Modrm.GetEArd[rm].dword)) break;
                            return Prefix_helpers.RUNEXCEPTION();
                        }
                        default: {
                            Log.log(8, 2, "Illegal group 7 RM subfunction " + which);
                            return 1;
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[770] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int_ref_1.value = Modrm.Getrd[rm].dword;
                if (rm >= 192) {
                    CPU.CPU_LAR(Modrm.GetEArw[rm].word(), int_ref_1);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    CPU.CPU_LAR(Memory.mem_readw(eaa), int_ref_1);
                }
                Modrm.Getrd[rm].dword = int_ref_1.value;
                return 3;
            }
        };
        Prefix_66_0f.ops[771] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int_ref_1.value = Modrm.Getrd[rm].dword;
                if (rm >= 192) {
                    CPU.CPU_LSL(Modrm.GetEArw[rm].word(), int_ref_1);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    CPU.CPU_LSL(Memory.mem_readw(eaa), int_ref_1);
                }
                Modrm.Getrd[rm].dword = int_ref_1.value;
                return 3;
            }
        };
        Prefix_66_0f.ops[896] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_O());
                return 6;
            }
        };
        Prefix_66_0f.ops[897] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NO());
                return 6;
            }
        };
        Prefix_66_0f.ops[898] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_B());
                return 6;
            }
        };
        Prefix_66_0f.ops[899] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NB());
                return 6;
            }
        };
        Prefix_66_0f.ops[900] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_Z());
                return 6;
            }
        };
        Prefix_66_0f.ops[901] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NZ());
                return 6;
            }
        };
        Prefix_66_0f.ops[902] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_BE());
                return 6;
            }
        };
        Prefix_66_0f.ops[903] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NBE());
                return 6;
            }
        };
        Prefix_66_0f.ops[904] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_S());
                return 6;
            }
        };
        Prefix_66_0f.ops[905] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NS());
                return 6;
            }
        };
        Prefix_66_0f.ops[906] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_P());
                return 6;
            }
        };
        Prefix_66_0f.ops[907] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NP());
                return 6;
            }
        };
        Prefix_66_0f.ops[908] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_L());
                return 6;
            }
        };
        Prefix_66_0f.ops[909] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NL());
                return 6;
            }
        };
        Prefix_66_0f.ops[910] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_LE());
                return 6;
            }
        };
        Prefix_66_0f.ops[911] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond32_d(Flags.TFLG_NLE());
                return 6;
            }
        };
        Prefix_66_0f.ops[928] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU.Segs_FSval);
                return 3;
            }
        };
        Prefix_66_0f.ops[929] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegFS(true)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[931] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                int mask = 1 << (Modrm.Getrd[rm].dword & 0x1F);
                if (rm >= 192) {
                    CPU_Regs.SETFLAGBIT(1, (Modrm.GetEArd[rm].dword & mask) != 0);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readd(eaa += (Modrm.Getrd[rm].dword >> 5) * 4);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[932] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    int op3 = Core.Fetchb() & 0x1F;
                    if (op3 != 0) {
                        CPU_Regs.Reg r = Modrm.GetEArd[rm];
                        r.dword = Instructions.DSHLD(Modrm.Getrd[rm].dword, op3, r.dword);
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int op3 = Core.Fetchb() & 0x1F;
                    if (op3 != 0) {
                        Memory.mem_writed(eaa, Instructions.DSHLD(Modrm.Getrd[rm].dword, op3, Memory.mem_readd(eaa)));
                    }
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[933] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int val = CPU_Regs.reg_ecx.dword & 0x1F;
                if (rm >= 192) {
                    if (val != 0) {
                        CPU_Regs.Reg r = Modrm.GetEArd[rm];
                        r.dword = Instructions.DSHLD(Modrm.Getrd[rm].dword, val, r.dword);
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    if (val != 0) {
                        Memory.mem_writed(eaa, Instructions.DSHLD(Modrm.Getrd[rm].dword, val, Memory.mem_readd(eaa)));
                    }
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[936] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push32(CPU.Segs_GSval);
                return 3;
            }
        };
        Prefix_66_0f.ops[937] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegGS(true)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[939] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                CPU_Regs.Reg rd = Modrm.Getrd[rm];
                int mask = 1 << (rd.dword & 0x1F);
                if (rm >= 192) {
                    CPU_Regs.Reg eard = Modrm.GetEArd[rm];
                    CPU_Regs.SETFLAGBIT(1, (eard.dword & mask) != 0);
                    eard.dword |= mask;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readd(eaa += (rd.dword >> 5) * 4);
                    Memory.mem_writed(eaa, old | mask);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[940] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    int op3 = Core.Fetchb() & 0x1F;
                    if (op3 != 0) {
                        CPU_Regs.Reg r = Modrm.GetEArd[rm];
                        r.dword = Instructions.DSHRD(Modrm.Getrd[rm].dword, op3, r.dword);
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int op3 = Core.Fetchb() & 0x1F;
                    if (op3 != 0) {
                        Memory.mem_writed(eaa, Instructions.DSHRD(Modrm.Getrd[rm].dword, op3, Memory.mem_readd(eaa)));
                    }
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[941] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int val = CPU_Regs.reg_ecx.dword & 0x1F;
                if (rm >= 192) {
                    if (val != 0) {
                        CPU_Regs.Reg r = Modrm.GetEArd[rm];
                        r.dword = Instructions.DSHRD(Modrm.Getrd[rm].dword, val, r.dword);
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    if (val != 0) {
                        Memory.mem_writed(eaa, Instructions.DSHRD(Modrm.Getrd[rm].dword, val, Memory.mem_readd(eaa)));
                    }
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[943] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrd[rm];
                r.dword = rm >= 192 ? Instructions.DIMULD(Modrm.GetEArd[rm].dword, r.dword) : Instructions.DIMULD(Memory.mem_readd(Table_ea.getEaa(rm)), r.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[945] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 69) {
                    return 1;
                }
                Flags.FillFlags();
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg eard = Modrm.GetEArd[rm];
                    if (eard.dword == CPU_Regs.reg_eax.dword) {
                        eard.dword = Modrm.Getrd[rm].dword;
                        CPU_Regs.SETFLAGBIT(64, true);
                    } else {
                        CPU_Regs.reg_eax.dword = eard.dword;
                        CPU_Regs.SETFLAGBIT(64, false);
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int val = Memory.mem_readd(eaa);
                    if (val == CPU_Regs.reg_eax.dword) {
                        Memory.mem_writed(eaa, Modrm.Getrd[rm].dword);
                        CPU_Regs.SETFLAGBIT(64, true);
                    } else {
                        Memory.mem_writed(eaa, val);
                        CPU_Regs.reg_eax.dword = val;
                        CPU_Regs.SETFLAGBIT(64, false);
                    }
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[946] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralSS(Memory.mem_readw(eaa + 4))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrd[rm].dword = Memory.mem_readd(eaa);
                return 3;
            }
        };
        Prefix_66_0f.ops[947] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                CPU_Regs.Reg rd = Modrm.Getrd[rm];
                int mask = 1 << (rd.dword & 0x1F);
                if (rm >= 192) {
                    CPU_Regs.Reg eard = Modrm.GetEArd[rm];
                    CPU_Regs.SETFLAGBIT(1, (eard.dword & mask) != 0);
                    eard.dword &= ~mask;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readd(eaa += (rd.dword >> 5) * 4);
                    Memory.mem_writed(eaa, old & ~mask);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[948] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralFS(Memory.mem_readw(eaa + 4))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrd[rm].dword = Memory.mem_readd(eaa);
                return 3;
            }
        };
        Prefix_66_0f.ops[949] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralGS(Memory.mem_readw(eaa + 4))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrd[rm].dword = Memory.mem_readd(eaa);
                return 3;
            }
        };
        Prefix_66_0f.ops[950] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrd[rm].dword = Modrm.GetEArb[rm].get();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrd[rm].dword = Memory.mem_readb(eaa);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[951] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrd[rm].dword = Modrm.GetEArw[rm].word();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrd[rm].dword = Memory.mem_readw(eaa);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[954] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    int mask = 1 << (Core.Fetchb() & 0x1F);
                    CPU_Regs.Reg eard = Modrm.GetEArd[rm];
                    CPU_Regs.SETFLAGBIT(1, (eard.dword & mask) != 0);
                    switch (rm & 0x38) {
                        case 32: {
                            break;
                        }
                        case 40: {
                            eard.dword |= mask;
                            break;
                        }
                        case 48: {
                            eard.dword &= ~mask;
                            break;
                        }
                        case 56: {
                            if (CPU_Regs.GETFLAG(1) != 0) {
                                eard.dword &= ~mask;
                                break;
                            }
                            eard.dword |= mask;
                            break;
                        }
                        default: {
                            Log.exit("CPU:66:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                            break;
                        }
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readd(eaa);
                    int mask = 1 << (Core.Fetchb() & 0x1F);
                    switch (rm & 0x38) {
                        case 32: {
                            break;
                        }
                        case 40: {
                            Memory.mem_writed(eaa, old | mask);
                            break;
                        }
                        case 48: {
                            Memory.mem_writed(eaa, old & ~mask);
                            break;
                        }
                        case 56: {
                            old = CPU_Regs.GETFLAG(1) != 0 ? (old &= ~mask) : (old |= mask);
                            Memory.mem_writed(eaa, old);
                            break;
                        }
                        default: {
                            Log.exit("CPU:66:0F:BA:Illegal subfunction " + Integer.toString(rm & 0x38, 16));
                        }
                    }
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[955] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                short rm = Core.Fetchb();
                int mask = 1 << (Modrm.Getrd[rm].dword & 0x1F);
                if (rm >= 192) {
                    CPU_Regs.Reg eard = Modrm.GetEArd[rm];
                    CPU_Regs.SETFLAGBIT(1, (eard.dword & mask) != 0);
                    eard.dword ^= mask;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int old = Memory.mem_readd(eaa += (Modrm.Getrd[rm].dword >> 5) * 4);
                    Memory.mem_writed(eaa, old ^ mask);
                    CPU_Regs.SETFLAGBIT(1, (old & mask) != 0);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[956] = new Prefix_helpers.OP(){

            public final int call() {
                int value;
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    value = Modrm.GetEArd[rm].dword;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    value = Memory.mem_readd(eaa);
                }
                if (value == 0) {
                    CPU_Regs.SETFLAGBIT(64, true);
                } else {
                    int result = 0;
                    while ((value & 1) == 0) {
                        ++result;
                        value >>>= 1;
                    }
                    CPU_Regs.SETFLAGBIT(64, false);
                    Modrm.Getrd[rm].dword = result;
                }
                Flags.lflags.type = 0;
                return 3;
            }
        };
        Prefix_66_0f.ops[957] = new Prefix_helpers.OP(){

            public final int call() {
                int value;
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    value = Modrm.GetEArd[rm].dword;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    value = Memory.mem_readd(eaa);
                }
                if (value == 0) {
                    CPU_Regs.SETFLAGBIT(64, true);
                } else {
                    int result = 31;
                    while ((value & Integer.MIN_VALUE) == 0) {
                        --result;
                        value <<= 1;
                    }
                    CPU_Regs.SETFLAGBIT(64, false);
                    Modrm.Getrd[rm].dword = result;
                }
                Flags.lflags.type = 0;
                return 3;
            }
        };
        Prefix_66_0f.ops[958] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrd[rm].dword = (byte)Modrm.GetEArb[rm].get();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrd[rm].dword = (byte)Memory.mem_readb(eaa);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[959] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrd[rm].dword = (short)Modrm.GetEArw[rm].word();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrd[rm].dword = (short)Memory.mem_readw(eaa);
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[961] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                short rm = Core.Fetchb();
                int oldrmrd = Modrm.Getrd[rm].dword;
                if (rm >= 192) {
                    Modrm.Getrd[rm].dword = Modrm.GetEArd[rm].dword;
                    Modrm.GetEArd[rm].dword += oldrmrd;
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int value = Memory.mem_readd(eaa);
                    Memory.mem_writed(eaa, value + oldrmrd);
                    Modrm.Getrd[rm].dword = value;
                }
                return 3;
            }
        };
        Prefix_66_0f.ops[968] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_eax.dword = Instructions.BSWAPD(CPU_Regs.reg_eax.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[969] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_ecx.dword = Instructions.BSWAPD(CPU_Regs.reg_ecx.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[970] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_edx.dword = Instructions.BSWAPD(CPU_Regs.reg_edx.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[971] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_ebx.dword = Instructions.BSWAPD(CPU_Regs.reg_ebx.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[972] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_esp.dword = Instructions.BSWAPD(CPU_Regs.reg_esp.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[973] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_ebp.dword = Instructions.BSWAPD(CPU_Regs.reg_ebp.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[974] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_esi.dword = Instructions.BSWAPD(CPU_Regs.reg_esi.dword);
                return 3;
            }
        };
        Prefix_66_0f.ops[975] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_ArchitectureType < 64) {
                    return 1;
                }
                CPU_Regs.reg_edi.dword = Instructions.BSWAPD(CPU_Regs.reg_edi.dword);
                return 3;
            }
        };
    }
}

