/*
 * Decompiled with CFR 0.152.
 */
package jdos.cpu.core_normal;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Core;
import jdos.cpu.Core_normal;
import jdos.cpu.Flags;
import jdos.cpu.Instructions;
import jdos.cpu.Modrm;
import jdos.cpu.StringOp;
import jdos.cpu.Table_ea;
import jdos.cpu.core_normal.Prefix_helpers;
import jdos.fpu.FPU;
import jdos.hardware.IO;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.util.IntRef;

public class Prefix_none
extends StringOp {
    protected static final boolean CPU_TRAP_CHECK = true;
    protected static final boolean CPU_PIC_CHECK = true;
    public static int returnValue = 0;
    public static Prefix_helpers.OP[] ops = new Prefix_helpers.OP[1024];
    static final CPU.Descriptor desc = new CPU.Descriptor();
    private static final IntRef int_ref_1 = new IntRef(0);

    static {
        Prefix_helpers.OP not_handled = new Prefix_helpers.OP(){

            public int call() {
                return 2;
            }
        };
        for (int i = 0; i < ops.length; ++i) {
            Prefix_none.ops[i] = not_handled;
        }
        Prefix_none.ops[0] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    short value = 0;
                    switch (rm >> 3 & 7) {
                        case 0: {
                            value = CPU_Regs.reg_eax.low();
                            break;
                        }
                        case 1: {
                            value = CPU_Regs.reg_ecx.low();
                            break;
                        }
                        case 2: {
                            value = CPU_Regs.reg_edx.low();
                            break;
                        }
                        case 3: {
                            value = CPU_Regs.reg_ebx.low();
                            break;
                        }
                        case 4: {
                            value = CPU_Regs.reg_eax.high();
                            break;
                        }
                        case 5: {
                            value = CPU_Regs.reg_ecx.high();
                            break;
                        }
                        case 6: {
                            value = CPU_Regs.reg_edx.high();
                            break;
                        }
                        case 7: {
                            value = CPU_Regs.reg_ebx.high();
                        }
                    }
                    switch (rm & 7) {
                        case 0: {
                            CPU_Regs.reg_eax.low(Instructions.ADDB(value, CPU_Regs.reg_eax.low()));
                            break;
                        }
                        case 1: {
                            CPU_Regs.reg_ecx.low(Instructions.ADDB(value, CPU_Regs.reg_ecx.low()));
                            break;
                        }
                        case 2: {
                            CPU_Regs.reg_edx.low(Instructions.ADDB(value, CPU_Regs.reg_edx.low()));
                            break;
                        }
                        case 3: {
                            CPU_Regs.reg_ebx.low(Instructions.ADDB(value, CPU_Regs.reg_ebx.low()));
                            break;
                        }
                        case 4: {
                            CPU_Regs.reg_eax.high(Instructions.ADDB(value, CPU_Regs.reg_eax.high()));
                            break;
                        }
                        case 5: {
                            CPU_Regs.reg_ecx.high(Instructions.ADDB(value, CPU_Regs.reg_ecx.high()));
                            break;
                        }
                        case 6: {
                            CPU_Regs.reg_edx.high(Instructions.ADDB(value, CPU_Regs.reg_edx.high()));
                            break;
                        }
                        case 7: {
                            CPU_Regs.reg_ebx.high(Instructions.ADDB(value, CPU_Regs.reg_ebx.high()));
                        }
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Instructions.ADDB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[512] = ops[0];
        Prefix_none.ops[1] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(Instructions.ADDW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Instructions.ADDW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[2] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Instructions.ADDB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get()));
                } else {
                    Modrm.Getrb[rm].set(Instructions.ADDB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get()));
                }
                return 3;
            }
        };
        Prefix_none.ops[514] = ops[2];
        Prefix_none.ops[3] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Instructions.ADDW(Modrm.GetEArw[rm].word(), Modrm.Getrw[rm].word()));
                } else {
                    Modrm.Getrw[rm].word(Instructions.ADDW(Memory.mem_readw(Table_ea.getEaa(rm)), Modrm.Getrw[rm].word()));
                }
                return 3;
            }
        };
        Prefix_none.ops[4] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Instructions.ADDB(Core.Fetchb(), CPU_Regs.reg_eax.low()));
                return 3;
            }
        };
        Prefix_none.ops[516] = ops[4];
        Prefix_none.ops[5] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Instructions.ADDW(Core.Fetchw(), CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_none.ops[6] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU.Segs_ESval);
                return 3;
            }
        };
        Prefix_none.ops[7] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegES(false)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_none.ops[8] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArb[rm].set(Instructions.ORB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Instructions.ORB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[520] = ops[8];
        Prefix_none.ops[9] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Prefix_helpers.r = rm;
                    Modrm.GetEArw[rm].word(Instructions.ORW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Instructions.ORW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[10] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Instructions.ORB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get()));
                } else {
                    Modrm.Getrb[rm].set(Instructions.ORB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get()));
                }
                return 3;
            }
        };
        Prefix_none.ops[522] = ops[10];
        Prefix_none.ops[11] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                CPU_Regs.Reg r = Modrm.Getrw[rm];
                if (rm >= 192) {
                    r.word(Instructions.ORW(Modrm.GetEArw[rm].word(), r.word()));
                } else {
                    r.word(Instructions.ORW(Memory.mem_readw(Table_ea.getEaa(rm)), r.word()));
                }
                return 3;
            }
        };
        Prefix_none.ops[12] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Instructions.ORB(Core.Fetchb(), CPU_Regs.reg_eax.low()));
                return 3;
            }
        };
        Prefix_none.ops[524] = ops[12];
        Prefix_none.ops[13] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Instructions.ORW(Core.Fetchw(), CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_none.ops[14] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU.Segs_CSval);
                return 3;
            }
        };
        Prefix_none.ops[15] = new Prefix_helpers.OP(){

            public final int call() {
                Core.opcode_index |= 0x100;
                return 4;
            }
        };
        Prefix_none.ops[527] = ops[15];
        Prefix_none.ops[16] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Prefix_helpers.r = rm;
                    Modrm.GetEArb[rm].set(Instructions.ADCB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Instructions.ADCB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[528] = ops[16];
        Prefix_none.ops[17] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(Instructions.ADCW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Instructions.ADCW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[18] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Instructions.ADCB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get()));
                } else {
                    Modrm.Getrb[rm].set(Instructions.ADCB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get()));
                }
                return 3;
            }
        };
        Prefix_none.ops[530] = ops[18];
        Prefix_none.ops[19] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Instructions.ADCW(Modrm.GetEArw[rm].word(), Modrm.Getrw[rm].word()));
                } else {
                    Modrm.Getrw[rm].word(Instructions.ADCW(Memory.mem_readw(Table_ea.getEaa(rm)), Modrm.Getrw[rm].word()));
                }
                return 3;
            }
        };
        Prefix_none.ops[20] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Instructions.ADCB(Core.Fetchb(), CPU_Regs.reg_eax.low()));
                return 3;
            }
        };
        Prefix_none.ops[532] = ops[20];
        Prefix_none.ops[21] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Instructions.ADCW(Core.Fetchw(), CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_none.ops[22] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU.Segs_SSval);
                return 3;
            }
        };
        Prefix_none.ops[23] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegSS(false)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                ++CPU.CPU_Cycles;
                return 3;
            }
        };
        Prefix_none.ops[24] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArb[rm].set(Instructions.SBBB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Instructions.SBBB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[536] = ops[24];
        Prefix_none.ops[25] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Prefix_helpers.r = rm;
                    Modrm.GetEArw[rm].word(Instructions.SBBW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Instructions.SBBW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[26] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Instructions.SBBB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get()));
                } else {
                    Modrm.Getrb[rm].set(Instructions.SBBB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get()));
                }
                return 3;
            }
        };
        Prefix_none.ops[538] = ops[26];
        Prefix_none.ops[27] = new Prefix_helpers.OP(){

            public final int call() {
                short rm;
                Prefix_helpers.r = rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Instructions.SBBW(Modrm.GetEArw[rm].word(), Modrm.Getrw[rm].word()));
                } else {
                    Modrm.Getrw[rm].word(Instructions.SBBW(Memory.mem_readw(Table_ea.getEaa(rm)), Modrm.Getrw[rm].word()));
                }
                return 3;
            }
        };
        Prefix_none.ops[28] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Instructions.SBBB(Core.Fetchb(), CPU_Regs.reg_eax.low()));
                return 3;
            }
        };
        Prefix_none.ops[540] = ops[28];
        Prefix_none.ops[29] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Instructions.SBBW(Core.Fetchw(), CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_none.ops[30] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU.Segs_DSval);
                return 3;
            }
        };
        Prefix_none.ops[31] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PopSegDS(false)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_none.ops[32] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArb[rm].set(Instructions.ANDB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Instructions.ANDB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[544] = ops[32];
        Prefix_none.ops[33] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(Instructions.ANDW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Instructions.ANDW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[34] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Instructions.ANDB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get()));
                } else {
                    Modrm.Getrb[rm].set(Instructions.ANDB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get()));
                }
                return 3;
            }
        };
        Prefix_none.ops[546] = ops[34];
        Prefix_none.ops[35] = new Prefix_helpers.OP(){

            public final int call() {
                short rm;
                Prefix_helpers.r = rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Instructions.ANDW(Modrm.GetEArw[rm].word(), Modrm.Getrw[rm].word()));
                } else {
                    Modrm.Getrw[rm].word(Instructions.ANDW(Memory.mem_readw(Table_ea.getEaa(rm)), Modrm.Getrw[rm].word()));
                }
                return 3;
            }
        };
        Prefix_none.ops[36] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Instructions.ANDB(Core.Fetchb(), CPU_Regs.reg_eax.low()));
                return 3;
            }
        };
        Prefix_none.ops[548] = ops[36];
        Prefix_none.ops[37] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Instructions.ANDW(Core.Fetchw(), CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_none.ops[38] = new Prefix_helpers.OP(){

            public final int call() {
                Core.DO_PREFIX_SEG_ES();
                return 4;
            }
        };
        Prefix_none.ops[550] = ops[38];
        Prefix_none.ops[39] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.DAA();
                return 3;
            }
        };
        Prefix_none.ops[551] = ops[39];
        Prefix_none.ops[40] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArb[rm].set(Instructions.SUBB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Instructions.SUBB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[552] = ops[40];
        Prefix_none.ops[41] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(Instructions.SUBW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Instructions.SUBW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[42] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Instructions.SUBB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get()));
                } else {
                    Modrm.Getrb[rm].set(Instructions.SUBB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get()));
                }
                return 3;
            }
        };
        Prefix_none.ops[554] = ops[42];
        Prefix_none.ops[43] = new Prefix_helpers.OP(){

            public final int call() {
                short rm;
                Prefix_helpers.r = rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Instructions.SUBW(Modrm.GetEArw[rm].word(), Modrm.Getrw[rm].word()));
                } else {
                    Modrm.Getrw[rm].word(Instructions.SUBW(Memory.mem_readw(Table_ea.getEaa(rm)), Modrm.Getrw[rm].word()));
                }
                return 3;
            }
        };
        Prefix_none.ops[44] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Instructions.SUBB(Core.Fetchb(), CPU_Regs.reg_eax.low()));
                return 3;
            }
        };
        Prefix_none.ops[556] = ops[44];
        Prefix_none.ops[45] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Instructions.SUBW(Core.Fetchw(), CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_none.ops[46] = new Prefix_helpers.OP(){

            public final int call() {
                Core.DO_PREFIX_SEG_CS();
                return 4;
            }
        };
        Prefix_none.ops[558] = ops[46];
        Prefix_none.ops[47] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.DAS();
                return 3;
            }
        };
        Prefix_none.ops[559] = ops[47];
        Prefix_none.ops[48] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArb[rm].set(Instructions.XORB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Instructions.XORB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[560] = ops[48];
        Prefix_none.ops[49] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(Instructions.XORW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word()));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Instructions.XORW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa)));
                }
                return 3;
            }
        };
        Prefix_none.ops[50] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Instructions.XORB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get()));
                } else {
                    Modrm.Getrb[rm].set(Instructions.XORB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get()));
                }
                return 3;
            }
        };
        Prefix_none.ops[562] = ops[50];
        Prefix_none.ops[51] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Instructions.XORW(Modrm.GetEArw[rm].word(), Modrm.Getrw[rm].word()));
                } else {
                    Modrm.Getrw[rm].word(Instructions.XORW(Memory.mem_readw(Table_ea.getEaa(rm)), Modrm.Getrw[rm].word()));
                }
                return 3;
            }
        };
        Prefix_none.ops[52] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Instructions.XORB(Core.Fetchb(), CPU_Regs.reg_eax.low()));
                return 3;
            }
        };
        Prefix_none.ops[564] = ops[52];
        Prefix_none.ops[53] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Instructions.XORW(Core.Fetchw(), CPU_Regs.reg_eax.word()));
                return 3;
            }
        };
        Prefix_none.ops[54] = new Prefix_helpers.OP(){

            public final int call() {
                Core.DO_PREFIX_SEG_SS();
                return 4;
            }
        };
        Prefix_none.ops[566] = ops[54];
        Prefix_none.ops[55] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.AAA();
                return 3;
            }
        };
        Prefix_none.ops[567] = ops[55];
        Prefix_none.ops[56] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.CMPB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Instructions.CMPB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa));
                }
                return 3;
            }
        };
        Prefix_none.ops[568] = ops[56];
        Prefix_none.ops[57] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.CMPW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Instructions.CMPW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa));
                }
                return 3;
            }
        };
        Prefix_none.ops[58] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.CMPB(Modrm.GetEArb[rm].get(), Modrm.Getrb[rm].get());
                } else {
                    Instructions.CMPB(Memory.mem_readb(Table_ea.getEaa(rm)), Modrm.Getrb[rm].get());
                }
                return 3;
            }
        };
        Prefix_none.ops[570] = ops[58];
        Prefix_none.ops[59] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.CMPW(Modrm.GetEArw[rm].word(), Modrm.Getrw[rm].word());
                } else {
                    Instructions.CMPW(Memory.mem_readw(Table_ea.getEaa(rm)), Modrm.Getrw[rm].word());
                }
                return 3;
            }
        };
        Prefix_none.ops[60] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.CMPB(Core.Fetchb(), CPU_Regs.reg_eax.low());
                return 3;
            }
        };
        Prefix_none.ops[572] = ops[60];
        Prefix_none.ops[61] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.CMPW(Core.Fetchw(), CPU_Regs.reg_eax.word());
                return 3;
            }
        };
        Prefix_none.ops[62] = new Prefix_helpers.OP(){

            public final int call() {
                Core.DO_PREFIX_SEG_DS();
                return 4;
            }
        };
        Prefix_none.ops[574] = ops[62];
        Prefix_none.ops[63] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.AAS();
                return 3;
            }
        };
        Prefix_none.ops[575] = ops[63];
        Prefix_none.ops[64] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_eax.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_eax.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[65] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_ecx.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_ecx.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[66] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_edx.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_edx.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[67] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_ebx.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_ebx.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[68] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_esp.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_esp.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[69] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_ebp.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_ebp.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[70] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_esi.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_esi.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[71] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_edi.word());
                Flags.lf_resw(Flags.lf_var1w() + 1);
                CPU_Regs.reg_edi.word(Flags.lf_resw());
                Flags.lflags.type = 26;
                return 3;
            }
        };
        Prefix_none.ops[72] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_eax.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_eax.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[73] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_ecx.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_ecx.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[74] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_edx.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_edx.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[75] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_ebx.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_ebx.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[76] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_esp.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_esp.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[77] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_ebp.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_ebp.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[78] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_esi.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_esi.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[79] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.LoadCF();
                Flags.lf_var1w(CPU_Regs.reg_edi.word());
                Flags.lf_resw(Flags.lf_var1w() - 1);
                CPU_Regs.reg_edi.word(Flags.lf_resw());
                Flags.lflags.type = 29;
                return 3;
            }
        };
        Prefix_none.ops[80] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_eax.word());
                return 3;
            }
        };
        Prefix_none.ops[81] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_ecx.word());
                return 3;
            }
        };
        Prefix_none.ops[82] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_edx.word());
                return 3;
            }
        };
        Prefix_none.ops[83] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_ebx.word());
                return 3;
            }
        };
        Prefix_none.ops[84] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_esp.word());
                return 3;
            }
        };
        Prefix_none.ops[85] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_ebp.word());
                return 3;
            }
        };
        Prefix_none.ops[86] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_esi.word());
                return 3;
            }
        };
        Prefix_none.ops[87] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(CPU_Regs.reg_edi.word());
                return 3;
            }
        };
        Prefix_none.ops[88] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[89] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[90] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[91] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[92] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[93] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebp.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[94] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esi.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[95] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[96] = new Prefix_helpers.OP(){

            public final int call() {
                int old_sp = CPU_Regs.reg_esp.word();
                CPU.CPU_Push16(CPU_Regs.reg_eax.word());
                CPU.CPU_Push16(CPU_Regs.reg_ecx.word());
                CPU.CPU_Push16(CPU_Regs.reg_edx.word());
                CPU.CPU_Push16(CPU_Regs.reg_ebx.word());
                CPU.CPU_Push16(old_sp);
                CPU.CPU_Push16(CPU_Regs.reg_ebp.word());
                CPU.CPU_Push16(CPU_Regs.reg_esi.word());
                CPU.CPU_Push16(CPU_Regs.reg_edi.word());
                return 3;
            }
        };
        Prefix_none.ops[97] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.word(CPU.CPU_Pop16());
                CPU_Regs.reg_esi.word(CPU.CPU_Pop16());
                CPU_Regs.reg_ebp.word(CPU.CPU_Pop16());
                CPU.CPU_Pop16();
                CPU_Regs.reg_ebx.word(CPU.CPU_Pop16());
                CPU_Regs.reg_edx.word(CPU.CPU_Pop16());
                CPU_Regs.reg_ecx.word(CPU.CPU_Pop16());
                CPU_Regs.reg_eax.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[98] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int eaa = Table_ea.getEaa(rm);
                short bound_min = (short)Memory.mem_readw(eaa);
                short bound_max = (short)Memory.mem_readw(eaa + 2);
                if ((short)Modrm.Getrw[rm].word() < bound_min || (short)Modrm.Getrw[rm].word() > bound_max) {
                    return Prefix_helpers.EXCEPTION(5);
                }
                return 3;
            }
        };
        Prefix_none.ops[99] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.flags & 0x20000) != 0 || !CPU.cpu.pmode) {
                    return 1;
                }
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    int_ref_1.value = Modrm.GetEArw[rm].word();
                    CPU.CPU_ARPL(int_ref_1, Modrm.Getrw[rm].word());
                    Modrm.GetEArw[rm].word(int_ref_1.value);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int_ref_1.value = Memory.mem_readw(eaa);
                    CPU.CPU_ARPL(int_ref_1, Modrm.Getrw[rm].word());
                    Memory.mem_writew(eaa, int_ref_1.value);
                }
                return 3;
            }
        };
        Prefix_none.ops[100] = new Prefix_helpers.OP(){

            public final int call() {
                Core.DO_PREFIX_SEG_FS();
                return 4;
            }
        };
        Prefix_none.ops[612] = ops[100];
        Prefix_none.ops[101] = new Prefix_helpers.OP(){

            public final int call() {
                Core.DO_PREFIX_SEG_GS();
                return 4;
            }
        };
        Prefix_none.ops[613] = ops[101];
        Prefix_none.ops[102] = new Prefix_helpers.OP(){

            public final int call() {
                Core.opcode_index = CPU.cpu.code.big ? 0 : 512;
                return 4;
            }
        };
        Prefix_none.ops[614] = ops[102];
        Prefix_none.ops[103] = new Prefix_helpers.OP(){

            public final int call() {
                Core.prefixes = Core.prefixes & 0xFFFFFFFE | (CPU.cpu.code.big ? 0 : 1);
                Table_ea.EA16 = (Core.prefixes & 1) == 0;
                return 4;
            }
        };
        Prefix_none.ops[615] = ops[103];
        Prefix_none.ops[104] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[105] = new Prefix_helpers.OP(){

            public final int call() {
                short rm;
                Prefix_helpers.r = rm = Core.Fetchb();
                if (rm >= 192) {
                    short op3 = Core.Fetchws();
                    Modrm.Getrw[rm].word(Instructions.DIMULW(Modrm.GetEArw[rm].word(), op3));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    short op3 = Core.Fetchws();
                    Modrm.Getrw[rm].word(Instructions.DIMULW(Memory.mem_readw(eaa), op3));
                }
                return 3;
            }
        };
        Prefix_none.ops[106] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_Push16(Core.Fetchbs());
                return 3;
            }
        };
        Prefix_none.ops[107] = new Prefix_helpers.OP(){

            public final int call() {
                short rm;
                Prefix_helpers.r = rm = Core.Fetchb();
                if (rm >= 192) {
                    byte op3 = Core.Fetchbs();
                    Modrm.Getrw[rm].word(Instructions.DIMULW(Modrm.GetEArw[rm].word(), op3));
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    byte op3 = Core.Fetchbs();
                    Modrm.Getrw[rm].word(Instructions.DIMULW(Memory.mem_readw(eaa), op3));
                }
                return 3;
            }
        };
        Prefix_none.ops[108] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 1)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Prefix_none.DoString(4);
                return 3;
            }
        };
        Prefix_none.ops[620] = ops[108];
        Prefix_none.ops[109] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 2)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Prefix_none.DoString(5);
                return 3;
            }
        };
        Prefix_none.ops[110] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 1)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Prefix_none.DoString(1);
                return 3;
            }
        };
        Prefix_none.ops[622] = ops[110];
        Prefix_none.ops[111] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 2)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Prefix_none.DoString(2);
                return 3;
            }
        };
        Prefix_none.ops[112] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_O());
                return 6;
            }
        };
        Prefix_none.ops[113] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NO());
                return 6;
            }
        };
        Prefix_none.ops[114] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_B());
                return 6;
            }
        };
        Prefix_none.ops[115] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NB());
                return 6;
            }
        };
        Prefix_none.ops[116] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_Z());
                return 6;
            }
        };
        Prefix_none.ops[117] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NZ());
                return 6;
            }
        };
        Prefix_none.ops[118] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_BE());
                return 6;
            }
        };
        Prefix_none.ops[119] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NBE());
                return 6;
            }
        };
        Prefix_none.ops[120] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_S());
                return 6;
            }
        };
        Prefix_none.ops[121] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NS());
                return 6;
            }
        };
        Prefix_none.ops[122] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_P());
                return 6;
            }
        };
        Prefix_none.ops[123] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NP());
                return 6;
            }
        };
        Prefix_none.ops[124] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_L());
                return 6;
            }
        };
        Prefix_none.ops[125] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NL());
                return 6;
            }
        };
        Prefix_none.ops[126] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_LE());
                return 6;
            }
        };
        Prefix_none.ops[127] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(Flags.TFLG_NLE());
                return 6;
            }
        };
        Prefix_none.ops[128] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm >= 192) {
                    Modrm.Getrb_interface r = Modrm.GetEArb[rm];
                    short ib = Core.Fetchb();
                    switch (which) {
                        case 0: {
                            r.set(Instructions.ADDB(ib, r.get()));
                            break;
                        }
                        case 1: {
                            r.set(Instructions.ORB(ib, r.get()));
                            break;
                        }
                        case 2: {
                            r.set(Instructions.ADCB(ib, r.get()));
                            break;
                        }
                        case 3: {
                            r.set(Instructions.SBBB(ib, r.get()));
                            break;
                        }
                        case 4: {
                            r.set(Instructions.ANDB(ib, r.get()));
                            break;
                        }
                        case 5: {
                            r.set(Instructions.SUBB(ib, r.get()));
                            break;
                        }
                        case 6: {
                            r.set(Instructions.XORB(ib, r.get()));
                            break;
                        }
                        case 7: {
                            Instructions.CMPB(ib, r.get());
                        }
                    }
                } else {
                    int eaa = Prefix_helpers.m = Table_ea.getEaa(rm);
                    short ib = Core.Fetchb();
                    switch (which) {
                        case 0: {
                            Memory.mem_writeb(eaa, Instructions.ADDB(ib, Memory.mem_readb(eaa)));
                            break;
                        }
                        case 1: {
                            Memory.mem_writeb(eaa, Instructions.ORB(ib, Memory.mem_readb(eaa)));
                            break;
                        }
                        case 2: {
                            Memory.mem_writeb(eaa, Instructions.ADCB(ib, Memory.mem_readb(eaa)));
                            break;
                        }
                        case 3: {
                            Memory.mem_writeb(eaa, Instructions.SBBB(ib, Memory.mem_readb(eaa)));
                            break;
                        }
                        case 4: {
                            Memory.mem_writeb(eaa, Instructions.ANDB(ib, Memory.mem_readb(eaa)));
                            break;
                        }
                        case 5: {
                            Memory.mem_writeb(eaa, Instructions.SUBB(ib, Memory.mem_readb(eaa)));
                            break;
                        }
                        case 6: {
                            Memory.mem_writeb(eaa, Instructions.XORB(ib, Memory.mem_readb(eaa)));
                            break;
                        }
                        case 7: {
                            Instructions.CMPB(ib, Memory.mem_readb(eaa));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[640] = ops[128];
        Prefix_none.ops[130] = ops[128];
        Prefix_none.ops[642] = ops[128];
        Prefix_none.ops[129] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArw[rm];
                    int iw = Core.Fetchw();
                    switch (which) {
                        case 0: {
                            r.word(Instructions.ADDW(iw, r.word()));
                            break;
                        }
                        case 1: {
                            r.word(Instructions.ORW(iw, r.word()));
                            break;
                        }
                        case 2: {
                            r.word(Instructions.ADCW(iw, r.word()));
                            break;
                        }
                        case 3: {
                            r.word(Instructions.SBBW(iw, r.word()));
                            break;
                        }
                        case 4: {
                            r.word(Instructions.ANDW(iw, r.word()));
                            break;
                        }
                        case 5: {
                            r.word(Instructions.SUBW(iw, r.word()));
                            break;
                        }
                        case 6: {
                            r.word(Instructions.XORW(iw, r.word()));
                            break;
                        }
                        case 7: {
                            Instructions.CMPW(iw, r.word());
                        }
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    int iw = Core.Fetchw();
                    switch (which) {
                        case 0: {
                            Memory.mem_writew(eaa, Instructions.ADDW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 1: {
                            Memory.mem_writew(eaa, Instructions.ORW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 2: {
                            Memory.mem_writew(eaa, Instructions.ADCW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 3: {
                            Memory.mem_writew(eaa, Instructions.SBBW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 4: {
                            Memory.mem_writew(eaa, Instructions.ANDW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 5: {
                            Memory.mem_writew(eaa, Instructions.SUBW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 6: {
                            Memory.mem_writew(eaa, Instructions.XORW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 7: {
                            Instructions.CMPW(iw, Memory.mem_readw(eaa));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[131] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm >= 192) {
                    CPU_Regs.Reg r = Modrm.GetEArw[rm];
                    int iw = (short)Core.Fetchbs() & 0xFFFF;
                    switch (which) {
                        case 0: {
                            r.word(Instructions.ADDW(iw, r.word()));
                            break;
                        }
                        case 1: {
                            r.word(Instructions.ORW(iw, r.word()));
                            break;
                        }
                        case 2: {
                            r.word(Instructions.ADCW(iw, r.word()));
                            break;
                        }
                        case 3: {
                            r.word(Instructions.SBBW(iw, r.word()));
                            break;
                        }
                        case 4: {
                            r.word(Instructions.ANDW(iw, r.word()));
                            break;
                        }
                        case 5: {
                            r.word(Instructions.SUBW(iw, r.word()));
                            break;
                        }
                        case 6: {
                            r.word(Instructions.XORW(iw, r.word()));
                            break;
                        }
                        case 7: {
                            Instructions.CMPW(iw, r.word());
                        }
                    }
                } else {
                    int eaa = Prefix_helpers.m = Table_ea.getEaa(rm);
                    int iw = (short)Core.Fetchbs() & 0xFFFF;
                    switch (which) {
                        case 0: {
                            Memory.mem_writew(eaa, Instructions.ADDW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 1: {
                            Memory.mem_writew(eaa, Instructions.ORW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 2: {
                            Memory.mem_writew(eaa, Instructions.ADCW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 3: {
                            Memory.mem_writew(eaa, Instructions.SBBW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 4: {
                            Memory.mem_writew(eaa, Instructions.ANDW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 5: {
                            Memory.mem_writew(eaa, Instructions.SUBW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 6: {
                            Memory.mem_writew(eaa, Instructions.XORW(iw, Memory.mem_readw(eaa)));
                            break;
                        }
                        case 7: {
                            Instructions.CMPW(iw, Memory.mem_readw(eaa));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[132] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.TESTB(Modrm.Getrb[rm].get(), Modrm.GetEArb[rm].get());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Instructions.TESTB(Modrm.Getrb[rm].get(), Memory.mem_readb(eaa));
                }
                return 3;
            }
        };
        Prefix_none.ops[644] = ops[132];
        Prefix_none.ops[133] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Instructions.TESTW(Modrm.Getrw[rm].word(), Modrm.GetEArw[rm].word());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Instructions.TESTW(Modrm.Getrw[rm].word(), Memory.mem_readw(eaa));
                }
                return 3;
            }
        };
        Prefix_none.ops[134] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                short oldrmrb = Modrm.Getrb[rm].get();
                if (rm >= 192) {
                    Modrm.Getrb[rm].set(Modrm.GetEArb[rm].get());
                    Modrm.GetEArb[rm].set(oldrmrb);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    short val = Memory.mem_readb(eaa);
                    Memory.mem_writeb(eaa, oldrmrb);
                    Modrm.Getrb[rm].set(val);
                }
                return 3;
            }
        };
        Prefix_none.ops[646] = ops[134];
        Prefix_none.ops[135] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    CPU_Regs.Reg rw = Modrm.Getrw[rm];
                    CPU_Regs.Reg ea = Modrm.GetEArw[rm];
                    int oldrmrw = rw.word();
                    rw.word(ea.word());
                    ea.word(oldrmrw);
                } else {
                    int oldrmrw = Modrm.Getrw[rm].word();
                    int eaa = Table_ea.getEaa(rm);
                    int val = Memory.mem_readw(eaa);
                    Memory.mem_writew(eaa, oldrmrw);
                    Modrm.Getrw[rm].word(val);
                }
                return 3;
            }
        };
        Prefix_none.ops[136] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    short value;
                    switch (rm >> 3 & 7) {
                        case 0: {
                            value = CPU_Regs.reg_eax.low();
                            break;
                        }
                        case 1: {
                            value = CPU_Regs.reg_ecx.low();
                            break;
                        }
                        case 2: {
                            value = CPU_Regs.reg_edx.low();
                            break;
                        }
                        case 3: {
                            value = CPU_Regs.reg_ebx.low();
                            break;
                        }
                        case 4: {
                            value = CPU_Regs.reg_eax.high();
                            break;
                        }
                        case 5: {
                            value = CPU_Regs.reg_ecx.high();
                            break;
                        }
                        case 6: {
                            value = CPU_Regs.reg_edx.high();
                            break;
                        }
                        case 7: {
                            value = CPU_Regs.reg_ebx.high();
                            break;
                        }
                        default: {
                            value = 0;
                        }
                    }
                    switch (rm & 7) {
                        case 0: {
                            CPU_Regs.reg_eax.low(value);
                            break;
                        }
                        case 1: {
                            CPU_Regs.reg_ecx.low(value);
                            break;
                        }
                        case 2: {
                            CPU_Regs.reg_edx.low(value);
                            break;
                        }
                        case 3: {
                            CPU_Regs.reg_ebx.low(value);
                            break;
                        }
                        case 4: {
                            CPU_Regs.reg_eax.high(value);
                            break;
                        }
                        case 5: {
                            CPU_Regs.reg_ecx.high(value);
                            break;
                        }
                        case 6: {
                            CPU_Regs.reg_edx.high(value);
                            break;
                        }
                        case 7: {
                            CPU_Regs.reg_ebx.high(value);
                        }
                    }
                } else {
                    if (rm == 5 && CPU.cpu.pmode && !CPU.cpu.code.big) {
                        CPU.cpu.gdt.GetDescriptor(CPU.seg_value(Core.base_val_ds), desc);
                        if (desc.Type() == 26 || desc.Type() == 27) {
                            CPU.CPU_Exception(13, CPU.seg_value(Core.base_val_ds) & 0xFFFC);
                            return 6;
                        }
                    }
                    int eaa = Table_ea.getEaa(rm);
                    switch (rm >> 3 & 7) {
                        case 0: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_eax.low());
                            break;
                        }
                        case 1: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_ecx.low());
                            break;
                        }
                        case 2: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_edx.low());
                            break;
                        }
                        case 3: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_ebx.low());
                            break;
                        }
                        case 4: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_eax.high());
                            break;
                        }
                        case 5: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_ecx.high());
                            break;
                        }
                        case 6: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_edx.high());
                            break;
                        }
                        case 7: {
                            Memory.mem_writeb(eaa, CPU_Regs.reg_ebx.high());
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[648] = ops[136];
        Prefix_none.ops[137] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(Modrm.Getrw[rm].word());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Modrm.Getrw[rm].word());
                }
                return 3;
            }
        };
        Prefix_none.ops[138] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    short value;
                    switch (rm & 7) {
                        case 0: {
                            value = CPU_Regs.reg_eax.low();
                            break;
                        }
                        case 1: {
                            value = CPU_Regs.reg_ecx.low();
                            break;
                        }
                        case 2: {
                            value = CPU_Regs.reg_edx.low();
                            break;
                        }
                        case 3: {
                            value = CPU_Regs.reg_ebx.low();
                            break;
                        }
                        case 4: {
                            value = CPU_Regs.reg_eax.high();
                            break;
                        }
                        case 5: {
                            value = CPU_Regs.reg_ecx.high();
                            break;
                        }
                        case 6: {
                            value = CPU_Regs.reg_edx.high();
                            break;
                        }
                        case 7: {
                            value = CPU_Regs.reg_ebx.high();
                            break;
                        }
                        default: {
                            value = 0;
                        }
                    }
                    switch (rm >> 3 & 7) {
                        case 0: {
                            CPU_Regs.reg_eax.low(value);
                            break;
                        }
                        case 1: {
                            CPU_Regs.reg_ecx.low(value);
                            break;
                        }
                        case 2: {
                            CPU_Regs.reg_edx.low(value);
                            break;
                        }
                        case 3: {
                            CPU_Regs.reg_ebx.low(value);
                            break;
                        }
                        case 4: {
                            CPU_Regs.reg_eax.high(value);
                            break;
                        }
                        case 5: {
                            CPU_Regs.reg_ecx.high(value);
                            break;
                        }
                        case 6: {
                            CPU_Regs.reg_edx.high(value);
                            break;
                        }
                        case 7: {
                            CPU_Regs.reg_ebx.high(value);
                        }
                    }
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    switch (rm >> 3 & 7) {
                        case 0: {
                            CPU_Regs.reg_eax.low(Memory.mem_readb(eaa));
                            break;
                        }
                        case 1: {
                            CPU_Regs.reg_ecx.low(Memory.mem_readb(eaa));
                            break;
                        }
                        case 2: {
                            CPU_Regs.reg_edx.low(Memory.mem_readb(eaa));
                            break;
                        }
                        case 3: {
                            CPU_Regs.reg_ebx.low(Memory.mem_readb(eaa));
                            break;
                        }
                        case 4: {
                            CPU_Regs.reg_eax.high(Memory.mem_readb(eaa));
                            break;
                        }
                        case 5: {
                            CPU_Regs.reg_ecx.high(Memory.mem_readb(eaa));
                            break;
                        }
                        case 6: {
                            CPU_Regs.reg_edx.high(Memory.mem_readb(eaa));
                            break;
                        }
                        case 7: {
                            CPU_Regs.reg_ebx.high(Memory.mem_readb(eaa));
                        }
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[650] = ops[138];
        Prefix_none.ops[139] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.Getrw[rm].word(Modrm.GetEArw[rm].word());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                }
                return 3;
            }
        };
        Prefix_none.ops[140] = new Prefix_helpers.OP(){

            public final int call() {
                int val;
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: {
                        val = CPU.Segs_ESval;
                        break;
                    }
                    case 1: {
                        val = CPU.Segs_CSval;
                        break;
                    }
                    case 2: {
                        val = CPU.Segs_SSval;
                        break;
                    }
                    case 3: {
                        val = CPU.Segs_DSval;
                        break;
                    }
                    case 4: {
                        val = CPU.Segs_FSval;
                        break;
                    }
                    case 5: {
                        val = CPU.Segs_GSval;
                        break;
                    }
                    default: {
                        Log.log(8, 2, "CPU:8c:Illegal RM Byte");
                        return 1;
                    }
                }
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(val);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, val);
                }
                return 3;
            }
        };
        Prefix_none.ops[141] = new Prefix_helpers.OP(){

            public final int call() {
                Core.base_ss = 0;
                Core.base_ds = 0;
                short rm = Core.Fetchb();
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    Modrm.Getrw[rm].word(Table_ea.getEaa32(rm));
                } else {
                    Modrm.Getrw[rm].word(Table_ea.getEaa16(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[142] = new Prefix_helpers.OP(){

            public final int call() {
                int val;
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                if (rm >= 192) {
                    val = Modrm.GetEArw[rm].word();
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    val = Memory.mem_readw(eaa);
                }
                switch (which) {
                    case 2: {
                        ++CPU.CPU_Cycles;
                    }
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!CPU.CPU_SetSegGeneral_index(which, val)) break;
                        return Prefix_helpers.RUNEXCEPTION();
                    }
                    default: {
                        return 1;
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[654] = ops[142];
        Prefix_none.ops[143] = new Prefix_helpers.OP(){

            public final int call() {
                int val = CPU.CPU_Pop16();
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(val);
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, val);
                }
                return 3;
            }
        };
        Prefix_none.ops[144] = new Prefix_helpers.OP(){

            public final int call() {
                return 3;
            }
        };
        Prefix_none.ops[656] = ops[144];
        Prefix_none.ops[145] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.word();
                CPU_Regs.reg_eax.word(CPU_Regs.reg_ecx.word());
                CPU_Regs.reg_ecx.word(temp);
                return 3;
            }
        };
        Prefix_none.ops[146] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.word();
                CPU_Regs.reg_eax.word(CPU_Regs.reg_edx.word());
                CPU_Regs.reg_edx.word(temp);
                return 3;
            }
        };
        Prefix_none.ops[147] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.word();
                CPU_Regs.reg_eax.word(CPU_Regs.reg_ebx.word());
                CPU_Regs.reg_ebx.word(temp);
                return 3;
            }
        };
        Prefix_none.ops[148] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.word();
                CPU_Regs.reg_eax.word(CPU_Regs.reg_esp.word());
                CPU_Regs.reg_esp.word(temp);
                return 3;
            }
        };
        Prefix_none.ops[149] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.word();
                CPU_Regs.reg_eax.word(CPU_Regs.reg_ebp.word());
                CPU_Regs.reg_ebp.word(temp);
                return 3;
            }
        };
        Prefix_none.ops[150] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.word();
                CPU_Regs.reg_eax.word(CPU_Regs.reg_esi.word());
                CPU_Regs.reg_esi.word(temp);
                return 3;
            }
        };
        Prefix_none.ops[151] = new Prefix_helpers.OP(){

            public final int call() {
                int temp = CPU_Regs.reg_eax.word();
                CPU_Regs.reg_eax.word(CPU_Regs.reg_edi.word());
                CPU_Regs.reg_edi.word(temp);
                return 3;
            }
        };
        Prefix_none.ops[152] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word((byte)CPU_Regs.reg_eax.low());
                return 3;
            }
        };
        Prefix_none.ops[153] = new Prefix_helpers.OP(){

            public final int call() {
                if ((CPU_Regs.reg_eax.word() & 0x8000) != 0) {
                    CPU_Regs.reg_edx.word(65535);
                } else {
                    CPU_Regs.reg_edx.word(0);
                }
                return 3;
            }
        };
        Prefix_none.ops[154] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                int newip = Core.Fetchw();
                int newcs = Core.Fetchw();
                CPU.CPU_CALL(false, newcs, newip, Prefix_helpers.GETIP());
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 5;
                }
                return 6;
            }
        };
        Prefix_none.ops[155] = new Prefix_helpers.OP(){

            public final int call() {
                return 3;
            }
        };
        Prefix_none.ops[667] = ops[155];
        Prefix_none.ops[156] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_PUSHF(false)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_none.ops[157] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_POPF(false)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 8;
                }
                if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                    return 8;
                }
                return 3;
            }
        };
        Prefix_none.ops[158] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.SETFLAGSb(CPU_Regs.reg_eax.high());
                return 3;
            }
        };
        Prefix_none.ops[670] = ops[158];
        Prefix_none.ops[159] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                CPU_Regs.reg_eax.high(CPU_Regs.flags & 0xFF);
                return 3;
            }
        };
        Prefix_none.ops[671] = ops[159];
        Prefix_none.ops[160] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Memory.mem_readb(Prefix_none.GetEADirect()));
                return 3;
            }
        };
        Prefix_none.ops[672] = ops[160];
        Prefix_none.ops[161] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Memory.mem_readw(Prefix_none.GetEADirect()));
                return 3;
            }
        };
        Prefix_none.ops[162] = new Prefix_helpers.OP(){

            public final int call() {
                Memory.mem_writeb(Prefix_none.GetEADirect(), CPU_Regs.reg_eax.low());
                return 3;
            }
        };
        Prefix_none.ops[674] = ops[162];
        Prefix_none.ops[163] = new Prefix_helpers.OP(){

            public final int call() {
                Memory.mem_writew(Prefix_none.GetEADirect(), CPU_Regs.reg_eax.word());
                return 3;
            }
        };
        Prefix_none.ops[164] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(7);
                return 3;
            }
        };
        Prefix_none.ops[676] = ops[164];
        Prefix_none.ops[165] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(8);
                return 3;
            }
        };
        Prefix_none.ops[166] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(19);
                return 3;
            }
        };
        Prefix_none.ops[678] = ops[166];
        Prefix_none.ops[167] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(20);
                return 3;
            }
        };
        Prefix_none.ops[168] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.TESTB(Core.Fetchb(), CPU_Regs.reg_eax.low());
                return 3;
            }
        };
        Prefix_none.ops[680] = ops[168];
        Prefix_none.ops[169] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.TESTW(Core.Fetchw(), CPU_Regs.reg_eax.word());
                return 3;
            }
        };
        Prefix_none.ops[170] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(13);
                return 3;
            }
        };
        Prefix_none.ops[682] = ops[170];
        Prefix_none.ops[171] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(14);
                return 3;
            }
        };
        Prefix_none.ops[172] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(10);
                return 3;
            }
        };
        Prefix_none.ops[684] = ops[172];
        Prefix_none.ops[173] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(11);
                return 3;
            }
        };
        Prefix_none.ops[174] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(16);
                return 3;
            }
        };
        Prefix_none.ops[686] = ops[174];
        Prefix_none.ops[175] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_none.DoString(17);
                return 3;
            }
        };
        Prefix_none.ops[176] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[688] = ops[176];
        Prefix_none.ops[177] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.low(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[689] = ops[177];
        Prefix_none.ops[178] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.low(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[690] = ops[178];
        Prefix_none.ops[179] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.low(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[691] = ops[179];
        Prefix_none.ops[180] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.high(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[692] = ops[180];
        Prefix_none.ops[181] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.high(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[693] = ops[181];
        Prefix_none.ops[182] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.high(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[694] = ops[182];
        Prefix_none.ops[183] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.high(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[695] = ops[183];
        Prefix_none.ops[184] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[185] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ecx.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[186] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edx.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[187] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebx.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[188] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[189] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_ebp.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[190] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esi.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[191] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_edi.word(Core.Fetchw());
                return 3;
            }
        };
        Prefix_none.ops[192] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2B_fetchb(rm);
                return 3;
            }
        };
        Prefix_none.ops[704] = ops[192];
        Prefix_none.ops[193] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2W_fetchb(rm);
                return 3;
            }
        };
        Prefix_none.ops[194] = new Prefix_helpers.OP(){

            public final int call() {
                int offset = Core.Fetchw();
                CPU_Regs.reg_eip = CPU.CPU_Pop16();
                CPU_Regs.reg_esp.dword += offset;
                return 6;
            }
        };
        Prefix_none.ops[195] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eip = CPU.CPU_Pop16();
                return 6;
            }
        };
        Prefix_none.ops[196] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralES(Memory.mem_readw(eaa + 2))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                return 3;
            }
        };
        Prefix_none.ops[197] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    return 1;
                }
                int eaa = Table_ea.getEaa(rm);
                if (CPU.CPU_SetSegGeneralDS(Memory.mem_readw(eaa + 2))) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                Modrm.Getrw[rm].word(Memory.mem_readw(eaa));
                return 3;
            }
        };
        Prefix_none.ops[198] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArb[rm].set(Core.Fetchb());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writeb(eaa, Core.Fetchb());
                }
                return 3;
            }
        };
        Prefix_none.ops[710] = ops[198];
        Prefix_none.ops[199] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    Modrm.GetEArw[rm].word(Core.Fetchw());
                } else {
                    int eaa = Table_ea.getEaa(rm);
                    Memory.mem_writew(eaa, Core.Fetchw());
                }
                return 3;
            }
        };
        Prefix_none.ops[200] = new Prefix_helpers.OP(){

            public final int call() {
                int bytes = Core.Fetchw();
                short level = Core.Fetchb();
                CPU.CPU_ENTER(false, bytes, level);
                return 3;
            }
        };
        Prefix_none.ops[201] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_esp.dword &= CPU.cpu.stack.notmask;
                CPU_Regs.reg_esp.dword |= CPU_Regs.reg_ebp.dword & CPU.cpu.stack.mask;
                CPU_Regs.reg_ebp.word(CPU.CPU_Pop16());
                return 3;
            }
        };
        Prefix_none.ops[202] = new Prefix_helpers.OP(){

            public final int call() {
                int words = Core.Fetchw();
                Flags.FillFlags();
                CPU.CPU_RET(false, words, Prefix_helpers.GETIP());
                return 6;
            }
        };
        Prefix_none.ops[203] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                CPU.CPU_RET(false, 0, Prefix_helpers.GETIP());
                return 6;
            }
        };
        Prefix_none.ops[204] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_SW_Interrupt_NoIOPLCheck(3, Prefix_helpers.GETIP());
                CPU.cpu.trap_skip = true;
                return 6;
            }
        };
        Prefix_none.ops[716] = ops[204];
        Prefix_none.ops[205] = new Prefix_helpers.OP(){

            public final int call() {
                short num = Core.Fetchb();
                CPU.CPU_SW_Interrupt(num, Prefix_helpers.GETIP());
                CPU.cpu.trap_skip = true;
                return 6;
            }
        };
        Prefix_none.ops[717] = ops[205];
        Prefix_none.ops[206] = new Prefix_helpers.OP(){

            public final int call() {
                if (Flags.get_OF()) {
                    CPU.CPU_SW_Interrupt(4, Prefix_helpers.GETIP());
                    CPU.cpu.trap_skip = true;
                    return 6;
                }
                return 3;
            }
        };
        Prefix_none.ops[718] = ops[206];
        Prefix_none.ops[207] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_IRET(false, Prefix_helpers.GETIP());
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 5;
                }
                if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                    return 5;
                }
                return 6;
            }
        };
        Prefix_none.ops[208] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2B(rm, 1);
                return 3;
            }
        };
        Prefix_none.ops[720] = ops[208];
        Prefix_none.ops[209] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2W(rm, 1);
                return 3;
            }
        };
        Prefix_none.ops[210] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2B(rm, CPU_Regs.reg_ecx.low());
                return 3;
            }
        };
        Prefix_none.ops[722] = ops[210];
        Prefix_none.ops[211] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                Prefix_helpers.GRP2W(rm, CPU_Regs.reg_ecx.low());
                return 3;
            }
        };
        Prefix_none.ops[212] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.AAM(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[724] = ops[212];
        Prefix_none.ops[213] = new Prefix_helpers.OP(){

            public final int call() {
                Instructions.AAD(Core.Fetchb());
                return 3;
            }
        };
        Prefix_none.ops[725] = ops[213];
        Prefix_none.ops[214] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.reg_eax.low(Flags.get_CF() ? 255 : 0);
                return 3;
            }
        };
        Prefix_none.ops[726] = ops[214];
        Prefix_none.ops[215] = new Prefix_helpers.OP(){

            public final int call() {
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    CPU_Regs.reg_eax.low(Memory.mem_readb(Core.base_ds + (CPU_Regs.reg_ebx.dword + CPU_Regs.reg_eax.low())));
                } else {
                    CPU_Regs.reg_eax.low(Memory.mem_readb(Core.base_ds + (CPU_Regs.reg_ebx.word() + CPU_Regs.reg_eax.low() & 0xFFFF)));
                }
                return 3;
            }
        };
        Prefix_none.ops[727] = ops[215];
        Prefix_none.ops[216] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC0_Normal(rm);
                } else {
                    FPU.FPU_ESC0_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[728] = ops[216];
        Prefix_none.ops[217] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC1_Normal(rm);
                } else {
                    FPU.FPU_ESC1_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[729] = ops[217];
        Prefix_none.ops[218] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC2_Normal(rm);
                } else {
                    FPU.FPU_ESC2_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[730] = ops[218];
        Prefix_none.ops[219] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC3_Normal(rm);
                } else {
                    FPU.FPU_ESC3_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[731] = ops[219];
        Prefix_none.ops[220] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC4_Normal(rm);
                } else {
                    FPU.FPU_ESC4_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[732] = ops[220];
        Prefix_none.ops[221] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC5_Normal(rm);
                } else {
                    FPU.FPU_ESC5_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[733] = ops[221];
        Prefix_none.ops[222] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC6_Normal(rm);
                } else {
                    FPU.FPU_ESC6_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[734] = ops[222];
        Prefix_none.ops[223] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                if (rm >= 192) {
                    FPU.FPU_ESC7_Normal(rm);
                } else {
                    FPU.FPU_ESC7_EA(rm, Table_ea.getEaa(rm));
                }
                return 3;
            }
        };
        Prefix_none.ops[735] = ops[223];
        Prefix_none.ops[224] = new Prefix_helpers.OP(){

            public final int call() {
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    Prefix_helpers.JumpCond16_b(CPU_Regs.reg_ecx.dword - 1 != 0 && !Flags.get_ZF());
                    --CPU_Regs.reg_ecx.dword;
                } else {
                    Prefix_helpers.JumpCond16_b(CPU_Regs.reg_ecx.word() - 1 != 0 && !Flags.get_ZF());
                    CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
                }
                return 6;
            }
        };
        Prefix_none.ops[225] = new Prefix_helpers.OP(){

            public final int call() {
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    Prefix_helpers.JumpCond16_b(CPU_Regs.reg_ecx.dword - 1 != 0 && Flags.get_ZF());
                    --CPU_Regs.reg_ecx.dword;
                } else {
                    Prefix_helpers.JumpCond16_b(CPU_Regs.reg_ecx.word() - 1 != 0 && Flags.get_ZF());
                    CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
                }
                return 6;
            }
        };
        Prefix_none.ops[226] = new Prefix_helpers.OP(){

            public final int call() {
                if (Prefix_helpers.TEST_PREFIX_ADDR() != 0) {
                    Prefix_helpers.JumpCond16_b(CPU_Regs.reg_ecx.dword - 1 != 0);
                    --CPU_Regs.reg_ecx.dword;
                } else {
                    Prefix_helpers.JumpCond16_b(CPU_Regs.reg_ecx.word() - 1 != 0);
                    CPU_Regs.reg_ecx.word(CPU_Regs.reg_ecx.word() - 1);
                }
                return 6;
            }
        };
        Prefix_none.ops[227] = new Prefix_helpers.OP(){

            public final int call() {
                Prefix_helpers.JumpCond16_b(((long)CPU_Regs.reg_ecx.dword & Prefix_helpers.AddrMaskTable1[Core.prefixes & 1]) == 0L);
                return 6;
            }
        };
        Prefix_none.ops[228] = new Prefix_helpers.OP(){

            public final int call() {
                short port = Core.Fetchb();
                if (CPU.CPU_IO_Exception(port, 1)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                CPU_Regs.reg_eax.low(IO.IO_ReadB(port));
                return 3;
            }
        };
        Prefix_none.ops[740] = ops[228];
        Prefix_none.ops[229] = new Prefix_helpers.OP(){

            public final int call() {
                short port = Core.Fetchb();
                if (CPU.CPU_IO_Exception(port, 2)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                CPU_Regs.reg_eax.word(IO.IO_ReadW(port));
                return 3;
            }
        };
        Prefix_none.ops[230] = new Prefix_helpers.OP(){

            public final int call() {
                short port = Core.Fetchb();
                if (CPU.CPU_IO_Exception(port, 1)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                IO.IO_WriteB(port, CPU_Regs.reg_eax.low());
                return 3;
            }
        };
        Prefix_none.ops[742] = ops[230];
        Prefix_none.ops[231] = new Prefix_helpers.OP(){

            public final int call() {
                short port = Core.Fetchb();
                if (CPU.CPU_IO_Exception(port, 2)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                IO.IO_WriteW(port, CPU_Regs.reg_eax.word());
                return 3;
            }
        };
        Prefix_none.ops[232] = new Prefix_helpers.OP(){

            public final int call() {
                short addip = Core.Fetchws();
                CPU.CPU_Push16(Prefix_helpers.GETIP() & 0xFFFF);
                Prefix_helpers.SAVEIP();
                CPU_Regs.reg_eip = CPU_Regs.reg_eip + addip & 0xFFFF;
                return 6;
            }
        };
        Prefix_none.ops[233] = new Prefix_helpers.OP(){

            public final int call() {
                short addip = Core.Fetchws();
                Prefix_helpers.SAVEIP();
                CPU_Regs.reg_eip = CPU_Regs.reg_eip + addip & 0xFFFF;
                return 6;
            }
        };
        Prefix_none.ops[234] = new Prefix_helpers.OP(){

            public final int call() {
                int newip = Core.Fetchw();
                int newcs = Core.Fetchw();
                Flags.FillFlags();
                CPU.CPU_JMP(false, newcs, newip, Prefix_helpers.GETIP());
                if (CPU_Regs.GETFLAG(256) != 0) {
                    CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                    return 5;
                }
                return 6;
            }
        };
        Prefix_none.ops[235] = new Prefix_helpers.OP(){

            public final int call() {
                short addip = Core.Fetchbs();
                Prefix_helpers.SAVEIP();
                CPU_Regs.reg_eip = CPU_Regs.reg_eip + addip & 0xFFFF;
                return 6;
            }
        };
        Prefix_none.ops[236] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 1)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                CPU_Regs.reg_eax.low(IO.IO_ReadB(CPU_Regs.reg_edx.word()));
                return 3;
            }
        };
        Prefix_none.ops[748] = ops[236];
        Prefix_none.ops[237] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 2)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                CPU_Regs.reg_eax.word(IO.IO_ReadW(CPU_Regs.reg_edx.word()));
                return 3;
            }
        };
        Prefix_none.ops[238] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 1)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                IO.IO_WriteB(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.low());
                return 3;
            }
        };
        Prefix_none.ops[750] = ops[238];
        Prefix_none.ops[239] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_IO_Exception(CPU_Regs.reg_edx.word(), 2)) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                IO.IO_WriteW(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.word());
                return 3;
            }
        };
        Prefix_none.ops[240] = new Prefix_helpers.OP(){

            public final int call() {
                return 3;
            }
        };
        Prefix_none.ops[752] = ops[240];
        Prefix_none.ops[241] = new Prefix_helpers.OP(){

            public final int call() {
                CPU.CPU_SW_Interrupt_NoIOPLCheck(1, Prefix_helpers.GETIP());
                CPU.cpu.trap_skip = true;
                return 6;
            }
        };
        Prefix_none.ops[753] = ops[241];
        Prefix_none.ops[242] = new Prefix_helpers.OP(){

            public final int call() {
                Core.prefixes |= 2;
                Core.rep_zero = false;
                return 4;
            }
        };
        Prefix_none.ops[754] = ops[242];
        Prefix_none.ops[243] = new Prefix_helpers.OP(){

            public final int call() {
                Core.prefixes |= 2;
                Core.rep_zero = true;
                return 4;
            }
        };
        Prefix_none.ops[755] = ops[243];
        Prefix_none.ops[244] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.cpu.pmode && CPU.cpu.cpl != 0) {
                    return Prefix_helpers.EXCEPTION(13);
                }
                Flags.FillFlags();
                CPU.CPU_HLT(Prefix_helpers.GETIP());
                return 5;
            }
        };
        Prefix_none.ops[756] = ops[244];
        Prefix_none.ops[245] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                CPU_Regs.SETFLAGBIT(1, (CPU_Regs.flags & 1) == 0);
                return 3;
            }
        };
        Prefix_none.ops[757] = ops[245];
        Prefix_none.ops[246] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: 
                    case 1: {
                        if (rm >= 192) {
                            Instructions.TESTB(Core.Fetchb(), Modrm.GetEArb[rm].get());
                            break;
                        }
                        short val = Memory.mem_readb(Table_ea.getEaa(rm));
                        Instructions.TESTB(Core.Fetchb(), val);
                        break;
                    }
                    case 2: {
                        if (rm >= 192) {
                            Modrm.GetEArb[rm].set(~Modrm.GetEArb[rm].get());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writeb(eaa, ~Memory.mem_readb(eaa));
                        break;
                    }
                    case 3: {
                        Flags.lflags.type = 55;
                        if (rm >= 192) {
                            Flags.lf_var1b(Modrm.GetEArb[rm].get());
                            Flags.lf_resb(0 - Flags.lf_var1b());
                            Modrm.GetEArb[rm].set(Flags.lf_resb());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Flags.lf_var1b(Memory.mem_readb(eaa));
                        Flags.lf_resb(0 - Flags.lf_var1b());
                        Memory.mem_writeb(eaa, Flags.lf_resb());
                        break;
                    }
                    case 4: {
                        if (rm >= 192) {
                            Instructions.MULB(Modrm.GetEArb[rm].get());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.MULB(Memory.mem_readb(eaa));
                        break;
                    }
                    case 5: {
                        if (rm >= 192) {
                            Prefix_helpers.r = rm;
                            Instructions.IMULB(Modrm.GetEArb[rm].get());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.IMULB(Memory.mem_readb(eaa));
                        break;
                    }
                    case 6: {
                        if (rm >= 192) {
                            Instructions.DIVB(Modrm.GetEArb[rm].get());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.DIVB(Memory.mem_readb(eaa));
                        break;
                    }
                    case 7: {
                        if (rm >= 192) {
                            Instructions.IDIVB(Modrm.GetEArb[rm].get());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.IDIVB(Memory.mem_readb(eaa));
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[758] = ops[246];
        Prefix_none.ops[247] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: 
                    case 1: {
                        if (rm >= 192) {
                            int op = Core.Fetchw();
                            Instructions.TESTW(op, Modrm.GetEArw[rm].word());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.TESTW(Core.Fetchw(), Memory.mem_readw(eaa));
                        break;
                    }
                    case 2: {
                        if (rm >= 192) {
                            Modrm.GetEArw[rm].word(~Modrm.GetEArw[rm].word());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writew(eaa, ~Memory.mem_readw(eaa));
                        break;
                    }
                    case 3: {
                        Flags.lflags.type = 56;
                        if (rm >= 192) {
                            Flags.lf_var1w(Modrm.GetEArw[rm].word());
                            Flags.lf_resw(0 - Flags.lf_var1w());
                            Modrm.GetEArw[rm].word(Flags.lf_resw());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Flags.lf_var1w(Memory.mem_readw(eaa));
                        Flags.lf_resw(0 - Flags.lf_var1w());
                        Memory.mem_writew(eaa, Flags.lf_resw());
                        break;
                    }
                    case 4: {
                        if (rm >= 192) {
                            Instructions.MULW(Modrm.GetEArw[rm].word());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.MULW(Memory.mem_readw(eaa));
                        break;
                    }
                    case 5: {
                        if (rm >= 192) {
                            Instructions.IMULW(Modrm.GetEArw[rm].word());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.IMULW(Memory.mem_readw(eaa));
                        break;
                    }
                    case 6: {
                        if (rm >= 192) {
                            Instructions.DIVW(Modrm.GetEArw[rm].word());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.DIVW(Memory.mem_readw(eaa));
                        break;
                    }
                    case 7: {
                        if (rm >= 192) {
                            Instructions.IDIVW(Modrm.GetEArw[rm].word());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Instructions.IDIVW(Memory.mem_readw(eaa));
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[248] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                CPU_Regs.SETFLAGBIT(1, false);
                return 3;
            }
        };
        Prefix_none.ops[760] = ops[248];
        Prefix_none.ops[249] = new Prefix_helpers.OP(){

            public final int call() {
                Flags.FillFlags();
                CPU_Regs.SETFLAGBIT(1, true);
                return 3;
            }
        };
        Prefix_none.ops[761] = ops[249];
        Prefix_none.ops[250] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_CLI()) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                return 3;
            }
        };
        Prefix_none.ops[762] = ops[250];
        Prefix_none.ops[251] = new Prefix_helpers.OP(){

            public final int call() {
                if (CPU.CPU_STI()) {
                    return Prefix_helpers.RUNEXCEPTION();
                }
                if (CPU_Regs.GETFLAG(512) != 0 && Pic.PIC_IRQCheck != 0) {
                    return 8;
                }
                return 3;
            }
        };
        Prefix_none.ops[763] = ops[251];
        Prefix_none.ops[252] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.SETFLAGBIT(1024, false);
                CPU.cpu.direction = 1;
                return 3;
            }
        };
        Prefix_none.ops[764] = ops[252];
        Prefix_none.ops[253] = new Prefix_helpers.OP(){

            public final int call() {
                CPU_Regs.SETFLAGBIT(1024, true);
                CPU.cpu.direction = -1;
                return 3;
            }
        };
        Prefix_none.ops[765] = ops[253];
        Prefix_none.ops[254] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: {
                        if (rm >= 192) {
                            switch (rm & 7) {
                                case 0: {
                                    CPU_Regs.reg_eax.low(Instructions.INCB(CPU_Regs.reg_eax.low()));
                                    break;
                                }
                                case 1: {
                                    CPU_Regs.reg_ecx.low(Instructions.INCB(CPU_Regs.reg_ecx.low()));
                                    break;
                                }
                                case 2: {
                                    CPU_Regs.reg_edx.low(Instructions.INCB(CPU_Regs.reg_edx.low()));
                                    break;
                                }
                                case 3: {
                                    CPU_Regs.reg_ebx.low(Instructions.INCB(CPU_Regs.reg_ebx.low()));
                                    break;
                                }
                                case 4: {
                                    CPU_Regs.reg_eax.high(Instructions.INCB(CPU_Regs.reg_eax.high()));
                                    break;
                                }
                                case 5: {
                                    CPU_Regs.reg_ecx.high(Instructions.INCB(CPU_Regs.reg_ecx.high()));
                                    break;
                                }
                                case 6: {
                                    CPU_Regs.reg_edx.high(Instructions.INCB(CPU_Regs.reg_edx.high()));
                                    break;
                                }
                                case 7: {
                                    CPU_Regs.reg_ebx.high(Instructions.INCB(CPU_Regs.reg_ebx.high()));
                                }
                            }
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writeb(eaa, Instructions.INCB(Memory.mem_readb(eaa)));
                        break;
                    }
                    case 1: {
                        if (rm >= 192) {
                            switch (rm & 7) {
                                case 0: {
                                    CPU_Regs.reg_eax.low(Instructions.DECB(CPU_Regs.reg_eax.low()));
                                    break;
                                }
                                case 1: {
                                    CPU_Regs.reg_ecx.low(Instructions.DECB(CPU_Regs.reg_ecx.low()));
                                    break;
                                }
                                case 2: {
                                    CPU_Regs.reg_edx.low(Instructions.DECB(CPU_Regs.reg_edx.low()));
                                    break;
                                }
                                case 3: {
                                    CPU_Regs.reg_ebx.low(Instructions.DECB(CPU_Regs.reg_ebx.low()));
                                    break;
                                }
                                case 4: {
                                    CPU_Regs.reg_eax.high(Instructions.DECB(CPU_Regs.reg_eax.high()));
                                    break;
                                }
                                case 5: {
                                    CPU_Regs.reg_ecx.high(Instructions.DECB(CPU_Regs.reg_ecx.high()));
                                    break;
                                }
                                case 6: {
                                    CPU_Regs.reg_edx.high(Instructions.DECB(CPU_Regs.reg_edx.high()));
                                    break;
                                }
                                case 7: {
                                    CPU_Regs.reg_ebx.high(Instructions.DECB(CPU_Regs.reg_ebx.high()));
                                }
                            }
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writeb(eaa, Instructions.DECB(Memory.mem_readb(eaa)));
                        break;
                    }
                    case 7: {
                        returnValue = Core.Fetchw();
                        Flags.FillFlags();
                        Prefix_helpers.SAVEIP();
                        return 7;
                    }
                    default: {
                        Log.exit("Illegal GRP4 Call " + (rm >> 3 & 7));
                    }
                }
                return 3;
            }
        };
        Prefix_none.ops[766] = ops[254];
        Prefix_none.ops[255] = new Prefix_helpers.OP(){

            public final int call() {
                short rm = Core.Fetchb();
                int which = rm >> 3 & 7;
                switch (which) {
                    case 0: {
                        if (rm >= 192) {
                            switch (rm & 7) {
                                case 0: {
                                    CPU_Regs.reg_eax.word(Instructions.INCW(CPU_Regs.reg_eax.word()));
                                    break;
                                }
                                case 1: {
                                    CPU_Regs.reg_ecx.word(Instructions.INCW(CPU_Regs.reg_ecx.word()));
                                    break;
                                }
                                case 2: {
                                    CPU_Regs.reg_edx.word(Instructions.INCW(CPU_Regs.reg_edx.word()));
                                    break;
                                }
                                case 3: {
                                    CPU_Regs.reg_ebx.word(Instructions.INCW(CPU_Regs.reg_ebx.word()));
                                    break;
                                }
                                case 4: {
                                    CPU_Regs.reg_esp.word(Instructions.INCW(CPU_Regs.reg_esp.word()));
                                    break;
                                }
                                case 5: {
                                    CPU_Regs.reg_ebp.word(Instructions.INCW(CPU_Regs.reg_ebp.word()));
                                    break;
                                }
                                case 6: {
                                    CPU_Regs.reg_esi.word(Instructions.INCW(CPU_Regs.reg_esi.word()));
                                    break;
                                }
                                case 7: {
                                    CPU_Regs.reg_edi.word(Instructions.INCW(CPU_Regs.reg_edi.word()));
                                }
                            }
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writew(eaa, Instructions.INCW(Memory.mem_readw(eaa)));
                        break;
                    }
                    case 1: {
                        if (rm >= 192) {
                            CPU_Regs.Reg r = Modrm.GetEArw[rm];
                            r.word(Instructions.DECW(r.word()));
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        Memory.mem_writew(eaa, Instructions.DECW(Memory.mem_readw(eaa)));
                        break;
                    }
                    case 2: {
                        int eip;
                        if (rm >= 192) {
                            eip = Modrm.GetEArw[rm].word();
                        } else {
                            int eaa = Table_ea.getEaa(rm);
                            eip = Memory.mem_readw(eaa);
                        }
                        CPU.CPU_Push16(Prefix_helpers.GETIP() & 0xFFFF);
                        CPU_Regs.reg_eip = eip;
                        return 6;
                    }
                    case 3: {
                        if (rm >= 192) {
                            return 1;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        int newip = Memory.mem_readw(eaa);
                        int newcs = Memory.mem_readw(eaa + 2);
                        Flags.FillFlags();
                        CPU.CPU_CALL(false, newcs, newip, Prefix_helpers.GETIP());
                        if (CPU_Regs.GETFLAG(256) != 0) {
                            CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                            return 5;
                        }
                        return 6;
                    }
                    case 4: {
                        if (rm >= 192) {
                            CPU_Regs.reg_eip = Modrm.GetEArw[rm].word();
                        } else {
                            int eaa = Table_ea.getEaa(rm);
                            CPU_Regs.reg_eip = Memory.mem_readw(eaa);
                        }
                        return 6;
                    }
                    case 5: {
                        if (rm >= 192) {
                            return 1;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        int newip = Memory.mem_readw(eaa);
                        int newcs = Memory.mem_readw(eaa + 2);
                        Flags.FillFlags();
                        CPU.CPU_JMP(false, newcs, newip, Prefix_helpers.GETIP());
                        if (CPU_Regs.GETFLAG(256) != 0) {
                            CPU.cpudecoder = Core_normal.CPU_Core_Normal_Trap_Run;
                            return 5;
                        }
                        return 6;
                    }
                    case 6: {
                        if (rm >= 192) {
                            CPU.CPU_Push16(Modrm.GetEArw[rm].word());
                            break;
                        }
                        int eaa = Table_ea.getEaa(rm);
                        CPU.CPU_Push16(Memory.mem_readw(eaa));
                        break;
                    }
                    default: {
                        Log.log(8, 2, "CPU:GRP5:Illegal Call " + Integer.toString(which, 16));
                        return 1;
                    }
                }
                return 3;
            }
        };
    }

    protected static interface call1 {
        public int call();
    }

    protected static interface mov {
        public void call();
    }
}

