/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Vector;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.SampleBuffer;
import jdos.dos.Dos_cdrom;
import jdos.dos.Dos_files;
import jdos.dos.drives.Drive_local;
import jdos.hardware.Memory;
import jdos.hardware.Mixer;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.util.BooleanRef;
import jdos.util.FileIO;
import jdos.util.FileIOFactory;
import jdos.util.IntRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class CDROM_Interface_Image
implements Dos_cdrom.CDROM_Interface {
    private static imagePlayer player = new imagePlayer();
    private static int refCount;
    public static CDROM_Interface_Image[] images;
    private Vector tracks = new Vector();
    private String mcn;
    private short subUnit;
    private static Mixer.MIXER_Handler CDAudioCallBack;

    public CDROM_Interface_Image(short subUnit) {
        CDROM_Interface_Image.images[subUnit] = this;
        if (refCount == 0) {
            if (CDROM_Interface_Image.player.channel == null) {
                CDROM_Interface_Image.player.channel = Mixer.MIXER_AddChannel(CDAudioCallBack, 44100, "CDAUDIO");
            }
            CDROM_Interface_Image.player.channel.Enable(true);
        }
        ++refCount;
    }

    public void close() {
        --refCount;
        if (CDROM_Interface_Image.player.cd == this) {
            CDROM_Interface_Image.player.cd = null;
        }
        this.ClearTracks();
        if (refCount == 0) {
            CDROM_Interface_Image.player.channel.Enable(false);
        }
    }

    public void InitNewMedia() {
    }

    public boolean SetDevice(String path, int forceCD) {
        if (this.LoadCueSheet(path)) {
            return true;
        }
        if (this.LoadIsoFile(path)) {
            return true;
        }
        byte[] b = new String("Could not load image file: " + path + "\n").getBytes();
        IntRef size = new IntRef(b.length);
        Dos_files.DOS_WriteFile(1, b, size);
        return false;
    }

    public boolean GetUPC(ShortRef attr, StringRef upc) {
        attr.value = 0;
        upc.value = this.mcn;
        return true;
    }

    public boolean GetAudioTracks(IntRef stTrack, IntRef end, Dos_cdrom.TMSF leadOut) {
        stTrack.value = 1;
        end.value = this.tracks.size() - 1;
        int value = ((Track)this.tracks.elementAt((int)(this.tracks.size() - 1))).start + 150;
        leadOut.fr = value % 75;
        leadOut.sec = (value /= 75) % 60;
        leadOut.min = value /= 60;
        return true;
    }

    public boolean GetAudioTrackInfo(int track2, Dos_cdrom.TMSF start, ShortRef attr) {
        if (track2 < 1 || track2 > this.tracks.size()) {
            return false;
        }
        int value = ((Track)this.tracks.elementAt((int)(track2 - 1))).start + 150;
        start.fr = value % 75;
        start.sec = (value /= 75) % 60;
        start.min = value /= 60;
        attr.value = (short)((Track)this.tracks.elementAt((int)(track2 - 1))).attr;
        return true;
    }

    public boolean GetAudioSub(ShortRef attr, ShortRef track2, ShortRef index, Dos_cdrom.TMSF relPos, Dos_cdrom.TMSF absPos) {
        int cur_track = this.GetTrack(CDROM_Interface_Image.player.currFrame);
        if (cur_track < 1) {
            return false;
        }
        track2.value = (short)cur_track;
        attr.value = (short)((Track)this.tracks.elementAt((int)(track2.value - 1))).attr;
        index.value = 1;
        int value = CDROM_Interface_Image.player.currFrame + 150;
        absPos.fr = value % 75;
        absPos.sec = (value /= 75) % 60;
        absPos.min = value /= 60;
        value = CDROM_Interface_Image.player.currFrame - ((Track)this.tracks.elementAt((int)(track2.value - 1))).start + 150;
        relPos.fr = value % 75;
        relPos.sec = (value /= 75) % 60;
        relPos.min = value /= 60;
        return true;
    }

    public boolean GetAudioStatus(BooleanRef playing, BooleanRef pause) {
        playing.value = CDROM_Interface_Image.player.isPlaying;
        pause.value = CDROM_Interface_Image.player.isPaused;
        return true;
    }

    public boolean GetMediaTrayStatus(BooleanRef mediaPresent, BooleanRef mediaChanged, BooleanRef trayOpen) {
        mediaPresent.value = true;
        mediaChanged.value = false;
        trayOpen.value = false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean PlayAudioSector(long start, long len) {
        Object object = CDROM_Interface_Image.player.mutex;
        synchronized (object) {
            CDROM_Interface_Image.player.cd = this;
            CDROM_Interface_Image.player.currFrame = (int)start;
            CDROM_Interface_Image.player.targetFrame = (int)(start + len);
            int track2 = this.GetTrack((int)start) - 1;
            if (track2 >= 0 && ((Track)this.tracks.elementAt((int)track2)).attr == 64) {
                Log.log(21, 1, "Game tries to play the data track. Not doing this");
                CDROM_Interface_Image.player.isPlaying = false;
            } else {
                CDROM_Interface_Image.player.isPlaying = true;
            }
            CDROM_Interface_Image.player.isPaused = false;
        }
        return true;
    }

    public boolean PauseAudio(boolean resume) {
        if (!CDROM_Interface_Image.player.isPlaying) {
            return false;
        }
        CDROM_Interface_Image.player.isPaused = !resume;
        return true;
    }

    public boolean StopAudio() {
        CDROM_Interface_Image.player.isPlaying = false;
        CDROM_Interface_Image.player.isPaused = false;
        return true;
    }

    public void ChannelControl(Dos_cdrom.TCtrl ctrl) {
        CDROM_Interface_Image.player.ctrlUsed = ctrl.out[0] != 0 || ctrl.out[1] != 1 || ctrl.vol[0] < 254 || ctrl.vol[1] < 254;
        CDROM_Interface_Image.player.ctrlData.copy(ctrl);
    }

    public boolean ReadSectors(int buffer, boolean raw, long sector, long num) {
        int sectorSize = raw ? 2352 : 2048;
        int buflen = (int)(num * (long)sectorSize);
        byte[] buf = new byte[buflen];
        boolean success = true;
        int i = 0;
        while ((long)i < num && (success = this.ReadSector(buf, i * sectorSize, raw, (int)sector + i))) {
            ++i;
        }
        Memory.MEM_BlockWrite(buffer, buf, buflen);
        return success;
    }

    public boolean LoadUnloadMedia(boolean unload) {
        return true;
    }

    public boolean ReadSector(byte[] buffer, int offset, boolean raw, int sector) {
        int length;
        int track2 = this.GetTrack(sector) - 1;
        if (track2 < 0) {
            return false;
        }
        Track t = (Track)this.tracks.elementAt(track2);
        int seek = t.skip + (sector - t.start) * t.sectorSize;
        int n = length = raw ? 2352 : 2048;
        if (t.sectorSize != 2352 && raw) {
            return false;
        }
        if (t.sectorSize == 2352 && !t.mode2 && !raw) {
            seek += 16;
        }
        if (t.mode2 && !raw) {
            seek += 24;
        }
        return t.file.read(buffer, offset, seek, length);
    }

    public boolean HasDataTrack() {
        for (int i = 0; i < this.tracks.size(); ++i) {
            Track it = (Track)this.tracks.elementAt(i);
            if (it.attr != 64) continue;
            return true;
        }
        return false;
    }

    private int GetTrack(int sector) {
        for (int i = 0; i < this.tracks.size() - 1; ++i) {
            Track curr = (Track)this.tracks.elementAt(i);
            Track next = (Track)this.tracks.elementAt(i + 1);
            if (curr.start > sector || sector >= next.start) continue;
            return curr.number;
        }
        return -1;
    }

    private void ClearTracks() {
        Object last = null;
        for (int i = 0; i < this.tracks.size(); ++i) {
            Track curr = (Track)this.tracks.elementAt(i);
            if (curr.file == null) continue;
            curr.file.close();
        }
        this.tracks.clear();
    }

    private boolean LoadIsoFile(String filename) {
        this.tracks.clear();
        Track track2 = new Track();
        BooleanRef error = new BooleanRef();
        track2.file = new BinaryFile(filename, error);
        if (error.value) {
            track2.file.close();
            return false;
        }
        track2.number = 1;
        track2.attr = 64;
        if (this.CanReadPVD(track2.file, 2048, false)) {
            track2.sectorSize = 2048;
            track2.mode2 = false;
        } else if (this.CanReadPVD(track2.file, 2352, false)) {
            track2.sectorSize = 2352;
            track2.mode2 = false;
        } else if (this.CanReadPVD(track2.file, 2336, true)) {
            track2.sectorSize = 2336;
            track2.mode2 = true;
        } else if (this.CanReadPVD(track2.file, 2352, true)) {
            track2.sectorSize = 2352;
            track2.mode2 = true;
        } else {
            return false;
        }
        track2.length = (int)track2.file.getLength() / track2.sectorSize;
        this.tracks.add(track2);
        track2 = new Track(track2);
        track2.number = 2;
        track2.attr = 0;
        track2.start = track2.length;
        track2.length = 0;
        track2.file = null;
        this.tracks.add(track2);
        return true;
    }

    private boolean CanReadPVD(TrackFile file, int sectorSize, boolean mode2) {
        byte[] pvd = new byte[2048];
        int seek = 16 * sectorSize;
        if (sectorSize == 2352 && !mode2) {
            seek += 16;
        }
        if (mode2) {
            seek += 24;
        }
        file.read(pvd, 0, seek, 2048);
        return pvd[0] == 1 && StringHelper.strncmp(pvd, 1, "CD001".getBytes(), 0, 5) == 0 && pvd[6] == 1;
    }

    private boolean LoadCueSheet(String cuefile) {
        Track track2 = new Track();
        this.tracks.clear();
        IntRef shift = new IntRef(0);
        int currPregap = 0;
        IntRef totalPregap = new IntRef(0);
        int prestart = 0;
        boolean success = true;
        boolean canAddTrack = false;
        File f = new File(cuefile);
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(cuefile));
            while ((line = in.readLine()) != null) {
                String[] parts = StringHelper.splitWithQuotes(line.trim(), ' ');
                if (parts[0].equals("TRACK")) {
                    success = canAddTrack ? this.AddTrack(track2, shift, prestart, totalPregap, currPregap) : true;
                    track2.start = 0;
                    track2.skip = 0;
                    currPregap = 0;
                    prestart = 0;
                    track2.number = Integer.parseInt(parts[1]);
                    if (parts[2].equals("AUDIO")) {
                        track2.sectorSize = 2352;
                        track2.attr = 0;
                        track2.mode2 = false;
                    } else if (parts[2].equals("MODE1/2048")) {
                        track2.sectorSize = 2048;
                        track2.attr = 64;
                        track2.mode2 = false;
                    } else if (parts[2].equals("MODE1/2352")) {
                        track2.sectorSize = 2352;
                        track2.attr = 64;
                        track2.mode2 = false;
                    } else if (parts[2].equals("MODE2/2336")) {
                        track2.sectorSize = 2336;
                        track2.attr = 64;
                        track2.mode2 = true;
                    } else if (parts[2].equals("MODE2/2352")) {
                        track2.sectorSize = 2352;
                        track2.attr = 64;
                        track2.mode2 = true;
                    } else {
                        success = false;
                    }
                    canAddTrack = true;
                } else if (parts[0].equals("INDEX")) {
                    int index = Integer.parseInt(parts[1]);
                    int frame = this.GetCueFrame(parts[2]);
                    if (frame < 0) {
                        success = false;
                    }
                    if (index == 1) {
                        track2.start = frame;
                    } else if (index == 0) {
                        prestart = frame;
                    }
                } else if (parts[0].equals("FILE")) {
                    success = canAddTrack ? this.AddTrack(track2, shift, prestart, totalPregap, currPregap) : true;
                    canAddTrack = false;
                    StringRef filename = new StringRef(parts[1]);
                    this.GetRealFileName(filename, new File(cuefile).getAbsoluteFile().getParent());
                    track2.file = null;
                    BooleanRef error = new BooleanRef(true);
                    if (parts[2].equals("BINARY")) {
                        track2.file = new BinaryFile(filename.value, error);
                    } else if (parts[2].equals("MP3")) {
                        track2.file = new AudioFile(filename.value, error);
                    }
                    if (error.value) {
                        if (track2.file != null) {
                            track2.file.close();
                        }
                        success = false;
                    }
                } else if (parts[0].equals("PREGAP")) {
                    currPregap = this.GetCueFrame(parts[1]);
                    success = currPregap >= 0;
                } else if (parts[0].equals("CATALOG")) {
                    this.mcn = parts[1];
                } else {
                    success = parts[0].equals("CDTEXTFILE") || parts[0].equals("FLAGS") || parts[0].equals("ISRC") || parts[0].equals("PERFORMER") || parts[0].equals("POSTGAP") || parts[0].equals("REM") || parts[0].equals("SONGWRITER") || parts[0].equals("TITLE") || parts[0].equals("");
                }
                if (success) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (!this.AddTrack(track2, shift, prestart, totalPregap, currPregap)) {
            return false;
        }
        ++track2.number;
        track2.attr = 0;
        track2.start = 0;
        track2.length = 0;
        track2.file = null;
        return this.AddTrack(track2, shift, 0, totalPregap, 0);
    }

    private boolean GetRealFileName(StringRef filename, String pathname) {
        if (new File(filename.value).exists()) {
            return true;
        }
        String tmpstr = pathname + "/" + filename.value;
        if (new File(tmpstr).exists()) {
            filename.value = tmpstr;
            return true;
        }
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef(0);
        if (!Dos_files.DOS_MakeName(filename.value, fullname, drive)) {
            return false;
        }
        if (Dos_files.Drives[drive.value] != null && Dos_files.Drives[drive.value] instanceof Drive_local) {
            Drive_local ldp = (Drive_local)Dos_files.Drives[drive.value];
            ldp.GetSystemFilename(fullname, filename.value);
            if (new File(fullname.value).exists()) {
                filename.value = fullname.value;
                return true;
            }
        }
        return false;
    }

    private int GetCueFrame(String part) {
        String[] parts = StringHelper.split(part, ":");
        if (parts.length == 3) {
            try {
                int min = Integer.parseInt(parts[0]);
                int sec = Integer.parseInt(parts[1]);
                int fr = Integer.parseInt(parts[2]);
                return 4500 * min + 75 * sec + fr;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    boolean AddTrack(Track c, IntRef shift, int prestart, IntRef totalPregap, int currPregap) {
        int skip;
        Track curr = new Track();
        curr.copy(c);
        if (prestart > 0) {
            if (prestart > curr.start) {
                return false;
            }
            skip = curr.start - prestart;
        } else {
            skip = 0;
        }
        if (this.tracks.size() == 0) {
            if (curr.number != 1) {
                return false;
            }
            curr.skip = skip * curr.sectorSize;
            curr.start += currPregap;
            totalPregap.value = currPregap;
            this.tracks.add(curr);
            return true;
        }
        Track prev = (Track)this.tracks.lastElement();
        if (prev.file == curr.file) {
            curr.start += shift.value;
            prev.length = curr.start + totalPregap.value - prev.start - skip;
            curr.skip += prev.skip + prev.length * prev.sectorSize + skip * curr.sectorSize;
            totalPregap.value += currPregap;
            curr.start += totalPregap.value;
        } else {
            int tmp = (int)(prev.file.getLength() - (long)prev.skip);
            prev.length = tmp / prev.sectorSize;
            if (tmp % prev.sectorSize != 0) {
                ++prev.length;
            }
            curr.start += prev.start + prev.length + currPregap;
            curr.skip = skip * curr.sectorSize;
            shift.value += prev.start + prev.length;
            totalPregap.value = currPregap;
        }
        if (curr.number <= 1) {
            return false;
        }
        if (prev.number + 1 != curr.number) {
            return false;
        }
        if (curr.start < prev.start + prev.length) {
            return false;
        }
        if (curr.length < 0) {
            return false;
        }
        this.tracks.add(curr);
        return true;
    }

    void CDROM_Image_Destroy(Section sec) {
    }

    void CDROM_Image_Init(Section section) {
    }

    static {
        images = new CDROM_Interface_Image[26];
        CDAudioCallBack = new Mixer.MIXER_Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(int len) {
                int i;
                if ((len *= 4) == 0) {
                    return;
                }
                if (!player.isPlaying || player.isPaused) {
                    player.channel.AddSilence();
                    return;
                }
                Object object = player.mutex;
                synchronized (object) {
                    while (player.bufLen < len) {
                        boolean success = player.targetFrame > player.currFrame ? player.cd.ReadSector(player.buffer, player.bufLen, true, player.currFrame) : false;
                        if (success) {
                            ++player.currFrame;
                            player.bufLen += 2352;
                            continue;
                        }
                        Arrays.fill(player.buffer, player.bufLen, player.bufLen, (byte)0);
                        player.bufLen = len;
                        player.isPlaying = false;
                    }
                }
                int tIndex = 0;
                int pIndex = 0;
                for (i = 0; i < len / 4; ++i) {
                    if (player.ctrlUsed) {
                        Mixer.MixTemp16[tIndex++] = (short)((player.buffer[pIndex] & 0xFF | player.buffer[pIndex + 1] << 8) * player.ctrlData.vol[0] / 255);
                        Mixer.MixTemp16[tIndex++] = (short)((player.buffer[pIndex + 2] & 0xFF | player.buffer[pIndex + 3] << 8) * player.ctrlData.vol[0] / 255);
                    } else {
                        Mixer.MixTemp16[tIndex++] = (short)(player.buffer[pIndex] & 0xFF | player.buffer[pIndex + 1] << 8);
                        Mixer.MixTemp16[tIndex++] = (short)(player.buffer[pIndex + 2] & 0xFF | player.buffer[pIndex + 3] << 8);
                    }
                    pIndex += 4;
                }
                player.channel.AddSamples_s16(len / 4, Mixer.MixTemp16);
                for (i = 0; i < player.bufLen - len; ++i) {
                    player.buffer[i] = player.buffer[len + i];
                }
                player.bufLen -= len;
            }
        };
    }

    private static class imagePlayer {
        CDROM_Interface_Image cd;
        Mixer.MixerChannel channel;
        final Object mutex = new Object();
        byte[] buffer = new byte[8192];
        int bufLen;
        int currFrame;
        int targetFrame;
        boolean isPlaying;
        boolean isPaused;
        boolean ctrlUsed;
        Dos_cdrom.TCtrl ctrlData = new Dos_cdrom.TCtrl();

        private imagePlayer() {
        }
    }

    private static class Track {
        int number;
        int attr;
        int start;
        int length;
        int skip;
        int sectorSize;
        boolean mode2;
        TrackFile file;

        public Track() {
        }

        public Track(Track t) {
            this.copy(t);
        }

        public void copy(Track t) {
            this.number = t.number;
            this.attr = t.attr;
            this.start = t.start;
            this.length = t.length;
            this.skip = t.skip;
            this.sectorSize = t.sectorSize;
            this.mode2 = t.mode2;
            this.file = t.file;
        }
    }

    private static class AudioFile
    implements TrackFile {
        Decoder decoder;
        Bitstream in;
        Header currFrame;
        int frameCount = -1;
        String filename;
        private long lastSeek;
        int framePos = 0;
        short[] frame = new short[0];

        public AudioFile(String filename, BooleanRef error) {
            this.decoder = new Decoder();
            try {
                this.in = new Bitstream(new FileInputStream(filename));
                this.filename = filename;
                error.value = false;
            }
            catch (Exception e) {
                error.value = true;
            }
        }

        private void reopen() {
            try {
                this.in = new Bitstream(new FileInputStream(this.filename));
                this.frameCount = -1;
                this.currFrame = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        protected short[] decodeFrame() throws JavaLayerException {
            try {
                if (this.decoder == null) {
                    return null;
                }
                if (this.in == null) {
                    return null;
                }
                this.currFrame = this.in.readFrame();
                if (this.currFrame == null) {
                    return null;
                }
                SampleBuffer output = (SampleBuffer)this.decoder.decodeFrame(this.currFrame, this.in);
                short[] samps = output.getBuffer();
                this.in.closeFrame();
                ++this.frameCount;
                return samps;
            }
            catch (RuntimeException e) {
                throw new JavaLayerException("Exception decoding audio frame", e);
            }
        }

        protected boolean seek(int ms) throws JavaLayerException {
            int gotoFrame = (int)((float)ms / this.currFrame.ms_per_frame());
            if (gotoFrame < this.frameCount) {
                this.reopen();
            }
            while (gotoFrame > this.frameCount) {
                this.currFrame = this.in.readFrame();
                if (this.currFrame == null) {
                    return false;
                }
                this.in.closeFrame();
                ++this.frameCount;
            }
            return true;
        }

        public boolean read(byte[] buffer, int offset, long seek, int count) {
            try {
                if (this.currFrame == null) {
                    this.frame = this.decodeFrame();
                    this.framePos = 0;
                }
                if (this.lastSeek != seek - (long)count && !this.seek((int)((double)seek / (double)176.4f))) {
                    return false;
                }
                this.lastSeek = seek;
                while (count > 0) {
                    if (this.framePos < this.frame.length) {
                        buffer[offset++] = (byte)(this.frame[this.framePos] & 0xFF);
                        buffer[offset++] = (byte)(this.frame[this.framePos] >> 8 & 0xFF);
                        ++this.framePos;
                        count -= 2;
                        continue;
                    }
                    this.frame = this.decodeFrame();
                    this.framePos = 0;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public long getLength() {
            return -1L;
        }

        public void close() {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class BinaryFile
    implements TrackFile {
        private FileIO file;

        public BinaryFile(String filename, BooleanRef error) {
            try {
                this.file = FileIOFactory.open(filename, 1);
                error.value = false;
            }
            catch (Exception e) {
                error.value = true;
            }
        }

        public boolean read(byte[] buffer, int offset, long seek, int count) {
            try {
                this.file.seek(seek);
                this.file.read(buffer, offset, count);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public long getLength() {
            try {
                return this.file.length();
            }
            catch (Exception e) {
                return -1L;
            }
        }

        public void close() {
            try {
                this.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static interface TrackFile {
        public boolean read(byte[] var1, int var2, long var3, int var5);

        public long getLength();

        public void close();
    }
}

