/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import jdos.dos.Drives;
import jdos.misc.Cross;
import jdos.misc.Log;
import jdos.util.BooleanRef;
import jdos.util.IntRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class DOS_Drive_Cache {
    Comparator SortByName = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((CFileInfo)o1).shortname.compareTo(((CFileInfo)o2).shortname);
        }
    };
    Comparator SortByDirName = new Comparator(){

        public int compare(Object o1, Object o2) {
            CFileInfo a = (CFileInfo)o1;
            CFileInfo b = (CFileInfo)o2;
            if (a.isDir != b.isDir) {
                return a.isDir ? 1 : -1;
            }
            return a.shortname.compareTo(b.shortname);
        }
    };
    Comparator SortByDirNameRev = new Comparator(){

        public int compare(Object o1, Object o2) {
            CFileInfo a = (CFileInfo)o1;
            CFileInfo b = (CFileInfo)o2;
            if (a.isDir != b.isDir) {
                return a.isDir ? 1 : -1;
            }
            return b.shortname.compareTo(a.shortname);
        }
    };
    Comparator SortByNameRev = new Comparator(){

        public int compare(Object o1, Object o2) {
            CFileInfo a = (CFileInfo)o1;
            CFileInfo b = (CFileInfo)o2;
            return b.shortname.compareTo(a.shortname);
        }
    };
    public static final int MAX_OPENDIRS = 2048;
    private CFileInfo dirBase;
    private String dirPath;
    private String basePath;
    private int sortDirType;
    private CFileInfo save_dir;
    private String save_path;
    private String save_expanded;
    private int srchNr = 0;
    private CFileInfo[] dirSearch = new CFileInfo[2048];
    private CFileInfo[] dirFindFirst = new CFileInfo[2048];
    private int nextFreeFindFirst = 0;
    private String label = "";
    private boolean updatelabel;

    public DOS_Drive_Cache() {
        this.dirBase = new CFileInfo();
        this.SetDirSort(2);
        this.updatelabel = true;
    }

    public DOS_Drive_Cache(String path) {
        this.dirBase = new CFileInfo();
        this.SetDirSort(2);
        this.SetBaseDir(path);
        this.updatelabel = true;
    }

    public void SetBaseDir(String baseDir) {
        IntRef id = new IntRef(0);
        this.basePath = baseDir;
        if (this.OpenDir(baseDir, id)) {
            StringRef result = new StringRef();
            this.ReadDir(id.value, result);
        }
        this.SetLabel(Cross.getVolumeLabel(this.basePath), Cross.isCDRom(this.basePath), true);
    }

    void SetDirSort(int sort) {
        this.sortDirType = sort;
    }

    boolean OpenDir(String path, IntRef id) {
        StringRef expand = new StringRef();
        CFileInfo dir = this.FindDirInfo(path, expand);
        if (this.OpenDir(dir, expand.value, id)) {
            this.dirSearch[id.value].nextEntry = 0;
            return true;
        }
        return false;
    }

    boolean ReadDir(int id, StringRef result) {
        if (id > 2048) {
            return false;
        }
        if (!this.IsCachedIn(this.dirSearch[id])) {
            Cross.dir_information dirp = Cross.open_directory(this.dirPath);
            if (dirp == null) {
                if (this.dirSearch[id] != null) {
                    this.dirSearch[id].id = 2048;
                    this.dirSearch[id] = null;
                }
                return false;
            }
            StringRef dir_name = new StringRef();
            BooleanRef is_directory = new BooleanRef();
            if (Cross.read_directory_first(dirp, dir_name, is_directory)) {
                this.CreateEntry(this.dirSearch[id], dir_name.value, is_directory.value);
                while (Cross.read_directory_next(dirp, dir_name, is_directory)) {
                    this.CreateEntry(this.dirSearch[id], dir_name.value, is_directory.value);
                }
            }
            Cross.close_directory(dirp);
        }
        if (this.SetResult(this.dirSearch[id], result, this.dirSearch[id].nextEntry)) {
            return true;
        }
        if (this.dirSearch[id] != null) {
            this.dirSearch[id].id = 2048;
            this.dirSearch[id] = null;
        }
        return false;
    }

    public void ExpandName(StringRef path) {
        path.value = this.GetExpandName(path.value);
    }

    public String GetExpandName(String path) {
        if (!File.separator.equals("\\")) {
            path = StringHelper.replace(path, "\\", File.separator);
        }
        StringRef work = new StringRef();
        String dir = path;
        int pos = path.lastIndexOf(File.separatorChar);
        if (pos >= 0) {
            dir = dir.substring(0, pos + 1);
        }
        CFileInfo dirInfo = this.FindDirInfo(dir, work);
        if (pos != 0) {
            StringRef d = new StringRef(path.substring(pos + 1));
            this.GetLongName(dirInfo, d);
            dir = d.value;
            work.value = work.value + dir;
        }
        if (work.value.endsWith(File.separator) && !work.value.endsWith(":" + File.separator) && work.value.length() > 1) {
            work.value = work.value.substring(0, work.value.length());
        }
        return work.value;
    }

    boolean GetShortName(String fullname, StringRef shortname) {
        StringRef expand = new StringRef();
        CFileInfo curDir = this.FindDirInfo(fullname, expand);
        int filelist_size = curDir.longNameList.size();
        if (filelist_size <= 0) {
            return false;
        }
        int low = 0;
        int high = filelist_size - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int res = fullname.compareTo(((CFileInfo)curDir.longNameList.elementAt((int)mid)).orgname);
            if (res > 0) {
                low = mid + 1;
                continue;
            }
            if (res < 0) {
                high = mid - 1;
                continue;
            }
            shortname.value = ((CFileInfo)curDir.longNameList.elementAt((int)mid)).shortname;
            return true;
        }
        return false;
    }

    public boolean FindFirst(String path, IntRef id) {
        int local_findcounter;
        IntRef dirID = new IntRef(0);
        if (!this.OpenDir(path, dirID)) {
            return false;
        }
        for (local_findcounter = 0; local_findcounter < 2048 && this.dirFindFirst[this.nextFreeFindFirst] != null; ++local_findcounter) {
            if (++this.nextFreeFindFirst < 2048) continue;
            this.nextFreeFindFirst = 0;
        }
        int dirFindFirstID = this.nextFreeFindFirst++;
        if (this.nextFreeFindFirst >= 2048) {
            this.nextFreeFindFirst = 0;
        }
        if (local_findcounter == 2048) {
            Log.log(14, 2, "DIRCACHE: FindFirst/Next: All slots full. Resetting");
            dirFindFirstID = 0;
            this.nextFreeFindFirst = 1;
            for (int n = 0; n < 2048; ++n) {
                this.DeleteFileInfo(this.dirFindFirst[n]);
                this.dirFindFirst[n] = null;
            }
        }
        this.dirFindFirst[dirFindFirstID] = new CFileInfo();
        this.dirFindFirst[dirFindFirstID].nextEntry = 0;
        for (int i = 0; i < this.dirSearch[dirID.value].fileList.size(); ++i) {
            this.CopyEntry(this.dirFindFirst[dirFindFirstID], (CFileInfo)this.dirSearch[dirID.value].fileList.elementAt(i));
        }
        switch (this.sortDirType) {
            case 1: {
                break;
            }
            case 2: {
                Collections.sort(this.dirFindFirst[dirFindFirstID].fileList, this.SortByDirName);
                break;
            }
            case 3: {
                Collections.sort(this.dirFindFirst[dirFindFirstID].fileList, this.SortByNameRev);
                break;
            }
            case 4: {
                Collections.sort(this.dirFindFirst[dirFindFirstID].fileList, this.SortByDirNameRev);
                break;
            }
        }
        id.value = dirFindFirstID;
        return true;
    }

    public boolean FindNext(int id, StringRef result) {
        if (id >= 2048 || this.dirFindFirst[id] == null) {
            Log.log(14, 2, "DIRCACHE: FindFirst/Next failure : ID out of range: " + Integer.toString(id, 16));
            return false;
        }
        if (!this.SetResult(this.dirFindFirst[id], result, this.dirFindFirst[id].nextEntry)) {
            this.DeleteFileInfo(this.dirFindFirst[id]);
            this.dirFindFirst[id] = null;
            return false;
        }
        return true;
    }

    void ClearFileInfo(CFileInfo dir) {
        for (int i = 0; i < dir.fileList.size(); ++i) {
            CFileInfo info = (CFileInfo)dir.fileList.elementAt(i);
            if (info == null) continue;
            this.ClearFileInfo(info);
        }
        if (dir.id != 2048) {
            this.dirSearch[dir.id] = null;
            dir.id = 2048;
        }
    }

    void DeleteFileInfo(CFileInfo dir) {
        if (dir != null) {
            this.ClearFileInfo(dir);
        }
    }

    public void CacheOut(String path) {
        this.CacheOut(path, false);
    }

    public void CacheOut(String path, boolean ignoreLastDir) {
        CFileInfo dir;
        StringRef expand = new StringRef();
        if (ignoreLastDir) {
            int pos = path.indexOf(File.separatorChar);
            String tmp = pos > 0 ? path.substring(pos) : path;
            dir = this.FindDirInfo(tmp, expand);
        } else {
            dir = this.FindDirInfo(path, expand);
        }
        for (int i = 0; i < dir.fileList.size(); ++i) {
            if (this.dirSearch[this.srchNr] == dir.fileList.elementAt(i)) {
                this.dirSearch[this.srchNr] = null;
            }
            this.DeleteFileInfo((CFileInfo)dir.fileList.elementAt(i));
            dir.fileList.setElementAt(null, i);
        }
        dir.fileList.clear();
        dir.longNameList.clear();
        this.save_dir = null;
    }

    public void AddEntry(String path, boolean checkExists) {
        StringRef file = new StringRef();
        StringRef expand = new StringRef();
        CFileInfo dir = this.FindDirInfo(path, expand);
        int pos = path.lastIndexOf(File.separatorChar);
        if (pos >= 0) {
            file.value = path.substring(pos + 1);
            if (checkExists && this.GetLongName(dir, file) >= 0) {
                return;
            }
            this.CreateEntry(dir, file.value, false);
            int index = this.GetLongName(dir, file);
            if (index >= 0 && dir != null) {
                for (int i = 0; i < 2048; ++i) {
                    if (this.dirSearch[i] != dir || index > this.dirSearch[i].nextEntry) continue;
                    ++this.dirSearch[i].nextEntry;
                }
            }
        }
    }

    public void DeleteEntry(String path) {
        this.DeleteEntry(path, false);
    }

    public void DeleteEntry(String path, boolean ignoreLastDir) {
        StringRef expand;
        CFileInfo dir;
        this.CacheOut(path, ignoreLastDir);
        if (this.dirSearch[this.srchNr] != null && this.dirSearch[this.srchNr].nextEntry > 0) {
            --this.dirSearch[this.srchNr].nextEntry;
        }
        if (!ignoreLastDir && (dir = this.FindDirInfo(path, expand = new StringRef())) != null) {
            for (int i = 0; i < 2048; ++i) {
                if (this.dirSearch[i] != dir || this.dirSearch[i].nextEntry <= 0) continue;
                --this.dirSearch[i].nextEntry;
            }
        }
    }

    public void EmptyCache() {
        this.Clear();
        this.dirBase = new CFileInfo();
        this.save_dir = null;
        this.srchNr = 0;
        this.SetBaseDir(this.basePath);
    }

    public void SetLabel(String vname, boolean cdrom, boolean allowupdate) {
        if (!this.updatelabel) {
            return;
        }
        this.updatelabel = allowupdate;
        StringRef l = new StringRef(this.label);
        Drives.Set_Label(vname, l, cdrom);
        this.label = l.value;
        if (this.label == null) {
            this.label = "";
        }
    }

    public String GetLabel() {
        return this.label;
    }

    private boolean RemoveTrailingDot(StringRef shortname) {
        int len = shortname.value.length();
        if (len > 0 && shortname.value.charAt(len - 1) == '.') {
            if (len == 1) {
                return false;
            }
            if (len == 2 && shortname.value.charAt(0) == '.') {
                return false;
            }
            shortname.value = shortname.value.substring(0, len - 1);
            return true;
        }
        return false;
    }

    private int GetLongName(CFileInfo curDir, StringRef shortName) {
        int filelist_size = curDir.fileList.size();
        if (filelist_size <= 0) {
            return -1;
        }
        this.RemoveTrailingDot(shortName);
        int low = 0;
        int high = filelist_size - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int res = shortName.value.compareTo(((CFileInfo)curDir.fileList.elementAt((int)mid)).shortname);
            if (res > 0) {
                low = mid + 1;
                continue;
            }
            if (res < 0) {
                high = mid - 1;
                continue;
            }
            shortName.value = ((CFileInfo)curDir.fileList.elementAt((int)mid)).orgname;
            return mid;
        }
        return -1;
    }

    private void CreateShortName(CFileInfo curDir, CFileInfo info) {
        Object buffer;
        int len;
        String tmpName = info.orgname.toUpperCase();
        boolean createShort = (tmpName = StringHelper.replace(tmpName, " ", "")).length() != info.orgname.length();
        int pos = tmpName.indexOf(46);
        if (pos >= 0) {
            if (tmpName.length() - pos > 4) {
                while (tmpName.startsWith(".")) {
                    tmpName = tmpName.substring(1);
                }
                createShort = true;
            }
            len = (pos = tmpName.indexOf(46)) >= 0 ? pos - 1 : tmpName.length();
        } else {
            len = tmpName.length();
        }
        boolean bl = createShort = createShort || len > 8;
        if (!createShort) {
            buffer = new StringRef(tmpName);
            boolean bl2 = createShort = this.GetLongName(curDir, (StringRef)buffer) >= 0;
        }
        if (createShort) {
            info.shortNr = this.CreateShortNameID(curDir, tmpName);
            buffer = String.valueOf(info.shortNr);
            int buflen = ((String)buffer).length();
            int tocopy = len + buflen + 1 > 8 ? 8 - buflen - 1 : len;
            info.shortname = tmpName.substring(0, tocopy);
            info.shortname = info.shortname + "~";
            info.shortname = info.shortname + (String)buffer;
            if (pos >= 0) {
                info.shortname = info.shortname + tmpName.substring(tmpName.lastIndexOf(46));
            }
            if (curDir.longNameList.size() > 0) {
                if (info.shortname.compareTo(((CFileInfo)curDir.longNameList.lastElement()).shortname) >= 0) {
                    curDir.longNameList.add(info);
                } else {
                    int i;
                    boolean found = false;
                    for (i = 0; i < curDir.longNameList.size(); ++i) {
                        CFileInfo it = (CFileInfo)curDir.longNameList.elementAt(i);
                        if (info.shortname.compareTo(it.shortname) >= 0) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        curDir.longNameList.insertElementAt(info, i);
                    } else {
                        curDir.longNameList.add(info);
                    }
                }
            } else {
                curDir.longNameList.add(info);
            }
        } else {
            info.shortname = tmpName;
        }
        StringRef sn = new StringRef(info.shortname);
        this.RemoveTrailingDot(sn);
        info.shortname = sn.value;
    }

    private int CreateShortNameID(CFileInfo curDir, String name) {
        int filelist_size = curDir.longNameList.size();
        if (filelist_size <= 0) {
            return 1;
        }
        int foundNr = 0;
        int low = 0;
        int high = filelist_size - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int res = this.CompareShortname(name, ((CFileInfo)curDir.longNameList.elementAt((int)mid)).shortname);
            if (res > 0) {
                low = mid + 1;
                continue;
            }
            if (res < 0) {
                high = mid - 1;
                continue;
            }
            do {
                foundNr = ((CFileInfo)curDir.longNameList.elementAt((int)mid)).shortNr;
            } while (++mid < curDir.longNameList.size() && this.CompareShortname(name, ((CFileInfo)curDir.longNameList.elementAt((int)mid)).shortname) == 0);
            break;
        }
        return foundNr + 1;
    }

    private int CompareShortname(String compareName, String shortName) {
        int pos = shortName.indexOf(126);
        if (pos >= 0) {
            String cpos = shortName.substring(pos);
            int compareCount1 = shortName.indexOf("~");
            int numberSize = cpos.indexOf(".");
            int compareCount2 = compareName.indexOf(".");
            if (compareCount2 > 8) {
                compareCount2 = 8;
            }
            if (compareCount2 > compareCount1 + numberSize) {
                compareCount1 = compareCount2 - numberSize;
            }
            return compareName.substring(0, compareCount1).compareToIgnoreCase(shortName.substring(0, Math.min(compareCount1, shortName.length())));
        }
        return compareName.compareTo(shortName);
    }

    private boolean SetResult(CFileInfo dir, StringRef result, int entryNr) {
        if (entryNr >= dir.fileList.size()) {
            return false;
        }
        CFileInfo info = (CFileInfo)dir.fileList.elementAt(entryNr);
        result.value = info.shortname;
        dir.nextEntry = entryNr + 1;
        return true;
    }

    private boolean IsCachedIn(CFileInfo curDir) {
        return curDir.fileList.size() > 0;
    }

    private CFileInfo FindDirInfo(String path, StringRef expandedPath) {
        int pos;
        String work;
        StringRef dir = new StringRef();
        CFileInfo curDir = this.dirBase;
        IntRef id = new IntRef(0);
        if (this.save_dir != null && path.equals(this.save_path)) {
            expandedPath.value = this.save_expanded;
            return this.save_dir;
        }
        String start = this.basePath.length() >= path.length() ? "" : path.substring(this.basePath.length());
        expandedPath.value = this.basePath;
        if (!this.IsCachedIn(curDir) && this.OpenDir(curDir, work = this.basePath, id)) {
            StringRef result = new StringRef();
            String buffer = this.dirPath;
            this.ReadDir(id.value, result);
            this.dirPath = buffer;
            if (this.dirSearch[id.value] != null) {
                this.dirSearch[id.value].id = 2048;
                this.dirSearch[id.value] = null;
            }
        }
        do {
            dir.value = (pos = start.indexOf(File.separatorChar)) >= 0 ? start.substring(0, pos) : start;
            int nextDir = this.GetLongName(curDir, dir);
            expandedPath.value = expandedPath.value + dir.value;
            if (nextDir >= 0 && ((CFileInfo)curDir.fileList.elementAt((int)nextDir)).isDir) {
                curDir = (CFileInfo)curDir.fileList.elementAt(nextDir);
                curDir.orgname = dir.value;
                if (!this.IsCachedIn(curDir) && this.OpenDir(curDir, expandedPath.value, id)) {
                    String buffer = this.dirPath;
                    StringRef result = new StringRef();
                    this.ReadDir(id.value, result);
                    this.dirPath = buffer;
                    if (this.dirSearch[id.value] != null) {
                        this.dirSearch[id.value].id = 2048;
                        this.dirSearch[id.value] = null;
                    }
                }
            }
            if (pos < 0) continue;
            expandedPath.value = expandedPath.value + File.separator;
            start = start.substring(pos + 1);
        } while (pos >= 0);
        this.save_path = path;
        this.save_expanded = expandedPath.value;
        this.save_dir = curDir;
        return curDir;
    }

    private boolean OpenDir(CFileInfo dir, String expand, IntRef id) {
        Cross.dir_information dirp;
        id.value = this.GetFreeID(dir);
        this.dirSearch[id.value] = dir;
        String expandcopy = expand;
        if (expandcopy.endsWith(File.separator)) {
            expandcopy = expandcopy + File.separator;
        }
        if (this.dirSearch[id.value] != null && (dirp = Cross.open_directory(expandcopy)) != null) {
            Cross.close_directory(dirp);
            this.dirPath = expandcopy;
            return true;
        }
        if (this.dirSearch[id.value] != null) {
            this.dirSearch[id.value].id = 2048;
            this.dirSearch[id.value] = null;
        }
        return false;
    }

    private void CreateEntry(CFileInfo dir, String name, boolean is_directory) {
        CFileInfo info = new CFileInfo();
        info.orgname = name;
        info.shortNr = 0;
        info.isDir = is_directory;
        this.CreateShortName(dir, info);
        boolean found = false;
        if (dir.fileList.size() > 0) {
            if (info.shortname.compareTo(((CFileInfo)dir.fileList.lastElement()).shortname) >= 0) {
                dir.fileList.add(info);
            } else {
                int it;
                for (it = 0; it < dir.fileList.size(); ++it) {
                    if (info.shortname.compareTo(((CFileInfo)dir.fileList.elementAt((int)it)).shortname) >= 0) continue;
                    found = true;
                    break;
                }
                if (found) {
                    dir.fileList.insertElementAt(info, it);
                } else {
                    dir.fileList.add(info);
                }
            }
        } else {
            dir.fileList.add(info);
        }
    }

    void CopyEntry(CFileInfo dir, CFileInfo from) {
        CFileInfo info = new CFileInfo();
        info.orgname = from.orgname;
        info.shortname = from.shortname;
        info.shortNr = from.shortNr;
        info.isDir = from.isDir;
        dir.fileList.add(info);
    }

    int GetFreeID(CFileInfo dir) {
        if (dir.id != 2048) {
            return dir.id;
        }
        for (int i = 0; i < 2048; ++i) {
            if (this.dirSearch[i] != null) continue;
            dir.id = i;
            return i;
        }
        Log.log(11, 0, "DIRCACHE: Too many open directories!");
        dir.id = 0;
        return 0;
    }

    void Clear() {
        this.DeleteFileInfo(this.dirBase);
        this.dirBase = null;
        this.nextFreeFindFirst = 0;
        for (int i = 0; i < 2048; ++i) {
            this.dirSearch[i] = null;
        }
    }

    private static class CFileInfo {
        String orgname;
        String shortname;
        boolean isDir = false;
        int id = 2048;
        int nextEntry = 0;
        int shortNr = 0;
        Vector fileList = new Vector();
        Vector longNameList = new Vector();
    }

    public static final class TDirSort {
        public static final int NOSORT = 0;
        public static final int ALPHABETICAL = 1;
        public static final int DIRALPHABETICAL = 2;
        public static final int ALPHABETICALREV = 3;
        public static final int DIRALPHABETICALREV = 4;
    }
}

