/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.cpu.Core_normal;
import jdos.dos.Dos;
import jdos.dos.Dos_MCB;
import jdos.dos.Dos_PSP;
import jdos.dos.Dos_ParamBlock;
import jdos.dos.Dos_files;
import jdos.dos.Dos_memory;
import jdos.gui.Main;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.Ptr;
import jdos.util.StringRef;

public class Dos_execute {
    public static String RunningProgram = "DOSBOX";
    public static final int RETURN_EXIT = 0;
    public static final int RETURN_CTRLC = 1;
    public static final int RETURN_ABORT = 2;
    public static final int RETURN_TSR = 3;
    private static final int MAGIC1 = 23117;
    private static final int MAGIC2 = 19802;
    private static final int MAXENV = 32768;
    private static final int ENV_KEEPFREE = 83;
    private static final int LOADNGO = 0;
    private static final int LOAD = 1;
    private static final int OVERLAY = 3;

    private static void SaveRegisters() {
        CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() - 18);
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 0, CPU_Regs.reg_eax.word());
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 2, CPU_Regs.reg_ecx.word());
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4, CPU_Regs.reg_edx.word());
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 6, CPU_Regs.reg_ebx.word());
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 8, CPU_Regs.reg_esi.word());
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 10, CPU_Regs.reg_edi.word());
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 12, CPU_Regs.reg_ebp.word());
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 14, CPU.Segs_DSval);
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 16, CPU.Segs_ESval);
    }

    private static void RestoreRegisters() {
        CPU_Regs.reg_eax.word(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 0));
        CPU_Regs.reg_ecx.word(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 2));
        CPU_Regs.reg_edx.word(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4));
        CPU_Regs.reg_ebx.word(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 6));
        CPU_Regs.reg_esi.word(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 8));
        CPU_Regs.reg_edi.word(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 10));
        CPU_Regs.reg_ebp.word(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 12));
        CPU_Regs.SegSet16DS(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 14));
        CPU_Regs.SegSet16ES(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 16));
        CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() + 18);
    }

    public static void DOS_UpdatePSPName() {
        Dos_MCB mcb = new Dos_MCB(Dos.dos.psp() - 1);
        StringRef name = new StringRef();
        mcb.GetFileName(name);
        if (name.value.length() == 0) {
            name.value = "DOSBOX";
        }
        RunningProgram = name.value;
        Main.GFX_SetTitle(-1, -1, false);
    }

    public static void DOS_Terminate(int pspseg, boolean tsr, int exitcode) {
        Dos.dos.return_code = (short)exitcode;
        Dos.dos.return_mode = (short)(tsr ? 3 : 0);
        Dos_PSP curpsp = new Dos_PSP(pspseg);
        if (pspseg == curpsp.GetParent()) {
            return;
        }
        if (!tsr) {
            curpsp.CloseFiles();
        }
        int old22 = curpsp.GetInt22();
        curpsp.RestoreVectors();
        Dos.dos.psp(curpsp.GetParent());
        Dos_PSP parentpsp = new Dos_PSP(curpsp.GetParent());
        CPU_Regs.SegSet16SS(Memory.RealSeg(parentpsp.GetStack()));
        CPU_Regs.reg_esp.word(Memory.RealOff(parentpsp.GetStack()));
        Dos_execute.RestoreRegisters();
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 0, Memory.RealOff(old22));
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 2, Memory.RealSeg(old22));
        Memory.mem_writew(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 4, 29186);
        if (!tsr) {
            Dos_memory.DOS_FreeProcessMemory(pspseg);
        }
        Dos_execute.DOS_UpdatePSPName();
        if (CPU.CPU_AutoDetermineMode >> 2 == 0 || CPU.cpu.pmode) {
            return;
        }
        if (((CPU.CPU_AutoDetermineMode >>= 2) & 2) != 0) {
            CPU.CPU_CycleAutoAdjust = false;
            CPU.CPU_CycleLeft = 0;
            CPU.CPU_Cycles = 0;
            CPU.CPU_CycleMax = CPU.CPU_OldCycleMax;
            Main.GFX_SetTitle(CPU.CPU_OldCycleMax, -1, false);
        } else {
            Main.GFX_SetTitle(-1, -1, false);
        }
        if ((CPU.CPU_AutoDetermineMode & 1) != 0) {
            CPU.cpudecoder = Core_normal.CPU_Core_Normal_Run;
            CPU.CPU_CycleLeft = 0;
            CPU.CPU_Cycles = 0;
        }
    }

    private static int long2para(int size) {
        if (size > 1048560) {
            return 65535;
        }
        if ((size & 0xF) != 0) {
            return (size >> 4) + 1;
        }
        return size >> 4;
    }

    private static boolean MakeEnv(String name, IntRef segment) {
        IntRef size;
        int envread;
        Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
        int envsize = 1;
        boolean parentenv = true;
        if (segment.value == 0) {
            if (psp.GetEnvironment() == 0) {
                parentenv = false;
            }
            envread = Memory.PhysMake(psp.GetEnvironment(), 0);
        } else {
            if (segment.value == 0) {
                parentenv = false;
            }
            envread = Memory.PhysMake(segment.value, 0);
        }
        if (parentenv) {
            envsize = 0;
            while (true) {
                if (envsize >= 32685) {
                    Dos.DOS_SetError(10);
                    return false;
                }
                if (Memory.mem_readw(envread + envsize) == 0) break;
                ++envsize;
            }
            envsize += 2;
        }
        if (!Dos_memory.DOS_AllocateMemory(segment, size = new IntRef(Dos_execute.long2para(envsize + 83)))) {
            return false;
        }
        int envwrite = Memory.PhysMake(segment.value, 0);
        if (parentenv) {
            Memory.MEM_BlockCopy(envwrite, envread, envsize);
            envwrite += envsize;
        } else {
            Memory.mem_writeb(envwrite++, 0);
        }
        Memory.mem_writew(envwrite, 1);
        envwrite += 2;
        StringRef namebuf = new StringRef();
        if (Dos_files.DOS_Canonicalize(name, namebuf)) {
            Memory.MEM_BlockWrite(envwrite, namebuf.value, namebuf.value.length() + 1);
            return true;
        }
        return false;
    }

    public static boolean DOS_NewPSP(int segment, int size) {
        Dos_PSP psp = new Dos_PSP(segment);
        psp.MakeNew(size);
        int parent_psp_seg = psp.GetParent();
        Dos_PSP psp_parent = new Dos_PSP(parent_psp_seg);
        psp.CopyFileTable(psp_parent, false);
        psp.SetCommandTail(Memory.RealMake(parent_psp_seg, 128));
        return true;
    }

    public static boolean DOS_ChildPSP(int segment, int size) {
        Dos_PSP psp = new Dos_PSP(segment);
        psp.MakeNew(size);
        int parent_psp_seg = psp.GetParent();
        Dos_PSP psp_parent = new Dos_PSP(parent_psp_seg);
        psp.CopyFileTable(psp_parent, true);
        psp.SetCommandTail(Memory.RealMake(parent_psp_seg, 128));
        psp.SetFCB1(Memory.RealMake(parent_psp_seg, 92));
        psp.SetFCB2(Memory.RealMake(parent_psp_seg, 108));
        psp.SetEnvironment(psp_parent.GetEnvironment());
        psp.SetSize(size);
        return true;
    }

    private static void SetupPSP(int pspseg, int memsize, int envseg) {
        Dos_MCB mcb = new Dos_MCB(pspseg - 1);
        mcb.SetPSPSeg(pspseg);
        mcb.SetPt(envseg - 1);
        mcb.SetPSPSeg(pspseg);
        Dos_PSP psp = new Dos_PSP(pspseg);
        psp.MakeNew(memsize);
        psp.SetEnvironment(envseg);
        Dos_PSP oldpsp = new Dos_PSP(Dos.dos.psp());
        psp.CopyFileTable(oldpsp, true);
    }

    private static void SetupCMDLine(int pspseg, Dos_ParamBlock block) {
        Dos_PSP psp = new Dos_PSP(pspseg);
        psp.SetCommandTail(block.exec.cmdtail);
    }

    public static boolean DOS_Execute(String name, int block_pt, short flags) {
        Dos_PSP newpsp;
        Dos_PSP callpsp;
        int sssp;
        int csip;
        IntRef readsize;
        LongRef pos;
        int loadseg;
        IntRef len;
        EXE_Header head = new EXE_Header();
        IntRef fhandle = new IntRef(0);
        int headersize = 0;
        int imagesize = 0;
        Dos_ParamBlock block = new Dos_ParamBlock(block_pt);
        block.LoadData();
        if ((flags & 0x80) != 0) {
            Log.log(13, 2, "using loadhigh flag!!!!!. dropping it");
        }
        if ((flags = (short)(flags & 0x7F)) != 0 && flags != 3 && flags != 1) {
            Dos.DOS_SetError(11);
            return false;
        }
        boolean iscom = false;
        if (!Dos_files.DOS_OpenFile(name, 0, fhandle)) {
            Dos.DOS_SetError(2);
            return false;
        }
        byte[] hd = new byte[len.value];
        len = new IntRef(28);
        if (!Dos_files.DOS_ReadFile(fhandle.value, hd, len)) {
            Dos_files.DOS_CloseFile(fhandle.value);
            return false;
        }
        if (len.value < 28) {
            if (len.value == 0) {
                Dos.DOS_SetError(5);
                Dos_files.DOS_CloseFile(fhandle.value);
                return false;
            }
            iscom = true;
        } else {
            head.fill(hd);
            if (head.signature != 23117 && head.signature != 19802) {
                iscom = true;
            } else {
                if ((head.pages & 0xFFFFF800) != 0) {
                    Log.log(13, 0, "Weird header: head.pages > 1 MB");
                }
                head.pages &= 0x7FF;
                headersize = head.headersize * 16;
                imagesize = head.pages * 512 - headersize;
                if (imagesize + headersize < 512) {
                    imagesize = 512 - headersize;
                }
            }
        }
        byte[] loadbuf = new byte[65536];
        IntRef envseg = new IntRef(block.exec.envseg);
        IntRef pspseg = new IntRef(0);
        IntRef memsize = new IntRef(0);
        if (flags != 3) {
            IntRef dataread;
            LongRef pos2;
            int minsize;
            if (!Dos_execute.MakeEnv(name, envseg)) {
                Dos_files.DOS_CloseFile(fhandle.value);
                return false;
            }
            IntRef maxsize = new IntRef(0);
            IntRef maxfree = new IntRef(65535);
            Dos_memory.DOS_AllocateMemory(pspseg, maxfree);
            if (iscom) {
                minsize = 4096;
                maxsize.value = 65535;
                if (Dosbox.machine == 3) {
                    pos2 = new LongRef(0L);
                    Dos_files.DOS_SeekFile(fhandle.value, pos2, 0);
                    dataread = new IntRef(6144);
                    Dos_files.DOS_ReadFile(fhandle.value, loadbuf, dataread);
                    if (dataread.value < 6144) {
                        maxsize.value = dataread.value;
                    }
                    if (minsize > maxsize.value) {
                        minsize = maxsize.value;
                    }
                }
            } else {
                minsize = Dos_execute.long2para(imagesize + (head.minmemory << 4) + 256);
                maxsize.value = head.maxmemory != 0 ? Dos_execute.long2para(imagesize + (head.maxmemory << 4) + 256) : 65535;
            }
            if (maxfree.value < minsize) {
                if (iscom) {
                    pos2 = new LongRef(0L);
                    Dos_files.DOS_SeekFile(fhandle.value, pos2, 0);
                    dataread = new IntRef(63488);
                    Dos_files.DOS_ReadFile(fhandle.value, loadbuf, dataread);
                    if (dataread.value < 63488) {
                        minsize = (dataread.value + 16 >> 4) + 32;
                    }
                }
                if (maxfree.value < minsize) {
                    Dos_files.DOS_CloseFile(fhandle.value);
                    Dos.DOS_SetError(8);
                    Dos_memory.DOS_FreeMemory(envseg.value);
                    return false;
                }
            }
            memsize.value = maxfree.value < maxsize.value ? maxfree.value : maxsize.value;
            if (!Dos_memory.DOS_AllocateMemory(pspseg, memsize)) {
                Log.exit("DOS:Exec error in memory");
            }
            if (iscom && Dosbox.machine == 3 && pspseg.value < 8192) {
                maxsize.value = 65535;
                Dos_memory.DOS_ResizeMemory(pspseg.value, maxsize);
                if (Memory.real_readb(8192, 0) == 90 && Memory.real_readw(8192, 1) == 0 && Memory.real_readw(8192, 3) == 32766 && pspseg.value + maxsize.value == 6143) {
                    Dos_MCB cmcb = new Dos_MCB(pspseg.value - 1);
                    cmcb.SetType((short)90);
                }
            }
            loadseg = pspseg.value + 16;
            if (!iscom && head.minmemory == 0 && head.maxmemory == 0) {
                loadseg = ((pspseg.value + memsize.value) * 16 - imagesize) / 16;
            }
        } else {
            loadseg = block.overlay.loadseg;
        }
        int loadaddress = Memory.PhysMake(loadseg, 0);
        if (iscom) {
            pos = new LongRef(0L);
            Dos_files.DOS_SeekFile(fhandle.value, pos, 0);
            readsize = new IntRef(65279);
            Dos_files.DOS_ReadFile(fhandle.value, loadbuf, readsize);
            Memory.MEM_BlockWrite(loadaddress, loadbuf, readsize.value);
        } else {
            pos = new LongRef(headersize);
            Dos_files.DOS_SeekFile(fhandle.value, pos, 0);
            while (imagesize > Short.MAX_VALUE) {
                readsize = new IntRef(32768);
                Dos_files.DOS_ReadFile(fhandle.value, loadbuf, readsize);
                Memory.MEM_BlockWrite(loadaddress, loadbuf, readsize.value);
                loadaddress += 32768;
                imagesize -= 32768;
            }
            if (imagesize > 0) {
                readsize = new IntRef(imagesize);
                Dos_files.DOS_ReadFile(fhandle.value, loadbuf, readsize);
                Memory.MEM_BlockWrite(loadaddress, loadbuf, readsize.value);
            }
            int relocate = flags == 3 ? block.overlay.relocation : loadseg;
            pos.value = head.reloctable;
            Dos_files.DOS_SeekFile(fhandle.value, pos, 0);
            for (int i = 0; i < head.relocations; ++i) {
                byte[] d = new byte[4];
                IntRef readsize2 = new IntRef(4);
                Dos_files.DOS_ReadFile(fhandle.value, d, readsize2);
                int relocpt = new Ptr(d, 0).readd(0);
                int address = Memory.PhysMake(Memory.RealSeg(relocpt) + loadseg, Memory.RealOff(relocpt));
                Memory.mem_writew(address, Memory.mem_readw(address) + relocate);
            }
        }
        Dos_files.DOS_CloseFile(fhandle.value);
        if (flags != 3) {
            Dos_execute.SetupPSP(pspseg.value, memsize.value, envseg.value);
            Dos_execute.SetupCMDLine(pspseg.value, block);
        }
        Callback.CALLBACK_SCF(false);
        if (flags == 3) {
            return true;
        }
        if (iscom) {
            csip = Memory.RealMake(pspseg.value, 256);
            sssp = Memory.RealMake(pspseg.value, 65534);
            Memory.mem_writew(Memory.PhysMake(pspseg.value, 65534), 0);
        } else {
            csip = Memory.RealMake(loadseg + head.initCS, head.initIP);
            sssp = Memory.RealMake(loadseg + head.initSS, head.initSP);
            if (head.initSP < 4) {
                Log.log(13, 2, "stack underflow/wrap at EXEC");
            }
        }
        if (flags == 1) {
            Dos_execute.SaveRegisters();
            callpsp = new Dos_PSP(Dos.dos.psp());
            callpsp.SetStack(CPU_Regs.RealMakeSegSS(CPU_Regs.reg_esp.word()));
            CPU_Regs.reg_esp.word(CPU_Regs.reg_esp.word() + 18);
            Dos.dos.psp(pspseg.value);
            newpsp = new Dos_PSP(Dos.dos.psp());
            Dos.dos.dta(Memory.RealMake(newpsp.GetSegment(), 128));
            Memory.real_writew(Memory.RealSeg(sssp - 2), Memory.RealOff(sssp - 2), 65535);
            block.exec.initsssp = sssp - 2;
            block.exec.initcsip = csip;
            block.SaveData();
            return true;
        }
        if (flags == 0) {
            if (CPU_Regs.reg_esp.word() > 65534 || CPU_Regs.reg_esp.word() < 18) {
                Log.log(13, 2, "stack underflow/wrap at EXEC");
            }
            Memory.RealSetVec(34, Memory.RealMake(Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word() + 2), Memory.mem_readw(CPU.Segs_SSphys + CPU_Regs.reg_esp.word())));
            Dos_execute.SaveRegisters();
            callpsp = new Dos_PSP(Dos.dos.psp());
            callpsp.SetStack(CPU_Regs.RealMakeSegSS(CPU_Regs.reg_esp.word()));
            Dos.dos.psp(pspseg.value);
            newpsp = new Dos_PSP(Dos.dos.psp());
            Dos.dos.dta(Memory.RealMake(newpsp.GetSegment(), 128));
            newpsp.SaveVectors();
            newpsp.SetFCB1(block.exec.fcb1);
            newpsp.SetFCB2(block.exec.fcb2);
            CPU_Regs.SegSet16SS(Memory.RealSeg(sssp));
            CPU_Regs.reg_esp.word(Memory.RealOff(sssp));
            CPU.CPU_Push16(Memory.RealSeg(csip));
            CPU.CPU_Push16(Memory.RealOff(csip));
            CPU_Regs.flags = CPU_Regs.flags & 0xFFFFF72A | 0x200;
            CPU_Regs.reg_ip(CPU_Regs.reg_ip() + 1);
            CPU_Regs.reg_eax.word(0);
            CPU_Regs.reg_ebx.word(0);
            CPU_Regs.reg_ecx.word(255);
            CPU_Regs.reg_edx.word(pspseg.value);
            CPU_Regs.reg_esi.word(Memory.RealOff(csip));
            CPU_Regs.reg_edi.word(Memory.RealOff(sssp));
            CPU_Regs.reg_ebp.word(2332);
            CPU_Regs.SegSet16DS(pspseg.value);
            CPU_Regs.SegSet16ES(pspseg.value);
            String stripname = "";
            block5: while (name.length() > 0) {
                char chr = name.charAt(0);
                name = name.substring(1);
                switch (chr) {
                    case '/': 
                    case ':': 
                    case '\\': {
                        stripname = "";
                        continue block5;
                    }
                }
                stripname = stripname + String.valueOf(chr).toUpperCase();
            }
            int p = stripname.indexOf(46);
            if (p >= 0) {
                stripname = stripname.substring(0, p);
            }
            Dos_MCB pspmcb = new Dos_MCB(Dos.dos.psp() - 1);
            pspmcb.SetFileName(stripname);
            Dos_execute.DOS_UpdatePSPName();
            return true;
        }
        return false;
    }

    private static class EXE_Header {
        public static final int size = 28;
        int signature;
        int extrabytes;
        int pages;
        int relocations;
        int headersize;
        int minmemory;
        int maxmemory;
        int initSS;
        int initSP;
        int checksum;
        int initIP;
        int initCS;
        int reloctable;
        int overlay;

        private EXE_Header() {
        }

        public void fill(byte[] data) {
            Ptr p = new Ptr(data, 0);
            this.signature = p.readw(0);
            this.extrabytes = p.readw(2);
            this.pages = p.readw(4);
            this.relocations = p.readw(6);
            this.headersize = p.readw(8);
            this.minmemory = p.readw(10);
            this.maxmemory = p.readw(12);
            this.initSS = p.readw(14);
            this.initSP = p.readw(16);
            this.checksum = p.readw(18);
            this.initIP = p.readw(20);
            this.initCS = p.readw(22);
            this.reloctable = p.readw(24);
            this.overlay = p.readw(26);
        }
    }
}

