/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import java.util.Random;
import jdos.cpu.CPU_Regs;
import jdos.dos.DOS_Device;
import jdos.dos.DOS_File;
import jdos.dos.Dos;
import jdos.dos.Dos_DTA;
import jdos.dos.Dos_Drive;
import jdos.dos.Dos_FCB;
import jdos.dos.Dos_PSP;
import jdos.dos.Dos_SDA;
import jdos.dos.Dos_devices;
import jdos.dos.drives.Drive_virtual;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class Dos_files {
    public static final int DOS_FILES = 127;
    public static final int DOS_DRIVES = 26;
    public static final int DOS_FILESTART = 4;
    public static final int FCB_SUCCESS = 0;
    public static final int FCB_READ_NODATA = 1;
    public static final int FCB_READ_PARTIAL = 3;
    public static final int FCB_ERR_NODATA = 1;
    public static final int FCB_ERR_EOF = 3;
    public static final int FCB_ERR_WRITE = 1;
    public static final int OPEN_READ = 0;
    public static final int OPEN_WRITE = 1;
    public static final int OPEN_READWRITE = 2;
    public static final int DOS_NOT_INHERIT = 128;
    public static final int DOS_SEEK_SET = 0;
    public static final int DOS_SEEK_CUR = 1;
    public static final int DOS_SEEK_END = 2;
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    public static final int STDAUX = 3;
    public static final int STDPRN = 4;
    public static DOS_File[] Files = new DOS_File[127];
    public static Dos_Drive[] Drives = new Dos_Drive[26];
    private static final String FCB_SEP = ":.;,=+";
    private static final String ILLEGAL = ":.;,=+ \t/\"[]<>|";
    private static final int PARSE_SEP_STOP = 1;
    private static final int PARSE_DFLT_DRIVE = 2;
    private static final int PARSE_BLNK_FNAME = 4;
    private static final int PARSE_BLNK_FEXT = 8;
    private static final int PARSE_RET_NOWILD = 0;
    private static final int PARSE_RET_WILD = 1;
    private static final int PARSE_RET_BADDRIVE = 255;

    public static short DOS_GetDefaultDrive() {
        short d = new Dos_SDA(178, 0).GetDrive();
        if (d != Dos.dos.current_drive) {
            Log.log(14, 2, "SDA drive " + d + " not the same as dos.current_drive " + Dos.dos.current_drive);
        }
        return Dos.dos.current_drive;
    }

    public static void DOS_SetDefaultDrive(short drive) {
        if (drive < 26 && (drive < 2 || Drives[drive] != null)) {
            Dos.dos.current_drive = (byte)drive;
            new Dos_SDA(178, 0).SetDrive(drive);
        }
    }

    public static boolean DOS_MakeName(String name, StringRef fullname, ShortRef drive) {
        int t;
        if (name == null || name.length() == 0 || name.startsWith(" ")) {
            Dos.DOS_SetError(2);
            return false;
        }
        String name_int = name;
        byte[] tempdir = new byte[80];
        byte[] upname = new byte[80];
        drive.value = Dos_files.DOS_GetDefaultDrive();
        if (name.length() > 1 && name_int.charAt(1) == ':') {
            drive.value = (short)((name_int.charAt(0) | 0x20) - 97);
            name_int = name_int.substring(2);
        }
        if (drive.value >= 26 || drive.value < 0 || Drives[drive.value] == null) {
            Dos.DOS_SetError(3);
            return false;
        }
        int r = 0;
        int w = 0;
        block5: while (r < name_int.length() && r < 80) {
            byte c;
            if ((c = (byte)name_int.charAt(r++)) >= 97 && c <= 122) {
                upname[w++] = (byte)(c - 32);
                continue;
            }
            if (c >= 65 && c <= 90) {
                upname[w++] = c;
                continue;
            }
            if (c >= 48 && c <= 57) {
                upname[w++] = c;
                continue;
            }
            switch (c & 0xFF) {
                case 47: {
                    upname[w++] = 92;
                    continue block5;
                }
                case 32: {
                    continue block5;
                }
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 63: 
                case 64: 
                case 92: 
                case 94: 
                case 95: 
                case 96: 
                case 123: 
                case 125: 
                case 126: 
                case 160: 
                case 189: 
                case 229: 
                case 246: 
                case 255: {
                    upname[w++] = c;
                    continue block5;
                }
            }
            Dos.DOS_SetError(3);
            return false;
        }
        if (r >= 80) {
            Dos.DOS_SetError(3);
            return false;
        }
        upname[w] = 0;
        fullname.value = upname[0] != 92 ? Dos_files.Drives[drive.value].curdir : "";
        int lastdir = 0;
        for (t = 0; t < fullname.value.length(); ++t) {
            if (fullname.value.charAt(t) != '\\' || t + 1 >= fullname.value.length()) continue;
            lastdir = t;
        }
        r = 0;
        w = 0;
        tempdir[0] = 0;
        boolean stop = false;
        while (!stop) {
            if (upname[r] == 0) {
                stop = true;
            }
            if (upname[r] == 92 || upname[r] == 0) {
                int iDown;
                tempdir[w] = 0;
                if (tempdir[0] == 0) {
                    w = 0;
                    ++r;
                    continue;
                }
                if (tempdir[0] == 46 && tempdir[1] == 0) {
                    tempdir[0] = 0;
                    w = 0;
                    ++r;
                    continue;
                }
                boolean dots = true;
                int templen = StringHelper.strlen(tempdir);
                for (iDown = 0; iDown < templen && dots; ++iDown) {
                    if (tempdir[iDown] == 46) continue;
                    dots = false;
                }
                if (dots && templen > 1) {
                    int cDots = templen - 1;
                    for (iDown = fullname.value.length() - 1; iDown >= 0; --iDown) {
                        if (fullname.value.charAt(iDown) != '\\' && iDown != 0) continue;
                        lastdir = iDown;
                        if (--cDots == 0) break;
                    }
                    fullname.value = fullname.value.substring(0, lastdir);
                    lastdir = 0;
                    for (t = 0; t < fullname.value.length(); ++t) {
                        if (fullname.value.charAt(t) != '\\' || t + 1 >= fullname.value.length()) continue;
                        lastdir = t;
                    }
                    tempdir[0] = 0;
                    w = 0;
                    ++r;
                    continue;
                }
                lastdir = fullname.value.length();
                if (lastdir != 0) {
                    fullname.value = fullname.value + "\\";
                }
                String stempdir = new String(tempdir, 0, StringHelper.strlen(tempdir));
                int pos = stempdir.indexOf(46);
                String ext = null;
                if (pos >= 0) {
                    ext = stempdir.substring(pos);
                }
                if (ext != null) {
                    if (ext.indexOf(46, 1) >= 0) {
                        if (stop) {
                            Dos.DOS_SetError(2);
                        } else {
                            Dos.DOS_SetError(3);
                        }
                        return false;
                    }
                    ext = ext.substring(0, Math.min(4, ext.length()));
                    if (StringHelper.strlen(tempdir) - ext.length() > 8) {
                        System.arraycopy(ext.getBytes(), 0, tempdir, 8, 4);
                    }
                } else {
                    tempdir[8] = 0;
                }
                if (fullname.value.length() + StringHelper.strlen(tempdir) >= 80) {
                    Dos.DOS_SetError(3);
                    return false;
                }
                fullname.value = fullname.value + new String(tempdir, 0, StringHelper.strlen(tempdir));
                tempdir[0] = 0;
                w = 0;
                ++r;
                continue;
            }
            tempdir[w++] = upname[r++];
        }
        return true;
    }

    public static boolean DOS_GetCurrentDir(short drive, StringRef buffer) {
        if ((drive = drive == 0 ? Dos_files.DOS_GetDefaultDrive() : (short)(drive - 1)) >= 26 || Drives[drive] == null) {
            Dos.DOS_SetError(15);
            return false;
        }
        buffer.value = Dos_files.Drives[drive].curdir;
        return true;
    }

    public static boolean DOS_ChangeDir(String dir) {
        ShortRef drive = new ShortRef();
        StringRef fulldir = new StringRef();
        String testdir = dir;
        if (testdir.length() > 1 && testdir.charAt(1) == ':') {
            testdir = testdir.substring(2);
        }
        if (testdir.length() == 0 || testdir.length() > 1 && testdir.charAt(testdir.length() - 1) == '\\') {
            Dos.DOS_SetError(3);
            return false;
        }
        if (!Dos_files.DOS_MakeName(dir, fulldir, drive)) {
            return false;
        }
        if (Drives[drive.value].TestDir(fulldir.value)) {
            Dos_files.Drives[drive.value].curdir = fulldir.value;
            return true;
        }
        Dos.DOS_SetError(3);
        return false;
    }

    public static boolean DOS_MakeDir(String dir) {
        ShortRef drive = new ShortRef();
        StringRef fulldir = new StringRef();
        if (dir == null || dir.length() == 0 || dir.endsWith("\\")) {
            Dos.DOS_SetError(3);
            return false;
        }
        if (!Dos_files.DOS_MakeName(dir, fulldir, drive)) {
            return false;
        }
        if (Drives[drive.value].MakeDir(fulldir.value)) {
            return true;
        }
        if (Drives[drive.value].TestDir(fulldir.value)) {
            Dos.DOS_SetError(5);
        } else {
            Dos.DOS_SetError(3);
        }
        return false;
    }

    public static boolean DOS_RemoveDir(String dir) {
        StringRef fulldir = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(dir, fulldir, drive)) {
            return false;
        }
        if (!Drives[drive.value].TestDir(fulldir.value)) {
            Dos.DOS_SetError(3);
            return false;
        }
        StringRef currdir = new StringRef();
        Dos_files.DOS_GetCurrentDir((short)(drive.value + 1), currdir);
        if (currdir.equals(fulldir.value)) {
            Dos.DOS_SetError(16);
            return false;
        }
        if (Drives[drive.value].RemoveDir(fulldir.value)) {
            return true;
        }
        Dos.DOS_SetError(5);
        return false;
    }

    public static boolean DOS_Rename(String oldname, String newname) {
        ShortRef driveold = new ShortRef();
        StringRef fullold = new StringRef();
        ShortRef drivenew = new ShortRef();
        StringRef fullnew = new StringRef();
        if (!Dos_files.DOS_MakeName(oldname, fullold, driveold)) {
            return false;
        }
        if (!Dos_files.DOS_MakeName(newname, fullnew, drivenew)) {
            return false;
        }
        if (Dos_devices.DOS_FindDevice(oldname) != 10 || Dos_devices.DOS_FindDevice(newname) != 10) {
            Dos.DOS_SetError(2);
            return false;
        }
        if (driveold.value != drivenew.value) {
            Dos.DOS_SetError(17);
            return false;
        }
        IntRef attr = new IntRef(0);
        if (Drives[drivenew.value].GetFileAttr(fullnew.value, attr)) {
            Dos.DOS_SetError(5);
            return false;
        }
        if (!Drives[driveold.value].GetFileAttr(fullold.value, attr)) {
            Dos.DOS_SetError(2);
            return false;
        }
        if (Drives[drivenew.value].Rename(fullold.value, fullnew.value)) {
            return true;
        }
        Dos.DOS_SetError(2);
        return false;
    }

    public static boolean DOS_FindFirst(String search, int attr) {
        return Dos_files.DOS_FindFirst(search, attr, false);
    }

    public static boolean DOS_FindFirst(String search, int attr, boolean fcb_findfirst) {
        String dir;
        String pattern;
        Dos_DTA dta = new Dos_DTA(Dos.dos.dta());
        ShortRef drive = new ShortRef();
        StringRef fullsearch = new StringRef();
        if (search.length() > 0 && search.endsWith("\\") && (search.length() <= 2 || search.charAt(search.length() - 2) != ':' || attr != 8)) {
            Dos.DOS_SetError(18);
            return false;
        }
        if (!Dos_files.DOS_MakeName(search, fullsearch, drive)) {
            return false;
        }
        boolean device = Dos_devices.DOS_FindDevice(search) != 10;
        int pos = fullsearch.value.lastIndexOf(92);
        if (pos < 0) {
            pattern = fullsearch.value;
            dir = "";
        } else {
            dir = fullsearch.value.substring(0, pos);
            pattern = fullsearch.value.substring(pos + 1);
        }
        dta.SetupSearch(drive.value, (short)attr, pattern);
        if (device) {
            pos = pattern.indexOf(46);
            if (pos >= 0) {
                pattern = pattern.substring(0, pos);
            }
            dta.SetResult(pattern, 0L, 0, 0, (short)64);
            Log.log(14, 1, "finding device " + pattern);
            return true;
        }
        return Drives[drive.value].FindFirst(dir, dta, fcb_findfirst);
    }

    public static boolean DOS_FindNext() {
        Dos_DTA dta = new Dos_DTA(Dos.dos.dta());
        short i = dta.GetSearchDrive();
        if (i >= 26 || Drives[i] == null) {
            Log.log(11, 2, "Corrupt search!!!!");
            Dos.DOS_SetError(18);
            return false;
        }
        return Drives[i].FindNext(dta);
    }

    public static boolean DOS_ReadFile(int entry, byte[] data, IntRef amount) {
        int handle = Dos.RealHandle(entry);
        if (handle >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle] == null || !Files[handle].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        boolean ret = Files[handle].Read(data, amount);
        return ret;
    }

    public static boolean DOS_WriteFile(int entry, byte[] data, IntRef amount) {
        int handle = Dos.RealHandle(entry);
        if (handle >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle] == null || !Files[handle].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        boolean ret = Files[handle].Write(data, amount);
        return ret;
    }

    public static boolean DOS_SeekFile(int entry, LongRef pos, int type) {
        int handle = Dos.RealHandle(entry);
        if (handle >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle] == null || !Files[handle].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        return Files[handle].Seek(pos, type);
    }

    public static boolean DOS_CloseFile(int entry) {
        int handle = Dos.RealHandle(entry);
        if (handle >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle] == null || !Files[handle].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle].IsOpen()) {
            Files[handle].Close();
        }
        Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
        psp.SetFileHandle(entry, 255);
        if (Files[handle].RemoveRef() <= 0) {
            Dos_files.Files[handle] = null;
        }
        return true;
    }

    public static boolean DOS_FlushFile(int entry) {
        int handle = Dos.RealHandle(entry);
        if (handle >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle] == null || !Files[handle].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        Log.log(14, 0, "FFlush used.");
        return true;
    }

    private static boolean PathExists(String name) {
        ShortRef drive;
        StringRef fulldir;
        if (name.lastIndexOf(92) < 0) {
            return true;
        }
        if (name.lastIndexOf(92) == 0) {
            return true;
        }
        if (!Dos_files.DOS_MakeName(name = name.substring(0, name.lastIndexOf(92)), fulldir = new StringRef(), drive = new ShortRef())) {
            return false;
        }
        return Drives[drive.value].TestDir(fulldir.value);
    }

    public static boolean DOS_CreateFile(String name, int attributes, IntRef entry) {
        boolean foundit;
        if (Dos_devices.DOS_FindDevice(name) != 10) {
            return Dos_files.DOS_OpenFile(name, 0, entry);
        }
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return false;
        }
        int handle = 127;
        for (int i = 0; i < 127; i = (int)((short)(i + 1))) {
            if (Files[i] != null) continue;
            handle = i;
            break;
        }
        if (handle == 127) {
            Dos.DOS_SetError(4);
            return false;
        }
        entry.value = psp.FindFreeFileEntry();
        if (entry.value == 255) {
            Dos.DOS_SetError(4);
            return false;
        }
        if ((attributes & 0x10) != 0) {
            Dos.DOS_SetError(5);
            return false;
        }
        Dos_files.Files[handle] = Drives[drive.value].FileCreate(fullname.value, attributes);
        boolean bl = foundit = Files[handle] != null;
        if (foundit) {
            Files[handle].SetDrive(drive.value);
            Files[handle].AddRef();
            psp.SetFileHandle(entry.value, handle);
            return true;
        }
        if (!Dos_files.PathExists(name)) {
            Dos.DOS_SetError(3);
        } else {
            Dos.DOS_SetError(2);
        }
        return false;
    }

    public static boolean DOS_OpenFile(String name, int flags, IntRef entry) {
        boolean device;
        if (flags > 2) {
            Log.log(11, 2, "Special file open command " + Integer.toString(flags, 16) + " file " + name);
        }
        Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
        IntRef attr = new IntRef(0);
        short devnum = Dos_devices.DOS_FindDevice(name);
        boolean bl = device = devnum != 10;
        if (!device && Dos_files.DOS_GetFileAttr(name, attr) && ((attr.value & 0x10) != 0 || (attr.value & 8) != 0)) {
            Dos.DOS_SetError(5);
            return false;
        }
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return false;
        }
        int handle = 255;
        for (int i = 0; i < 127; i = (int)((short)(i + 1))) {
            if (Files[i] != null) continue;
            handle = i;
            break;
        }
        if (handle == 255) {
            Dos.DOS_SetError(4);
            return false;
        }
        entry.value = psp.FindFreeFileEntry();
        if (entry.value == 255) {
            Dos.DOS_SetError(4);
            return false;
        }
        boolean exists = false;
        if (device) {
            Dos_files.Files[handle] = new DOS_Device(Dos_devices.Devices[devnum]);
        } else {
            Dos_files.Files[handle] = Drives[drive.value].FileOpen(fullname.value, flags);
            boolean bl2 = exists = Files[handle] != null;
            if (exists) {
                Files[handle].SetDrive(drive.value);
            }
        }
        if (exists || device) {
            Files[handle].AddRef();
            psp.SetFileHandle(entry.value, handle);
            return true;
        }
        if ((flags & 3) != 0 && Drives[drive.value].FileExists(fullname.value)) {
            Dos.DOS_SetError(5);
        } else if (!Dos_files.PathExists(name)) {
            Dos.DOS_SetError(3);
        } else {
            Dos.DOS_SetError(2);
        }
        return false;
    }

    public static boolean DOS_OpenFileExtended(String name, int flags, int createAttr, int action, IntRef entry, IntRef status) {
        int result = 0;
        if (action == 0) {
            Dos.DOS_SetError(1);
            return false;
        }
        if ((action & 0xF) > 2 || (action & 0xF0) > 16) {
            Dos.DOS_SetError(1);
            return false;
        }
        if (Dos_files.DOS_OpenFile(name, (short)(flags & 0xFF), entry)) {
            switch (action & 0xF) {
                case 0: {
                    Dos.DOS_SetError(80);
                    return false;
                }
                case 1: {
                    result = 1;
                    break;
                }
                case 2: {
                    Dos_files.DOS_CloseFile(entry.value);
                    if (!Dos_files.DOS_CreateFile(name, createAttr, entry)) {
                        return false;
                    }
                    result = 3;
                    break;
                }
                default: {
                    Dos.DOS_SetError(1);
                    Log.exit("DOS: OpenFileExtended: Unknown action.");
                    break;
                }
            }
        } else {
            if ((action & 0xF0) == 0) {
                return false;
            }
            if (!Dos_files.DOS_CreateFile(name, createAttr, entry)) {
                return false;
            }
            result = 2;
        }
        status.value = result;
        return true;
    }

    public static boolean DOS_UnlinkFile(String name) {
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return false;
        }
        if (Drives[drive.value].FileUnlink(fullname.value)) {
            return true;
        }
        Dos.DOS_SetError(2);
        return false;
    }

    public static boolean DOS_GetFileAttr(String name, IntRef attr) {
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return false;
        }
        if (Drives[drive.value].GetFileAttr(fullname.value, attr)) {
            return true;
        }
        Dos.DOS_SetError(2);
        return false;
    }

    public static boolean DOS_SetFileAttr(String name, int attr) {
        IntRef attrTemp = new IntRef(0);
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return false;
        }
        if (Drives[drive.value].GetInfo().startsWith("CDRom ") || Drives[drive.value].GetInfo().startsWith("isoDrive ")) {
            Dos.DOS_SetError(5);
            return false;
        }
        return Drives[drive.value].GetFileAttr(fullname.value, attrTemp);
    }

    public static boolean DOS_Canonicalize(String name, StringRef big) {
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return false;
        }
        big.value = String.valueOf((char)(drive.value + 65));
        big.value = big.value + ':';
        big.value = big.value + '\\';
        big.value = big.value + fullname.value;
        return true;
    }

    public static boolean DOS_GetFreeDiskSpace(short drive, IntRef bytes, ShortRef sectors, IntRef clusters, IntRef free) {
        if ((drive = drive == 0 ? Dos_files.DOS_GetDefaultDrive() : (short)(drive - 1)) >= 26 || Drives[drive] == null) {
            Dos.DOS_SetError(15);
            return false;
        }
        return Drives[drive].AllocationInfo(bytes, sectors, clusters, free);
    }

    public static boolean DOS_DuplicateEntry(int entry, IntRef newentry) {
        int handle = Dos.RealHandle(entry);
        if (handle >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle] == null || !Files[handle].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
        newentry.value = psp.FindFreeFileEntry();
        if (newentry.value == 255) {
            Dos.DOS_SetError(4);
            return false;
        }
        Files[handle].AddRef();
        psp.SetFileHandle(newentry.value, handle);
        return true;
    }

    public static boolean DOS_ForceDuplicateEntry(int entry, int newentry) {
        if (entry == newentry) {
            Dos.DOS_SetError(6);
            return false;
        }
        int orig = Dos.RealHandle(entry);
        if (orig >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[orig] == null || !Files[orig].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        int newone = Dos.RealHandle(newentry);
        if (newone < 127 && Files[newone] != null) {
            Dos_files.DOS_CloseFile(newentry);
        }
        Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
        Files[orig].AddRef();
        psp.SetFileHandle(newentry, orig);
        return true;
    }

    public static boolean DOS_CreateTempFile(StringRef name, IntRef entry) {
        StringBuffer tempname;
        if (name.value.length() == 0) {
            name.value = "\\";
        } else if (!name.value.endsWith("\\") && !name.value.endsWith("/")) {
            name.value = name.value + "\\";
        }
        Dos.dos.errorcode = 0;
        Random r = new Random();
        do {
            tempname = new StringBuffer();
            for (int i = 0; i < 8; ++i) {
                tempname.append((char)(Math.abs(r.nextInt() % 26) + 65));
            }
        } while (!Dos_files.DOS_CreateFile(name.value + tempname.toString(), 0, entry) && Dos.dos.errorcode == 80);
        name.value = name.value + tempname;
        return Dos.dos.errorcode == 0;
    }

    private static boolean isvalid(char in) {
        return in > '\u001f' && ILLEGAL.indexOf(in) < 0;
    }

    public static short FCB_Parsename(int seg, int offset, short parser, String string, ShortRef change) {
        int p;
        int begin_len = string.length();
        short ret = 0;
        if ((parser & 2) == 0) {
            Memory.mem_writeb(Memory.PhysMake(seg, offset), 0);
        }
        Dos_FCB fcb = new Dos_FCB(seg, offset, false);
        boolean finished = false;
        boolean hasext = false;
        boolean hasname = false;
        boolean hasdrive = false;
        int index = 0;
        int fill = 32;
        StringRef fcb_name = new StringRef();
        fcb.GetName(fcb_name);
        char drive = (char)(fcb_name.value.charAt(0) - 65 + 1);
        byte[] name = new byte[8];
        byte[] b = fcb_name.value.substring(2, fcb_name.value.lastIndexOf(46)).getBytes();
        System.arraycopy(b, 0, name, 0, Math.min(b.length, 8));
        byte[] ext = new byte[3];
        b = fcb_name.value.substring(fcb_name.value.lastIndexOf(46) + 1).getBytes();
        System.arraycopy(b, 0, ext, 0, Math.min(b.length, ext.length));
        if ((parser & 1) != 0 && string.length() > 0 && FCB_SEP.indexOf(string.charAt(0)) >= 0) {
            string = string.substring(1);
        }
        while (string.length() > 0 && (string.charAt(0) == ' ' || string.charAt(0) == '\t')) {
            string = string.substring(1);
        }
        if (string.length() > 1 && string.charAt(1) == ':') {
            drive = '\u0000';
            hasdrive = true;
            char d = string.substring(0, 1).toUpperCase().charAt(0);
            if (d >= 'A' && d <= 'Z' && Drives[d - 65] != null) {
                drive = (char)(d - 65 + 1);
            } else {
                ret = 255;
            }
            string = string.substring(2);
        }
        if ((p = string.lastIndexOf("\\")) >= 0) {
            string = string.substring(p + 1);
        }
        boolean skipext = false;
        if (string.length() > 0 && string.charAt(0) == '.') {
            if ((string = string.substring(1)).length() == 0) {
                hasname = true;
                ret = 0;
                name = ".       ".getBytes();
                skipext = true;
            } else if (string.charAt(0) == '.' && string.length() == 1) {
                string = "";
                hasname = true;
                ret = 0;
                name = "..      ".getBytes();
                skipext = true;
            }
        } else {
            hasname = true;
            finished = false;
            fill = 32;
            index = 0;
            while (index < 8) {
                if (!finished && string.length() > 0) {
                    if (string.charAt(0) == '*') {
                        fill = 63;
                        name[index] = 63;
                        if (ret == 0) {
                            ret = 1;
                        }
                        finished = true;
                    } else if (string.charAt(0) == '?') {
                        name[index] = 63;
                        if (ret == 0) {
                            ret = 1;
                        }
                    } else if (Dos_files.isvalid(string.charAt(0))) {
                        name[index] = (byte)string.toUpperCase().charAt(0);
                    } else {
                        finished = true;
                        continue;
                    }
                    string = string.substring(1);
                } else {
                    name[index] = (byte)fill;
                }
                ++index;
            }
            if (string.length() > 0) {
                if (string.charAt(0) != '.') {
                    skipext = true;
                } else {
                    string = string.substring(1);
                }
            }
        }
        if (!skipext) {
            hasext = true;
            finished = false;
            fill = 32;
            index = 0;
            while (index < 3) {
                if (!finished && string.length() > 0) {
                    if (string.charAt(0) == '*') {
                        fill = 63;
                        ext[index] = 63;
                        finished = true;
                    } else if (string.charAt(0) == '?') {
                        ext[index] = 63;
                        if (ret == 0) {
                            ret = 1;
                        }
                    } else if (Dos_files.isvalid(string.charAt(0))) {
                        ext[index] = (byte)string.toUpperCase().charAt(0);
                    } else {
                        finished = true;
                        continue;
                    }
                    string = string.substring(1);
                } else {
                    ext[index] = (byte)fill;
                }
                ++index;
            }
        }
        if (!hasdrive & (parser & 2) == 0) {
            drive = '\u0000';
        }
        if (!hasname & (parser & 4) == 0) {
            name = "        ".getBytes();
        }
        if (!hasext & (parser & 8) == 0) {
            ext = "   ".getBytes();
        }
        fcb.SetName((short)drive, new String(name), new String(ext));
        change.value = (short)(begin_len - string.length());
        return ret;
    }

    private static void DTAExtendName(String name, StringRef filename, StringRef ext) {
        int pos = name.indexOf(46);
        if (pos >= 0) {
            ext.value = name.substring(pos + 1);
            name = name.substring(0, pos);
        } else {
            ext.value = "";
        }
        filename.value = name;
        while (filename.value.length() < 8) {
            filename.value = filename.value + " ";
        }
        while (ext.value.length() < 3) {
            ext.value = ext.value + " ";
        }
    }

    private static void SaveFindResult(Dos_FCB find_fcb) {
        Dos_DTA find_dta = new Dos_DTA(Dos.dos.tables.tempdta);
        StringRef name = new StringRef();
        LongRef size = new LongRef(0L);
        IntRef date = new IntRef(0);
        IntRef time = new IntRef(0);
        ShortRef attr = new ShortRef();
        StringRef file_name = new StringRef();
        StringRef ext = new StringRef();
        find_dta.GetResult(name, size, date, time, attr);
        short drive = (short)(find_fcb.GetDrive() + 1);
        Dos_files.DTAExtendName(name.value, file_name, ext);
        Dos_FCB fcb = new Dos_FCB(Memory.RealSeg(Dos.dos.dta()), Memory.RealOff(Dos.dos.dta()));
        fcb.Create(find_fcb.Extended());
        fcb.SetName(drive, file_name.value, ext.value);
        fcb.SetAttr(attr.value);
        fcb.SetSizeDateTime(size.value, date.value, time.value);
    }

    public static boolean DOS_FCBCreate(int seg, int offset) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        StringRef shortname = new StringRef();
        IntRef handle = new IntRef(0);
        fcb.GetName(shortname);
        if (!Dos_files.DOS_CreateFile(shortname.value, 32, handle)) {
            return false;
        }
        fcb.FileOpen((short)handle.value);
        return true;
    }

    public static boolean DOS_FCBOpen(int seg, int offset) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        StringRef shortname = new StringRef();
        IntRef handle = new IntRef(0);
        fcb.GetName(shortname);
        ShortRef drive = new ShortRef();
        StringRef fullname = new StringRef();
        if (!Dos_files.DOS_MakeName(shortname.value, fullname, drive)) {
            return false;
        }
        for (short i = 0; i < 127; i = (short)((short)(i + 1))) {
            Dos_PSP psp = new Dos_PSP(Dos.dos.psp());
            if (Files[i] == null || !Files[i].IsOpen() || !Files[i].IsName(fullname.value)) continue;
            handle.value = psp.FindEntryByHandle(i);
            if (handle.value == 255) {
                Log.log(11, 2, "DOS: File " + shortname + " is opened but has no psp entry.");
                return false;
            }
            fcb.FileOpen((short)handle.value);
            return true;
        }
        if (!Dos_files.DOS_OpenFile(shortname.value, 2, handle)) {
            return false;
        }
        fcb.FileOpen((short)handle.value);
        return true;
    }

    public static boolean DOS_FCBClose(int seg, int offset) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        if (!fcb.Valid()) {
            return false;
        }
        ShortRef fhandle = new ShortRef();
        fcb.FileClose(fhandle);
        Dos_files.DOS_CloseFile(fhandle.value);
        return true;
    }

    public static boolean DOS_FCBFindFirst(int seg, int offset) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        int old_dta = Dos.dos.dta();
        Dos.dos.dta(Dos.dos.tables.tempdta);
        StringRef name = new StringRef();
        fcb.GetName(name);
        ShortRef attr = new ShortRef(32);
        fcb.GetAttr(attr);
        boolean ret = Dos_files.DOS_FindFirst(name.value, attr.value, true);
        Dos.dos.dta(old_dta);
        if (ret) {
            Dos_files.SaveFindResult(fcb);
        }
        return ret;
    }

    public static boolean DOS_FCBFindNext(int seg, int offset) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        int old_dta = Dos.dos.dta();
        Dos.dos.dta(Dos.dos.tables.tempdta);
        boolean ret = Dos_files.DOS_FindNext();
        Dos.dos.dta(old_dta);
        if (ret) {
            Dos_files.SaveFindResult(fcb);
        }
        return ret;
    }

    public static short DOS_FCBRead(int seg, int offset, int recno) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        ShortRef fhandle = new ShortRef();
        ShortRef cur_rec = new ShortRef();
        IntRef cur_block = new IntRef(0);
        IntRef rec_size = new IntRef(0);
        fcb.GetSeqData(fhandle, rec_size);
        fcb.GetRecord(cur_block, cur_rec);
        LongRef pos = new LongRef((cur_block.value * 128 + cur_rec.value) * rec_size.value);
        if (!Dos_files.DOS_SeekFile(fhandle.value, pos, 0)) {
            return 1;
        }
        IntRef toread = new IntRef(rec_size.value);
        if (!Dos_files.DOS_ReadFile(fhandle.value, Dos.dos_copybuf, toread)) {
            return 1;
        }
        if (toread.value == 0) {
            return 1;
        }
        if (toread.value < rec_size.value) {
            int i = toread.value;
            while (i < rec_size.value) {
                Dos.dos_copybuf[i++] = 0;
            }
        }
        Memory.MEM_BlockWrite(Memory.Real2Phys(Dos.dos.dta()) + recno * rec_size.value, Dos.dos_copybuf, rec_size.value);
        cur_rec.value = (short)(cur_rec.value + 1);
        if (cur_rec.value > 127) {
            ++cur_block.value;
            cur_rec.value = 0;
        }
        fcb.SetRecord(cur_block.value, cur_rec.value);
        if (toread.value == rec_size.value) {
            return 0;
        }
        if (toread.value == 0) {
            return 1;
        }
        return 3;
    }

    public static short DOS_FCBWrite(int seg, int offset, int recno) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        ShortRef fhandle = new ShortRef();
        ShortRef cur_rec = new ShortRef();
        IntRef cur_block = new IntRef(0);
        IntRef rec_size = new IntRef(0);
        fcb.GetSeqData(fhandle, rec_size);
        fcb.GetRecord(cur_block, cur_rec);
        LongRef pos = new LongRef((cur_block.value * 128 + cur_rec.value) * rec_size.value);
        if (!Dos_files.DOS_SeekFile(fhandle.value, pos, 0)) {
            return 1;
        }
        Memory.MEM_BlockRead(Memory.Real2Phys(Dos.dos.dta()) + recno * rec_size.value, Dos.dos_copybuf, rec_size.value);
        IntRef towrite = new IntRef(rec_size.value);
        if (!Dos_files.DOS_WriteFile(fhandle.value, Dos.dos_copybuf, towrite)) {
            return 1;
        }
        LongRef size = new LongRef(0L);
        IntRef date = new IntRef(0);
        IntRef time = new IntRef(0);
        fcb.GetSizeDateTime(size, date, time);
        if (pos.value + (long)towrite.value > size.value) {
            size.value = pos.value + (long)towrite.value;
        }
        date.value = Dos.DOS_PackDate(Dos.dos.date.year, Dos.dos.date.month, Dos.dos.date.day);
        long ticks = (long)Memory.mem_readd(1132) & 0xFFFFFFFFL;
        long seconds = ticks * 10L / 182L;
        int hour = (int)(seconds / 3600L);
        int min = (int)(seconds % 3600L / 60L);
        int sec = (int)(seconds % 60L);
        time.value = Dos.DOS_PackTime(hour, min, sec);
        short temp = (short)Dos.RealHandle(fhandle.value);
        Dos_files.Files[temp].time = time.value;
        Dos_files.Files[temp].date = date.value;
        fcb.SetSizeDateTime(size.value, date.value, time.value);
        cur_rec.value = (short)(cur_rec.value + 1);
        if (cur_rec.value > 127) {
            ++cur_block.value;
            cur_rec.value = 0;
        }
        fcb.SetRecord(cur_block.value, cur_rec.value);
        return 0;
    }

    public static short DOS_FCBIncreaseSize(int seg, int offset) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        ShortRef fhandle = new ShortRef();
        ShortRef cur_rec = new ShortRef();
        IntRef cur_block = new IntRef(0);
        IntRef rec_size = new IntRef(0);
        fcb.GetSeqData(fhandle, rec_size);
        fcb.GetRecord(cur_block, cur_rec);
        LongRef pos = new LongRef((cur_block.value * 128 + cur_rec.value) * rec_size.value);
        if (!Dos_files.DOS_SeekFile(fhandle.value, pos, 0)) {
            return 1;
        }
        IntRef towrite = new IntRef(0);
        if (!Dos_files.DOS_WriteFile(fhandle.value, Dos.dos_copybuf, towrite)) {
            return 1;
        }
        LongRef size = new LongRef(0L);
        IntRef date = new IntRef(0);
        IntRef time = new IntRef(0);
        fcb.GetSizeDateTime(size, date, time);
        if (pos.value + (long)towrite.value > size.value) {
            size.value = pos.value + (long)towrite.value;
        }
        date.value = Dos.DOS_PackDate(Dos.dos.date.year, Dos.dos.date.month, Dos.dos.date.day);
        long ticks = (long)Memory.mem_readd(1132) & 0xFFFFFFFFL;
        long seconds = ticks * 10L / 182L;
        int hour = (int)(seconds / 3600L);
        int min = (int)(seconds % 3600L / 60L);
        int sec = (int)(seconds % 60L);
        time.value = Dos.DOS_PackTime(hour, min, sec);
        short temp = (short)Dos.RealHandle(fhandle.value);
        Dos_files.Files[temp].time = time.value;
        Dos_files.Files[temp].date = date.value;
        fcb.SetSizeDateTime(size.value, date.value, time.value);
        fcb.SetRecord(cur_block.value, cur_rec.value);
        return 0;
    }

    public static short DOS_FCBRandomRead(int seg, int offset, int numRec, boolean restore) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        LongRef random = new LongRef(0L);
        IntRef old_block = new IntRef(0);
        ShortRef old_rec = new ShortRef(0);
        short error = 0;
        fcb.GetRandom(random);
        fcb.SetRecord((int)(random.value / 128L), (short)(random.value & 0x7FL));
        if (restore) {
            fcb.GetRecord(old_block, old_rec);
        }
        for (int i = 0; i < numRec && (error = Dos_files.DOS_FCBRead(seg, offset, i)) == 0; ++i) {
        }
        IntRef new_block = new IntRef(0);
        ShortRef new_rec = new ShortRef(0);
        fcb.GetRecord(new_block, new_rec);
        if (restore) {
            fcb.SetRecord(old_block.value, old_rec.value);
        }
        if (!restore) {
            fcb.SetRandom(new_block.value * 128 + new_rec.value);
        }
        return error;
    }

    public static short DOS_FCBRandomWrite(int seg, int offset, int numRec, boolean restore) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        LongRef random = new LongRef(0L);
        IntRef old_block = new IntRef(0);
        ShortRef old_rec = new ShortRef(0);
        short error = 0;
        fcb.GetRandom(random);
        fcb.SetRecord((int)(random.value / 128L), (short)(random.value & 0x7FL));
        if (restore) {
            fcb.GetRecord(old_block, old_rec);
        }
        if (numRec > 0) {
            for (int i = 0; i < numRec && (error = Dos_files.DOS_FCBWrite(seg, offset, i)) == 0; ++i) {
            }
        } else {
            Dos_files.DOS_FCBIncreaseSize(seg, offset);
        }
        IntRef new_block = new IntRef(0);
        ShortRef new_rec = new ShortRef(0);
        fcb.GetRecord(new_block, new_rec);
        if (restore) {
            fcb.SetRecord(old_block.value, old_rec.value);
        }
        if (!restore) {
            fcb.SetRandom(new_block.value * 128 + new_rec.value);
        }
        return error;
    }

    public static boolean DOS_FCBGetFileSize(int seg, int offset) {
        StringRef shortname = new StringRef();
        IntRef entry = new IntRef(0);
        ShortRef handle = new ShortRef();
        IntRef rec_size = new IntRef(0);
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        fcb.GetName(shortname);
        if (!Dos_files.DOS_OpenFile(shortname.value, 0, entry)) {
            return false;
        }
        handle.value = (short)Dos.RealHandle(entry.value);
        LongRef size = new LongRef(0L);
        Files[handle.value].Seek(size, 2);
        Dos_files.DOS_CloseFile(entry.value);
        fcb.GetSeqData(handle, rec_size);
        long random = size.value / (long)rec_size.value;
        if (size.value % (long)rec_size.value != 0L) {
            ++random;
        }
        fcb.SetRandom(random);
        return true;
    }

    public static boolean DOS_FCBDeleteFile(int seg, int offset) {
        int old_dta = Dos.dos.dta();
        Dos.dos.dta(Dos.dos.tables.tempdta_fcbdelete);
        Dos_FCB fcb = new Dos_FCB(Memory.RealSeg(Dos.dos.dta()), Memory.RealOff(Dos.dos.dta()));
        boolean nextfile = false;
        boolean return_value = false;
        nextfile = Dos_files.DOS_FCBFindFirst(seg, offset);
        while (nextfile) {
            StringRef shortname = new StringRef();
            fcb.GetName(shortname);
            boolean res = Dos_files.DOS_UnlinkFile(shortname.value);
            if (!return_value && res) {
                return_value = true;
            }
            nextfile = Dos_files.DOS_FCBFindNext(seg, offset);
        }
        Dos.dos.dta(old_dta);
        return return_value;
    }

    public static boolean DOS_FCBRenameFile(int seg, int offset) {
        Dos_FCB fcbold = new Dos_FCB(seg, offset);
        Dos_FCB fcbnew = new Dos_FCB(seg, offset + 16);
        StringRef oldname = new StringRef();
        StringRef newname = new StringRef();
        fcbold.GetName(oldname);
        fcbnew.GetName(newname);
        return Dos_files.DOS_Rename(oldname.value, newname.value);
    }

    public static void DOS_FCBSetRandomRecord(int seg, int offset) {
        Dos_FCB fcb = new Dos_FCB(seg, offset);
        IntRef block = new IntRef(0);
        ShortRef rec = new ShortRef();
        fcb.GetRecord(block, rec);
        fcb.SetRandom(block.value * 128 + rec.value);
    }

    public static boolean DOS_FileExists(String name) {
        StringRef fullname = new StringRef();
        ShortRef drive = new ShortRef();
        if (!Dos_files.DOS_MakeName(name, fullname, drive)) {
            return false;
        }
        return Drives[drive.value].FileExists(fullname.value);
    }

    public static boolean DOS_GetAllocationInfo(short drive, IntRef _bytes_sector, ShortRef _sectors_cluster, IntRef _total_clusters) {
        if ((drive = drive == 0 ? Dos_files.DOS_GetDefaultDrive() : (short)(drive - 1)) >= 26 || Drives[drive] == null) {
            return false;
        }
        IntRef _free_clusters = new IntRef(0);
        Drives[drive].AllocationInfo(_bytes_sector, _sectors_cluster, _total_clusters, _free_clusters);
        CPU_Regs.SegSet16DS(Memory.RealSeg(Dos.dos.tables.mediaid));
        CPU_Regs.reg_ebx.word(Memory.RealOff(Dos.dos.tables.mediaid + drive * 2));
        return true;
    }

    public static boolean DOS_SetDrive(short drive) {
        if (Drives[drive] != null) {
            Dos_files.DOS_SetDefaultDrive(drive);
            return true;
        }
        return false;
    }

    public static boolean DOS_GetFileDate(int entry, IntRef otime, IntRef odate) {
        int handle = Dos.RealHandle(entry);
        if (handle >= 127) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (Files[handle] == null || !Files[handle].IsOpen()) {
            Dos.DOS_SetError(6);
            return false;
        }
        if (!Files[handle].UpdateDateTimeFromHost()) {
            Dos.DOS_SetError(6);
            return false;
        }
        otime.value = Dos_files.Files[handle].time;
        odate.value = Dos_files.Files[handle].date;
        return true;
    }

    public static void DOS_SetupFiles() {
        int i;
        for (i = 0; i < 127; ++i) {
            Dos_files.Files[i] = null;
        }
        for (i = 0; i < 26; ++i) {
            Dos_files.Drives[i] = null;
        }
        Dos_files.Drives[25] = new Drive_virtual();
    }
}

