/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.Callback;
import jdos.dos.Dos;
import jdos.dos.Dos_MCB;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.util.IntRef;
import jdos.util.StringRef;

public class Dos_memory {
    public static final int MCB_FREE = 0;
    public static final int MCB_DOS = 8;
    private static final int UMB_START_SEG = 40959;
    private static int memAllocStrategy = 0;
    private static Callback.Handler DOS_default_handler = new Callback.Handler(){

        public String getName() {
            return "Dos_memory.DOS_default_handler";
        }

        public int call() {
            Log.log(8, 2, "DOS rerouted Interrupt Called " + Integer.toString(CPU.lastint, 16));
            return 0;
        }
    };
    private static Callback callbackhandler;

    private static void DOS_CompressMemory() {
        int mcb_segment = Dos.dos.firstMCB;
        Dos_MCB mcb = new Dos_MCB(mcb_segment);
        Dos_MCB mcb_next = new Dos_MCB(0);
        while (mcb.GetType() != 90) {
            mcb_next.SetPt(mcb_segment + mcb.GetSize() + 1);
            if (mcb.GetPSPSeg() == 0 && mcb_next.GetPSPSeg() == 0) {
                mcb.SetSize(mcb.GetSize() + mcb_next.GetSize() + 1);
                mcb.SetType(mcb_next.GetType());
                continue;
            }
            mcb.SetPt(mcb_segment += mcb.GetSize() + 1);
        }
    }

    public static void DOS_FreeProcessMemory(int pspseg) {
        int mcb_segment = Dos.dos.firstMCB;
        Dos_MCB mcb = new Dos_MCB(mcb_segment);
        while (true) {
            if (mcb.GetPSPSeg() == pspseg) {
                mcb.SetPSPSeg(0);
            }
            if (mcb.GetType() == 90) {
                if (Dosbox.machine != 3 || mcb_segment + mcb.GetSize() != 6142 || Memory.real_readb(6143, 0) != 77 || Memory.real_readw(6143, 1) != 8) break;
                mcb.SetType((short)77);
            }
            mcb.SetPt(mcb_segment += mcb.GetSize() + 1);
        }
        int umb_start = Dos.dos_infoblock.GetStartOfUMBChain();
        if (umb_start == 40959) {
            Dos_MCB umb_mcb = new Dos_MCB(umb_start);
            while (true) {
                if (umb_mcb.GetPSPSeg() == pspseg) {
                    umb_mcb.SetPSPSeg(0);
                }
                if (umb_mcb.GetType() == 77) {
                    umb_mcb.SetPt(umb_start += umb_mcb.GetSize() + 1);
                    continue;
                }
                break;
            }
        } else if (umb_start != 65535) {
            Log.log(14, 2, "Corrupt UMB chain: " + Integer.toString(umb_start, 16));
        }
        Dos_memory.DOS_CompressMemory();
    }

    public static int DOS_GetMemAllocStrategy() {
        return memAllocStrategy;
    }

    public static boolean DOS_SetMemAllocStrategy(int strat) {
        if ((strat & 0x3F) < 3) {
            memAllocStrategy = strat;
            return true;
        }
        return false;
    }

    public static boolean DOS_AllocateMemory(IntRef segment, IntRef blocks) {
        Dos_memory.DOS_CompressMemory();
        int bigsize = 0;
        int mem_strat = memAllocStrategy;
        int mcb_segment = Dos.dos.firstMCB;
        int umb_start = Dos.dos_infoblock.GetStartOfUMBChain();
        if (umb_start == 40959) {
            if ((mem_strat & 0xC0) != 0) {
                mcb_segment = umb_start;
            }
        } else if (umb_start != 65535) {
            Log.log(14, 2, "Corrupt UMB chain: " + Integer.toString(umb_start, 16));
        }
        Dos_MCB mcb = new Dos_MCB(0);
        Dos_MCB mcb_next = new Dos_MCB(0);
        Dos_MCB psp_mcb = new Dos_MCB(Dos.dos.psp() - 1);
        StringRef psp_name = new StringRef();
        psp_mcb.GetFileName(psp_name);
        int found_seg = 0;
        int found_seg_size = 0;
        while (true) {
            mcb.SetPt(mcb_segment);
            if (mcb.GetPSPSeg() == 0) {
                int block_size = mcb.GetSize();
                if (block_size < blocks.value) {
                    if (bigsize < block_size) {
                        bigsize = block_size;
                    }
                } else {
                    if (block_size == blocks.value && (mem_strat & 0x3F) < 2) {
                        mcb.SetPSPSeg(Dos.dos.psp());
                        segment.value = mcb_segment + 1;
                        return true;
                    }
                    switch (mem_strat & 0x3F) {
                        case 0: {
                            mcb_next.SetPt(mcb_segment + blocks.value + 1);
                            mcb_next.SetPSPSeg(0);
                            mcb_next.SetType(mcb.GetType());
                            mcb_next.SetSize(block_size - blocks.value - 1);
                            mcb.SetSize(blocks.value);
                            mcb.SetType((short)77);
                            mcb.SetPSPSeg(Dos.dos.psp());
                            mcb.SetFileName(psp_name.value);
                            segment.value = mcb_segment + 1;
                            return true;
                        }
                        case 1: {
                            if (found_seg_size != 0 && block_size >= found_seg_size) break;
                            found_seg = mcb_segment;
                            found_seg_size = block_size;
                            break;
                        }
                        default: {
                            found_seg = mcb_segment;
                            found_seg_size = block_size;
                        }
                    }
                }
            }
            if (mcb.GetType() == 90) {
                if ((mem_strat & 0x80) != 0 && umb_start == 40959) {
                    mcb_segment = Dos.dos.firstMCB;
                    mem_strat &= 0xFFFFFF3F;
                    continue;
                }
                if (found_seg != 0) {
                    if ((mem_strat & 0x3F) == 1) {
                        mcb.SetPt(found_seg);
                        mcb_next.SetPt(found_seg + blocks.value + 1);
                        mcb_next.SetPSPSeg(0);
                        mcb_next.SetType(mcb.GetType());
                        mcb_next.SetSize(found_seg_size - blocks.value - 1);
                        mcb.SetSize(blocks.value);
                        mcb.SetType((short)77);
                        mcb.SetPSPSeg(Dos.dos.psp());
                        mcb.SetFileName(psp_name.value);
                        segment.value = found_seg + 1;
                    } else {
                        mcb.SetPt(found_seg);
                        if (found_seg_size == blocks.value) {
                            mcb.SetPSPSeg(Dos.dos.psp());
                            mcb.SetFileName(psp_name.value);
                            segment.value = found_seg + 1;
                            return true;
                        }
                        segment.value = found_seg + 1 + found_seg_size - blocks.value;
                        mcb_next.SetPt(segment.value - 1);
                        mcb_next.SetSize(blocks.value);
                        mcb_next.SetType(mcb.GetType());
                        mcb_next.SetPSPSeg(Dos.dos.psp());
                        mcb_next.SetFileName(psp_name.value);
                        mcb.SetSize(found_seg_size - blocks.value - 1);
                        mcb.SetPSPSeg(0);
                        mcb.SetType((short)77);
                    }
                    return true;
                }
                blocks.value = bigsize;
                Dos.DOS_SetError(8);
                return false;
            }
            mcb_segment += mcb.GetSize() + 1;
        }
    }

    public static boolean DOS_ResizeMemory(int segment, IntRef blocks) {
        Dos_MCB mcb;
        if (segment < 368) {
            Log.log(14, 2, "Program resizes " + Integer.toString(segment, 16) + ", take care");
        }
        if ((mcb = new Dos_MCB(segment - 1)).GetType() != 77 && mcb.GetType() != 90) {
            Dos.DOS_SetError(7);
            return false;
        }
        Dos_memory.DOS_CompressMemory();
        int total = mcb.GetSize();
        Dos_MCB mcb_next = new Dos_MCB(segment + total);
        if (blocks.value <= total) {
            if (blocks.value == total) {
                return true;
            }
            Dos_MCB mcb_new_next = new Dos_MCB(segment + blocks.value);
            mcb.SetSize(blocks.value);
            mcb_new_next.SetType(mcb.GetType());
            if (mcb.GetType() == 90) {
                mcb.SetType((short)77);
            }
            mcb_new_next.SetSize(total - blocks.value - 1);
            mcb_new_next.SetPSPSeg(0);
            mcb.SetPSPSeg(Dos.dos.psp());
            return true;
        }
        if (mcb.GetType() != 90 && mcb_next.GetPSPSeg() == 0) {
            total += mcb_next.GetSize() + 1;
        }
        if (blocks.value < total) {
            if (mcb.GetType() != 90) {
                mcb.SetType(mcb_next.GetType());
            }
            mcb.SetSize(blocks.value);
            mcb_next.SetPt(segment + blocks.value);
            mcb_next.SetSize(total - blocks.value - 1);
            mcb_next.SetType(mcb.GetType());
            mcb_next.SetPSPSeg(0);
            mcb.SetType((short)77);
            mcb.SetPSPSeg(Dos.dos.psp());
            return true;
        }
        if (mcb_next.GetPSPSeg() == 0 && mcb.GetType() != 90) {
            mcb.SetType(mcb_next.GetType());
        }
        mcb.SetSize(total);
        mcb.SetPSPSeg(Dos.dos.psp());
        if (blocks.value == total) {
            return true;
        }
        blocks.value = total;
        Dos.DOS_SetError(8);
        return false;
    }

    public static boolean DOS_FreeMemory(int segment) {
        if (segment < 368) {
            Log.log(14, 2, "Program tried to free " + Integer.toString(segment, 16) + " ---ERROR");
            Dos.DOS_SetError(9);
            return false;
        }
        Dos_MCB mcb = new Dos_MCB(segment - 1);
        if (mcb.GetType() != 77 && mcb.GetType() != 90) {
            Dos.DOS_SetError(9);
            return false;
        }
        mcb.SetPSPSeg(0);
        return true;
    }

    public static void DOS_BuildUMBChain(boolean umb_active, boolean ems_active) {
        if (umb_active && Dosbox.machine != 2) {
            int first_umb_seg = 53248;
            int first_umb_size = 8192;
            if (ems_active || Dosbox.machine == 3) {
                first_umb_size = 4096;
            }
            Dos.dos_infoblock.SetStartOfUMBChain(40959);
            Dos.dos_infoblock.SetUMBChainState((short)0);
            Dos_MCB umb_mcb = new Dos_MCB(first_umb_seg);
            umb_mcb.SetPSPSeg(0);
            umb_mcb.SetSize(first_umb_size - 1);
            umb_mcb.SetType((short)90);
            int mcb_segment = Dos.dos.firstMCB;
            Dos_MCB mcb = new Dos_MCB(mcb_segment);
            while (mcb.GetType() != 90) {
                mcb.SetPt(mcb_segment += mcb.GetSize() + 1);
            }
            int cover_mcb = mcb_segment + mcb.GetSize() + 1;
            mcb.SetPt(cover_mcb);
            mcb.SetType((short)77);
            mcb.SetPSPSeg(8);
            mcb.SetSize(first_umb_seg - cover_mcb - 1);
            mcb.SetFileName("SC      ");
        } else {
            Dos.dos_infoblock.SetStartOfUMBChain(65535);
            Dos.dos_infoblock.SetUMBChainState((short)0);
        }
    }

    public static boolean DOS_LinkUMBsToMemChain(int linkstate) {
        int umb_start = Dos.dos_infoblock.GetStartOfUMBChain();
        if (umb_start != 40959) {
            if (umb_start != 65535) {
                Log.log(14, 2, "Corrupt UMB chain: " + Integer.toString(umb_start, 16));
            }
            return false;
        }
        if ((linkstate & 1) == (Dos.dos_infoblock.GetUMBChainState() & 1)) {
            return true;
        }
        int mcb_segment = Dos.dos.firstMCB;
        int prev_mcb_segment = Dos.dos.firstMCB;
        Dos_MCB mcb = new Dos_MCB(mcb_segment);
        while (mcb_segment != umb_start && mcb.GetType() != 90) {
            prev_mcb_segment = mcb_segment;
            mcb.SetPt(mcb_segment += mcb.GetSize() + 1);
        }
        Dos_MCB prev_mcb = new Dos_MCB(prev_mcb_segment);
        switch (linkstate) {
            case 0: {
                if (prev_mcb.GetType() == 77 && mcb_segment == umb_start) {
                    prev_mcb.SetType((short)90);
                }
                Dos.dos_infoblock.SetUMBChainState((short)0);
                break;
            }
            case 1: {
                if (mcb.GetType() != 90) break;
                mcb.SetType((short)77);
                Dos.dos_infoblock.SetUMBChainState((short)1);
                break;
            }
            default: {
                Log.log_msg("Invalid link state " + Integer.toString(linkstate, 16) + " when reconfiguring MCB chain");
                return false;
            }
        }
        return true;
    }

    public static void DOS_SetupMemory() {
        callbackhandler = new Callback();
        callbackhandler.Allocate(DOS_default_handler, "DOS default int");
        int ihseg = 112;
        int ihofs = 8;
        Memory.real_writeb(ihseg, ihofs + 0, 254);
        Memory.real_writeb(ihseg, ihofs + 1, 56);
        Memory.real_writew(ihseg, ihofs + 2, callbackhandler.Get_callback());
        Memory.real_writeb(ihseg, ihofs + 4, 207);
        Memory.RealSetVec(1, Memory.RealMake(ihseg, ihofs));
        Memory.RealSetVec(2, Memory.RealMake(ihseg, ihofs));
        Memory.RealSetVec(3, Memory.RealMake(ihseg, ihofs));
        Memory.RealSetVec(4, Memory.RealMake(ihseg, ihofs));
        Dos_MCB mcb_devicedummy = new Dos_MCB(367);
        mcb_devicedummy.SetPSPSeg(8);
        mcb_devicedummy.SetSize(1);
        mcb_devicedummy.SetType((short)77);
        int mcb_sizes = 2;
        Dos_MCB tempmcb = new Dos_MCB(367 + mcb_sizes);
        tempmcb.SetPSPSeg(0);
        tempmcb.SetSize(4);
        tempmcb.SetType((short)77);
        Dos_MCB tempmcb2 = new Dos_MCB(367 + (mcb_sizes += 5));
        tempmcb2.SetPSPSeg(64);
        tempmcb2.SetSize(16);
        tempmcb2.SetType((short)77);
        Dos_MCB mcb = new Dos_MCB(367 + (mcb_sizes += 17));
        mcb.SetPSPSeg(0);
        mcb.SetType((short)90);
        if (Dosbox.machine == 2) {
            mcb.SetSize(39568 - mcb_sizes);
        } else if (Dosbox.machine == 3) {
            mcb_devicedummy.SetPt(8192);
            mcb_devicedummy.SetPSPSeg(0);
            mcb_devicedummy.SetSize(Short.MAX_VALUE);
            mcb_devicedummy.SetType((short)90);
            mcb_devicedummy.SetPt(6143);
            mcb_devicedummy.SetPSPSeg(8);
            mcb_devicedummy.SetSize(2048);
            mcb_devicedummy.SetType((short)77);
            mcb.SetSize(5777 - (2 + mcb_sizes));
            mcb.SetType((short)77);
        } else {
            mcb.SetSize(40591 - mcb_sizes);
        }
        Dos.dos.firstMCB = 367;
        Dos.dos_infoblock.SetFirstMCB(367);
    }
}

