/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos;

import java.util.Vector;
import jdos.dos.Dos_Drive;
import jdos.dos.Dos_files;
import jdos.misc.Log;
import jdos.misc.setup.Section;

public class DriveManager {
    private static DriveInfo[] driveInfos = new DriveInfo[26];
    static int currentDrive;

    public static void AppendDisk(int drive, Dos_Drive disk) {
        DriveManager.driveInfos[drive].disks.add(disk);
    }

    public static void InitializeDrive(int drive) {
        currentDrive = drive;
        DriveInfo driveInfo = driveInfos[currentDrive];
        if (driveInfo.disks.size() > 0) {
            Dos_Drive disk;
            driveInfo.currentDisk = 0;
            Dos_files.Drives[DriveManager.currentDrive] = disk = (Dos_Drive)driveInfo.disks.elementAt(driveInfo.currentDisk);
            disk.Activate();
        }
    }

    public static int UnmountDrive(int drive) {
        int result = 0;
        if (DriveManager.driveInfos[drive].disks.size() == 0) {
            result = Dos_files.Drives[drive].UnMount();
        } else {
            int currentDisk = DriveManager.driveInfos[drive].currentDisk;
            result = ((Dos_Drive)DriveManager.driveInfos[drive].disks.elementAt(currentDisk)).UnMount();
            if (result == 0) {
                DriveManager.driveInfos[drive].disks.clear();
            }
        }
        return result;
    }

    public static void CycleAllDisks() {
        for (int idrive = 0; idrive < 26; ++idrive) {
            int numDisks = DriveManager.driveInfos[idrive].disks.size();
            if (numDisks <= 1) continue;
            int currentDisk = DriveManager.driveInfos[idrive].currentDisk;
            Dos_Drive oldDisk = (Dos_Drive)DriveManager.driveInfos[idrive].disks.elementAt(currentDisk);
            currentDisk = (currentDisk + 1) % numDisks;
            Dos_Drive newDisk = (Dos_Drive)DriveManager.driveInfos[idrive].disks.elementAt(currentDisk);
            DriveManager.driveInfos[idrive].currentDisk = currentDisk;
            newDisk.curdir = oldDisk.curdir;
            newDisk.Activate();
            Dos_files.Drives[idrive] = newDisk;
            Log.log_msg("Drive " + String.valueOf(65 + idrive) + ": disk " + String.valueOf(currentDisk + 1) + " of " + numDisks + " now active");
        }
    }

    public static void Init(Section sec) {
        currentDrive = 0;
        for (int i = 0; i < 26; ++i) {
            DriveManager.driveInfos[i] = new DriveInfo();
            DriveManager.driveInfos[i].currentDisk = 0;
        }
    }

    private static class DriveInfo {
        Vector disks = new Vector();
        int currentDisk;

        private DriveInfo() {
        }
    }
}

