/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos.drives;

import jdos.dos.CDROM_Interface_Image;
import jdos.dos.DOS_File;
import jdos.dos.Dos;
import jdos.dos.DosMSCDEX;
import jdos.dos.Dos_DTA;
import jdos.dos.Dos_Drive;
import jdos.dos.Drives;
import jdos.dos.FileStat_Block;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.Ptr;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class Drive_iso
extends Dos_Drive {
    private static final int ISO_MAX_HASH_TABLE_SIZE = 100;
    private static final int ISO_FRAMESIZE = 2048;
    private static final int ISO_ASSOCIATED = 4;
    private static final int ISO_DIRECTORY = 2;
    private static final int ISO_HIDDEN = 1;
    private static final int ISO_MAX_FILENAME_LENGTH = 37;
    private static final int ISO_MAXPATHNAME = 256;
    private static final int ISO_FIRST_VD = 16;
    private DirIterator[] dirIterators = new DirIterator[2048];
    private int nextFreeDirIterator = 0;
    private SectorHashEntry[] sectorHashEntries = new SectorHashEntry[100];
    private boolean dataCD;
    private isoDirEntry rootEntry = new isoDirEntry();
    private short mediaid;
    private String fileName;
    private short subUnit;
    private char driveLetter;
    private String discLabel;

    private static boolean IS_ASSOC(int fileFlags) {
        return (fileFlags & 4) != 0;
    }

    private static boolean IS_DIR(int fileFlags) {
        return (fileFlags & 2) != 0;
    }

    private static boolean IS_HIDDEN(int fileFlags) {
        return (fileFlags & 1) != 0;
    }

    public Drive_iso(char driveLetter, String fileName, short mediaid, IntRef error) {
        int i;
        this.fileName = fileName;
        ShortRef s = new ShortRef(this.subUnit);
        error.value = this.UpdateMscdex(driveLetter, fileName, s);
        this.subUnit = s.value;
        if (error.value == 0) {
            if (this.loadImage()) {
                this.info = "isoDrive " + fileName;
                this.driveLetter = driveLetter;
                this.mediaid = mediaid;
                StringRef buffer = new StringRef();
                if (!DosMSCDEX.MSCDEX_GetVolumeName(this.subUnit, buffer)) {
                    buffer.value = "";
                }
                StringRef d = new StringRef(this.discLabel);
                Drives.Set_Label(buffer.value, d, true);
                this.discLabel = d.value;
            } else if (!CDROM_Interface_Image.images[this.subUnit].HasDataTrack()) {
                this.info = "isoDrive " + fileName;
                this.driveLetter = driveLetter;
                this.mediaid = mediaid;
                StringRef d = new StringRef(this.discLabel);
                Drives.Set_Label("Audio_CD", d, true);
                this.discLabel = d.value;
            } else {
                error.value = 6;
            }
        }
        for (i = 0; i < this.dirIterators.length; ++i) {
            this.dirIterators[i] = new DirIterator();
        }
        for (i = 0; i < this.sectorHashEntries.length; ++i) {
            this.sectorHashEntries[i] = new SectorHashEntry();
        }
    }

    int UpdateMscdex(char driveLetter, String path, ShortRef subUnit) {
        if (DosMSCDEX.MSCDEX_HasDrive(driveLetter)) {
            CDROM_Interface_Image oldCdrom = CDROM_Interface_Image.images[subUnit.value];
            CDROM_Interface_Image cdrom = new CDROM_Interface_Image(subUnit.value);
            if (!cdrom.SetDevice(path, 0)) {
                CDROM_Interface_Image.images[subUnit.value] = oldCdrom;
                cdrom.close();
                return 3;
            }
            DosMSCDEX.MSCDEX_ReplaceDrive(cdrom, subUnit.value);
            return 0;
        }
        return DosMSCDEX.MSCDEX_AddDrive(driveLetter, path, subUnit);
    }

    public void Activate() {
        ShortRef s = new ShortRef(this.subUnit);
        this.UpdateMscdex(this.driveLetter, this.fileName, s);
        this.subUnit = s.value;
    }

    public DOS_File FileOpen(String name, int flags) {
        boolean success;
        if ((flags & 0xF) == 1) {
            Dos.DOS_SetError(5);
            return null;
        }
        isoDirEntry de = new isoDirEntry();
        boolean bl = success = this.lookup(de, name) && !Drive_iso.IS_DIR(de.fileFlags);
        if (success) {
            FileStat_Block file_stat = new FileStat_Block();
            file_stat.size = de.dataLengthL;
            file_stat.attr = 33;
            file_stat.date = Dos.DOS_PackDate(1900 + de.dateYear, de.dateMonth, de.dateDay);
            file_stat.time = Dos.DOS_PackTime(de.timeHour, de.timeMin, de.timeSec);
            isoFile file = new isoFile(this, name, file_stat, de.extentLocationL * 2048L);
            file.flags = flags;
            return file;
        }
        return null;
    }

    public DOS_File FileCreate(String name, int attributes) {
        Dos.DOS_SetError(5);
        return null;
    }

    public boolean FileUnlink(String _name) {
        Dos.DOS_SetError(5);
        return false;
    }

    public boolean RemoveDir(String _dir) {
        Dos.DOS_SetError(5);
        return false;
    }

    public boolean MakeDir(String _dir) {
        Dos.DOS_SetError(5);
        return false;
    }

    public boolean TestDir(String dir) {
        isoDirEntry de = new isoDirEntry();
        return this.lookup(de, dir) && Drive_iso.IS_DIR(de.fileFlags);
    }

    public boolean FindFirst(String dir, Dos_DTA dta, boolean fcb_findfirst) {
        boolean isRoot;
        isoDirEntry de = new isoDirEntry();
        if (!this.lookup(de, dir)) {
            Dos.DOS_SetError(3);
            return false;
        }
        int dirIterator = this.GetDirIterator(de);
        this.dirIterators[dirIterator].root = isRoot = dir.length() == 0;
        dta.SetDirID(dirIterator);
        ShortRef attr = new ShortRef();
        StringRef pattern = new StringRef();
        dta.GetSearchParams(attr, pattern);
        if (attr.value == 8) {
            if (this.discLabel.length() != 0) {
                dta.SetResult(this.discLabel, 0L, 0, 0, (short)8);
                return true;
            }
            Dos.DOS_SetError(18);
            return false;
        }
        if ((attr.value & 8) != 0 && isRoot && !fcb_findfirst && Drives.WildFileCmp(this.discLabel, pattern.value)) {
            dta.SetResult(this.discLabel, 0L, 0, 0, (short)8);
            return true;
        }
        return this.FindNext(dta);
    }

    public boolean FindNext(Dos_DTA dta) {
        ShortRef attr = new ShortRef(0);
        StringRef pattern = new StringRef();
        dta.GetSearchParams(attr, pattern);
        int dirIterator = dta.GetDirID();
        boolean isRoot = this.dirIterators[dirIterator].root;
        isoDirEntry de = new isoDirEntry();
        while (this.GetNextDirEntry(dirIterator, de)) {
            short findAttr = 0;
            findAttr = Drive_iso.IS_DIR(de.fileFlags) ? (short)((short)(findAttr | 0x10)) : (short)((short)(findAttr | 0x20));
            if (Drive_iso.IS_HIDDEN(de.fileFlags)) {
                findAttr = (short)(findAttr | 2);
            }
            String deident = StringHelper.toString(de.ident);
            if (Drive_iso.IS_ASSOC(de.fileFlags) || isRoot && de.ident[0] == 46 || !Drives.WildFileCmp(deident, pattern.value) || (~attr.value & findAttr & 0x16) != 0) continue;
            String findName = deident.toUpperCase();
            long findSize = de.dataLengthL;
            int findDate = Dos.DOS_PackDate(1900 + de.dateYear, de.dateMonth, de.dateDay);
            int findTime = Dos.DOS_PackTime(de.timeHour, de.timeMin, de.timeSec);
            dta.SetResult(findName, findSize, findDate, findTime, findAttr);
            return true;
        }
        this.FreeDirIterator(dirIterator);
        Dos.DOS_SetError(18);
        return false;
    }

    public boolean Rename(String oldname, String newname) {
        Dos.DOS_SetError(5);
        return false;
    }

    public boolean GetFileAttr(String name, IntRef attr) {
        attr.value = 0;
        isoDirEntry de = new isoDirEntry();
        boolean success = this.lookup(de, name);
        if (success) {
            attr.value = 33;
            if (Drive_iso.IS_HIDDEN(de.fileFlags)) {
                attr.value |= 2;
            }
            if (Drive_iso.IS_DIR(de.fileFlags)) {
                attr.value |= 0x10;
            }
        }
        return success;
    }

    public boolean AllocationInfo(IntRef bytes_sector, ShortRef sectors_cluster, IntRef total_clusters, IntRef free_clusters) {
        bytes_sector.value = 2048;
        sectors_cluster.value = 1;
        total_clusters.value = 60000;
        free_clusters.value = 0;
        return true;
    }

    public boolean FileExists(String name) {
        isoDirEntry de = new isoDirEntry();
        return this.lookup(de, name) && !Drive_iso.IS_DIR(de.fileFlags);
    }

    public boolean FileStat(String name, FileStat_Block stat_block) {
        isoDirEntry de = new isoDirEntry();
        boolean success = this.lookup(de, name);
        if (success) {
            stat_block.date = Dos.DOS_PackDate(1900 + de.dateYear, de.dateMonth, de.dateDay);
            stat_block.time = Dos.DOS_PackTime(de.timeHour, de.timeMin, de.timeSec);
            stat_block.size = de.dataLengthL;
            stat_block.attr = 33;
            if (Drive_iso.IS_DIR(de.fileFlags)) {
                stat_block.attr |= 0x10;
            }
        }
        return success;
    }

    public short GetMediaByte() {
        return this.mediaid;
    }

    public boolean isRemote() {
        return true;
    }

    public boolean isRemovable() {
        return true;
    }

    public int UnMount() {
        if (DosMSCDEX.MSCDEX_RemoveDrive(this.driveLetter) != 0) {
            return 0;
        }
        return 2;
    }

    private int GetDirIterator(isoDirEntry de) {
        int dirIterator = this.nextFreeDirIterator;
        this.dirIterators[dirIterator].currentSector = de.extentLocationL;
        this.dirIterators[dirIterator].endSector = de.extentLocationL + de.dataLengthL / 2048L - 1L;
        if (de.dataLengthL % 2048L != 0L) {
            ++this.dirIterators[dirIterator].endSector;
        }
        this.dirIterators[dirIterator].pos = 0L;
        this.dirIterators[dirIterator].valid = true;
        this.nextFreeDirIterator = (this.nextFreeDirIterator + 1) % 2048;
        return dirIterator;
    }

    private boolean GetNextDirEntry(int dirIteratorHandle, isoDirEntry de) {
        boolean result = false;
        byte[][] buffer = new byte[1][];
        DirIterator dirIterator = this.dirIterators[dirIteratorHandle];
        if (dirIterator.valid && this.ReadCachedSector(buffer, dirIterator.currentSector)) {
            int length;
            if (dirIterator.pos >= 2048L || buffer[0][(int)dirIterator.pos] == 0 || dirIterator.pos + (long)buffer[0][(int)dirIterator.pos] > 2048L) {
                if (dirIterator.currentSector < dirIterator.endSector) {
                    dirIterator.pos = 0L;
                    ++dirIterator.currentSector;
                    if (!this.ReadCachedSector(buffer, dirIterator.currentSector)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            result = (length = this.readDirEntry(de, buffer[0], (int)dirIterator.pos)) >= 0;
            dirIterator.pos += (long)length;
        }
        return result;
    }

    private void FreeDirIterator(int dirIterator) {
        this.dirIterators[dirIterator].valid = false;
        if ((dirIterator + 1) % 2048 == this.nextFreeDirIterator) {
            this.nextFreeDirIterator = this.nextFreeDirIterator > 0 ? --this.nextFreeDirIterator : 2047;
        }
    }

    private boolean ReadCachedSector(byte[][] buffer, long sector) {
        int pos = (int)sector % 100;
        SectorHashEntry he = this.sectorHashEntries[pos];
        if (!he.valid || he.sector != sector) {
            if (!CDROM_Interface_Image.images[this.subUnit].ReadSector(he.data, 0, false, (int)sector)) {
                return false;
            }
            he.valid = true;
            he.sector = sector;
        }
        buffer[0] = he.data;
        return true;
    }

    private boolean readSector(byte[] buffer, int sector) {
        return CDROM_Interface_Image.images[this.subUnit].ReadSector(buffer, 0, false, sector);
    }

    private int readDirEntry(isoDirEntry de, byte[] data, int offset) {
        de.load(data, offset, data[0]);
        if (de.extAttrLength != 0) {
            return -1;
        }
        if (de.fileUnitSize != 0 || de.interleaveGapSize != 0) {
            return -1;
        }
        if (de.length < 33 + de.fileIdentLength) {
            return -1;
        }
        if (Drive_iso.IS_DIR(de.fileFlags)) {
            if (de.fileIdentLength == 1 && de.ident[0] == 0) {
                StringHelper.strcpy(de.ident, ".");
            } else if (de.fileIdentLength == 1 && de.ident[0] == 1) {
                StringHelper.strcpy(de.ident, "..");
            } else {
                if (de.fileIdentLength > 200) {
                    return -1;
                }
                de.ident[de.fileIdentLength] = 0;
            }
        } else {
            if (de.fileIdentLength > 200) {
                return -1;
            }
            de.ident[de.fileIdentLength] = 0;
            StringHelper.strreplace(de.ident, ';', '\u0000');
            int tmp = StringHelper.strlen(de.ident);
            if (tmp > 0 && de.ident[tmp - 1] == 46) {
                de.ident[tmp - 1] = 0;
            }
        }
        int dotpos = StringHelper.toString(de.ident).indexOf(46);
        if (dotpos >= 0 && dotpos > 8) {
            StringHelper.strcpy(de.ident, 8, de.ident, dotpos);
        }
        if (StringHelper.strlen(de.ident) > 12) {
            de.ident[12] = 0;
        }
        return de.length;
    }

    boolean loadImage() {
        this.dataCD = false;
        byte[] b = new byte[8000];
        this.readSector(b, 16);
        if (b[0] != 1 || !StringHelper.toString(b, 1, 5).startsWith("CD001") || b[6] != 1) {
            return false;
        }
        if (this.readDirEntry(this.rootEntry, b, 156) > 0) {
            this.dataCD = true;
            return true;
        }
        return false;
    }

    boolean lookup(isoDirEntry de, String path) {
        if (!this.dataCD) {
            return false;
        }
        de.copy(this.rootEntry);
        if (path.length() == 0) {
            return true;
        }
        String[] isoPath = StringHelper.split(StringHelper.replace(path, "\\", "/"), "/");
        for (int i = 0; i < isoPath.length; ++i) {
            String name = isoPath[i];
            boolean found = false;
            if (Drive_iso.IS_DIR(de.fileFlags)) {
                int nameLength = name.length();
                if (nameLength > 0 && name.charAt(nameLength - 1) == '.') {
                    name = name.substring(0, nameLength - 1);
                }
                int dirIterator = this.GetDirIterator(de);
                while (!found && this.GetNextDirEntry(dirIterator, de)) {
                    if (Drive_iso.IS_ASSOC(de.fileFlags) || name.compareToIgnoreCase(StringHelper.toString(de.ident)) != 0) continue;
                    found = true;
                }
                this.FreeDirIterator(dirIterator);
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    class isoFile
    extends DOS_File {
        private Drive_iso drive;
        private byte[] buffer = new byte[2048];
        private int cachedSector;
        private long fileBegin;
        private long filePos;
        private long fileEnd;
        private int info;

        isoFile(Drive_iso drive, String name, FileStat_Block stat, long offset) {
            this.drive = drive;
            this.time = stat.time;
            this.date = stat.date;
            this.attr = stat.attr;
            this.filePos = this.fileBegin = offset;
            this.fileEnd = this.fileBegin + stat.size;
            this.cachedSector = -1;
            this.open = true;
            this.name = null;
            this.SetName(name);
        }

        public boolean Read(byte[] data, IntRef size) {
            if (this.filePos + (long)size.value > this.fileEnd) {
                size.value = (int)(this.fileEnd - this.filePos);
            }
            int nowSize = 0;
            int sector = (int)(this.filePos / 2048L);
            int sectorPos = (int)(this.filePos % 2048L);
            if (sector != this.cachedSector) {
                if (this.drive.readSector(this.buffer, sector)) {
                    this.cachedSector = sector;
                } else {
                    size.value = 0;
                    this.cachedSector = -1;
                }
            }
            while (nowSize < size.value) {
                int remSector = 2048 - sectorPos;
                int remSize = size.value - nowSize;
                if (remSector < remSize) {
                    System.arraycopy(this.buffer, sectorPos, data, nowSize, remSector);
                    nowSize += remSector;
                    sectorPos = 0;
                    ++this.cachedSector;
                    if (this.drive.readSector(this.buffer, ++sector)) continue;
                    size.value = nowSize;
                    this.cachedSector = -1;
                    continue;
                }
                System.arraycopy(this.buffer, sectorPos, data, nowSize, remSize);
                nowSize += remSize;
            }
            size.value = nowSize;
            this.filePos += (long)size.value;
            return true;
        }

        public boolean Write(byte[] data, IntRef size) {
            return false;
        }

        public boolean Seek(LongRef pos, int type) {
            int p = (int)(pos.value & 0xFFFFFFFFL);
            switch (type) {
                case 0: {
                    this.filePos = this.fileBegin + (long)p;
                    break;
                }
                case 1: {
                    this.filePos += (long)p;
                    break;
                }
                case 2: {
                    this.filePos = this.fileEnd + (long)p;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (this.filePos > this.fileEnd || this.filePos < this.fileBegin) {
                this.filePos = this.fileEnd;
            }
            pos.value = this.filePos - this.fileBegin;
            return true;
        }

        public boolean Close() {
            if (this.refCtr == 1) {
                this.open = false;
            }
            return true;
        }

        public int GetInformation() {
            return 64;
        }
    }

    private static class SectorHashEntry {
        boolean valid;
        long sector;
        byte[] data = new byte[2048];

        private SectorHashEntry() {
        }
    }

    private static class DirIterator {
        boolean valid;
        boolean root;
        long currentSector;
        long endSector;
        long pos;

        private DirIterator() {
        }
    }

    private static class isoDirEntry {
        short length;
        short extAttrLength;
        long extentLocationL;
        long extentLocationM;
        long dataLengthL;
        long dataLengthM;
        short dateYear;
        short dateMonth;
        short dateDay;
        short timeHour;
        short timeMin;
        short timeSec;
        short timeZone;
        short fileFlags;
        short fileUnitSize;
        short interleaveGapSize;
        int VolumeSeqNumberL;
        int VolumeSeqNumberM;
        short fileIdentLength;
        byte[] ident = new byte[222];

        private isoDirEntry() {
        }

        public void copy(isoDirEntry i) {
            this.length = i.length;
            this.extAttrLength = i.extAttrLength;
            this.extentLocationL = i.extentLocationL;
            this.extentLocationM = i.extentLocationM;
            this.dataLengthL = i.dataLengthL;
            this.dataLengthM = i.dataLengthM;
            this.dateYear = i.dateYear;
            this.dateMonth = i.dateMonth;
            this.dateDay = i.dateDay;
            this.timeHour = i.timeHour;
            this.timeMin = i.timeMin;
            this.timeSec = i.timeSec;
            this.timeZone = i.timeZone;
            this.fileFlags = i.fileFlags;
            this.fileUnitSize = i.fileUnitSize;
            this.interleaveGapSize = i.interleaveGapSize;
            this.VolumeSeqNumberL = i.VolumeSeqNumberL;
            this.VolumeSeqNumberM = i.VolumeSeqNumberM;
            this.fileIdentLength = i.fileIdentLength;
            System.arraycopy(i.ident, 0, this.ident, 0, this.ident.length);
        }

        public void load(byte[] data, int offset, int len) {
            Ptr p = new Ptr(data, offset);
            this.length = p.readb(0);
            p.inc(1);
            this.extAttrLength = p.readb(0);
            p.inc(1);
            this.extentLocationL = p.readd(0);
            p.inc(4);
            this.extentLocationM = p.readd(0);
            p.inc(4);
            this.dataLengthL = p.readd(0);
            p.inc(4);
            this.dataLengthM = p.readd(0);
            p.inc(4);
            this.dateYear = p.readb(0);
            p.inc(1);
            this.dateMonth = p.readb(0);
            p.inc(1);
            this.dateDay = p.readb(0);
            p.inc(1);
            this.timeHour = p.readb(0);
            p.inc(1);
            this.timeMin = p.readb(0);
            p.inc(1);
            this.timeSec = p.readb(0);
            p.inc(1);
            this.timeZone = p.readb(0);
            p.inc(1);
            this.fileFlags = p.readb(0);
            p.inc(1);
            this.fileUnitSize = p.readb(0);
            p.inc(1);
            this.interleaveGapSize = p.readb(0);
            p.inc(1);
            this.VolumeSeqNumberL = p.readw(0);
            p.inc(2);
            this.VolumeSeqNumberM = p.readw(0);
            p.inc(2);
            this.fileIdentLength = p.readb(0);
            p.inc(1);
            if (this.length > 33) {
                p.read(this.ident, this.length - 33);
            }
        }
    }
}

