/*
 * Decompiled with CFR 0.152.
 */
package jdos.dos.drives;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import jdos.dos.DOS_File;
import jdos.dos.Dos;
import jdos.dos.Dos_DTA;
import jdos.dos.Dos_Drive;
import jdos.dos.Dos_files;
import jdos.dos.Drives;
import jdos.dos.FileStat_Block;
import jdos.hardware.IoHandler;
import jdos.misc.Log;
import jdos.util.CalendarHelper;
import jdos.util.FileIO;
import jdos.util.FileIOFactory;
import jdos.util.IntRef;
import jdos.util.LongRef;
import jdos.util.ShortRef;
import jdos.util.StringHelper;
import jdos.util.StringRef;

public class Drive_local
extends Dos_Drive {
    public String basedir;
    SrchInfo[] srchInfo = new SrchInfo[2048];
    private Allocation allocation = new Allocation();

    public Drive_local(String startdir, int _bytes_sector, short _sectors_cluster, int _total_clusters, int _free_clusters, short _mediaid) {
        for (int i = 0; i < this.srchInfo.length; ++i) {
            this.srchInfo[i] = new SrchInfo();
        }
        this.basedir = startdir;
        this.basedir = StringHelper.replace(this.basedir, "/", File.separator);
        this.basedir = StringHelper.replace(this.basedir, "\\", File.separator);
        if (!this.basedir.endsWith(File.separator)) {
            this.basedir = this.basedir + File.separator;
        }
        this.info = "local directory " + startdir;
        this.allocation.bytes_sector = _bytes_sector;
        this.allocation.sectors_cluster = _sectors_cluster;
        this.allocation.total_clusters = _total_clusters;
        this.allocation.free_clusters = _free_clusters;
        this.allocation.mediaid = _mediaid;
        this.dirCache.SetBaseDir(this.basedir);
    }

    public DOS_File FileOpen(String name, int flags) {
        short i;
        int type;
        switch (flags & 0xF) {
            case 0: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            default: {
                Dos.DOS_SetError(12);
                return null;
            }
        }
        StringRef newname = new StringRef(this.basedir + name);
        this.dirCache.ExpandName(newname);
        short drive = 26;
        for (i = 0; i < 26; ++i) {
            if (Dos_files.Drives[i] != this) continue;
            drive = i;
            break;
        }
        for (i = 0; i < 127; ++i) {
            if (Dos_files.Files[i] == null || !Dos_files.Files[i].IsOpen() || Dos_files.Files[i].GetDrive() != drive || !Dos_files.Files[i].IsName(name) || !(Dos_files.Files[i] instanceof localFile)) continue;
            ((localFile)Dos_files.Files[i]).Flush();
        }
        try {
            FileIO raf = FileIOFactory.open(newname.value, type);
            localFile file = new localFile(name, raf);
            file.flags = flags;
            return file;
        }
        catch (FileNotFoundException e) {
            System.out.println("File Not Found: " + newname.value);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public DOS_File FileCreate(String name, int attributes) {
        String newname = this.basedir + name;
        String temp_name = this.dirCache.GetExpandName(newname);
        boolean existing_file = new File(temp_name).exists();
        try {
            FileIO hand = FileIOFactory.open(temp_name, 7);
            if (!existing_file) {
                this.dirCache.AddEntry(newname, true);
            }
            localFile file = new localFile(name, hand);
            file.flags = 2L;
            return file;
        }
        catch (Exception e) {
            Log.log_msg("Warning: file creation failed: " + newname);
            return null;
        }
    }

    public boolean FileUnlink(String name) {
        String newname = this.basedir + name;
        String fullname = this.dirCache.GetExpandName(newname);
        File f = new File(fullname);
        if (!f.delete()) {
            if (!f.exists()) {
                return false;
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                fis.close();
            }
            catch (Exception e) {
                return false;
            }
            boolean found_file = false;
            for (int i = 0; i < 127; ++i) {
                if (Dos_files.Files[i] == null || !Dos_files.Files[i].IsName(name)) continue;
                int max = 127;
                while (Dos_files.Files[i].IsOpen() && max-- != 0) {
                    Dos_files.Files[i].Close();
                    if (Dos_files.Files[i].RemoveRef() > 0) continue;
                }
                found_file = true;
            }
            if (!found_file) {
                return false;
            }
            if (f.delete()) {
                this.dirCache.DeleteEntry(newname);
                return true;
            }
            return false;
        }
        this.dirCache.DeleteEntry(newname);
        return true;
    }

    public boolean RemoveDir(String dir) {
        boolean temp;
        String newdir = this.basedir + dir;
        File f = new File(this.dirCache.GetExpandName(newdir));
        boolean bl = temp = f.isDirectory() && f.delete();
        if (temp) {
            this.dirCache.DeleteEntry(newdir, true);
        }
        return temp;
    }

    public boolean MakeDir(String dir) {
        boolean temp;
        String newdir = this.basedir + dir;
        File f = new File(this.dirCache.GetExpandName(newdir));
        boolean bl = temp = !f.exists() && f.mkdir();
        if (temp) {
            this.dirCache.CacheOut(newdir, true);
        }
        return temp;
    }

    public boolean TestDir(String dir) {
        StringRef newdir = new StringRef(this.basedir + dir);
        this.dirCache.ExpandName(newdir);
        File f = new File(newdir.value);
        if (!newdir.value.endsWith("\\")) {
            return f.exists() && f.isDirectory();
        }
        return f.exists();
    }

    public boolean FindFirst(String dir, Dos_DTA dta, boolean fcb_findfirst) {
        IntRef id;
        StringRef tempDir = new StringRef(this.basedir + dir);
        if (this.allocation.mediaid == 240) {
            this.EmptyCache();
        }
        if (!tempDir.value.endsWith(File.separator)) {
            tempDir.value = tempDir.value + File.separator;
        }
        if (!this.dirCache.FindFirst(tempDir.value, id = new IntRef(0))) {
            Dos.DOS_SetError(3);
            return false;
        }
        this.srchInfo[id.value].srch_dir = tempDir.value;
        dta.SetDirID(id.value);
        ShortRef sAttr = new ShortRef();
        dta.GetSearchParams(sAttr, tempDir);
        if (this.isRemote() && this.isRemovable()) {
            if (sAttr.value == 8) {
                dta.SetResult(this.dirCache.GetLabel(), 0L, 0, 0, (short)8);
                return true;
            }
        } else {
            if (sAttr.value == 8) {
                if (this.dirCache.GetLabel().length() == 0) {
                    Dos.DOS_SetError(18);
                    return false;
                }
                dta.SetResult(this.dirCache.GetLabel(), 0L, 0, 0, (short)8);
                return true;
            }
            if ((sAttr.value & 8) != 0 && dir.length() == 0 && !fcb_findfirst && Drives.WildFileCmp(this.dirCache.GetLabel(), tempDir.value)) {
                dta.SetResult(this.dirCache.GetLabel(), 0L, 0, 0, (short)8);
                return true;
            }
        }
        return this.FindNext(dta);
    }

    public boolean FindNext(Dos_DTA dta) {
        int find_attr;
        String dir_entcopy;
        StringRef dir_ent = new StringRef();
        ShortRef srch_attr = new ShortRef();
        StringRef srch_pattern = new StringRef();
        dta.GetSearchParams(srch_attr, srch_pattern);
        int id = dta.GetDirID();
        File f = null;
        while (true) {
            if (!this.dirCache.FindNext(id, dir_ent)) {
                Dos.DOS_SetError(18);
                return false;
            }
            if (!Drives.WildFileCmp(dir_ent.value, srch_pattern.value)) continue;
            String full_name = this.srchInfo[id].srch_dir + dir_ent.value;
            dir_entcopy = dir_ent.value;
            f = new File(this.dirCache.GetExpandName(full_name));
            if (f.exists() && (~srch_attr.value & (find_attr = f.isDirectory() ? 16 : 32) & 0x16) == 0) break;
        }
        String find_name = dir_entcopy.toUpperCase();
        int find_date = CalendarHelper.Dos_date(f.lastModified());
        int find_time = CalendarHelper.Dos_time(f.lastModified());
        long find_size = f.length();
        dta.SetResult(find_name, find_size, find_date, find_time, (short)find_attr);
        return true;
    }

    public boolean GetFileAttr(String name, IntRef attr) {
        StringRef newname = new StringRef(this.basedir + name);
        this.dirCache.ExpandName(newname);
        File f = new File(newname.value);
        if (f.exists()) {
            attr.value = 32;
            if (f.isDirectory()) {
                attr.value |= 0x10;
            }
            return true;
        }
        attr.value = 0;
        return false;
    }

    public boolean Rename(String oldname, String newname) {
        StringRef newold = new StringRef(this.basedir + oldname);
        this.dirCache.ExpandName(newold);
        StringRef newnew = new StringRef(this.basedir + newname);
        this.dirCache.ExpandName(newnew);
        File fold = new File(newold.value);
        File fnew = new File(newnew.value);
        boolean temp = fold.renameTo(fnew);
        if (temp) {
            this.dirCache.CacheOut(newnew.value);
        }
        return temp;
    }

    public boolean AllocationInfo(IntRef _bytes_sector, ShortRef _sectors_cluster, IntRef _total_clusters, IntRef _free_clusters) {
        _bytes_sector.value = this.allocation.bytes_sector;
        _sectors_cluster.value = this.allocation.sectors_cluster;
        _total_clusters.value = this.allocation.total_clusters;
        _free_clusters.value = this.allocation.free_clusters;
        return true;
    }

    public boolean FileExists(String name) {
        StringRef newname = new StringRef(this.basedir + name);
        this.dirCache.ExpandName(newname);
        try {
            FileIO raf = FileIOFactory.open(newname.value, 1);
            raf.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean FileStat(String name, FileStat_Block stat_block) {
        StringRef newname = new StringRef(this.basedir + name);
        this.dirCache.ExpandName(newname);
        File f = new File(newname.value);
        if (!f.exists()) {
            return false;
        }
        stat_block.time = CalendarHelper.Dos_time(f.lastModified());
        stat_block.date = CalendarHelper.Dos_date(f.lastModified());
        stat_block.size = f.length();
        return true;
    }

    public short GetMediaByte() {
        return this.allocation.mediaid;
    }

    public boolean isRemote() {
        return false;
    }

    public boolean isRemovable() {
        return false;
    }

    public int UnMount() {
        return 0;
    }

    public FileIO GetSystemFilePtr(String name, String type) {
        StringRef newname = new StringRef(this.basedir + name);
        this.dirCache.ExpandName(newname);
        int mode = 1;
        if (type.indexOf(43) >= 0) {
            mode |= 2;
        }
        try {
            return FileIOFactory.open(newname.value, mode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean GetSystemFilename(StringRef sysName, String dosName) {
        sysName.value = this.basedir + dosName;
        this.dirCache.ExpandName(sysName);
        return true;
    }

    private static class Allocation {
        int bytes_sector;
        short sectors_cluster;
        int total_clusters;
        int free_clusters;
        short mediaid;

        private Allocation() {
        }
    }

    private static class SrchInfo {
        String srch_dir;

        private SrchInfo() {
        }
    }

    protected static class localFile
    extends DOS_File {
        private FileIO fhandle;
        private boolean read_only_medium;
        private int last_action;

        public localFile(String name, FileIO handle) {
            this.fhandle = handle;
            this.open = true;
            this.UpdateDateTimeFromHost();
            this.attr = 32;
            this.last_action = 0;
            this.read_only_medium = false;
            this.SetName(name);
        }

        public boolean Read(byte[] data, IntRef size) {
            short mask;
            if ((this.flags & 0xFL) == 1L) {
                Dos.DOS_SetError(5);
                return false;
            }
            this.last_action = 1;
            try {
                size.value = this.fhandle.read(data, 0, size.value);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (size.value == -1) {
                size.value = 0;
            }
            if (((mask = IoHandler.IO_Read(33)) & 4) != 0) {
                IoHandler.IO_Write(33, mask & 0xFB);
            }
            return true;
        }

        public boolean Write(byte[] data, IntRef size) {
            if ((this.flags & 0xFL) == 0L) {
                Dos.DOS_SetError(5);
                return false;
            }
            this.last_action = 2;
            if (size.value == 0) {
                try {
                    this.fhandle.setLength(this.fhandle.getFilePointer());
                }
                catch (Exception e) {}
            } else {
                try {
                    this.fhandle.write(data, 0, size.value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        public boolean Seek(LongRef pos, int type) {
            int p = (int)(pos.value & 0xFFFFFFFFL);
            try {
                switch (type) {
                    case 0: {
                        this.fhandle.seek(p);
                        break;
                    }
                    case 1: {
                        this.fhandle.seek((long)p + this.fhandle.getFilePointer());
                        break;
                    }
                    case 2: {
                        this.fhandle.seek(this.fhandle.length() + (long)p);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                pos.value = this.fhandle.getFilePointer();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.last_action = 0;
            return true;
        }

        public boolean Close() {
            if (this.refCtr == 1) {
                if (this.fhandle != null) {
                    try {
                        this.fhandle.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.fhandle = null;
                this.open = false;
            }
            return true;
        }

        public int GetInformation() {
            return this.read_only_medium ? 64 : 0;
        }

        public boolean UpdateDateTimeFromHost() {
            if (!this.open) {
                return false;
            }
            long dt = this.fhandle.lastModified();
            this.time = CalendarHelper.Dos_time(dt);
            this.date = CalendarHelper.Dos_date(dt);
            return true;
        }

        public void Flush() {
            if (this.last_action == 2) {
                this.last_action = 0;
            }
        }

        public void FlagReadOnlyMedium() {
            this.read_only_medium = true;
        }

        private static final class Last_action {
            public static final int NONE = 0;
            public static final int READ = 1;
            public static final int WRITE = 2;

            private Last_action() {
            }
        }
    }
}

