/*
 * Decompiled with CFR 0.152.
 */
package jdos.fpu;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.debug.Debug;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.util.MicroDouble;

public class FPU {
    private static final int TAG_Valid = 0;
    private static final int TAG_Zero = 1;
    private static final int TAG_Weird = 2;
    private static final int TAG_Empty = 3;
    public static final int ROUND_Nearest = 0;
    public static final int ROUND_Down = 1;
    public static final int ROUND_Up = 2;
    public static final int ROUND_Chop = 3;
    public static final long PI = 4614256656552045848L;
    public static final long L2E = 4609176140021203710L;
    public static final long L2T = MicroDouble.parseDouble("3.3219280948873623");
    public static final long LN2 = 4604418534313441775L;
    public static final long LG2 = MicroDouble.parseDouble("0.3010299956639812");
    private static final int BIAS80 = 16383;
    private static final int BIAS64 = 1023;
    public static FPU_rec fpu = new FPU_rec();
    public static Section.SectionFunction FPU_Init = new Section.SectionFunction(){

        public void call(Section section) {
            FPU.FPU_FINIT();
        }
    };

    public static void log() {
        Debug.log_long(15, FPU.fpu.regs[0].ll());
        Debug.log_long(16, FPU.fpu.regs[1].ll());
        Debug.log_long(17, FPU.fpu.regs[2].ll());
        Debug.log_long(18, FPU.fpu.regs[3].ll());
        Debug.log_long(19, FPU.fpu.regs[4].ll());
        Debug.log_long(20, FPU.fpu.regs[5].ll());
        Debug.log_long(21, FPU.fpu.regs[6].ll());
        Debug.log_long(22, FPU.fpu.regs[7].ll());
        Debug.log_long(23, FPU.fpu.regs[8].ll());
        Debug.log(24, FPU.fpu.cw);
        Debug.log(25, FPU.fpu.cw_mask_all);
        Debug.log(26, FPU.fpu.sw);
        Debug.log(27, FPU.fpu.top);
        Debug.log(28, FPU.fpu.round);
    }

    private static int STV(int i) {
        return FPU.fpu.top + i & 7;
    }

    private static void FPU_SetTag(int tag) {
        for (int i = 0; i < 8; ++i) {
            FPU.fpu.tags[i] = tag >> 2 * i & 3;
        }
    }

    private static void FPU_SetCW(int word) {
        FPU.fpu.cw = word;
        FPU.fpu.cw_mask_all = word | 0x3F;
        FPU.fpu.round = word >>> 10 & 3;
    }

    private static int FPU_GET_TOP() {
        return (FPU.fpu.sw & 0x3800) >> 11;
    }

    private static void FPU_SET_TOP(int val) {
        FPU.fpu.sw &= 0xFFFFC7FF;
        FPU.fpu.sw |= (val & 7) << 11;
    }

    private static void FPU_SET_C0(int C) {
        FPU.fpu.sw &= 0xFFFFFEFF;
        if (C != 0) {
            FPU.fpu.sw |= 0x100;
        }
    }

    private static void FPU_SET_C1(int C) {
        FPU.fpu.sw &= 0xFFFFFDFF;
        if (C != 0) {
            FPU.fpu.sw |= 0x200;
        }
    }

    private static void FPU_SET_C2(int C) {
        FPU.fpu.sw &= 0xFFFFFBFF;
        if (C != 0) {
            FPU.fpu.sw |= 0x400;
        }
    }

    private static void FPU_SET_C3(int C) {
        FPU.fpu.sw &= 0xFFFFBFFF;
        if (C != 0) {
            FPU.fpu.sw |= 0x4000;
        }
    }

    private static void FPU_FINIT() {
        FPU.FPU_SetCW(895);
        FPU.fpu.sw = 0;
        FPU.fpu.top = FPU.FPU_GET_TOP();
        FPU.fpu.tags[0] = 3;
        FPU.fpu.tags[1] = 3;
        FPU.fpu.tags[2] = 3;
        FPU.fpu.tags[3] = 3;
        FPU.fpu.tags[4] = 3;
        FPU.fpu.tags[5] = 3;
        FPU.fpu.tags[6] = 3;
        FPU.fpu.tags[7] = 3;
        FPU.fpu.tags[8] = 0;
    }

    private static void FPU_FCLEX() {
        FPU.fpu.sw &= 0x7F00;
    }

    private static void FPU_FNOP() {
    }

    private static void FPU_PUSH(long in) {
        FPU.fpu.top = FPU.fpu.top - 1 & 7;
        FPU.fpu.tags[FPU.fpu.top] = 0;
        FPU.fpu.regs[FPU.fpu.top].d = in;
    }

    private static void FPU_PREP_PUSH() {
        FPU.fpu.top = FPU.fpu.top - 1 & 7;
        FPU.fpu.tags[FPU.fpu.top] = 0;
    }

    private static void FPU_FPOP() {
        FPU.fpu.tags[FPU.fpu.top] = 3;
        FPU.fpu.top = FPU.fpu.top + 1 & 7;
    }

    private static long FROUND(long in) {
        switch (FPU.fpu.round) {
            case 0: {
                long floor = MicroDouble.floor(in);
                long diff = MicroDouble.sub(in, floor);
                if (MicroDouble.gt(diff, 4602678819172646912L)) {
                    return MicroDouble.ceil(in);
                }
                if (MicroDouble.lt(diff, 4602678819172646912L)) {
                    return floor;
                }
                return (MicroDouble.longValue(floor) & 1L) != 0L ? MicroDouble.ceil(in) : floor;
            }
            case 1: {
                return MicroDouble.floor(in);
            }
            case 2: {
                return MicroDouble.ceil(in);
            }
            case 3: {
                return MicroDouble.truncate(in);
            }
        }
        return in;
    }

    private static long FPU_FLD80(int addr) {
        Test test = new Test();
        test.eind.ll(Memory.mem_readd(addr), Memory.mem_readd(addr + 4));
        test.begin = (short)Memory.mem_readw(addr + 8);
        long exp64 = (test.begin & Short.MAX_VALUE) - 16383;
        long blah = (exp64 > 0L ? exp64 : -exp64) & 0x3FFL;
        long exp64final = (exp64 > 0L ? blah : -blah) + 1023L;
        long mant64 = test.eind.ll() + 1023L >>> 11 & 0xFFFFFFFFFFFFFL;
        long sign = (test.begin & 0x8000) != 0 ? 1L : 0L;
        FPU_Reg result = new FPU_Reg();
        result.ll(sign << 63 | exp64final << 52 | mant64);
        if (test.eind.ll() == Long.MIN_VALUE && (test.begin & Short.MAX_VALUE) == Short.MAX_VALUE) {
            result.d = sign != 0L ? -4503599627370496L : 0x7FF0000000000000L;
        }
        return result.d;
    }

    private static void FPU_ST80(int addr, int reg) {
        Test test = new Test();
        long sign80 = (FPU.fpu.regs[reg].ll() & Long.MIN_VALUE) != 0L ? 1L : 0L;
        long exp80 = FPU.fpu.regs[reg].ll() & 0x7FF0000000000000L;
        long exp80final = exp80 >> 52;
        long mant80 = FPU.fpu.regs[reg].ll() & 0xFFFFFFFFFFFFFL;
        long mant80final = mant80 << 11;
        if (FPU.fpu.regs[reg].d != 0L) {
            mant80final |= Long.MIN_VALUE;
            exp80final += 15360L;
        }
        test.begin = (short)((short)sign80 << 15 | (short)exp80final);
        test.eind.ll(mant80final);
        Memory.mem_writed(addr, test.eind.l.lower());
        Memory.mem_writed(addr + 4, test.eind.l.upper());
        Memory.mem_writew(addr + 8, test.begin);
    }

    private static void FPU_FLD_F32(int addr, int store_to) {
        FPU.fpu.regs[store_to].d = MicroDouble.floatToDouble(Memory.mem_readd(addr));
    }

    private static void FPU_FLD_F64(int addr, int store_to) {
        FPU.fpu.regs[store_to].ll(Memory.mem_readd(addr), Memory.mem_readd(addr + 4));
    }

    private static void FPU_FLD_F80(int addr) {
        FPU.fpu.regs[FPU.fpu.top].d = FPU.FPU_FLD80(addr);
    }

    private static void FPU_FLD_I16(int addr, int store_to) {
        FPU.fpu.regs[store_to].d = MicroDouble.intToDouble((short)Memory.mem_readw(addr));
    }

    private static void FPU_FLD_I32(int addr, int store_to) {
        FPU.fpu.regs[store_to].d = MicroDouble.intToDouble(Memory.mem_readd(addr));
    }

    private static void FPU_FLD_I64(int addr, int store_to) {
        FPU_Reg blah = new FPU_Reg();
        blah.ll(Memory.mem_readd(addr), Memory.mem_readd(addr + 4));
        FPU.fpu.regs[store_to].d = MicroDouble.longToDouble(blah.ll());
    }

    private static void FPU_FBLD(int addr, int store_to) {
        long val = 0L;
        short in = 0;
        long base = 1L;
        for (int i = 0; i < 9; ++i) {
            in = Memory.mem_readb(addr + i);
            val += (long)(in & 0xF) * base;
            val += (long)(in >> 4 & 0xF) * (base *= 10L);
            base *= 10L;
        }
        long temp = MicroDouble.longToDouble(val);
        in = Memory.mem_readb(addr + 9);
        temp = MicroDouble.add(temp, MicroDouble.longToDouble((long)(in & 0xF) * base));
        if ((in & 0x80) != 0) {
            temp = MicroDouble.negate(temp);
        }
        FPU.fpu.regs[store_to].d = temp;
    }

    private static void FPU_FLD_F32_EA(int addr) {
        FPU.FPU_FLD_F32(addr, 8);
    }

    private static void FPU_FLD_F64_EA(int addr) {
        FPU.FPU_FLD_F64(addr, 8);
    }

    private static void FPU_FLD_I32_EA(int addr) {
        FPU.FPU_FLD_I32(addr, 8);
    }

    private static void FPU_FLD_I16_EA(int addr) {
        FPU.FPU_FLD_I16(addr, 8);
    }

    private static void FPU_FST_F32(int addr) {
        Memory.mem_writed(addr, MicroDouble.floatValue(FPU.fpu.regs[FPU.fpu.top].d));
    }

    private static void FPU_FST_F64(int addr) {
        Memory.mem_writed(addr, FPU.fpu.regs[FPU.fpu.top].l.lower());
        Memory.mem_writed(addr + 4, FPU.fpu.regs[FPU.fpu.top].l.upper());
    }

    private static void FPU_FST_F80(int addr) {
        FPU.FPU_ST80(addr, FPU.fpu.top);
    }

    private static void FPU_FST_I16(int addr) {
        Memory.mem_writew(addr, MicroDouble.shortValue(FPU.FROUND(FPU.fpu.regs[FPU.fpu.top].d)));
    }

    private static void FPU_FST_I32(int addr) {
        Memory.mem_writed(addr, MicroDouble.intValue(FPU.FROUND(FPU.fpu.regs[FPU.fpu.top].d)));
    }

    private static void FPU_FST_I64(int addr) {
        FPU_Reg blah = new FPU_Reg();
        blah.ll(MicroDouble.longValue(FPU.FROUND(FPU.fpu.regs[FPU.fpu.top].d)));
        Memory.mem_writed(addr, blah.l.lower());
        Memory.mem_writed(addr + 4, blah.l.upper());
    }

    private static void FPU_FBST(int addr) {
        String val = String.valueOf(MicroDouble.longValue(FPU.fpu.regs[FPU.fpu.top].d));
        boolean sign = false;
        if (val.startsWith("-")) {
            sign = true;
            val = val.substring(1);
        }
        while (val.length() < 19) {
            val = "0" + val;
        }
        for (int i = 0; i < 9; ++i) {
            short p = (short)(val.charAt(i * 2) - 48 | val.charAt(i * 2 + 1) - 48 << 4);
            Memory.mem_writeb(addr + i, p);
        }
        short p = (short)(val.charAt(18) - 48);
        if (sign) {
            p = (short)(p | 0x80);
        }
        Memory.mem_writeb(addr + 9, p);
    }

    private static void FPU_FADD(int op1, int op2) {
        FPU.fpu.regs[op1].d = MicroDouble.add(FPU.fpu.regs[op1].d, FPU.fpu.regs[op2].d);
    }

    private static void FPU_FSIN() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.sin(FPU.fpu.regs[FPU.fpu.top].d);
        FPU.FPU_SET_C2(0);
    }

    private static void FPU_FSINCOS() {
        long temp = FPU.fpu.regs[FPU.fpu.top].d;
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.sin(temp);
        FPU.FPU_PUSH(MicroDouble.cos(temp));
        FPU.FPU_SET_C2(0);
    }

    private static void FPU_FCOS() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.cos(FPU.fpu.regs[FPU.fpu.top].d);
        FPU.FPU_SET_C2(0);
    }

    private static void FPU_FSQRT() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.sqrt(FPU.fpu.regs[FPU.fpu.top].d);
    }

    private static void FPU_FPATAN() {
        FPU.fpu.regs[FPU.STV((int)1)].d = MicroDouble.atan(MicroDouble.div(FPU.fpu.regs[FPU.STV((int)1)].d, FPU.fpu.regs[FPU.fpu.top].d));
        FPU.FPU_FPOP();
    }

    private static void FPU_FPTAN() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.tan(FPU.fpu.regs[FPU.fpu.top].d);
        FPU.FPU_PUSH(0x3FF0000000000000L);
        FPU.FPU_SET_C2(0);
    }

    private static void FPU_FDIV(int st, int other) {
        FPU.fpu.regs[st].d = MicroDouble.div(FPU.fpu.regs[st].d, FPU.fpu.regs[other].d);
    }

    private static void FPU_FDIVR(int st, int other) {
        FPU.fpu.regs[st].d = MicroDouble.div(FPU.fpu.regs[other].d, FPU.fpu.regs[st].d);
    }

    private static void FPU_FMUL(int st, int other) {
        FPU.fpu.regs[st].d = MicroDouble.mul(FPU.fpu.regs[st].d, FPU.fpu.regs[other].d);
    }

    private static void FPU_FSUB(int st, int other) {
        FPU.fpu.regs[st].d = MicroDouble.sub(FPU.fpu.regs[st].d, FPU.fpu.regs[other].d);
    }

    private static void FPU_FSUBR(int st, int other) {
        FPU.fpu.regs[st].d = MicroDouble.sub(FPU.fpu.regs[other].d, FPU.fpu.regs[st].d);
    }

    private static void FPU_FXCH(int st, int other) {
        int tag = FPU.fpu.tags[other];
        long reg = FPU.fpu.regs[other].d;
        FPU.fpu.tags[other] = FPU.fpu.tags[st];
        FPU.fpu.regs[other].d = FPU.fpu.regs[st].d;
        FPU.fpu.tags[st] = tag;
        FPU.fpu.regs[st].d = reg;
    }

    private static void FPU_FST(int st, int other) {
        FPU.fpu.tags[other] = FPU.fpu.tags[st];
        FPU.fpu.regs[other].d = FPU.fpu.regs[st].d;
    }

    private static void FPU_FCOM(int st, int other) {
        if (FPU.fpu.tags[st] != 0 && FPU.fpu.tags[st] != 1 || FPU.fpu.tags[other] != 0 && FPU.fpu.tags[other] != 1) {
            FPU.FPU_SET_C3(1);
            FPU.FPU_SET_C2(1);
            FPU.FPU_SET_C0(1);
            return;
        }
        if (MicroDouble.eq(FPU.fpu.regs[st].d, FPU.fpu.regs[other].d)) {
            FPU.FPU_SET_C3(1);
            FPU.FPU_SET_C2(0);
            FPU.FPU_SET_C0(0);
            return;
        }
        if (MicroDouble.lt(FPU.fpu.regs[st].d, FPU.fpu.regs[other].d)) {
            FPU.FPU_SET_C3(0);
            FPU.FPU_SET_C2(0);
            FPU.FPU_SET_C0(1);
            return;
        }
        FPU.FPU_SET_C3(0);
        FPU.FPU_SET_C2(0);
        FPU.FPU_SET_C0(0);
    }

    private static void FPU_FUCOM(int st, int other) {
        FPU.FPU_FCOM(st, other);
    }

    private static void FPU_FRNDINT() {
        FPU.fpu.regs[FPU.fpu.top].d = FPU.FROUND(FPU.fpu.regs[FPU.fpu.top].d);
    }

    private static void FPU_FPREM() {
        long valtop = FPU.fpu.regs[FPU.fpu.top].d;
        long valdiv = FPU.fpu.regs[FPU.STV((int)1)].d;
        long ressaved = MicroDouble.floor(MicroDouble.div(valtop, valdiv));
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.sub(valtop, MicroDouble.mul(ressaved, valdiv));
        ressaved = MicroDouble.longValue(ressaved);
        FPU.FPU_SET_C0((int)(ressaved & 4L));
        FPU.FPU_SET_C3((int)(ressaved & 2L));
        FPU.FPU_SET_C1((int)(ressaved & 1L));
        FPU.FPU_SET_C2(0);
    }

    private static void FPU_FPREM1() {
        long quotf;
        long valtop = FPU.fpu.regs[FPU.fpu.top].d;
        long valdiv = FPU.fpu.regs[FPU.STV((int)1)].d;
        long quot = MicroDouble.div(valtop, valdiv);
        long ressaved = MicroDouble.gt(MicroDouble.sub(quot, quotf = MicroDouble.floor(quot)), 4602678819172646912L) ? MicroDouble.add(quotf, 0x3FF0000000000000L) : (MicroDouble.lt(MicroDouble.sub(quot, quotf), 4602678819172646912L) ? quotf : ((MicroDouble.longValue(quotf) & 1L) != 0L ? MicroDouble.add(quotf, 0x3FF0000000000000L) : quotf));
        ressaved = MicroDouble.longValue(ressaved);
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.sub(valtop, MicroDouble.mul(MicroDouble.longToDouble(ressaved), valdiv));
        FPU.FPU_SET_C0((int)(ressaved & 4L));
        FPU.FPU_SET_C3((int)(ressaved & 2L));
        FPU.FPU_SET_C1((int)(ressaved & 1L));
        FPU.FPU_SET_C2(0);
    }

    private static void FPU_FXAM() {
        if ((FPU.fpu.regs[FPU.fpu.top].ll() & Long.MIN_VALUE) != 0L) {
            FPU.FPU_SET_C1(1);
        } else {
            FPU.FPU_SET_C1(0);
        }
        if (FPU.fpu.tags[FPU.fpu.top] == 3) {
            FPU.FPU_SET_C3(1);
            FPU.FPU_SET_C2(0);
            FPU.FPU_SET_C0(1);
            return;
        }
        if (MicroDouble.isZero(FPU.fpu.regs[FPU.fpu.top].d)) {
            FPU.FPU_SET_C3(1);
            FPU.FPU_SET_C2(0);
            FPU.FPU_SET_C0(0);
        } else {
            FPU.FPU_SET_C3(0);
            FPU.FPU_SET_C2(1);
            FPU.FPU_SET_C0(0);
        }
    }

    private static void FPU_F2XM1() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.sub(MicroDouble.pow(0x4000000000000000L, FPU.fpu.regs[FPU.fpu.top].d), 0x3FF0000000000000L);
    }

    private static void FPU_FYL2X() {
        FPU.fpu.regs[FPU.STV((int)1)].d = MicroDouble.mul(FPU.fpu.regs[FPU.STV((int)1)].d, MicroDouble.div(MicroDouble.log(FPU.fpu.regs[FPU.fpu.top].d), MicroDouble.log(0x4000000000000000L)));
        FPU.FPU_FPOP();
    }

    private static void FPU_FYL2XP1() {
        FPU.fpu.regs[FPU.STV((int)1)].d = MicroDouble.mul(FPU.fpu.regs[FPU.STV((int)1)].d, MicroDouble.div(MicroDouble.log(MicroDouble.add(FPU.fpu.regs[FPU.fpu.top].d, 0x3FF0000000000000L)), MicroDouble.log(0x4000000000000000L)));
        FPU.FPU_FPOP();
    }

    private static void FPU_FSCALE() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.mul(FPU.fpu.regs[FPU.fpu.top].d, MicroDouble.pow(0x4000000000000000L, MicroDouble.truncate(FPU.fpu.regs[FPU.STV((int)1)].d)));
    }

    private static void FPU_FSTENV(int addr) {
        FPU.FPU_SET_TOP(FPU.fpu.top);
        if (!CPU.cpu.code.big) {
            Memory.mem_writew(addr + 0, FPU.fpu.cw);
            Memory.mem_writew(addr + 2, FPU.fpu.sw);
            Memory.mem_writew(addr + 4, FPU.FPU_GetTag());
        } else {
            Memory.mem_writed(addr + 0, FPU.fpu.cw);
            Memory.mem_writed(addr + 4, FPU.fpu.sw);
            Memory.mem_writed(addr + 8, FPU.FPU_GetTag());
        }
    }

    private static void FPU_FLDENV(int addr) {
        int tag;
        int cw;
        if (!CPU.cpu.code.big) {
            cw = Memory.mem_readw(addr + 0);
            FPU.fpu.sw = Memory.mem_readw(addr + 2);
            tag = Memory.mem_readw(addr + 4);
        } else {
            cw = Memory.mem_readd(addr + 0);
            FPU.fpu.sw = Memory.mem_readd(addr + 4);
            long tagbig = (long)Memory.mem_readd(addr + 8) & 0xFFFFFFFFL;
            tag = (int)tagbig;
        }
        FPU.FPU_SetTag(tag);
        FPU.FPU_SetCW(cw);
        FPU.fpu.top = FPU.FPU_GET_TOP();
    }

    private static void FPU_FSAVE(int addr) {
        FPU.FPU_FSTENV(addr);
        int start = CPU.cpu.code.big ? 28 : 14;
        for (int i = 0; i < 8; ++i) {
            FPU.FPU_ST80(addr + start, FPU.STV(i));
            start += 10;
        }
        FPU.FPU_FINIT();
    }

    private static void FPU_FRSTOR(int addr) {
        FPU.FPU_FLDENV(addr);
        int start = CPU.cpu.code.big ? 28 : 14;
        for (int i = 0; i < 8; ++i) {
            FPU.fpu.regs[FPU.STV((int)i)].d = FPU.FPU_FLD80(addr + start);
            start += 10;
        }
    }

    private static void FPU_FXTRACT() {
        FPU_Reg test = new FPU_Reg(FPU.fpu.regs[FPU.fpu.top]);
        long exp80 = test.ll() & 0x7FF0000000000000L;
        long exp80final = (exp80 >> 52) - 1023L;
        exp80final = MicroDouble.longToDouble(exp80final);
        long mant = MicroDouble.div(test.d, MicroDouble.pow(0x4000000000000000L, exp80final));
        FPU.fpu.regs[FPU.fpu.top].d = exp80final;
        FPU.FPU_PUSH(mant);
    }

    private static void FPU_FCHS() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.negate(FPU.fpu.regs[FPU.fpu.top].d);
    }

    private static void FPU_FABS() {
        FPU.fpu.regs[FPU.fpu.top].d = MicroDouble.abs(FPU.fpu.regs[FPU.fpu.top].d);
    }

    private static void FPU_FTST() {
        FPU.fpu.regs[8].d = 0L;
        FPU.FPU_FCOM(FPU.fpu.top, 8);
    }

    private static void FPU_FLD1() {
        FPU.FPU_PREP_PUSH();
        FPU.fpu.regs[FPU.fpu.top].d = 0x3FF0000000000000L;
    }

    private static void FPU_FLDL2T() {
        FPU.FPU_PREP_PUSH();
        FPU.fpu.regs[FPU.fpu.top].d = L2T;
    }

    private static void FPU_FLDL2E() {
        FPU.FPU_PREP_PUSH();
        FPU.fpu.regs[FPU.fpu.top].d = 4609176140021203710L;
    }

    private static void FPU_FLDPI() {
        FPU.FPU_PREP_PUSH();
        FPU.fpu.regs[FPU.fpu.top].d = 4614256656552045848L;
    }

    private static void FPU_FLDLG2() {
        FPU.FPU_PREP_PUSH();
        FPU.fpu.regs[FPU.fpu.top].d = LG2;
    }

    private static void FPU_FLDLN2() {
        FPU.FPU_PREP_PUSH();
        FPU.fpu.regs[FPU.fpu.top].d = 4604418534313441775L;
    }

    private static void FPU_FLDZ() {
        FPU.FPU_PREP_PUSH();
        FPU.fpu.regs[FPU.fpu.top].d = 0L;
        FPU.fpu.tags[FPU.fpu.top] = 1;
    }

    private static void FPU_FADD_EA(int op1) {
        FPU.FPU_FADD(op1, 8);
    }

    private static void FPU_FMUL_EA(int op1) {
        FPU.FPU_FMUL(op1, 8);
    }

    private static void FPU_FSUB_EA(int op1) {
        FPU.FPU_FSUB(op1, 8);
    }

    private static void FPU_FSUBR_EA(int op1) {
        FPU.FPU_FSUBR(op1, 8);
    }

    private static void FPU_FDIV_EA(int op1) {
        FPU.FPU_FDIV(op1, 8);
    }

    private static void FPU_FDIVR_EA(int op1) {
        FPU.FPU_FDIVR(op1, 8);
    }

    private static void FPU_FCOM_EA(int op1) {
        FPU.FPU_FCOM(op1, 8);
    }

    private static void FPU_FLDCW(int addr) {
        int temp = Memory.mem_readw(addr);
        FPU.FPU_SetCW(temp);
    }

    private static int FPU_GetTag() {
        int tag = 0;
        for (int i = 0; i < 8; ++i) {
            tag |= (FPU.fpu.tags[i] & 3) << 2 * i;
        }
        return tag;
    }

    private static void EATREE(int _rm) {
        int group = _rm >> 3 & 7;
        switch (group) {
            case 0: {
                FPU.FPU_FADD_EA(FPU.fpu.top);
                break;
            }
            case 1: {
                FPU.FPU_FMUL_EA(FPU.fpu.top);
                break;
            }
            case 2: {
                FPU.FPU_FCOM_EA(FPU.fpu.top);
                break;
            }
            case 3: {
                FPU.FPU_FCOM_EA(FPU.fpu.top);
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_FSUB_EA(FPU.fpu.top);
                break;
            }
            case 5: {
                FPU.FPU_FSUBR_EA(FPU.fpu.top);
                break;
            }
            case 6: {
                FPU.FPU_FDIV_EA(FPU.fpu.top);
                break;
            }
            case 7: {
                FPU.FPU_FDIVR_EA(FPU.fpu.top);
                break;
            }
        }
    }

    public static void FPU_ESC0_EA(int rm, int addr) {
        FPU.FPU_FLD_F32_EA(addr);
        FPU.EATREE(rm);
    }

    public static void FPU_ESC0_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.FPU_FADD(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 1: {
                FPU.FPU_FMUL(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 2: {
                FPU.FPU_FCOM(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 3: {
                FPU.FPU_FCOM(FPU.fpu.top, FPU.STV(sub));
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_FSUB(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 5: {
                FPU.FPU_FSUBR(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 6: {
                FPU.FPU_FDIV(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 7: {
                FPU.FPU_FDIVR(FPU.fpu.top, FPU.STV(sub));
                break;
            }
        }
    }

    public static void FPU_ESC1_EA(int rm, int addr) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FLD_F32(addr, FPU.fpu.top);
                break;
            }
            case 1: {
                Log.log(7, 1, "ESC EA 1:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            case 2: {
                FPU.FPU_FST_F32(addr);
                break;
            }
            case 3: {
                FPU.FPU_FST_F32(addr);
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_FLDENV(addr);
                break;
            }
            case 5: {
                FPU.FPU_FLDCW(addr);
                break;
            }
            case 6: {
                FPU.FPU_FSTENV(addr);
                break;
            }
            case 7: {
                Memory.mem_writew(addr, FPU.fpu.cw);
                break;
            }
            default: {
                Log.log(7, 1, "ESC EA 1:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC1_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        block0 : switch (group) {
            case 0: {
                int reg_from = FPU.STV(sub);
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FST(reg_from, FPU.fpu.top);
                break;
            }
            case 1: {
                FPU.FPU_FXCH(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 2: {
                FPU.FPU_FNOP();
                break;
            }
            case 3: {
                FPU.FPU_FST(FPU.fpu.top, FPU.STV(sub));
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                switch (sub) {
                    case 0: {
                        FPU.FPU_FCHS();
                        break;
                    }
                    case 1: {
                        FPU.FPU_FABS();
                        break;
                    }
                    case 2: 
                    case 3: {
                        Log.log(7, 1, "ESC 1:Unhandled group " + group + " subfunction " + sub);
                        break;
                    }
                    case 4: {
                        FPU.FPU_FTST();
                        break;
                    }
                    case 5: {
                        FPU.FPU_FXAM();
                        break;
                    }
                    case 6: 
                    case 7: {
                        Log.log(7, 1, "ESC 1:Unhandled group " + group + " subfunction " + sub);
                    }
                }
                break;
            }
            case 5: {
                switch (sub) {
                    case 0: {
                        FPU.FPU_FLD1();
                        break;
                    }
                    case 1: {
                        FPU.FPU_FLDL2T();
                        break;
                    }
                    case 2: {
                        FPU.FPU_FLDL2E();
                        break;
                    }
                    case 3: {
                        FPU.FPU_FLDPI();
                        break;
                    }
                    case 4: {
                        FPU.FPU_FLDLG2();
                        break;
                    }
                    case 5: {
                        FPU.FPU_FLDLN2();
                        break;
                    }
                    case 6: {
                        FPU.FPU_FLDZ();
                        break;
                    }
                    case 7: {
                        Log.log(7, 1, "ESC 1:Unhandled group " + group + " subfunction " + sub);
                    }
                }
                break;
            }
            case 6: {
                switch (sub) {
                    case 0: {
                        FPU.FPU_F2XM1();
                        break block0;
                    }
                    case 1: {
                        FPU.FPU_FYL2X();
                        break block0;
                    }
                    case 2: {
                        FPU.FPU_FPTAN();
                        break block0;
                    }
                    case 3: {
                        FPU.FPU_FPATAN();
                        break block0;
                    }
                    case 4: {
                        FPU.FPU_FXTRACT();
                        break block0;
                    }
                    case 5: {
                        FPU.FPU_FPREM1();
                        break block0;
                    }
                    case 6: {
                        FPU.fpu.top = FPU.fpu.top - 1 & 7;
                        break block0;
                    }
                    case 7: {
                        FPU.fpu.top = FPU.fpu.top + 1 & 7;
                        break block0;
                    }
                }
                Log.log(7, 1, "ESC 1:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            case 7: {
                switch (sub) {
                    case 0: {
                        FPU.FPU_FPREM();
                        break block0;
                    }
                    case 1: {
                        FPU.FPU_FYL2XP1();
                        break block0;
                    }
                    case 2: {
                        FPU.FPU_FSQRT();
                        break block0;
                    }
                    case 3: {
                        FPU.FPU_FSINCOS();
                        break block0;
                    }
                    case 4: {
                        FPU.FPU_FRNDINT();
                        break block0;
                    }
                    case 5: {
                        FPU.FPU_FSCALE();
                        break block0;
                    }
                    case 6: {
                        FPU.FPU_FSIN();
                        break block0;
                    }
                    case 7: {
                        FPU.FPU_FCOS();
                        break block0;
                    }
                }
                Log.log(7, 1, "ESC 1:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            default: {
                Log.log(7, 1, "ESC 1:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC2_EA(int rm, int addr) {
        FPU.FPU_FLD_I32_EA(addr);
        FPU.EATREE(rm);
    }

    public static void FPU_ESC2_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        block0 : switch (group) {
            case 5: {
                switch (sub) {
                    case 1: {
                        FPU.FPU_FUCOM(FPU.fpu.top, FPU.STV(1));
                        FPU.FPU_FPOP();
                        FPU.FPU_FPOP();
                        break block0;
                    }
                }
                Log.log(7, 1, "ESC 2:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            default: {
                Log.log(7, 1, "ESC 2:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC3_EA(int rm, int addr) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FLD_I32(addr, FPU.fpu.top);
                break;
            }
            case 1: {
                Log.log(7, 1, "ESC 3 EA:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            case 2: {
                FPU.FPU_FST_I32(addr);
                break;
            }
            case 3: {
                FPU.FPU_FST_I32(addr);
                FPU.FPU_FPOP();
                break;
            }
            case 5: {
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FLD_F80(addr);
                break;
            }
            case 7: {
                FPU.FPU_FST_F80(addr);
                FPU.FPU_FPOP();
                break;
            }
            default: {
                Log.log(7, 1, "ESC 3 EA:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC3_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        block0 : switch (group) {
            case 4: {
                switch (sub) {
                    case 0: 
                    case 1: {
                        Log.log(7, 2, "8087 only fpu code used esc 3: group 4: subfuntion :" + sub);
                        break block0;
                    }
                    case 2: {
                        FPU.FPU_FCLEX();
                        break block0;
                    }
                    case 3: {
                        FPU.FPU_FINIT();
                        break block0;
                    }
                    case 4: 
                    case 5: {
                        FPU.FPU_FNOP();
                        break block0;
                    }
                }
                Log.exit("ESC 3:ILLEGAL OPCODE group " + group + " subfunction " + sub);
                break;
            }
            default: {
                Log.log(7, 1, "ESC 3:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC4_EA(int rm, int addr) {
        FPU.FPU_FLD_F64_EA(addr);
        FPU.EATREE(rm);
    }

    public static void FPU_ESC4_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.FPU_FADD(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 1: {
                FPU.FPU_FMUL(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 2: {
                FPU.FPU_FCOM(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 3: {
                FPU.FPU_FCOM(FPU.fpu.top, FPU.STV(sub));
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_FSUBR(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 5: {
                FPU.FPU_FSUB(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 6: {
                FPU.FPU_FDIVR(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 7: {
                FPU.FPU_FDIV(FPU.STV(sub), FPU.fpu.top);
                break;
            }
        }
    }

    public static void FPU_ESC5_EA(int rm, int addr) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FLD_F64(addr, FPU.fpu.top);
                break;
            }
            case 1: {
                Log.log(7, 1, "ESC 5 EA:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            case 2: {
                FPU.FPU_FST_F64(addr);
                break;
            }
            case 3: {
                FPU.FPU_FST_F64(addr);
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_FRSTOR(addr);
                break;
            }
            case 6: {
                FPU.FPU_FSAVE(addr);
                break;
            }
            case 7: {
                FPU.FPU_SET_TOP(FPU.fpu.top);
                Memory.mem_writew(addr, FPU.fpu.sw);
                break;
            }
            default: {
                Log.log(7, 1, "ESC 5 EA:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC5_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.fpu.tags[FPU.STV((int)sub)] = 3;
                break;
            }
            case 1: {
                FPU.FPU_FXCH(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 2: {
                FPU.FPU_FST(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 3: {
                FPU.FPU_FST(FPU.fpu.top, FPU.STV(sub));
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_FUCOM(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 5: {
                FPU.FPU_FUCOM(FPU.fpu.top, FPU.STV(sub));
                FPU.FPU_FPOP();
                break;
            }
            default: {
                Log.log(7, 1, "ESC 5:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC6_EA(int rm, int addr) {
        FPU.FPU_FLD_I16_EA(addr);
        FPU.EATREE(rm);
    }

    public static void FPU_ESC6_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.FPU_FADD(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 1: {
                FPU.FPU_FMUL(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 2: {
                FPU.FPU_FCOM(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 3: {
                if (sub != 1) {
                    Log.log(7, 1, "ESC 6:Unhandled group " + group + " subfunction " + sub);
                    return;
                }
                FPU.FPU_FCOM(FPU.fpu.top, FPU.STV(1));
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_FSUBR(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 5: {
                FPU.FPU_FSUB(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 6: {
                FPU.FPU_FDIVR(FPU.STV(sub), FPU.fpu.top);
                break;
            }
            case 7: {
                FPU.FPU_FDIV(FPU.STV(sub), FPU.fpu.top);
                break;
            }
        }
        FPU.FPU_FPOP();
    }

    public static void FPU_ESC7_EA(int rm, int addr) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        switch (group) {
            case 0: {
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FLD_I16(addr, FPU.fpu.top);
                break;
            }
            case 1: {
                Log.log(7, 1, "ESC 7 EA:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            case 2: {
                FPU.FPU_FST_I16(addr);
                break;
            }
            case 3: {
                FPU.FPU_FST_I16(addr);
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FBLD(addr, FPU.fpu.top);
                break;
            }
            case 5: {
                FPU.FPU_PREP_PUSH();
                FPU.FPU_FLD_I64(addr, FPU.fpu.top);
                break;
            }
            case 6: {
                FPU.FPU_FBST(addr);
                FPU.FPU_FPOP();
                break;
            }
            case 7: {
                FPU.FPU_FST_I64(addr);
                FPU.FPU_FPOP();
                break;
            }
            default: {
                Log.log(7, 1, "ESC 7 EA:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    public static void FPU_ESC7_Normal(int rm) {
        int group = rm >> 3 & 7;
        int sub = rm & 7;
        block0 : switch (group) {
            case 0: {
                FPU.fpu.tags[FPU.STV((int)sub)] = 3;
                FPU.FPU_FPOP();
                break;
            }
            case 1: {
                FPU.FPU_FXCH(FPU.fpu.top, FPU.STV(sub));
                break;
            }
            case 2: 
            case 3: {
                FPU.FPU_FST(FPU.fpu.top, FPU.STV(sub));
                FPU.FPU_FPOP();
                break;
            }
            case 4: {
                switch (sub) {
                    case 0: {
                        FPU.FPU_SET_TOP(FPU.fpu.top);
                        CPU_Regs.reg_eax.word(FPU.fpu.sw);
                        break block0;
                    }
                }
                Log.log(7, 1, "ESC 7:Unhandled group " + group + " subfunction " + sub);
                break;
            }
            default: {
                Log.log(7, 1, "ESC 7:Unhandled group " + group + " subfunction " + sub);
            }
        }
    }

    private static class Test {
        short begin;
        FPU_Reg eind = new FPU_Reg();

        private Test() {
        }
    }

    public static class FPU_rec {
        public FPU_Reg[] regs = new FPU_Reg[9];
        public FPU_P_Reg[] p_regs = new FPU_P_Reg[9];
        public int[] tags = new int[9];
        public int cw;
        public int cw_mask_all;
        public int sw;
        public int top;
        public int round;

        public FPU_rec() {
            int i;
            for (i = 0; i < this.regs.length; ++i) {
                this.regs[i] = new FPU_Reg();
            }
            for (i = 0; i < this.p_regs.length; ++i) {
                this.p_regs[i] = new FPU_P_Reg();
            }
        }
    }

    private static class FPU_P_Reg {
        long m1;
        long m2;
        int m3;
        int d1;
        long d2;

        private FPU_P_Reg() {
        }
    }

    public static class FPU_Reg {
        L l = new L();
        public long d;

        public FPU_Reg() {
        }

        public FPU_Reg(FPU_Reg i) {
            this.d = i.d;
        }

        public void copy(FPU_Reg i) {
            this.d = i.d;
        }

        void ll(int lower, int upper) {
            this.ll((long)lower & 0xFFFFFFFFL | ((long)upper & 0xFFFFFFFFL) << 32);
        }

        long ll() {
            return this.d;
        }

        void ll(long l) {
            this.d = l;
        }

        class L {
            L() {
            }

            int lower() {
                return (int)FPU_Reg.this.ll();
            }

            int upper() {
                return (int)(FPU_Reg.this.ll() >>> 32);
            }
        }
    }
}

