/*
 * Decompiled with CFR 0.152.
 */
package jdos.gui;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.util.Vector;
import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.core_dynamic.Compiler;
import jdos.cpu.core_dynamic.Loader;
import jdos.dos.Dos_execute;
import jdos.dos.Dos_programs;
import jdos.gui.Mapper;
import jdos.gui.Render;
import jdos.hardware.Keyboard;
import jdos.ints.Mouse;
import jdos.misc.Cross;
import jdos.misc.Log;
import jdos.misc.setup.CommandLine;
import jdos.misc.setup.Config;
import jdos.misc.setup.Prop_bool;
import jdos.misc.setup.Prop_int;
import jdos.misc.setup.Prop_multival;
import jdos.misc.setup.Prop_string;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.sdl.GUI;
import jdos.sdl.SDL_Mapper;
import jdos.util.IntRef;

public class Main {
    private static GUI gui = null;
    private static long startTime = System.currentTimeMillis();
    private static final String MAPPERFILE = "mapper-0.74.map";
    static int internal_cycles = 0;
    static int internal_frameskip = 0;
    public static boolean mouse_locked = false;
    public static float mouse_sensitivity = 100.0f;
    private static boolean mouse_autoenable = false;
    private static boolean mouse_autolock = false;
    private static boolean mouse_requestlock = false;
    private static Point lastMouse = new Point();
    public static Object pauseMutex = new Object();
    public static final Object paintMutex = new Object();
    private static int skipCount = 0;
    static byte[] byte_rawImageData;
    static short[] short_rawImageData;
    static int[] int_rawImageData;
    static int[] pixelBuffer;
    static int pitch;
    static int screen_width;
    static int screen_height;
    static int buffer_width;
    static int buffer_height;
    static IndexColorModel colorModel;
    static int[] cmap;
    static BufferedImage buffer;
    private static Section.SectionFunction GUI_ShutDown;
    private static Mapper.MAPPER_Handler KillSwitch;
    private static Mapper.MAPPER_Handler CaptureMouse;
    private static Mapper.MAPPER_Handler SwitchFullScreen;
    private static boolean paused;
    private static Mapper.MAPPER_Handler PauseDOSBox;
    private static int priority_focus;
    private static int priority_nofocus;
    private static Section.SectionFunction GUI_StartUp;
    private static Vector events;
    private static long startupTime;

    public static void showProgress(String msg, int percent) {
        gui.showProgress(msg, percent);
    }

    public static long GetTicks() {
        return System.currentTimeMillis() - startTime;
    }

    public static void Delay(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void GFX_SetPalette(int start, int count, Render.RenderPal_t.RGB[] entries, int entriesOffset) {
        for (int i = start; i < start + count; ++i) {
            Main.cmap[i] = Main.GFX_GetRGB(entries[i].red, entries[i].green, entries[i].blue);
        }
        Main.updateBuffers();
    }

    public static int GFX_GetRGB(short red, short green, short blue) {
        return blue << 0 | green << 8 | red << 16 | 0xFF000000;
    }

    public static void GFX_SetTitle(int cycles, int frameskip, boolean paused) {
        StringBuffer title = new StringBuffer();
        if (cycles != -1) {
            internal_cycles = cycles;
        }
        if (frameskip != -1) {
            internal_frameskip = frameskip;
        }
        if (CPU.CPU_CycleAutoAdjust) {
            title.append("DOSBox ");
            title.append("0.74.25b");
            title.append(", Cpu speed: max ");
            title.append(internal_cycles);
            title.append("% cycles, Frameskip ");
            title.append(internal_frameskip);
            title.append(", Program: ");
            title.append(Dos_execute.RunningProgram);
        } else {
            title.append("DOSBox ");
            title.append("0.74.25b");
            title.append(", Cpu speed: ");
            title.append(internal_cycles);
            title.append(" cycles, Frameskip ");
            title.append(internal_frameskip);
            title.append(", Program: ");
            title.append(Dos_execute.RunningProgram);
        }
        if (paused) {
            title.append(" PAUSED");
        }
        if (gui != null) {
            gui.setTitle(title.toString());
        }
    }

    public static void GFX_Events() {
        while (events.size() > 0) {
            Object event = events.elementAt(0);
            events.removeElementAt(0);
            if (event == null) {
                throw new ShutdownException();
            }
            if (event instanceof KeyEvent) {
                Main.handle((KeyEvent)event);
                continue;
            }
            if (event instanceof FocusChangeEvent) {
                Main.handle((FocusChangeEvent)event);
                continue;
            }
            if (!(event instanceof MouseEvent)) continue;
            Main.handle((MouseEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEvent(Object o) {
        KeyEvent key;
        if (paused && o instanceof KeyEvent && (key = (KeyEvent)o).getKeyCode() == 19) {
            Object object = pauseMutex;
            synchronized (object) {
                try {
                    pauseMutex.notify();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        events.add(o);
    }

    public static void GFX_CaptureMouse() {
        boolean bl = mouse_locked = !mouse_locked;
        if (mouse_locked) {
            gui.showCursor(false);
            gui.captureMouse(true);
        } else {
            gui.captureMouse(false);
            if (mouse_autoenable || !mouse_autolock) {
                gui.showCursor(true);
            }
        }
    }

    private static void handle(MouseEvent event) {
        if (event.getID() == 503 || event.getID() == 506) {
            if (mouse_locked || !mouse_autoenable) {
                if (event instanceof MouseEvent2) {
                    MouseEvent2 event2 = (MouseEvent2)event;
                    Mouse.Mouse_CursorMoved((float)event2.rel_x * mouse_sensitivity / 100.0f, (float)event2.rel_y * mouse_sensitivity / 100.0f, event2.abs_x, event2.abs_y, mouse_locked);
                } else {
                    Mouse.Mouse_CursorMoved((float)(event.getPoint().x - Main.lastMouse.x) * mouse_sensitivity / 100.0f, (float)(event.getPoint().y - Main.lastMouse.y) * mouse_sensitivity / 100.0f, (float)event.getPoint().x / (float)(screen_width - 1) * mouse_sensitivity / 100.0f, (float)event.getPoint().y / (float)(screen_height - 1) * mouse_sensitivity / 100.0f, mouse_locked);
                    lastMouse = event.getPoint();
                }
            }
        } else if (event.getID() == 501) {
            if (mouse_requestlock && !mouse_locked) {
                Main.GFX_CaptureMouse();
                return;
            }
            if (!mouse_autoenable && mouse_autolock && event.getButton() == 3) {
                Main.GFX_CaptureMouse();
                return;
            }
            if (event.getButton() == 1) {
                Mouse.Mouse_ButtonPressed(0);
            } else if (event.getButton() == 2) {
                Mouse.Mouse_ButtonPressed(2);
            } else if (event.getButton() == 3) {
                Mouse.Mouse_ButtonPressed(1);
            }
        } else if (event.getID() == 502) {
            if (event.getButton() == 1) {
                Mouse.Mouse_ButtonReleased(0);
            } else if (event.getButton() == 2) {
                Mouse.Mouse_ButtonReleased(2);
            } else if (event.getButton() == 3) {
                Mouse.Mouse_ButtonReleased(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handle(FocusChangeEvent event) {
        if (event.hasfocus) {
            Main.SetPriority(priority_focus);
        } else {
            Keyboard.KEYBOARD_AddKey(54, false);
            Keyboard.KEYBOARD_AddKey(55, false);
            if (mouse_locked) {
                Main.GFX_CaptureMouse();
            }
            if (priority_nofocus == 0) {
                Main.GFX_SetTitle(-1, -1, true);
                Keyboard.KEYBOARD_ClrBuffer();
                Object object = pauseMutex;
                synchronized (object) {
                    try {
                        pauseMutex.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Main.GFX_SetTitle(-1, -1, false);
            } else {
                Main.SetPriority(priority_nofocus);
            }
        }
    }

    private static void handle(KeyEvent key) {
        int result;
        switch (key.getKeyCode()) {
            case 27: {
                result = 49;
                break;
            }
            case 97: {
                result = 87;
                break;
            }
            case 49: {
                result = 1;
                break;
            }
            case 98: {
                result = 88;
                break;
            }
            case 50: {
                result = 2;
                break;
            }
            case 99: {
                result = 89;
                break;
            }
            case 51: {
                result = 3;
                break;
            }
            case 100: {
                result = 90;
                break;
            }
            case 52: {
                result = 4;
                break;
            }
            case 101: {
                result = 91;
                break;
            }
            case 53: {
                result = 5;
                break;
            }
            case 102: {
                result = 92;
                break;
            }
            case 54: {
                result = 6;
                break;
            }
            case 103: {
                result = 93;
                break;
            }
            case 55: {
                result = 7;
                break;
            }
            case 104: {
                result = 94;
                break;
            }
            case 56: {
                result = 8;
                break;
            }
            case 105: {
                result = 95;
                break;
            }
            case 57: {
                result = 9;
                break;
            }
            case 96: {
                result = 96;
                break;
            }
            case 48: {
                result = 10;
                break;
            }
            case 109: {
                result = 99;
                break;
            }
            case 45: {
                result = 64;
                break;
            }
            case 61: {
                result = 65;
                break;
            }
            case 8: {
                result = 51;
                break;
            }
            case 9: {
                result = 50;
                break;
            }
            case 81: {
                result = 11;
                break;
            }
            case 87: {
                result = 12;
                break;
            }
            case 69: {
                result = 13;
                break;
            }
            case 82: {
                result = 14;
                break;
            }
            case 84: {
                result = 15;
                break;
            }
            case 89: {
                result = 16;
                break;
            }
            case 85: {
                result = 17;
                break;
            }
            case 73: {
                result = 18;
                break;
            }
            case 79: {
                result = 19;
                break;
            }
            case 80: {
                result = 20;
                break;
            }
            case 91: {
                result = 67;
                break;
            }
            case 93: {
                result = 68;
                break;
            }
            case 10: {
                result = 52;
                break;
            }
            case 17: {
                if (key.getKeyLocation() == 2) {
                    result = 56;
                    break;
                }
                result = 57;
                break;
            }
            case 65: {
                result = 21;
                break;
            }
            case 83: {
                result = 22;
                break;
            }
            case 68: {
                result = 23;
                break;
            }
            case 70: {
                result = 24;
                break;
            }
            case 71: {
                result = 25;
                break;
            }
            case 72: {
                result = 26;
                break;
            }
            case 74: {
                result = 27;
                break;
            }
            case 75: {
                result = 28;
                break;
            }
            case 76: {
                result = 29;
                break;
            }
            case 59: {
                result = 69;
                break;
            }
            case 222: {
                result = 70;
                break;
            }
            case 192: {
                result = 63;
                break;
            }
            case 16: {
                if (key.getKeyLocation() == 2) {
                    result = 58;
                    break;
                }
                result = 59;
                break;
            }
            case 92: {
                result = 66;
                break;
            }
            case 90: {
                result = 30;
                break;
            }
            case 88: {
                result = 31;
                break;
            }
            case 67: {
                result = 32;
                break;
            }
            case 86: {
                result = 33;
                break;
            }
            case 66: {
                result = 34;
                break;
            }
            case 78: {
                result = 35;
                break;
            }
            case 77: {
                result = 36;
                break;
            }
            case 44: {
                result = 72;
                break;
            }
            case 46: {
                result = 71;
                break;
            }
            case 110: {
                result = 102;
                break;
            }
            case 47: {
                result = 73;
                break;
            }
            case 106: {
                result = 98;
                break;
            }
            case 18: {
                if (key.getKeyLocation() == 2) {
                    result = 54;
                    break;
                }
                result = 55;
                break;
            }
            case 32: {
                result = 53;
                break;
            }
            case 20: {
                result = 60;
                break;
            }
            case 112: {
                result = 37;
                break;
            }
            case 113: {
                result = 38;
                break;
            }
            case 114: {
                result = 39;
                break;
            }
            case 115: {
                result = 40;
                break;
            }
            case 116: {
                result = 41;
                break;
            }
            case 117: {
                result = 42;
                break;
            }
            case 118: {
                result = 43;
                break;
            }
            case 119: {
                result = 44;
                break;
            }
            case 120: {
                result = 45;
                break;
            }
            case 121: {
                result = 46;
                break;
            }
            case 144: {
                result = 62;
                break;
            }
            case 145: {
                result = 61;
                break;
            }
            case 521: {
                result = 100;
                break;
            }
            case 153: {
                result = 74;
                break;
            }
            case 122: {
                result = 47;
                break;
            }
            case 123: {
                result = 48;
                break;
            }
            case 111: {
                result = 97;
                break;
            }
            case 107: {
                result = 100;
                break;
            }
            case 36: {
                result = 78;
                break;
            }
            case 38: {
                result = 84;
                break;
            }
            case 33: {
                result = 79;
                break;
            }
            case 37: {
                result = 83;
                break;
            }
            case 39: {
                result = 86;
                break;
            }
            case 35: {
                result = 81;
                break;
            }
            case 40: {
                result = 85;
                break;
            }
            case 34: {
                result = 82;
                break;
            }
            case 155: {
                result = 77;
                break;
            }
            case 127: {
                result = 80;
                break;
            }
            case 19: {
                result = 76;
                break;
            }
            case 154: {
                result = 75;
                break;
            }
            default: {
                Log.log(20, 1, "Unknown key code: " + key.getKeyCode());
                return;
            }
        }
        Keyboard.KEYBOARD_AddKey(result, key.getID() == 401);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void GFX_EndUpdate() {
        if (pixelBuffer != null) {
            if (startupTime != 0L) {
                System.out.println("Startup time: " + String.valueOf(System.currentTimeMillis() - startupTime) + "ms");
                startupTime = 0L;
            }
            long startTime = 0L;
            if (Render.render.frameskip.auto) {
                startTime = System.currentTimeMillis();
            }
            Object object = paintMutex;
            synchronized (object) {
                if (Render.render.frameskip.auto) {
                    long diff = System.currentTimeMillis() - startTime;
                    if (diff > 5L) {
                        skipCount = 0;
                        ++Render.render.frameskip.max;
                        Main.GFX_SetTitle(-1, Render.render.frameskip.max, false);
                    } else if (diff < 2L && Render.render.frameskip.max > 0 && ++skipCount > 100) {
                        skipCount = 0;
                        --Render.render.frameskip.max;
                        Main.GFX_SetTitle(-1, Render.render.frameskip.max, false);
                    }
                }
                int type = buffer.getRaster().getTransferType();
                switch (type) {
                    case 0: {
                        int pos = 0;
                        for (int i = 0; i < pixelBuffer.length; ++i) {
                            int p = pixelBuffer[i];
                            Main.byte_rawImageData[pos++] = (byte)p;
                            Main.byte_rawImageData[pos++] = (byte)(p >> 8);
                            Main.byte_rawImageData[pos++] = (byte)(p >> 16);
                            Main.byte_rawImageData[pos++] = (byte)(p >> 24);
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        int pos = 0;
                        for (int i = 0; i < pixelBuffer.length; ++i) {
                            int p = pixelBuffer[i];
                            Main.short_rawImageData[pos++] = (short)p;
                            Main.short_rawImageData[pos++] = (short)(p >> 16);
                        }
                        break;
                    }
                    case 3: {
                        System.arraycopy(pixelBuffer, 0, int_rawImageData, 0, pixelBuffer.length);
                    }
                }
            }
            gui.dopaint();
        }
    }

    public static boolean GFX_StartUpdate(int[][] pixels, IntRef pitch) {
        pixels[0] = pixelBuffer;
        pitch.value = Main.pitch;
        return true;
    }

    public static void GFX_SetSize(int width, int height, GFX_CallBack_t callback) {
        buffer_width = screen_width = width;
        buffer_height = screen_height = height;
        if (Render.render.aspect) {
            screen_height = screen_width * 3 / 4;
        }
        gui.setSize(screen_width, screen_height);
        if (Render.render.src.dblh) {
            buffer_height /= 2;
        }
        if (Render.render.src.dblw) {
            buffer_width /= 2;
        }
        Main.updateBuffers();
    }

    private static void updateBuffers() {
        switch (Render.render.src.bpp) {
            case 8: {
                colorModel = new IndexColorModel(8, 256, cmap, 0, false, -1, 0);
                buffer = new BufferedImage(buffer_width, buffer_height, 13, colorModel);
                DataBufferByte buf = (DataBufferByte)buffer.getRaster().getDataBuffer();
                byte_rawImageData = buf.getData();
                pixelBuffer = new int[byte_rawImageData.length >> 2];
                pitch = buffer_width;
                break;
            }
            case 15: {
                buffer = new BufferedImage(buffer_width, buffer_height, 9);
                DataBufferUShort buf = (DataBufferUShort)buffer.getRaster().getDataBuffer();
                short_rawImageData = buf.getData();
                pixelBuffer = new int[short_rawImageData.length >> 1];
                pitch = buffer_width * 2;
                break;
            }
            case 16: {
                buffer = new BufferedImage(buffer_width, buffer_height, 8);
                DataBufferUShort buf = (DataBufferUShort)buffer.getRaster().getDataBuffer();
                short_rawImageData = buf.getData();
                pixelBuffer = new int[short_rawImageData.length >> 1];
                pitch = buffer_width * 2;
                break;
            }
            case 32: {
                buffer = new BufferedImage(buffer_width, buffer_height, 1);
                DataBufferInt buf = (DataBufferInt)buffer.getRaster().getDataBuffer();
                int_rawImageData = buf.getData();
                pixelBuffer = new int[int_rawImageData.length];
                pitch = buffer_width * 4;
            }
        }
    }

    public static void Mouse_AutoLock(boolean enable) {
        mouse_autolock = enable;
        if (mouse_autoenable) {
            mouse_requestlock = enable;
        } else {
            gui.showCursor(!enable);
            mouse_requestlock = false;
        }
    }

    static void SetPriority(int level) {
    }

    private static void Config_Add_SDL() {
        Section_prop sdl_sec = Dosbox.control.AddSection_prop("sdl", GUI_StartUp);
        sdl_sec.AddInitFunction(SDL_Mapper.MAPPER_StartUp);
        Prop_bool Pbool = sdl_sec.Add_bool("fullscreen", 0, false);
        Pbool.Set_help("Start dosbox directly in fullscreen. (Press ALT-Enter to go back)");
        Pbool = sdl_sec.Add_bool("fulldouble", 0, false);
        Pbool.Set_help("Use double buffering in fullscreen. It can reduce screen flickering, but it can also result in a slow DOSBox.");
        Prop_string Pstring = sdl_sec.Add_string("fullresolution", 0, "original");
        Pstring.Set_help("What resolution to use for fullscreen: original or fixed size (e.g. 1024x768).\n  Using your monitor's native resolution with aspect=true might give the best results.\n  If you end up with small window on a large screen, try an output different from surface.");
        Pstring = sdl_sec.Add_string("windowresolution", 0, "original");
        Pstring.Set_help("Scale the window to this size IF the output device supports hardware scaling.\n  (output=surface does not!)");
        String[] outputs = new String[]{"surface", "overlay", "opengl", "openglnb", "ddraw"};
        Pstring = sdl_sec.Add_string("output", 0, "surface");
        Pstring.Set_help("What video system to use for output.");
        Pstring.Set_values(outputs);
        Pbool = sdl_sec.Add_bool("autolock", 0, true);
        Pbool.Set_help("Mouse will automatically lock, if you click on the screen. (Press CTRL-F10 to unlock)");
        Prop_int Pint = sdl_sec.Add_int("sensitivity", 0, 100);
        Pint.SetMinMax(1, 1000);
        Pint.Set_help("Mouse sensitivity.");
        Pbool = sdl_sec.Add_bool("waitonerror", 0, true);
        Pbool.Set_help("Wait before closing the console if dosbox has an error.");
        Prop_multival Pmulti = sdl_sec.Add_multi("priority", 0, ",");
        Pmulti.SetValue("higher,normal");
        Pmulti.Set_help("Priority levels for dosbox. Second entry behind the comma is for when dosbox is not focused/minimized.\n  pause is only valid for the second entry.");
        String[] actt = new String[]{"lowest", "lower", "normal", "higher", "highest", "pause"};
        Pstring = Pmulti.GetSection().Add_string("active", 0, "higher");
        Pstring.Set_values(actt);
        String[] inactt = new String[]{"lowest", "lower", "normal", "higher", "highest", "pause"};
        Pstring = Pmulti.GetSection().Add_string("inactive", 0, "normal");
        Pstring.Set_values(inactt);
        Pstring = sdl_sec.Add_path("mapperfile", 0, MAPPERFILE);
        Pstring.Set_help("File used to load/save the key/event mappings from. Resetmapper only works with the defaul value.");
        Pbool = sdl_sec.Add_bool("usescancodes", 0, true);
        Pbool.Set_help("Avoid usage of symkeys, might not work on all operating systems.");
    }

    static void launcheditor() {
        String edit;
        String path = Cross.CreatePlatformConfigDir() + Cross.GetPlatformConfigName();
        if (!Dosbox.control.PrintConfig(path)) {
            Log.exit("tried creating " + path + ". but failed.\n");
        }
        while ((edit = Dosbox.control.cmdline.FindString("-editconf", true)) != null) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{edit, path});
                if (p == null) continue;
                System.exit(0);
            }
            catch (Exception exception) {}
        }
        Log.exit("can't find editor(s) specified at the command line.\n");
    }

    static void launchcaptures(String edit) {
        String file = null;
        Section t = Dosbox.control.GetSection("dosbox");
        if (t != null) {
            file = t.GetPropValue("captures");
        }
        if (t == null || file.equals("PROP_NOT_EXIST")) {
            Log.exit("Config system messed up.\n");
        }
        String path = Cross.CreatePlatformConfigDir();
        path = path + file;
        Cross.CreateDir(path);
        if (new File(path).isDirectory()) {
            Log.exit(path + " doesn't exists or isn't a directory.\n");
        }
        try {
            Process p = Runtime.getRuntime().exec(new String[]{edit, path});
            if (p != null) {
                System.exit(0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Log.exit("can't find filemanager " + edit + "\n");
    }

    static void eraseconfigfile() {
        if (new File("dosbox.conf").exists()) {
            Main.show_warning("Warning: dosbox.conf exists in current working directory.\nThis will override the configuration file at runtime.\n");
        }
        String path = Cross.CreatePlatformConfigDir() + Cross.GetPlatformConfigName();
        new File(path).delete();
        System.exit(0);
    }

    static void erasemapperfile() {
        if (new File("dosbox.conf").exists()) {
            Main.show_warning("Warning: dosbox.conf exists in current working directory.\nKeymapping might not be properly reset.\nPlease reset configuration as well and delete the dosbox.conf.\n");
        }
        String path = Cross.CreatePlatformConfigDir() + MAPPERFILE;
        new File(path).delete();
        System.exit(0);
    }

    static void show_warning(String message) {
        Log.log_msg(message);
    }

    static void printconfiglocation() {
        String path = Cross.CreatePlatformConfigDir() + Cross.GetPlatformConfigName();
        if (!Dosbox.control.PrintConfig(path)) {
            Log.exit("tried creating " + path + ". but failed.\n");
        }
        Log.log_msg(path + "\n");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void main(GUI g, String[] args) {
        gui = g;
        while (true) {
            String path;
            String captures;
            Config myconf;
            String saveName;
            CPU.initialize();
            Main.GFX_SetTitle(-1, -1, false);
            CommandLine com_line = new CommandLine(args);
            if (com_line.FindExist("-applet", true)) {
                Dosbox.applet = true;
            }
            if ((saveName = com_line.FindString("-compile", true)) != null) {
                Compiler.saveClasses = true;
            }
            Dosbox.control = myconf = new Config(com_line);
            Main.Config_Add_SDL();
            Dosbox.Init();
            if (Dosbox.control.cmdline.FindString("-editconf", false) != null) {
                Main.launcheditor();
            }
            if ((captures = Dosbox.control.cmdline.FindString("-opencaptures", true)) != null) {
                Main.launchcaptures(captures);
            }
            if (Dosbox.control.cmdline.FindExist("-eraseconf")) {
                Main.eraseconfigfile();
            }
            if (Dosbox.control.cmdline.FindExist("-resetconf")) {
                Main.eraseconfigfile();
            }
            if (Dosbox.control.cmdline.FindExist("-erasemapper")) {
                Main.erasemapperfile();
            }
            if (Dosbox.control.cmdline.FindExist("-resetmapper")) {
                Main.erasemapperfile();
            }
            if (Dosbox.control.cmdline.FindExist("-version") || Dosbox.control.cmdline.FindExist("--version")) {
                Log.log_msg("\nDOSBox version 0.74.25b, copyright 2002-2010 DOSBox Team.\n\n");
                Log.log_msg("DOSBox is written by the DOSBox Team (See AUTHORS file))\n");
                Log.log_msg("DOSBox comes with ABSOLUTELY NO WARRANTY.  This is free software,\n");
                Log.log_msg("and you are welcome to redistribute it under certain conditions;\n");
                Log.log_msg("please read the COPYING file thoroughly before doing so.\n\n");
                return;
            }
            if (Dosbox.control.cmdline.FindExist("-printconf")) {
                Main.printconfiglocation();
            }
            Log.log_msg("DOSBox version 0.74.25b");
            Log.log_msg("Copyright 2002-2010 DOSBox Team, published under GNU GPL.");
            Log.log_msg("---");
            boolean parsed_anyconfigfile = false;
            if (Dosbox.control.cmdline.FindExist("-userconf", true)) {
                path = Cross.CreatePlatformConfigDir() + Cross.GetPlatformConfigName();
                if (Dosbox.control.ParseConfigFile(path)) {
                    parsed_anyconfigfile = true;
                }
                if (!parsed_anyconfigfile && Dosbox.control.PrintConfig(path)) {
                    Log.log_msg("CONFIG: Generating default configuration.\nWriting it to " + path);
                    if (Dosbox.control.ParseConfigFile(path)) {
                        parsed_anyconfigfile = true;
                    }
                }
            }
            while ((path = Dosbox.control.cmdline.FindString("-conf", true)) != null) {
                if (!Dosbox.control.ParseConfigFile(path)) continue;
                parsed_anyconfigfile = true;
            }
            if (!Dosbox.applet) {
                if (!parsed_anyconfigfile && Dosbox.control.ParseConfigFile("dosbox.conf")) {
                    parsed_anyconfigfile = true;
                }
                if (!parsed_anyconfigfile && Dosbox.control.ParseConfigFile(path = Cross.CreatePlatformConfigDir() + Cross.GetPlatformConfigName())) {
                    parsed_anyconfigfile = true;
                }
                if (!parsed_anyconfigfile) {
                    path = Cross.CreatePlatformConfigDir() + Cross.GetPlatformConfigName();
                    if (Dosbox.control.PrintConfig(path)) {
                        Log.log_msg("CONFIG: Generating default configuration.\nWriting it to " + path);
                        Dosbox.control.ParseConfigFile(path);
                    } else {
                        Log.log_msg("CONFIG: Using default settings. Create a configfile to change them");
                    }
                }
            }
            Dosbox.control.ParseEnv();
            Dosbox.control.Init();
            Section_prop sdl_sec = (Section_prop)Dosbox.control.GetSection("sdl");
            if (Dosbox.control.cmdline.FindExist("-fullscreen") || sdl_sec.Get_bool("fullscreen")) {
                gui.fullScreenToggle();
            }
            try {
                startupTime = System.currentTimeMillis();
                Dosbox.control.StartUp();
            }
            catch (Dos_programs.RebootException e) {
                System.out.println("Rebooting");
                try {
                    myconf.Destroy();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                continue;
            }
            catch (ShutdownException e) {
                if (saveName != null) {
                    Loader.save(saveName, false);
                }
                System.out.println("Normal Shutdown");
                try {
                    myconf.Destroy();
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            catch (KillException e) {
                System.out.println("Normal Shutdown");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (Dosbox.applet) break;
                System.exit(1);
            }
            finally {
                events.clear();
                continue;
            }
            break;
        }
    }

    static {
        cmap = new int[256];
        int i = 0;
        for (int r = 0; r < 256; r += 51) {
            for (int g = 0; g < 256; g += 51) {
                for (int b = 0; b < 256; b += 51) {
                    Main.cmap[i++] = r << 16 | g << 8 | b;
                }
            }
        }
        int grayIncr = 256 / (256 - i);
        int gray = grayIncr * 3;
        while (i < 256) {
            Main.cmap[i] = gray << 16 | gray << 8 | gray;
            gray += grayIncr;
            ++i;
        }
        GUI_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                if (mouse_locked) {
                    Main.GFX_CaptureMouse();
                }
            }
        };
        KillSwitch = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (pressed) {
                    throw new KillException();
                }
            }
        };
        CaptureMouse = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (pressed) {
                    Main.GFX_CaptureMouse();
                }
            }
        };
        SwitchFullScreen = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                gui.fullScreenToggle();
            }
        };
        paused = false;
        PauseDOSBox = new Mapper.MAPPER_Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call(boolean pressed) {
                if (!pressed) {
                    return;
                }
                Main.GFX_SetTitle(-1, -1, true);
                Object object = pauseMutex;
                synchronized (object) {
                    paused = true;
                    try {
                        pauseMutex.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    paused = false;
                }
                Main.GFX_SetTitle(-1, -1, false);
            }
        };
        GUI_StartUp = new Section.SectionFunction(){

            public void call(Section sec) {
                sec.AddDestroyFunction(GUI_ShutDown);
                Section_prop section = (Section_prop)sec;
                Prop_multival p = section.Get_multival("priority");
                String focus = p.GetSection().Get_string("active");
                String notfocus = p.GetSection().Get_string("inactive");
                if (focus.equals("lowest")) {
                    priority_focus = 1;
                } else if (focus.equals("lower")) {
                    priority_focus = 2;
                } else if (focus.equals("normal")) {
                    priority_focus = 3;
                } else if (focus.equals("higher")) {
                    priority_focus = 4;
                } else if (focus.equals("highest")) {
                    priority_focus = 5;
                }
                if (notfocus.equals("lowest")) {
                    priority_nofocus = 1;
                } else if (notfocus.equals("lower")) {
                    priority_nofocus = 2;
                } else if (notfocus.equals("normal")) {
                    priority_nofocus = 3;
                } else if (notfocus.equals("higher")) {
                    priority_nofocus = 4;
                } else if (notfocus.equals("highest")) {
                    priority_nofocus = 5;
                } else if (notfocus.equals("pause")) {
                    priority_nofocus = 0;
                }
                Main.SetPriority(priority_focus);
                Integer autolock = Dosbox.control.cmdline.FindInt("-autolock", true);
                if (autolock != null) {
                    mouse_autoenable = autolock == 1;
                } else {
                    mouse_autoenable = section.Get_bool("autolock");
                }
                if (!mouse_autoenable) {
                    gui.showCursor(false);
                }
                mouse_autolock = false;
                mouse_sensitivity = section.Get_int("sensitivity");
                Mapper.MAPPER_AddHandler(KillSwitch, 8, 1, "shutdown", "ShutDown");
                Mapper.MAPPER_AddHandler(CaptureMouse, 9, 1, "capmouse", "Cap Mouse");
                Mapper.MAPPER_AddHandler(SwitchFullScreen, 12, 2, "fullscr", "Fullscreen");
                Mapper.MAPPER_AddHandler(PauseDOSBox, 16, 2, "pause", "Pause");
            }
        };
        events = new Vector();
    }

    static final class PRIORITY_LEVELS {
        public static final int PRIORITY_LEVEL_PAUSE = 0;
        public static final int PRIORITY_LEVEL_LOWEST = 1;
        public static final int PRIORITY_LEVEL_LOWER = 2;
        public static final int PRIORITY_LEVEL_NORMAL = 3;
        public static final int PRIORITY_LEVEL_HIGHER = 4;
        public static final int PRIORITY_LEVEL_HIGHEST = 5;

        PRIORITY_LEVELS() {
        }
    }

    public static class MouseEvent1
    extends MouseEvent {
        public MouseEvent1(MouseEvent event, int offX, int offY) {
            super(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), event.getX() - offX, event.getY() - offY, event.getClickCount(), event.isPopupTrigger());
        }
    }

    public static class MouseEvent2
    extends MouseEvent {
        public int rel_x;
        public int rel_y;
        public float abs_x;
        public float abs_y;

        public MouseEvent2(MouseEvent event, int rel_x, int rel_y, float abs_x, float abs_y, int offX, int offY) {
            super(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), event.getX() - offX, event.getY() - offY, event.getClickCount(), event.isPopupTrigger());
            this.rel_x = rel_x;
            this.rel_y = rel_y;
            this.abs_x = abs_x;
            this.abs_y = abs_y;
        }
    }

    private static class KillException
    extends RuntimeException {
        private KillException() {
        }
    }

    private static class ShutdownException
    extends RuntimeException {
        private ShutdownException() {
        }
    }

    public static class FocusChangeEvent {
        public boolean hasfocus;

        public FocusChangeEvent(boolean hasfocus) {
            this.hasfocus = hasfocus;
        }
    }

    public static interface GFX_CallBack_t {
        public void call(int var1);
    }

    public static final class GFX_CallBackFunctions_t {
        public static final int GFX_CallBackReset = 0;
        public static final int GFX_CallBackStop = 1;
        public static final int GFX_CallBackRedraw = 2;
    }
}

