/*
 * Decompiled with CFR 0.152.
 */
package jdos.gui;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import jdos.cpu.core_dynamic.DecodeBlock;
import jdos.gui.Main;
import jdos.gui.MainFrame;
import jdos.gui.Render;
import jdos.sdl.GUI;
import jdos.util.FileHelper;
import jdos.util.Progress;
import jdos.util.StringHelper;
import jdos.util.UnZip;

public class MainApplet
extends Applet
implements GUI,
KeyListener,
Runnable,
MouseListener,
MouseMotionListener {
    private static final String base_dir = ".jdosbox";
    int[] pixels = new int[256];
    Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, this.pixels, 0, 16));
    Cursor transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(this.image, new Point(0, 0), "invisibleCursor");
    private String progressMsg = null;
    private int progressPercent = 0;
    private long progressTotal = 0L;
    private long progressCompleted = 0L;
    private Color backgroundColor = Color.darkGray;
    private static int current_id = 0;
    private int id;
    static Thread thread;
    Progress progressBar = new Progress(){

        public void set(int value) {
        }

        public void status(String value) {
            MainApplet.this.progressMsg = value;
            MainApplet.this.repaint();
        }

        public void done() {
        }

        public boolean hasCancelled() {
            return false;
        }

        public void speed(String value) {
        }

        public void initializeSpeedValue(long totalExpected) {
            MainApplet.this.progressTotal = totalExpected;
            MainApplet.this.progressCompleted = 0L;
        }

        public void incrementSpeedValue(long value) {
            MainApplet.this.progressCompleted += value;
            MainApplet.this.progressPercent = (int)(MainApplet.this.progressCompleted * 100L / MainApplet.this.progressTotal);
            MainApplet.this.repaint();
        }
    };
    Graphics bufferGraphics;
    Image offscreen;

    public void showProgress(String msg, int percent) {
        this.progressMsg = msg;
        this.progressPercent = percent;
        this.repaint();
    }

    public void captureMouse(boolean on) {
        if (MainFrame.robot != null) {
            MainFrame.robotCenter(this.getLocationOnScreen());
        }
    }

    public void showCursor(boolean on) {
        if (on) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(this.transparentCursor);
        }
    }

    public void fullScreenToggle() {
    }

    public void setSize(int width, int height) {
    }

    public void dopaint() {
        this.repaint();
    }

    public void setTitle(String title) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean download(String urlLocation, File location) {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            this.progressMsg = "Downloading " + location.getName();
            this.progressPercent = 0;
            this.repaint();
            if (location.exists()) {
                location.delete();
            }
            if (!location.getParentFile().exists()) {
                location.getParentFile().mkdirs();
            }
            URL url = new URL(urlLocation);
            URLConnection urlc = url.openConnection();
            long size = -1L;
            String s = urlc.getHeaderField("content-length");
            if (s != null) {
                size = Long.parseLong(s);
            }
            bis = new BufferedInputStream(urlc.getInputStream());
            bos = new BufferedOutputStream(new FileOutputStream(location));
            byte[] buffer = new byte[4096];
            int read = 0;
            if (size > 0L) {
                this.progressBar.initializeSpeedValue(size);
            }
            do {
                if ((read = bis.read(buffer)) <= 0) continue;
                this.progressBar.incrementSpeedValue(read);
                ((BufferedOutputStream)bos).write(buffer, 0, read);
            } while (read > 0);
            bis.close();
            bis = null;
            bos.close();
            bos = null;
            if (size > 0L && location.length() != size) {
                System.out.println("FAILED to download file: " + location.getAbsolutePath());
                System.out.println("   expected " + size + " bytes and got " + location.length() + " bytes");
                this.progressMsg = "FAILED to download file: " + urlLocation;
                this.progressPercent = 0;
                this.repaint();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception e) {}
            }
        }
        this.progressMsg = "FAILED to download file: " + urlLocation;
        this.progressPercent = 0;
        this.repaint();
        return false;
    }

    private void unzip(File file, File directory) {
        UnZip.unzip(file.getAbsolutePath(), directory.getAbsolutePath(), this.progressBar);
    }

    private Color parseColorStr(String s) {
        if (s.length() == 7 && s.charAt(0) == '#') {
            try {
                int r = Integer.parseInt(s.substring(1, 3), 16);
                int g = Integer.parseInt(s.substring(3, 5), 16);
                int b = Integer.parseInt(s.substring(5, 7), 16);
                return new Color(r, g, b);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Color.black;
    }

    public void run() {
        String param;
        System.out.println("About to start DosBox");
        for (int i = 1; i < 10; ++i) {
            try {
                String url = this.getParameter("download" + i);
                if (url == null) continue;
                String fullName = url.substring(url.lastIndexOf(47) + 1);
                String name = url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(46));
                File dir = new File(FileHelper.getHomeDirectory() + File.separator + base_dir + File.separator + name);
                if (dir.exists()) continue;
                File downloadFile = new File(FileHelper.getHomeDirectory() + File.separator + base_dir + File.separator + "temp" + File.separator + fullName);
                if (this.download(url, downloadFile)) {
                    this.unzip(downloadFile, dir);
                    downloadFile.delete();
                    continue;
                }
                return;
            }
            catch (Exception e) {
                System.out.println("download parameter should be the url of a .zip or .7z file");
                e.printStackTrace();
            }
        }
        String bg = this.getParameter("background-color");
        if (bg != null) {
            this.backgroundColor = this.parseColorStr(bg);
        }
        this.progressMsg = null;
        this.progressPercent = 0;
        this.repaint();
        Vector<String> params = new Vector<String>();
        params.add("-applet");
        for (int i = 1; i < 10 && (param = this.getParameter("param" + i)) != null; ++i) {
            if (param.startsWith("-")) {
                String[] p = StringHelper.split(param, " ");
                for (int j = 0; j < p.length; ++j) {
                    params.addElement(p[j]);
                }
                continue;
            }
            params.add("-c");
            params.add(param);
        }
        Object[] cmds = new String[params.size()];
        params.copyInto(cmds);
        Main.main(this, (String[])cmds);
    }

    public void init() {
        System.out.println("Applet.init()");
        try {
            if (MainFrame.robot == null) {
                MainFrame.robot = new Robot();
            }
        }
        catch (Throwable e) {
            System.out.println("Applet is not signed");
            System.out.println("    mouse capture will not work");
            System.out.println("    disabling compiler");
            DecodeBlock.compilerEnabled = false;
        }
        if (thread != null) {
            System.out.println("Applet.init force stop");
            this.i_stop();
        }
        this.setBackground(Color.black);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addFocusListener(new FocusListener(){
            private final KeyEventDispatcher altDisabler = new KeyEventDispatcher(){

                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getKeyCode() == 18) {
                        Main.addEvent(e);
                        return true;
                    }
                    return false;
                }
            };

            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.altDisabler);
            }

            public void focusLost(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.altDisabler);
            }
        });
    }

    public void destroy() {
        this.removeKeyListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
    }

    public void start() {
        this.id = ++current_id;
        System.out.println("Applet.start");
        if (thread != null) {
            System.out.println("Applet.start force stop");
            this.i_stop();
        }
        thread = new Thread(this);
        thread.start();
    }

    public void stop() {
        if (this.id == current_id) {
            this.i_stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void i_stop() {
        System.out.println("Applet.stop");
        Object object = Main.pauseMutex;
        synchronized (object) {
            Main.pauseMutex.notify();
        }
        Main.addEvent(null);
        try {
            thread.join(5000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        thread = null;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawProgress(Graphics g, int width, int height) {
        int barHeight = 0;
        int yOffset = 5;
        FontMetrics fm = g.getFontMetrics(g.getFont());
        Rectangle2D rect = fm.getStringBounds(this.progressMsg, g);
        barHeight = (int)(rect.getHeight() * 1.7);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int x = (width - textWidth) / 2;
        int y = height - barHeight + (barHeight - textHeight) / 2 + fm.getAscent();
        int right = width * this.progressPercent / 100;
        g.setColor(Color.white);
        g.fillRect(0, height - barHeight - yOffset, right, barHeight);
        g.setClip(right, 0, width, height);
        g.setColor(Color.yellow);
        g.drawString(this.progressMsg, x, y - yOffset);
        g.setClip(0, 0, right, height);
        g.setColor(Color.black);
        g.drawString(this.progressMsg, x, y - yOffset);
        g.setClip(0, 0, width, height);
    }

    private int getScreenX() {
        if (Main.screen_width < this.getWidth()) {
            return (this.getWidth() - Main.screen_width) / 2;
        }
        return 0;
    }

    private int getScreenY() {
        if (Main.screen_height < this.getHeight()) {
            return (this.getHeight() - Main.screen_height) / 2;
        }
        return 0;
    }

    private void draw(Graphics g) {
        int x = 0;
        int y = 0;
        if (Main.screen_width < this.getWidth()) {
            x = this.getScreenX();
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, x, this.getHeight());
            g.fillRect(x + Main.screen_width, 0, this.getWidth() - (x + Main.screen_width), this.getHeight());
        }
        if (Main.screen_height < this.getHeight()) {
            y = this.getScreenY();
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), y);
            g.fillRect(0, y + Main.screen_height, this.getWidth(), this.getHeight() - (y + Main.screen_height));
        }
        if (Render.render != null && Render.render.aspect && Main.screen_height % Main.buffer_height != 0) {
            BufferedImage resized = MainFrame.resizeImage(Main.buffer, Main.screen_width, Main.screen_height, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(resized, x, y, Main.screen_width + x, Main.screen_height + y, 0, 0, Main.screen_width, Main.screen_height, null);
        } else {
            g.drawImage(Main.buffer, x, y, Main.screen_width + x, Main.screen_height + y, 0, 0, Main.buffer_width, Main.buffer_height, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g) {
        if (Main.buffer != null) {
            Object object = Main.paintMutex;
            synchronized (object) {
                if (this.progressMsg != null) {
                    this.drawProgress(Main.buffer.getGraphics(), Main.screen_width, Main.screen_height);
                }
                this.draw(g);
            }
        } else if (this.progressMsg != null) {
            if (this.bufferGraphics == null) {
                Rectangle r = g.getClipBounds();
                this.offscreen = this.createImage(r.width, r.height);
                this.bufferGraphics = this.offscreen.getGraphics();
            }
            this.bufferGraphics.clearRect(0, 0, this.offscreen.getWidth(null), this.offscreen.getHeight(null));
            this.drawProgress(this.bufferGraphics, this.offscreen.getWidth(null), this.offscreen.getHeight(null));
            g.drawImage(this.offscreen, 0, 0, null);
        }
    }

    public void paint(Graphics g) {
        this.update(g);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Main.addEvent(e);
    }

    public void keyReleased(KeyEvent e) {
        Main.addEvent(e);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 3) {
            Main.GFX_CaptureMouse();
        }
    }

    public void mousePressed(MouseEvent e) {
        Main.addEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        Main.addEvent(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        MainFrame.robotMouse(e, this.getLocationOnScreen(), this.getScreenX(), this.getScreenY());
    }

    public void mouseMoved(MouseEvent e) {
        MainFrame.robotMouse(e, this.getLocationOnScreen(), this.getScreenX(), this.getScreenY());
    }
}

