/*
 * Decompiled with CFR 0.152.
 */
package jdos.gui;

import jdos.gui.Main;
import jdos.gui.Mapper;
import jdos.hardware.Hardware;
import jdos.misc.Log;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.IntRef;
import jdos.util.Ptr;

public class Render {
    public static final int RENDER_USE_ADVANCED_SCALERS = 0;
    public static final int RENDER_SKIP_CACHE = 16;
    public static Render_t render;
    private static Main.GFX_CallBack_t RENDER_CallBack;
    private static Mapper.MAPPER_Handler IncreaseFrameSkip;
    private static Mapper.MAPPER_Handler DecreaseFrameSkip;
    public static Section.SectionFunction RENDER_ShutDown;
    static boolean running;
    public static Section.SectionFunction RENDER_Init;

    private static void Check_Palette() {
        if (Render.render.pal.changed) {
            Render.render.pal.modified.clear();
            Render.render.pal.changed = false;
        }
        if (Render.render.pal.first > Render.render.pal.last) {
            return;
        }
        switch (Render.render.src.bpp) {
            case 8: {
                Main.GFX_SetPalette(Render.render.pal.first, Render.render.pal.last - Render.render.pal.first + 1, Render.render.pal.rgb, Render.render.pal.first);
                break;
            }
            case 15: 
            case 16: {
                for (int i = Render.render.pal.first; i <= Render.render.pal.last; ++i) {
                    short r = Render.render.pal.rgb[i].red;
                    short g = Render.render.pal.rgb[i].green;
                    short b = Render.render.pal.rgb[i].blue;
                    int newPal = Main.GFX_GetRGB(r, g, b);
                    if (newPal == Render.render.pal.lut.b16[i]) continue;
                    Render.render.pal.changed = true;
                    Render.render.pal.modified.set(i, 1);
                    Render.render.pal.lut.b16[i] = (short)newPal;
                }
                break;
            }
            default: {
                for (int i = Render.render.pal.first; i <= Render.render.pal.last; ++i) {
                    short r = Render.render.pal.rgb[i].red;
                    short g = Render.render.pal.rgb[i].green;
                    short b = Render.render.pal.rgb[i].blue;
                    int newPal = Main.GFX_GetRGB(r, g, b);
                    if (newPal == Render.render.pal.lut.b32[i]) continue;
                    Render.render.pal.changed = true;
                    Render.render.pal.modified.set(i, 1);
                    Render.render.pal.lut.b32[i] = newPal;
                }
            }
        }
        Render.render.pal.first = 256;
        Render.render.pal.last = 0;
    }

    public static void RENDER_SetPal(int entry, int red, int green, int blue) {
        Render.render.pal.rgb[entry].red = (short)red;
        Render.render.pal.rgb[entry].green = (short)green;
        Render.render.pal.rgb[entry].blue = (short)blue;
        if (Render.render.pal.first > entry) {
            Render.render.pal.first = entry;
        }
        if (Render.render.pal.last < entry) {
            Render.render.pal.last = entry;
        }
    }

    public static boolean RENDER_StartUpdate() {
        if (Render.render.updating) {
            return false;
        }
        if (!Render.render.active) {
            return false;
        }
        if (Render.render.frameskip.count < Render.render.frameskip.max) {
            ++Render.render.frameskip.count;
            return false;
        }
        Render.render.frameskip.count = 0;
        if (Render.render.src.bpp == 8) {
            Render.Check_Palette();
        }
        int[][] outWrite = new int[1][];
        IntRef outPitch = new IntRef(Render.render.src.outPitch);
        Main.GFX_StartUpdate(outWrite, outPitch);
        Render.render.src.outPitch = outPitch.value;
        Render.render.src.outWrite = outWrite[0];
        Render.render.src.outWriteOff = 0;
        Render.render.fullFrame = true;
        Render.render.updating = true;
        return true;
    }

    private static void RENDER_Halt() {
        Main.GFX_EndUpdate();
        Render.render.updating = false;
        Render.render.active = false;
    }

    public static void RENDER_EndUpdate(boolean abort) {
        if (!Render.render.updating) {
            return;
        }
        if ((Hardware.CaptureState & 0x18) != 0) {
            int flags = 0;
            if (Render.render.src.dblw != Render.render.src.dblh) {
                if (Render.render.src.dblw) {
                    flags |= 1;
                }
                if (Render.render.src.dblh) {
                    flags |= 2;
                }
            }
            float fps = Render.render.src.fps;
            int pitch = Render.render.src.outPitch;
            if (Render.render.frameskip.max != 0) {
                fps /= (float)(1 + Render.render.frameskip.max);
            }
            Hardware.CAPTURE_AddImage(Render.render.src.width, Render.render.src.height, Render.render.src.bpp, pitch, flags, fps, Render.render.src.outWrite, Render.render.pal.rgb);
        }
        if (Render.render.src.outWrite != null) {
            Main.GFX_EndUpdate();
            Render.render.frameskip.hadSkip[Render.render.frameskip.index] = false;
        }
        Render.render.frameskip.index = Render.render.frameskip.index + 1 & 0xF;
        Render.render.updating = false;
    }

    private static void RENDER_Reset() {
        int width = Render.render.src.width;
        int height = Render.render.src.height;
        if (Render.render.src.dblw) {
            width *= 2;
        }
        if (Render.render.src.dblh) {
            height *= 2;
        }
        Main.GFX_SetSize(width, height, RENDER_CallBack);
        Render.render.pal.first = 0;
        Render.render.pal.last = 255;
        Render.render.pal.changed = false;
        Render.render.pal.modified.clear();
        Render.render.src.outWrite = null;
        Render.render.active = true;
    }

    public static void RENDER_SetSize(int width, int height, int bpp, float fps, double ratio, boolean dblw, boolean dblh) {
        Render.RENDER_Halt();
        if (width == 0 || height == 0) {
            return;
        }
        if (ratio > 1.0) {
            double target = (double)height * ratio + 0.1;
            ratio = target / (double)height;
        }
        Render.render.src.width = width;
        Render.render.src.height = height;
        Render.render.src.bpp = bpp;
        Render.render.src.dblw = dblw;
        Render.render.src.dblh = dblh;
        Render.render.src.fps = fps;
        Render.render.src.ratio = ratio;
        Render.RENDER_Reset();
    }

    static {
        RENDER_CallBack = new Main.GFX_CallBack_t(){

            public void call(int function) {
                if (function == 1) {
                    Render.RENDER_Halt();
                } else if (function != 2) {
                    if (function == 0) {
                        Main.GFX_EndUpdate();
                        Render.RENDER_Reset();
                    } else {
                        Log.exit("Unhandled GFX_CallBackReset " + function);
                    }
                }
            }
        };
        IncreaseFrameSkip = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (!pressed) {
                    return;
                }
                if (Render.render.frameskip.max < 10) {
                    ++Render.render.frameskip.max;
                }
                Log.log_msg("Frame Skip at " + Render.render.frameskip.max);
                Main.GFX_SetTitle(-1, Render.render.frameskip.max, false);
            }
        };
        DecreaseFrameSkip = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (!pressed) {
                    return;
                }
                if (Render.render.frameskip.max > 0) {
                    --Render.render.frameskip.max;
                }
                Log.log_msg("Frame Skip at " + Render.render.frameskip.max);
                Main.GFX_SetTitle(-1, Render.render.frameskip.max, false);
            }
        };
        RENDER_ShutDown = new Section.SectionFunction(){

            public void call(Section sec) {
                render = null;
                running = false;
            }
        };
        running = false;
        RENDER_Init = new Section.SectionFunction(){

            public void call(Section sec) {
                Section_prop section = (Section_prop)sec;
                render = new Render_t();
                Render.render.pal.first = 256;
                Render.render.pal.last = 0;
                Render.render.aspect = section.Get_bool("aspect");
                Render.render.frameskip.max = section.Get_int("frameskip");
                if (Render.render.frameskip.max < 0) {
                    Render.render.frameskip.max = 0;
                    Render.render.frameskip.auto = true;
                }
                Render.render.frameskip.count = 0;
                if (!running) {
                    Render.render.updating = true;
                }
                running = true;
                Mapper.MAPPER_AddHandler(DecreaseFrameSkip, 6, 1, "decfskip", "Dec Fskip");
                Mapper.MAPPER_AddHandler(IncreaseFrameSkip, 7, 1, "incfskip", "Inc Fskip");
                Main.GFX_SetTitle(-1, Render.render.frameskip.max, false);
                section.AddDestroyFunction(RENDER_ShutDown);
            }
        };
    }

    public static class Render_t {
        public SRC src = new SRC();
        public Frameskip frameskip = new Frameskip();
        public RenderPal_t pal = new RenderPal_t();
        public boolean updating;
        public boolean active;
        public boolean aspect;
        public boolean fullFrame;

        public static class Frameskip {
            public int count;
            public int max;
            public int index;
            public boolean auto;
            public boolean[] hadSkip = new boolean[16];
        }

        public static class SRC {
            public int width;
            public int start;
            public int height;
            public int bpp;
            public boolean dblw;
            public boolean dblh;
            public double ratio;
            public float fps;
            public int outPitch;
            public int[] outWrite;
            public int outWriteOff;
        }
    }

    public static class RenderPal_t {
        RGB[] rgb = new RGB[256];
        public LUT lut = new LUT();
        public boolean changed;
        public Ptr modified = new Ptr(256);
        int first;
        int last;

        public RenderPal_t() {
            for (int i = 0; i < this.rgb.length; ++i) {
                this.rgb[i] = new RGB();
            }
        }

        public static class LUT {
            public short[] b16 = new short[256];
            public int[] b32 = new int[256];
        }

        public static class RGB {
            public short red;
            public short green;
            public short blue;
            public short unused;
        }
    }
}

