/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.cpu.Paging;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;

public class DMA
extends Module_base {
    private static long dma_wrapping = 65535L;
    private static DmaController[] DmaControllers = new DmaController[2];
    private static final int EMM_PAGEFRAME4K = 224;
    private static long[] ems_board_mapping = new long[272];
    private static IoHandler.IO_WriteHandler DMA_Write_Port = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            if (port < 16) {
                DmaControllers[0].WriteControllerReg(port, val, 1);
            } else if (port >= 192 && port <= 223) {
                DmaControllers[1].WriteControllerReg(port - 192 >> 1, val, 1);
            } else {
                DMA.UpdateEMSMapping();
                switch (port) {
                    case 129: {
                        DMA.GetDMAChannel(2).SetPage((short)val);
                        break;
                    }
                    case 130: {
                        DMA.GetDMAChannel(3).SetPage((short)val);
                        break;
                    }
                    case 131: {
                        DMA.GetDMAChannel(1).SetPage((short)val);
                        break;
                    }
                    case 137: {
                        DMA.GetDMAChannel(6).SetPage((short)val);
                        break;
                    }
                    case 138: {
                        DMA.GetDMAChannel(7).SetPage((short)val);
                        break;
                    }
                    case 139: {
                        DMA.GetDMAChannel(5).SetPage((short)val);
                    }
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler DMA_Read_Port = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            if (port < 16) {
                return DmaControllers[0].ReadControllerReg(port, iolen);
            }
            if (port >= 192 && port <= 223) {
                return DmaControllers[1].ReadControllerReg(port - 192 >> 1, iolen);
            }
            switch (port) {
                case 129: {
                    return DMA.GetDMAChannel((int)2).pagenum;
                }
                case 130: {
                    return DMA.GetDMAChannel((int)3).pagenum;
                }
                case 131: {
                    return DMA.GetDMAChannel((int)1).pagenum;
                }
                case 137: {
                    return DMA.GetDMAChannel((int)6).pagenum;
                }
                case 138: {
                    return DMA.GetDMAChannel((int)7).pagenum;
                }
                case 139: {
                    return DMA.GetDMAChannel((int)5).pagenum;
                }
            }
            return 0;
        }
    };
    private static DMA test;
    public static Section.SectionFunction DMA_Destroy;
    public static Section.SectionFunction DMA_Init;

    private static void UpdateEMSMapping() {
        for (int i = 0; i < 16; ++i) {
            DMA.ems_board_mapping[224 + i] = Paging.paging.firstmb[224 + i];
        }
    }

    private static void DMA_BlockRead(int spage, int offset, short[] data, int dataOffset, int size) {
        int highpart_addr_page = spage >> 12;
        int dma16 = 1;
        size <<= dma16;
        offset <<= dma16;
        long dma_wrap = (long)((65535 << dma16) + dma16) | dma_wrapping;
        boolean left = true;
        while (size != 0) {
            int page;
            if ((long)offset > dma_wrapping << dma16) {
                Log.log_msg("DMA segbound wrapping (read): " + Long.toString(spage, 16) + ":" + Integer.toString(offset, 16) + " size " + Integer.toString(size, 16) + " [1] wrap " + Long.toString(dma_wrapping, 16));
            }
            if ((page = highpart_addr_page + ((offset = (int)((long)offset & dma_wrap)) >>> 12)) < 224) {
                page = (int)Paging.paging.firstmb[page];
            } else if (page < 240) {
                page = (int)ems_board_mapping[page];
            } else if (page < 272) {
                page = (int)Paging.paging.firstmb[page];
            }
            if (left) {
                data[dataOffset] = Memory.phys_readb(page * 4096 + (offset & 0xFFF));
            } else {
                int n = dataOffset++;
                data[n] = (short)(data[n] | Memory.phys_readb(page * 4096 + (offset & 0xFFF)) << 8);
            }
            left = !left;
            --size;
            ++offset;
        }
    }

    private static void DMA_BlockRead(int spage, int offset, byte[] data, int dataOffset, int size) {
        int highpart_addr_page = spage >>> 12;
        long dma_wrap = 65535L;
        while (size != 0) {
            int page;
            if ((long)offset > dma_wrapping) {
                Log.log_msg("DMA segbound wrapping (read): " + Long.toString(spage, 16) + ":" + Integer.toString(offset, 16) + " size " + Integer.toString(size, 16) + " [0] wrap " + Long.toString(dma_wrapping, 16));
            }
            if ((page = highpart_addr_page + ((offset = (int)((long)offset & dma_wrap)) >>> 12)) < 224) {
                page = (int)Paging.paging.firstmb[page];
            } else if (page < 240) {
                page = (int)ems_board_mapping[page];
            } else if (page < 272) {
                page = (int)Paging.paging.firstmb[page];
            }
            data[dataOffset++] = Memory.host_readbs(page * 4096 + (offset & 0xFFF));
            --size;
            ++offset;
        }
    }

    static void DMA_BlockWrite(int spage, int offset, byte[] data, int data_offset, int size, short dma16) {
        int highpart_addr_page = spage >> 12;
        size <<= dma16;
        offset <<= dma16;
        long dma_wrap = (long)((65535 << dma16) + dma16) | dma_wrapping;
        int i = 0;
        while (size != 0) {
            int page;
            if ((long)offset > dma_wrapping << dma16) {
                Log.log_msg("DMA segbound wrapping (write): " + Long.toString(spage, 16) + ":" + Long.toString(offset, 16) + " size " + Integer.toString(size, 16) + " [" + dma16 + "] wrap " + Long.toString(dma_wrapping, 16));
            }
            if ((page = highpart_addr_page + ((offset = (int)((long)offset & dma_wrap)) >>> 12)) < 224) {
                page = (int)Paging.paging.firstmb[page];
            } else if (page < 240) {
                page = (int)ems_board_mapping[page];
            } else if (page < 272) {
                page = (int)Paging.paging.firstmb[page];
            }
            Memory.phys_writeb(page * 4096 + (offset & 0xFFF), data[data_offset + i]);
            --size;
            ++offset;
            ++i;
        }
    }

    public static DmaChannel GetDMAChannel(int chan) {
        if (chan < 4) {
            if (DmaControllers[0] != null) {
                return DmaControllers[0].GetChannel(chan);
            }
        } else if (chan < 8 && DmaControllers[1] != null) {
            return DmaControllers[1].GetChannel(chan - 4);
        }
        return null;
    }

    public static void CloseSecondDMAController() {
        if (DmaControllers[1] != null) {
            DMA.DmaControllers[1] = null;
        }
    }

    public static boolean SecondDMAControllerAvailable() {
        return DmaControllers[1] != null;
    }

    public static void DMA_SetWrapping(int wrap) {
        dma_wrapping = wrap;
    }

    public DMA(Section configuration) {
        super(configuration);
        DMA.DmaControllers[0] = new DmaController(0);
        DMA.DmaControllers[1] = Dosbox.IS_EGAVGA_ARCH() ? new DmaController(1) : null;
        for (int i = 0; i < 16; ++i) {
            int mask = 1;
            if (i < 8) {
                mask |= 2;
            }
            DMA.DmaControllers[0].DMA_WriteHandler[i].Install(i, DMA_Write_Port, mask);
            DMA.DmaControllers[0].DMA_ReadHandler[i].Install(i, DMA_Read_Port, mask);
            if (!Dosbox.IS_EGAVGA_ARCH()) continue;
            DMA.DmaControllers[1].DMA_WriteHandler[i].Install(192 + i * 2, DMA_Write_Port, mask);
            DMA.DmaControllers[1].DMA_ReadHandler[i].Install(192 + i * 2, DMA_Read_Port, mask);
        }
        DMA.DmaControllers[0].DMA_WriteHandler[16].Install(129, DMA_Write_Port, 1, 3);
        DMA.DmaControllers[0].DMA_ReadHandler[16].Install(129, DMA_Read_Port, 1, 3);
        if (Dosbox.IS_EGAVGA_ARCH()) {
            DMA.DmaControllers[1].DMA_WriteHandler[16].Install(137, DMA_Write_Port, 1, 3);
            DMA.DmaControllers[1].DMA_ReadHandler[16].Install(137, DMA_Read_Port, 1, 3);
        }
    }

    static {
        DMA_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                test = null;
            }
        };
        DMA_Init = new Section.SectionFunction(){

            public void call(Section section) {
                DMA.DMA_SetWrapping(65535);
                test = new DMA(section);
                section.AddDestroyFunction(DMA_Destroy);
                for (int i = 0; i < 272; ++i) {
                    ems_board_mapping[i] = i;
                }
            }
        };
    }

    public static class DmaController {
        private short ctrlnum;
        private boolean flipflop = false;
        private DmaChannel[] DmaChannels = new DmaChannel[4];
        public IoHandler.IO_ReadHandleObject[] DMA_ReadHandler = new IoHandler.IO_ReadHandleObject[17];
        public IoHandler.IO_WriteHandleObject[] DMA_WriteHandler = new IoHandler.IO_WriteHandleObject[17];

        public DmaController(int num) {
            int i;
            this.ctrlnum = (short)num;
            for (i = 0; i < 4; i = (int)((short)(i + 1))) {
                this.DmaChannels[i] = new DmaChannel(i + this.ctrlnum * 4, this.ctrlnum == 1);
            }
            for (i = 0; i < this.DMA_ReadHandler.length; ++i) {
                this.DMA_ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
            }
            for (i = 0; i < this.DMA_WriteHandler.length; ++i) {
                this.DMA_WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
            }
        }

        public DmaChannel GetChannel(int chan) {
            if (chan < 4) {
                return this.DmaChannels[chan];
            }
            return null;
        }

        public void WriteControllerReg(int reg, int val, int len) {
            switch (reg) {
                case 0: 
                case 2: 
                case 4: 
                case 6: {
                    DMA.UpdateEMSMapping();
                    DmaChannel chan = this.GetChannel((short)(reg >> 1));
                    boolean bl = this.flipflop = !this.flipflop;
                    if (this.flipflop) {
                        chan.baseaddr = chan.baseaddr & 0xFF00 | val;
                        chan.curraddr = chan.curraddr & 0xFF00 | val;
                        break;
                    }
                    chan.baseaddr = chan.baseaddr & 0xFF | val << 8;
                    chan.curraddr = chan.curraddr & 0xFF | val << 8;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    DMA.UpdateEMSMapping();
                    DmaChannel chan = this.GetChannel((short)(reg >> 1));
                    boolean bl = this.flipflop = !this.flipflop;
                    if (this.flipflop) {
                        chan.basecnt = chan.basecnt & 0xFF00 | val;
                        chan.currcnt = chan.currcnt & 0xFF00 | val;
                        break;
                    }
                    chan.basecnt = chan.basecnt & 0xFF | val << 8;
                    chan.currcnt = chan.currcnt & 0xFF | val << 8;
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    if ((val & 4) == 0) {
                        DMA.UpdateEMSMapping();
                    }
                    DmaChannel chan = this.GetChannel((short)(val & 3));
                    chan.SetMask((val & 4) > 0);
                    break;
                }
                case 11: {
                    DMA.UpdateEMSMapping();
                    DmaChannel chan = this.GetChannel((short)(val & 3));
                    chan.autoinit = (val & 0x10) > 0;
                    chan.increment = (val & 0x20) > 0;
                    break;
                }
                case 12: {
                    this.flipflop = false;
                    break;
                }
                case 13: {
                    for (int ct = 0; ct < 4; ct = (int)((short)(ct + 1))) {
                        DmaChannel chan = this.GetChannel(ct);
                        chan.SetMask(true);
                        chan.tcount = false;
                    }
                    this.flipflop = false;
                    break;
                }
                case 14: {
                    DMA.UpdateEMSMapping();
                    for (int ct = 0; ct < 4; ct = (int)((short)(ct + 1))) {
                        DmaChannel chan = this.GetChannel(ct);
                        chan.SetMask(false);
                    }
                    break;
                }
                case 15: {
                    DMA.UpdateEMSMapping();
                    for (int ct = 0; ct < 4; ct = (int)((short)(ct + 1))) {
                        DmaChannel chan = this.GetChannel(ct);
                        chan.SetMask((val & 1) != 0);
                        val >>= 1;
                    }
                    break;
                }
            }
        }

        public int ReadControllerReg(int reg, int len) {
            switch (reg) {
                case 0: 
                case 2: 
                case 4: 
                case 6: {
                    DmaChannel chan = this.GetChannel((short)(reg >> 1));
                    boolean bl = this.flipflop = !this.flipflop;
                    if (this.flipflop) {
                        return chan.curraddr & 0xFF;
                    }
                    return chan.curraddr >> 8 & 0xFF;
                }
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    DmaChannel chan = this.GetChannel((short)(reg >> 1));
                    boolean bl = this.flipflop = !this.flipflop;
                    if (this.flipflop) {
                        return chan.currcnt & 0xFF;
                    }
                    return chan.currcnt >> 8 & 0xFF;
                }
                case 8: {
                    int ret = 0;
                    for (int ct = 0; ct < 4; ct = (int)((short)(ct + 1))) {
                        DmaChannel chan = this.GetChannel(ct);
                        if (chan.tcount) {
                            ret |= 1 << ct;
                        }
                        chan.tcount = false;
                        if (!chan.request) continue;
                        ret |= 1 << 4 + ct;
                    }
                    return ret;
                }
            }
            return -1;
        }
    }

    public static class DmaChannel {
        public int pagebase;
        public int baseaddr;
        public int curraddr;
        public int basecnt;
        public int currcnt;
        public short channum;
        public short pagenum;
        public short DMA16;
        public boolean increment;
        public boolean autoinit;
        public short trantype;
        public boolean masked = true;
        public boolean tcount;
        public boolean request;
        public DMA_CallBack callback = null;

        public DmaChannel(int num, boolean dma16) {
            if (num == 4) {
                return;
            }
            this.channum = (short)num;
            this.DMA16 = (short)(dma16 ? 1 : 0);
            this.pagenum = 0;
            this.pagebase = 0;
            this.baseaddr = 0;
            this.curraddr = 0;
            this.basecnt = 0;
            this.currcnt = 0;
            this.increment = true;
            this.autoinit = false;
            this.tcount = false;
            this.request = false;
        }

        public void DoCallBack(int event) {
            if (this.callback != null) {
                this.callback.call(this, event);
            }
        }

        public void SetMask(boolean _mask) {
            this.masked = _mask;
            this.DoCallBack(this.masked ? 1 : 2);
        }

        public void Register_Callback(DMA_CallBack _cb) {
            this.callback = _cb;
            this.SetMask(this.masked);
            if (this.callback != null) {
                this.Raise_Request();
            } else {
                this.Clear_Request();
            }
        }

        public void ReachedTC() {
            this.tcount = true;
            this.DoCallBack(0);
        }

        public void SetPage(short val) {
            this.pagenum = val;
            this.pagebase = this.pagenum >> this.DMA16 << 16 + this.DMA16;
        }

        public void Raise_Request() {
            this.request = true;
        }

        public void Clear_Request() {
            this.request = false;
        }

        public int Read(int want, byte[] buffer, int bufferOffset) {
            int done;
            block2: {
                int left;
                block3: {
                    done = 0;
                    this.curraddr = (int)((long)this.curraddr & dma_wrapping);
                    do {
                        if (want < (left = this.currcnt + 1)) {
                            DMA.DMA_BlockRead(this.pagebase, this.curraddr, buffer, bufferOffset, want);
                            done += want;
                            this.curraddr += want;
                            this.currcnt -= want;
                            break block2;
                        }
                        DMA.DMA_BlockRead(this.pagebase, this.curraddr, buffer, bufferOffset, want);
                        bufferOffset += left;
                        want -= left;
                        done += left;
                        this.ReachedTC();
                        if (!this.autoinit) break block3;
                        this.currcnt = this.basecnt;
                        this.curraddr = this.baseaddr;
                    } while (want != 0);
                    DMA.UpdateEMSMapping();
                    break block2;
                }
                this.curraddr += left;
                this.currcnt = 65535;
                this.masked = true;
                DMA.UpdateEMSMapping();
                this.DoCallBack(3);
            }
            return done;
        }

        public int Read(int want, short[] buffer, int bufferOffset) {
            int done;
            block2: {
                int left;
                block3: {
                    done = 0;
                    this.curraddr = (int)((long)this.curraddr & dma_wrapping);
                    do {
                        if (want < (left = this.currcnt + 1)) {
                            DMA.DMA_BlockRead(this.pagebase, this.curraddr, buffer, bufferOffset, want);
                            done += want;
                            this.curraddr += want;
                            this.currcnt -= want;
                            break block2;
                        }
                        DMA.DMA_BlockRead(this.pagebase, this.curraddr, buffer, bufferOffset, want);
                        bufferOffset += left;
                        want -= left;
                        done += left;
                        this.ReachedTC();
                        if (!this.autoinit) break block3;
                        this.currcnt = this.basecnt;
                        this.curraddr = this.baseaddr;
                    } while (want != 0);
                    DMA.UpdateEMSMapping();
                    break block2;
                }
                this.curraddr += left;
                this.currcnt = 65535;
                this.masked = true;
                DMA.UpdateEMSMapping();
                this.DoCallBack(3);
            }
            return done;
        }

        public int Write(int want, byte[] buffer, int offset) {
            int done;
            block2: {
                int left;
                block3: {
                    done = 0;
                    this.curraddr = (int)((long)this.curraddr & dma_wrapping);
                    do {
                        if (want < (left = this.currcnt + 1)) {
                            DMA.DMA_BlockWrite(this.pagebase, this.curraddr, buffer, offset, want, this.DMA16);
                            done += want;
                            this.curraddr += want;
                            this.currcnt -= want;
                            break block2;
                        }
                        DMA.DMA_BlockWrite(this.pagebase, this.curraddr, buffer, offset, left, this.DMA16);
                        offset += left << this.DMA16;
                        want -= left;
                        done += left;
                        this.ReachedTC();
                        if (!this.autoinit) break block3;
                        this.currcnt = this.basecnt;
                        this.curraddr = this.baseaddr;
                    } while (want != 0);
                    DMA.UpdateEMSMapping();
                    break block2;
                }
                this.curraddr += left;
                this.currcnt = 65535;
                this.masked = true;
                DMA.UpdateEMSMapping();
                this.DoCallBack(3);
            }
            return done;
        }
    }

    public static interface DMA_CallBack {
        public void call(DmaChannel var1, int var2);
    }

    public static final class DMAEvent {
        public static final int DMA_REACHED_TC = 0;
        public static final int DMA_MASKED = 1;
        public static final int DMA_UNMASKED = 2;
        public static final int DMA_TRANSFEREND = 3;
    }
}

