/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import java.util.Arrays;
import jdos.hardware.Adlib;
import jdos.hardware.Mixer;

public class DbOPL {
    private static final int WAVE_HANDLER = 10;
    private static final int WAVE_TABLELOG = 11;
    private static final int WAVE_TABLEMUL = 12;
    private static final int DBOPL_WAVE = 12;
    private static final double OPLRATE = 49715.90277777778;
    private static final int TREMOLO_TABLE = 52;
    private static final boolean WAVE_PRECISION = false;
    private static final int WAVE_BITS = 10;
    private static final int WAVE_SH = 22;
    private static final int WAVE_MASK = 0x3FFFFF;
    private static final int LFO_SH = 12;
    private static final int LFO_MAX = 0x100000;
    private static final int ENV_BITS = 9;
    private static final int ENV_MIN = 0;
    private static final int ENV_EXTRA = 0;
    private static final int ENV_MAX = 511;
    private static final int ENV_LIMIT = 384;
    private static final int RATE_SH = 24;
    private static final int RATE_MASK = 0xFFFFFF;
    private static final int MUL_SH = 16;
    private static final byte[] KslCreateTable = new byte[]{64, 32, 24, 19, 16, 12, 11, 10, 8, 6, 5, 4, 3, 2, 1, 0};
    private static final byte[] FreqCreateTable = new byte[]{1, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 20, 24, 24, 30, 30};
    private static final byte[] AttackSamplesTable = new byte[]{69, 55, 46, 40, 35, 29, 23, 20, 19, 15, 11, 10, 9};
    private static final byte[] EnvelopeIncreaseTable = new byte[]{4, 5, 6, 7, 8, 10, 12, 14, 16, 20, 24, 28, 32};
    static int[] ExpTable;
    static int[] SinTable;
    private static final short[] WaveTable;
    private static final short[] WaveBaseTable;
    private static final short[] WaveMaskTable;
    private static final short[] WaveStartTable;
    private static final int[] MulTable;
    private static final short[] KslTable;
    private static final short[] TremoloTable;
    private static final int[] ChanOffsetTable;
    private static final int[] OpOffsetTable;
    private static final byte[] VibratoTable;
    private static final byte[] KslShiftTable;
    private static final int sm2AM = 0;
    private static final int sm2FM = 1;
    private static final int sm3AM = 2;
    private static final int sm3FM = 3;
    private static final int sm4Start = 4;
    private static final int sm3FMFM = 5;
    private static final int sm3AMFM = 6;
    private static final int sm3FMAM = 7;
    private static final int sm3AMAM = 8;
    private static final int sm6Start = 9;
    private static final int sm2Percussion = 10;
    private static final int sm3Percussion = 11;
    private static int SynthMode;
    private static final int SHIFT_KSLBASE = 16;
    private static final int SHIFT_KEYCODE = 24;
    private static final double PI = Math.PI;
    private static final WaveHandler WaveForm0;
    private static final WaveHandler WaveForm1;
    private static final WaveHandler WaveForm2;
    private static final WaveHandler WaveForm3;
    private static final WaveHandler WaveForm4;
    private static final WaveHandler WaveForm5;
    private static final WaveHandler WaveForm6;
    private static final WaveHandler WaveForm7;
    private static final WaveHandler[] WaveHandlerTable;
    private static boolean doneTables;

    private static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    private static boolean ENV_SILENT(int _X_) {
        return _X_ >= 384;
    }

    private static int MakeVolume(int wave, int volume) {
        int total = wave + volume;
        int index = total & 0xFF;
        int sig = ExpTable[index];
        int exp = total >> 8;
        return sig >> exp;
    }

    private static void InitTables() {
        int i;
        int i2;
        if (doneTables) {
            return;
        }
        doneTables = true;
        for (i2 = 0; i2 < 384; ++i2) {
            int s = i2 * 8;
            double val = 0.5 + Math.pow(2.0, -1.0 + (double)(255 - s) * 0.00390625) * 65536.0;
            DbOPL.MulTable[i2] = (int)val;
        }
        for (i2 = 0; i2 < 512; ++i2) {
            DbOPL.WaveTable[512 + i2] = (short)(Math.sin(((double)i2 + 0.5) * 0.006135923151542565) * 4084.0);
            DbOPL.WaveTable[0 + i2] = -WaveTable[512 + i2];
        }
        for (i2 = 0; i2 < 256; ++i2) {
            DbOPL.WaveTable[1792 + i2] = (short)(0.5 + Math.pow(2.0, -1.0 + (double)(255 - i2 * 8) * 0.00390625) * 4085.0);
            DbOPL.WaveTable[1791 - i2] = -WaveTable[1792 + i2];
        }
        for (i2 = 0; i2 < 256; ++i2) {
            DbOPL.WaveTable[1024 + i2] = WaveTable[0];
            DbOPL.WaveTable[1280 + i2] = WaveTable[0];
            DbOPL.WaveTable[2304 + i2] = WaveTable[0];
            DbOPL.WaveTable[3072 + i2] = WaveTable[0];
            DbOPL.WaveTable[3328 + i2] = WaveTable[0];
            DbOPL.WaveTable[2048 + i2] = WaveTable[512 + i2];
            DbOPL.WaveTable[2560 + i2] = WaveTable[512 + i2 * 2];
            DbOPL.WaveTable[2816 + i2] = WaveTable[0 + i2 * 2];
            DbOPL.WaveTable[3584 + i2] = WaveTable[512 + i2 * 2];
            DbOPL.WaveTable[3840 + i2] = WaveTable[512 + i2 * 2];
        }
        for (int oct = 0; oct < 8; ++oct) {
            int base = oct * 8;
            for (int i3 = 0; i3 < 16; ++i3) {
                int val = base - KslCreateTable[i3];
                if (val < 0) {
                    val = 0;
                }
                DbOPL.KslTable[oct * 16 + i3] = (short)(val * 4);
            }
        }
        for (i2 = 0; i2 < 26; i2 = (int)((short)(i2 + 1))) {
            short val;
            DbOPL.TremoloTable[i2] = val = (short)(i2 << 0);
            DbOPL.TremoloTable[51 - i2] = val;
        }
        Object chip = null;
        for (i = 0; i < 32; ++i) {
            int index = i & 0xF;
            if (index >= 9) {
                DbOPL.ChanOffsetTable[i] = -1;
                continue;
            }
            if (index < 6) {
                index = index % 3 * 2 + index / 3;
            }
            if (i >= 16) {
                index += 9;
            }
            DbOPL.ChanOffsetTable[i] = index;
        }
        for (i = 0; i < 64; ++i) {
            if (i % 8 >= 6 || i / 8 % 4 == 3) {
                DbOPL.OpOffsetTable[i] = -1;
                continue;
            }
            int chNum = i / 8 * 3 + i % 8 % 3;
            if (chNum >= 12) {
                chNum += 4;
            }
            int opNum = i % 8 / 3;
            Object chan = null;
            DbOPL.OpOffsetTable[i] = ChanOffsetTable[chNum] | opNum << 16;
        }
    }

    static {
        WaveTable = new short[4096];
        MulTable = new int[384];
        WaveBaseTable = new short[]{0, 512, 512, 2048, 2560, 3072, 256, 1024};
        WaveMaskTable = new short[]{1023, 1023, 511, 511, 1023, 1023, 512, 1023};
        WaveStartTable = new short[]{512, 0, 0, 0, 0, 512, 512, 256};
        KslTable = new short[128];
        TremoloTable = new short[52];
        ChanOffsetTable = new int[32];
        OpOffsetTable = new int[64];
        VibratoTable = new byte[]{1, 0, 1, 30, -127, -128, -127, -98};
        KslShiftTable = new byte[]{31, 1, 2, 0};
        WaveForm0 = new WaveHandler(){

            public int call(int i, int volume) {
                int neg = 0 - (i >> 9 & 1);
                int wave = SinTable[i & 0x1FF];
                return (DbOPL.MakeVolume(wave, volume) ^ neg) - neg;
            }
        };
        WaveForm1 = new WaveHandler(){

            public int call(int i, int volume) {
                int wave = SinTable[i & 0x1FF];
                return DbOPL.MakeVolume(wave |= ((i ^ 0x200) & 0x200) - 1 >> 20, volume);
            }
        };
        WaveForm2 = new WaveHandler(){

            public int call(int i, int volume) {
                int wave = SinTable[i & 0x1FF];
                return DbOPL.MakeVolume(wave, volume);
            }
        };
        WaveForm3 = new WaveHandler(){

            public int call(int i, int volume) {
                int wave = SinTable[i & 0xFF];
                return DbOPL.MakeVolume(wave |= ((i ^ 0x100) & 0x100) - 1 >> 20, volume);
            }
        };
        WaveForm4 = new WaveHandler(){

            public int call(int i, int volume) {
                int neg = 0 - ((i <<= 1) >> 9 & 1);
                int wave = SinTable[i & 0x1FF];
                return (DbOPL.MakeVolume(wave |= ((i ^ 0x200) & 0x200) - 1 >> 20, volume) ^ neg) - neg;
            }
        };
        WaveForm5 = new WaveHandler(){

            public int call(int i, int volume) {
                int wave = SinTable[(i <<= 1) & 0x1FF];
                return DbOPL.MakeVolume(wave |= ((i ^ 0x200) & 0x200) - 1 >> 20, volume);
            }
        };
        WaveForm6 = new WaveHandler(){

            public int call(int i, int volume) {
                int neg = 0 - (i >> 9 & 1);
                return (DbOPL.MakeVolume(0, volume) ^ neg) - neg;
            }
        };
        WaveForm7 = new WaveHandler(){

            public int call(int i, int volume) {
                int neg = (i >> 9 & 1) - 1;
                int wave = i << 3;
                wave = (wave ^ neg) - neg & 0xFFF;
                return (DbOPL.MakeVolume(wave, volume) ^ neg) - neg;
            }
        };
        WaveHandlerTable = new WaveHandler[]{WaveForm0, WaveForm1, WaveForm2, WaveForm3, WaveForm4, WaveForm5, WaveForm6, WaveForm7};
        doneTables = false;
    }

    public static final class Handler
    implements Adlib.Handler {
        Chip chip = new Chip();
        int[] buffer = new int[1024];

        public long WriteAddr(int port, short val) {
            return this.chip.WriteAddr(port, val);
        }

        public void WriteReg(int addr, short val) {
            this.chip.WriteReg(addr, val);
        }

        public void Generate(Mixer.MixerChannel chan, int samples) {
            if (samples > 512) {
                samples = 512;
            }
            if (this.chip.opl3Active == 0) {
                this.chip.GenerateBlock2(samples, this.buffer, 0);
                chan.AddSamples_m32(samples, this.buffer);
            } else {
                this.chip.GenerateBlock3(samples, this.buffer, 0);
                chan.AddSamples_s32(samples, this.buffer);
            }
        }

        public void Init(long rate) {
            DbOPL.InitTables();
            this.chip.Setup(rate);
        }
    }

    private static class Chip {
        int lfoCounter;
        int lfoAdd;
        long noiseCounter;
        long noiseAdd;
        int noiseValue;
        int[] freqMul = new int[16];
        int[] linearRates = new int[76];
        int[] attackRates = new int[76];
        Channel[] chan = new Channel[19];
        short reg104 = 0;
        short reg08 = 0;
        short reg04 = 0;
        short regBD = 0;
        short vibratoIndex;
        short tremoloIndex;
        byte vibratoSign;
        short vibratoShift;
        short tremoloValue;
        short vibratoStrength;
        short tremoloStrength;
        short waveFormMask;
        byte opl3Active = 0;

        Chip() {
            for (int i = 0; i < this.chan.length; ++i) {
                this.chan[i] = new Channel(this, i);
            }
        }

        int ForwardLFO(int samples) {
            this.vibratoSign = (byte)(VibratoTable[this.vibratoIndex >> 2] >> 7);
            this.vibratoShift = (short)((VibratoTable[this.vibratoIndex >> 2] & 7) + this.vibratoStrength);
            this.tremoloValue = (short)(TremoloTable[this.tremoloIndex] >> this.tremoloStrength);
            int todo = 0x100000 - this.lfoCounter;
            int count = (todo + this.lfoAdd - 1) / this.lfoAdd;
            if (count > samples) {
                count = samples;
                this.lfoCounter += count * this.lfoAdd;
            } else {
                this.lfoCounter += count * this.lfoAdd;
                this.lfoCounter &= 0xFFFFF;
                this.vibratoIndex = (short)(this.vibratoIndex + 1 & 0x1F);
                this.tremoloIndex = this.tremoloIndex + 1 < 52 ? (short)(this.tremoloIndex + 1) : (short)0;
            }
            return count;
        }

        int ForwardNoise() {
            this.noiseCounter += this.noiseAdd;
            this.noiseCounter &= 0x3FFFFFL;
            for (long count = this.noiseCounter >> 12; count > 0L; --count) {
                this.noiseValue ^= 0x800302 & 0 - (this.noiseValue & 1);
                this.noiseValue >>= 1;
            }
            return this.noiseValue;
        }

        void WriteBD(short val) {
            int change = this.regBD ^ val;
            if (change == 0) {
                return;
            }
            this.regBD = val;
            this.vibratoStrength = (val & 0x40) != 0 ? (short)0 : 1;
            this.tremoloStrength = (short)((val & 0x80) != 0 ? 0 : 2);
            if ((val & 0x20) != 0) {
                if ((change & 0x20) != 0) {
                    this.chan[6].synthHandlerMode = this.opl3Active != 0 ? 11 : 10;
                }
                if ((val & 0x10) != 0) {
                    this.chan[6].op[0].KeyOn(2);
                    this.chan[6].op[1].KeyOn(2);
                } else {
                    this.chan[6].op[0].KeyOff(2);
                    this.chan[6].op[1].KeyOff(2);
                }
                if ((val & 1) != 0) {
                    this.chan[7].op[0].KeyOn(2);
                } else {
                    this.chan[7].op[0].KeyOff(2);
                }
                if ((val & 8) != 0) {
                    this.chan[7].op[1].KeyOn(2);
                } else {
                    this.chan[7].op[1].KeyOff(2);
                }
                if ((val & 4) != 0) {
                    this.chan[8].op[0].KeyOn(2);
                } else {
                    this.chan[8].op[0].KeyOff(2);
                }
                if ((val & 2) != 0) {
                    this.chan[8].op[1].KeyOn(2);
                } else {
                    this.chan[8].op[1].KeyOff(2);
                }
            } else if ((change & 0x20) != 0) {
                this.chan[6].ResetC0(this);
                this.chan[6].op[0].KeyOff(2);
                this.chan[6].op[1].KeyOff(2);
                this.chan[7].op[0].KeyOff(2);
                this.chan[7].op[1].KeyOff(2);
                this.chan[8].op[0].KeyOff(2);
                this.chan[8].op[1].KeyOff(2);
            }
        }

        void WriteReg(int reg, int val) {
            switch ((reg & 0xF0) >> 4) {
                case 0: {
                    if (reg == 1) {
                        this.waveFormMask = (short)((val & 0x20) != 0 ? 7 : 0);
                        break;
                    }
                    if (reg == 260) {
                        if (((this.reg104 ^ val) & 0x3F) == 0) {
                            return;
                        }
                        this.reg104 = (short)(0x80 | val & 0x3F);
                        break;
                    }
                    if (reg == 261) {
                        if (((this.opl3Active ^ val) & 1) == 0) {
                            return;
                        }
                        this.opl3Active = (byte)((val & 1) != 0 ? -1 : 0);
                        for (int i = 0; i < 18; ++i) {
                            this.chan[i].ResetC0(this);
                        }
                        break;
                    }
                    if (reg == 8) {
                        this.reg08 = (short)val;
                    }
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    int index = reg >> 3 & 0x20 | reg & 0x1F;
                    if (OpOffsetTable[index] <= 0) break;
                    int offset = OpOffsetTable[index];
                    Operator regOp = this.chan[offset & 0xFFFF].op[offset >>> 16];
                    regOp.Write20(this, (short)val);
                    break;
                }
                case 4: 
                case 5: {
                    int index = reg >> 3 & 0x20 | reg & 0x1F;
                    if (OpOffsetTable[index] <= 0) break;
                    int offset = OpOffsetTable[index];
                    Operator regOp = this.chan[offset & 0xFFFF].op[offset >>> 16];
                    regOp.Write40(this, (short)val);
                    break;
                }
                case 6: 
                case 7: {
                    int index = reg >> 3 & 0x20 | reg & 0x1F;
                    if (OpOffsetTable[index] <= 0) break;
                    int offset = OpOffsetTable[index];
                    Operator regOp = this.chan[offset & 0xFFFF].op[offset >>> 16];
                    regOp.Write60(this, (short)val);
                    break;
                }
                case 8: 
                case 9: {
                    int index = reg >> 3 & 0x20 | reg & 0x1F;
                    if (OpOffsetTable[index] <= 0) break;
                    int offset = OpOffsetTable[index];
                    Operator regOp = this.chan[offset & 0xFFFF].op[offset >>> 16];
                    regOp.Write80(this, (short)val);
                    break;
                }
                case 10: {
                    int index = reg >> 4 & 0x10 | reg & 0xF;
                    if (ChanOffsetTable[index] < 0) break;
                    Channel regChan = this.chan[ChanOffsetTable[index]];
                    regChan.WriteA0(this, val);
                    break;
                }
                case 11: {
                    if (reg == 189) {
                        this.WriteBD((short)val);
                        break;
                    }
                    int index = reg >> 4 & 0x10 | reg & 0xF;
                    if (ChanOffsetTable[index] < 0) break;
                    Channel regChan = this.chan[ChanOffsetTable[index]];
                    regChan.WriteB0(this, (short)val);
                    break;
                }
                case 12: {
                    int index = reg >> 4 & 0x10 | reg & 0xF;
                    if (ChanOffsetTable[index] >= 0) {
                        Channel regChan = this.chan[ChanOffsetTable[index]];
                        regChan.WriteC0(this, (short)val);
                    }
                }
                case 13: {
                    break;
                }
                case 14: 
                case 15: {
                    int index = reg >> 3 & 0x20 | reg & 0x1F;
                    if (OpOffsetTable[index] <= 0) break;
                    int offset = OpOffsetTable[index];
                    Operator regOp = this.chan[offset & 0xFFFF].op[offset >>> 16];
                    regOp.WriteE0(this, (short)val);
                }
            }
        }

        long WriteAddr(int port, short val) {
            switch (port & 3) {
                case 0: {
                    return val;
                }
                case 2: {
                    if (this.opl3Active != 0 || val == 5) {
                        return 0x100 | val;
                    }
                    return val;
                }
            }
            return 0L;
        }

        void GenerateBlock2(int total, int[] output, int offset) {
            while (total > 0) {
                int samples = this.ForwardLFO(total);
                Arrays.fill(output, offset, samples + offset, 0);
                int count = 0;
                int i = 0;
                while (i < 9) {
                    Channel ch = this.chan[i];
                    ++count;
                    i = ch.BlockTemplate((int)ch.synthHandlerMode, (Chip)this, (long)((long)samples), (int[])output, (int)offset).index;
                }
                total -= samples;
                offset += samples;
            }
        }

        void GenerateBlock3(int total, int[] output, int offset) {
            while (total > 0) {
                int samples = this.ForwardLFO(total);
                Arrays.fill(output, offset, offset + samples * 2, 0);
                int count = 0;
                int i = 0;
                while (i < 18) {
                    Channel ch = this.chan[i];
                    ++count;
                    i = ch.BlockTemplate((int)ch.synthHandlerMode, (Chip)this, (long)((long)samples), (int[])output, (int)offset).index;
                }
                total -= samples;
                offset += samples * 2;
            }
        }

        void Setup(long rate) {
            int index;
            int shift;
            int i;
            double d_original = 49715.90277777778;
            double scale = d_original / (double)rate;
            this.noiseAdd = (long)(0.5 + scale * 4096.0);
            this.noiseCounter = 0L;
            this.noiseValue = 1;
            this.lfoAdd = (int)(0.5 + scale * 4096.0);
            this.lfoCounter = 0;
            this.vibratoIndex = 0;
            this.tremoloIndex = 0;
            int freqScale = (int)(0.5 + scale * 2048.0);
            for (int i2 = 0; i2 < 16; ++i2) {
                this.freqMul[i2] = freqScale * FreqCreateTable[i2];
            }
            for (i = 0; i < 76; ++i) {
                if (i < 52) {
                    shift = 12 - (i >> 2);
                    index = i & 3;
                } else if (i < 60) {
                    shift = 0;
                    index = i - 48;
                } else {
                    shift = 0;
                    index = 12;
                }
                this.linearRates[i] = (int)(scale * (double)(EnvelopeIncreaseTable[index] << 24 - shift - 3));
            }
            for (i = 0; i < 62; ++i) {
                int guessAdd;
                if (i < 52) {
                    shift = 12 - (i >> 2);
                    index = i & 3;
                } else if (i < 60) {
                    shift = 0;
                    index = i - 48;
                } else {
                    shift = 0;
                    index = 12;
                }
                int i_original = (int)((double)(AttackSamplesTable[index] << shift) / scale);
                int bestAdd = guessAdd = (int)(scale * (double)(EnvelopeIncreaseTable[index] << 24 - shift - 3));
                long bestDiff = 0x40000000L;
                for (long passes = 0L; passes < 16L; ++passes) {
                    int mul;
                    int samples;
                    int volume = 511;
                    int count = 0;
                    for (samples = 0; volume > 0 && samples < i_original * 2; ++samples) {
                        int change = (count += guessAdd) >> 24;
                        count &= 0xFFFFFF;
                        if (change == 0) continue;
                        volume += ~volume * change >> 3;
                    }
                    int diff = i_original - samples;
                    long lDiff = Math.abs(diff);
                    if (lDiff < bestDiff) {
                        bestDiff = lDiff;
                        bestAdd = guessAdd;
                        if (bestDiff == 0L) break;
                    }
                    if (diff < 0) {
                        mul = (i_original - diff << 12) / i_original;
                        guessAdd = guessAdd * mul >> 12;
                        ++guessAdd;
                        continue;
                    }
                    if (diff <= 0) continue;
                    mul = (i_original - diff << 12) / i_original;
                    guessAdd = guessAdd * mul >> 12;
                    --guessAdd;
                }
                this.attackRates[i] = bestAdd;
            }
            for (i = 62; i < 76; i = (int)((short)(i + 1))) {
                this.attackRates[i] = 0x8000000;
            }
            this.chan[0].fourMask = 1;
            this.chan[1].fourMask = (short)129;
            this.chan[2].fourMask = (short)2;
            this.chan[3].fourMask = (short)130;
            this.chan[4].fourMask = (short)4;
            this.chan[5].fourMask = (short)132;
            this.chan[9].fourMask = (short)8;
            this.chan[10].fourMask = (short)136;
            this.chan[11].fourMask = (short)16;
            this.chan[12].fourMask = (short)144;
            this.chan[13].fourMask = (short)32;
            this.chan[14].fourMask = (short)160;
            this.chan[6].fourMask = (short)64;
            this.chan[7].fourMask = (short)64;
            this.chan[8].fourMask = (short)64;
            this.WriteReg(261, 1);
            for (i = 0; i < 512; ++i) {
                if (i == 261) continue;
                this.WriteReg(i, 255);
                this.WriteReg(i, 0);
            }
            this.WriteReg(261, 0);
            for (i = 0; i < 255; ++i) {
                this.WriteReg(i, 255);
                this.WriteReg(i, 0);
            }
        }
    }

    private static class Channel {
        int index;
        Chip chip;
        Operator[] op = new Operator[2];
        int synthHandlerMode;
        int chanData;
        int[] old = new int[2];
        int feedback;
        short regB0;
        short regC0;
        short fourMask;
        byte maskLeft;
        byte maskRight;

        Channel(Chip chip, int index) {
            this.chip = chip;
            this.index = index;
            this.old[1] = 0;
            this.old[0] = 0;
            this.chanData = 0;
            this.regB0 = 0;
            this.regC0 = 0;
            this.maskLeft = (byte)-1;
            this.maskRight = (byte)-1;
            this.feedback = 31;
            this.fourMask = 0;
            this.synthHandlerMode = 1;
            for (int i = 0; i < this.op.length; ++i) {
                this.op[i] = new Operator();
            }
        }

        Operator Op(int index) {
            return this.chip.chan[this.index + (index >> 1)].op[index & 1];
        }

        void SetChanData(Chip chip, int data) {
            long change = this.chanData ^ data;
            this.chanData = data;
            this.Op((int)0).chanData = data;
            this.Op((int)1).chanData = data;
            this.Op(0).UpdateFrequency();
            this.Op(1).UpdateFrequency();
            if ((change & 0xFF0000L) != 0L) {
                this.Op(0).UpdateAttenuation();
                this.Op(1).UpdateAttenuation();
            }
            if ((change & 0xFFFFFFFFFF000000L) != 0L) {
                this.Op(0).UpdateRates(chip);
                this.Op(1).UpdateRates(chip);
            }
        }

        void UpdateFrequency(Chip chip, int fourOp) {
            int data = this.chanData & 0xFFFF;
            long kslBase = KslTable[data >> 6];
            long keyCode = (data & 0x1C00) >> 9;
            keyCode = (chip.reg08 & 0x40) != 0 ? (keyCode |= (long)((data & 0x100) >> 8)) : (keyCode |= (long)((data & 0x200) >> 9));
            data = (int)((long)data | (keyCode << 24 | kslBase << 16));
            this.SetChanData(chip, data);
            if ((fourOp & 0x3F) != 0) {
                chip.chan[this.index + 1].SetChanData(chip, data);
            }
        }

        void WriteA0(Chip chip, int val) {
            int fourOp = chip.reg104 & chip.opl3Active & this.fourMask;
            if (fourOp > 128) {
                return;
            }
            long change = (this.chanData ^ val) & 0xFF;
            if (change != 0L) {
                this.chanData = (int)((long)this.chanData ^ change);
                this.UpdateFrequency(chip, fourOp);
            }
        }

        void WriteB0(Chip chip, short val) {
            int fourOp = chip.reg104 & chip.opl3Active & this.fourMask;
            if (fourOp > 128) {
                return;
            }
            long change = (this.chanData ^ val << 8) & 0x1F00;
            if (change != 0L) {
                this.chanData = (int)((long)this.chanData ^ change);
                this.UpdateFrequency(chip, fourOp);
            }
            if (((val ^ this.regB0) & 0x20) == 0) {
                return;
            }
            this.regB0 = val;
            if ((val & 0x20) != 0) {
                this.Op(0).KeyOn(1);
                this.Op(1).KeyOn(1);
                if ((fourOp & 0x3F) != 0) {
                    chip.chan[this.index + 1].Op(0).KeyOn(1);
                    chip.chan[this.index + 1].Op(1).KeyOn(1);
                }
            } else {
                this.Op(0).KeyOff(1);
                this.Op(1).KeyOff(1);
                if ((fourOp & 0x3F) != 0) {
                    chip.chan[this.index + 1].Op(0).KeyOff(1);
                    chip.chan[this.index + 1].Op(1).KeyOff(1);
                }
            }
        }

        void WriteC0(Chip chip, short val) {
            int change = val ^ this.regC0;
            if (change == 0) {
                return;
            }
            this.regC0 = val;
            this.feedback = val >> 1 & 7;
            this.feedback = this.feedback != 0 ? 9 - this.feedback : 31;
            if (chip.opl3Active != 0) {
                if ((chip.reg104 & this.fourMask & 0x3F) != 0) {
                    Channel chan1;
                    Channel chan0;
                    if ((this.fourMask & 0x80) == 0) {
                        chan0 = this;
                        chan1 = chip.chan[this.index + 1];
                    } else {
                        chan0 = chip.chan[this.index - 1];
                        chan1 = this;
                    }
                    int synth = (chan0.regC0 & 1) << 0 | (chan1.regC0 & 1) << 1;
                    switch (synth) {
                        case 0: {
                            chan0.synthHandlerMode = 5;
                            break;
                        }
                        case 1: {
                            chan0.synthHandlerMode = 6;
                            break;
                        }
                        case 2: {
                            chan0.synthHandlerMode = 7;
                            break;
                        }
                        case 3: {
                            chan0.synthHandlerMode = 8;
                        }
                    }
                } else if ((this.fourMask & 0x40) == 0 || (chip.regBD & 0x20) == 0) {
                    this.synthHandlerMode = (val & 1) != 0 ? 2 : 3;
                }
                this.maskLeft = (byte)((val & 0x10) != 0 ? -1 : 0);
                this.maskRight = (byte)((val & 0x20) != 0 ? -1 : 0);
            } else if ((this.fourMask & 0x40) == 0 || (chip.regBD & 0x20) == 0) {
                this.synthHandlerMode = (val & 1) != 0 ? 0 : 1;
            }
        }

        void ResetC0(Chip chip) {
            short val = this.regC0;
            this.regC0 = (short)(this.regC0 ^ 0xFF);
            this.WriteC0(chip, val);
        }

        void GeneratePercussion(boolean opl3Mode, Chip chip, int[] output, int offset) {
            int sdVol;
            Channel chan = this;
            int mod = this.old[0] + this.old[1] >> this.feedback;
            this.old[0] = this.old[1];
            this.old[1] = this.Op(0).GetSample(mod);
            mod = (chan.regC0 & 1) != 0 ? 0 : this.old[0];
            int sample = this.Op(1).GetSample(mod);
            int noiseBit = chip.ForwardNoise() & 1;
            int c2 = this.Op(2).ForwardWave();
            int c5 = this.Op(5).ForwardWave();
            int phaseBit = (c2 & 0x88 ^ c2 << 5 & 0x80) != 0 | ((c5 ^ c5 << 2) & 0x20) != 0 ? 2 : 0;
            int hhVol = this.Op(2).ForwardVolume();
            if (!DbOPL.ENV_SILENT(hhVol)) {
                int hhIndex = phaseBit << 8 | 52 << (phaseBit ^ noiseBit << 1);
                sample += this.Op(2).GetWave(hhIndex, hhVol);
            }
            if (!DbOPL.ENV_SILENT(sdVol = this.Op(3).ForwardVolume())) {
                int sdIndex = 256 + (c2 & 0x100) ^ noiseBit << 8;
                sample += this.Op(3).GetWave(sdIndex, sdVol);
            }
            sample += this.Op(4).GetSample(0);
            int tcVol = this.Op(5).ForwardVolume();
            if (!DbOPL.ENV_SILENT(tcVol)) {
                int tcIndex = 1 + phaseBit << 8;
                sample += this.Op(5).GetWave(tcIndex, tcVol);
            }
            sample <<= 1;
            if (opl3Mode) {
                int n = offset;
                output[n] = output[n] + sample;
                int n2 = offset + 1;
                output[n2] = output[n2] + sample;
            } else {
                int n = offset;
                output[n] = output[n] + sample;
            }
        }

        Channel BlockTemplate(int mode, Chip chip, long samples, int[] output, int offset) {
            switch (mode) {
                case 0: 
                case 2: {
                    if (!this.Op(0).Silent() || !this.Op(1).Silent()) break;
                    this.old[1] = 0;
                    this.old[0] = 0;
                    return chip.chan[this.index + 1];
                }
                case 1: 
                case 3: {
                    if (!this.Op(1).Silent()) break;
                    this.old[1] = 0;
                    this.old[0] = 0;
                    return chip.chan[this.index + 1];
                }
                case 5: {
                    if (!this.Op(3).Silent()) break;
                    this.old[1] = 0;
                    this.old[0] = 0;
                    return chip.chan[this.index + 2];
                }
                case 6: {
                    if (!this.Op(0).Silent() || !this.Op(3).Silent()) break;
                    this.old[1] = 0;
                    this.old[0] = 0;
                    return chip.chan[this.index + 2];
                }
                case 7: {
                    if (!this.Op(1).Silent() || !this.Op(3).Silent()) break;
                    this.old[1] = 0;
                    this.old[0] = 0;
                    return chip.chan[this.index + 2];
                }
                case 8: {
                    if (!this.Op(0).Silent() || !this.Op(2).Silent() || !this.Op(3).Silent()) break;
                    this.old[1] = 0;
                    this.old[0] = 0;
                    return chip.chan[this.index + 2];
                }
            }
            this.Op(0).Prepare(chip);
            this.Op(1).Prepare(chip);
            if (mode > 4) {
                this.Op(2).Prepare(chip);
                this.Op(3).Prepare(chip);
            }
            if (mode > 9) {
                this.Op(4).Prepare(chip);
                this.Op(5).Prepare(chip);
            }
            int i = 0;
            while ((long)i < samples) {
                if (mode == 10) {
                    this.GeneratePercussion(false, chip, output, offset + i);
                } else if (mode == 11) {
                    this.GeneratePercussion(true, chip, output, offset + i * 2);
                } else {
                    int next;
                    int mod = this.old[0] + this.old[1] >>> this.feedback;
                    this.old[0] = this.old[1];
                    this.old[1] = this.Op(0).GetSample(mod);
                    int sample = 0;
                    int out0 = this.old[0];
                    if (mode == 0 || mode == 2) {
                        sample = out0 + this.Op(1).GetSample(0);
                    } else if (mode == 1 || mode == 3) {
                        sample = this.Op(1).GetSample(out0);
                    } else if (mode == 5) {
                        next = this.Op(1).GetSample(out0);
                        next = this.Op(2).GetSample(next);
                        sample = this.Op(3).GetSample(next);
                    } else if (mode == 6) {
                        sample = out0;
                        next = this.Op(1).GetSample(0);
                        next = this.Op(2).GetSample(next);
                        sample += this.Op(3).GetSample(next);
                    } else if (mode == 7) {
                        sample = this.Op(1).GetSample(out0);
                        next = this.Op(2).GetSample(0);
                        sample += this.Op(3).GetSample(next);
                    } else if (mode == 8) {
                        sample = out0;
                        next = this.Op(1).GetSample(0);
                        sample += this.Op(2).GetSample(next);
                        sample += this.Op(3).GetSample(0);
                    }
                    switch (mode) {
                        case 0: 
                        case 1: {
                            int n = offset + i;
                            output[n] = output[n] + sample;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            int n = offset + i * 2 + 0;
                            output[n] = output[n] + (sample & this.maskLeft);
                            int n2 = offset + i * 2 + 1;
                            output[n2] = output[n2] + (sample & this.maskRight);
                        }
                    }
                }
                ++i;
            }
            switch (mode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return chip.chan[this.index + 1];
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    return chip.chan[this.index + 2];
                }
                case 10: 
                case 11: {
                    return chip.chan[this.index + 3];
                }
            }
            return null;
        }
    }

    private static class Operator {
        public static final int MASK_KSR = 16;
        public static final int MASK_SUSTAIN = 32;
        public static final int MASK_VIBRATO = 64;
        public static final int MASK_TREMOLO = 128;
        public static final int OFF = 0;
        public static final int RELEASE = 1;
        public static final int SUSTAIN = 2;
        public static final int DECAY = 3;
        public static final int ATTACK = 4;
        public int State;
        int volHandlerParam;
        WaveHandler waveHandler;
        short[] waveBase;
        int waveBaseOff;
        int waveMask;
        long waveStart;
        long waveIndex = 0L;
        int waveAdd = 0;
        int waveCurrent = 0;
        int chanData = 0;
        int freqMul = 0;
        int vibrato;
        int sustainLevel;
        int totalLevel;
        int currentLevel;
        int volume;
        long attackAdd;
        long decayAdd;
        long releaseAdd;
        long rateIndex;
        short rateZero;
        short keyOn = 0;
        short reg20 = 0;
        short reg40 = 0;
        short reg60 = 0;
        short reg80 = 0;
        short regE0 = 0;
        short state;
        byte tremoloMask;
        short vibStrength;
        short ksr = 0;

        private void SetState(int s) {
            this.state = (short)s;
            this.volHandlerParam = s;
        }

        private void UpdateAttack(Chip chip) {
            int rate = this.reg60 >> 4;
            if (rate != 0) {
                int val = (rate << 2) + this.ksr;
                this.attackAdd = chip.attackRates[val];
                this.rateZero = (short)(this.rateZero & 0xFFFFFFEF);
            } else {
                this.attackAdd = 0L;
                this.rateZero = (short)(this.rateZero | 0x10);
            }
        }

        private void UpdateRelease(Chip chip) {
            int rate = this.reg80 & 0xF;
            if (rate != 0) {
                int val = (rate << 2) + this.ksr;
                this.releaseAdd = chip.linearRates[val];
                this.rateZero = (short)(this.rateZero & 0xFFFFFFFD);
                if ((this.reg20 & 0x20) == 0) {
                    this.rateZero = (short)(this.rateZero & 0xFFFFFFFB);
                }
            } else {
                this.rateZero = (short)(this.rateZero | 2);
                this.releaseAdd = 0L;
                if ((this.reg20 & 0x20) == 0) {
                    this.rateZero = (short)(this.rateZero | 4);
                }
            }
        }

        private void UpdateDecay(Chip chip) {
            int rate = this.reg60 & 0xF;
            if (rate != 0) {
                int val = (rate << 2) + this.ksr;
                this.decayAdd = chip.linearRates[val];
                this.rateZero = (short)(this.rateZero & 0xFFFFFFF7);
            } else {
                this.decayAdd = 0L;
                this.rateZero = (short)(this.rateZero | 8);
            }
        }

        public void UpdateAttenuation() {
            short kslBase = (short)(this.chanData >> 16 & 0xFF);
            int tl = this.reg40 & 0x3F;
            short kslShift = KslShiftTable[this.reg40 >> 6];
            this.totalLevel = tl << 2;
            this.totalLevel += kslBase << 0 >> kslShift;
        }

        public void UpdateRates(Chip chip) {
            short newKsr = (short)(this.chanData >> 24 & 0xFF);
            if ((this.reg20 & 0x10) == 0) {
                newKsr = (short)(newKsr >> 2);
            }
            if (this.ksr == newKsr) {
                return;
            }
            this.ksr = newKsr;
            this.UpdateAttack(chip);
            this.UpdateDecay(chip);
            this.UpdateRelease(chip);
        }

        public void UpdateFrequency() {
            int freq = this.chanData & 0x3FF;
            long block = this.chanData >> 10 & 0xFF;
            this.waveAdd = (freq << (int)block) * this.freqMul;
            if ((this.reg20 & 0x40) != 0) {
                this.vibStrength = (short)(freq >> 7);
                this.vibrato = (this.vibStrength << (int)block) * this.freqMul;
            } else {
                this.vibStrength = 0;
                this.vibrato = 0;
            }
        }

        public void Write20(Chip chip, short val) {
            int change = this.reg20 ^ val;
            if (change == 0) {
                return;
            }
            this.reg20 = val;
            this.tremoloMask = (byte)((byte)val >> 7);
            this.tremoloMask = (byte)(this.tremoloMask & 0xFFFFFFFF);
            if ((change & 0x10) != 0) {
                this.UpdateRates(chip);
            }
            this.rateZero = (this.reg20 & 0x20) != 0 || this.releaseAdd == 0L ? (short)(this.rateZero | 4) : (short)(this.rateZero & 0xFFFFFFFB);
            if ((change & 0x4F) != 0) {
                this.freqMul = chip.freqMul[val & 0xF];
                this.UpdateFrequency();
            }
        }

        public void Write40(Chip chip, short val) {
            if ((this.reg40 ^ val) == 0) {
                return;
            }
            this.reg40 = val;
            this.UpdateAttenuation();
        }

        public void Write60(Chip chip, short val) {
            int change = this.reg60 ^ val;
            this.reg60 = val;
            if ((change & 0xF) != 0) {
                this.UpdateDecay(chip);
            }
            if ((change & 0xF0) != 0) {
                this.UpdateAttack(chip);
            }
        }

        public void Write80(Chip chip, short val) {
            int change = this.reg80 ^ val;
            if (change == 0) {
                return;
            }
            this.reg80 = val;
            int sustain = val >> 4;
            sustain |= sustain + 1 & 0x10;
            this.sustainLevel = sustain << 4;
            if ((change & 0xF) != 0) {
                this.UpdateRelease(chip);
            }
        }

        public void WriteE0(Chip chip, short val) {
            if ((this.regE0 ^ val) == 0) {
                return;
            }
            int waveForm = val & (3 & chip.waveFormMask | 7 & chip.opl3Active);
            this.regE0 = val;
            this.waveBase = WaveTable;
            this.waveBaseOff = WaveBaseTable[waveForm];
            this.waveStart = WaveStartTable[waveForm] << 22;
            this.waveMask = WaveMaskTable[waveForm];
        }

        public boolean Silent() {
            if (!DbOPL.ENV_SILENT(this.totalLevel + this.volume)) {
                return false;
            }
            return (this.rateZero & 1 << this.state) != 0;
        }

        public void Prepare(Chip chip) {
            this.currentLevel = this.totalLevel + (chip.tremoloValue & this.tremoloMask);
            this.waveCurrent = this.waveAdd;
            if (this.vibStrength >> chip.vibratoShift != 0) {
                int add = this.vibrato >> chip.vibratoShift;
                byte neg = chip.vibratoSign;
                add = (add ^ neg) - neg;
                this.waveCurrent += add;
            }
        }

        public void KeyOn(int mask) {
            if (this.keyOn == 0) {
                this.waveIndex = this.waveStart;
                this.rateIndex = 0L;
                this.SetState(4);
            }
            this.keyOn = (short)(this.keyOn | mask);
        }

        public void KeyOff(int mask) {
            this.keyOn = (short)(this.keyOn & ~mask);
            if (this.keyOn == 0 && this.state != 0) {
                this.SetState(1);
            }
        }

        public int TemplateVolume(int yes) {
            int vol = this.volume;
            switch (yes) {
                case 0: {
                    return 511;
                }
                case 4: {
                    int change = this.RateForward(this.attackAdd);
                    if (change == 0) {
                        return vol;
                    }
                    if ((vol += ~vol * change >> 3) >= 0) break;
                    this.volume = 0;
                    this.rateIndex = 0L;
                    this.SetState(3);
                    return 0;
                }
                case 3: {
                    if ((vol += this.RateForward(this.decayAdd)) < this.sustainLevel) break;
                    if (vol >= 511) {
                        this.volume = 511;
                        this.SetState(0);
                        return 511;
                    }
                    this.rateIndex = 0L;
                    this.SetState(2);
                    break;
                }
                case 2: {
                    if ((this.reg20 & 0x20) != 0) {
                        return vol;
                    }
                }
                case 1: {
                    if ((vol += this.RateForward(this.releaseAdd)) < 511) break;
                    this.volume = 511;
                    this.SetState(0);
                    return 511;
                }
            }
            this.volume = vol;
            return vol;
        }

        public int RateForward(long add) {
            this.rateIndex += add;
            int ret = (int)(this.rateIndex >> 24);
            this.rateIndex &= 0xFFFFFFL;
            return ret;
        }

        public int ForwardWave() {
            this.waveIndex += (long)this.waveCurrent;
            return (int)(this.waveIndex >> 22);
        }

        public int ForwardVolume() {
            return this.currentLevel + this.TemplateVolume(this.volHandlerParam);
        }

        public int GetSample(int modulation) {
            int vol = this.ForwardVolume();
            if (DbOPL.ENV_SILENT(vol)) {
                this.waveIndex += (long)this.waveCurrent;
                return 0;
            }
            int index = this.ForwardWave();
            return this.GetWave(index += modulation, vol);
        }

        public int GetWave(int index, int vol) {
            return this.waveBase[this.waveBaseOff + (index & this.waveMask)] * MulTable[vol >> 0] >> 16;
        }

        public Operator() {
            this.SetState(0);
            this.rateZero = 1;
            this.sustainLevel = 511;
            this.currentLevel = 511;
            this.totalLevel = 511;
            this.volume = 511;
            this.releaseAdd = 0L;
        }
    }

    private static interface WaveHandler {
        public int call(int var1, int var2);
    }
}

