/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.IoHandler;
import jdos.hardware.Mixer;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.ShortPtr;

public class Gameblaster {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int CMS_BUFFER_SIZE = 128;
    private static final int CMS_RATE = 22050;
    private static final byte[][] envelope = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}};
    private static final int[] amplitude_lookup = new int[]{0, 2047, 4095, 6143, 8191, 10239, 12287, 14335, 16383, 18431, 20479, 22527, 24575, 26623, 28671, 30719};
    private static double sample_rate;
    private static SAA1099[] saa1099;
    private static Mixer.MixerChannel cms_chan;
    private static ShortPtr[][] cms_buffer;
    private static ShortPtr[] cms_buf_point0;
    private static ShortPtr[] cms_buf_point2;
    private static int last_command;
    private static int base_port;
    private static IoHandler.IO_WriteHandler write_cms;
    private static Mixer.MIXER_Handler CMS_CallBack;
    private static short cms_detect_register;
    private static IoHandler.IO_WriteHandler write_cms_detect;
    private static IoHandler.IO_ReadHandler read_cms_detect;
    private static CMS test;

    static void saa1099_envelope(int chip, int ch) {
        SAA1099 saa = saa1099[chip];
        if (saa.env_enable[ch] != 0) {
            int mode = saa.env_mode[ch];
            int step = saa.env_step[ch] = saa.env_step[ch] + 1 & 0x3F | saa.env_step[ch] & 0x20;
            int mask = 15;
            if (saa.env_bits[ch] != 0) {
                mask &= 0xFFFFFFFE;
            }
            saa.channels[ch * 3 + 1].envelope[0] = saa.channels[ch * 3 + 2].envelope[0] = envelope[mode][step] & mask;
            saa.channels[ch * 3 + 0].envelope[0] = saa.channels[ch * 3 + 2].envelope[0];
            if ((saa.env_reverse_right[ch] & 1) != 0) {
                saa.channels[ch * 3 + 1].envelope[1] = saa.channels[ch * 3 + 2].envelope[1] = 15 - envelope[mode][step] & mask;
                saa.channels[ch * 3 + 0].envelope[1] = saa.channels[ch * 3 + 2].envelope[1];
            } else {
                saa.channels[ch * 3 + 1].envelope[1] = saa.channels[ch * 3 + 2].envelope[1] = envelope[mode][step] & mask;
                saa.channels[ch * 3 + 0].envelope[1] = saa.channels[ch * 3 + 2].envelope[1];
            }
        } else {
            saa.channels[ch * 3 + 2].envelope[1] = 16;
            saa.channels[ch * 3 + 1].envelope[1] = 16;
            saa.channels[ch * 3 + 0].envelope[1] = 16;
            saa.channels[ch * 3 + 2].envelope[0] = 16;
            saa.channels[ch * 3 + 1].envelope[0] = 16;
            saa.channels[ch * 3 + 0].envelope[0] = 16;
        }
    }

    private static void saa1099_update(int chip, ShortPtr[] buffer, int length) {
        int ch;
        SAA1099 saa = saa1099[chip];
        if (saa.all_ch_enable == 0) {
            buffer[0].clear(length * 2);
            buffer[1].clear(length * 2);
            return;
        }
        block6: for (ch = 0; ch < 2; ++ch) {
            switch (saa.noise_params[ch]) {
                case 0: {
                    saa.noise[ch].freq = 62500.0;
                    continue block6;
                }
                case 1: {
                    saa.noise[ch].freq = 31250.0;
                    continue block6;
                }
                case 2: {
                    saa.noise[ch].freq = 15625.0;
                    continue block6;
                }
                case 3: {
                    saa.noise[ch].freq = saa.channels[ch * 3].freq;
                }
            }
        }
        for (int j = 0; j < length; ++j) {
            int output_l = 0;
            int output_r = 0;
            for (ch = 0; ch < 6; ++ch) {
                if (saa.channels[ch].freq == 0.0) {
                    saa.channels[ch].freq = (double)(31250 << saa.channels[ch].octave) / (511.0 - (double)saa.channels[ch].frequency);
                }
                saa.channels[ch].counter -= saa.channels[ch].freq;
                while (saa.channels[ch].counter < 0.0) {
                    saa.channels[ch].freq = (double)(31250 << saa.channels[ch].octave) / (511.0 - (double)saa.channels[ch].frequency);
                    saa.channels[ch].counter += sample_rate;
                    saa.channels[ch].level ^= 1;
                    if (ch == 1 && saa.env_clock[0] == 0) {
                        Gameblaster.saa1099_envelope(chip, 0);
                    }
                    if (ch != 4 || saa.env_clock[1] != 0) continue;
                    Gameblaster.saa1099_envelope(chip, 1);
                }
                if (saa.channels[ch].noise_enable != 0 && (saa.noise[ch / 3].level & 1) != 0) {
                    output_l -= saa.channels[ch].amplitude[0] * saa.channels[ch].envelope[0] / 16 / 2;
                    output_r -= saa.channels[ch].amplitude[1] * saa.channels[ch].envelope[1] / 16 / 2;
                }
                if (saa.channels[ch].freq_enable == 0 || (saa.channels[ch].level & 1) == 0) continue;
                output_l += saa.channels[ch].amplitude[0] * saa.channels[ch].envelope[0] / 16;
                output_r += saa.channels[ch].amplitude[1] * saa.channels[ch].envelope[1] / 16;
            }
            for (ch = 0; ch < 2; ++ch) {
                saa.noise[ch].counter -= saa.noise[ch].freq;
                while (saa.noise[ch].counter < 0.0) {
                    saa.noise[ch].counter += sample_rate;
                    if ((saa.noise[ch].level & 0x4000) == 0 == ((saa.noise[ch].level & 0x40) == 0)) {
                        saa.noise[ch].level = saa.noise[ch].level << 1 | 1;
                        continue;
                    }
                    saa.noise[ch].level <<= 1;
                }
            }
            buffer[0].set(j, output_l / 6);
            buffer[1].set(j, output_r / 6);
        }
    }

    private static void saa1099_write_port_w(int chip, int offset, int data) {
        SAA1099 saa = saa1099[chip];
        if (offset == 1) {
            saa.selected_reg = data & 0x1F;
            if (saa.selected_reg == 24 || saa.selected_reg == 25) {
                if (saa.env_clock[0] != 0) {
                    Gameblaster.saa1099_envelope(chip, 0);
                }
                if (saa.env_clock[1] != 0) {
                    Gameblaster.saa1099_envelope(chip, 1);
                }
            }
            return;
        }
        int reg = saa.selected_reg;
        switch (reg) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                int ch = reg & 7;
                saa.channels[ch].amplitude[0] = amplitude_lookup[data & 0xF];
                saa.channels[ch].amplitude[1] = amplitude_lookup[data >> 4 & 0xF];
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                int ch = reg & 7;
                saa.channels[ch].frequency = data & 0xFF;
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                int ch = reg - 16 << 1;
                saa.channels[ch + 0].octave = data & 7;
                saa.channels[ch + 1].octave = data >> 4 & 7;
                break;
            }
            case 20: {
                saa.channels[0].freq_enable = data & 1;
                saa.channels[1].freq_enable = data & 2;
                saa.channels[2].freq_enable = data & 4;
                saa.channels[3].freq_enable = data & 8;
                saa.channels[4].freq_enable = data & 0x10;
                saa.channels[5].freq_enable = data & 0x20;
                break;
            }
            case 21: {
                saa.channels[0].noise_enable = data & 1;
                saa.channels[1].noise_enable = data & 2;
                saa.channels[2].noise_enable = data & 4;
                saa.channels[3].noise_enable = data & 8;
                saa.channels[4].noise_enable = data & 0x10;
                saa.channels[5].noise_enable = data & 0x20;
                break;
            }
            case 22: {
                saa.noise_params[0] = data & 3;
                saa.noise_params[1] = data >> 4 & 3;
                break;
            }
            case 24: 
            case 25: {
                int ch = reg - 24;
                saa.env_reverse_right[ch] = data & 1;
                saa.env_mode[ch] = data >> 1 & 7;
                saa.env_bits[ch] = data & 0x10;
                saa.env_clock[ch] = data & 0x20;
                saa.env_enable[ch] = data & 0x80;
                saa.env_step[ch] = 0;
                break;
            }
            case 28: {
                saa.all_ch_enable = data & 1;
                saa.sync_state = data & 2;
                if ((data & 2) == 0) break;
                for (int i = 0; i < 6; ++i) {
                    saa.channels[i].level = 0;
                    saa.channels[i].counter = 0.0;
                }
                break;
            }
            default: {
                Log.log(21, 2, "CMS Unkown write to reg " + Integer.toString(reg, 16) + " with " + Integer.toString(data, 16));
            }
        }
    }

    public static void CMS_Init(Section sec) {
        for (int i = 0; i < saa1099.length; ++i) {
            Gameblaster.saa1099[i] = new SAA1099();
        }
        test = new CMS(sec);
    }

    public static void CMS_ShutDown(Section sec) {
        test.close();
        test = null;
        for (int i = 0; i < saa1099.length; ++i) {
            Gameblaster.saa1099[i] = null;
        }
    }

    static {
        saa1099 = new SAA1099[2];
        cms_buffer = new ShortPtr[2][2];
        Gameblaster.cms_buffer[0][0] = new ShortPtr(128);
        Gameblaster.cms_buffer[0][1] = new ShortPtr(128);
        Gameblaster.cms_buffer[1][0] = new ShortPtr(128);
        Gameblaster.cms_buffer[1][1] = new ShortPtr(128);
        cms_buf_point0 = new ShortPtr[]{cms_buffer[0][0], cms_buffer[0][1]};
        cms_buf_point2 = new ShortPtr[]{cms_buffer[1][0], cms_buffer[1][1]};
        write_cms = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                if (cms_chan != null && !cms_chan.enabled) {
                    cms_chan.Enable(true);
                }
                last_command = Pic.PIC_Ticks;
                switch (port - base_port) {
                    case 0: {
                        Gameblaster.saa1099_write_port_w(0, 0, val);
                        break;
                    }
                    case 1: {
                        Gameblaster.saa1099_write_port_w(0, 1, val);
                        break;
                    }
                    case 2: {
                        Gameblaster.saa1099_write_port_w(1, 0, val);
                        break;
                    }
                    case 3: {
                        Gameblaster.saa1099_write_port_w(1, 1, val);
                    }
                }
            }
        };
        CMS_CallBack = new Mixer.MIXER_Handler(){

            public void call(int len) {
                if (len > 128) {
                    return;
                }
                Gameblaster.saa1099_update(0, cms_buf_point0, len);
                Gameblaster.saa1099_update(1, cms_buf_point2, len);
                short[] stream = Mixer.MixTemp16;
                int streamOff = 0;
                for (int l = 0; l < len; ++l) {
                    short left = (short)(cms_buffer[0][0].get(l) + cms_buffer[1][0].get(l));
                    short right = (short)(cms_buffer[0][1].get(l) + cms_buffer[1][1].get(l));
                    stream[streamOff++] = left > Short.MAX_VALUE ? Short.MAX_VALUE : (left < Short.MIN_VALUE ? Short.MIN_VALUE : left);
                    stream[streamOff++] = right > Short.MAX_VALUE ? Short.MAX_VALUE : (right < Short.MIN_VALUE ? Short.MIN_VALUE : right);
                }
                if (cms_chan != null) {
                    cms_chan.AddSamples_s16(len, stream);
                }
                if (last_command + 10000 < Pic.PIC_Ticks && cms_chan != null) {
                    cms_chan.Enable(false);
                }
            }
        };
        cms_detect_register = (short)255;
        write_cms_detect = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                switch (port - base_port) {
                    case 6: 
                    case 7: {
                        cms_detect_register = (short)val;
                    }
                }
            }
        };
        read_cms_detect = new IoHandler.IO_ReadHandler(){

            public int call(int port, int iolen) {
                int retval = 255;
                switch (port - base_port) {
                    case 4: {
                        retval = 127;
                        break;
                    }
                    case 10: 
                    case 11: {
                        retval = cms_detect_register;
                    }
                }
                return retval;
            }
        };
    }

    private static class CMS
    extends Module_base {
        private IoHandler.IO_WriteHandleObject WriteHandler = new IoHandler.IO_WriteHandleObject();
        private IoHandler.IO_WriteHandleObject DetWriteHandler = new IoHandler.IO_WriteHandleObject();
        private IoHandler.IO_ReadHandleObject DetReadHandler = new IoHandler.IO_ReadHandleObject();
        private Mixer.MixerObject MixerChan = new Mixer.MixerObject();

        public CMS(Section configuration) {
            super(configuration);
            Section_prop section = (Section_prop)configuration;
            int sample_rate_temp = section.Get_int("oplrate");
            sample_rate = sample_rate_temp;
            base_port = section.Get_hex("sbbase").toInt();
            this.WriteHandler.Install(base_port, write_cms, 1, 4);
            String sbtype = section.Get_string("sbtype");
            if (sbtype.equalsIgnoreCase("gb")) {
                this.DetWriteHandler.Install(base_port + 4, write_cms_detect, 1, 12);
                this.DetReadHandler.Install(base_port, read_cms_detect, 1, 16);
            }
            cms_chan = this.MixerChan.Install(CMS_CallBack, sample_rate_temp, "CMS");
            last_command = Pic.PIC_Ticks;
        }

        public void close() {
            cms_chan = null;
        }
    }

    private static class SAA1099 {
        int stream;
        int[] noise_params = new int[2];
        int[] env_enable = new int[2];
        int[] env_reverse_right = new int[2];
        int[] env_mode = new int[2];
        int[] env_bits = new int[2];
        int[] env_clock = new int[2];
        int[] env_step = new int[2];
        int all_ch_enable;
        int sync_state;
        int selected_reg;
        saa1099_channel[] channels = new saa1099_channel[6];
        saa1099_noise[] noise = new saa1099_noise[2];

        public SAA1099() {
            int i;
            for (i = 0; i < this.channels.length; ++i) {
                this.channels[i] = new saa1099_channel();
            }
            for (i = 0; i < this.noise.length; ++i) {
                this.noise[i] = new saa1099_noise();
            }
        }
    }

    private static class saa1099_noise {
        double counter;
        double freq;
        int level;

        private saa1099_noise() {
        }
    }

    private static class saa1099_channel {
        int frequency;
        int freq_enable;
        int noise_enable;
        int octave;
        int[] amplitude = new int[2];
        int[] envelope = new int[2];
        double counter;
        double freq;
        int level;

        private saa1099_channel() {
        }
    }
}

