/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.Dos_misc;
import jdos.dos.Dos_system;
import jdos.dos.Dos_tables;
import jdos.dos.drives.Drive_virtual;
import jdos.gui.Main;
import jdos.hardware.IO;
import jdos.hardware.IPXServer;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.hardware.Timer;
import jdos.misc.Log;
import jdos.misc.Program;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.IntRef;
import jdos.util.StringHelper;

public class IPX
extends Module_base {
    static final int SOCKETTABLESIZE = 150;
    static final int IPXBUFFERSIZE = 1424;
    private static final int USEFLAG_AVAILABLE = 0;
    private static final int USEFLAG_AESTEMP = 224;
    private static final int USEFLAG_IPXCRIT = 248;
    private static final int USEFLAG_SPXLISTEN = 249;
    private static final int USEFLAG_PROCESSING = 250;
    private static final int USEFLAG_HOLDING = 251;
    private static final int USEFLAG_AESWAITING = 252;
    private static final int USEFLAG_AESCOUNT = 253;
    private static final int USEFLAG_LISTENING = 254;
    private static final int USEFLAG_SENDING = 255;
    private static final int COMP_SUCCESS = 0;
    private static final int COMP_REMOTETERM = 236;
    private static final int COMP_DISCONNECT = 237;
    private static final int COMP_INVALIDID = 238;
    private static final int COMP_SPXTABLEFULL = 239;
    private static final int COMP_EVENTNOTCANCELED = 249;
    private static final int COMP_NOCONNECTION = 250;
    private static final int COMP_CANCELLED = 252;
    private static final int COMP_MALFORMED = 253;
    private static final int COMP_UNDELIVERABLE = 254;
    private static final int COMP_HARDWAREERROR = 255;
    private static final ipxnetaddr localIpxAddr = new ipxnetaddr();
    private static int udpPort;
    private static boolean isIpxServer;
    private static boolean isIpxConnected;
    private static InetAddress ipxServConnIp;
    private static DatagramSocket ipxClientSocket;
    private static int ipx_callback;
    private static final packetBuffer incomingPacket;
    private static int socketCount;
    private static int[] opensockets;
    private static int ECBSerialNumber;
    private static int ECBAmount;
    private static ECBClass ECBList;
    private static ECBClass ESRList;
    private static final Dos_system.MultiplexHandler IPX_Multiplex;
    private static final Pic.PIC_EventHandler IPX_AES_EventHandler;
    private static final Callback.Handler IPX_Handler;
    private static final Callback.Handler IPX_IntHandler;
    private static ReceiverThread receiverThread;
    private static final Timer.TIMER_TickHandler IPX_ClientLoop;
    private static Program.PROGRAMS_Main IPXNET_ProgramStart;
    private static final Callback.Handler IPX_ESRHandler;
    private Callback callback_ipx = new Callback();
    private Callback callback_esr = new Callback();
    private Callback callback_ipxint = new Callback();
    private IntRef old_73_vector = new IntRef(0);
    private static int dospage;
    private static IPX test;
    public static Section.SectionFunction IPX_ShutDown;
    public static Section.SectionFunction IPX_Init;

    private static int swapByte(int sockNum) {
        return sockNum >>> 8 & 0xFF | (sockNum & 0xFF) << 8;
    }

    private static boolean sockInUse(int sockNum) {
        for (int i = 0; i < socketCount; ++i) {
            if (opensockets[i] != sockNum) continue;
            return true;
        }
        return false;
    }

    private static void OpenSocket() {
        int sockNum = IPX.swapByte(CPU_Regs.reg_edx.word());
        if (socketCount >= 150) {
            CPU_Regs.reg_eax.low(254);
            return;
        }
        if (sockNum == 0) {
            int sockAlloc;
            for (sockAlloc = 16386; IPX.sockInUse(sockAlloc) && sockAlloc < Short.MAX_VALUE; ++sockAlloc) {
            }
            if (sockAlloc > Short.MAX_VALUE) {
                Log.log_msg("IPX: Out of dynamic sockets");
            }
            sockNum = sockAlloc;
        } else if (IPX.sockInUse(sockNum)) {
            CPU_Regs.reg_eax.low(255);
            return;
        }
        IPX.opensockets[IPX.socketCount] = sockNum;
        ++socketCount;
        CPU_Regs.reg_eax.low(0);
        CPU_Regs.reg_edx.word(IPX.swapByte(sockNum));
    }

    private static void CloseSocket() {
        ECBClass tmpECB = ECBList;
        ECBClass tmp2ECB = ECBList;
        int sockNum = IPX.swapByte(CPU_Regs.reg_edx.word());
        if (!IPX.sockInUse(sockNum)) {
            return;
        }
        for (int i = 0; i < socketCount - 1; ++i) {
            if (opensockets[i] != sockNum) continue;
            for (int j = i; j < 149; ++j) {
                IPX.opensockets[j] = opensockets[j + 1];
            }
            break;
        }
        --socketCount;
        while (tmpECB != null) {
            tmp2ECB = tmpECB.nextECB;
            if (tmpECB.getSocket() == sockNum) {
                tmpECB.setCompletionFlag(252);
                tmpECB.setInUseFlag(0);
                tmpECB.close();
            }
            tmpECB = tmp2ECB;
        }
    }

    private static void handleIpxRequest() {
        switch (CPU_Regs.reg_ebx.word()) {
            case 0: {
                IPX.OpenSocket();
                Log.log_msg(StringHelper.sprintf("IPX: Open socket %4x", new Object[]{new Integer(IPX.swapByte(CPU_Regs.reg_edx.word()))}));
                break;
            }
            case 1: {
                Log.log_msg(StringHelper.sprintf("IPX: Close socket %4x", new Object[]{new Integer(IPX.swapByte(CPU_Regs.reg_edx.word()))}));
                IPX.CloseSocket();
                break;
            }
            case 2: {
                for (int i = 0; i < 6; ++i) {
                    Memory.real_writeb(CPU.Segs_ESval, CPU_Regs.reg_edi.word() + i, Memory.real_readb(CPU.Segs_ESval, CPU_Regs.reg_esi.word() + i + 4));
                }
                CPU_Regs.reg_ecx.word(1);
                CPU_Regs.reg_eax.low(0);
                break;
            }
            case 3: {
                ECBClass tmpECB = new ECBClass(CPU.Segs_ESval, CPU_Regs.reg_esi.word());
                if (!IPX.incomingPacket.connected) {
                    tmpECB.setInUseFlag(0);
                    tmpECB.setCompletionFlag(254);
                    tmpECB.close();
                    CPU_Regs.reg_eax.low(255);
                    break;
                }
                tmpECB.setInUseFlag(255);
                CPU_Regs.reg_eax.low(0);
                IPX.sendPacket(tmpECB);
                break;
            }
            case 4: {
                ECBClass tmpECB = new ECBClass(CPU.Segs_ESval, CPU_Regs.reg_esi.word());
                if (!IPX.sockInUse(tmpECB.getSocket())) {
                    CPU_Regs.reg_eax.low(255);
                    tmpECB.setInUseFlag(0);
                    tmpECB.setCompletionFlag(255);
                    tmpECB.close();
                    break;
                }
                CPU_Regs.reg_eax.low(0);
                tmpECB.setInUseFlag(254);
                break;
            }
            case 5: 
            case 7: {
                ECBClass tmpECB = new ECBClass(CPU.Segs_ESval, CPU_Regs.reg_esi.word());
                Pic.PIC_AddEvent(IPX_AES_EventHandler, 54.9254f * (float)CPU_Regs.reg_eax.word(), tmpECB.ECBAddr);
                tmpECB.setInUseFlag(253);
                break;
            }
            case 6: {
                int ecbaddress = Memory.RealMake(CPU.Segs_ESval, CPU_Regs.reg_esi.word());
                ECBClass tmpECB = ECBList;
                while (tmpECB != null) {
                    ECBClass tmp2ECB = tmpECB.nextECB;
                    if (tmpECB.ECBAddr == ecbaddress) {
                        if (tmpECB.getInUseFlag() == 253) {
                            Pic.PIC_RemoveSpecificEvents(IPX_AES_EventHandler, ecbaddress);
                        }
                        tmpECB.setInUseFlag(0);
                        tmpECB.setCompletionFlag(252);
                        tmpECB.close();
                        CPU_Regs.reg_eax.low(0);
                        Log.log_msg("IPX: ECB canceled.");
                        return;
                    }
                    tmpECB = tmp2ECB;
                }
                CPU_Regs.reg_eax.low(255);
                break;
            }
            case 8: {
                CPU_Regs.reg_eax.word(Memory.mem_readw(1132));
                break;
            }
            case 9: {
                Log.log_msg(StringHelper.sprintf("IPX: Get internetwork address %2x:%2x:%2x:%2x:%2x:%2x", new Object[]{new Integer(IPX.localIpxAddr.netnode[5] & 0xFF), new Integer(IPX.localIpxAddr.netnode[4] & 0xFF), new Integer(IPX.localIpxAddr.netnode[3] & 0xFF), new Integer(IPX.localIpxAddr.netnode[2] & 0xFF), new Integer(IPX.localIpxAddr.netnode[1] & 0xFF), new Integer(IPX.localIpxAddr.netnode[0] & 0xFF)}));
                byte[] addrptr = localIpxAddr.toByteArray();
                for (int i = 0; i < 10; ++i) {
                    Memory.real_writeb(CPU.Segs_ESval, CPU_Regs.reg_esi.word() + i, addrptr[i]);
                }
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                CPU_Regs.reg_ecx.word(0);
                CPU_Regs.reg_eax.word(1024);
                break;
            }
            case 16: {
                CPU_Regs.reg_eax.low(0);
                break;
            }
            case 26: {
                CPU_Regs.reg_ecx.word(0);
                CPU_Regs.reg_eax.word(1424);
                break;
            }
            default: {
                Log.log_msg(StringHelper.sprintf("Unhandled IPX function: %4x", new Object[]{new Integer(CPU_Regs.reg_ebx.word())}));
            }
        }
    }

    private static void write16(OutputStream os, int value) throws IOException {
        os.write(value >> 8 & 0xFF);
        os.write(value & 0xFF);
    }

    private static void write32(OutputStream os, int value) throws IOException {
        os.write(value >> 24 & 0xFF);
        os.write(value >> 16 & 0xFF);
        os.write(value >> 8 & 0xFF);
        os.write(value & 0xFF);
    }

    private static short read16(InputStream is) throws IOException {
        int b = is.read() & 0xFF;
        int a = is.read() & 0xFF;
        return (short)(a | b << 8);
    }

    private static int read32(InputStream is) throws IOException {
        int d = is.read() & 0xFF;
        int c = is.read() & 0xFF;
        int b = is.read() & 0xFF;
        int a = is.read() & 0xFF;
        return a | b << 8 | c << 16 | d << 24;
    }

    private static void pingAck(IPaddress retAddr) {
        IPXHeader regHeader = new IPXHeader();
        regHeader.checkSum = (short)-1;
        regHeader.dest.network = 0;
        regHeader.dest.addr.setHost(retAddr.host);
        regHeader.dest.addr.setPort(retAddr.port);
        regHeader.dest.socket = (short)2;
        regHeader.src.network = 0;
        System.arraycopy(IPX.localIpxAddr.netnode, 0, regHeader.src.addr.byNode.node, 0, regHeader.src.addr.byNode.node.length);
        regHeader.src.socket = (short)2;
        regHeader.transControl = 0;
        regHeader.pType = 0;
        byte[] buf = regHeader.toByteArray();
        try {
            DatagramPacket packet = new DatagramPacket(buf, buf.length, ipxServConnIp, udpPort);
            ipxClientSocket.send(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void pingSend() {
        IPXHeader regHeader = new IPXHeader();
        regHeader.checkSum = (short)-1;
        regHeader.dest.network = 0;
        regHeader.dest.addr.setHost(-1);
        regHeader.dest.addr.setPort(65535);
        regHeader.dest.socket = (short)2;
        regHeader.src.network = 0;
        System.arraycopy(IPX.localIpxAddr.netnode, 0, regHeader.src.addr.byNode.node, 0, regHeader.src.addr.byNode.node.length);
        regHeader.src.socket = (short)2;
        regHeader.transControl = 0;
        regHeader.pType = 0;
        byte[] buf = regHeader.toByteArray();
        try {
            DatagramPacket packet = new DatagramPacket(buf, buf.length, ipxServConnIp, udpPort);
            ipxClientSocket.send(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void receivePacket(byte[] buffer, int bufSize) {
        IPXHeader tmpHeader = new IPXHeader();
        tmpHeader.load(buffer);
        int useSocket = tmpHeader.dest.socket & 0xFFFF;
        if (useSocket == 2 && tmpHeader.dest.addr.host() == -1 && tmpHeader.dest.addr.port() == 65535) {
            IPaddress tmpAddr = new IPaddress();
            tmpAddr.host = tmpHeader.src.addr.host();
            tmpAddr.port = tmpHeader.src.addr.port();
            IPX.pingAck(tmpAddr);
            return;
        }
        ECBClass useECB = ECBList;
        while (useECB != null) {
            ECBClass nextECB = useECB.nextECB;
            if (useECB.iuflag == 254 && useECB.mysocket == useSocket) {
                useECB.writeDataBuffer(buffer, bufSize);
                useECB.NotifyESR();
                return;
            }
            useECB = nextECB;
        }
    }

    private static void DisconnectFromServer(boolean unexpected) {
        if (unexpected) {
            Log.log_msg("IPX: Server disconnected unexpectedly");
        }
        if (IPX.incomingPacket.connected) {
            IPX.incomingPacket.connected = false;
            Timer.TIMER_DelTickHandler(IPX_ClientLoop);
            ipxClientSocket.close();
        }
        IPX.receiverThread.exit = true;
        try {
            receiverThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendPacket(ECBClass sendecb) {
        int m;
        byte[] outbuffer = new byte[1424];
        fragmentDescriptor tmpFrag = new fragmentDescriptor();
        sendecb.setInUseFlag(0);
        int packetsize = 0;
        int fragCount = sendecb.getFragCount();
        for (int i = 0; i < fragCount; ++i) {
            sendecb.getFragDesc(i, tmpFrag);
            if (i == 0) {
                int m2;
                for (m2 = 0; m2 < 4; ++m2) {
                    Memory.real_writeb(tmpFrag.segment, tmpFrag.offset + m2 + 18, IPX.localIpxAddr.netnum[m2]);
                }
                for (m2 = 0; m2 < 6; ++m2) {
                    Memory.real_writeb(tmpFrag.segment, tmpFrag.offset + m2 + 22, IPX.localIpxAddr.netnode[m2]);
                }
                Memory.real_writew(tmpFrag.segment, tmpFrag.offset + 28, IPX.swapByte(sendecb.getSocket()));
                Memory.real_writew(tmpFrag.segment, tmpFrag.offset, 65535);
            }
            for (int t = 0; t < tmpFrag.size; ++t) {
                outbuffer[packetsize] = (byte)Memory.real_readb(tmpFrag.segment, tmpFrag.offset + t);
                if (++packetsize < 1424) continue;
                Log.log_msg("IPX: Packet size to be sent greater than 1424 bytes.");
                sendecb.setCompletionFlag(254);
                sendecb.NotifyESR();
                return;
            }
        }
        outbuffer[3] = (byte)(packetsize & 0xFF);
        outbuffer[2] = (byte)(packetsize >> 8 & 0xFF);
        sendecb.getFragDesc(0, tmpFrag);
        Memory.real_writew(tmpFrag.segment, tmpFrag.offset + 2, IPX.swapByte(packetsize));
        byte[] immedAddr = new byte[6];
        sendecb.getImmAddress(immedAddr);
        boolean islocalbroadcast = true;
        boolean isloopback = true;
        for (m = 0; m < 4; ++m) {
            if (IPX.localIpxAddr.netnum[m] == outbuffer[m + 6]) continue;
            isloopback = false;
        }
        for (m = 0; m < 6; ++m) {
            if (IPX.localIpxAddr.netnode[m] != outbuffer[m + 10]) {
                isloopback = false;
            }
            if (immedAddr[m] == -1) continue;
            islocalbroadcast = false;
        }
        if (!isloopback) {
            DatagramPacket outPacket = new DatagramPacket(outbuffer, packetsize, ipxServConnIp, udpPort);
            try {
                ipxClientSocket.send(outPacket);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.log_msg("IPX: Could not send packet");
                sendecb.setCompletionFlag(255);
                sendecb.NotifyESR();
                IPX.DisconnectFromServer(true);
                return;
            }
            sendecb.setCompletionFlag(0);
        } else {
            sendecb.setCompletionFlag(0);
        }
        if (isloopback || islocalbroadcast) {
            IPX.receivePacket(outbuffer, packetsize);
        }
        sendecb.NotifyESR();
    }

    private static boolean pingCheck(IPXHeader outHeader) {
        int length = receiverThread.next(null);
        if (length > 0) {
            byte[] buffer = new byte[1024];
            System.arraycopy(IPX.receiverThread.recvBuffer, 0, buffer, 0, length);
            outHeader.load(buffer);
            return true;
        }
        return false;
    }

    private static boolean ConnectToServer(String strAddr) {
        try {
            int length;
            ipxServConnIp = InetAddress.getByName(strAddr);
            ipxClientSocket = new DatagramSocket();
            receiverThread = new ReceiverThread(ipxClientSocket);
            receiverThread.start();
            IPXHeader regHeader = new IPXHeader();
            regHeader.checkSum = (short)-1;
            regHeader.dest.network = 0;
            regHeader.dest.addr.setHost(0);
            regHeader.dest.addr.setPort(0);
            regHeader.dest.socket = (short)2;
            regHeader.src.network = 0;
            regHeader.src.addr.setHost(0);
            regHeader.src.addr.setPort(0);
            regHeader.src.socket = (short)2;
            regHeader.transControl = 0;
            byte[] outbuffer = regHeader.toByteArray();
            DatagramPacket outPacket = new DatagramPacket(outbuffer, outbuffer.length, ipxServConnIp, udpPort);
            try {
                ipxClientSocket.send(outPacket);
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.log_msg("IPX: Unable to connect to server");
                try {
                    ipxClientSocket.close();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                return false;
            }
            long ticks = Main.GetTicks();
            do {
                long elapsed;
                if ((elapsed = Main.GetTicks() - ticks) > 5000L) {
                    Log.log_msg("Timeout connecting to server at " + strAddr);
                    try {
                        ipxClientSocket.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    return false;
                }
                Callback.CALLBACK_Idle();
            } while ((length = receiverThread.next(null)) <= 0);
            regHeader.load(IPX.receiverThread.recvBuffer);
            System.arraycopy(regHeader.dest.addr.byNode.node, 0, IPX.localIpxAddr.netnode, 0, IPX.localIpxAddr.netnode.length);
            localIpxAddr.netnum(regHeader.dest.network);
            Log.log_msg(StringHelper.sprintf("IPX: Connected to server.  IPX address is %d:%d:%d:%d:%d:%d", new Object[]{new Integer(IPX.localIpxAddr.netnode[0] & 0xFF), new Integer(IPX.localIpxAddr.netnode[1] & 0xFF), new Integer(IPX.localIpxAddr.netnode[2] & 0xFF), new Integer(IPX.localIpxAddr.netnode[3] & 0xFF), new Integer(IPX.localIpxAddr.netnode[4] & 0xFF), new Integer(IPX.localIpxAddr.netnode[5] & 0xFF)}));
            IPX.incomingPacket.connected = true;
            Timer.TIMER_AddTickHandler(IPX_ClientLoop);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void IPX_NetworkInit() {
        IPX.localIpxAddr.netnum[0] = 0;
        IPX.localIpxAddr.netnum[1] = 0;
        IPX.localIpxAddr.netnum[2] = 0;
        IPX.localIpxAddr.netnum[3] = 1;
        IPX.localIpxAddr.netnode[0] = 0;
        IPX.localIpxAddr.netnode[1] = 0;
        IPX.localIpxAddr.netnode[2] = 0;
        IPX.localIpxAddr.netnode[3] = 0;
        IPX.localIpxAddr.netnode[4] = 0;
        IPX.localIpxAddr.netnode[5] = 0;
        socketCount = 0;
    }

    private IPX(Section configuration) {
        super(configuration);
        Section_prop section = (Section_prop)configuration;
        if (!section.Get_bool("ipx")) {
            return;
        }
        ECBList = null;
        ESRList = null;
        isIpxServer = false;
        isIpxConnected = false;
        IPX.IPX_NetworkInit();
        Dos_misc.DOS_AddMultiplexHandler(IPX_Multiplex);
        this.callback_ipx.Install(IPX_Handler, 1, "IPX Handler");
        ipx_callback = this.callback_ipx.Get_RealPointer();
        this.callback_ipxint.Install(IPX_IntHandler, 3, "IPX (int 7a)");
        this.callback_ipxint.Set_RealVec(122);
        this.callback_esr.Allocate(IPX_ESRHandler, "IPX_ESR");
        int call_ipxesr1 = this.callback_esr.Get_callback();
        if (dospage == 0) {
            dospage = Dos_tables.DOS_GetMemory(2);
        }
        int phyDospage = Memory.PhysMake(dospage, 0);
        Memory.phys_writeb(phyDospage + 0, 250);
        Memory.phys_writeb(phyDospage + 1, 96);
        Memory.phys_writeb(phyDospage + 2, 30);
        Memory.phys_writeb(phyDospage + 3, 6);
        Memory.phys_writew(phyDospage + 4, 40975);
        Memory.phys_writew(phyDospage + 6, 43023);
        Memory.phys_writeb(phyDospage + 8, 254);
        Memory.phys_writeb(phyDospage + 9, 56);
        Memory.phys_writew(phyDospage + 10, call_ipxesr1);
        Memory.phys_writew(phyDospage + 12, 43279);
        Memory.phys_writew(phyDospage + 14, 41231);
        Memory.phys_writeb(phyDospage + 16, 7);
        Memory.phys_writeb(phyDospage + 17, 31);
        Memory.phys_writeb(phyDospage + 18, 97);
        Memory.phys_writeb(phyDospage + 19, 207);
        int ESRRoutineBase = Memory.RealMake(dospage, 0);
        Memory.RealSetVec(115, ESRRoutineBase, this.old_73_vector);
        IO.IO_WriteB(161, IO.IO_ReadB(161) & 0xFFFFFFF7);
        Program.PROGRAMS_MakeFile("IPXNET.COM", IPXNET_ProgramStart);
    }

    private void close() {
        Section_prop section = (Section_prop)this.m_configuration;
        Pic.PIC_RemoveEvents(IPX_AES_EventHandler);
        if (!section.Get_bool("ipx")) {
            return;
        }
        if (isIpxServer) {
            isIpxServer = false;
            IPXServer.IPX_StopServer();
        }
        IPX.DisconnectFromServer(false);
        Dos_misc.DOS_DelMultiplexHandler(IPX_Multiplex);
        Memory.RealSetVec(115, this.old_73_vector.value);
        IO.IO_WriteB(161, IO.IO_ReadB(161) | 8);
        int phyDospage = Memory.PhysMake(dospage, 0);
        for (int i = 0; i < 32; ++i) {
            Memory.phys_writeb(phyDospage + i, 0);
        }
        Drive_virtual.VFILE_Remove("IPXNET.COM");
    }

    static {
        incomingPacket = new packetBuffer();
        opensockets = new int[150];
        ECBSerialNumber = 0;
        ECBAmount = 0;
        IPX_Multiplex = new Dos_system.MultiplexHandler(){

            public boolean call() {
                if (CPU_Regs.reg_eax.word() != 31232) {
                    return false;
                }
                CPU_Regs.reg_eax.low(255);
                CPU_Regs.SegSet16ES(Memory.RealSeg(ipx_callback));
                CPU_Regs.reg_edi.word(Memory.RealOff(ipx_callback));
                return true;
            }
        };
        IPX_AES_EventHandler = new Pic.PIC_EventHandler(){

            public void call(int param) {
                ECBClass tmpECB = ECBList;
                while (tmpECB != null) {
                    ECBClass tmp2ECB = tmpECB.nextECB;
                    if (tmpECB.iuflag == 253 && param == tmpECB.ECBAddr) {
                        tmpECB.setCompletionFlag(0);
                        tmpECB.setInUseFlag(0);
                        tmpECB.NotifyESR();
                        return;
                    }
                    tmpECB = tmp2ECB;
                }
                Log.log_msg("!!!! Rouge AES !!!!");
            }
        };
        IPX_Handler = new Callback.Handler(){

            public int call() {
                IPX.handleIpxRequest();
                return 0;
            }

            public String getName() {
                return "IPX";
            }
        };
        IPX_IntHandler = new Callback.Handler(){

            public int call() {
                IPX.handleIpxRequest();
                return 0;
            }

            public String getName() {
                return "IPX INT 7A";
            }
        };
        IPX_ClientLoop = new Timer.TIMER_TickHandler(){

            public void call() {
                int length = receiverThread.next(null);
                if (length > 0) {
                    IPX.receivePacket(receiverThread.recvBuffer, length);
                }
            }
        };
        IPXNET_ProgramStart = new Program.PROGRAMS_Main(){

            public Program call() {
                return new IPXNET();
            }
        };
        IPX_ESRHandler = new Callback.Handler(){

            public int call() {
                while (ESRList != null) {
                    if (ESRList.databuffer != null) {
                        ESRList.writeData();
                    }
                    if (ESRList.getESRAddr() != 0) {
                        CPU_Regs.SegSet16ES(Memory.RealSeg(ESRList.ECBAddr));
                        CPU_Regs.reg_esi.word(Memory.RealOff(ESRList.ECBAddr));
                        CPU_Regs.reg_eax.low(255);
                        Callback.CALLBACK_RunRealFar(Memory.RealSeg(ESRList.getESRAddr()), Memory.RealOff(ESRList.getESRAddr()));
                    }
                    ESRList.close();
                }
                IO.IO_WriteB(160, 99);
                IO.IO_WriteB(32, 98);
                return 0;
            }

            public String getName() {
                return "IPX ESR";
            }
        };
        IPX_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                test.close();
            }
        };
        IPX_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new IPX(section);
                section.AddDestroyFunction(IPX_ShutDown, true);
            }
        };
    }

    private static class IPXNET
    extends Program {
        private IPXNET() {
        }

        void HelpCommand(String helpStr) {
            if ("connect".equals(helpStr)) {
                this.WriteOut("IPXNET CONNECT opens a connection to an IPX tunneling server running on another\n");
                this.WriteOut("DosBox session.  The \"address\" parameter specifies the IP address or host name\n");
                this.WriteOut("of the server computer.  One can also specify the UDP port to use.  By default\n");
                this.WriteOut("IPXNET uses port 213, the assigned IANA port for IPX tunneling, for its\nconnection.\n\n");
                this.WriteOut("The syntax for IPXNET CONNECT is:\n\n");
                this.WriteOut("IPXNET CONNECT address <port>\n\n");
                return;
            }
            if ("disconnect".equals(helpStr)) {
                this.WriteOut("IPXNET DISCONNECT closes the connection to the IPX tunneling server.\n\n");
                this.WriteOut("The syntax for IPXNET DISCONNECT is:\n\n");
                this.WriteOut("IPXNET DISCONNECT\n\n");
                return;
            }
            if ("startserver".equals(helpStr)) {
                this.WriteOut("IPXNET STARTSERVER starts and IPX tunneling server on this DosBox session.  By\n");
                this.WriteOut("default, the server will accept connections on UDP port 213, though this can be\n");
                this.WriteOut("changed.  Once the server is started, DosBox will automatically start a client\n");
                this.WriteOut("connection to the IPX tunneling server.\n\n");
                this.WriteOut("The syntax for IPXNET STARTSERVER is:\n\n");
                this.WriteOut("IPXNET STARTSERVER <port>\n\n");
                return;
            }
            if ("stopserver".equals(helpStr)) {
                this.WriteOut("IPXNET STOPSERVER stops the IPX tunneling server running on this DosBox\nsession.");
                this.WriteOut("  Care should be taken to ensure that all other connections have\nterminated ");
                this.WriteOut("as well sinnce stoping the server may cause lockups on other\nmachines still using ");
                this.WriteOut("the IPX tunneling server.\n\n");
                this.WriteOut("The syntax for IPXNET STOPSERVER is:\n\n");
                this.WriteOut("IPXNET STOPSERVER\n\n");
                return;
            }
            if ("ping".equals(helpStr)) {
                this.WriteOut("IPXNET PING broadcasts a ping request through the IPX tunneled network.  In    \n");
                this.WriteOut("response, all other connected computers will respond to the ping and report\n");
                this.WriteOut("the time it took to receive and send the ping message.\n\n");
                this.WriteOut("The syntax for IPXNET PING is:\n\n");
                this.WriteOut("IPXNET PING\n\n");
                return;
            }
            if ("status".equals(helpStr)) {
                this.WriteOut("IPXNET STATUS reports the current state of this DosBox's sessions IPX tunneling\n");
                this.WriteOut("network.  For a list of the computers connected to the network use the IPXNET \n");
                this.WriteOut("PING command.\n\n");
                this.WriteOut("The syntax for IPXNET STATUS is:\n\n");
                this.WriteOut("IPXNET STATUS\n\n");
                return;
            }
        }

        public void Run() {
            this.WriteOut("IPX Tunneling utility for DosBox\n\n");
            if (this.cmd.GetCount() == 0) {
                this.WriteOut("The syntax of this command is:\n\n");
                this.WriteOut("IPXNET [ CONNECT | DISCONNECT | STARTSERVER | STOPSERVER | PING | HELP |\n         STATUS ]\n\n");
                return;
            }
            this.temp_line = this.cmd.FindCommand(1);
            if (this.temp_line != null) {
                this.temp_line = this.temp_line.toLowerCase();
                if ("help".equals(this.temp_line)) {
                    this.temp_line = this.cmd.FindCommand(2);
                    if (this.temp_line != null) {
                        this.HelpCommand(this.temp_line);
                        return;
                    }
                    this.WriteOut("The following are valid IPXNET commands:\n\n");
                    this.WriteOut("IPXNET CONNECT        IPXNET DISCONNECT       IPXNET STARTSERVER\n");
                    this.WriteOut("IPXNET STOPSERVER     IPXNET PING             IPXNET STATUS\n\n");
                    this.WriteOut("To get help on a specific command, type:\n\n");
                    this.WriteOut("IPXNET HELP command\n\n");
                    return;
                }
                if ("startserver".equals(this.temp_line)) {
                    if (!isIpxServer) {
                        boolean startsuccess;
                        if (incomingPacket.connected) {
                            this.WriteOut("IPX Tunneling Client alreadu connected to another server.  Disconnect first.\n");
                            return;
                        }
                        udpPort = 213;
                        this.temp_line = this.cmd.FindCommand(2);
                        if (this.temp_line != null) {
                            try {
                                udpPort = Integer.parseInt(this.temp_line);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (startsuccess = IPXServer.IPX_StartServer(udpPort)) {
                            this.WriteOut("IPX Tunneling Server started\n");
                            isIpxServer = true;
                            IPX.ConnectToServer("localhost");
                        } else {
                            this.WriteOut("IPX Tunneling Server failed to start.\n");
                            if (udpPort < 1024) {
                                this.WriteOut("Try a port number above 1024. See IPXNET HELP CONNECT on how to specify a port.\n");
                            }
                        }
                    } else {
                        this.WriteOut("IPX Tunneling Server already started\n");
                    }
                    return;
                }
                if ("stopserver".equals(this.temp_line)) {
                    if (!isIpxServer) {
                        this.WriteOut("IPX Tunneling Server not running in this DosBox session.\n");
                    } else {
                        isIpxServer = false;
                        IPX.DisconnectFromServer(false);
                        IPXServer.IPX_StopServer();
                        this.WriteOut("IPX Tunneling Server stopped.");
                    }
                    return;
                }
                if ("connect".equals(this.temp_line)) {
                    if (incomingPacket.connected) {
                        this.WriteOut("IPX Tunneling Client already connected.\n");
                        return;
                    }
                    this.temp_line = this.cmd.FindCommand(2);
                    if (this.temp_line == null) {
                        this.WriteOut("IPX Server address not specified.\n");
                        return;
                    }
                    String strHost = this.temp_line;
                    udpPort = 213;
                    this.temp_line = this.cmd.FindCommand(3);
                    if (this.temp_line != null) {
                        try {
                            udpPort = Integer.parseInt(this.temp_line);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (IPX.ConnectToServer(strHost)) {
                        this.WriteOut("IPX Tunneling Client connected to server at " + strHost + ".\n");
                    } else {
                        this.WriteOut("IPX Tunneling Client failed to connect to server at " + strHost + ".\n");
                    }
                    return;
                }
                if ("disconnect".equals(this.temp_line)) {
                    if (!incomingPacket.connected) {
                        this.WriteOut("IPX Tunneling Client not connected.\n");
                        return;
                    }
                    this.WriteOut("IPX Tunneling Client disconnected from server.\n");
                    IPX.DisconnectFromServer(false);
                    return;
                }
                if ("status".equals(this.temp_line)) {
                    this.WriteOut("IPX Tunneling Status:\n\n");
                    this.WriteOut("Server status: ");
                    if (isIpxServer) {
                        this.WriteOut("ACTIVE\n");
                    } else {
                        this.WriteOut("INACTIVE\n");
                    }
                    this.WriteOut("Client status: ");
                    if (incomingPacket.connected) {
                        this.WriteOut("CONNECTED -- Server at " + ipxServConnIp.getHostAddress() + " port " + udpPort + "\n");
                    } else {
                        this.WriteOut("DISCONNECTED\n");
                    }
                    if (isIpxServer) {
                        this.WriteOut("List of active connections:\n\n");
                        for (int i = 0; i < 150; ++i) {
                            IPXAddress addr = IPXServer.IPX_isConnectedToServer(i);
                            if (addr == null) continue;
                            this.WriteOut("     " + addr.address.getHostAddress() + " from port " + addr.port + "\n");
                        }
                        this.WriteOut("\n");
                    }
                    return;
                }
                if ("ping".equals(this.temp_line)) {
                    IPXHeader pingHead = new IPXHeader();
                    if (!incomingPacket.connected) {
                        this.WriteOut("IPX Tunneling Client not connected.\n");
                        return;
                    }
                    Timer.TIMER_DelTickHandler(IPX_ClientLoop);
                    this.WriteOut("Sending broadcast ping:\n\n");
                    IPX.pingSend();
                    long ticks = Main.GetTicks();
                    while (Main.GetTicks() - ticks < 1500L) {
                        Callback.CALLBACK_Idle();
                        if (!IPX.pingCheck(pingHead)) continue;
                        this.WriteOut("Response from " + pingHead.src.addr.hostAsString() + ", port " + pingHead.src.addr.port() + " time=" + String.valueOf(Main.GetTicks() - ticks) + "ms\n");
                    }
                    Timer.TIMER_AddTickHandler(IPX_ClientLoop);
                    return;
                }
            }
        }
    }

    static final class ReceiverThread
    extends Thread {
        boolean exit = false;
        Object signal = new Object();
        boolean ready = false;
        DatagramPacket receivePacket;
        byte[] tmpBuffer = new byte[1424];
        DatagramSocket socket;
        byte[] recvBuffer = new byte[1424];

        public ReceiverThread(DatagramSocket socket) {
            this.socket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int next(IPXAddress address) {
            Object object = this.signal;
            synchronized (object) {
                if (this.ready) {
                    System.arraycopy(this.tmpBuffer, 0, this.recvBuffer, 0, 1424);
                    this.ready = false;
                    int result = this.receivePacket.getLength();
                    if (address != null) {
                        address.address = this.receivePacket.getAddress();
                        address.port = this.receivePacket.getPort();
                    }
                    this.signal.notify();
                    return result;
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.exit = false;
            while (!this.exit) {
                this.receivePacket = new DatagramPacket(this.tmpBuffer, 1424);
                try {
                    this.socket.receive(this.receivePacket);
                    Object object = this.signal;
                    synchronized (object) {
                        this.ready = true;
                        this.signal.wait();
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private static class ECBClass {
        public int ECBAddr;
        public boolean isInESRList;
        ECBClass prevECB;
        ECBClass nextECB;
        public int iuflag;
        public int mysocket;
        public byte[] databuffer;
        public int buflen;
        public int SerialNumber;

        public ECBClass(int segment, int offset) {
            this.ECBAddr = Memory.RealMake(segment, offset);
            this.databuffer = null;
            this.isInESRList = false;
            this.prevECB = null;
            this.nextECB = null;
            if (ECBList == null) {
                ECBList = this;
            } else {
                ECBClass useECB = ECBList;
                while (useECB.nextECB != null) {
                    useECB = useECB.nextECB;
                }
                useECB.nextECB = this;
                this.prevECB = useECB;
            }
            this.iuflag = this.getInUseFlag();
            this.mysocket = this.getSocket();
        }

        public int getSocket() {
            return IPX.swapByte(Memory.real_readw(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 10));
        }

        public byte getInUseFlag() {
            return (byte)Memory.real_readb(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 8);
        }

        public void setInUseFlag(int flagval) {
            this.iuflag = flagval;
            Memory.real_writeb(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 8, flagval);
        }

        public void setCompletionFlag(int flagval) {
            Memory.real_writeb(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 9, flagval);
        }

        public int getFragCount() {
            return Memory.real_readw(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 34);
        }

        public boolean writeData() {
            int length = this.buflen;
            byte[] buffer = this.databuffer;
            fragmentDescriptor tmpFrag = new fragmentDescriptor();
            this.setInUseFlag(0);
            int fragCount = this.getFragCount();
            int bufoffset = 0;
            for (int i = 0; i < fragCount; ++i) {
                this.getFragDesc(i, tmpFrag);
                for (int t = 0; t < tmpFrag.size; ++t) {
                    Memory.real_writeb(tmpFrag.segment, tmpFrag.offset + t, buffer[bufoffset]);
                    if (++bufoffset < length) continue;
                    this.setCompletionFlag(0);
                    this.setImmAddress(buffer, 22);
                    return true;
                }
            }
            if (bufoffset < length) {
                this.setCompletionFlag(253);
                return false;
            }
            return false;
        }

        public void writeDataBuffer(byte[] buffer, int length) {
            this.databuffer = new byte[length];
            System.arraycopy(buffer, 0, this.databuffer, 0, length);
            this.buflen = length;
        }

        public void getFragDesc(int descNum, fragmentDescriptor fragDesc) {
            int memoff = Memory.RealOff(this.ECBAddr) + 30 + (descNum + 1) * 6;
            fragDesc.offset = Memory.real_readw(Memory.RealSeg(this.ECBAddr), memoff);
            fragDesc.segment = Memory.real_readw(Memory.RealSeg(this.ECBAddr), memoff += 2);
            fragDesc.size = Memory.real_readw(Memory.RealSeg(this.ECBAddr), memoff += 2);
        }

        public int getESRAddr() {
            return Memory.RealMake(Memory.real_readw(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 6), Memory.real_readw(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 4));
        }

        public void NotifyESR() {
            long ESRval = Memory.real_readd(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 4);
            if (ESRval != 0L || this.databuffer != null) {
                if (this.prevECB == null) {
                    ECBList = this.nextECB;
                    if (ECBList != null) {
                        ECBList.prevECB = null;
                    }
                } else {
                    this.prevECB.nextECB = this.nextECB;
                    if (this.nextECB != null) {
                        this.nextECB.prevECB = this.prevECB;
                    }
                }
                this.nextECB = null;
                if (ESRList == null) {
                    ESRList = this;
                    this.prevECB = null;
                } else {
                    ECBClass useECB = ESRList;
                    while (useECB.nextECB != null) {
                        useECB = useECB.nextECB;
                    }
                    useECB.nextECB = this;
                    this.prevECB = useECB;
                }
                this.isInESRList = true;
                Pic.PIC_ActivateIRQ(11);
            } else {
                this.close();
            }
        }

        public void setImmAddress(byte[] immAddr, int off) {
            for (int i = 0; i < 6; ++i) {
                Memory.real_writeb(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 28 + i, immAddr[i + off]);
            }
        }

        public void getImmAddress(byte[] immAddr) {
            for (int i = 0; i < 6; ++i) {
                immAddr[i] = (byte)Memory.real_readb(Memory.RealSeg(this.ECBAddr), Memory.RealOff(this.ECBAddr) + 28 + i);
            }
        }

        public void close() {
            if (this.isInESRList) {
                ESRList = this.nextECB;
            } else if (this.prevECB == null) {
                ECBList = this.nextECB;
                if (ECBList != null) {
                    ECBList.prevECB = null;
                }
            } else {
                this.prevECB.nextECB = this.nextECB;
                if (this.nextECB != null) {
                    this.nextECB.prevECB = this.prevECB;
                }
            }
        }
    }

    private static final class fragmentDescriptor {
        int offset;
        int segment;
        int size;

        private fragmentDescriptor() {
        }
    }

    private static final class ipxnetaddr {
        byte[] netnum = new byte[4];
        byte[] netnode = new byte[6];

        private ipxnetaddr() {
        }

        public byte[] toByteArray() {
            byte[] result = new byte[10];
            System.arraycopy(this.netnum, 0, result, 0, 4);
            System.arraycopy(this.netnode, 0, result, 4, 6);
            return result;
        }

        public int netnum() {
            return this.netnum[3] & 0xFF | (this.netnum[2] & 0xFF) << 8 | (this.netnum[1] & 0xFF) << 16 | (this.netnum[0] & 0xFF) << 24;
        }

        public void netnum(int num) {
            this.netnum[3] = (byte)(num & 0xFF);
            this.netnum[2] = (byte)(num >> 8 & 0xFF);
            this.netnum[1] = (byte)(num >> 16 & 0xFF);
            this.netnum[0] = (byte)(num >> 24 & 0xFF);
        }
    }

    private static final class IPaddress {
        int host;
        int port;

        private IPaddress() {
        }
    }

    static final class IPXHeader {
        short checkSum;
        short length = (short)30;
        short transControl;
        short pType;
        final transport dest = new transport();
        final transport src = new transport();

        IPXHeader() {
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                IPX.write16(bos, this.checkSum);
                IPX.write16(bos, this.length);
                bos.write(this.transControl);
                bos.write(this.pType);
                IPX.write32(bos, this.dest.network);
                bos.write(this.dest.addr.byNode.node);
                IPX.write16(bos, this.dest.socket);
                IPX.write32(bos, this.src.network);
                bos.write(this.src.addr.byNode.node);
                IPX.write16(bos, this.src.socket);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return bos.toByteArray();
        }

        void load(byte[] data) {
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            try {
                this.checkSum = IPX.read16(bis);
                this.length = IPX.read16(bis);
                this.transControl = (short)bis.read();
                this.pType = (short)bis.read();
                this.dest.network = IPX.read32(bis);
                bis.read(this.dest.addr.byNode.node);
                this.dest.socket = IPX.read16(bis);
                this.src.network = IPX.read32(bis);
                bis.read(this.src.addr.byNode.node);
                this.src.socket = IPX.read16(bis);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public static class transport {
            int network;
            final addrtype addr = new addrtype();
            short socket;

            public static class addrtype {
                nodeType byNode = new nodeType();

                public void setHost(int host) {
                    this.byNode.node[0] = (byte)(host & 0xFF);
                    this.byNode.node[1] = (byte)(host >> 8 & 0xFF);
                    this.byNode.node[2] = (byte)(host >> 16 & 0xFF);
                    this.byNode.node[3] = (byte)(host >> 24 & 0xFF);
                }

                public void setPort(int port) {
                    this.byNode.node[4] = (byte)(port & 0xFF);
                    this.byNode.node[5] = (byte)(port >> 8 & 0xFF);
                }

                public int host() {
                    return this.byNode.node[0] & 0xFF | (this.byNode.node[1] & 0xFF) << 8 | (this.byNode.node[2] & 0xFF) << 16 | (this.byNode.node[3] & 0xFF) << 24;
                }

                public String hostAsString() {
                    return (this.byNode.node[0] & 0xFF) + "." + (this.byNode.node[1] & 0xFF) + "." + (this.byNode.node[2] & 0xFF) + "." + (this.byNode.node[3] & 0xFF);
                }

                public int port() {
                    return this.byNode.node[4] & 0xFF | (this.byNode.node[5] & 0xFF) << 8;
                }
            }
        }
    }

    public static final class nodeType {
        public byte[] node = new byte[6];
    }

    public static final class packetBuffer {
        byte[] buffer = new byte[1024];
        short packetSize;
        short packetRead;
        boolean inPacket;
        boolean connected;
        boolean waitsize;
    }

    static final class IPXAddress {
        InetAddress address;
        int host;
        int port;

        IPXAddress() {
        }
    }
}

