/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.IoHandler;
import jdos.hardware.Pic;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.sdl.SDL_Mapper;

public class Joystick
extends Module_base {
    private static final int RANGE = 64;
    private static final int TIMEOUT = 10;
    private static final int OHMS = 60000;
    private static final float JOY_S_CONSTANT = 2.42E-5f;
    private static final float S_PER_OHM = 1.1E-8f;
    int joytype;
    static Stick[] stick = new Stick[2];
    private static long last_write = 0L;
    private static boolean write_active = false;
    private static boolean swap34 = false;
    private static boolean button_wrapping_enabled = true;
    private static IoHandler.IO_ReadHandler read_p201 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            if (write_active && (long)Pic.PIC_Ticks - last_write > 10L) {
                write_active = false;
                Joystick.stick[0].xcount = 0;
                Joystick.stick[1].xcount = 0;
                Joystick.stick[0].ycount = 0;
                Joystick.stick[1].ycount = 0;
            }
            int ret = 255;
            if (Joystick.stick[0].enabled) {
                if (Joystick.stick[0].xcount != 0) {
                    --Joystick.stick[0].xcount;
                } else {
                    ret = (short)(ret & 0xFFFFFFFE);
                }
                if (Joystick.stick[0].ycount != 0) {
                    --Joystick.stick[0].ycount;
                } else {
                    ret = (short)(ret & 0xFFFFFFFD);
                }
                if (Joystick.stick[0].button[0]) {
                    ret = (short)(ret & 0xFFFFFFEF);
                }
                if (Joystick.stick[0].button[1]) {
                    ret = (short)(ret & 0xFFFFFFDF);
                }
            }
            if (Joystick.stick[1].enabled) {
                if (Joystick.stick[1].xcount != 0) {
                    --Joystick.stick[1].xcount;
                } else {
                    ret = (short)(ret & 0xFFFFFFFB);
                }
                if (Joystick.stick[1].ycount != 0) {
                    --Joystick.stick[1].ycount;
                } else {
                    ret = (short)(ret & 0xFFFFFFF7);
                }
                if (Joystick.stick[1].button[0]) {
                    ret = (short)(ret & 0xFFFFFFBF);
                }
                if (Joystick.stick[1].button[1]) {
                    ret = (short)(ret & 0xFFFFFF7F);
                }
            }
            return ret;
        }
    };
    private static IoHandler.IO_ReadHandler read_p201_timed = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int ret = 255;
            double currentTick = Pic.PIC_FullIndex();
            if (Joystick.stick[0].enabled) {
                if (Joystick.stick[0].xtick < currentTick) {
                    ret = (short)(ret & 0xFFFFFFFE);
                }
                if (Joystick.stick[0].ytick < currentTick) {
                    ret = (short)(ret & 0xFFFFFFFD);
                }
            }
            if (Joystick.stick[1].enabled) {
                if (Joystick.stick[1].xtick < currentTick) {
                    ret = (short)(ret & 0xFFFFFFFB);
                }
                if (Joystick.stick[1].ytick < currentTick) {
                    ret = (short)(ret & 0xFFFFFFF7);
                }
            }
            if (Joystick.stick[0].enabled) {
                if (Joystick.stick[0].button[0]) {
                    ret = (short)(ret & 0xFFFFFFEF);
                }
                if (Joystick.stick[0].button[1]) {
                    ret = (short)(ret & 0xFFFFFFDF);
                }
            }
            if (Joystick.stick[1].enabled) {
                if (Joystick.stick[1].button[0]) {
                    ret = (short)(ret & 0xFFFFFFBF);
                }
                if (Joystick.stick[1].button[1]) {
                    ret = (short)(ret & 0xFFFFFF7F);
                }
            }
            return ret;
        }
    };
    private static IoHandler.IO_WriteHandler write_p201 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            write_active = true;
            last_write = Pic.PIC_Ticks;
            if (Joystick.stick[0].enabled) {
                Joystick.stick[0].xcount = (int)(Joystick.stick[0].xpos * 64.0f + 64.0f);
                Joystick.stick[0].ycount = (int)(Joystick.stick[0].ypos * 64.0f + 64.0f);
            }
            if (Joystick.stick[1].enabled) {
                Joystick.stick[1].xcount = (int)((swap34 ? Joystick.stick[1].ypos : Joystick.stick[1].xpos) * 64.0f + 64.0f);
                Joystick.stick[1].ycount = (int)((swap34 ? Joystick.stick[1].xpos : Joystick.stick[1].ypos) * 64.0f + 64.0f);
            }
        }
    };
    private static IoHandler.IO_WriteHandler write_p201_timed = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            double currentTick = Pic.PIC_FullIndex();
            if (Joystick.stick[0].enabled) {
                Joystick.stick[0].xtick = currentTick + 1000.0 * ((double)2.42E-5f + (double)1.1E-8f * (((double)Joystick.stick[0].xpos + 1.0) * 60000.0));
                Joystick.stick[0].ytick = currentTick + 1000.0 * ((double)2.42E-5f + (double)1.1E-8f * (((double)Joystick.stick[0].ypos + 1.0) * 60000.0));
            }
            if (Joystick.stick[1].enabled) {
                Joystick.stick[1].xtick = currentTick + 1000.0 * ((double)2.42E-5f + (double)1.1E-8f * ((double)(swap34 ? Joystick.stick[1].ypos : Joystick.stick[1].xpos) + 1.0) * 60000.0);
                Joystick.stick[1].ytick = currentTick + 1000.0 * ((double)2.42E-5f + (double)1.1E-8f * ((double)(swap34 ? Joystick.stick[1].xpos : Joystick.stick[1].ypos) + 1.0) * 60000.0);
            }
        }
    };
    private IoHandler.IO_ReadHandleObject ReadHandler = new IoHandler.IO_ReadHandleObject();
    private IoHandler.IO_WriteHandleObject WriteHandler = new IoHandler.IO_WriteHandleObject();
    static Joystick test;
    public static Section.SectionFunction JOYSTICK_Destroy;
    public static Section.SectionFunction JOYSTICK_Init;

    public static void JOYSTICK_Enable(int which, boolean enabled) {
        if (which < 2) {
            Joystick.stick[which].enabled = enabled;
        }
    }

    public static void JOYSTICK_Button(int which, int num, boolean pressed) {
        if (which < 2 && num < 2) {
            Joystick.stick[which].button[num] = pressed;
        }
    }

    public static void JOYSTICK_Move_X(int which, float x) {
        if (which < 2) {
            Joystick.stick[which].xpos = x;
        }
    }

    public static void JOYSTICK_Move_Y(int which, float y) {
        if (which < 2) {
            Joystick.stick[which].ypos = y;
        }
    }

    public static boolean JOYSTICK_IsEnabled(int which) {
        if (which < 2) {
            return Joystick.stick[which].enabled;
        }
        return false;
    }

    public static boolean JOYSTICK_GetButton(int which, int num) {
        if (which < 2 && num < 2) {
            return Joystick.stick[which].button[num];
        }
        return false;
    }

    public static float JOYSTICK_GetMove_X(int which) {
        if (which < 2) {
            return Joystick.stick[which].xpos;
        }
        return 0.0f;
    }

    public static float JOYSTICK_GetMove_Y(int which) {
        if (which < 2) {
            return Joystick.stick[which].ypos;
        }
        return 0.0f;
    }

    public Joystick(Section configuration) {
        super(configuration);
        Section_prop section = (Section_prop)configuration;
        String type = section.Get_string("joysticktype");
        this.joytype = type.equalsIgnoreCase("none") ? 0 : (type.equalsIgnoreCase("false") ? 0 : (type.equalsIgnoreCase("auto") ? 1 : (type.equalsIgnoreCase("2axis") ? 2 : (type.equalsIgnoreCase("4axis") ? 3 : (type.equalsIgnoreCase("4axis_2") ? 4 : (type.equalsIgnoreCase("fcs") ? 5 : (type.equalsIgnoreCase("ch") ? 6 : 1)))))));
        boolean timed = section.Get_bool("timed");
        if (timed) {
            this.ReadHandler.Install(513, read_p201_timed, 1);
            this.WriteHandler.Install(513, write_p201_timed, 1);
        } else {
            this.ReadHandler.Install(513, read_p201, 1);
            this.WriteHandler.Install(513, write_p201, 1);
        }
        SDL_Mapper.autofire = section.Get_bool("autofire");
        swap34 = section.Get_bool("swap34");
        button_wrapping_enabled = section.Get_bool("buttonwrap");
        Joystick.stick[0].enabled = false;
        Joystick.stick[1].enabled = false;
        Joystick.stick[1].xtick = Joystick.stick[1].ytick = Pic.PIC_FullIndex();
        Joystick.stick[0].ytick = Joystick.stick[1].ytick;
        Joystick.stick[0].xtick = Joystick.stick[1].ytick;
    }

    static {
        JOYSTICK_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                test = null;
                for (int i = 0; i < stick.length; ++i) {
                    Joystick.stick[i] = null;
                }
            }
        };
        JOYSTICK_Init = new Section.SectionFunction(){

            public void call(Section section) {
                for (int i = 0; i < stick.length; ++i) {
                    Joystick.stick[i] = new Stick();
                }
                test = new Joystick(section);
                section.AddDestroyFunction(JOYSTICK_Destroy, true);
            }
        };
    }

    private static class Stick {
        boolean enabled;
        float xpos;
        float ypos;
        double xtick;
        double ytick;
        int xcount;
        int ycount;
        boolean[] button = new boolean[2];

        private Stick() {
        }
    }

    private static final class JoystickType {
        public static final int JOY_NONE = 0;
        public static final int JOY_AUTO = 1;
        public static final int JOY_2AXIS = 2;
        public static final int JOY_4AXIS = 3;
        public static final int JOY_4AXIS_2 = 4;
        public static final int JOY_FCS = 5;
        public static final int JOY_CH = 6;

        private JoystickType() {
        }
    }
}

