/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.cpu.CPU;
import jdos.gui.Midi;
import jdos.hardware.IoHandler;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;

public class MPU401
extends Module_base {
    private static final int MPU401_VERSION = 21;
    private static final int MPU401_REVISION = 1;
    private static final int MPU401_QUEUE = 32;
    private static final float MPU401_TIMECONSTANT = 60000.0f;
    private static final int M_UART = 0;
    private static final int M_INTELLIGENT = 1;
    private static final int T_OVERFLOW = 0;
    private static final int T_MARK = 1;
    private static final int T_MIDI_SYS = 2;
    private static final int T_MIDI_NORM = 3;
    private static final int T_COMMAND = 4;
    private static final int MSG_EOX = 247;
    private static final int MSG_OVERFLOW = 248;
    private static final int MSG_MARK = 252;
    private static final int MSG_MPU_OVERFLOW = 248;
    private static final int MSG_MPU_COMMAND_REQ = 249;
    private static final int MSG_MPU_END = 252;
    private static final int MSG_MPU_CLOCK = 253;
    private static final int MSG_MPU_ACK = 254;
    private static final MPU mpu = new MPU();
    private static final IoHandler.IO_ReadHandler MPU401_ReadStatus = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int ret = 63;
            if (mpu.queue_used == 0) {
                ret = (short)(ret | 0x80);
            }
            return ret;
        }
    };
    private static final IoHandler.IO_WriteHandler MPU401_WriteCommand = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            block44: {
                block43: {
                    mpu.state.reset = false;
                    if (val > 47) break block43;
                    switch (val & 3) {
                        case 1: {
                            Midi.MIDI_RawOutByte(252);
                            break;
                        }
                        case 2: {
                            Midi.MIDI_RawOutByte(250);
                            break;
                        }
                        case 3: {
                            Midi.MIDI_RawOutByte(251);
                        }
                    }
                    if ((val & 0x20) != 0) {
                        Log.log(21, 2, "MPU-401:Unhandled Recording Command " + Integer.toString(val, 16));
                    }
                    switch (val & 0xC) {
                        case 4: {
                            Pic.PIC_RemoveEvents(MPU401_Event);
                            mpu.state.playing = false;
                            for (int i = 176; i < 191; ++i) {
                                Midi.MIDI_RawOutByte(i);
                                Midi.MIDI_RawOutByte(123);
                                Midi.MIDI_RawOutByte(0);
                            }
                            break block44;
                        }
                        case 8: {
                            Log.log(21, 0, "MPU-401:Intelligent mode playback started");
                            mpu.state.playing = true;
                            Pic.PIC_RemoveEvents(MPU401_Event);
                            Pic.PIC_AddEvent(MPU401_Event, 60000.0f / (float)(mpu.clock.tempo * mpu.clock.timebase));
                            MPU401.ClrQueue();
                        }
                    }
                    break block44;
                }
                if (val >= 160 && val <= 167) {
                    if ((mpu.state.cmask & 1 << (val & 7)) != 0) {
                        MPU401.QueueByte(mpu.playbuf[val & 7].counter);
                    }
                } else if (val >= 208 && val <= 215) {
                    mpu.state.old_chan = mpu.state.channel;
                    mpu.state.channel = (short)(val & 7);
                    mpu.state.wsd = true;
                    mpu.state.wsm = false;
                    mpu.state.wsd_start = true;
                } else {
                    switch (val) {
                        case 223: {
                            mpu.state.wsd = false;
                            mpu.state.wsm = true;
                            mpu.state.wsd_start = true;
                            break;
                        }
                        case 142: {
                            mpu.state.cond_set = false;
                            break;
                        }
                        case 143: {
                            mpu.state.cond_set = true;
                            break;
                        }
                        case 148: {
                            mpu.clock.clock_to_host = false;
                            break;
                        }
                        case 149: {
                            mpu.clock.clock_to_host = true;
                            break;
                        }
                        case 194: {
                            mpu.clock.timebase = (short)48;
                            break;
                        }
                        case 195: {
                            mpu.clock.timebase = (short)72;
                            break;
                        }
                        case 196: {
                            mpu.clock.timebase = (short)96;
                            break;
                        }
                        case 197: {
                            mpu.clock.timebase = (short)120;
                            break;
                        }
                        case 198: {
                            mpu.clock.timebase = (short)144;
                            break;
                        }
                        case 199: {
                            mpu.clock.timebase = (short)168;
                            break;
                        }
                        case 200: {
                            mpu.clock.timebase = (short)192;
                            break;
                        }
                        case 224: 
                        case 225: 
                        case 226: 
                        case 228: 
                        case 230: 
                        case 231: 
                        case 236: 
                        case 237: 
                        case 238: 
                        case 239: {
                            mpu.state.command_byte = val;
                            break;
                        }
                        case 171: {
                            MPU401.QueueByte(254);
                            MPU401.QueueByte(0);
                            return;
                        }
                        case 172: {
                            MPU401.QueueByte(254);
                            MPU401.QueueByte(21);
                            return;
                        }
                        case 173: {
                            MPU401.QueueByte(254);
                            MPU401.QueueByte(1);
                            return;
                        }
                        case 175: {
                            MPU401.QueueByte(254);
                            MPU401.QueueByte(mpu.clock.tempo);
                            return;
                        }
                        case 177: {
                            mpu.clock.tempo_rel = (short)40;
                            break;
                        }
                        case 184: 
                        case 185: {
                            int i;
                            for (i = 176; i < 191; ++i) {
                                Midi.MIDI_RawOutByte(i);
                                Midi.MIDI_RawOutByte(123);
                                Midi.MIDI_RawOutByte(0);
                            }
                            for (i = 0; i < 8; ++i) {
                                mpu.playbuf[i].counter = 0;
                                mpu.playbuf[i].type = 0;
                            }
                            mpu.condbuf.counter = 0;
                            mpu.condbuf.type = 0;
                            mpu.state.conductor = mpu.state.cond_set;
                            if (!mpu.state.conductor) {
                                mpu.state.cond_req = false;
                            }
                            mpu.state.amask = mpu.state.tmask;
                            mpu.state.req_mask = 0;
                            mpu.state.irq_pending = true;
                            break;
                        }
                        case 255: {
                            mpu.state.reset = true;
                            if (CPU.CPU_Cycles > 5) {
                                CPU.CPU_CycleLeft += CPU.CPU_Cycles;
                                CPU.CPU_Cycles = 5;
                            }
                            MPU401.MPU401_Reset();
                            break;
                        }
                        case 63: {
                            mpu.mode = 0;
                            break;
                        }
                    }
                }
            }
            MPU401.QueueByte(254);
        }
    };
    private static final IoHandler.IO_ReadHandler MPU401_ReadData = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            int ret = 254;
            if (mpu.queue_used != 0) {
                if (mpu.queue_pos >= 32) {
                    mpu.queue_pos -= 32;
                }
                ret = mpu.queue[mpu.queue_pos];
                ++mpu.queue_pos;
                --mpu.queue_used;
            }
            if (!mpu.intelligent) {
                return ret;
            }
            if (mpu.queue_used == 0) {
                Pic.PIC_DeActivateIRQ(mpu.irq);
            }
            if (ret >= 240 && ret <= 247) {
                mpu.state.channel = (short)(ret & 7);
                mpu.state.data_onoff = 0;
                mpu.state.cond_req = false;
            }
            if (ret == 249) {
                mpu.state.data_onoff = 0;
                mpu.state.cond_req = true;
                if (mpu.condbuf.type != 0) {
                    mpu.state.block_ack = true;
                    MPU401_WriteCommand.call(817, mpu.condbuf.value[0], 1);
                    if (mpu.state.command_byte != 0) {
                        MPU401_WriteData.call(816, mpu.condbuf.value[1], 1);
                    }
                }
                mpu.condbuf.type = 0;
            }
            if (ret == 252 || ret == 253 || ret == 254) {
                mpu.state.data_onoff = -1;
                MPU401.MPU401_EOIHandler();
            }
            return ret;
        }
    };
    private static int length;
    private static int cnt;
    private static int posd;
    private static final IoHandler.IO_WriteHandler MPU401_WriteData;
    private static final Pic.PIC_EventHandler MPU401_Event;
    private IoHandler.IO_ReadHandleObject[] ReadHandler = new IoHandler.IO_ReadHandleObject[2];
    private IoHandler.IO_WriteHandleObject[] WriteHandler = new IoHandler.IO_WriteHandleObject[2];
    private boolean installed = false;
    private static MPU401 test;
    public static Section.SectionFunction MPU401_Destroy;
    public static Section.SectionFunction MPU401_Init;

    private static void QueueByte(int data) {
        if (MPU401.mpu.state.block_ack) {
            MPU401.mpu.state.block_ack = false;
            return;
        }
        if (MPU401.mpu.queue_used == 0 && MPU401.mpu.intelligent) {
            MPU401.mpu.state.irq_pending = true;
            Pic.PIC_ActivateIRQ(MPU401.mpu.irq);
        }
        if (MPU401.mpu.queue_used < 32) {
            int pos = MPU401.mpu.queue_used + MPU401.mpu.queue_pos;
            if (MPU401.mpu.queue_pos >= 32) {
                MPU401.mpu.queue_pos -= 32;
            }
            if (pos >= 32) {
                pos -= 32;
            }
            ++MPU401.mpu.queue_used;
            MPU401.mpu.queue[pos] = (short)data;
        } else {
            Log.log(21, 0, "MPU401:Data queue full");
        }
    }

    private static void ClrQueue() {
        MPU401.mpu.queue_used = 0;
        MPU401.mpu.queue_pos = 0;
    }

    private static void MPU401_IntelligentOut(int chan) {
        switch (MPU401.mpu.playbuf[chan].type) {
            case 0: {
                break;
            }
            case 1: {
                short val = MPU401.mpu.playbuf[chan].sys_val;
                if (val != 252) break;
                Midi.MIDI_RawOutByte(val);
                MPU401.mpu.state.amask = (short)(MPU401.mpu.state.amask & ~(1 << chan));
                MPU401.mpu.state.req_mask &= ~(1 << chan);
                break;
            }
            case 3: {
                for (int i = 0; i < MPU401.mpu.playbuf[chan].vlength; ++i) {
                    Midi.MIDI_RawOutByte(MPU401.mpu.playbuf[chan].value[i]);
                }
                break;
            }
        }
    }

    private static void UpdateTrack(int chan) {
        MPU401.MPU401_IntelligentOut(chan);
        if ((MPU401.mpu.state.amask & 1 << chan) != 0) {
            MPU401.mpu.playbuf[chan].vlength = 0;
            MPU401.mpu.playbuf[chan].type = 0;
            MPU401.mpu.playbuf[chan].counter = 240;
            MPU401.mpu.state.req_mask |= 1 << chan;
        } else if (MPU401.mpu.state.amask == 0 && !MPU401.mpu.state.conductor) {
            MPU401.mpu.state.req_mask |= 0x1000;
        }
    }

    private static void UpdateConductor() {
        if (MPU401.mpu.condbuf.value[0] == 252) {
            MPU401.mpu.condbuf.value[0] = 0;
            MPU401.mpu.state.conductor = false;
            MPU401.mpu.state.req_mask &= 0xFFFFFDFF;
            if (MPU401.mpu.state.amask == 0) {
                MPU401.mpu.state.req_mask |= 0x1000;
            }
            return;
        }
        MPU401.mpu.condbuf.vlength = 0;
        MPU401.mpu.condbuf.counter = 240;
        MPU401.mpu.state.req_mask |= 0x200;
    }

    private static void MPU401_EOIHandler() {
        if (MPU401.mpu.state.send_now) {
            MPU401.mpu.state.send_now = false;
            if (MPU401.mpu.state.cond_req) {
                MPU401.UpdateConductor();
            } else {
                MPU401.UpdateTrack(MPU401.mpu.state.channel);
            }
        }
        MPU401.mpu.state.irq_pending = false;
        if (!MPU401.mpu.state.playing || MPU401.mpu.state.req_mask == 0) {
            return;
        }
        int i = 0;
        do {
            if ((MPU401.mpu.state.req_mask & 1 << i) == 0) continue;
            MPU401.QueueByte(240 + i);
            MPU401.mpu.state.req_mask &= ~(1 << i);
            break;
        } while (i++ < 16);
    }

    private static void MPU401_Reset() {
        Pic.PIC_DeActivateIRQ(MPU401.mpu.irq);
        MPU401.mpu.mode = MPU401.mpu.intelligent ? 1 : 0;
        MPU401.mpu.state.wsd = false;
        MPU401.mpu.state.wsm = false;
        MPU401.mpu.state.conductor = false;
        MPU401.mpu.state.cond_req = false;
        MPU401.mpu.state.cond_set = false;
        MPU401.mpu.state.playing = false;
        MPU401.mpu.state.run_irq = false;
        MPU401.mpu.state.irq_pending = false;
        MPU401.mpu.state.cmask = (short)255;
        MPU401.mpu.state.tmask = 0;
        MPU401.mpu.state.amask = 0;
        MPU401.mpu.state.midi_mask = 65535;
        MPU401.mpu.state.data_onoff = 0;
        MPU401.mpu.state.command_byte = 0;
        MPU401.mpu.state.block_ack = false;
        MPU401.mpu.clock.old_tempo = (short)100;
        MPU401.mpu.clock.tempo = (short)100;
        MPU401.mpu.clock.old_timebase = (short)120;
        MPU401.mpu.clock.timebase = (short)120;
        MPU401.mpu.clock.old_tempo_rel = (short)40;
        MPU401.mpu.clock.tempo_rel = (short)40;
        MPU401.mpu.clock.tempo_grad = 0;
        MPU401.mpu.clock.clock_to_host = false;
        MPU401.mpu.clock.cth_rate = (short)60;
        MPU401.mpu.clock.cth_counter = 0;
        MPU401.ClrQueue();
        MPU401.mpu.state.req_mask = 0;
        MPU401.mpu.condbuf.counter = 0;
        MPU401.mpu.condbuf.type = 0;
        for (int i = 0; i < 8; ++i) {
            MPU401.mpu.playbuf[i].type = 0;
            MPU401.mpu.playbuf[i].counter = 0;
        }
    }

    public MPU401(Section configuration) {
        super(configuration);
        int i;
        Section_prop section = (Section_prop)configuration;
        String s_mpu = section.Get_string("mpu401");
        if (s_mpu.equalsIgnoreCase("none")) {
            return;
        }
        if (s_mpu.equalsIgnoreCase("off")) {
            return;
        }
        if (s_mpu.equalsIgnoreCase("false")) {
            return;
        }
        if (!Midi.MIDI_Available()) {
            return;
        }
        this.installed = true;
        for (i = 0; i < this.WriteHandler.length; ++i) {
            this.WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
        }
        for (i = 0; i < this.ReadHandler.length; ++i) {
            this.ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
        }
        this.WriteHandler[0].Install(816, MPU401_WriteData, 1);
        this.WriteHandler[1].Install(817, MPU401_WriteCommand, 1);
        this.ReadHandler[0].Install(816, MPU401_ReadData, 1);
        this.ReadHandler[1].Install(817, MPU401_ReadStatus, 1);
        MPU401.mpu.queue_used = 0;
        MPU401.mpu.queue_pos = 0;
        MPU401.mpu.mode = 0;
        MPU401.mpu.irq = 9;
        MPU401.mpu.intelligent = true;
        if (s_mpu.equalsIgnoreCase("uart")) {
            MPU401.mpu.intelligent = false;
        }
        if (!MPU401.mpu.intelligent) {
            return;
        }
        Pic.PIC_SetIRQMask(MPU401.mpu.irq, false);
        MPU401.MPU401_Reset();
    }

    static {
        MPU401_WriteData = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                if (mpu.mode == 0) {
                    Midi.MIDI_RawOutByte(val);
                    return;
                }
                switch (mpu.state.command_byte) {
                    case 0: {
                        break;
                    }
                    case 224: {
                        mpu.state.command_byte = 0;
                        mpu.clock.tempo = (short)val;
                        return;
                    }
                    case 225: {
                        mpu.state.command_byte = 0;
                        if (val != 64) {
                            Log.log(21, 2, "MPU-401:Relative tempo change not implemented");
                        }
                        return;
                    }
                    case 231: {
                        mpu.state.command_byte = 0;
                        mpu.clock.cth_rate = (short)(val >> 2);
                        return;
                    }
                    case 236: {
                        mpu.state.command_byte = 0;
                        mpu.state.tmask = (short)val;
                        return;
                    }
                    case 237: {
                        mpu.state.command_byte = 0;
                        mpu.state.cmask = (short)val;
                        return;
                    }
                    case 238: {
                        mpu.state.command_byte = 0;
                        mpu.state.midi_mask &= 0xFF00;
                        mpu.state.midi_mask |= val;
                        return;
                    }
                    case 239: {
                        mpu.state.command_byte = 0;
                        mpu.state.midi_mask &= 0xFF;
                        mpu.state.midi_mask |= val << 8;
                        return;
                    }
                    default: {
                        mpu.state.command_byte = 0;
                        return;
                    }
                }
                if (mpu.state.wsd) {
                    if (mpu.state.wsd_start) {
                        mpu.state.wsd_start = false;
                        cnt = 0;
                        switch (val & 0xF0) {
                            case 192: 
                            case 208: {
                                mpu.playbuf[mpu.state.channel].value[0] = (short)val;
                                length = 2;
                                break;
                            }
                            case 128: 
                            case 144: 
                            case 160: 
                            case 176: 
                            case 224: {
                                mpu.playbuf[mpu.state.channel].value[0] = (short)val;
                                length = 3;
                                break;
                            }
                            case 240: {
                                Log.log(21, 2, "MPU-401:Illegal WSD byte");
                                mpu.state.wsd = false;
                                mpu.state.channel = mpu.state.old_chan;
                                return;
                            }
                            default: {
                                cnt++;
                                Midi.MIDI_RawOutByte(mpu.playbuf[mpu.state.channel].value[0]);
                            }
                        }
                    }
                    if (cnt < length) {
                        Midi.MIDI_RawOutByte(val);
                        cnt++;
                    }
                    if (cnt == length) {
                        mpu.state.wsd = false;
                        mpu.state.channel = mpu.state.old_chan;
                    }
                    return;
                }
                if (mpu.state.wsm) {
                    if (val == 247) {
                        Midi.MIDI_RawOutByte(247);
                        mpu.state.wsm = false;
                        return;
                    }
                    if (mpu.state.wsd_start) {
                        mpu.state.wsd_start = false;
                        cnt = 0;
                        switch (val) {
                            case 242: {
                                length = 3;
                                break;
                            }
                            case 243: {
                                length = 2;
                                break;
                            }
                            case 246: {
                                length = 1;
                                break;
                            }
                            case 240: {
                                length = 0;
                                break;
                            }
                            default: {
                                length = 0;
                            }
                        }
                    }
                    if (length == 0 || cnt < length) {
                        Midi.MIDI_RawOutByte(val);
                        cnt++;
                    }
                    if (cnt == length) {
                        mpu.state.wsm = false;
                    }
                    return;
                }
                if (mpu.state.cond_req) {
                    switch (mpu.state.data_onoff) {
                        case -1: {
                            return;
                        }
                        case 0: {
                            mpu.condbuf.vlength = 0;
                            if (val < 240) {
                                ++mpu.state.data_onoff;
                            } else {
                                mpu.state.data_onoff = -1;
                                MPU401.MPU401_EOIHandler();
                                return;
                            }
                            mpu.state.send_now = val == 0;
                            mpu.condbuf.counter = val;
                            break;
                        }
                        case 1: {
                            mpu.condbuf.type = 4;
                            if (val == 248 || val == 249) {
                                mpu.condbuf.type = 0;
                            }
                            mpu.condbuf.value[mpu.condbuf.vlength] = (short)val;
                            mpu.condbuf.vlength = (short)(mpu.condbuf.vlength + 1);
                            if ((val & 0xF0) != 224) {
                                MPU401.MPU401_EOIHandler();
                                break;
                            }
                            ++mpu.state.data_onoff;
                            break;
                        }
                        case 2: {
                            mpu.condbuf.value[mpu.condbuf.vlength] = (short)val;
                            mpu.condbuf.vlength = (short)(mpu.condbuf.vlength + 1);
                            MPU401.MPU401_EOIHandler();
                        }
                    }
                    return;
                }
                switch (mpu.state.data_onoff) {
                    case -1: {
                        return;
                    }
                    case 0: {
                        if (val >= 240) {
                            mpu.state.data_onoff = -1;
                            MPU401.MPU401_EOIHandler();
                            return;
                        }
                        mpu.state.data_onoff = 1;
                        mpu.state.send_now = val == 0;
                        mpu.playbuf[mpu.state.channel].counter = val;
                        break;
                    }
                    case 1: {
                        mpu.playbuf[mpu.state.channel].vlength = (short)(mpu.playbuf[mpu.state.channel].vlength + 1);
                        posd = mpu.playbuf[mpu.state.channel].vlength;
                        if (posd == 1) {
                            switch (val & 0xF0) {
                                case 240: {
                                    if (val > 247) {
                                        mpu.playbuf[mpu.state.channel].type = 1;
                                        mpu.playbuf[mpu.state.channel].sys_val = (short)val;
                                        length = 1;
                                        break;
                                    }
                                    Log.log(21, 2, "MPU-401:Illegal message");
                                    mpu.playbuf[mpu.state.channel].type = 2;
                                    mpu.playbuf[mpu.state.channel].sys_val = (short)val;
                                    length = 1;
                                    break;
                                }
                                case 192: 
                                case 208: {
                                    mpu.playbuf[mpu.state.channel].type = 3;
                                    mpu.playbuf[mpu.state.channel].length = (short)2;
                                    length = 2;
                                    break;
                                }
                                case 128: 
                                case 144: 
                                case 160: 
                                case 176: 
                                case 224: {
                                    mpu.playbuf[mpu.state.channel].type = 3;
                                    mpu.playbuf[mpu.state.channel].length = (short)3;
                                    length = 3;
                                    break;
                                }
                                default: {
                                    posd++;
                                    mpu.playbuf[mpu.state.channel].vlength = (short)(mpu.playbuf[mpu.state.channel].vlength + 1);
                                    mpu.playbuf[mpu.state.channel].type = 3;
                                    length = mpu.playbuf[mpu.state.channel].length;
                                }
                            }
                        }
                        if (posd != 1 || val < 240) {
                            mpu.playbuf[mpu.state.channel].value[posd - 1] = (short)val;
                        }
                        if (posd != length) break;
                        MPU401.MPU401_EOIHandler();
                    }
                }
            }
        };
        MPU401_Event = new Pic.PIC_EventHandler(){

            public void call(int val) {
                if (mpu.mode == 0) {
                    return;
                }
                if (!mpu.state.irq_pending) {
                    for (int i = 0; i < 8; ++i) {
                        if ((mpu.state.amask & 1 << i) == 0) continue;
                        --mpu.playbuf[i].counter;
                        if (mpu.playbuf[i].counter > 0) continue;
                        MPU401.UpdateTrack(i);
                    }
                    if (mpu.state.conductor) {
                        --mpu.condbuf.counter;
                        if (mpu.condbuf.counter <= 0) {
                            MPU401.UpdateConductor();
                        }
                    }
                    if (mpu.clock.clock_to_host) {
                        mpu.clock.cth_counter = (short)(mpu.clock.cth_counter + 1);
                        if (mpu.clock.cth_counter >= mpu.clock.cth_rate) {
                            mpu.clock.cth_counter = 0;
                            mpu.state.req_mask |= 0x2000;
                        }
                    }
                    if (!mpu.state.irq_pending && mpu.state.req_mask != 0) {
                        MPU401.MPU401_EOIHandler();
                    }
                }
                Pic.PIC_RemoveEvents(MPU401_Event);
                int new_time = mpu.clock.tempo * mpu.clock.timebase;
                if (new_time == 0) {
                    return;
                }
                Pic.PIC_AddEvent(MPU401_Event, 60000.0f / (float)new_time);
            }
        };
        MPU401_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                if (!test.installed) {
                    return;
                }
                Section_prop sec_prop = (Section_prop)section;
                if (!sec_prop.Get_string("mpu401").equalsIgnoreCase("intelligent")) {
                    return;
                }
                Pic.PIC_SetIRQMask(mpu.irq, true);
            }
        };
        MPU401_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new MPU401(section);
                section.AddDestroyFunction(MPU401_Destroy, true);
            }
        };
    }

    private static final class MPU {
        public boolean intelligent;
        public int mode;
        int irq;
        short[] queue = new short[32];
        int queue_pos;
        int queue_used;
        public final track[] playbuf = new track[8];
        public final track condbuf = new track();
        public final State state = new State();
        public final Clock clock = new Clock();

        public MPU() {
            for (int i = 0; i < this.playbuf.length; ++i) {
                this.playbuf[i] = new track();
            }
        }

        public static class Clock {
            short timebase;
            short old_timebase;
            short tempo;
            short old_tempo;
            short tempo_rel;
            short old_tempo_rel;
            short tempo_grad;
            short cth_rate;
            short cth_counter;
            boolean clock_to_host;
            boolean cth_active;
        }

        public static class State {
            boolean conductor;
            boolean cond_req;
            boolean cond_set;
            boolean block_ack;
            boolean playing;
            boolean reset;
            boolean wsd;
            boolean wsm;
            boolean wsd_start;
            boolean run_irq;
            boolean irq_pending;
            boolean send_now;
            int data_onoff;
            int command_byte;
            short tmask;
            short cmask;
            short amask;
            int midi_mask;
            int req_mask;
            short channel;
            short old_chan;
        }

        public static class track {
            int counter;
            short[] value = new short[8];
            short sys_val;
            short vlength;
            short length;
            int type;
        }
    }
}

