/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.IoHandler;
import jdos.hardware.Pic;
import jdos.hardware.Timer;
import jdos.host.Ethernet;
import jdos.host.RxFrame;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.Ptr;
import jdos.util.StringHelper;

public class NE2000
extends Module_base {
    private static final int BX_NE2K_NEVER_FULL_RING = 1;
    public static final boolean BX_DEBUG = false;
    public static final boolean BX_INFO = true;
    public static final boolean BX_PANIC = true;
    public static final boolean BX_ERROR = true;
    private static final int BX_RESET_HARDWARE = 0;
    private static final int BX_RESET_SOFTWARE = 1;
    private static bx_ne2k_c theNE2kDevice = null;
    private static final int BX_NE2K_MEMSIZ = 32768;
    private static final int BX_NE2K_MEMSTART = 16384;
    private static final int BX_NE2K_MEMEND = 49152;
    private static final IoHandler.IO_ReadHandler dosbox_read = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return (int)theNE2kDevice.read(port, iolen);
        }
    };
    private static final IoHandler.IO_WriteHandler dosbox_write = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            theNE2kDevice.write(port, (long)val & 0xFFFFFFFFL, iolen);
        }
    };
    private static final Pic.PIC_EventHandler NE2000_TX_Event = new Pic.PIC_EventHandler(){

        public void call(int val) {
            theNE2kDevice.tx_timer();
        }
    };
    private static final Timer.TIMER_TickHandler NE2000_Poller = new Timer.TIMER_TickHandler(){

        public void call() {
            test.ethernet.receive(theNE2kDevice);
        }
    };
    IoHandler.IO_ReadHandleObject[] ReadHandler8 = new IoHandler.IO_ReadHandleObject[32];
    IoHandler.IO_WriteHandleObject[] WriteHandler8 = new IoHandler.IO_WriteHandleObject[32];
    boolean load_success;
    Ethernet ethernet;
    private static NE2000 test;
    private static Section.SectionFunction NE2000_ShutDown;
    public static Section.SectionFunction NE2000_Init;

    public NE2000(Section configuration) {
        super(configuration);
        int i;
        int base;
        Section_prop section = (Section_prop)configuration;
        this.load_success = true;
        if (!section.Get_bool("ne2000")) {
            this.load_success = false;
            return;
        }
        int irq = section.Get_int("nicirq");
        if (irq != 3 && irq != 4 && irq != 5 && irq != 6 && irq != 7 && irq != 9 && irq != 10 && irq != 11 && irq != 12 && irq != 14 && irq != 15) {
            irq = 3;
        }
        if ((base = section.Get_hex("nicbase").toInt()) != 608 && base != 640 && base != 768 && base != 800 && base != 832 && base != 896) {
            base = 768;
        }
        String macstring = section.Get_string("macaddr");
        String[] parts = StringHelper.split(macstring, ":");
        byte[] mac = new byte[6];
        try {
            for (i = 0; i < parts.length; ++i) {
                int d = Integer.parseInt(parts[i], 16);
                if (d > 255) {
                    throw new Exception("Invalid macaddr string: " + macstring);
                }
                mac[i] = (byte)d;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mac[0] = -84;
            mac[1] = -34;
            mac[2] = 72;
            mac[3] = -120;
            mac[4] = -69;
            mac[5] = -86;
        }
        if (section.Get_bool("pcap")) {
            try {
                Class<?> c = Class.forName("jdos.host.PCapEthernet");
                this.ethernet = (Ethernet)c.newInstance();
                if (!this.ethernet.open(section, mac)) {
                    this.ethernet = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.ethernet == null && section.Get_string("pcaphost").length() > 0) {
            try {
                Class<?> c = Class.forName("jdos.host.FowardPCapEthernet");
                this.ethernet = (Ethernet)c.newInstance();
                if (!this.ethernet.open(section, mac)) {
                    this.ethernet = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.ethernet == null) {
            Log.log_msg("Network card disabled");
            this.load_success = false;
            return;
        }
        theNE2kDevice = new bx_ne2k_c();
        Ptr.memcpy(NE2000.theNE2kDevice.s.physaddr, mac, 6);
        theNE2kDevice.init();
        NE2000.theNE2kDevice.s.base_address = base;
        NE2000.theNE2kDevice.s.base_irq = irq;
        for (i = 0; i < 32; ++i) {
            this.ReadHandler8[i] = new IoHandler.IO_ReadHandleObject();
            this.ReadHandler8[i].Install((int)((long)i + NE2000.theNE2kDevice.s.base_address), dosbox_read, 3);
            this.WriteHandler8[i] = new IoHandler.IO_WriteHandleObject();
            this.WriteHandler8[i].Install((int)((long)i + NE2000.theNE2kDevice.s.base_address), dosbox_write, 3);
        }
        Timer.TIMER_AddTickHandler(NE2000_Poller);
    }

    public void close() {
        if (this.ethernet != null) {
            this.ethernet.close();
        }
        Timer.TIMER_DelTickHandler(NE2000_Poller);
        Pic.PIC_RemoveEvents(NE2000_TX_Event);
    }

    static {
        NE2000_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                test.close();
                test = null;
            }
        };
        NE2000_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new NE2000(section);
                section.AddDestroyFunction(NE2000_ShutDown, true);
            }
        };
    }

    public static final class bx_ne2k_c
    implements RxFrame {
        bx_ne2k_t s = new bx_ne2k_t();

        public bx_ne2k_c() {
            this.s.tx_timer_index = 0;
        }

        public void init() {
            Log.log_msg(StringHelper.sprintf("[NE2000] port 0x%x/32 irq %d mac %02x:%02x:%02x:%02x:%02x:%02x", new Object[]{new Long(this.s.base_address), new Integer(this.s.base_irq), new Integer(this.s.physaddr[0]), new Integer(this.s.physaddr[1]), new Integer(this.s.physaddr[2]), new Integer(this.s.physaddr[3]), new Integer(this.s.physaddr[4]), new Integer(this.s.physaddr[5])}));
            this.s.macaddr[0] = this.s.physaddr[0];
            this.s.macaddr[1] = this.s.physaddr[0];
            this.s.macaddr[2] = this.s.physaddr[1];
            this.s.macaddr[3] = this.s.physaddr[1];
            this.s.macaddr[4] = this.s.physaddr[2];
            this.s.macaddr[5] = this.s.physaddr[2];
            this.s.macaddr[6] = this.s.physaddr[3];
            this.s.macaddr[7] = this.s.physaddr[3];
            this.s.macaddr[8] = this.s.physaddr[4];
            this.s.macaddr[9] = this.s.physaddr[4];
            this.s.macaddr[10] = this.s.physaddr[5];
            this.s.macaddr[11] = this.s.physaddr[5];
            for (int i = 12; i < 32; ++i) {
                this.s.macaddr[i] = 87;
            }
            this.reset(0);
        }

        public void reset(int type) {
            this.s.CR = new bx_ne2k_t.CR_t();
            this.s.ISR = new bx_ne2k_t.ISR_t();
            this.s.IMR = new bx_ne2k_t.IMR_t();
            this.s.DCR = new bx_ne2k_t.DCR_t();
            this.s.TCR = new bx_ne2k_t.TCR_t();
            this.s.TSR = new bx_ne2k_t.TSR_t();
            this.s.RSR = new bx_ne2k_t.RSR_t();
            this.s.tx_timer_active = 0;
            this.s.local_dma = 0;
            this.s.page_start = 0;
            this.s.page_stop = 0;
            this.s.bound_ptr = 0;
            this.s.tx_page_start = 0;
            this.s.num_coll = 0;
            this.s.tx_bytes = 0;
            this.s.fifo = 0;
            this.s.remote_dma = 0;
            this.s.remote_start = 0;
            this.s.remote_bytes = 0;
            this.s.tallycnt_0 = 0;
            this.s.tallycnt_1 = 0;
            this.s.tallycnt_2 = 0;
            this.s.curr_page = 0;
            this.s.rempkt_ptr = 0;
            this.s.localpkt_ptr = 0;
            this.s.address_cnt = 0;
            this.s.mem.clear();
            this.s.CR.stop = 1;
            this.s.CR.rdma_cmd = (short)4;
            this.s.ISR.reset = 1;
            this.s.DCR.longaddr = 1;
            Pic.PIC_DeActivateIRQ(this.s.base_irq);
        }

        public int read_cr() {
            int val = (this.s.CR.pgsel & 3) << 6 | (this.s.CR.rdma_cmd & 7) << 3 | this.s.CR.tx_packet << 2 | this.s.CR.start << 1 | this.s.CR.stop;
            return val;
        }

        public void write_cr(int value) {
            if ((value & 0x38) == 0) {
                value |= 0x20;
            }
            if ((value & 1) != 0) {
                this.s.ISR.reset = 1;
                this.s.CR.stop = 1;
            } else {
                this.s.CR.stop = 0;
            }
            this.s.CR.rdma_cmd = (short)((value & 0x38) >> 3);
            if ((value & 2) != 0 && this.s.CR.start == 0) {
                this.s.ISR.reset = 0;
            }
            this.s.CR.start = (value & 2) == 2 ? 1 : 0;
            this.s.CR.pgsel = (short)((value & 0xC0) >> 6);
            if (this.s.CR.rdma_cmd == 3) {
                this.s.remote_start = this.s.remote_dma = this.s.bound_ptr * 256;
                this.s.remote_bytes = this.s.mem.readw(this.s.bound_ptr * 256 + 2 - 16384);
                Log.log_msg("[NE2000] Sending buffer #x" + Integer.toString(this.s.remote_start, 16) + " length " + this.s.remote_bytes);
            }
            if ((value & 4) != 0 && this.s.TCR.loop_cntl != 0) {
                if (this.s.TCR.loop_cntl != 1) {
                    Log.log_msg("[NE2000] Loop mode " + this.s.TCR.loop_cntl + " not supported.");
                } else {
                    this.rx_frame(new Ptr(this.s.mem, this.s.tx_page_start * 256 - 16384), this.s.tx_bytes);
                    if (this.s.IMR.tx_inte != 0 && this.s.ISR.pkt_tx == 0) {
                        Pic.PIC_ActivateIRQ(this.s.base_irq);
                    }
                    this.s.ISR.pkt_tx = 1;
                }
            } else if ((value & 4) != 0) {
                if (this.s.CR.stop != 0 || this.s.CR.start == 0) {
                    Log.log_msg("[NE2000] CR write - tx start, dev in reset");
                }
                if (this.s.tx_bytes == 0) {
                    Log.log_msg("[NE2000] CR write - tx start, tx bytes == 0");
                }
                test.ethernet.send(this.s.mem.p, this.s.tx_page_start * 256 - 16384, this.s.tx_bytes);
                if (this.s.tx_timer_active != 0) {
                    Log.log_msg("[NE2000] CR write, tx timer still active");
                    Pic.PIC_RemoveEvents(NE2000_TX_Event);
                }
                this.s.tx_timer_active = 1;
                Pic.PIC_AddEvent(NE2000_TX_Event, (float)((double)(192 + this.s.tx_bytes * 8) / 10000.0), 0);
            }
            if (this.s.CR.rdma_cmd == 1 && this.s.CR.start != 0 && this.s.remote_bytes == 0) {
                this.s.ISR.rdma_done = 1;
                if (this.s.IMR.rdma_inte != 0) {
                    Pic.PIC_ActivateIRQ(this.s.base_irq);
                }
            }
        }

        public long chipmem_read(int address, int io_len) {
            long retval = 0L;
            if (io_len == 2 && (address & 1) != 0) {
                Log.log_msg("[NE2000] unaligned chipmem word read");
            }
            if (address >= 0 && address <= 31) {
                retval = this.s.macaddr[address];
                if (io_len == 2 || io_len == 4) {
                    retval |= (long)(this.s.macaddr[address + 1] << 8);
                    if (io_len == 4) {
                        retval |= (long)(this.s.macaddr[address + 2] << 16);
                        retval |= (long)(this.s.macaddr[address + 3] << 24);
                    }
                }
                return retval;
            }
            if (address >= 16384 && address < 49152) {
                if (io_len == 1) {
                    return this.s.mem.readb(address - 16384);
                }
                if (io_len == 2) {
                    return this.s.mem.readw(address - 16384);
                }
                if (io_len == 4) {
                    return this.s.mem.readd(address - 16384);
                }
            }
            return 255L;
        }

        public void chipmem_write(int address, long value, int io_len) {
            if (io_len == 2 && (address & 1) != 0) {
                Log.log_msg("[NE2000] unaligned chipmem word write");
            }
            if (address >= 16384 && address < 49152) {
                if (io_len == 1) {
                    this.s.mem.writeb(address - 16384, (short)value);
                } else if (io_len == 2) {
                    this.s.mem.writew(address - 16384, (int)value);
                } else if (io_len == 4) {
                    this.s.mem.writed(address - 16384, value);
                }
            }
        }

        public long asic_read(int offset, int io_len) {
            long retval = 0L;
            switch (offset) {
                case 0: {
                    if (io_len > this.s.remote_bytes) {
                        Log.log_msg("[NE2000] dma read underrun iolen=" + io_len + " remote_bytes=" + this.s.remote_bytes);
                    }
                    retval = this.chipmem_read(this.s.remote_dma, io_len);
                    this.s.remote_dma += this.s.DCR.wdsize + 1;
                    if (this.s.remote_dma == this.s.page_stop << 8) {
                        this.s.remote_dma = this.s.page_start << 8;
                    }
                    this.s.remote_bytes = this.s.remote_bytes > 1 ? (this.s.remote_bytes -= this.s.DCR.wdsize + 1) : 0;
                    if (this.s.remote_bytes != 0) break;
                    this.s.ISR.rdma_done = 1;
                    if (this.s.IMR.rdma_inte == 0) break;
                    Pic.PIC_ActivateIRQ(this.s.base_irq);
                    break;
                }
                case 15: {
                    this.reset(1);
                    break;
                }
                default: {
                    Log.log_msg(StringHelper.sprintf("[NE2000] asic read invalid address %04x", new Object[]{new Integer(offset)}));
                }
            }
            return retval;
        }

        public void asic_write(int offset, long value, int io_len) {
            switch (offset) {
                case 0: {
                    if (io_len == 2 && this.s.DCR.wdsize == 0) {
                        Log.log_msg("[NE2000] dma write length 2 on byte mode operation");
                        break;
                    }
                    if (this.s.remote_bytes == 0) {
                        Log.log_msg("[NE2000] dma write, byte count 0");
                    }
                    this.chipmem_write(this.s.remote_dma, value, io_len);
                    this.s.remote_dma += io_len;
                    if (this.s.remote_dma == this.s.page_stop << 8) {
                        this.s.remote_dma = this.s.page_start << 8;
                    }
                    this.s.remote_bytes -= io_len;
                    if (this.s.remote_bytes > 32768) {
                        this.s.remote_bytes = 0;
                    }
                    if (this.s.remote_bytes != 0) break;
                    this.s.ISR.rdma_done = 1;
                    if (this.s.IMR.rdma_inte == 0) break;
                    Pic.PIC_ActivateIRQ(this.s.base_irq);
                    break;
                }
                case 15: {
                    this.reset(1);
                    break;
                }
                default: {
                    Log.log_msg(StringHelper.sprintf("[NE2000] asic write invalid address %04x, ignoring", new Object[]{new Long(offset)}));
                }
            }
        }

        public long page0_read(int offset, int io_len) {
            if (io_len > 1) {
                Log.log_msg(StringHelper.sprintf("[NE2000] bad length! page 0 read from port %04x, len=%u", new Object[]{new Integer(offset), new Integer(io_len)}));
                return 0L;
            }
            switch (offset) {
                case 1: {
                    return this.s.local_dma & 0xFF;
                }
                case 2: {
                    return this.s.local_dma >> 8;
                }
                case 3: {
                    return this.s.bound_ptr;
                }
                case 4: {
                    return this.s.TSR.ow_coll << 7 | this.s.TSR.cd_hbeat << 6 | this.s.TSR.fifo_ur << 5 | this.s.TSR.no_carrier << 4 | this.s.TSR.aborted << 3 | this.s.TSR.collided << 2 | this.s.TSR.tx_ok;
                }
                case 5: {
                    return this.s.num_coll;
                }
                case 6: {
                    Log.log_msg("[NE2000] reading FIFO not supported yet");
                    return this.s.fifo;
                }
                case 7: {
                    return this.s.ISR.reset << 7 | this.s.ISR.rdma_done << 6 | this.s.ISR.cnt_oflow << 5 | this.s.ISR.overwrite << 4 | this.s.ISR.tx_err << 3 | this.s.ISR.rx_err << 2 | this.s.ISR.pkt_tx << 1 | this.s.ISR.pkt_rx;
                }
                case 8: {
                    return this.s.remote_dma & 0xFF;
                }
                case 9: {
                    return this.s.remote_dma >> 8;
                }
                case 10: {
                    Log.log_msg("[NE2000] reserved read - page 0, 0xa");
                    return 255L;
                }
                case 11: {
                    Log.log_msg("[NE2000] reserved read - page 0, 0xb");
                    return 255L;
                }
                case 12: {
                    return this.s.RSR.deferred << 7 | this.s.RSR.rx_disabled << 6 | this.s.RSR.rx_mbit << 5 | this.s.RSR.rx_missed << 4 | this.s.RSR.fifo_or << 3 | this.s.RSR.bad_falign << 2 | this.s.RSR.bad_crc << 1 | this.s.RSR.rx_ok;
                }
                case 13: {
                    return this.s.tallycnt_0;
                }
                case 14: {
                    return this.s.tallycnt_1;
                }
                case 15: {
                    return this.s.tallycnt_2;
                }
            }
            Log.log_msg(StringHelper.sprintf("[NE2000] page 0 read offset %04x out of range", new Object[]{new Integer(offset)}));
            return 0L;
        }

        public void page0_write(int offset, long val, int io_len) {
            int value = (int)val;
            if (io_len == 2) {
                this.page0_write(offset, value & 0xFF, 1);
                this.page0_write(offset + 1, value >> 8 & 0xFF, 1);
                return;
            }
            switch (offset) {
                case 1: {
                    this.s.page_start = (short)value;
                    break;
                }
                case 2: {
                    this.s.page_stop = (short)value;
                    break;
                }
                case 3: {
                    this.s.bound_ptr = (short)value;
                    break;
                }
                case 4: {
                    this.s.tx_page_start = (short)value;
                    break;
                }
                case 5: {
                    this.s.tx_bytes &= 0xFF00;
                    this.s.tx_bytes |= value & 0xFF;
                    break;
                }
                case 6: {
                    this.s.tx_bytes &= 0xFF;
                    this.s.tx_bytes |= (value & 0xFF) << 8;
                    break;
                }
                case 7: {
                    this.s.ISR.pkt_rx = this.s.ISR.pkt_rx & ~(((value &= 0x7F) & 1) == 1 ? 1 : 0);
                    this.s.ISR.pkt_tx = this.s.ISR.pkt_tx & ~((value & 2) == 2 ? 1 : 0);
                    this.s.ISR.rx_err = this.s.ISR.rx_err & ~((value & 4) == 4 ? 1 : 0);
                    this.s.ISR.tx_err = this.s.ISR.tx_err & ~((value & 8) == 8 ? 1 : 0);
                    this.s.ISR.overwrite = this.s.ISR.overwrite & ~((value & 0x10) == 16 ? 1 : 0);
                    this.s.ISR.cnt_oflow = this.s.ISR.cnt_oflow & ~((value & 0x20) == 32 ? 1 : 0);
                    this.s.ISR.rdma_done = this.s.ISR.rdma_done & ~((value & 0x40) == 64 ? 1 : 0);
                    value = this.s.ISR.rdma_done << 6 | this.s.ISR.cnt_oflow << 5 | this.s.ISR.overwrite << 4 | this.s.ISR.tx_err << 3 | this.s.ISR.rx_err << 2 | this.s.ISR.pkt_tx << 1 | this.s.ISR.pkt_rx;
                    if ((value &= this.s.IMR.rdma_inte << 6 | this.s.IMR.cofl_inte << 5 | this.s.IMR.overw_inte << 4 | this.s.IMR.txerr_inte << 3 | this.s.IMR.rxerr_inte << 2 | this.s.IMR.tx_inte << 1 | this.s.IMR.rx_inte) != 0) break;
                    Pic.PIC_DeActivateIRQ(this.s.base_irq);
                    break;
                }
                case 8: {
                    this.s.remote_start &= 0xFF00;
                    this.s.remote_start |= value & 0xFF;
                    this.s.remote_dma = this.s.remote_start;
                    break;
                }
                case 9: {
                    this.s.remote_start &= 0xFF;
                    this.s.remote_start |= (value & 0xFF) << 8;
                    this.s.remote_dma = this.s.remote_start;
                    break;
                }
                case 10: {
                    this.s.remote_bytes &= 0xFF00;
                    this.s.remote_bytes |= value & 0xFF;
                    break;
                }
                case 11: {
                    this.s.remote_bytes &= 0xFF;
                    this.s.remote_bytes |= (value & 0xFF) << 8;
                    break;
                }
                case 12: {
                    if ((value & 0xC0) != 0) {
                        Log.log_msg("[NE2000] RCR write, reserved bits set");
                    }
                    this.s.RCR.errors_ok = (value & 1) == 1 ? 1 : 0;
                    this.s.RCR.runts_ok = (value & 2) == 2 ? 1 : 0;
                    this.s.RCR.broadcast = (value & 4) == 4 ? 1 : 0;
                    this.s.RCR.multicast = (value & 8) == 8 ? 1 : 0;
                    this.s.RCR.promisc = (value & 0x10) == 16 ? 1 : 0;
                    int n = this.s.RCR.monitor = (value & 0x20) == 32 ? 1 : 0;
                    if ((value & 0x20) == 0) break;
                    Log.log_msg("[NE2000] RCR write, monitor bit set!");
                    break;
                }
                case 13: {
                    if ((value & 0xE0) != 0) {
                        Log.log_msg("[NE2000] TCR write, reserved bits set");
                    }
                    if ((value & 6) != 0) {
                        this.s.TCR.loop_cntl = (short)((value & 6) >> 1);
                        Log.log_msg("[NE2000] TCR write, loop mode " + this.s.TCR.loop_cntl + " not supported");
                    } else {
                        this.s.TCR.loop_cntl = 0;
                    }
                    if ((value & 1) != 0) {
                        Log.log_msg("[NE2000] TCR write, inhibit-CRC not supported");
                    }
                    if ((value & 8) != 0) {
                        Log.log_msg("[NE2000] TCR write, auto transmit disable not supported");
                    }
                    this.s.TCR.coll_prio = (value & 8) == 8 ? 1 : 0;
                    break;
                }
                case 14: {
                    if ((value & 8) == 0) {
                        Log.log_msg("[NE2000] DCR write, loopback mode selected");
                    }
                    if ((value & 4) != 0) {
                        Log.log_msg("[NE2000] DCR write - LAS set ???");
                    }
                    if ((value & 0x10) != 0) {
                        Log.log_msg("[NE2000] DCR write - AR set ???");
                    }
                    this.s.DCR.wdsize = (value & 1) == 1 ? 1 : 0;
                    this.s.DCR.endian = (value & 2) == 2 ? 1 : 0;
                    this.s.DCR.longaddr = (value & 4) == 4 ? 1 : 0;
                    this.s.DCR.loop = (value & 8) == 8 ? 1 : 0;
                    this.s.DCR.auto_rx = (value & 0x10) == 16 ? 1 : 0;
                    this.s.DCR.fifo_size = (short)((value & 0x50) >> 5);
                    break;
                }
                case 15: {
                    if ((value & 0x80) != 0) {
                        Log.log_msg("[NE2000] IMR write, reserved bit set");
                    }
                    this.s.IMR.rx_inte = (value & 1) == 1 ? 1 : 0;
                    this.s.IMR.tx_inte = (value & 2) == 2 ? 1 : 0;
                    this.s.IMR.rxerr_inte = (value & 4) == 4 ? 1 : 0;
                    this.s.IMR.txerr_inte = (value & 8) == 8 ? 1 : 0;
                    this.s.IMR.overw_inte = (value & 0x10) == 16 ? 1 : 0;
                    this.s.IMR.cofl_inte = (value & 0x20) == 32 ? 1 : 0;
                    int n = this.s.IMR.rdma_inte = (value & 0x40) == 64 ? 1 : 0;
                    if (this.s.ISR.pkt_tx == 0 || this.s.IMR.tx_inte == 0) break;
                    Log.log_msg("[NE2000] tx irq retrigger");
                    Pic.PIC_ActivateIRQ(this.s.base_irq);
                    break;
                }
                default: {
                    Log.log_msg("[NE2000] page 0 write, bad offset " + Integer.toString(offset, 16));
                }
            }
        }

        public long page1_read(int offset, int io_len) {
            if (io_len > 1) {
                Log.log_msg(StringHelper.sprintf("[NE2000] bad length! page 1 read from port %04x, len=%u", new Object[]{new Integer(offset), new Integer(io_len)}));
                return 0L;
            }
            switch (offset) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return this.s.physaddr[offset - 1];
                }
                case 7: {
                    return this.s.curr_page;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return this.s.mchash[offset - 8];
                }
            }
            Log.log_msg(StringHelper.sprintf("[NE2000] page 1 read offset %04x out of range", new Object[]{new Integer(offset)}));
            return 0L;
        }

        public void page1_write(int offset, long value, int io_len) {
            switch (offset) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.s.physaddr[offset - 1] = (byte)value;
                    break;
                }
                case 7: {
                    this.s.curr_page = (short)value;
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.s.mchash[offset - 8] = (byte)value;
                    break;
                }
                default: {
                    Log.log_msg("[NE2000] page 1 write, bad offset " + Integer.toString(offset, 16));
                }
            }
        }

        public long page2_read(int offset, int io_len) {
            if (io_len > 1) {
                Log.log_msg(StringHelper.sprintf("[NE2000] bad length! page 2 read from port %04x, len=%u", new Object[]{new Integer(offset), new Integer(io_len)}));
                return 0L;
            }
            switch (offset) {
                case 1: {
                    return this.s.page_start;
                }
                case 2: {
                    return this.s.page_stop;
                }
                case 3: {
                    return this.s.rempkt_ptr;
                }
                case 4: {
                    return this.s.tx_page_start;
                }
                case 5: {
                    return this.s.localpkt_ptr;
                }
                case 6: {
                    return this.s.address_cnt >> 8;
                }
                case 7: {
                    return this.s.address_cnt & 0xFF;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    Log.log_msg("reserved read - page 2, 0x" + Integer.toString(offset, 16));
                    return 255L;
                }
                case 12: {
                    return this.s.RCR.monitor << 5 | this.s.RCR.promisc << 4 | this.s.RCR.multicast << 3 | this.s.RCR.broadcast << 2 | this.s.RCR.runts_ok << 1 | this.s.RCR.errors_ok;
                }
                case 13: {
                    return this.s.TCR.coll_prio << 4 | this.s.TCR.ext_stoptx << 3 | (this.s.TCR.loop_cntl & 3) << 1 | this.s.TCR.crc_disable;
                }
                case 14: {
                    return (this.s.DCR.fifo_size & 3) << 5 | this.s.DCR.auto_rx << 4 | this.s.DCR.loop << 3 | this.s.DCR.longaddr << 2 | this.s.DCR.endian << 1 | this.s.DCR.wdsize;
                }
                case 15: {
                    return this.s.IMR.rdma_inte << 6 | this.s.IMR.cofl_inte << 5 | this.s.IMR.overw_inte << 4 | this.s.IMR.txerr_inte << 3 | this.s.IMR.rxerr_inte << 2 | this.s.IMR.tx_inte << 1 | this.s.IMR.rx_inte;
                }
            }
            Log.log_msg(StringHelper.sprintf("[NE2000] page 2 read offset %04x out of range", new Object[]{new Integer(offset)}));
            return 0L;
        }

        public void page2_write(int offset, long value, int io_len) {
            if (offset != 0) {
                Log.log_msg("[NE2000] page 2 write ?");
            }
            switch (offset) {
                case 1: {
                    this.s.local_dma &= 0xFF00;
                    this.s.local_dma = (int)((long)this.s.local_dma | value & 0xFFL);
                    break;
                }
                case 2: {
                    this.s.local_dma &= 0xFF;
                    this.s.local_dma = (int)((long)this.s.local_dma | (value & 0xFFL) << 8);
                    break;
                }
                case 3: {
                    this.s.rempkt_ptr = (short)value;
                    break;
                }
                case 4: {
                    Log.log_msg("page 2 write to reserved offset 4");
                    break;
                }
                case 5: {
                    this.s.localpkt_ptr = (short)value;
                    break;
                }
                case 6: {
                    this.s.address_cnt &= 0xFF;
                    this.s.address_cnt = (int)((long)this.s.address_cnt | (value & 0xFFL) << 8);
                    break;
                }
                case 7: {
                    this.s.address_cnt &= 0xFF00;
                    this.s.address_cnt = (int)((long)this.s.address_cnt | value & 0xFFL);
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    Log.log_msg("[NE2000] page 2 write to reserved offset " + Integer.toString(offset, 16));
                    break;
                }
                default: {
                    Log.log_msg("[NE2000] page 2 write, illegal offset " + Integer.toString(offset));
                }
            }
        }

        public long page3_read(int offset, int io_len) {
            Log.log_msg("[NE2000] page 3 read attempted");
            return 0L;
        }

        public void page3_write(int address, long value, int io_len) {
            Log.log_msg("[NE2000] page 3 write attempted");
        }

        public void tx_timer() {
            this.s.TSR.tx_ok = 1;
            if (this.s.IMR.tx_inte != 0 && this.s.ISR.pkt_tx == 0) {
                Pic.PIC_ActivateIRQ(this.s.base_irq);
            }
            this.s.ISR.pkt_tx = 1;
            this.s.tx_timer_active = 0;
        }

        public long read(long address, int io_len) {
            long retval = 0L;
            int offset = (int)(address - this.s.base_address);
            if (offset >= 16) {
                retval = this.asic_read(offset - 16, io_len);
            } else if (offset == 0) {
                retval = this.read_cr();
            } else {
                switch (this.s.CR.pgsel) {
                    case 0: {
                        retval = this.page0_read(offset, io_len);
                        break;
                    }
                    case 1: {
                        retval = this.page1_read(offset, io_len);
                        break;
                    }
                    case 2: {
                        retval = this.page2_read(offset, io_len);
                        break;
                    }
                    case 3: {
                        retval = this.page3_read(offset, io_len);
                        break;
                    }
                    default: {
                        Log.log_msg("[NE2000] unknown value of pgsel in read - " + this.s.CR.pgsel);
                    }
                }
            }
            return retval;
        }

        public void write(long address, long value, int io_len) {
            int offset = (int)(address - this.s.base_address);
            if (offset >= 16) {
                this.asic_write(offset - 16, value, io_len);
            } else if (offset == 0) {
                this.write_cr((int)value);
            } else {
                switch (this.s.CR.pgsel) {
                    case 0: {
                        this.page0_write(offset, value, io_len);
                        break;
                    }
                    case 1: {
                        this.page1_write(offset, value, io_len);
                        break;
                    }
                    case 2: {
                        this.page2_write(offset, value, io_len);
                        break;
                    }
                    case 3: {
                        this.page3_write(offset, value, io_len);
                        break;
                    }
                    default: {
                        Log.log_msg("[NE2000] unknown value of pgsel in write - " + this.s.CR.pgsel);
                    }
                }
            }
        }

        public int mcast_index(byte[] dst, int offset) {
            int POLYNOMIAL = 79764918;
            int crc = -1;
            int i = 6;
            while (--i >= 0) {
                byte b = dst[offset++];
                int j = 8;
                while (--j >= 0) {
                    int carry = (((long)crc & 0x80000000L) != 0L ? 1 : 0) ^ b & 1;
                    crc <<= 1;
                    b = (byte)(b >>> 1);
                    if (carry == 0) continue;
                    crc = crc ^ 0x4C11DB6 | carry;
                }
            }
            return crc >>> 26;
        }

        public boolean rx_frame(Ptr buf, int io_len) {
            int nextpage;
            int avail;
            if (this.s.DCR.loop == 0 || this.s.TCR.loop_cntl != 0) {
                return false;
            }
            byte[] pkthdr = new byte[4];
            Ptr pktbuf = buf;
            byte[] bcast_addr = new byte[]{-1, -1, -1, -1, -1, -1};
            if (io_len != 60) {
                // empty if block
            }
            if (this.s.CR.stop != 0 || this.s.page_start == 0) {
                return true;
            }
            int pages = (io_len + 4 + 4 + 255) / 256;
            if (this.s.curr_page < this.s.bound_ptr) {
                avail = this.s.bound_ptr - this.s.curr_page;
            } else {
                avail = this.s.page_stop - this.s.page_start - (this.s.curr_page - this.s.bound_ptr);
                boolean bl = true;
            }
            if (avail <= pages) {
                return true;
            }
            if (io_len < 60 && this.s.RCR.runts_ok == 0) {
                return true;
            }
            if (this.s.RCR.promisc == 0) {
                if (Ptr.memcmp(buf, bcast_addr, 6) == 0) {
                    if (this.s.RCR.broadcast == 0) {
                        return true;
                    }
                } else if ((pktbuf.readb(0) & 1) != 0) {
                    if (this.s.RCR.multicast == 0) {
                        return true;
                    }
                    int idx = this.mcast_index(buf.p, buf.off);
                    if ((this.s.mchash[idx >> 3] & 1 << (idx & 7)) == 0) {
                        return true;
                    }
                } else if (0 != Ptr.memcmp(buf, this.s.physaddr, 6)) {
                    return true;
                }
            }
            if ((nextpage = this.s.curr_page + pages) >= this.s.page_stop) {
                nextpage -= this.s.page_stop - this.s.page_start;
            }
            pkthdr[0] = 0;
            pkthdr[0] = 1;
            if ((pktbuf.readb(0) & 1) != 0) {
                pkthdr[0] = (byte)(pkthdr[0] | 0x20);
            }
            pkthdr[1] = (byte)nextpage;
            pkthdr[2] = (byte)(io_len + 4 & 0xFF);
            pkthdr[3] = (byte)(io_len + 4 >> 8);
            Ptr startptr = new Ptr(this.s.mem, this.s.curr_page * 256 - 16384);
            if (nextpage > this.s.curr_page || this.s.curr_page + pages == this.s.page_stop) {
                Ptr.memcpy(startptr, pkthdr, 4);
                startptr.inc(4);
                Ptr.memcpy(startptr, buf, io_len);
                this.s.curr_page = (short)nextpage;
            } else {
                int endbytes = (this.s.page_stop - this.s.curr_page) * 256;
                Ptr.memcpy(startptr, pkthdr, 4);
                startptr.inc(4);
                Ptr.memcpy(startptr, buf, endbytes - 4);
                startptr = new Ptr(this.s.mem, this.s.page_start * 256 - 16384);
                Ptr.memcpy(startptr, new Ptr(pktbuf, endbytes - 4), io_len - endbytes + 4);
                this.s.curr_page = (short)nextpage;
            }
            this.s.RSR.rx_ok = 1;
            if ((pktbuf.readb(0) & 0x80) != 0) {
                this.s.RSR.rx_mbit = 1;
            }
            this.s.ISR.pkt_rx = 1;
            if (this.s.IMR.rx_inte != 0) {
                Pic.PIC_ActivateIRQ(this.s.base_irq);
            }
            return true;
        }
    }

    private static final class bx_ne2k_t {
        public CR_t CR = new CR_t();
        public ISR_t ISR = new ISR_t();
        public IMR_t IMR = new IMR_t();
        public DCR_t DCR = new DCR_t();
        public TCR_t TCR = new TCR_t();
        public TSR_t TSR = new TSR_t();
        public final RCR_t RCR = new RCR_t();
        public RSR_t RSR = new RSR_t();
        public int local_dma;
        public short page_start;
        public short page_stop;
        public short bound_ptr;
        public short tx_page_start;
        public short num_coll;
        public int tx_bytes;
        public short fifo;
        public int remote_dma;
        public int remote_start;
        public int remote_bytes;
        public short tallycnt_0;
        public short tallycnt_1;
        public short tallycnt_2;
        public byte[] physaddr = new byte[6];
        public short curr_page;
        public byte[] mchash = new byte[8];
        public short rempkt_ptr;
        public short localpkt_ptr;
        public int address_cnt;
        public byte[] macaddr = new byte[32];
        public Ptr mem = new Ptr(32768);
        public long base_address;
        public int base_irq;
        public int tx_timer_index;
        public int tx_timer_active;

        private bx_ne2k_t() {
        }

        public static final class RSR_t {
            public int rx_ok;
            public int bad_crc;
            public int bad_falign;
            public int fifo_or;
            public int rx_missed;
            public int rx_mbit;
            public int rx_disabled;
            public int deferred;
        }

        public static final class RCR_t {
            public int errors_ok;
            public int runts_ok;
            public int broadcast;
            public int multicast;
            public int promisc;
            public int monitor;
            public short reserved;
        }

        public static final class TSR_t {
            public int tx_ok;
            public int reserved;
            public int collided;
            public int aborted;
            public int no_carrier;
            public int fifo_ur;
            public int cd_hbeat;
            public int ow_coll;
        }

        public static final class TCR_t {
            public int crc_disable;
            public short loop_cntl;
            public int ext_stoptx;
            public int coll_prio;
            public short reserved;
        }

        public static final class DCR_t {
            public int wdsize;
            public int endian;
            public int longaddr;
            public int loop;
            public int auto_rx;
            public short fifo_size;
        }

        public static final class IMR_t {
            public int rx_inte;
            public int tx_inte;
            public int rxerr_inte;
            public int txerr_inte;
            public int overw_inte;
            public int cofl_inte;
            public int rdma_inte;
            public int reserved;
        }

        public static final class ISR_t {
            public int pkt_rx;
            public int pkt_tx;
            public int rx_err;
            public int tx_err;
            public int overwrite;
            public int cnt_oflow;
            public int rdma_done;
            public int reset;
        }

        public static final class CR_t {
            public int stop;
            public int start;
            public int tx_packet;
            public short rdma_cmd;
            public short pgsel;
        }
    }
}

