/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.Mixer;
import jdos.hardware.Pic;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;

public class PCSpeaker
extends Module_base {
    private static final double PI = Math.PI;
    private static final int SPKR_ENTRIES = 1024;
    private static final int SPKR_VOLUME = 5000;
    private static final float SPKR_SPEED = 142857.14f;
    private static Spkr spkr;
    private static Mixer.MIXER_Handler PCSPEAKER_CallBack;
    private Mixer.MixerObject MixerChan = new Mixer.MixerObject();
    private static PCSpeaker test;
    private static Section.SectionFunction PCSPEAKER_ShutDown;
    public static Section.SectionFunction PCSPEAKER_Init;

    private static void AddDelayEntry(float index, float vol) {
        if (PCSpeaker.spkr.used == 1024) {
            return;
        }
        PCSpeaker.spkr.entries[PCSpeaker.spkr.used].index = index;
        PCSpeaker.spkr.entries[PCSpeaker.spkr.used].vol = vol;
        ++PCSpeaker.spkr.used;
    }

    private static void ForwardPIT(float newindex) {
        float passed = newindex - PCSpeaker.spkr.last_index;
        float delay_base = PCSpeaker.spkr.last_index;
        PCSpeaker.spkr.last_index = newindex;
        switch (PCSpeaker.spkr.pit_mode) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                while (passed > 0.0f) {
                    float delay;
                    if (PCSpeaker.spkr.pit_index >= PCSpeaker.spkr.pit_half) {
                        if (PCSpeaker.spkr.pit_index + passed >= PCSpeaker.spkr.pit_max) {
                            delay = PCSpeaker.spkr.pit_max - PCSpeaker.spkr.pit_index;
                            delay_base += delay;
                            passed -= delay;
                            PCSpeaker.spkr.pit_last = -5000.0f;
                            if (PCSpeaker.spkr.mode == 3) {
                                PCSpeaker.AddDelayEntry(delay_base, PCSpeaker.spkr.pit_last);
                            }
                            PCSpeaker.spkr.pit_index = 0.0f;
                            continue;
                        }
                        PCSpeaker.spkr.pit_index += passed;
                        return;
                    }
                    if (PCSpeaker.spkr.pit_index + passed >= PCSpeaker.spkr.pit_half) {
                        delay = PCSpeaker.spkr.pit_half - PCSpeaker.spkr.pit_index;
                        delay_base += delay;
                        passed -= delay;
                        PCSpeaker.spkr.pit_last = 5000.0f;
                        if (PCSpeaker.spkr.mode == 3) {
                            PCSpeaker.AddDelayEntry(delay_base, PCSpeaker.spkr.pit_last);
                        }
                        PCSpeaker.spkr.pit_index = PCSpeaker.spkr.pit_half;
                        continue;
                    }
                    PCSpeaker.spkr.pit_index += passed;
                    return;
                }
                break;
            }
            case 3: {
                while (passed > 0.0f) {
                    float delay;
                    if (PCSpeaker.spkr.pit_index >= PCSpeaker.spkr.pit_half) {
                        if (PCSpeaker.spkr.pit_index + passed >= PCSpeaker.spkr.pit_max) {
                            delay = PCSpeaker.spkr.pit_max - PCSpeaker.spkr.pit_index;
                            delay_base += delay;
                            passed -= delay;
                            PCSpeaker.spkr.pit_last = 5000.0f;
                            if (PCSpeaker.spkr.mode == 3) {
                                PCSpeaker.AddDelayEntry(delay_base, PCSpeaker.spkr.pit_last);
                            }
                            PCSpeaker.spkr.pit_index = 0.0f;
                            PCSpeaker.spkr.pit_half = PCSpeaker.spkr.pit_new_half;
                            PCSpeaker.spkr.pit_max = PCSpeaker.spkr.pit_new_max;
                            continue;
                        }
                        PCSpeaker.spkr.pit_index += passed;
                        return;
                    }
                    if (PCSpeaker.spkr.pit_index + passed >= PCSpeaker.spkr.pit_half) {
                        delay = PCSpeaker.spkr.pit_half - PCSpeaker.spkr.pit_index;
                        delay_base += delay;
                        passed -= delay;
                        PCSpeaker.spkr.pit_last = -5000.0f;
                        if (PCSpeaker.spkr.mode == 3) {
                            PCSpeaker.AddDelayEntry(delay_base, PCSpeaker.spkr.pit_last);
                        }
                        PCSpeaker.spkr.pit_index = PCSpeaker.spkr.pit_half;
                        PCSpeaker.spkr.pit_half = PCSpeaker.spkr.pit_new_half;
                        PCSpeaker.spkr.pit_max = PCSpeaker.spkr.pit_new_max;
                        continue;
                    }
                    PCSpeaker.spkr.pit_index += passed;
                    return;
                }
                break;
            }
            case 4: {
                if (!(PCSpeaker.spkr.pit_index < PCSpeaker.spkr.pit_max)) break;
                if (PCSpeaker.spkr.pit_index + passed >= PCSpeaker.spkr.pit_max) {
                    float delay = PCSpeaker.spkr.pit_max - PCSpeaker.spkr.pit_index;
                    delay_base += delay;
                    passed -= delay;
                    PCSpeaker.spkr.pit_last = -5000.0f;
                    if (PCSpeaker.spkr.mode == 3) {
                        PCSpeaker.AddDelayEntry(delay_base, PCSpeaker.spkr.pit_last);
                    }
                    PCSpeaker.spkr.pit_index = PCSpeaker.spkr.pit_max;
                    break;
                }
                PCSpeaker.spkr.pit_index += passed;
            }
        }
    }

    public static void PCSPEAKER_SetCounter(int cntr, int mode) {
        if (PCSpeaker.spkr.last_ticks == 0) {
            if (PCSpeaker.spkr.chan != null) {
                PCSpeaker.spkr.chan.Enable(true);
            }
            PCSpeaker.spkr.last_index = 0.0f;
        }
        PCSpeaker.spkr.last_ticks = Pic.PIC_Ticks;
        float newindex = Pic.PIC_TickIndex();
        PCSpeaker.ForwardPIT(newindex);
        switch (mode) {
            case 0: {
                if (PCSpeaker.spkr.mode != 3) {
                    return;
                }
                if (cntr > 80) {
                    cntr = 80;
                }
                PCSpeaker.spkr.pit_last = ((float)cntr - 40.0f) * 125.0f;
                PCSpeaker.AddDelayEntry(newindex, PCSpeaker.spkr.pit_last);
                PCSpeaker.spkr.pit_index = 0.0f;
                break;
            }
            case 1: {
                if (PCSpeaker.spkr.mode != 3) {
                    return;
                }
                PCSpeaker.spkr.pit_last = 5000.0f;
                PCSpeaker.AddDelayEntry(newindex, PCSpeaker.spkr.pit_last);
                break;
            }
            case 2: {
                PCSpeaker.spkr.pit_index = 0.0f;
                PCSpeaker.spkr.pit_last = -5000.0f;
                PCSpeaker.AddDelayEntry(newindex, PCSpeaker.spkr.pit_last);
                PCSpeaker.spkr.pit_half = 8.380951E-4f;
                PCSpeaker.spkr.pit_max = 8.380951E-4f * (float)cntr;
                break;
            }
            case 3: {
                if (cntr < PCSpeaker.spkr.min_tr) {
                    PCSpeaker.spkr.pit_last = 0.0f;
                    PCSpeaker.spkr.pit_mode = 0;
                    return;
                }
                PCSpeaker.spkr.pit_new_max = 8.380951E-4f * (float)cntr;
                PCSpeaker.spkr.pit_new_half = PCSpeaker.spkr.pit_new_max / 2.0f;
                break;
            }
            case 4: {
                PCSpeaker.spkr.pit_last = 5000.0f;
                PCSpeaker.AddDelayEntry(newindex, PCSpeaker.spkr.pit_last);
                PCSpeaker.spkr.pit_index = 0.0f;
                PCSpeaker.spkr.pit_max = 8.380951E-4f * (float)cntr;
                break;
            }
            default: {
                return;
            }
        }
        PCSpeaker.spkr.pit_mode = mode;
    }

    public static void PCSPEAKER_SetType(int mode) {
        if (PCSpeaker.spkr.last_ticks == 0) {
            if (PCSpeaker.spkr.chan != null) {
                PCSpeaker.spkr.chan.Enable(true);
            }
            PCSpeaker.spkr.last_index = 0.0f;
        }
        PCSpeaker.spkr.last_ticks = Pic.PIC_Ticks;
        float newindex = Pic.PIC_TickIndex();
        PCSpeaker.ForwardPIT(newindex);
        switch (mode) {
            case 0: {
                PCSpeaker.spkr.mode = 0;
                PCSpeaker.AddDelayEntry(newindex, -5000.0f);
                break;
            }
            case 1: {
                PCSpeaker.spkr.mode = 2;
                PCSpeaker.AddDelayEntry(newindex, -5000.0f);
                break;
            }
            case 2: {
                PCSpeaker.spkr.mode = 1;
                PCSpeaker.AddDelayEntry(newindex, 5000.0f);
                break;
            }
            case 3: {
                if (PCSpeaker.spkr.mode != 3) {
                    PCSpeaker.AddDelayEntry(newindex, PCSpeaker.spkr.pit_last);
                }
                PCSpeaker.spkr.mode = 3;
            }
        }
    }

    public PCSpeaker(Section configuration) {
        super(configuration);
        PCSpeaker.spkr.chan = null;
        Section_prop section = (Section_prop)configuration;
        if (!section.Get_bool("pcspeaker")) {
            return;
        }
        PCSpeaker.spkr.mode = 0;
        PCSpeaker.spkr.last_ticks = 0;
        PCSpeaker.spkr.last_index = 0.0f;
        PCSpeaker.spkr.rate = section.Get_int("pcrate");
        PCSpeaker.spkr.pit_max = 54.92456f;
        PCSpeaker.spkr.pit_half = PCSpeaker.spkr.pit_max / 2.0f;
        PCSpeaker.spkr.pit_new_max = PCSpeaker.spkr.pit_max;
        PCSpeaker.spkr.pit_new_half = PCSpeaker.spkr.pit_half;
        PCSpeaker.spkr.pit_index = 0.0f;
        PCSpeaker.spkr.min_tr = (1193182 + PCSpeaker.spkr.rate / 2 - 1) / (PCSpeaker.spkr.rate / 2);
        PCSpeaker.spkr.used = 0;
        PCSpeaker.spkr.chan = this.MixerChan.Install(PCSPEAKER_CallBack, PCSpeaker.spkr.rate, "SPKR");
    }

    static {
        PCSPEAKER_CallBack = new Mixer.MIXER_Handler(){

            public void call(int len) {
                short[] stream = new short[len];
                PCSpeaker.ForwardPIT(1.0f);
                spkr.last_index = 0.0f;
                int count = len;
                int pos = 0;
                float sample_base = 0.0f;
                float sample_add = 1.0001f / (float)len;
                int i = 0;
                while (count-- != 0) {
                    float index = sample_base;
                    float end = sample_base += sample_add;
                    double value = 0.0;
                    while (index < end) {
                        if (spkr.used != 0 && spkr.entries[pos].index <= index) {
                            spkr.volwant = spkr.entries[pos].vol;
                            ++pos;
                            --spkr.used;
                            continue;
                        }
                        float vol_end = spkr.used != 0 && spkr.entries[pos].index < end ? spkr.entries[pos].index : end;
                        float vol_len = vol_end - index;
                        float vol_diff = spkr.volwant - spkr.volcur;
                        if (vol_diff == 0.0f) {
                            value += (double)(spkr.volcur * vol_len);
                            index += vol_len;
                            continue;
                        }
                        float vol_time = Math.abs(vol_diff) / 142857.14f;
                        if (vol_time <= vol_len) {
                            value += (double)(vol_time * spkr.volcur);
                            value += (double)(vol_time * vol_diff / 2.0f);
                            index += vol_time;
                            spkr.volcur = spkr.volwant;
                            continue;
                        }
                        value += (double)(spkr.volcur * vol_len);
                        if (vol_diff < 0.0f) {
                            value -= (double)(142857.14f * vol_len * vol_len / 2.0f);
                            spkr.volcur -= 142857.14f * vol_len;
                        } else {
                            value += (double)(142857.14f * vol_len * vol_len / 2.0f);
                            spkr.volcur += 142857.14f * vol_len;
                        }
                        index += vol_len;
                    }
                    stream[i++] = (short)(value / (double)sample_add);
                }
                if (spkr.chan != null) {
                    spkr.chan.AddSamples_m16(len, stream);
                }
                boolean turnoff = false;
                int test_ticks = Pic.PIC_Ticks;
                if (spkr.last_ticks + 10000 < test_ticks) {
                    turnoff = true;
                }
                if (spkr.mode == 0 && spkr.last_ticks + 1000 < test_ticks) {
                    turnoff = true;
                }
                if (turnoff) {
                    if (spkr.volwant == 0.0f) {
                        spkr.last_ticks = 0;
                        if (spkr.chan != null) {
                            spkr.chan.Enable(false);
                        }
                    } else {
                        spkr.volwant = spkr.volwant > 0.0f ? (spkr.volwant -= 1.0f) : (spkr.volwant += 1.0f);
                    }
                }
            }
        };
        PCSPEAKER_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                test = null;
                spkr = null;
            }
        };
        PCSPEAKER_Init = new Section.SectionFunction(){

            public void call(Section section) {
                spkr = new Spkr();
                test = new PCSpeaker(section);
                section.AddDestroyFunction(PCSPEAKER_ShutDown, true);
            }
        };
    }

    private static class Spkr {
        Mixer.MixerChannel chan = new Mixer.MixerChannel();
        int mode;
        int pit_mode;
        int rate;
        float pit_last;
        float pit_new_max;
        float pit_new_half;
        float pit_max;
        float pit_half;
        float pit_index;
        float volwant;
        float volcur;
        int last_ticks;
        float last_index;
        int min_tr;
        DelayEntry[] entries = new DelayEntry[1024];
        int used;

        public Spkr() {
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i] = new DelayEntry();
            }
        }
    }

    private static class DelayEntry {
        float index;
        float vol;

        private DelayEntry() {
        }
    }

    private static final class SPKR_MODES {
        public static final int SPKR_OFF = 0;
        public static final int SPKR_ON = 1;
        public static final int SPKR_PIT_OFF = 2;
        public static final int SPKR_PIT_ON = 3;

        private SPKR_MODES() {
        }
    }
}

