/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.hardware.DMA;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.Mixer;
import jdos.hardware.Pic;
import jdos.hardware.SBlaster;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.IntRef;

public class TandySound
extends Module_base {
    private static final int MAX_OUTPUT = Short.MAX_VALUE;
    private static final int STEP = 65536;
    private static final int FB_WNOISE = 81922;
    private static final int FB_PNOISE = 32768;
    private static final int NG_PRESET = 3893;
    private static SN76496 sn = new SN76496();
    private static final int TDAC_DMA_BUFSIZE = 1024;
    private static final Tandy tandy = new Tandy();
    private static final IoHandler.IO_WriteHandler SN76496Write = new IoHandler.IO_WriteHandler(){

        public void call(int port, int data, int iolen) {
            SN76496 R = sn;
            tandy.last_write = Pic.PIC_Ticks;
            if (!tandy.enabled) {
                tandy.chan.Enable(true);
                tandy.enabled = true;
            }
            if ((data & 0x80) != 0) {
                int r = (data & 0x70) >> 4;
                int c = r / 2;
                R.LastRegister = r;
                R.Register[r] = R.Register[r] & 0x3F0 | data & 0xF;
                switch (r) {
                    case 0: 
                    case 2: 
                    case 4: {
                        R.Period[c] = R.UpdateStep * R.Register[r];
                        if (R.Period[c] == 0) {
                            R.Period[c] = 1022;
                        }
                        if (r != 4 || (R.Register[6] & 3) != 3) break;
                        R.Period[3] = 2 * R.Period[2];
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: {
                        R.Volume[c] = R.VolTable[data & 0xF];
                        break;
                    }
                    case 6: {
                        int n = R.Register[6];
                        R.NoiseFB = (n & 4) != 0 ? 81922 : 32768;
                        R.Period[3] = (n &= 3) == 3 ? 2 * R.Period[2] : R.UpdateStep << 5 + n;
                    }
                }
            } else {
                int r = R.LastRegister;
                int c = r / 2;
                switch (r) {
                    case 0: 
                    case 2: 
                    case 4: {
                        R.Register[r] = R.Register[r] & 0xF | (data & 0x3F) << 4;
                        R.Period[c] = R.UpdateStep * R.Register[r];
                        if (R.Period[c] == 0) {
                            R.Period[c] = 1022;
                        }
                        if (r != 4 || (R.Register[6] & 3) != 3) break;
                        R.Period[3] = 2 * R.Period[2];
                    }
                }
            }
        }
    };
    private static final Mixer.MIXER_Handler SN76496Update = new Mixer.MIXER_Handler(){

        public void call(int length) {
            int i;
            if (tandy.last_write + 5000 < Pic.PIC_Ticks) {
                tandy.enabled = false;
                tandy.chan.Enable(false);
            }
            SN76496 R = sn;
            short[] buffer = Mixer.MixTemp16;
            int bufferIndex = 0;
            for (i = 0; i < 4; ++i) {
                if (R.Volume[i] != 0 || R.Count[i] > length * 65536) continue;
                int n = i;
                R.Count[n] = R.Count[n] + length * 65536;
            }
            int[] vol = new int[4];
            for (int count = length; count != 0; --count) {
                int nextevent;
                vol[3] = 0;
                vol[2] = 0;
                vol[1] = 0;
                vol[0] = 0;
                for (i = 0; i < 3; ++i) {
                    if (R.Output[i] != 0) {
                        int n = i;
                        vol[n] = vol[n] + R.Count[i];
                    }
                    int n = i;
                    R.Count[n] = R.Count[n] - 65536;
                    while (R.Count[i] <= 0) {
                        int n2 = i;
                        R.Count[n2] = R.Count[n2] + R.Period[i];
                        if (R.Count[i] > 0) {
                            int n3 = i;
                            R.Output[n3] = R.Output[n3] ^ 1;
                            if (R.Output[i] == 0) break;
                            int n4 = i;
                            vol[n4] = vol[n4] + R.Period[i];
                            break;
                        }
                        int n5 = i;
                        R.Count[n5] = R.Count[n5] + R.Period[i];
                        int n6 = i;
                        vol[n6] = vol[n6] + R.Period[i];
                    }
                    if (R.Output[i] == 0) continue;
                    int n7 = i;
                    vol[n7] = vol[n7] - R.Count[i];
                }
                int left = 65536;
                do {
                    nextevent = R.Count[3] < left ? R.Count[3] : left;
                    if (R.Output[3] != 0) {
                        vol[3] = vol[3] + R.Count[3];
                    }
                    R.Count[3] = R.Count[3] - nextevent;
                    if (R.Count[3] <= 0) {
                        if ((R.RNG & 1) != 0) {
                            R.RNG ^= R.NoiseFB;
                        }
                        R.RNG >>= 1;
                        R.Output[3] = R.RNG & 1;
                        R.Count[3] = R.Count[3] + R.Period[3];
                        if (R.Output[3] != 0) {
                            vol[3] = vol[3] + R.Period[3];
                        }
                    }
                    if (R.Output[3] == 0) continue;
                    vol[3] = vol[3] - R.Count[3];
                } while ((left -= nextevent) > 0);
                int out = vol[0] * R.Volume[0] + vol[1] * R.Volume[1] + vol[2] * R.Volume[2] + vol[3] * R.Volume[3];
                if (out > 0x7FFF0000) {
                    out = 0x7FFF0000;
                }
                buffer[bufferIndex++] = (short)(out / 65536);
            }
            tandy.chan.AddSamples_m16(length, buffer);
        }
    };
    private static final DMA.DMA_CallBack TandyDAC_DMA_CallBack = new DMA.DMA_CallBack(){

        public void call(DMA.DmaChannel chan, int event) {
            if (event == 0) {
                tandy.dac.dma.transfer_done = true;
                Pic.PIC_ActivateIRQ(tandy.dac.hw.irq);
            }
        }
    };
    private static final IoHandler.IO_WriteHandler TandyDACWrite = new IoHandler.IO_WriteHandler(){

        public void call(int port, int data, int iolen) {
            block0 : switch (port) {
                case 196: {
                    short oldmode = tandy.dac.mode;
                    tandy.dac.mode = (short)(data & 0xFF);
                    if ((data & 3) != (oldmode & 3)) {
                        TandySound.TandyDACModeChanged();
                    }
                    if ((data & 0xC) == 12 && (oldmode & 0xC) != 12) {
                        TandySound.TandyDACDMAEnabled();
                        break;
                    }
                    if ((data & 0xC) == 12 || (oldmode & 0xC) != 12) break;
                    TandySound.TandyDACDMADisabled();
                    break;
                }
                case 197: {
                    switch (tandy.dac.mode & 3) {
                        case 0: {
                            break block0;
                        }
                        case 1: {
                            tandy.dac.control = (short)(data & 0xFF);
                            break block0;
                        }
                        case 2: {
                            break block0;
                        }
                    }
                    break;
                }
                case 198: {
                    tandy.dac.frequency = tandy.dac.frequency & 0xF00 | (short)(data & 0xFF);
                    switch (tandy.dac.mode & 3) {
                        case 0: {
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            TandySound.TandyDACModeChanged();
                        }
                    }
                    break;
                }
                case 199: {
                    tandy.dac.frequency = tandy.dac.frequency & 0xFF | (short)(data & 0xF) << 8;
                    tandy.dac.amplitude = (short)(data >> 5);
                    switch (tandy.dac.mode & 3) {
                        case 0: {
                            break block0;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            TandySound.TandyDACModeChanged();
                        }
                    }
                }
            }
        }
    };
    private static final IoHandler.IO_ReadHandler TandyDACRead = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            switch (port) {
                case 196: {
                    return tandy.dac.mode & 0x77 | (tandy.dac.irq_activated ? 8 : 0);
                }
                case 198: {
                    return (short)(tandy.dac.frequency & 0xFF);
                }
                case 199: {
                    return (short)(tandy.dac.frequency >> 8 & 0xF | tandy.dac.amplitude << 5);
                }
            }
            Log.log_msg("Tandy DAC: Read from unknown " + Integer.toString(port, 16));
            return 255;
        }
    };
    private static final Mixer.MIXER_Handler TandyDACUpdate = new Mixer.MIXER_Handler(){

        public void call(int length) {
            if (tandy.dac.enabled && (tandy.dac.mode & 0xC) == 12) {
                if (!tandy.dac.dma.transfer_done) {
                    int len = length;
                    TandySound.TandyDACGenerateDMASound(len);
                } else {
                    for (int ct = 0; ct < length; ++ct) {
                        tandy.dac.chan.AddSamples_m8(1, tandy.dac.dma.last_sample);
                    }
                }
            } else {
                tandy.dac.chan.AddSilence();
            }
        }
    };
    private IoHandler.IO_WriteHandleObject[] WriteHandler = new IoHandler.IO_WriteHandleObject[4];
    private IoHandler.IO_ReadHandleObject[] ReadHandler = new IoHandler.IO_ReadHandleObject[4];
    private Mixer.MixerObject MixerChan = new Mixer.MixerObject();
    private Mixer.MixerObject MixerChanDAC = new Mixer.MixerObject();
    private static TandySound test;
    private static Section.SectionFunction TANDYSOUND_ShutDown;
    public static Section.SectionFunction TANDYSOUND_Init;

    private static void SN76496_set_clock(int clock) {
        SN76496 R = sn;
        R.UpdateStep = (int)(65536.0 * (double)R.SampleRate * 16.0 / (double)clock);
    }

    private static void SN76496_set_gain(int gain) {
        SN76496 R = sn;
        gain &= 0xFF;
        double out = 10922.0;
        while (gain-- > 0) {
            out *= 1.023292992;
        }
        for (int i = 0; i < 15; ++i) {
            R.VolTable[i] = out > 10922.0 ? 10922 : (int)out;
            out /= 1.258925412;
        }
        R.VolTable[15] = 0;
    }

    private static boolean TS_Get_Address(IntRef tsaddr, IntRef tsirq, IntRef tsdma) {
        tsaddr.value = 0;
        tsirq.value = 0;
        tsdma.value = 0;
        if (TandySound.tandy.dac.enabled) {
            tsaddr.value = TandySound.tandy.dac.hw.base;
            tsirq.value = TandySound.tandy.dac.hw.irq;
            tsdma.value = TandySound.tandy.dac.hw.dma;
            return true;
        }
        return false;
    }

    private static void TandyDACModeChanged() {
        switch (TandySound.tandy.dac.mode & 3) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                TandySound.tandy.dac.chan.FillUp();
                if (TandySound.tandy.dac.frequency == 0) break;
                float freq = 3579545.0f / (float)TandySound.tandy.dac.frequency;
                TandySound.tandy.dac.chan.SetFreq((int)freq);
                float vol = (float)TandySound.tandy.dac.amplitude / 7.0f;
                TandySound.tandy.dac.chan.SetVolume(vol, vol);
                if ((TandySound.tandy.dac.mode & 0xC) != 12) break;
                TandySound.tandy.dac.dma.transfer_done = false;
                TandySound.tandy.dac.dma.chan = DMA.GetDMAChannel(TandySound.tandy.dac.hw.dma);
                if (TandySound.tandy.dac.dma.chan == null) break;
                TandySound.tandy.dac.dma.chan.Register_Callback(TandyDAC_DMA_CallBack);
                TandySound.tandy.dac.chan.Enable(true);
            }
        }
    }

    private static void TandyDACDMAEnabled() {
        TandySound.TandyDACModeChanged();
    }

    private static void TandyDACDMADisabled() {
    }

    private static void TandyDACGenerateDMASound(int length) {
        if (length != 0) {
            int read = TandySound.tandy.dac.dma.chan.Read(length, TandySound.tandy.dac.dma.buf, 0);
            TandySound.tandy.dac.chan.AddSamples_m8(read, TandySound.tandy.dac.dma.buf);
            if (read < length) {
                if (read > 0) {
                    TandySound.tandy.dac.dma.last_sample[0] = TandySound.tandy.dac.dma.buf[read - 1];
                }
                for (int ct = read; ct < length; ++ct) {
                    TandySound.tandy.dac.chan.AddSamples_m8(1, TandySound.tandy.dac.dma.last_sample);
                }
            }
        }
    }

    public TandySound(Section configuration) {
        super(configuration);
        String option;
        int i;
        Section_prop section = (Section_prop)configuration;
        for (i = 0; i < this.WriteHandler.length; ++i) {
            this.WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
        }
        for (i = 0; i < this.ReadHandler.length; ++i) {
            this.ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
        }
        boolean enable_hw_tandy_dac = true;
        IntRef sbport = new IntRef(0);
        IntRef sbirq = new IntRef(0);
        IntRef sbdma = new IntRef(0);
        if (SBlaster.SB_Get_Address(sbport, sbirq, sbdma)) {
            enable_hw_tandy_dac = false;
        }
        Memory.real_writeb(64, 212, 0);
        if (Dosbox.IS_TANDY_ARCH()) {
            option = section.Get_string("tandy").toLowerCase();
            if (!(option.equals("true") || option.equals("on") || option.equals("auto"))) {
                return;
            }
        } else {
            option = section.Get_string("tandy").toLowerCase();
            if (!option.equals("true") && !option.equals("on")) {
                return;
            }
            DMA.CloseSecondDMAController();
            if (enable_hw_tandy_dac) {
                this.WriteHandler[2].Install(480, SN76496Write, 1, 2);
                this.WriteHandler[3].Install(484, TandyDACWrite, 1, 4);
            }
        }
        int sample_rate = section.Get_int("tandyrate");
        TandySound.tandy.chan = this.MixerChan.Install(SN76496Update, sample_rate, "TANDY");
        this.WriteHandler[0].Install(192, SN76496Write, 1, 2);
        if (enable_hw_tandy_dac) {
            this.WriteHandler[1].Install(196, TandyDACWrite, 1, 4);
            this.ReadHandler[1].Install(196, TandyDACRead, 1, 4);
            TandySound.tandy.dac.enabled = true;
            TandySound.tandy.dac.chan = this.MixerChanDAC.Install(TandyDACUpdate, sample_rate, "TANDYDAC");
            TandySound.tandy.dac.hw.base = 196;
            TandySound.tandy.dac.hw.irq = (short)7;
            TandySound.tandy.dac.hw.dma = 1;
        } else {
            TandySound.tandy.dac.enabled = false;
            TandySound.tandy.dac.hw.base = 0;
            TandySound.tandy.dac.hw.irq = 0;
            TandySound.tandy.dac.hw.dma = 0;
        }
        TandySound.tandy.dac.control = 0;
        TandySound.tandy.dac.mode = 0;
        TandySound.tandy.dac.irq_activated = false;
        TandySound.tandy.dac.frequency = 0;
        TandySound.tandy.dac.amplitude = 0;
        TandySound.tandy.dac.dma.last_sample[0] = 0;
        TandySound.tandy.enabled = false;
        Memory.real_writeb(64, 212, 255);
        SN76496 R = sn;
        R.SampleRate = sample_rate;
        TandySound.SN76496_set_clock(3579545);
        for (i = 0; i < 4; ++i) {
            R.Volume[i] = 0;
        }
        R.LastRegister = 0;
        for (i = 0; i < 8; i += 2) {
            R.Register[i] = 0;
            R.Register[i + 1] = 15;
        }
        for (i = 0; i < 4; ++i) {
            R.Output[i] = 0;
            R.Period[i] = R.Count[i] = R.UpdateStep;
        }
        R.RNG = 3893;
        R.Output[3] = R.RNG & 1;
        TandySound.SN76496_set_gain(1);
    }

    static {
        TANDYSOUND_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                test = null;
            }
        };
        TANDYSOUND_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new TandySound(section);
                section.AddDestroyFunction(TANDYSOUND_ShutDown, true);
            }
        };
    }

    private static final class Tandy {
        Mixer.MixerChannel chan;
        boolean enabled;
        int last_write;
        Dac dac = new Dac();

        private Tandy() {
        }

        public static class Dac {
            Mixer.MixerChannel chan;
            boolean enabled;
            HW hw = new HW();
            DMA dma = new DMA();
            short mode;
            short control;
            int frequency;
            short amplitude;
            boolean irq_activated;

            public static class DMA {
                int rate;
                byte[] buf = new byte[1024];
                byte[] last_sample = new byte[1];
                DMA.DmaChannel chan;
                boolean transfer_done;
            }

            public static class HW {
                int base;
                short irq;
                short dma;
            }
        }
    }

    private static final class SN76496 {
        int SampleRate;
        int UpdateStep;
        int[] VolTable = new int[16];
        int[] Register = new int[8];
        int LastRegister;
        int[] Volume = new int[4];
        int RNG;
        int NoiseFB;
        int[] Period = new int[4];
        int[] Count = new int[4];
        int[] Output = new int[4];

        private SN76496() {
        }
    }
}

