/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.cpu.CPU;
import jdos.hardware.IoHandler;
import jdos.hardware.PCSpeaker;
import jdos.hardware.Pic;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;

public class Timer
extends Module_base {
    public static final int PIT_TICK_RATE = 1193182;
    private static TickerBlock firstticker;
    private static PIT_Block[] pit;
    private static boolean gate2;
    private static short latched_timerstatus;
    private static boolean latched_timerstatus_locked;
    private static Pic.PIC_EventHandler PIT0_Event;
    private static IoHandler.IO_WriteHandler write_latch;
    private static IoHandler.IO_ReadHandler read_latch;
    private static IoHandler.IO_WriteHandler write_p43;
    private IoHandler.IO_ReadHandleObject[] ReadHandler = new IoHandler.IO_ReadHandleObject[4];
    private IoHandler.IO_WriteHandleObject[] WriteHandler = new IoHandler.IO_WriteHandleObject[4];
    private static Timer test;
    private static Section.SectionFunction TIMER_Destroy;
    public static Section.SectionFunction TIMER_Init;

    public static void TIMER_DelTickHandler(TIMER_TickHandler handler2) {
        TickerBlock ticker = firstticker;
        TickerBlock prev = null;
        while (ticker != null) {
            if (ticker.handler == handler2) {
                if (prev == null) {
                    firstticker = ticker.next;
                } else {
                    prev.next = ticker.next;
                }
                return;
            }
            prev = ticker;
            ticker = ticker.next;
        }
    }

    public static void TIMER_AddTickHandler(TIMER_TickHandler handler2) {
        TickerBlock newticker = new TickerBlock();
        newticker.next = firstticker;
        newticker.handler = handler2;
        firstticker = newticker;
    }

    public static void TIMER_AddTick() {
        CPU.CPU_CycleLeft = CPU.CPU_CycleMax;
        CPU.CPU_Cycles = 0;
        ++Pic.PIC_Ticks;
        Pic.PICEntry entry = Pic.pic_queue.next_entry;
        while (entry != null) {
            entry.index -= 1.0;
            entry = entry.next;
        }
        TickerBlock ticker = firstticker;
        while (ticker != null) {
            TickerBlock nextticker = ticker.next;
            ticker.handler.call();
            ticker = nextticker;
        }
    }

    public static int BIN2BCD(int val) {
        return val % 10 + (val / 10 % 10 << 4) + (val / 100 % 10 << 8) + (val / 1000 % 10 << 12);
    }

    public static int BCD2BIN(int val) {
        return (val & 0xF) + (val >> 4 & 0xF) * 10 + (val >> 8 & 0xF) * 100 + (val >> 12 & 0xF) * 1000;
    }

    static double fmod(double d, double d1) {
        return d % d1;
    }

    static boolean counter_output(int counter) {
        PIT_Block p = pit[counter];
        double index = Pic.PIC_FullIndex() - p.start;
        switch (p.mode) {
            case 0: {
                if (p.new_mode) {
                    return false;
                }
                return index > (double)p.delay;
            }
            case 2: {
                if (p.new_mode) {
                    return true;
                }
                return (index = Timer.fmod(index, p.delay)) > 0.0;
            }
            case 3: {
                if (p.new_mode) {
                    return true;
                }
                return (index = Timer.fmod(index, p.delay)) * 2.0 < (double)p.delay;
            }
            case 4: {
                return true;
            }
        }
        Log.log(15, 2, "Illegal Mode " + p.mode + " for reading output");
        return true;
    }

    private static void status_latch(int counter) {
        if (!latched_timerstatus_locked) {
            PIT_Block p = pit[counter];
            latched_timerstatus = 0;
            if (p.bcd) {
                latched_timerstatus = (short)(latched_timerstatus | 1);
            }
            latched_timerstatus = (short)(latched_timerstatus | (p.mode & 7) << 1);
            if (p.read_state == 0 || p.read_state == 3) {
                latched_timerstatus = (short)(latched_timerstatus | 0x30);
            } else if (p.read_state == 1) {
                latched_timerstatus = (short)(latched_timerstatus | 0x10);
            } else if (p.read_state == 2) {
                latched_timerstatus = (short)(latched_timerstatus | 0x20);
            }
            if (Timer.counter_output(counter)) {
                latched_timerstatus = (short)(latched_timerstatus | 0x80);
            }
            if (p.new_mode) {
                latched_timerstatus = (short)(latched_timerstatus | 0x40);
            }
            p.counterstatus_set = true;
            latched_timerstatus_locked = true;
        }
    }

    static void counter_latch(int counter) {
        PIT_Block p = pit[counter];
        p.go_read_latch = false;
        if (counter == 2 && !gate2 && p.mode != 1) {
            return;
        }
        double index = Pic.PIC_FullIndex() - p.start;
        switch (p.mode) {
            case 0: 
            case 4: {
                if (index > (double)p.delay) {
                    index -= (double)p.delay;
                    if (p.bcd) {
                        index = Timer.fmod(index, 8.38095110385507);
                        p.read_latch = (int)(9999.0 - index * 1193.182);
                        break;
                    }
                    index = Timer.fmod(index, 54.92540115422459);
                    p.read_latch = (int)(65535.0 - index * 1193.182);
                    break;
                }
                p.read_latch = (int)((double)p.cntr - index * 1193.182);
                break;
            }
            case 1: {
                if (!p.counting) break;
                if (index > (double)p.delay) {
                    p.read_latch = 65535;
                    break;
                }
                p.read_latch = (int)((double)p.cntr - index * 1193.182);
                break;
            }
            case 2: {
                index = Timer.fmod(index, p.delay);
                p.read_latch = (int)((double)p.cntr - index / (double)p.delay * (double)p.cntr);
                break;
            }
            case 3: {
                index = Timer.fmod(index, p.delay);
                index *= 2.0;
                if (index > (double)p.delay) {
                    index -= (double)p.delay;
                }
                p.read_latch = (int)((double)p.cntr - index / (double)p.delay * (double)p.cntr);
                p.read_latch &= 0xFFFE;
                break;
            }
            default: {
                Log.log(15, 2, "Illegal Mode " + p.mode + " for reading counter " + counter);
                p.read_latch = 65535;
            }
        }
    }

    public static void TIMER_SetGate2(boolean in) {
        if (gate2 == in) {
            return;
        }
        switch (Timer.pit[2].mode) {
            case 0: {
                if (in) {
                    Timer.pit[2].start = Pic.PIC_FullIndex();
                    break;
                }
                Timer.counter_latch(2);
                Timer.pit[2].cntr = Timer.pit[2].read_latch;
                break;
            }
            case 1: {
                if (!in) break;
                Timer.pit[2].counting = true;
                Timer.pit[2].start = Pic.PIC_FullIndex();
                break;
            }
            case 2: 
            case 3: {
                if (in) {
                    Timer.pit[2].start = Pic.PIC_FullIndex();
                    break;
                }
                Timer.counter_latch(2);
                break;
            }
            case 4: 
            case 5: {
                Log.log(21, 1, "unsupported gate 2 mode " + Integer.toString(Timer.pit[2].mode, 16));
            }
        }
        gate2 = in;
    }

    public Timer(Section configuration) {
        super(configuration);
        int i;
        for (i = 0; i < this.ReadHandler.length; ++i) {
            this.ReadHandler[i] = new IoHandler.IO_ReadHandleObject();
        }
        for (i = 0; i < this.WriteHandler.length; ++i) {
            this.WriteHandler[i] = new IoHandler.IO_WriteHandleObject();
        }
        this.WriteHandler[0].Install(64, write_latch, 1);
        this.WriteHandler[2].Install(66, write_latch, 1);
        this.WriteHandler[3].Install(67, write_p43, 1);
        this.ReadHandler[0].Install(64, read_latch, 1);
        this.ReadHandler[1].Install(65, read_latch, 1);
        this.ReadHandler[2].Install(66, read_latch, 1);
        Timer.pit[0].cntr = 65536;
        Timer.pit[0].write_state = (short)3;
        Timer.pit[0].read_state = (short)3;
        Timer.pit[0].read_latch = 0;
        Timer.pit[0].write_latch = 0;
        Timer.pit[0].mode = (short)3;
        Timer.pit[0].bcd = false;
        Timer.pit[0].go_read_latch = true;
        Timer.pit[0].counterstatus_set = false;
        Timer.pit[0].update_count = false;
        Timer.pit[1].bcd = false;
        Timer.pit[1].write_state = 1;
        Timer.pit[1].read_state = 1;
        Timer.pit[1].go_read_latch = true;
        Timer.pit[1].cntr = 18;
        Timer.pit[1].mode = (short)2;
        Timer.pit[1].write_state = (short)3;
        Timer.pit[1].counterstatus_set = false;
        Timer.pit[2].read_latch = 1320;
        Timer.pit[2].write_state = (short)3;
        Timer.pit[2].read_state = (short)3;
        Timer.pit[2].mode = (short)3;
        Timer.pit[2].bcd = false;
        Timer.pit[2].cntr = 1320;
        Timer.pit[2].go_read_latch = true;
        Timer.pit[2].counterstatus_set = false;
        Timer.pit[2].counting = false;
        Timer.pit[0].delay = 1000.0f / (1193182.0f / (float)Timer.pit[0].cntr);
        Timer.pit[1].delay = 1000.0f / (1193182.0f / (float)Timer.pit[1].cntr);
        Timer.pit[2].delay = 1000.0f / (1193182.0f / (float)Timer.pit[2].cntr);
        latched_timerstatus_locked = false;
        gate2 = false;
        Pic.PIC_AddEvent(PIT0_Event, Timer.pit[0].delay);
    }

    static {
        pit = new PIT_Block[3];
        PIT0_Event = new Pic.PIC_EventHandler(){

            public void call(int val) {
                Pic.PIC_ActivateIRQ(0);
                if (pit[0].mode != 0) {
                    pit[0].start += (double)pit[0].delay;
                    if (pit[0].update_count) {
                        pit[0].delay = 1000.0f / (1193182.0f / (float)pit[0].cntr);
                        pit[0].update_count = false;
                    }
                    Pic.PIC_AddEvent(PIT0_Event, pit[0].delay);
                }
            }

            public String toString() {
                return "PIT0_Event";
            }
        };
        write_latch = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                int counter = port - 64;
                PIT_Block p = pit[counter];
                if (p.bcd) {
                    Timer.BIN2BCD(p.write_latch);
                }
                switch (p.write_state) {
                    case 0: {
                        p.write_latch |= (val & 0xFF) << 8;
                        p.write_state = (short)3;
                        break;
                    }
                    case 3: {
                        p.write_latch = val & 0xFF;
                        p.write_state = 0;
                        break;
                    }
                    case 1: {
                        p.write_latch = val & 0xFF;
                        break;
                    }
                    case 2: {
                        p.write_latch = (val & 0xFF) << 8;
                    }
                }
                if (p.bcd) {
                    Timer.BCD2BIN(p.write_latch);
                }
                if (p.write_state != 0) {
                    p.cntr = p.write_latch == 0 ? (!p.bcd ? 65536 : 9999) : p.write_latch;
                    if (!p.new_mode && p.mode == 2 && counter == 0) {
                        p.update_count = true;
                        return;
                    }
                    p.start = Pic.PIC_FullIndex();
                    p.delay = 1000.0f / (1193182.0f / (float)p.cntr);
                    switch (counter) {
                        case 0: {
                            if (p.new_mode || p.mode == 0) {
                                if (p.mode == 0) {
                                    Pic.PIC_RemoveEvents(PIT0_Event);
                                }
                                Pic.PIC_AddEvent(PIT0_Event, p.delay);
                                break;
                            }
                            Log.log(15, 0, "PIT 0 Timer set without new control word");
                            break;
                        }
                        case 2: {
                            PCSpeaker.PCSPEAKER_SetCounter(p.cntr, p.mode);
                            break;
                        }
                        default: {
                            Log.log(15, 2, "PIT:Illegal timer selected for writing");
                        }
                    }
                    p.new_mode = false;
                }
            }
        };
        read_latch = new IoHandler.IO_ReadHandler(){

            public int call(int port, int iolen) {
                int counter = port - 64;
                int ret = 0;
                if (pit[counter].counterstatus_set) {
                    pit[counter].counterstatus_set = false;
                    latched_timerstatus_locked = false;
                    ret = latched_timerstatus;
                } else {
                    if (pit[counter].go_read_latch) {
                        Timer.counter_latch(counter);
                    }
                    if (pit[counter].bcd) {
                        Timer.BIN2BCD(pit[counter].read_latch);
                    }
                    switch (pit[counter].read_state) {
                        case 0: {
                            ret = pit[counter].read_latch >> 8 & 0xFF;
                            pit[counter].read_state = (short)3;
                            pit[counter].go_read_latch = true;
                            break;
                        }
                        case 3: {
                            ret = pit[counter].read_latch & 0xFF;
                            pit[counter].read_state = 0;
                            break;
                        }
                        case 1: {
                            ret = pit[counter].read_latch & 0xFF;
                            pit[counter].go_read_latch = true;
                            break;
                        }
                        case 2: {
                            ret = pit[counter].read_latch >> 8 & 0xFF;
                            pit[counter].go_read_latch = true;
                            break;
                        }
                        default: {
                            Log.exit("Timer.cpp: error in readlatch");
                        }
                    }
                    if (pit[counter].bcd) {
                        Timer.BCD2BIN(pit[counter].read_latch);
                    }
                }
                return ret;
            }
        };
        write_p43 = new IoHandler.IO_WriteHandler(){

            public void call(int port, int val, int iolen) {
                int latch = val >> 6 & 3;
                switch (latch) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if ((val & 0x30) == 0) {
                            Timer.counter_latch(latch);
                            break;
                        }
                        boolean bl = pit[latch].bcd = (val & 1) > 0;
                        if ((val & 1) != 0 && pit[latch].cntr >= 9999) {
                            pit[latch].cntr = 9999;
                        }
                        if (pit[latch].counterstatus_set) {
                            pit[latch].counterstatus_set = false;
                            latched_timerstatus_locked = false;
                        }
                        pit[latch].update_count = false;
                        pit[latch].counting = false;
                        pit[latch].read_state = (short)(val >> 4 & 3);
                        pit[latch].write_state = (short)(val >> 4 & 3);
                        short mode = (short)(val >> 1 & 7);
                        if (mode > 5) {
                            mode = (short)(mode - 4);
                        }
                        if (pit[latch].mode == 0) {
                            pit[latch].mode = mode;
                        }
                        if (latch == 0) {
                            Pic.PIC_RemoveEvents(PIT0_Event);
                            if (!Timer.counter_output(0) && mode != 0) {
                                Pic.PIC_ActivateIRQ(0);
                                if (CPU.CPU_Cycles < 25) {
                                    CPU.CPU_Cycles = 25;
                                }
                            }
                            if (mode == 0) {
                                Pic.PIC_DeActivateIRQ(0);
                            }
                        }
                        pit[latch].new_mode = true;
                        pit[latch].mode = mode;
                        break;
                    }
                    case 3: {
                        if ((val & 0x20) == 0) {
                            if ((val & 2) != 0) {
                                Timer.counter_latch(0);
                            }
                            if ((val & 4) != 0) {
                                Timer.counter_latch(1);
                            }
                            if ((val & 8) != 0) {
                                Timer.counter_latch(2);
                            }
                        }
                        if ((val & 0x10) != 0) break;
                        if ((val & 2) != 0) {
                            Timer.status_latch(0);
                            break;
                        }
                        if ((val & 4) != 0) {
                            Timer.status_latch(1);
                            break;
                        }
                        if ((val & 8) == 0) break;
                        Timer.status_latch(2);
                    }
                }
            }
        };
        TIMER_Destroy = new Section.SectionFunction(){

            public void call(Section section) {
                Pic.PIC_RemoveEvents(PIT0_Event);
                test = null;
                for (int i = 0; i < pit.length; ++i) {
                    pit[i] = null;
                }
                firstticker = null;
            }
        };
        TIMER_Init = new Section.SectionFunction(){

            public void call(Section section) {
                firstticker = null;
                for (int i = 0; i < pit.length; ++i) {
                    pit[i] = new PIT_Block();
                }
                test = new Timer(section);
                section.AddDestroyFunction(TIMER_Destroy);
            }
        };
    }

    private static class PIT_Block {
        int cntr;
        float delay;
        double start;
        int read_latch;
        int write_latch;
        short mode;
        short latch_mode;
        short read_state;
        short write_state;
        boolean bcd;
        boolean go_read_latch;
        boolean new_mode;
        boolean counterstatus_set;
        boolean counting;
        boolean update_count;

        private PIT_Block() {
        }
    }

    private static class TickerBlock {
        TIMER_TickHandler handler;
        TickerBlock next;

        private TickerBlock() {
        }
    }

    public static interface TIMER_TickHandler {
        public void call();
    }
}

