/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.cpu.Paging;
import jdos.hardware.Pic;
import jdos.hardware.VGA_attr;
import jdos.hardware.VGA_dac;
import jdos.hardware.VGA_draw;
import jdos.hardware.VGA_gfx;
import jdos.hardware.VGA_memory;
import jdos.hardware.VGA_misc;
import jdos.hardware.VGA_other;
import jdos.hardware.VGA_paradise;
import jdos.hardware.VGA_s3;
import jdos.hardware.VGA_seq;
import jdos.hardware.VGA_tseng;
import jdos.hardware.VGA_xga;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.Ptr;

public class VGA {
    public static final boolean VGA_LFB_MAPPED = true;
    public static final int VGA_CHANGE_SHIFT = 9;
    public static final int M_CGA2 = 0;
    public static final int M_CGA4 = 1;
    public static final int M_EGA = 2;
    public static final int M_VGA = 3;
    public static final int M_LIN4 = 4;
    public static final int M_LIN8 = 5;
    public static final int M_LIN15 = 6;
    public static final int M_LIN16 = 7;
    public static final int M_LIN32 = 8;
    public static final int M_TEXT = 9;
    public static final int M_HERC_GFX = 10;
    public static final int M_HERC_TEXT = 11;
    public static final int M_CGA16 = 12;
    public static final int M_TANDY2 = 13;
    public static final int M_TANDY4 = 14;
    public static final int M_TANDY16 = 15;
    public static final int M_TANDY_TEXT = 16;
    public static final int M_ERROR = 17;
    public static final int CLK_25 = 25175;
    public static final int CLK_28 = 28322;
    public static final int MIN_VCO = 180000;
    public static final int MAX_VCO = 360000;
    public static final int S3_CLOCK_REF = 14318;
    public static final int S3_MAX_CLOCK = 150000;
    public static final int S3_XGA_1024 = 0;
    public static final int S3_XGA_1152 = 1;
    public static final int S3_XGA_640 = 64;
    public static final int S3_XGA_800 = 128;
    public static final int S3_XGA_1280 = 192;
    public static final int S3_XGA_WMASK = 193;
    public static final int S3_XGA_8BPP = 0;
    public static final int S3_XGA_16BPP = 16;
    public static final int S3_XGA_32BPP = 48;
    public static final int S3_XGA_CMASK = 48;
    public static VGA_Type vga;
    public static SVGA_Driver svga;
    public static int[] CGA_2_Table;
    public static int[] CGA_4_Table;
    public static int[] CGA_4_HiRes_Table;
    private static int[] CGA_16_Table;
    public static int[] TXT_Font_Table;
    public static int[] TXT_FG_Table;
    public static int[] TXT_BG_Table;
    public static int[] ExpandTable;
    public static int[][] Expand16Table;
    public static int[] FillTable;
    private static int[] ColorTable;
    public static Section.SectionFunction VGA_Init;

    public static int S3_CLOCK(int _M, int _N, int _R) {
        return 14318 * (_M + 2) / ((_N + 2) * (1 << _R));
    }

    public static void VGA_SetModeNow(int mode) {
        if (VGA.vga.mode == mode) {
            return;
        }
        VGA.vga.mode = mode;
        VGA_memory.VGA_SetupHandlers();
        VGA.VGA_StartResize(0);
    }

    public static void VGA_SetMode(int mode) {
        if (VGA.vga.mode == mode) {
            return;
        }
        VGA.vga.mode = mode;
        VGA_memory.VGA_SetupHandlers();
        VGA.VGA_StartResize();
    }

    public static void VGA_DetermineMode() {
        if (VGA.svga.determine_mode != null) {
            VGA.svga.determine_mode.call();
            return;
        }
        switch (VGA.vga.s3.misc_control_2 >> 4) {
            case 0: {
                if ((VGA.vga.attr.mode_control & 1) != 0) {
                    if (Dosbox.IS_VGA_ARCH() && (VGA.vga.gfx.mode & 0x40) != 0) {
                        if ((VGA.vga.s3.reg_31 & 8) != 0) {
                            VGA.VGA_SetMode(5);
                            break;
                        }
                        VGA.VGA_SetMode(3);
                        break;
                    }
                    if ((VGA.vga.gfx.mode & 0x20) != 0) {
                        VGA.VGA_SetMode(1);
                        break;
                    }
                    if ((VGA.vga.gfx.miscellaneous & 0xC) == 12) {
                        VGA.VGA_SetMode(0);
                        break;
                    }
                    if ((VGA.vga.s3.reg_31 & 8) != 0) {
                        VGA.VGA_SetMode(4);
                        break;
                    }
                    VGA.VGA_SetMode(2);
                    break;
                }
                VGA.VGA_SetMode(9);
                break;
            }
            case 1: {
                VGA.VGA_SetMode(5);
                break;
            }
            case 3: {
                VGA.VGA_SetMode(6);
                break;
            }
            case 5: {
                VGA.VGA_SetMode(7);
                break;
            }
            case 13: {
                VGA.VGA_SetMode(8);
            }
        }
    }

    public static void VGA_StartResize() {
        VGA.VGA_StartResize(50);
    }

    public static void VGA_StartResize(int delay) {
        if (!VGA.vga.draw.resizing) {
            VGA.vga.draw.resizing = true;
            if (VGA.vga.mode == 17) {
                delay = 5;
            }
            if (delay == 0) {
                VGA_draw.VGA_SetupDrawing.call(0);
            } else {
                Pic.PIC_AddEvent(VGA_draw.VGA_SetupDrawing, delay);
            }
        }
    }

    public static void VGA_SetClock(int which, int target) {
        int f_vco;
        int r;
        if (VGA.svga.set_clock != null) {
            VGA.svga.set_clock.call(which, target);
            return;
        }
        int best_err = target;
        int best_m = 1;
        int best_n = 1;
        for (r = 0; r <= 3 && (180000 > (f_vco = target * (1 << r)) || f_vco >= 360000); ++r) {
        }
        for (int n = 1; n <= 31; ++n) {
            int m = (target * (n + 2) * (1 << r) + 7159) / 14318 - 2;
            if (0 > m || m > 127) continue;
            int temp_target = VGA.S3_CLOCK(m, n, r);
            int err = target - temp_target;
            if (err < 0) {
                err = -err;
            }
            if (err >= best_err) continue;
            best_err = err;
            best_m = m;
            best_n = n;
        }
        VGA.vga.s3.clk[which].m = (short)best_m;
        VGA.vga.s3.clk[which].r = (short)r;
        VGA.vga.s3.clk[which].n = (short)best_n;
        VGA.VGA_StartResize();
    }

    public static void VGA_SetCGA2Table(int val0, int val1) {
        byte[] total = new byte[]{(byte)val0, (byte)val1};
        for (int i = 0; i < 16; ++i) {
            VGA.CGA_2_Table[i] = total[i >> 3 & 1] << 0 | total[i >> 2 & 1] << 8 | total[i >> 1 & 1] << 16 | total[i >> 0 & 1] << 24;
        }
    }

    public static void VGA_SetCGA4Table(int val0, int val1, int val2, int val3) {
        byte[] total = new byte[]{(byte)val0, (byte)val1, (byte)val2, (byte)val3};
        for (int i = 0; i < 256; ++i) {
            VGA.CGA_4_Table[i] = total[i >> 6 & 3] << 0 | total[i >> 4 & 3] << 8 | total[i >> 2 & 3] << 16 | total[i >> 0 & 3] << 24;
            VGA.CGA_4_HiRes_Table[i] = total[i >> 3 & 1 | i >> 6 & 2] << 0 | total[i >> 2 & 1 | i >> 5 & 2] << 8 | total[i >> 1 & 1 | i >> 4 & 2] << 16 | total[i >> 0 & 1 | i >> 3 & 2] << 24;
        }
    }

    private static void SVGA_Setup_Driver() {
        svga = new SVGA_Driver();
        switch (Dosbox.svgaCard) {
            case 1: {
                VGA_s3.SVGA_Setup_S3Trio();
                break;
            }
            case 2: {
                VGA_tseng.SVGA_Setup_TsengET4K();
                break;
            }
            case 3: {
                VGA_tseng.SVGA_Setup_TsengET3K();
                break;
            }
            case 4: {
                VGA_paradise.SVGA_Setup_ParadisePVGA1A();
                break;
            }
            default: {
                VGA.vga.vmemwrap = 262144;
                VGA.vga.vmemsize = 262144;
            }
        }
    }

    public static void VGA_Init() {
        vga = new VGA_Type();
    }

    static {
        CGA_2_Table = new int[16];
        CGA_4_Table = new int[256];
        CGA_4_HiRes_Table = new int[256];
        CGA_16_Table = new int[256];
        TXT_Font_Table = new int[16];
        TXT_FG_Table = new int[16];
        TXT_BG_Table = new int[16];
        ExpandTable = new int[256];
        Expand16Table = new int[4][16];
        FillTable = new int[16];
        ColorTable = new int[16];
        VGA_Init = new Section.SectionFunction(){

            public void call(Section sec) {
                int i;
                Section_prop section = (Section_prop)sec;
                VGA.vga.draw.resizing = false;
                VGA.vga.mode = 17;
                VGA.vga.vmemsize = section.Get_int("vmemsize") * 1024 * 1024;
                VGA.SVGA_Setup_Driver();
                VGA_memory.VGA_SetupMemory.call(section);
                VGA_misc.VGA_SetupMisc();
                VGA_dac.VGA_SetupDAC();
                VGA_gfx.VGA_SetupGFX();
                VGA_seq.VGA_SetupSEQ();
                VGA_attr.VGA_SetupAttr();
                VGA_other.VGA_SetupOther();
                VGA_xga.VGA_SetupXGA();
                VGA.VGA_SetClock(0, 25175);
                VGA.VGA_SetClock(1, 28322);
                VGA.VGA_SetCGA2Table(0, 1);
                VGA.VGA_SetCGA4Table(0, 1, 2, 3);
                for (i = 0; i < 256; ++i) {
                    VGA.ExpandTable[i] = i | i << 8 | i << 16 | i << 24;
                }
                for (i = 0; i < 16; ++i) {
                    VGA.TXT_FG_Table[i] = i | i << 8 | i << 16 | i << 24;
                    VGA.TXT_BG_Table[i] = i | i << 8 | i << 16 | i << 24;
                    VGA.FillTable[i] = ((i & 1) != 0 ? 255 : 0) | ((i & 2) != 0 ? 65280 : 0) | ((i & 4) != 0 ? 0xFF0000 : 0) | ((i & 8) != 0 ? -16777216 : 0);
                    VGA.TXT_Font_Table[i] = ((i & 1) != 0 ? -16777216 : 0) | ((i & 2) != 0 ? 0xFF0000 : 0) | ((i & 4) != 0 ? 65280 : 0) | ((i & 8) != 0 ? 255 : 0);
                }
                for (int j = 0; j < 4; ++j) {
                    for (i = 0; i < 16; ++i) {
                        VGA.Expand16Table[j][i] = ((i & 1) != 0 ? 1 << 24 + j : 0) | ((i & 2) != 0 ? 1 << 16 + j : 0) | ((i & 4) != 0 ? 1 << 8 + j : 0) | ((i & 8) != 0 ? 1 << j : 0);
                    }
                }
            }
        };
    }

    public static class SVGA_Driver {
        public tWritePort write_p3d5;
        public tReadPort read_p3d5;
        public tWritePort write_p3c5;
        public tReadPort read_p3c5;
        public tWritePort write_p3c0;
        public tReadPort read_p3c1;
        public tWritePort write_p3cf;
        public tReadPort read_p3cf;
        public tFinishSetMode set_video_mode;
        public tDetermineMode determine_mode;
        public tSetClock set_clock;
        public tGetClock get_clock;
        public tHWCursorActive hardware_cursor_active;
        public tAcceptsMode accepts_mode;
    }

    public static interface tAcceptsMode {
        public boolean call(int var1);
    }

    public static interface tHWCursorActive {
        public boolean call();
    }

    public static interface tGetClock {
        public int call();
    }

    public static interface tSetClock {
        public void call(int var1, int var2);
    }

    public static interface tDetermineMode {
        public void call();
    }

    public static interface tFinishSetMode {
        public void call(int var1, VGA_ModeExtraData var2);
    }

    public static interface tReadPort {
        public int call(int var1, int var2);
    }

    public static interface tWritePort {
        public void call(int var1, int var2, int var3);
    }

    public static class VGA_ModeExtraData {
        public short ver_overflow;
        public short hor_overflow;
        public int offset;
        public int modeNo;
        public int htotal;
        public int vtotal;
    }

    public static class VGA_Type {
        public int mode;
        short misc_output;
        public VGA_Draw draw = new VGA_Draw();
        public VGA_Config config = new VGA_Config();
        public VGA_Internal internal = new VGA_Internal();
        public VGA_Seq seq = new VGA_Seq();
        public VGA_Attr attr = new VGA_Attr();
        public VGA_Crtc crtc = new VGA_Crtc();
        public VGA_Gfx gfx = new VGA_Gfx();
        public VGA_Dac dac = new VGA_Dac();
        public VGA_Latch latch = new VGA_Latch();
        public VGA_S3 s3 = new VGA_S3();
        public VGA_SVGA svga = new VGA_SVGA();
        public VGA_HERC herc = new VGA_HERC();
        public VGA_TANDY tandy = new VGA_TANDY();
        public VGA_OTHER other = new VGA_OTHER();
        public VGA_Memory mem = new VGA_Memory();
        public int vmemwrap;
        public int fastmem;
        public int fastmem_orgptr;
        public int vmemsize;
        public VGA_Changes changes;
        public VGA_LFB lfb = new VGA_LFB();
    }

    public static class VGA_LFB {
        public int page;
        public int addr;
        public int mask;
        public Paging.PageHandler handler;
    }

    public static class VGA_Changes {
        public Ptr map;
        public short checkMask;
        public short frame;
        public short writeMask;
        public boolean active;
        public int clearMask;
        public int start;
        public int last;
        public int lastAddress;
    }

    public static class VGA_Memory {
        public int linear;
        public int linear_orgptr;
    }

    public static class VGA_Latch {
        public int d;

        public short b(int index) {
            switch (index) {
                case 0: {
                    return (short)(this.d & 0xFF);
                }
                case 1: {
                    return (short)(this.d >> 8 & 0xFF);
                }
                case 2: {
                    return (short)(this.d >> 16 & 0xFF);
                }
                case 3: {
                    return (short)(this.d >> 24 & 0xFF);
                }
            }
            return 0;
        }
    }

    public static class VGA_SVGA {
        public int readStart;
        public int writeStart;
        public int bankMask;
        public int bank_read_full;
        public int bank_write_full;
        public short bank_read;
        public short bank_write;
        public int bank_size;
    }

    public static class VGA_Dac {
        public short bits;
        public short pel_mask;
        public short pel_index;
        public short state;
        public short write_index;
        public short read_index;
        public int first_changed;
        public short[] combine = new short[16];
        public RGBEntry[] rgb = new RGBEntry[256];
        public int[] xlat16 = new int[256];

        public VGA_Dac() {
            for (int i = 0; i < this.rgb.length; ++i) {
                this.rgb[i] = new RGBEntry();
            }
        }
    }

    public static class RGBEntry {
        public short red;
        public short green;
        public short blue;
    }

    public static class VGA_Gfx {
        public short index;
        public short set_reset;
        public short enable_set_reset;
        public short color_compare;
        public short data_rotate;
        public short read_map_select;
        public short mode;
        public short miscellaneous;
        public short color_dont_care;
        public short bit_mask;
    }

    public static class VGA_Crtc {
        public short horizontal_total;
        public short horizontal_display_end;
        public short start_horizontal_blanking;
        public short end_horizontal_blanking;
        public short start_horizontal_retrace;
        public short end_horizontal_retrace;
        public short vertical_total;
        public short overflow;
        public short preset_row_scan;
        public short maximum_scan_line;
        public short cursor_start;
        public short cursor_end;
        public short start_address_high;
        public short start_address_low;
        public short cursor_location_high;
        public short cursor_location_low;
        public short vertical_retrace_start;
        public short vertical_retrace_end;
        public short vertical_display_end;
        public short offset;
        public short underline_location;
        public short start_vertical_blanking;
        public short end_vertical_blanking;
        public short mode_control;
        public short line_compare;
        public short index;
        public boolean read_only;
    }

    public static class VGA_Attr {
        public short[] palette = new short[16];
        public short mode_control;
        public short horizontal_pel_panning;
        public short overscan_color;
        public short color_plane_enable;
        public short color_select;
        public short index;
        public short disabled;
    }

    public static class VGA_Seq {
        public short index;
        public short reset;
        public short clocking_mode;
        public short map_mask;
        public short character_map_select;
        public short memory_mode;
    }

    public static class VGA_TANDY {
        public boolean pcjr_flipflop;
        public short mode_control;
        public short color_select;
        public short disp_bank;
        public short reg_index;
        public short gfx_control;
        public short palette_mask;
        public short extended_ram;
        public short border_color;
        public short line_mask;
        public short line_shift;
        public short draw_bank;
        public short mem_bank;
        public int draw_base;
        public int mem_base;
        public int addr_mask;
    }

    public static class VGA_OTHER {
        public short index;
        public short htotal;
        public short hdend;
        public short hsyncp;
        public short hsyncw;
        public short vtotal;
        public short vdend;
        public short vadjust;
        public short vsyncp;
        public short vsyncw;
        public short max_scanline;
        public int lightpen;
        boolean lightpen_triggered;
        public short cursor_start;
        public short cursor_end;
    }

    public static class VGA_HERC {
        public short mode_control;
        public short enable_bits;
    }

    public static class VGA_S3 {
        public short reg_lock1;
        public short reg_lock2;
        public short reg_31;
        public short reg_35;
        public short reg_36;
        public short reg_3a;
        public short reg_40;
        public short reg_41;
        public short reg_43;
        public short reg_45;
        public short reg_50;
        public short reg_51;
        public short reg_52;
        public short reg_55;
        public short reg_58;
        public short reg_6b;
        public short ex_hor_overflow;
        public short ex_ver_overflow;
        public int la_window;
        public short misc_control_2;
        public short ext_mem_ctrl;
        public int xga_screen_width;
        public int xga_color_mode;
        public CLK[] clk = new CLK[4];
        public CLK mclk = new CLK();
        public PLL pll = new PLL();
        public VGA_HWCURSOR hgc = new VGA_HWCURSOR();

        public VGA_S3() {
            for (int i = 0; i < this.clk.length; ++i) {
                this.clk[i] = new CLK();
            }
        }

        public static class PLL {
            short lock;
            short cmd;
        }

        public static class CLK {
            short r;
            short n;
            short m;
        }
    }

    public static class VGA_HWCURSOR {
        public short curmode;
        public int originx;
        public int originy;
        public short fstackpos;
        public short bstackpos;
        public Ptr forestack = new Ptr(4);
        public Ptr backstack = new Ptr(4);
        public int startaddr;
        public short posx;
        public short posy;
        public short[][] mc = new short[64][64];
    }

    public static class VGA_Draw {
        public boolean resizing;
        public int width;
        public int height;
        public int blocks;
        public int address;
        public int panning;
        public int bytes_skip;
        public int linear_base;
        public int linear_mask;
        public int address_add;
        public int line_length;
        public int address_line_total;
        public int address_line;
        public int lines_total;
        public int vblank_skip;
        public int lines_done;
        public int lines_scaled;
        public int split_line;
        public int parts_total;
        public int parts_lines;
        public int parts_left;
        public int byte_panning_shift;
        public Delay delay = new Delay();
        public int bpp;
        public double aspect_ratio;
        public boolean double_scan;
        public boolean doublewidth;
        public boolean doubleheight;
        public byte[] font = new byte[65536];
        public Ptr[] font_tables = new Ptr[2];
        public boolean blinking;
        public boolean blink;
        public boolean char9dot;
        public Cursor cursor = new Cursor();
        public int mode;
        public boolean vret_triggered;

        public static class Cursor {
            int address;
            short sline;
            short eline;
            short count;
            short delay;
            boolean enabled;
        }

        public static class Delay {
            double framestart;
            double vrstart;
            double vrend;
            double hrstart;
            double hrend;
            double hblkstart;
            double hblkend;
            double vblkstart;
            double vblkend;
            double vdend;
            double vtotal;
            double hdend;
            double htotal;
            double parts;
        }
    }

    static final class Drawmode {
        public static final int PART = 0;
        public static final int LINE = 1;
        public static final int EGALINE = 2;

        Drawmode() {
        }
    }

    public static class VGA_Config {
        public int mh_mask;
        public int display_start;
        public int real_start;
        public boolean retrace;
        public int scan_len;
        public int cursor_start;
        public int line_compare;
        public boolean chained;
        public boolean compatible_chain4;
        public short pel_panning;
        public short hlines_skip;
        public short bytes_skip;
        public short addr_shift;
        public short read_mode;
        public short write_mode;
        public short read_map_select;
        public short color_dont_care;
        public short color_compare;
        public short data_rotate;
        public short raster_op;
        public int full_bit_mask;
        public long full_map_mask;
        public long full_not_map_mask;
        public long full_set_reset;
        public long full_not_enable_set_reset;
        public long full_enable_set_reset;
        public long full_enable_and_set_reset;
    }

    public static class VGA_Internal {
        public boolean attrindex;
    }
}

