/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.gui.Render;
import jdos.hardware.Memory;
import jdos.hardware.Pic;
import jdos.hardware.VGA;
import jdos.hardware.VGA_memory;
import jdos.misc.Log;
import jdos.util.IntPtr;

public class VGA_draw {
    private static final int VGA_PARTS = 4;
    private static VGA_Line_Handler VGA_DrawLine;
    public static final int TEMPLINE_SIZE = 7680;
    public static int TempLine;
    private static VGA_Line_Handler VGA_Draw_1BPP_Line;
    private static VGA_Line_Handler VGA_Draw_2BPP_Line;
    private static VGA_Line_Handler VGA_Draw_2BPPHiRes_Line;
    private static int[] temp;
    private static VGA_Line_Handler VGA_Draw_CGA16_Line;
    private static VGA_Line_Handler VGA_Draw_4BPP_Line;
    private static VGA_Line_Handler VGA_Draw_4BPP_Line_Double;
    private static VGA_Line_Handler VGA_Draw_Linear_Line;
    private static VGA_Line_Handler VGA_Draw_Xlat16_Linear_Line;
    private static VGA_Line_Handler VGA_Draw_VGA_Line_HWMouse;
    private static VGA_Line_Handler VGA_Draw_LIN16_Line_HWMouse;
    private static VGA_Line_Handler VGA_Draw_LIN32_Line_HWMouse;
    private static int[] FontMask;
    private static VGA_Line_Handler VGA_TEXT_Draw_Line;
    private static VGA_Line_Handler VGA_TEXT_Herc_Draw_Line;
    private static VGA_Line_Handler VGA_TEXT_Xlat16_Draw_Line;
    private static Pic.PIC_EventHandler VGA_DrawSingleLine;
    private static Pic.PIC_EventHandler VGA_DrawEGASingleLine;
    private static Pic.PIC_EventHandler VGA_DrawPart;
    private static Pic.PIC_EventHandler VGA_VertInterrupt;
    private static Pic.PIC_EventHandler VGA_Other_VertInterrupt;
    private static Pic.PIC_EventHandler VGA_DisplayStartLatch;
    private static Pic.PIC_EventHandler VGA_PanningLatch;
    private static Pic.PIC_EventHandler VGA_VerticalTimer;
    public static Pic.PIC_EventHandler VGA_SetupDrawing;

    private static int VGA_Text_Memwrap(int vidstart) {
        int line_end = 2 * VGA.vga.draw.blocks;
        if ((vidstart &= VGA.vga.draw.linear_mask) + line_end > VGA.vga.draw.linear_mask) {
            int break_pos = VGA.vga.draw.linear_mask - vidstart + 1;
            int t = TempLine + 3840;
            Memory.host_memcpy(t, VGA.vga.tandy.draw_base + vidstart, break_pos);
            Memory.host_memcpy(t + break_pos, VGA.vga.tandy.draw_base, line_end - break_pos);
            return t;
        }
        return VGA.vga.tandy.draw_base + vidstart;
    }

    private static void VGA_ChangesEnd() {
        if (VGA.vga.changes.active) {
            long end = VGA.vga.draw.address >> 9;
            long total = 4L + end - (long)VGA.vga.changes.start;
            int clearMask = VGA.vga.changes.clearMask;
            total >>= 2;
            IntPtr clear = new IntPtr(VGA.vga.changes.map, VGA.vga.changes.start & 0xFFFFFFFC);
            while (total-- != 0L) {
                clear.setInc(clear.get() & clearMask);
            }
        }
    }

    private static void VGA_ProcessSplit() {
        if ((VGA.vga.attr.mode_control & 0x20) != 0) {
            VGA.vga.draw.address = 0;
            VGA.vga.draw.panning = 0;
        } else {
            VGA.vga.draw.address = VGA.vga.draw.byte_panning_shift * VGA.vga.draw.bytes_skip;
            if (VGA.vga.mode != 9 && Dosbox.machine != 4) {
                VGA.vga.draw.address += VGA.vga.draw.panning;
            }
        }
        VGA.vga.draw.address_line = 0;
    }

    public static void VGA_SetBlinking(int enabled) {
        int b;
        if (enabled != 0) {
            b = 0;
            VGA.vga.draw.blinking = true;
            VGA.vga.attr.mode_control = (short)(VGA.vga.attr.mode_control | 8);
            VGA.vga.tandy.mode_control = (short)(VGA.vga.tandy.mode_control | 0x20);
        } else {
            b = 8;
            VGA.vga.draw.blinking = false;
            VGA.vga.attr.mode_control = (short)(VGA.vga.attr.mode_control & 0xFFFFFFF7);
            VGA.vga.tandy.mode_control = (short)(VGA.vga.tandy.mode_control & 0xFFFFFFDF);
        }
        for (int i = 0; i < 8; ++i) {
            VGA.TXT_BG_Table[i + 8] = b + i | b + i << 8 | b + i << 16 | b + i << 24;
        }
    }

    public static void VGA_CheckScanLength() {
        switch (VGA.vga.mode) {
            case 2: 
            case 4: {
                VGA.vga.draw.address_add = VGA.vga.config.scan_len * 16;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                VGA.vga.draw.address_add = VGA.vga.config.scan_len * 8;
                break;
            }
            case 9: {
                VGA.vga.draw.address_add = VGA.vga.config.scan_len * 4;
                break;
            }
            case 0: 
            case 1: 
            case 12: {
                VGA.vga.draw.address_add = 80;
                return;
            }
            case 13: {
                VGA.vga.draw.address_add = VGA.vga.draw.blocks / 4;
                break;
            }
            case 14: {
                VGA.vga.draw.address_add = VGA.vga.draw.blocks;
                break;
            }
            case 15: {
                VGA.vga.draw.address_add = VGA.vga.draw.blocks;
                break;
            }
            case 16: {
                VGA.vga.draw.address_add = VGA.vga.draw.blocks * 2;
                break;
            }
            case 11: {
                VGA.vga.draw.address_add = VGA.vga.draw.blocks * 2;
                break;
            }
            case 10: {
                VGA.vga.draw.address_add = VGA.vga.draw.blocks;
                break;
            }
            default: {
                VGA.vga.draw.address_add = VGA.vga.draw.blocks * 8;
            }
        }
    }

    public static void VGA_ActivateHardwareCursor() {
        boolean hwcursor_active = false;
        if (VGA.svga.hardware_cursor_active != null && VGA.svga.hardware_cursor_active.call()) {
            hwcursor_active = true;
        }
        if (hwcursor_active) {
            switch (VGA.vga.mode) {
                case 8: {
                    VGA_DrawLine = VGA_Draw_LIN32_Line_HWMouse;
                    break;
                }
                case 6: 
                case 7: {
                    VGA_DrawLine = VGA_Draw_LIN16_Line_HWMouse;
                    break;
                }
                default: {
                    VGA_DrawLine = VGA_Draw_VGA_Line_HWMouse;
                    break;
                }
            }
        } else {
            VGA_DrawLine = VGA_Draw_Linear_Line;
        }
    }

    private static void VGA_KillDrawing() {
        Pic.PIC_RemoveEvents(VGA_DrawPart);
        Pic.PIC_RemoveEvents(VGA_DrawSingleLine);
        Pic.PIC_RemoveEvents(VGA_DrawEGASingleLine);
        VGA.vga.draw.parts_left = 0;
        VGA.vga.draw.lines_done = -1;
        Render.RENDER_EndUpdate(true);
    }

    static /* synthetic */ VGA_Line_Handler access$302(VGA_Line_Handler x0) {
        VGA_DrawLine = x0;
        return VGA_DrawLine;
    }

    static /* synthetic */ VGA_Line_Handler access$1400() {
        return VGA_Draw_Xlat16_Linear_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$1500() {
        return VGA_Draw_Linear_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$1600() {
        return VGA_Draw_CGA16_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$1700() {
        return VGA_Draw_2BPP_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$1800() {
        return VGA_Draw_1BPP_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$1900() {
        return VGA_TEXT_Xlat16_Draw_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$2000() {
        return VGA_TEXT_Draw_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$2100() {
        return VGA_Draw_2BPPHiRes_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$2200() {
        return VGA_Draw_4BPP_Line;
    }

    static /* synthetic */ VGA_Line_Handler access$2300() {
        return VGA_Draw_4BPP_Line_Double;
    }

    static /* synthetic */ VGA_Line_Handler access$2400() {
        return VGA_TEXT_Herc_Draw_Line;
    }

    static /* synthetic */ void access$2500() {
        VGA_draw.VGA_KillDrawing();
    }

    static {
        VGA_Draw_1BPP_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int base = VGA.vga.tandy.draw_base + ((line & VGA.vga.tandy.line_mask) << VGA.vga.tandy.line_shift);
                int draw = TempLine;
                int x = VGA.vga.draw.blocks;
                while (x > 0) {
                    short val = Memory.host_readb(base + (vidstart & 0x1FFF));
                    Memory.host_writed(draw, VGA.CGA_2_Table[val >> 4]);
                    Memory.host_writed(draw += 4, VGA.CGA_2_Table[val & 0xF]);
                    draw += 4;
                    --x;
                    ++vidstart;
                }
                return TempLine;
            }
        };
        VGA_Draw_2BPP_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int base = VGA.vga.tandy.draw_base + ((line & VGA.vga.tandy.line_mask) << VGA.vga.tandy.line_shift);
                int draw = TempLine;
                for (int x = 0; x < VGA.vga.draw.blocks; ++x) {
                    short val = Memory.host_readb(base + (vidstart & VGA.vga.tandy.addr_mask));
                    ++vidstart;
                    Memory.host_writed(draw, VGA.CGA_4_Table[val]);
                    draw += 4;
                }
                return TempLine;
            }
        };
        VGA_Draw_2BPPHiRes_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int base = VGA.vga.tandy.draw_base + ((line & VGA.vga.tandy.line_mask) << VGA.vga.tandy.line_shift);
                int draw = TempLine;
                for (int x = 0; x < VGA.vga.draw.blocks; ++x) {
                    short val1 = Memory.host_readb(base + (vidstart & VGA.vga.tandy.addr_mask));
                    short val2 = Memory.host_readb(base + (++vidstart & VGA.vga.tandy.addr_mask));
                    ++vidstart;
                    Memory.host_writed(draw, VGA.CGA_4_HiRes_Table[val1 >> 4 | val2 & 0xF0]);
                    Memory.host_writed(draw += 4, VGA.CGA_4_HiRes_Table[val1 & 0xF | (val2 & 0xF) << 4]);
                    draw += 4;
                }
                return TempLine;
            }
        };
        temp = new int[643];
        VGA_Draw_CGA16_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int base = VGA.vga.tandy.draw_base + ((line & VGA.vga.tandy.line_mask) << VGA.vga.tandy.line_shift);
                int reader = base + vidstart;
                int draw = TempLine;
                for (int x = 0; x < 640; ++x) {
                    temp[x + 2] = (Memory.host_readb(reader + (x >> 3)) >> 7 - (x & 7) & 1) << 4;
                }
                int i = 0;
                for (int x = 0; x < VGA.vga.draw.blocks; ++x) {
                    int val1 = Memory.host_readb(reader++);
                    int val2 = val1 & 0xF;
                    int temp1 = temp[i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    int temp2 = temp[++i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    int temp3 = temp[++i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    int temp4 = temp[++i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    Memory.host_writed(draw, 0x80808080 | (temp1 | (val1 >>= 4)) | (temp2 | val1) << 8 | (temp3 | val1) << 16 | (temp4 | val1) << 24);
                    draw += 4;
                    temp1 = temp[++i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    temp2 = temp[++i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    temp3 = temp[++i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    temp4 = temp[++i] + temp[i + 1] + temp[i + 2] + temp[i + 3];
                    ++i;
                    Memory.host_writed(draw, 0x80808080 | (temp1 | val2) | (temp2 | val2) << 8 | (temp3 | val2) << 16 | (temp4 | val2) << 24);
                    draw += 4;
                }
                return TempLine;
            }
        };
        VGA_Draw_4BPP_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int base = VGA.vga.tandy.draw_base + ((line & VGA.vga.tandy.line_mask) << VGA.vga.tandy.line_shift);
                int draw = TempLine;
                for (int x = 0; x < VGA.vga.draw.blocks; ++x) {
                    short val1 = Memory.host_readb(base + (vidstart & VGA.vga.tandy.addr_mask));
                    short val2 = Memory.host_readb(base + (++vidstart & VGA.vga.tandy.addr_mask));
                    ++vidstart;
                    Memory.host_writed(draw, (val1 & 0xF) << 8 | (val1 & 0xF0) >> 4 | (val2 & 0xF) << 24 | (val2 & 0xF0) << 12);
                    draw += 4;
                }
                return TempLine;
            }
        };
        VGA_Draw_4BPP_Line_Double = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int base = VGA.vga.tandy.draw_base + ((line & VGA.vga.tandy.line_mask) << VGA.vga.tandy.line_shift);
                int draw = TempLine;
                for (int x = 0; x < VGA.vga.draw.blocks; ++x) {
                    short val = Memory.host_readb(base + (vidstart & VGA.vga.tandy.addr_mask));
                    ++vidstart;
                    Memory.host_writed(draw, (val & 0xF0) >> 4 | (val & 0xF0) << 4 | (val & 0xF) << 16 | (val & 0xF) << 24);
                    draw += 4;
                }
                return TempLine;
            }
        };
        VGA_Draw_Linear_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int offset = vidstart & VGA.vga.draw.linear_mask;
                if (VGA.vga.draw.linear_mask - offset < VGA.vga.draw.line_length) {
                    Memory.host_memcpy(VGA.vga.draw.linear_base + VGA.vga.draw.linear_mask + 1, VGA.vga.draw.linear_base, VGA.vga.draw.line_length);
                }
                return VGA.vga.draw.linear_base + offset;
            }
        };
        VGA_Draw_Xlat16_Linear_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int ret = VGA.vga.draw.linear_base + (vidstart & VGA.vga.draw.linear_mask);
                int temps = TempLine;
                for (int i = 0; i < VGA.vga.draw.line_length; ++i) {
                    Memory.host_writew(temps, VGA.vga.dac.xlat16[Memory.host_readb(ret + i)]);
                    temps += 2;
                }
                return TempLine;
            }
        };
        VGA_Draw_VGA_Line_HWMouse = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                if (VGA.svga.hardware_cursor_active == null || !VGA.svga.hardware_cursor_active.call()) {
                    return VGA.vga.mem.linear + vidstart;
                }
                int lineat = (vidstart - (VGA.vga.config.real_start << 2)) / VGA.vga.draw.width;
                if (VGA.vga.s3.hgc.posx >= VGA.vga.draw.width || lineat < VGA.vga.s3.hgc.originy || lineat > VGA.vga.s3.hgc.originy + (63 - VGA.vga.s3.hgc.posy)) {
                    return VGA.vga.mem.linear + vidstart;
                }
                Memory.host_memcpy(TempLine, VGA.vga.mem.linear + vidstart, VGA.vga.draw.width);
                int sourceStartBit = (lineat - VGA.vga.s3.hgc.originy + VGA.vga.s3.hgc.posy) * 64 + VGA.vga.s3.hgc.posx;
                int cursorMemStart = (sourceStartBit >> 2 & 0xFFFFFFFE) + (VGA.vga.s3.hgc.startaddr << 10);
                int cursorStartBit = sourceStartBit & 7;
                if ((cursorMemStart & 2) != 0) {
                    --cursorMemStart;
                }
                int cursorMemEnd = cursorMemStart + (64 - VGA.vga.s3.hgc.posx >> 2);
                int dst_off = VGA.vga.s3.hgc.originx + TempLine;
                cursorMemEnd += VGA.vga.mem.linear;
                int m = cursorMemStart += VGA.vga.mem.linear;
                while (m < cursorMemEnd) {
                    short bitsA = Memory.host_readb(m);
                    short bitsB = Memory.host_readb(m + 2);
                    for (int bit = 128 >> cursorStartBit; bit != 0; bit >>= 1) {
                        cursorStartBit = 0;
                        if ((bitsA & bit) != 0) {
                            if ((bitsB & bit) != 0) {
                                Memory.host_writebs(dst_off, (byte)(Memory.host_readbs(dst_off) ^ 0xFF));
                                ++dst_off;
                            }
                        } else if ((bitsB & bit) != 0) {
                            Memory.host_writebs(dst_off, VGA.vga.s3.hgc.forestack.p[0]);
                        } else {
                            Memory.host_writebs(dst_off, VGA.vga.s3.hgc.backstack.p[0]);
                        }
                        ++dst_off;
                    }
                    if ((m & 1) != 0) {
                        m += 3;
                        continue;
                    }
                    ++m;
                }
                return TempLine;
            }
        };
        VGA_Draw_LIN16_Line_HWMouse = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                if (VGA.svga.hardware_cursor_active == null || !VGA.svga.hardware_cursor_active.call()) {
                    return VGA.vga.mem.linear + vidstart;
                }
                int lineat = (vidstart - (VGA.vga.config.real_start << 2) >> 1) / VGA.vga.draw.width;
                if (VGA.vga.s3.hgc.posx >= VGA.vga.draw.width || lineat < VGA.vga.s3.hgc.originy || lineat > VGA.vga.s3.hgc.originy + (63 - VGA.vga.s3.hgc.posy)) {
                    return VGA.vga.mem.linear + vidstart;
                }
                Memory.host_memcpy(TempLine, VGA.vga.mem.linear + vidstart, VGA.vga.draw.width * 2);
                int sourceStartBit = (lineat - VGA.vga.s3.hgc.originy + VGA.vga.s3.hgc.posy) * 64 + VGA.vga.s3.hgc.posx;
                int cursorMemStart = (sourceStartBit >> 2 & 0xFFFFFFFE) + (VGA.vga.s3.hgc.startaddr << 10);
                int cursorStartBit = sourceStartBit & 7;
                if ((cursorMemStart & 2) != 0) {
                    --cursorMemStart;
                }
                int cursorMemEnd = cursorMemStart + (64 - VGA.vga.s3.hgc.posx >> 2);
                int xat = TempLine + VGA.vga.s3.hgc.originx * 2;
                int m = cursorMemStart;
                while (m < cursorMemEnd) {
                    short bitsA = Memory.host_readb(VGA.vga.mem.linear + m);
                    short bitsB = Memory.host_readb(VGA.vga.mem.linear + m + 2);
                    for (int bit = 128 >> cursorStartBit; bit != 0; bit >>= 1) {
                        cursorStartBit = 0;
                        if ((bitsA & bit) != 0) {
                            if ((bitsB & bit) != 0) {
                                Memory.host_writew(xat, ~Memory.host_readw(xat));
                            }
                        } else if ((bitsB & bit) != 0) {
                            Memory.host_writew(xat, VGA.vga.s3.hgc.forestack.readw(0));
                        } else {
                            Memory.host_writew(xat, VGA.vga.s3.hgc.backstack.readw(0));
                        }
                        xat += 2;
                    }
                    if ((m & 1) != 0) {
                        m += 3;
                        continue;
                    }
                    ++m;
                }
                return TempLine;
            }
        };
        VGA_Draw_LIN32_Line_HWMouse = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                if (VGA.svga.hardware_cursor_active == null || !VGA.svga.hardware_cursor_active.call()) {
                    return VGA.vga.mem.linear + vidstart;
                }
                int lineat = (vidstart - (VGA.vga.config.real_start << 2) >> 2) / VGA.vga.draw.width;
                if (VGA.vga.s3.hgc.posx >= VGA.vga.draw.width || lineat < VGA.vga.s3.hgc.originy || lineat > VGA.vga.s3.hgc.originy + (63 - VGA.vga.s3.hgc.posy)) {
                    return VGA.vga.mem.linear + vidstart;
                }
                Memory.host_memcpy(TempLine, VGA.vga.mem.linear + vidstart, VGA.vga.draw.width * 4);
                int sourceStartBit = (lineat - VGA.vga.s3.hgc.originy + VGA.vga.s3.hgc.posy) * 64 + VGA.vga.s3.hgc.posx;
                int cursorMemStart = (sourceStartBit >> 2 & 0xFFFFFFFE) + (VGA.vga.s3.hgc.startaddr << 10);
                int cursorStartBit = sourceStartBit & 7;
                if ((cursorMemStart & 2) != 0) {
                    --cursorMemStart;
                }
                int cursorMemEnd = cursorMemStart + (64 - VGA.vga.s3.hgc.posx >> 2);
                int xat = TempLine + VGA.vga.s3.hgc.originx * 4;
                int m = cursorMemStart;
                while (m < cursorMemEnd) {
                    short bitsA = Memory.host_readb(VGA.vga.mem.linear + m);
                    short bitsB = Memory.host_readb(VGA.vga.mem.linear + m + 2);
                    for (int bit = 128 >> cursorStartBit; bit != 0; bit >>= 1) {
                        cursorStartBit = 0;
                        if ((bitsA & bit) != 0) {
                            if ((bitsB & bit) != 0) {
                                Memory.host_writed(xat, ~Memory.host_readd(xat));
                            }
                        } else if ((bitsB & bit) != 0) {
                            Memory.host_writed(xat, VGA.vga.s3.hgc.forestack.readd(0));
                        } else {
                            Memory.host_writed(xat, VGA.vga.s3.hgc.backstack.readd(0));
                        }
                        xat += 4;
                    }
                    if ((m & 1) != 0) {
                        m += 3;
                        continue;
                    }
                    ++m;
                }
                return TempLine;
            }
        };
        FontMask = new int[]{-1, 0};
        VGA_TEXT_Draw_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int font_addr;
                int draw = TempLine;
                int vidmem = VGA_draw.VGA_Text_Memwrap(vidstart);
                for (int cx = 0; cx < VGA.vga.draw.blocks; ++cx) {
                    short chr = Memory.host_readb(vidmem + cx * 2);
                    short col = Memory.host_readb(vidmem + cx * 2 + 1);
                    int font = VGA.vga.draw.font_tables[col >> 3 & 1].get(chr * 32 + line);
                    int mask1 = VGA.TXT_Font_Table[font >> 4] & FontMask[col >> 7];
                    int mask2 = VGA.TXT_Font_Table[font & 0xF] & FontMask[col >> 7];
                    int fg = VGA.TXT_FG_Table[col & 0xF];
                    int bg = VGA.TXT_BG_Table[col >> 4];
                    Memory.host_writed(draw, fg & mask1 | bg & ~mask1);
                    Memory.host_writed(draw += 4, fg & mask2 | bg & ~mask2);
                    draw += 4;
                }
                if (VGA.vga.draw.cursor.enabled && (VGA.vga.draw.cursor.count & 8) != 0 && (font_addr = VGA.vga.draw.cursor.address - vidstart >> 1) >= 0 && font_addr < VGA.vga.draw.blocks && line >= VGA.vga.draw.cursor.sline && line <= VGA.vga.draw.cursor.eline) {
                    draw = TempLine + font_addr * 8;
                    int att = VGA.TXT_FG_Table[Memory.host_readb(VGA.vga.tandy.draw_base + VGA.vga.draw.cursor.address + 1) & 0xF];
                    Memory.host_writed(draw, att);
                    Memory.host_writed(draw += 4, att);
                    draw += 4;
                }
                return TempLine;
            }
        };
        VGA_TEXT_Herc_Draw_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int font_addr;
                int draw = TempLine;
                int vidmem = VGA_draw.VGA_Text_Memwrap(vidstart);
                for (int cx = 0; cx < VGA.vga.draw.blocks; ++cx) {
                    int mask1;
                    int mask2;
                    int fg;
                    int bg;
                    short chr = Memory.host_readb(vidmem + cx * 2);
                    short attrib = Memory.host_readb(vidmem + cx * 2 + 1);
                    if ((attrib & 0x77) == 0) {
                        Memory.host_writed(draw, 0);
                        Memory.host_writed(draw += 4, 0);
                        draw += 4;
                        continue;
                    }
                    boolean underline = false;
                    if ((attrib & 0x77) == 112) {
                        bg = VGA.TXT_BG_Table[7];
                        fg = (attrib & 8) != 0 ? VGA.TXT_FG_Table[15] : VGA.TXT_FG_Table[0];
                    } else {
                        if ((VGA.vga.crtc.underline_location & 0x1F) == line && (attrib & 0x77) == 1) {
                            underline = true;
                        }
                        bg = VGA.TXT_BG_Table[0];
                        fg = (attrib & 8) != 0 ? VGA.TXT_FG_Table[15] : VGA.TXT_FG_Table[7];
                    }
                    if (underline) {
                        mask1 = mask2 = FontMask[attrib >> 7];
                    } else {
                        int font = VGA.vga.draw.font_tables[0].get(chr * 32 + line);
                        mask1 = VGA.TXT_Font_Table[font >> 4] & FontMask[attrib >> 7];
                        mask2 = VGA.TXT_Font_Table[font & 0xF] & FontMask[attrib >> 7];
                    }
                    Memory.host_writed(draw, fg & mask1 | bg & ~mask1);
                    Memory.host_writed(draw += 4, fg & mask2 | bg & ~mask2);
                    draw += 4;
                }
                if (VGA.vga.draw.cursor.enabled && (VGA.vga.draw.cursor.count & 8) == 0 && (font_addr = VGA.vga.draw.cursor.address - vidstart >> 1) >= 0 && font_addr < VGA.vga.draw.blocks && line >= VGA.vga.draw.cursor.sline && line <= VGA.vga.draw.cursor.eline) {
                    draw = TempLine + font_addr * 8;
                    short attr = Memory.host_readb(VGA.vga.tandy.draw_base + VGA.vga.draw.cursor.address + 1);
                    int cg = (attr & 8) != 0 ? VGA.TXT_FG_Table[15] : ((attr & 0x77) == 112 ? VGA.TXT_FG_Table[0] : VGA.TXT_FG_Table[7]);
                    Memory.host_writed(draw, cg);
                    Memory.host_writed(draw += 4, cg);
                    draw += 4;
                }
                return TempLine;
            }
        };
        VGA_TEXT_Xlat16_Draw_Line = new VGA_Line_Handler(){

            public int call(int vidstart, int line) {
                int attr_addr;
                int draw = TempLine + 16 - VGA.vga.draw.panning;
                int vidmem = VGA_draw.VGA_Text_Memwrap(vidstart);
                int blocks = VGA.vga.draw.blocks;
                if (VGA.vga.draw.panning != 0) {
                    ++blocks;
                }
                for (int cx = 0; cx < blocks; ++cx) {
                    int n;
                    int foreground;
                    short chr = Memory.host_readb(vidmem + cx * 2);
                    short attr = Memory.host_readb(vidmem + cx * 2 + 1);
                    int font = VGA.vga.draw.font_tables[attr >> 3 & 1].get(chr * 32 + line);
                    int background = attr >> 4;
                    if (VGA.vga.draw.blinking) {
                        background &= 0xFFFFFFF7;
                    }
                    int n2 = foreground = VGA.vga.draw.blink || (attr & 0x80) == 0 ? attr & 0xF : background;
                    if ((attr & 0x77) == 1 && (VGA.vga.crtc.underline_location & 0x1F) == line) {
                        background = foreground;
                    }
                    if (VGA.vga.draw.char9dot) {
                        if (((font <<= 1) & 2) != 0 && (VGA.vga.attr.mode_control & 4) != 0 && chr >= 192 && chr <= 223) {
                            font |= 1;
                        }
                        for (n = 0; n < 9; ++n) {
                            Memory.host_writew(draw, VGA.vga.dac.xlat16[(font & 0x100) != 0 ? foreground : background]);
                            draw += 2;
                            font <<= 1;
                        }
                        continue;
                    }
                    for (n = 0; n < 8; ++n) {
                        Memory.host_writew(draw, VGA.vga.dac.xlat16[(font & 0x80) != 0 ? foreground : background]);
                        draw += 2;
                        font <<= 1;
                    }
                }
                if ((VGA.vga.draw.cursor.count & 8) != 0 && line >= VGA.vga.draw.cursor.sline && line <= VGA.vga.draw.cursor.eline && VGA.vga.draw.cursor.enabled && (attr_addr = VGA.vga.draw.cursor.address - vidstart >> 1) >= 0 && attr_addr < VGA.vga.draw.blocks) {
                    int index = attr_addr * (VGA.vga.draw.char9dot ? 18 : 16);
                    draw = TempLine + index * 2 + 16 - VGA.vga.draw.panning;
                    int foreground = Memory.host_readb(VGA.vga.tandy.draw_base + VGA.vga.draw.cursor.address + 1) & 0xF;
                    for (int i = 0; i < 8; ++i) {
                        Memory.host_writew(draw, VGA.vga.dac.xlat16[foreground]);
                        draw += 2;
                    }
                }
                return TempLine + 32;
            }
        };
        VGA_DrawSingleLine = new Pic.PIC_EventHandler(){

            public void call(int val) {
                if (VGA.vga.attr.disabled != 0) {
                    Memory.host_zeroset(TempLine, 7680);
                    Memory.host_memcpy(Render.render.src.outWrite, Render.render.src.outWriteOff, TempLine, Render.render.src.outPitch);
                } else {
                    int data = VGA_DrawLine.call(VGA.vga.draw.address, VGA.vga.draw.address_line);
                    Memory.host_memcpy(Render.render.src.outWrite, Render.render.src.outWriteOff, data, Render.render.src.outPitch);
                }
                Render.render.src.outWriteOff += Render.render.src.outPitch;
                ++VGA.vga.draw.address_line;
                if (VGA.vga.draw.address_line >= VGA.vga.draw.address_line_total) {
                    VGA.vga.draw.address_line = 0;
                    VGA.vga.draw.address += VGA.vga.draw.address_add;
                }
                ++VGA.vga.draw.lines_done;
                if (VGA.vga.draw.split_line == VGA.vga.draw.lines_done) {
                    VGA_draw.VGA_ProcessSplit();
                }
                if (VGA.vga.draw.lines_done < VGA.vga.draw.lines_total) {
                    Pic.PIC_AddEvent(VGA_DrawSingleLine, (float)VGA.vga.draw.delay.htotal);
                } else {
                    Render.RENDER_EndUpdate(false);
                }
            }

            public String toString() {
                return "VGA_DrawSingleLine";
            }
        };
        VGA_DrawEGASingleLine = new Pic.PIC_EventHandler(){

            public void call(int val) {
                if (VGA.vga.attr.disabled != 0) {
                    Memory.host_zeroset(TempLine, 7680);
                    Memory.host_memcpy(Render.render.src.outWrite, Render.render.src.outWriteOff, TempLine, Render.render.src.outPitch);
                } else {
                    int address = VGA.vga.draw.address;
                    if (VGA.vga.mode != 9) {
                        address += VGA.vga.draw.panning;
                    }
                    int data = VGA_DrawLine.call(address, VGA.vga.draw.address_line);
                    Memory.host_memcpy(Render.render.src.outWrite, Render.render.src.outWriteOff, data, Render.render.src.outPitch);
                }
                Render.render.src.outWriteOff += Render.render.src.outPitch;
                ++VGA.vga.draw.address_line;
                if (VGA.vga.draw.address_line >= VGA.vga.draw.address_line_total) {
                    VGA.vga.draw.address_line = 0;
                    VGA.vga.draw.address += VGA.vga.draw.address_add;
                }
                ++VGA.vga.draw.lines_done;
                if (VGA.vga.draw.split_line == VGA.vga.draw.lines_done) {
                    VGA_draw.VGA_ProcessSplit();
                }
                if (VGA.vga.draw.lines_done < VGA.vga.draw.lines_total) {
                    Pic.PIC_AddEvent(VGA_DrawEGASingleLine, (float)VGA.vga.draw.delay.htotal);
                } else {
                    Render.RENDER_EndUpdate(false);
                }
            }

            public String toString() {
                return "VGA_DrawEGASingleLine";
            }
        };
        VGA_DrawPart = new Pic.PIC_EventHandler(){

            public void call(int val) {
                while (val-- != 0) {
                    int data = VGA_DrawLine.call(VGA.vga.draw.address, VGA.vga.draw.address_line);
                    Memory.host_memcpy(Render.render.src.outWrite, Render.render.src.outWriteOff, data, Render.render.src.outPitch);
                    Render.render.src.outWriteOff += Render.render.src.outPitch;
                    ++VGA.vga.draw.address_line;
                    if (VGA.vga.draw.address_line >= VGA.vga.draw.address_line_total) {
                        VGA.vga.draw.address_line = 0;
                        VGA.vga.draw.address += VGA.vga.draw.address_add;
                    }
                    ++VGA.vga.draw.lines_done;
                    if (VGA.vga.draw.split_line != VGA.vga.draw.lines_done) continue;
                    if (VGA_memory.VGA_KEEP_CHANGES) {
                        VGA_draw.VGA_ChangesEnd();
                    }
                    VGA_draw.VGA_ProcessSplit();
                    if (!VGA_memory.VGA_KEEP_CHANGES) continue;
                    VGA.vga.changes.start = VGA.vga.draw.address >> 9;
                }
                if (--VGA.vga.draw.parts_left != 0) {
                    Pic.PIC_AddEvent(VGA_DrawPart, (float)VGA.vga.draw.delay.parts, VGA.vga.draw.parts_left != 1 ? VGA.vga.draw.parts_lines : VGA.vga.draw.lines_total - VGA.vga.draw.lines_done);
                } else {
                    if (VGA_memory.VGA_KEEP_CHANGES) {
                        VGA_draw.VGA_ChangesEnd();
                    }
                    Render.RENDER_EndUpdate(false);
                }
            }

            public String toString() {
                return "VGA_DrawPart";
            }
        };
        VGA_VertInterrupt = new Pic.PIC_EventHandler(){

            public void call(int val) {
                if (!VGA.vga.draw.vret_triggered && (VGA.vga.crtc.vertical_retrace_end & 0x30) == 16) {
                    VGA.vga.draw.vret_triggered = true;
                    if (Dosbox.machine == 4) {
                        Pic.PIC_ActivateIRQ(9);
                    }
                }
            }

            public String toString() {
                return "VGA_VertInterrupt";
            }
        };
        VGA_Other_VertInterrupt = new Pic.PIC_EventHandler(){

            public void call(int val) {
                if (val != 0) {
                    Pic.PIC_ActivateIRQ(5);
                } else {
                    Pic.PIC_DeActivateIRQ(5);
                }
            }

            public String toString() {
                return "VGA_Other_VertInterrupt";
            }
        };
        VGA_DisplayStartLatch = new Pic.PIC_EventHandler(){

            public void call(int val) {
                VGA.vga.config.real_start = VGA.vga.config.display_start & VGA.vga.vmemwrap - 1;
                VGA.vga.draw.bytes_skip = VGA.vga.config.bytes_skip;
            }

            public String toString() {
                return "VGA_DisplayStartLatch";
            }
        };
        VGA_PanningLatch = new Pic.PIC_EventHandler(){

            public void call(int val) {
                VGA.vga.draw.panning = VGA.vga.config.pel_panning;
            }

            public String toString() {
                return "VGA_PanningLatch";
            }
        };
        VGA_VerticalTimer = new Pic.PIC_EventHandler(){

            public String toString() {
                return "VGA_VerticalTimer";
            }

            public void call(int val) {
                VGA.vga.draw.delay.framestart = Pic.PIC_FullIndex();
                Pic.PIC_AddEvent(VGA_VerticalTimer, (float)VGA.vga.draw.delay.vtotal);
                switch (Dosbox.machine) {
                    case 2: 
                    case 3: {
                        Pic.PIC_AddEvent(VGA_Other_VertInterrupt, (float)VGA.vga.draw.delay.vrstart, 1);
                        Pic.PIC_AddEvent(VGA_Other_VertInterrupt, (float)VGA.vga.draw.delay.vrend, 0);
                    }
                    case 0: 
                    case 1: {
                        VGA_DisplayStartLatch.call(0);
                        break;
                    }
                    case 5: {
                        Pic.PIC_AddEvent(VGA_DisplayStartLatch, (float)VGA.vga.draw.delay.vrstart);
                        Pic.PIC_AddEvent(VGA_PanningLatch, (float)VGA.vga.draw.delay.vrend);
                        Pic.PIC_AddEvent(VGA_VertInterrupt, (float)(VGA.vga.draw.delay.vdend + 0.005));
                        break;
                    }
                    case 4: {
                        Pic.PIC_AddEvent(VGA_DisplayStartLatch, (float)VGA.vga.draw.delay.vrend);
                        Pic.PIC_AddEvent(VGA_VertInterrupt, (float)(VGA.vga.draw.delay.vdend + 0.005));
                        break;
                    }
                    default: {
                        Log.exit("This new machine needs implementation in VGA_VerticalTimer too.");
                    }
                }
                if (!Render.RENDER_StartUpdate()) {
                    return;
                }
                VGA.vga.draw.address_line = VGA.vga.config.hlines_skip;
                if (Dosbox.IS_EGAVGA_ARCH()) {
                    VGA.vga.draw.split_line = (VGA.vga.config.line_compare + 1) / VGA.vga.draw.lines_scaled;
                    if (Dosbox.svgaCard == 1 && VGA.vga.config.line_compare == 0) {
                        VGA.vga.draw.split_line = 0;
                    }
                    VGA.vga.draw.split_line -= VGA.vga.draw.vblank_skip;
                } else {
                    VGA.vga.draw.split_line = 65536;
                }
                VGA.vga.draw.address = VGA.vga.config.real_start;
                VGA.vga.draw.byte_panning_shift = 0;
                if (Dosbox.machine == 4) {
                    if (VGA.vga.draw.doubleheight) {
                        VGA.vga.draw.split_line *= 2;
                    }
                    ++VGA.vga.draw.split_line;
                }
                boolean startaddr_changed = false;
                switch (VGA.vga.mode) {
                    case 2: {
                        VGA.vga.draw.linear_mask = (VGA.vga.crtc.mode_control & 1) == 0 ? (VGA.vga.draw.linear_mask &= 0xFFFEFFFF) : (VGA.vga.draw.linear_mask |= 0x10000);
                    }
                    case 4: {
                        VGA.vga.draw.byte_panning_shift = 8;
                        VGA.vga.draw.address += VGA.vga.draw.bytes_skip;
                        VGA.vga.draw.address *= VGA.vga.draw.byte_panning_shift;
                        if (Dosbox.machine != 4) {
                            VGA.vga.draw.address += VGA.vga.draw.panning;
                        }
                        startaddr_changed = true;
                        break;
                    }
                    case 3: {
                        if (VGA.vga.config.compatible_chain4 && (VGA.vga.crtc.underline_location & 0x40) != 0) {
                            VGA.vga.draw.linear_base = VGA.vga.fastmem;
                            VGA.vga.draw.linear_mask = 65535;
                        } else {
                            VGA.vga.draw.linear_base = VGA.vga.mem.linear;
                            VGA.vga.draw.linear_mask = VGA.vga.vmemwrap - 1;
                        }
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        VGA.vga.draw.byte_panning_shift = 4;
                        VGA.vga.draw.address += VGA.vga.draw.bytes_skip;
                        VGA.vga.draw.address *= VGA.vga.draw.byte_panning_shift;
                        VGA.vga.draw.address += VGA.vga.draw.panning;
                        startaddr_changed = true;
                        break;
                    }
                    case 9: {
                        VGA.vga.draw.byte_panning_shift = 2;
                        VGA.vga.draw.address += VGA.vga.draw.bytes_skip;
                    }
                    case 11: 
                    case 16: {
                        VGA.vga.draw.linear_mask = Dosbox.machine == 0 ? 4095 : (Dosbox.IS_EGAVGA_ARCH() ? Short.MAX_VALUE : 16383);
                        VGA.vga.draw.cursor.address = VGA.vga.config.cursor_start * 2;
                        VGA.vga.draw.address *= 2;
                        VGA.vga.draw.cursor.count = (short)(VGA.vga.draw.cursor.count + 1);
                        FontMask[1] = VGA.vga.draw.blinking & VGA.vga.draw.cursor.count >>> 4 != 0 ? 0 : -1;
                        VGA.vga.draw.blink = VGA.vga.draw.blinking & VGA.vga.draw.cursor.count >> 4 != 0 || !VGA.vga.draw.blinking;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 0: 
                    case 1: {
                        VGA.vga.draw.address = VGA.vga.draw.address * 2 & 0x1FFF;
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        VGA.vga.draw.address *= 2;
                        break;
                    }
                }
                if (VGA.vga.draw.split_line == 0) {
                    VGA_draw.VGA_ProcessSplit();
                }
                float draw_skip = 0.0f;
                if (VGA.vga.draw.vblank_skip != 0) {
                    draw_skip = (float)(VGA.vga.draw.delay.htotal * (double)VGA.vga.draw.vblank_skip);
                    VGA.vga.draw.address += VGA.vga.draw.address_add * (VGA.vga.draw.vblank_skip / VGA.vga.draw.address_line_total);
                }
                switch (VGA.vga.draw.mode) {
                    case 0: {
                        if (VGA.vga.draw.parts_left != 0) {
                            Pic.PIC_RemoveEvents(VGA_DrawPart);
                            Render.RENDER_EndUpdate(true);
                        }
                        VGA.vga.draw.lines_done = 0;
                        VGA.vga.draw.parts_left = VGA.vga.draw.parts_total;
                        Pic.PIC_AddEvent(VGA_DrawPart, (float)VGA.vga.draw.delay.parts + draw_skip, VGA.vga.draw.parts_lines);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (VGA.vga.draw.lines_done < VGA.vga.draw.lines_total) {
                            if (VGA.vga.draw.mode == 2) {
                                Pic.PIC_RemoveEvents(VGA_DrawEGASingleLine);
                            } else {
                                Pic.PIC_RemoveEvents(VGA_DrawSingleLine);
                            }
                            Render.RENDER_EndUpdate(true);
                        }
                        VGA.vga.draw.lines_done = 0;
                        if (VGA.vga.draw.mode == 2) {
                            Pic.PIC_AddEvent(VGA_DrawEGASingleLine, (float)(VGA.vga.draw.delay.htotal / 4.0 + (double)draw_skip));
                            break;
                        }
                        Pic.PIC_AddEvent(VGA_DrawSingleLine, (float)(VGA.vga.draw.delay.htotal / 4.0 + (double)draw_skip));
                    }
                }
            }
        };
        VGA_SetupDrawing = new Pic.PIC_EventHandler(){

            public String toString() {
                return "VGA_SetupDrawing";
            }

            /*
             * Unable to fully structure code
             */
            public void call(int val) {
                if (VGA.vga.mode == 17) {
                    Pic.PIC_RemoveEvents(VGA_draw.access$900());
                    Pic.PIC_RemoveEvents(VGA_draw.access$1200());
                    Pic.PIC_RemoveEvents(VGA_draw.access$1100());
                    return;
                }
                switch (Dosbox.machine) {
                    case 1: 
                    case 3: {
                        VGA.vga.draw.mode = 1;
                        break;
                    }
                    case 4: {
                        VGA.vga.draw.mode = 2;
                        break;
                    }
                    case 5: {
                        if (Dosbox.svgaCard == 0) {
                            VGA.vga.draw.mode = 1;
                            break;
                        }
                    }
                    default: {
                        VGA.vga.draw.mode = 0;
                    }
                }
                if (Dosbox.IS_EGAVGA_ARCH()) {
                    htotal = VGA.vga.crtc.horizontal_total;
                    hdend = VGA.vga.crtc.horizontal_display_end;
                    hbend = VGA.vga.crtc.end_horizontal_blanking & 31;
                    hbstart = VGA.vga.crtc.start_horizontal_blanking;
                    hrstart = VGA.vga.crtc.start_horizontal_retrace;
                    vtotal = VGA.vga.crtc.vertical_total | (VGA.vga.crtc.overflow & 1) << 8;
                    vdend = VGA.vga.crtc.vertical_display_end | (VGA.vga.crtc.overflow & 2) << 7;
                    vbstart = VGA.vga.crtc.start_vertical_blanking | (VGA.vga.crtc.overflow & 8) << 5;
                    vrstart = VGA.vga.crtc.vertical_retrace_start + ((VGA.vga.crtc.overflow & 4) << 6);
                    if (Dosbox.IS_VGA_ARCH()) {
                        htotal |= (VGA.vga.s3.ex_hor_overflow & 1) << 8;
                        htotal += 3;
                        hdend |= (VGA.vga.s3.ex_hor_overflow & 2) << 7;
                        hbend |= (VGA.vga.crtc.end_horizontal_retrace & 128) >> 2;
                        hbstart |= (VGA.vga.s3.ex_hor_overflow & 4) << 6;
                        hrstart |= (VGA.vga.s3.ex_hor_overflow & 16) << 4;
                        vtotal |= (VGA.vga.crtc.overflow & 32) << 4;
                        vtotal |= (VGA.vga.s3.ex_ver_overflow & 1) << 10;
                        vdend |= (VGA.vga.crtc.overflow & 64) << 3;
                        vdend |= (VGA.vga.s3.ex_ver_overflow & 2) << 9;
                        vbstart |= (VGA.vga.crtc.maximum_scan_line & 32) << 4;
                        vbstart |= (VGA.vga.s3.ex_ver_overflow & 4) << 8;
                        vrstart |= (VGA.vga.crtc.overflow & 128) << 2;
                        vrstart |= (VGA.vga.s3.ex_ver_overflow & 16) << 6;
                        vbend = VGA.vga.crtc.end_vertical_blanking & 127;
                    } else {
                        vbend = VGA.vga.crtc.end_vertical_blanking & 31;
                    }
                    htotal += 2;
                    vtotal += 2;
                    ++hdend;
                    ++vdend;
                    ++vbstart;
                    hbend = hbstart + (hbend - hbstart & 63);
                    hrend = VGA.vga.crtc.end_horizontal_retrace & 31;
                    hrend = hrend - hrstart & 31;
                    hrend = hrend == 0 ? hrstart + 31 + 1 : hrstart + hrend;
                    vrend = VGA.vga.crtc.vertical_retrace_end & 15;
                    vrend = vrend - vrstart & 15;
                    vrend = vrend == 0 ? vrstart + 15 + 1 : vrstart + vrend;
                    vbend = vbend - vbstart & 127;
                    vbend = vbend == 0 ? vbstart + 127 + 1 : vbstart + vbend;
                    ++vbend;
                    if (VGA.svga.get_clock != null) {
                        clock = VGA.svga.get_clock.call();
                    } else {
                        switch (VGA.vga.misc_output >> 2 & 3) {
                            case 0: {
                                clock = Dosbox.machine == 4 ? 14318180 : 25175000;
                                break;
                            }
                            default: {
                                v0 = clock = Dosbox.machine == 4 ? 16257000 : 28322000;
                            }
                        }
                    }
                    clock = (VGA.vga.seq.clocking_mode & 1) != 0 ? (clock /= 8) : (clock /= 9);
                    if ((VGA.vga.seq.clocking_mode & 8) != 0) {
                        htotal *= 2;
                    }
                    VGA.vga.draw.address_line_total = (VGA.vga.crtc.maximum_scan_line & 31) + 1;
                    if (Dosbox.IS_VGA_ARCH() && Dosbox.svgaCard == 0 && (VGA.vga.mode == 2 || VGA.vga.mode == 3)) {
                        if ((VGA.vga.crtc.maximum_scan_line & 128) != 0) {
                            VGA.vga.draw.address_line_total *= 2;
                        }
                        VGA.vga.draw.double_scan = false;
                    } else {
                        VGA.vga.draw.double_scan = Dosbox.IS_VGA_ARCH() ? (VGA.vga.crtc.maximum_scan_line & 128) > 0 : vtotal == 262;
                    }
                } else {
                    htotal = VGA.vga.other.htotal + 1;
                    hbstart = hdend = VGA.vga.other.hdend;
                    hbend = htotal;
                    hrstart = VGA.vga.other.hsyncp;
                    hrend = hrstart + VGA.vga.other.hsyncw;
                    VGA.vga.draw.address_line_total = VGA.vga.other.max_scanline + 1;
                    vtotal = VGA.vga.draw.address_line_total * (VGA.vga.other.vtotal + 1) + VGA.vga.other.vadjust;
                    vdend = VGA.vga.draw.address_line_total * VGA.vga.other.vdend;
                    vrstart = VGA.vga.draw.address_line_total * VGA.vga.other.vsyncp;
                    vrend = vrstart + 16;
                    vbstart = vdend;
                    vbend = vtotal;
                    VGA.vga.draw.double_scan = false;
                    switch (Dosbox.machine) {
                        case 1: 
                        case 2: 
                        case 3: {
                            clock = ((VGA.vga.tandy.mode_control & 1) != 0 ? 14318180 : 7159090) / 8;
                            break;
                        }
                        case 0: {
                            if ((VGA.vga.herc.mode_control & 2) != 0) {
                                clock = 1000000;
                                break;
                            }
                            clock = 2000000;
                            break;
                        }
                        default: {
                            clock = 14318180;
                        }
                    }
                    VGA.vga.draw.delay.hdend = (double)hdend * 1000.0 / (double)clock;
                }
                if (htotal == 0) {
                    return;
                }
                if (vtotal == 0) {
                    return;
                }
                fps = (double)clock / (double)(vtotal * htotal);
                VGA.vga.draw.delay.htotal = (double)htotal * 1000.0 / (double)clock;
                VGA.vga.draw.delay.hblkstart = (double)hbstart * 1000.0 / (double)clock;
                VGA.vga.draw.delay.hblkend = (double)hbend * 1000.0 / (double)clock;
                VGA.vga.draw.delay.hrstart = (double)hrstart * 1000.0 / (double)clock;
                VGA.vga.draw.delay.hrend = (double)hrend * 1000.0 / (double)clock;
                VGA.vga.draw.delay.vblkstart = (double)vbstart * VGA.vga.draw.delay.htotal;
                VGA.vga.draw.delay.vblkend = (double)vbend * VGA.vga.draw.delay.htotal;
                VGA.vga.draw.delay.vrstart = (double)vrstart * VGA.vga.draw.delay.htotal;
                VGA.vga.draw.delay.vrend = (double)vrend * VGA.vga.draw.delay.htotal;
                vblank_skip = 0;
                if (Dosbox.IS_VGA_ARCH() && vbstart < vtotal) {
                    if (vbend > vtotal) {
                        vblank_skip = vbend & 127;
                        if ((vbend & 127) == 1) {
                            vblank_skip = 0;
                        }
                        if (vbstart < vdend) {
                            vdend = vbstart;
                        }
                        Log.log(1, 1, "Blanking wrap to line " + vblank_skip);
                    } else if (vbstart == 1) {
                        vblank_skip = vbend;
                        Log.log(1, 1, "Upper " + vblank_skip + " lines of the screen blanked");
                    } else if (vbstart < vdend) {
                        if (vbend < vdend) {
                            Log.log(1, 1, "Unsupported blanking: line " + vbstart + "-" + vbend);
                        } else {
                            vdend = vbstart;
                        }
                    }
                    vdend -= vblank_skip;
                }
                VGA.vga.draw.delay.vdend = (double)vdend * VGA.vga.draw.delay.htotal;
                VGA.vga.draw.parts_total = 4;
                pwidth = Dosbox.machine == 4 ? 114.0 / (double)htotal : 100.0 / (double)htotal;
                target_total = Dosbox.machine == 4 ? 262.0 : 449.0;
                sync = VGA.vga.misc_output >> 6;
                switch (sync) {
                    case 0: {
                        pheight = 1.411764705882353 * (target_total / (double)vtotal);
                        break;
                    }
                    case 1: {
                        pheight = 1.2 * (target_total / (double)vtotal);
                        break;
                    }
                    case 2: {
                        pheight = 1.3714285714285714 * (target_total / (double)vtotal);
                        break;
                    }
                    default: {
                        pheight = 1.0 * (525.0 / (double)vtotal);
                    }
                }
                aspect_ratio = pheight / pwidth;
                VGA.vga.draw.delay.parts = VGA.vga.draw.delay.vdend / (double)VGA.vga.draw.parts_total;
                VGA.vga.draw.resizing = false;
                VGA.vga.draw.vret_triggered = false;
                if (hbstart < hdend) {
                    hdend = hbstart;
                }
                if (!Dosbox.IS_VGA_ARCH() && vbstart < vdend) {
                    vdend = vbstart;
                }
                width = hdend;
                height = vdend;
                doubleheight = false;
                doublewidth = false;
                switch (VGA.vga.mode) {
                    case 6: {
                        bpp = 15;
                        break;
                    }
                    case 7: {
                        bpp = 16;
                        break;
                    }
                    case 8: {
                        bpp = 32;
                        break;
                    }
                    default: {
                        bpp = 8;
                    }
                }
                VGA.vga.draw.linear_base = VGA.vga.mem.linear;
                VGA.vga.draw.linear_mask = VGA.vga.vmemwrap - 1;
                switch (VGA.vga.mode) {
                    case 3: {
                        doublewidth = true;
                        width <<= 2;
                        if (Dosbox.IS_VGA_ARCH() && Dosbox.svgaCard == 0) {
                            bpp = 16;
                            VGA_draw.access$302(VGA_draw.access$1400());
                            break;
                        }
                        VGA_draw.access$302(VGA_draw.access$1500());
                        break;
                    }
                    case 5: {
                        if ((VGA.vga.crtc.mode_control & 8) == 0) ** GOTO lbl201
                        width >>= 1;
                        ** GOTO lbl204
lbl201:
                        // 1 sources

                        if (Dosbox.svgaCard == 1 && (VGA.vga.s3.reg_3a & 16) == 0) {
                            doublewidth = true;
                            width >>= 1;
                        }
                    }
lbl204:
                    // 5 sources

                    case 8: {
                        width <<= 3;
                        if ((VGA.vga.crtc.mode_control & 8) != 0) {
                            doublewidth = true;
                        }
                        VGA_draw.VGA_ActivateHardwareCursor();
                        break;
                    }
                    case 6: 
                    case 7: {
                        width <<= 2;
                        if ((VGA.vga.crtc.mode_control & 8) != 0 || Dosbox.svgaCard == 1 && (VGA.vga.s3.pll.cmd & 16) != 0) {
                            doublewidth = true;
                        }
                        VGA_draw.VGA_ActivateHardwareCursor();
                        break;
                    }
                    case 4: {
                        doublewidth = (VGA.vga.seq.clocking_mode & 8) > 0;
                        VGA.vga.draw.blocks = width;
                        width <<= 3;
                        VGA_draw.access$302(VGA_draw.access$1500());
                        VGA.vga.draw.linear_base = VGA.vga.fastmem;
                        VGA.vga.draw.linear_mask = (VGA.vga.vmemwrap << 1) - 1;
                        break;
                    }
                    case 2: {
                        doublewidth = (VGA.vga.seq.clocking_mode & 8) > 0;
                        VGA.vga.draw.blocks = width;
                        width <<= 3;
                        if (Dosbox.IS_VGA_ARCH() && Dosbox.svgaCard == 0) {
                            bpp = 16;
                            VGA_draw.access$302(VGA_draw.access$1400());
                        } else {
                            VGA_draw.access$302(VGA_draw.access$1500());
                        }
                        VGA.vga.draw.linear_base = VGA.vga.fastmem;
                        VGA.vga.draw.linear_mask = (VGA.vga.vmemwrap << 1) - 1;
                        break;
                    }
                    case 12: {
                        doubleheight = true;
                        VGA.vga.draw.blocks = width * 2;
                        width <<= 4;
                        VGA_draw.access$302(VGA_draw.access$1600());
                        break;
                    }
                    case 1: {
                        doublewidth = true;
                        VGA.vga.draw.blocks = width * 2;
                        width <<= 3;
                        VGA_draw.access$302(VGA_draw.access$1700());
                        break;
                    }
                    case 0: {
                        doubleheight = true;
                        VGA.vga.draw.blocks = 2 * width;
                        width <<= 3;
                        VGA_draw.access$302(VGA_draw.access$1800());
                        break;
                    }
                    case 9: {
                        aspect_ratio = 1.0;
                        VGA.vga.draw.blocks = width;
                        v1 = doublewidth = (VGA.vga.seq.clocking_mode & 8) > 0;
                        if (Dosbox.IS_VGA_ARCH() && Dosbox.svgaCard == 0) {
                            if ((VGA.vga.seq.clocking_mode & 1) != 0) {
                                VGA.vga.draw.char9dot = false;
                                width *= 8;
                            } else {
                                VGA.vga.draw.char9dot = true;
                                width *= 9;
                            }
                            VGA_draw.access$302(VGA_draw.access$1900());
                            bpp = 16;
                            break;
                        }
                        width *= 8;
                        VGA.vga.draw.char9dot = false;
                        VGA_draw.access$302(VGA_draw.access$2000());
                        break;
                    }
                    case 10: {
                        aspect_ratio = 1.5;
                        VGA.vga.draw.blocks = width * 2;
                        width *= 16;
                        VGA_draw.access$302(VGA_draw.access$1800());
                        break;
                    }
                    case 13: {
                        aspect_ratio = 1.2;
                        doubleheight = true;
                        doublewidth = Dosbox.machine == 3 ? (VGA.vga.tandy.gfx_control & 8) == 0 : (VGA.vga.tandy.mode_control & 16) == 0;
                        VGA.vga.draw.blocks = width * (doublewidth != false ? 4 : 8);
                        width = VGA.vga.draw.blocks * 2;
                        VGA_draw.access$302(VGA_draw.access$1800());
                        break;
                    }
                    case 14: {
                        aspect_ratio = 1.2;
                        doubleheight = true;
                        doublewidth = Dosbox.machine == 2 ? (VGA.vga.tandy.mode_control & 16) == 0 : (VGA.vga.tandy.mode_control & 1) == 0;
                        VGA.vga.draw.blocks = width * 2;
                        width = VGA.vga.draw.blocks * 4;
                        if (Dosbox.machine == 2 && (VGA.vga.tandy.gfx_control & 8) != 0 || Dosbox.machine == 3 && VGA.vga.tandy.mode_control == 11) {
                            VGA_draw.access$302(VGA_draw.access$2100());
                            break;
                        }
                        VGA_draw.access$302(VGA_draw.access$1700());
                        break;
                    }
                    case 15: {
                        aspect_ratio = 1.2;
                        doubleheight = true;
                        VGA.vga.draw.blocks = width * 2;
                        if ((VGA.vga.tandy.mode_control & 1) != 0) {
                            if (Dosbox.machine == 2 && (VGA.vga.tandy.mode_control & 16) != 0) {
                                doublewidth = false;
                                VGA.vga.draw.blocks *= 2;
                                width = VGA.vga.draw.blocks * 2;
                            } else {
                                doublewidth = true;
                                width = VGA.vga.draw.blocks * 2;
                            }
                            VGA_draw.access$302(VGA_draw.access$2200());
                            break;
                        }
                        doublewidth = true;
                        width = VGA.vga.draw.blocks * 4;
                        VGA_draw.access$302(VGA_draw.access$2300());
                        break;
                    }
                    case 16: {
                        doublewidth = (VGA.vga.tandy.mode_control & 1) == 0;
                        aspect_ratio = 1.0;
                        doubleheight = true;
                        VGA.vga.draw.blocks = width;
                        width <<= 3;
                        VGA_draw.access$302(VGA_draw.access$2000());
                        break;
                    }
                    case 11: {
                        aspect_ratio = 1.0;
                        VGA.vga.draw.blocks = width;
                        width <<= 3;
                        VGA_draw.access$302(VGA_draw.access$2400());
                        break;
                    }
                    default: {
                        Log.log(1, 2, "Unhandled VGA mode " + VGA.vga.mode + " while checking for resolution");
                    }
                }
                VGA_draw.VGA_CheckScanLength();
                if (VGA.vga.draw.double_scan) {
                    if (Dosbox.IS_VGA_ARCH()) {
                        VGA.vga.draw.vblank_skip /= 2;
                        height /= 2;
                    }
                    doubleheight = true;
                }
                VGA.vga.draw.vblank_skip = vblank_skip;
                if ((!Dosbox.IS_VGA_ARCH() || Dosbox.svgaCard != 0 || VGA.vga.mode != 2 && VGA.vga.mode != 3) && !doubleheight && VGA.vga.mode < 9 && (VGA.vga.draw.address_line_total & 1) == 0) {
                    VGA.vga.draw.address_line_total /= 2;
                    doubleheight = true;
                    height /= 2;
                }
                VGA.vga.draw.lines_total = height;
                VGA.vga.draw.parts_lines = VGA.vga.draw.lines_total / VGA.vga.draw.parts_total;
                VGA.vga.draw.line_length = width * ((bpp + 1) / 8);
                if (VGA_memory.VGA_KEEP_CHANGES) {
                    VGA.vga.changes.active = false;
                    VGA.vga.changes.frame = 0;
                    VGA.vga.changes.writeMask = 1;
                }
                if (width >= 640 && height >= 480) {
                    aspect_ratio = (double)((float)width / (float)height) * 0.75;
                }
                fps_changed = false;
                if (Math.abs(VGA.vga.draw.delay.vtotal - 1000.0 / fps) > 1.0E-4) {
                    fps_changed = true;
                    VGA.vga.draw.delay.vtotal = 1000.0 / fps;
                    VGA_draw.access$2500();
                    Pic.PIC_RemoveEvents(VGA_draw.access$1000());
                    Pic.PIC_RemoveEvents(VGA_draw.access$900());
                    Pic.PIC_RemoveEvents(VGA_draw.access$1200());
                    Pic.PIC_RemoveEvents(VGA_draw.access$1100());
                    VGA_draw.access$900().call(0);
                }
                if (width != VGA.vga.draw.width || height != VGA.vga.draw.height || VGA.vga.draw.doublewidth != doublewidth || VGA.vga.draw.doubleheight != doubleheight || Math.abs(aspect_ratio - VGA.vga.draw.aspect_ratio) > 1.0E-4 || VGA.vga.draw.bpp != bpp || fps_changed) {
                    VGA_draw.access$2500();
                    VGA.vga.draw.width = width;
                    VGA.vga.draw.height = height;
                    VGA.vga.draw.doublewidth = doublewidth;
                    VGA.vga.draw.doubleheight = doubleheight;
                    VGA.vga.draw.aspect_ratio = aspect_ratio;
                    VGA.vga.draw.bpp = bpp;
                    VGA.vga.draw.lines_scaled = doubleheight != false ? 2 : 1;
                    Render.RENDER_SetSize(width, height, bpp, (float)fps, aspect_ratio, doublewidth, doubleheight);
                }
            }
        };
    }

    private static interface VGA_Line_Handler {
        public int call(int var1, int var2);
    }
}

