/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.VGA;
import jdos.hardware.VGA_memory;

public class VGA_gfx {
    static boolean index9warned = false;
    private static IoHandler.IO_WriteHandler write_p3ce = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.gfx.index = (short)(val & 0xF);
        }
    };
    private static IoHandler.IO_ReadHandler read_p3ce = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.gfx.index;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3cf = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (VGA.vga.gfx.index) {
                case 0: {
                    VGA.vga.gfx.set_reset = (short)(val & 0xF);
                    VGA.vga.config.full_set_reset = VGA.FillTable[val & 0xF];
                    VGA.vga.config.full_enable_and_set_reset = VGA.vga.config.full_set_reset & VGA.vga.config.full_enable_set_reset;
                    break;
                }
                case 1: {
                    VGA.vga.gfx.enable_set_reset = (short)(val & 0xF);
                    VGA.vga.config.full_enable_set_reset = VGA.FillTable[val & 0xF];
                    VGA.vga.config.full_not_enable_set_reset = VGA.vga.config.full_enable_set_reset ^ 0xFFFFFFFFFFFFFFFFL;
                    VGA.vga.config.full_enable_and_set_reset = VGA.vga.config.full_set_reset & VGA.vga.config.full_enable_set_reset;
                    break;
                }
                case 2: {
                    VGA.vga.gfx.color_compare = (short)(val & 0xF);
                    VGA.vga.config.color_compare = (short)(val & 0xF);
                    break;
                }
                case 3: {
                    VGA.vga.gfx.data_rotate = (short)val;
                    VGA.vga.config.data_rotate = (short)(val & 7);
                    VGA.vga.config.raster_op = (short)(val >> 3 & 3);
                    break;
                }
                case 4: {
                    VGA.vga.gfx.read_map_select = (short)(val & 3);
                    VGA.vga.config.read_map_select = (short)(val & 3);
                    break;
                }
                case 5: {
                    if (((VGA.vga.gfx.mode ^ val) & 0xF0) != 0) {
                        VGA.vga.gfx.mode = (short)val;
                        VGA.VGA_DetermineMode();
                    } else {
                        VGA.vga.gfx.mode = (short)val;
                    }
                    VGA.vga.config.write_mode = (short)(val & 3);
                    VGA.vga.config.read_mode = (short)(val >> 3 & 1);
                    break;
                }
                case 6: {
                    if (((VGA.vga.gfx.miscellaneous ^ val) & 0xC) != 0) {
                        VGA.vga.gfx.miscellaneous = (short)val;
                        VGA.VGA_DetermineMode();
                    } else {
                        VGA.vga.gfx.miscellaneous = (short)val;
                    }
                    VGA_memory.VGA_SetupHandlers();
                    break;
                }
                case 7: {
                    VGA.vga.gfx.color_dont_care = (short)(val & 0xF);
                    VGA.vga.config.color_dont_care = (short)(val & 0xF);
                    break;
                }
                case 8: {
                    VGA.vga.gfx.bit_mask = (short)val;
                    VGA.vga.config.full_bit_mask = VGA.ExpandTable[val];
                    break;
                }
                default: {
                    if (VGA.svga.write_p3cf != null) {
                        VGA.svga.write_p3cf.call(VGA.vga.gfx.index, val, iolen);
                        break;
                    }
                    if (VGA.vga.gfx.index != 9 || index9warned) break;
                    index9warned = true;
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_p3cf = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            switch (VGA.vga.gfx.index) {
                case 0: {
                    return VGA.vga.gfx.set_reset;
                }
                case 1: {
                    return VGA.vga.gfx.enable_set_reset;
                }
                case 2: {
                    return VGA.vga.gfx.color_compare;
                }
                case 3: {
                    return VGA.vga.gfx.data_rotate;
                }
                case 4: {
                    return VGA.vga.gfx.read_map_select;
                }
                case 5: {
                    return VGA.vga.gfx.mode;
                }
                case 6: {
                    return VGA.vga.gfx.miscellaneous;
                }
                case 7: {
                    return VGA.vga.gfx.color_dont_care;
                }
                case 8: {
                    return VGA.vga.gfx.bit_mask;
                }
            }
            if (VGA.svga.read_p3cf != null) {
                return VGA.svga.read_p3cf.call(VGA.vga.gfx.index, iolen);
            }
            return 0;
        }
    };

    public static void VGA_SetupGFX() {
        if (Dosbox.IS_EGAVGA_ARCH()) {
            IoHandler.IO_RegisterWriteHandler(974, write_p3ce, 1);
            IoHandler.IO_RegisterWriteHandler(975, write_p3cf, 1);
            if (Dosbox.IS_VGA_ARCH()) {
                IoHandler.IO_RegisterReadHandler(974, read_p3ce, 1);
                IoHandler.IO_RegisterReadHandler(975, read_p3cf, 1);
            }
        }
    }
}

