/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.VGA;
import jdos.hardware.VGA_memory;
import jdos.ints.Int10_modes;

public class VGA_paradise {
    static SVGA_PVGA1A_DATA pvga1a = new SVGA_PVGA1A_DATA();
    private static VGA.tWritePort write_p3cf_pvga1a = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            if (pvga1a.locked() && reg >= 9 && reg <= 14) {
                return;
            }
            switch (reg) {
                case 9: {
                    VGA_paradise.pvga1a.PR0A = val;
                    VGA_paradise.bank_setup_pvga1a();
                    break;
                }
                case 10: {
                    VGA_paradise.pvga1a.PR0B = val;
                    VGA_paradise.bank_setup_pvga1a();
                    break;
                }
                case 11: {
                    VGA_paradise.pvga1a.PR1 = VGA_paradise.pvga1a.PR1 & 0xFFFFFFF7 | val & 8;
                    VGA_paradise.bank_setup_pvga1a();
                    break;
                }
                case 12: {
                    VGA_paradise.pvga1a.PR2 = val;
                    break;
                }
                case 13: {
                    VGA_paradise.pvga1a.PR3 = val;
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFFFF | (val & 0x18) << 13;
                    VGA.vga.config.cursor_start = VGA.vga.config.cursor_start & 0xFFFF | (val & 0x18) << 13;
                    break;
                }
                case 14: {
                    VGA_paradise.pvga1a.PR4 = val;
                    break;
                }
                case 15: {
                    VGA_paradise.pvga1a.PR5 = val;
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort read_p3cf_pvga1a = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            if (pvga1a.locked() && reg >= 9 && reg <= 14) {
                return 0;
            }
            switch (reg) {
                case 9: {
                    return VGA_paradise.pvga1a.PR0A;
                }
                case 10: {
                    return VGA_paradise.pvga1a.PR0B;
                }
                case 11: {
                    return VGA_paradise.pvga1a.PR1;
                }
                case 12: {
                    return VGA_paradise.pvga1a.PR2;
                }
                case 13: {
                    return VGA_paradise.pvga1a.PR3;
                }
                case 14: {
                    return VGA_paradise.pvga1a.PR4;
                }
                case 15: {
                    return VGA_paradise.pvga1a.PR5;
                }
            }
            return 0;
        }
    };
    private static VGA.tFinishSetMode FinishSetMode_PVGA1A = new VGA.tFinishSetMode(){

        public void call(int crtc_base, VGA.VGA_ModeExtraData modeData) {
            VGA_paradise.pvga1a.biosMode = modeData.modeNo;
            IoHandler.IO_Write(974, 15);
            short oldlock = IoHandler.IO_Read(975);
            IoHandler.IO_Write(975, 5);
            IoHandler.IO_Write(974, 9);
            IoHandler.IO_Write(975, 0);
            IoHandler.IO_Write(974, 10);
            IoHandler.IO_Write(975, 0);
            IoHandler.IO_Write(974, 11);
            short val = IoHandler.IO_Read(975);
            IoHandler.IO_Write(975, val & 0xFFFFFFF7);
            IoHandler.IO_Write(974, 12);
            IoHandler.IO_Write(975, 0);
            IoHandler.IO_Write(974, 13);
            IoHandler.IO_Write(975, 0);
            IoHandler.IO_Write(974, 14);
            IoHandler.IO_Write(975, 0);
            IoHandler.IO_Write(974, 15);
            IoHandler.IO_Write(975, oldlock);
            if (VGA.svga.determine_mode != null) {
                VGA.svga.determine_mode.call();
            }
            if (VGA.vga.mode != 3) {
                VGA.vga.config.compatible_chain4 = false;
                VGA.vga.vmemwrap = VGA.vga.vmemsize;
            } else {
                VGA.vga.config.compatible_chain4 = true;
                VGA.vga.vmemwrap = 262144;
            }
            VGA_memory.VGA_SetupHandlers();
        }
    };
    private static VGA.tDetermineMode DetermineMode_PVGA1A = new VGA.tDetermineMode(){

        public void call() {
            if ((VGA.vga.attr.mode_control & 1) != 0) {
                if ((VGA.vga.gfx.mode & 0x40) != 0) {
                    VGA.VGA_SetMode(VGA_paradise.pvga1a.biosMode <= 19 ? 3 : 5);
                } else if ((VGA.vga.gfx.mode & 0x20) != 0) {
                    VGA.VGA_SetMode(1);
                } else if ((VGA.vga.gfx.miscellaneous & 0xC) == 12) {
                    VGA.VGA_SetMode(0);
                } else {
                    VGA.VGA_SetMode(VGA_paradise.pvga1a.biosMode <= 19 ? 2 : 4);
                }
            } else {
                VGA.VGA_SetMode(9);
            }
        }
    };
    private static VGA.tSetClock SetClock_PVGA1A = new VGA.tSetClock(){

        public void call(int which, int target) {
            if (which < 4) {
                VGA_paradise.pvga1a.clockFreq[which] = 1000 * target;
                VGA.VGA_StartResize();
            }
        }
    };
    private static VGA.tGetClock GetClock_PVGA1A = new VGA.tGetClock(){

        public int call() {
            return VGA_paradise.pvga1a.clockFreq[VGA.vga.misc_output >> 2 & 3];
        }
    };
    private static VGA.tAcceptsMode AcceptsMode_PVGA1A = new VGA.tAcceptsMode(){

        public boolean call(int modeNo) {
            return Int10_modes.VideoModeMemSize(modeNo) < VGA.vga.vmemsize;
        }
    };

    private static void bank_setup_pvga1a() {
        if ((VGA_paradise.pvga1a.PR1 & 8) == 0) {
            VGA.vga.svga.bank_read = VGA.vga.svga.bank_write = (short)VGA_paradise.pvga1a.PR0A;
            VGA.vga.svga.bank_size = 4096;
            VGA_memory.VGA_SetupHandlers();
        }
    }

    public static void SVGA_Setup_ParadisePVGA1A() {
        VGA.svga.write_p3cf = write_p3cf_pvga1a;
        VGA.svga.read_p3cf = read_p3cf_pvga1a;
        VGA.svga.set_video_mode = FinishSetMode_PVGA1A;
        VGA.svga.determine_mode = DetermineMode_PVGA1A;
        VGA.svga.set_clock = SetClock_PVGA1A;
        VGA.svga.get_clock = GetClock_PVGA1A;
        VGA.svga.accepts_mode = AcceptsMode_PVGA1A;
        VGA.VGA_SetClock(0, 25175);
        VGA.VGA_SetClock(1, 28322);
        VGA.VGA_SetClock(2, 32400);
        VGA.VGA_SetClock(3, 35900);
        if (VGA.vga.vmemsize == 0) {
            VGA.vga.vmemsize = 524288;
        }
        if (VGA.vga.vmemsize < 524288) {
            VGA.vga.vmemsize = 262144;
            VGA_paradise.pvga1a.PR1 = 64;
        } else if (VGA.vga.vmemsize > 524288) {
            VGA.vga.vmemsize = 0x100000;
            VGA_paradise.pvga1a.PR1 = 192;
        } else {
            VGA_paradise.pvga1a.PR1 = 128;
        }
        int rom_base = Memory.PhysMake(49152, 0);
        Memory.phys_writeb(rom_base + 125, 86);
        Memory.phys_writeb(rom_base + 126, 71);
        Memory.phys_writeb(rom_base + 127, 65);
        Memory.phys_writeb(rom_base + 128, 61);
        IoHandler.IO_Write(975, 5);
    }

    private static class SVGA_PVGA1A_DATA {
        int PR0A;
        int PR0B;
        int PR1;
        int PR2;
        int PR3;
        int PR4;
        int PR5;
        int[] clockFreq = new int[4];
        int biosMode;

        private SVGA_PVGA1A_DATA() {
        }

        boolean locked() {
            return (this.PR5 & 7) != 5;
        }
    }
}

