/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.Memory;
import jdos.hardware.VGA;
import jdos.hardware.VGA_draw;
import jdos.hardware.VGA_memory;
import jdos.ints.Int10_modes;
import jdos.misc.Log;

public class VGA_s3 {
    private static VGA.tWritePort SVGA_S3_WriteCRTC = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            block0 : switch (reg) {
                case 49: {
                    VGA.vga.s3.reg_31 = (short)val;
                    VGA.vga.config.compatible_chain4 = (val & 8) == 0;
                    VGA.vga.vmemwrap = VGA.vga.config.compatible_chain4 ? 262144 : VGA.vga.vmemsize;
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFFFCFFFF | (val & 0x30) << 12;
                    VGA.VGA_DetermineMode();
                    VGA_memory.VGA_SetupHandlers();
                    break;
                }
                case 53: {
                    if (VGA.vga.s3.reg_lock1 != 72) {
                        return;
                    }
                    VGA.vga.s3.reg_35 = (short)(val & 0xF0);
                    if ((VGA.vga.svga.bank_read & 0xF ^ val & 0xF) == 0) break;
                    VGA.vga.svga.bank_read = (short)(VGA.vga.svga.bank_read & 0xF0);
                    VGA.vga.svga.bank_write = VGA.vga.svga.bank_read = (short)(VGA.vga.svga.bank_read | val & 0xF);
                    VGA_memory.VGA_SetupHandlers();
                    break;
                }
                case 56: {
                    VGA.vga.s3.reg_lock1 = (short)val;
                    break;
                }
                case 57: {
                    VGA.vga.s3.reg_lock2 = (short)val;
                    break;
                }
                case 58: {
                    VGA.vga.s3.reg_3a = (short)val;
                    break;
                }
                case 64: {
                    VGA.vga.s3.reg_40 = (short)val;
                    break;
                }
                case 65: {
                    VGA.vga.s3.reg_41 = (short)val;
                    break;
                }
                case 67: {
                    VGA.vga.s3.reg_43 = (short)(val & 0xFFFFFFFB);
                    if (((val & 4 ^ VGA.vga.config.scan_len >> 6) & 4) == 0) break;
                    VGA.vga.config.scan_len &= 0x2FF;
                    VGA.vga.config.scan_len |= (val & 4) << 6;
                    VGA_draw.VGA_CheckScanLength();
                    break;
                }
                case 69: {
                    VGA.vga.s3.hgc.curmode = (short)val;
                    VGA_draw.VGA_ActivateHardwareCursor();
                    break;
                }
                case 70: {
                    VGA.vga.s3.hgc.originx = VGA.vga.s3.hgc.originx & 0xFF | val << 8;
                    break;
                }
                case 71: {
                    VGA.vga.s3.hgc.originx = VGA.vga.s3.hgc.originx & 0xFF00 | val;
                    break;
                }
                case 72: {
                    VGA.vga.s3.hgc.originy = VGA.vga.s3.hgc.originy & 0xFF | val << 8;
                    break;
                }
                case 73: {
                    VGA.vga.s3.hgc.originy = VGA.vga.s3.hgc.originy & 0xFF00 | val;
                    break;
                }
                case 74: {
                    if (VGA.vga.s3.hgc.fstackpos > 2) {
                        VGA.vga.s3.hgc.fstackpos = 0;
                    }
                    VGA.vga.s3.hgc.forestack.set(VGA.vga.s3.hgc.fstackpos, val);
                    VGA.vga.s3.hgc.fstackpos = (short)(VGA.vga.s3.hgc.fstackpos + 1);
                    break;
                }
                case 75: {
                    if (VGA.vga.s3.hgc.bstackpos > 2) {
                        VGA.vga.s3.hgc.bstackpos = 0;
                    }
                    VGA.vga.s3.hgc.backstack.set(VGA.vga.s3.hgc.bstackpos, val);
                    VGA.vga.s3.hgc.bstackpos = (short)(VGA.vga.s3.hgc.bstackpos + 1);
                    break;
                }
                case 76: {
                    VGA.vga.s3.hgc.startaddr &= 0xFF;
                    VGA.vga.s3.hgc.startaddr |= (val & 0xF) << 8;
                    if ((VGA.vga.s3.hgc.startaddr << 10) + 1024 <= VGA.vga.vmemsize) break;
                    VGA.vga.s3.hgc.startaddr &= 0xFF;
                    Log.log(3, 0, "VGA:S3:CRTC: HGC pattern address beyond video memory");
                    break;
                }
                case 77: {
                    VGA.vga.s3.hgc.startaddr &= 0xFF00;
                    VGA.vga.s3.hgc.startaddr |= val & 0xFF;
                    break;
                }
                case 78: {
                    VGA.vga.s3.hgc.posx = (short)(val & 0x3F);
                    break;
                }
                case 79: {
                    VGA.vga.s3.hgc.posy = (short)(val & 0x3F);
                    break;
                }
                case 80: {
                    VGA.vga.s3.reg_50 = (short)val;
                    switch (val & 0x30) {
                        case 48: {
                            VGA.vga.s3.xga_color_mode = 8;
                            break;
                        }
                        case 16: {
                            VGA.vga.s3.xga_color_mode = 7;
                            break;
                        }
                        case 0: {
                            VGA.vga.s3.xga_color_mode = 5;
                        }
                    }
                    switch (val & 0xC1) {
                        case 0: {
                            VGA.vga.s3.xga_screen_width = 1024;
                            break block0;
                        }
                        case 1: {
                            VGA.vga.s3.xga_screen_width = 1152;
                            break block0;
                        }
                        case 64: {
                            VGA.vga.s3.xga_screen_width = 640;
                            break block0;
                        }
                        case 128: {
                            VGA.vga.s3.xga_screen_width = 800;
                            break block0;
                        }
                        case 192: {
                            VGA.vga.s3.xga_screen_width = 1280;
                            break block0;
                        }
                    }
                    VGA.vga.s3.xga_screen_width = 1024;
                    break;
                }
                case 81: {
                    VGA.vga.s3.reg_51 = (short)(val & 0xC0);
                    VGA.vga.config.display_start &= 0xF3FFFF;
                    VGA.vga.config.display_start |= (val & 3) << 18;
                    if ((VGA.vga.svga.bank_read & 0x30 ^ (val & 0xC) << 2) != 0) {
                        VGA.vga.svga.bank_read = (short)(VGA.vga.svga.bank_read & 0xCF);
                        VGA.vga.svga.bank_write = VGA.vga.svga.bank_read = (short)(VGA.vga.svga.bank_read | (val & 0xC) << 2);
                        VGA_memory.VGA_SetupHandlers();
                    }
                    if (((val & 0x30 ^ VGA.vga.config.scan_len >> 4) & 0x30) == 0) break;
                    VGA.vga.config.scan_len &= 0xFF;
                    VGA.vga.config.scan_len |= (val & 0x30) << 4;
                    VGA_draw.VGA_CheckScanLength();
                    break;
                }
                case 82: {
                    VGA.vga.s3.reg_52 = (short)val;
                    break;
                }
                case 83: {
                    if (VGA.vga.s3.ext_mem_ctrl == val) break;
                    VGA.vga.s3.ext_mem_ctrl = (short)val;
                    VGA_memory.VGA_SetupHandlers();
                    break;
                }
                case 85: {
                    VGA.vga.s3.reg_55 = (short)val;
                    break;
                }
                case 88: {
                    VGA.vga.s3.reg_58 = (short)val;
                    break;
                }
                case 89: {
                    if ((VGA.vga.s3.la_window & 0xFF00 ^ val << 8) == 0) break;
                    VGA.vga.s3.la_window = VGA.vga.s3.la_window & 0xFF | val << 8;
                    VGA_memory.VGA_StartUpdateLFB();
                    break;
                }
                case 90: {
                    if ((VGA.vga.s3.la_window & 0xFF ^ val) == 0) break;
                    VGA.vga.s3.la_window = VGA.vga.s3.la_window & 0xFF00 | val;
                    VGA_memory.VGA_StartUpdateLFB();
                    break;
                }
                case 93: {
                    if (((val ^ VGA.vga.s3.ex_hor_overflow) & 3) != 0) {
                        VGA.vga.s3.ex_hor_overflow = (short)val;
                        VGA.VGA_StartResize();
                        break;
                    }
                    VGA.vga.s3.ex_hor_overflow = (short)val;
                    break;
                }
                case 94: {
                    VGA.vga.config.line_compare = VGA.vga.config.line_compare & 0x3FF | (val & 0x40) << 4;
                    if (((val ^ VGA.vga.s3.ex_ver_overflow) & 3) != 0) {
                        VGA.vga.s3.ex_ver_overflow = (short)val;
                        VGA.VGA_StartResize();
                        break;
                    }
                    VGA.vga.s3.ex_ver_overflow = (short)val;
                    break;
                }
                case 103: {
                    VGA.vga.s3.misc_control_2 = (short)val;
                    VGA.VGA_DetermineMode();
                    break;
                }
                case 105: {
                    if (((VGA.vga.config.display_start & 0x1F0000) >> 16 ^ val & 0x1F) == 0) break;
                    VGA.vga.config.display_start &= 0xFFFF;
                    VGA.vga.config.display_start |= (val & 0x1F) << 16;
                    break;
                }
                case 106: {
                    VGA.vga.svga.bank_write = VGA.vga.svga.bank_read = (short)(val & 0x7F);
                    VGA_memory.VGA_SetupHandlers();
                    break;
                }
                case 107: {
                    VGA.vga.s3.reg_6b = (short)val;
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort SVGA_S3_ReadCRTC = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            switch (reg) {
                case 36: 
                case 38: {
                    return ((VGA.vga.attr.disabled & 1) != 0 ? 0 : 32) | VGA.vga.attr.index & 0x1F;
                }
                case 45: {
                    return 136;
                }
                case 46: {
                    return 17;
                }
                case 47: {
                    return 0;
                }
                case 48: {
                    return 225;
                }
                case 49: {
                    return VGA.vga.s3.reg_31;
                }
                case 53: {
                    return VGA.vga.s3.reg_35 | VGA.vga.svga.bank_read & 0xF;
                }
                case 54: {
                    return VGA.vga.s3.reg_36;
                }
                case 55: {
                    return 43;
                }
                case 56: {
                    return VGA.vga.s3.reg_lock1;
                }
                case 57: {
                    return VGA.vga.s3.reg_lock2;
                }
                case 58: {
                    return VGA.vga.s3.reg_3a;
                }
                case 64: {
                    return VGA.vga.s3.reg_40;
                }
                case 65: {
                    return VGA.vga.s3.reg_41;
                }
                case 66: {
                    return 13;
                }
                case 67: {
                    return VGA.vga.s3.reg_43 | VGA.vga.config.scan_len >> 6 & 4;
                }
                case 69: {
                    VGA.vga.s3.hgc.bstackpos = 0;
                    VGA.vga.s3.hgc.fstackpos = 0;
                    return VGA.vga.s3.hgc.curmode | 0xA0;
                }
                case 70: {
                    return VGA.vga.s3.hgc.originx >> 8;
                }
                case 71: {
                    return VGA.vga.s3.hgc.originx & 0xFF;
                }
                case 72: {
                    return VGA.vga.s3.hgc.originy >> 8;
                }
                case 73: {
                    return VGA.vga.s3.hgc.originy & 0xFF;
                }
                case 74: {
                    return VGA.vga.s3.hgc.forestack.get(VGA.vga.s3.hgc.fstackpos);
                }
                case 75: {
                    return VGA.vga.s3.hgc.backstack.get(VGA.vga.s3.hgc.bstackpos);
                }
                case 80: {
                    return VGA.vga.s3.reg_50;
                }
                case 81: {
                    return VGA.vga.config.display_start >> 16 & 3 | (VGA.vga.svga.bank_read & 0x30) >> 2 | (VGA.vga.config.scan_len & 0x300) >> 4 | VGA.vga.s3.reg_51;
                }
                case 82: {
                    return VGA.vga.s3.reg_52;
                }
                case 83: {
                    return VGA.vga.s3.ext_mem_ctrl;
                }
                case 85: {
                    return VGA.vga.s3.reg_55;
                }
                case 88: {
                    return VGA.vga.s3.reg_58;
                }
                case 89: {
                    return VGA.vga.s3.la_window >> 8;
                }
                case 90: {
                    return VGA.vga.s3.la_window & 0xFF;
                }
                case 93: {
                    return VGA.vga.s3.ex_hor_overflow;
                }
                case 94: {
                    return VGA.vga.s3.ex_ver_overflow;
                }
                case 103: {
                    return VGA.vga.s3.misc_control_2;
                }
                case 105: {
                    return (VGA.vga.config.display_start & 0x1F0000) >> 16;
                }
                case 106: {
                    return VGA.vga.svga.bank_read & 0x7F;
                }
                case 107: {
                    return VGA.vga.s3.reg_6b;
                }
            }
            return 0;
        }
    };
    private static VGA.tWritePort SVGA_S3_WriteSEQ = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            if (reg > 8 && VGA.vga.s3.pll.lock != 6) {
                return;
            }
            switch (reg) {
                case 8: {
                    VGA.vga.s3.pll.lock = (short)val;
                    break;
                }
                case 16: {
                    VGA.vga.s3.mclk.n = (short)(val & 0x1F);
                    VGA.vga.s3.mclk.r = (short)(val >> 5);
                    break;
                }
                case 17: {
                    VGA.vga.s3.mclk.m = (short)(val & 0x7F);
                    break;
                }
                case 18: {
                    VGA.vga.s3.clk[3].n = (short)(val & 0x1F);
                    VGA.vga.s3.clk[3].r = (short)(val >> 5);
                    break;
                }
                case 19: {
                    VGA.vga.s3.clk[3].m = (short)(val & 0x7F);
                    break;
                }
                case 21: {
                    VGA.vga.s3.pll.cmd = (short)val;
                    VGA.VGA_StartResize();
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort SVGA_S3_ReadSEQ = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            if (reg > 8 && VGA.vga.s3.pll.lock != 6) {
                if (reg < 27) {
                    return 0;
                }
                return reg;
            }
            switch (reg) {
                case 8: {
                    return VGA.vga.s3.pll.lock;
                }
                case 16: {
                    return VGA.vga.s3.mclk.n != 0 || VGA.vga.s3.mclk.r << 5 != 0 ? 1 : 0;
                }
                case 17: {
                    return VGA.vga.s3.mclk.m;
                }
                case 18: {
                    return VGA.vga.s3.clk[3].n != 0 || VGA.vga.s3.clk[3].r << 5 != 0 ? 1 : 0;
                }
                case 19: {
                    return VGA.vga.s3.clk[3].m;
                }
                case 21: {
                    return VGA.vga.s3.pll.cmd;
                }
            }
            return 0;
        }
    };
    private static VGA.tGetClock SVGA_S3_GetClock = new VGA.tGetClock(){

        public int call() {
            int clock = VGA.vga.misc_output >> 2 & 3;
            clock = clock == 0 ? 25175000 : (clock == 1 ? 28322000 : 1000 * VGA.S3_CLOCK(VGA.vga.s3.clk[clock].m, VGA.vga.s3.clk[clock].n, VGA.vga.s3.clk[clock].r));
            if ((VGA.vga.s3.pll.cmd & 0x10) != 0) {
                clock /= 2;
            }
            return clock;
        }
    };
    private static VGA.tHWCursorActive SVGA_S3_HWCursorActive = new VGA.tHWCursorActive(){

        public boolean call() {
            return (VGA.vga.s3.hgc.curmode & 1) != 0;
        }
    };
    private static VGA.tAcceptsMode SVGA_S3_AcceptsMode = new VGA.tAcceptsMode(){

        public boolean call(int mode) {
            return Int10_modes.VideoModeMemSize(mode) < VGA.vga.vmemsize;
        }
    };

    public static void SVGA_Setup_S3Trio() {
        VGA.svga.write_p3d5 = SVGA_S3_WriteCRTC;
        VGA.svga.read_p3d5 = SVGA_S3_ReadCRTC;
        VGA.svga.write_p3c5 = SVGA_S3_WriteSEQ;
        VGA.svga.read_p3c5 = SVGA_S3_ReadSEQ;
        VGA.svga.write_p3c0 = null;
        VGA.svga.read_p3c1 = null;
        VGA.svga.set_video_mode = null;
        VGA.svga.determine_mode = null;
        VGA.svga.set_clock = null;
        VGA.svga.get_clock = SVGA_S3_GetClock;
        VGA.svga.hardware_cursor_active = SVGA_S3_HWCursorActive;
        VGA.svga.accepts_mode = SVGA_S3_AcceptsMode;
        if (VGA.vga.vmemsize == 0) {
            VGA.vga.vmemsize = 0x200000;
        }
        if (VGA.vga.vmemsize < 0x100000) {
            VGA.vga.vmemsize = 524288;
            VGA.vga.s3.reg_36 = (short)250;
        } else if (VGA.vga.vmemsize < 0x200000) {
            VGA.vga.vmemsize = 0x100000;
            VGA.vga.s3.reg_36 = (short)218;
        } else if (VGA.vga.vmemsize < 0x300000) {
            VGA.vga.vmemsize = 0x200000;
            VGA.vga.s3.reg_36 = (short)154;
        } else if (VGA.vga.vmemsize < 0x400000) {
            VGA.vga.vmemsize = 0x300000;
            VGA.vga.s3.reg_36 = (short)90;
        } else if (VGA.vga.vmemsize < 0x800000) {
            VGA.vga.vmemsize = 0x400000;
            VGA.vga.s3.reg_36 = (short)26;
        } else {
            VGA.vga.vmemsize = 0x800000;
            VGA.vga.s3.reg_36 = (short)122;
        }
        int rom_base = Memory.PhysMake(49152, 0);
        Memory.phys_writeb(rom_base + 63, 83);
        Memory.phys_writeb(rom_base + 64, 51);
        Memory.phys_writeb(rom_base + 65, 32);
        Memory.phys_writeb(rom_base + 66, 56);
        Memory.phys_writeb(rom_base + 67, 54);
        Memory.phys_writeb(rom_base + 68, 67);
        Memory.phys_writeb(rom_base + 69, 55);
        Memory.phys_writeb(rom_base + 70, 54);
        Memory.phys_writeb(rom_base + 71, 52);
    }
}

