/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.VGA;
import jdos.hardware.VGA_memory;
import jdos.util.Ptr;

public class VGA_seq {
    private static IoHandler.IO_ReadHandler read_p3c4 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.seq.index;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3c4 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.seq.index = (short)val;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3c5 = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            switch (VGA.vga.seq.index) {
                case 0: {
                    VGA.vga.seq.reset = (short)val;
                    break;
                }
                case 1: {
                    if (val == VGA.vga.seq.clocking_mode) break;
                    if ((val & 0xFFFFFFDF) != (VGA.vga.seq.clocking_mode & 0xFFFFFFDF)) {
                        VGA.vga.seq.clocking_mode = (short)val;
                        VGA.VGA_StartResize();
                    } else {
                        VGA.vga.seq.clocking_mode = (short)val;
                    }
                    if ((val & 0x20) != 0) {
                        VGA.vga.attr.disabled = (short)(VGA.vga.attr.disabled | 2);
                        break;
                    }
                    VGA.vga.attr.disabled = (short)(VGA.vga.attr.disabled & 0xFFFFFFFD);
                    break;
                }
                case 2: {
                    VGA.vga.seq.map_mask = (short)(val & 0xF);
                    VGA.vga.config.full_map_mask = VGA.FillTable[val & 0xF];
                    VGA.vga.config.full_not_map_mask = VGA.vga.config.full_map_mask ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case 3: {
                    VGA.vga.seq.character_map_select = (short)val;
                    int font1 = (val & 3) << 1;
                    if (Dosbox.IS_VGA_ARCH()) {
                        font1 |= (val & 0x10) >> 4;
                    }
                    VGA.vga.draw.font_tables[0] = new Ptr(VGA.vga.draw.font, font1 * 8 * 1024);
                    int font2 = (val & 0xC) >> 1;
                    if (Dosbox.IS_VGA_ARCH()) {
                        font2 |= (val & 0x20) >> 5;
                    }
                    VGA.vga.draw.font_tables[1] = new Ptr(VGA.vga.draw.font, font2 * 8 * 1024);
                    break;
                }
                case 4: {
                    VGA.vga.seq.memory_mode = (short)val;
                    if (!Dosbox.IS_VGA_ARCH()) break;
                    VGA.vga.config.chained = (val & 8) != 0;
                    VGA_memory.VGA_SetupHandlers();
                    break;
                }
                default: {
                    if (VGA.svga.write_p3c5 == null) break;
                    VGA.svga.write_p3c5.call(VGA.vga.seq.index, val, iolen);
                }
            }
        }
    };
    private static IoHandler.IO_ReadHandler read_p3c5 = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            switch (VGA.vga.seq.index) {
                case 0: {
                    return VGA.vga.seq.reset;
                }
                case 1: {
                    return VGA.vga.seq.clocking_mode;
                }
                case 2: {
                    return VGA.vga.seq.map_mask;
                }
                case 3: {
                    return VGA.vga.seq.character_map_select;
                }
                case 4: {
                    return VGA.vga.seq.memory_mode;
                }
            }
            if (VGA.svga.read_p3c5 != null) {
                return VGA.svga.read_p3c5.call(VGA.vga.seq.index, iolen);
            }
            return 0;
        }
    };

    public static void VGA_SetupSEQ() {
        if (Dosbox.IS_EGAVGA_ARCH()) {
            IoHandler.IO_RegisterWriteHandler(964, write_p3c4, 1);
            IoHandler.IO_RegisterWriteHandler(965, write_p3c5, 1);
            if (Dosbox.IS_VGA_ARCH()) {
                IoHandler.IO_RegisterReadHandler(964, read_p3c4, 1);
                IoHandler.IO_RegisterReadHandler(965, read_p3c5, 1);
            }
        }
    }
}

