/*
 * Decompiled with CFR 0.152.
 */
package jdos.hardware;

import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.VGA;
import jdos.hardware.VGA_memory;
import jdos.ints.Int10_modes;

public class VGA_tseng {
    static SVGA_ET4K_DATA et4k = new SVGA_ET4K_DATA();
    private static VGA.tWritePort write_p3d5_et4k = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            if (!VGA_tseng.et4k.extensionsEnabled && reg != 51) {
                return;
            }
            switch (reg) {
                case 49: {
                    VGA_tseng.et4k.store_3d4_31 = val;
                    break;
                }
                case 50: {
                    VGA_tseng.et4k.store_3d4_32 = val;
                    break;
                }
                case 51: {
                    VGA_tseng.et4k.store_3d4_33 = val;
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFFFF | (val & 3) << 16;
                    VGA.vga.config.cursor_start = VGA.vga.config.cursor_start & 0xFFFF | (val & 0xC) << 14;
                    break;
                }
                case 52: {
                    VGA_tseng.et4k.store_3d4_34 = val;
                    break;
                }
                case 53: {
                    VGA_tseng.et4k.store_3d4_35 = val;
                    VGA.vga.config.line_compare = VGA.vga.config.line_compare & 0x3FF | (val & 0x10) << 6;
                    int s3val = (val & 1) << 2 | (val & 2) >> 1 | (val & 4) >> 1 | (val & 8) << 1 | (val & 0x10) << 2;
                    if (((s3val ^ VGA.vga.s3.ex_ver_overflow) & 3) != 0) {
                        VGA.vga.s3.ex_ver_overflow = (short)s3val;
                        VGA.VGA_StartResize();
                        break;
                    }
                    VGA.vga.s3.ex_ver_overflow = (short)s3val;
                    break;
                }
                case 54: {
                    VGA_tseng.et4k.store_3d4_34 = val;
                    break;
                }
                case 55: {
                    if (val == VGA_tseng.et4k.store_3d4_37) break;
                    VGA_tseng.et4k.store_3d4_37 = val;
                    VGA.vga.vmemwrap = 65536 << ((val & 8) >> 2) << (val & 3) - 1;
                    VGA_memory.VGA_SetupHandlers();
                    break;
                }
                case 63: {
                    VGA_tseng.et4k.store_3d4_3f = val;
                    if (((val ^ VGA.vga.s3.ex_hor_overflow) & 3) != 0) {
                        VGA.vga.s3.ex_hor_overflow = (short)(val & 0x15);
                        VGA.VGA_StartResize();
                        break;
                    }
                    VGA.vga.s3.ex_hor_overflow = (short)(val & 0x15);
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort read_p3d5_et4k = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            if (!VGA_tseng.et4k.extensionsEnabled && reg != 51) {
                return 0;
            }
            switch (reg) {
                case 49: {
                    return VGA_tseng.et4k.store_3d4_31;
                }
                case 50: {
                    return VGA_tseng.et4k.store_3d4_32;
                }
                case 51: {
                    return VGA_tseng.et4k.store_3d4_33;
                }
                case 52: {
                    return VGA_tseng.et4k.store_3d4_34;
                }
                case 53: {
                    return VGA_tseng.et4k.store_3d4_35;
                }
                case 54: {
                    return VGA_tseng.et4k.store_3d4_36;
                }
                case 55: {
                    return VGA_tseng.et4k.store_3d4_37;
                }
                case 63: {
                    return VGA_tseng.et4k.store_3d4_3f;
                }
            }
            return 0;
        }
    };
    private static VGA.tWritePort write_p3c5_et4k = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            switch (reg) {
                case 6: {
                    VGA_tseng.et4k.store_3c4_06 = val;
                    break;
                }
                case 7: {
                    VGA_tseng.et4k.store_3c4_07 = val;
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort read_p3c5_et4k = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            switch (reg) {
                case 6: {
                    return VGA_tseng.et4k.store_3c4_06;
                }
                case 7: {
                    return VGA_tseng.et4k.store_3c4_07;
                }
            }
            return 0;
        }
    };
    private static IoHandler.IO_WriteHandler io_write_p3cd_et4k = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            write_p3cd_et4k.call(port, val, iolen);
        }
    };
    private static VGA.tWritePort write_p3cd_et4k = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            VGA.vga.svga.bank_write = (short)(val & 0xF);
            VGA.vga.svga.bank_read = (short)(val >> 4 & 0xF);
            VGA_memory.VGA_SetupHandlers();
        }
    };
    private static IoHandler.IO_ReadHandler read_p3cd_et4k = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.svga.bank_read << 4 | VGA.vga.svga.bank_write;
        }
    };
    private static VGA.tWritePort write_p3c0_et4k = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            switch (reg) {
                case 22: {
                    VGA_tseng.et4k.store_3c0_16 = val;
                    break;
                }
                case 23: {
                    VGA_tseng.et4k.store_3c0_17 = val;
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort read_p3c1_et4k = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            switch (reg) {
                case 22: {
                    return VGA_tseng.et4k.store_3c0_16;
                }
                case 23: {
                    return VGA_tseng.et4k.store_3c0_17;
                }
            }
            return 0;
        }
    };
    private static VGA.tFinishSetMode FinishSetMode_ET4K = new VGA.tFinishSetMode(){

        public void call(int crtc_base, VGA.VGA_ModeExtraData modeData) {
            VGA_tseng.et4k.biosMode = modeData.modeNo;
            IoHandler.IO_Write(973, 0);
            int et4k_hor_overflow = modeData.hor_overflow & 1 | modeData.hor_overflow & 4 | modeData.hor_overflow & 0x10;
            IoHandler.IO_Write(crtc_base, 63);
            IoHandler.IO_Write(crtc_base + 1, et4k_hor_overflow);
            int et4k_ver_overflow = (modeData.ver_overflow & 1) << 1 | (modeData.ver_overflow & 2) << 1 | (modeData.ver_overflow & 4) >> 2 | (modeData.ver_overflow & 0x10) >> 1 | (modeData.ver_overflow & 0x40) >> 2;
            IoHandler.IO_Write(crtc_base, 53);
            IoHandler.IO_Write(crtc_base + 1, et4k_ver_overflow);
            IoHandler.IO_Write(crtc_base, 49);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 50);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 51);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 52);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 54);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 55);
            IoHandler.IO_Write(crtc_base + 1, 0xC | (VGA.vga.vmemsize == 0x100000 ? 3 : (VGA.vga.vmemsize == 524288 ? 2 : 1)));
            IoHandler.IO_Write(964, 6);
            IoHandler.IO_Write(965, 0);
            IoHandler.IO_Write(964, 7);
            IoHandler.IO_Write(965, 0);
            IoHandler.IO_Write(960, 22);
            IoHandler.IO_Write(960, 0);
            IoHandler.IO_Write(960, 23);
            IoHandler.IO_Write(960, 0);
            if (modeData.modeNo > 19) {
                int target = modeData.vtotal * 8 * modeData.htotal * 60;
                int best = 1;
                int dist = 100000000;
                for (int i = 0; i < 16; ++i) {
                    int cdiff = Math.abs(target - VGA_tseng.et4k.clockFreq[i]);
                    if (cdiff >= dist) continue;
                    best = i;
                    dist = cdiff;
                }
                VGA_tseng.set_clock_index_et4k(best);
            }
            if (VGA.svga.determine_mode != null) {
                VGA.svga.determine_mode.call();
            }
            VGA.vga.config.compatible_chain4 = false;
            VGA.vga.vmemwrap = VGA.vga.vmemsize;
            VGA_memory.VGA_SetupHandlers();
        }
    };
    private static VGA.tDetermineMode DetermineMode_ET4K = new VGA.tDetermineMode(){

        public void call() {
            if ((VGA.vga.attr.mode_control & 1) != 0) {
                if ((VGA.vga.gfx.mode & 0x40) != 0) {
                    VGA.VGA_SetMode(VGA_tseng.et4k.biosMode <= 19 ? 3 : 5);
                } else if ((VGA.vga.gfx.mode & 0x20) != 0) {
                    VGA.VGA_SetMode(1);
                } else if ((VGA.vga.gfx.miscellaneous & 0xC) == 12) {
                    VGA.VGA_SetMode(0);
                } else {
                    VGA.VGA_SetMode(VGA_tseng.et4k.biosMode <= 19 ? 2 : 4);
                }
            } else {
                VGA.VGA_SetMode(9);
            }
        }
    };
    private static VGA.tSetClock SetClock_ET4K = new VGA.tSetClock(){

        public void call(int which, int target) {
            VGA_tseng.et4k.clockFreq[which] = 1000 * target;
            VGA.VGA_StartResize();
        }
    };
    private static VGA.tGetClock GetClock_ET4K = new VGA.tGetClock(){

        public int call() {
            return VGA_tseng.et4k.clockFreq[VGA_tseng.get_clock_index_et4k()];
        }
    };
    private static VGA.tAcceptsMode AcceptsMode_ET4K = new VGA.tAcceptsMode(){

        public boolean call(int modeNo) {
            return Int10_modes.VideoModeMemSize(modeNo) < VGA.vga.vmemsize;
        }
    };
    private static SVGA_ET3K_DATA et3k = new SVGA_ET3K_DATA();
    private static VGA.tWritePort write_p3d5_et3k = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            switch (reg) {
                case 27: {
                    et3k.store_3d4_1b = val;
                    break;
                }
                case 28: {
                    et3k.store_3d4_1c = val;
                    break;
                }
                case 29: {
                    et3k.store_3d4_1d = val;
                    break;
                }
                case 30: {
                    et3k.store_3d4_1e = val;
                    break;
                }
                case 31: {
                    et3k.store_3d4_1f = val;
                    break;
                }
                case 32: {
                    et3k.store_3d4_20 = val;
                    break;
                }
                case 33: {
                    et3k.store_3d4_21 = val;
                    break;
                }
                case 35: {
                    et3k.store_3d4_23 = val;
                    VGA.vga.config.display_start = VGA.vga.config.display_start & 0xFFFF | (val & 2) << 15;
                    VGA.vga.config.cursor_start = VGA.vga.config.cursor_start & 0xFFFF | (val & 1) << 16;
                    break;
                }
                case 36: {
                    et3k.store_3d4_24 = val;
                    break;
                }
                case 37: {
                    et3k.store_3d4_25 = val;
                    VGA.vga.config.line_compare = VGA.vga.config.line_compare & 0x3FF | (val & 0x10) << 6;
                    int s3val = (val & 1) << 2 | (val & 2) >> 1 | (val & 4) >> 1 | (val & 8) << 1 | (val & 0x10) << 2;
                    if (((s3val ^ VGA.vga.s3.ex_ver_overflow) & 3) != 0) {
                        VGA.vga.s3.ex_ver_overflow = (short)s3val;
                        VGA.VGA_StartResize();
                        break;
                    }
                    VGA.vga.s3.ex_ver_overflow = (short)s3val;
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort read_p3d5_et3k = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            switch (reg) {
                case 27: {
                    return et3k.store_3d4_1b;
                }
                case 28: {
                    return et3k.store_3d4_1c;
                }
                case 29: {
                    return et3k.store_3d4_1d;
                }
                case 30: {
                    return et3k.store_3d4_1e;
                }
                case 31: {
                    return et3k.store_3d4_1f;
                }
                case 32: {
                    return et3k.store_3d4_20;
                }
                case 33: {
                    return et3k.store_3d4_21;
                }
                case 35: {
                    return et3k.store_3d4_23;
                }
                case 36: {
                    return et3k.store_3d4_24;
                }
                case 37: {
                    return et3k.store_3d4_25;
                }
            }
            return 0;
        }
    };
    private static VGA.tWritePort write_p3c5_et3k = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            switch (reg) {
                case 6: {
                    et3k.store_3c4_06 = val;
                    break;
                }
                case 7: {
                    et3k.store_3c4_07 = val;
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort read_p3c5_et3k = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            switch (reg) {
                case 6: {
                    return et3k.store_3c4_06;
                }
                case 7: {
                    return et3k.store_3c4_07;
                }
            }
            return 0;
        }
    };
    private static IoHandler.IO_WriteHandler write_p3cd_et3k = new IoHandler.IO_WriteHandler(){

        public void call(int port, int val, int iolen) {
            VGA.vga.svga.bank_write = (short)(val & 7);
            VGA.vga.svga.bank_read = (short)(val >> 3 & 7);
            VGA.vga.svga.bank_size = (val & 0x40) != 0 ? 65536 : 131072;
            VGA_memory.VGA_SetupHandlers();
        }
    };
    private static IoHandler.IO_ReadHandler read_p3cd_et3k = new IoHandler.IO_ReadHandler(){

        public int call(int port, int iolen) {
            return VGA.vga.svga.bank_read << 3 | VGA.vga.svga.bank_write | (VGA.vga.svga.bank_size == 131072 ? 0 : 64);
        }
    };
    private static VGA.tWritePort write_p3c0_et3k = new VGA.tWritePort(){

        public void call(int reg, int val, int iolen) {
            switch (reg) {
                case 22: {
                    et3k.store_3c0_16 = val;
                    break;
                }
                case 23: {
                    et3k.store_3c0_17 = val;
                    break;
                }
            }
        }
    };
    private static VGA.tReadPort read_p3c1_et3k = new VGA.tReadPort(){

        public int call(int reg, int iolen) {
            switch (reg) {
                case 22: {
                    return et3k.store_3c0_16;
                }
                case 23: {
                    return et3k.store_3c0_17;
                }
            }
            return 0;
        }
    };
    private static VGA.tFinishSetMode FinishSetMode_ET3K = new VGA.tFinishSetMode(){

        public void call(int crtc_base, VGA.VGA_ModeExtraData modeData) {
            et3k.biosMode = modeData.modeNo;
            IoHandler.IO_Write(973, 64);
            int et4k_ver_overflow = (modeData.ver_overflow & 1) << 1 | (modeData.ver_overflow & 2) << 1 | (modeData.ver_overflow & 4) >> 2 | (modeData.ver_overflow & 0x10) >> 1 | (modeData.ver_overflow & 0x40) >> 2;
            IoHandler.IO_Write(crtc_base, 37);
            IoHandler.IO_Write(crtc_base + 1, et4k_ver_overflow);
            for (int i = 22; i <= 33; ++i) {
                IoHandler.IO_Write(crtc_base, i);
            }
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 35);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 36);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(964, 6);
            IoHandler.IO_Write(965, 0);
            IoHandler.IO_Write(964, 7);
            IoHandler.IO_Write(965, 64);
            IoHandler.IO_Write(960, 22);
            IoHandler.IO_Write(960, 0);
            IoHandler.IO_Write(960, 23);
            IoHandler.IO_Write(960, 0);
            if (modeData.modeNo > 19) {
                int target = modeData.vtotal * 8 * modeData.htotal * 60;
                int best = 1;
                int dist = 100000000;
                for (int i = 0; i < 8; ++i) {
                    int cdiff = Math.abs(target - et3k.clockFreq[i]);
                    if (cdiff >= dist) continue;
                    best = i;
                    dist = cdiff;
                }
                VGA_tseng.set_clock_index_et3k(best);
            }
            if (VGA.svga.determine_mode != null) {
                VGA.svga.determine_mode.call();
            }
            VGA.vga.config.compatible_chain4 = false;
            VGA.vga.vmemwrap = VGA.vga.vmemsize;
            VGA_memory.VGA_SetupHandlers();
        }
    };
    private static VGA.tDetermineMode DetermineMode_ET3K = new VGA.tDetermineMode(){

        public void call() {
            if ((VGA.vga.attr.mode_control & 1) != 0) {
                if ((VGA.vga.gfx.mode & 0x40) != 0) {
                    VGA.VGA_SetMode(et3k.biosMode <= 19 ? 3 : 5);
                } else if ((VGA.vga.gfx.mode & 0x20) != 0) {
                    VGA.VGA_SetMode(1);
                } else if ((VGA.vga.gfx.miscellaneous & 0xC) == 12) {
                    VGA.VGA_SetMode(0);
                } else {
                    VGA.VGA_SetMode(et3k.biosMode <= 19 ? 2 : 4);
                }
            } else {
                VGA.VGA_SetMode(9);
            }
        }
    };
    private static VGA.tSetClock SetClock_ET3K = new VGA.tSetClock(){

        public void call(int which, int target) {
            et3k.clockFreq[which] = 1000 * target;
            VGA.VGA_StartResize();
        }
    };
    private static VGA.tGetClock GetClock_ET3K = new VGA.tGetClock(){

        public int call() {
            return et3k.clockFreq[VGA_tseng.get_clock_index_et3k()];
        }
    };
    private static VGA.tAcceptsMode AcceptsMode_ET3K = new VGA.tAcceptsMode(){

        public boolean call(int mode) {
            return mode <= 55 && mode != 47 && Int10_modes.VideoModeMemSize(mode) < VGA.vga.vmemsize;
        }
    };

    private static int get_clock_index_et4k() {
        return VGA.vga.misc_output >> 2 & 3 | VGA_tseng.et4k.store_3d4_34 << 1 & 4 | VGA_tseng.et4k.store_3d4_31 >> 3 & 8;
    }

    private static void set_clock_index_et4k(int index) {
        IoHandler.IO_Write(962, VGA.vga.misc_output & 0xFFFFFFF3 | (index & 3) << 2);
        VGA_tseng.et4k.store_3d4_34 = VGA_tseng.et4k.store_3d4_34 & 0xFFFFFFFD | (index & 4) >> 1;
        VGA_tseng.et4k.store_3d4_31 = VGA_tseng.et4k.store_3d4_31 & 0xFFFFFF3F | (index & 8) << 3;
    }

    public static void SVGA_Setup_TsengET4K() {
        VGA.svga.write_p3d5 = write_p3d5_et4k;
        VGA.svga.read_p3d5 = read_p3d5_et4k;
        VGA.svga.write_p3c5 = write_p3c5_et4k;
        VGA.svga.read_p3c5 = read_p3c5_et4k;
        VGA.svga.write_p3c0 = write_p3c0_et4k;
        VGA.svga.read_p3c1 = read_p3c1_et4k;
        VGA.svga.set_video_mode = FinishSetMode_ET4K;
        VGA.svga.determine_mode = DetermineMode_ET4K;
        VGA.svga.set_clock = SetClock_ET4K;
        VGA.svga.get_clock = GetClock_ET4K;
        VGA.svga.accepts_mode = AcceptsMode_ET4K;
        VGA.VGA_SetClock(0, 25175);
        VGA.VGA_SetClock(1, 28322);
        VGA.VGA_SetClock(2, 32400);
        VGA.VGA_SetClock(3, 35900);
        VGA.VGA_SetClock(4, 39900);
        VGA.VGA_SetClock(5, 44700);
        VGA.VGA_SetClock(6, 31400);
        VGA.VGA_SetClock(7, 37500);
        VGA.VGA_SetClock(8, 50000);
        VGA.VGA_SetClock(9, 56500);
        VGA.VGA_SetClock(10, 64900);
        VGA.VGA_SetClock(11, 71900);
        VGA.VGA_SetClock(12, 79900);
        VGA.VGA_SetClock(13, 89600);
        VGA.VGA_SetClock(14, 62800);
        VGA.VGA_SetClock(15, 74800);
        IoHandler.IO_RegisterReadHandler(973, read_p3cd_et4k, 1);
        IoHandler.IO_RegisterWriteHandler(973, io_write_p3cd_et4k, 1);
        if (VGA.vga.vmemsize == 0) {
            VGA.vga.vmemsize = 0x100000;
        }
        VGA.vga.vmemsize = VGA.vga.vmemsize < 524288 ? 262144 : (VGA.vga.vmemsize < 0x100000 ? 524288 : 0x100000);
        int rom_base = Memory.PhysMake(49152, 0);
        Memory.phys_writeb(rom_base + 117, 32);
        Memory.phys_writeb(rom_base + 118, 84);
        Memory.phys_writeb(rom_base + 119, 115);
        Memory.phys_writeb(rom_base + 120, 101);
        Memory.phys_writeb(rom_base + 121, 110);
        Memory.phys_writeb(rom_base + 122, 103);
        Memory.phys_writeb(rom_base + 123, 32);
    }

    private static int get_clock_index_et3k() {
        return VGA.vga.misc_output >> 2 & 3 | VGA_tseng.et3k.store_3d4_24 << 1 & 4;
    }

    private static void set_clock_index_et3k(int index) {
        IoHandler.IO_Write(962, VGA.vga.misc_output & 0xFFFFFFF3 | (index & 3) << 2);
        VGA_tseng.et3k.store_3d4_24 = VGA_tseng.et3k.store_3d4_24 & 0xFFFFFFFD | (index & 4) >> 1;
    }

    public static void SVGA_Setup_TsengET3K() {
        VGA.svga.write_p3d5 = write_p3d5_et3k;
        VGA.svga.read_p3d5 = read_p3d5_et3k;
        VGA.svga.write_p3c5 = write_p3c5_et3k;
        VGA.svga.read_p3c5 = read_p3c5_et3k;
        VGA.svga.write_p3c0 = write_p3c0_et3k;
        VGA.svga.read_p3c1 = read_p3c1_et3k;
        VGA.svga.set_video_mode = FinishSetMode_ET3K;
        VGA.svga.determine_mode = DetermineMode_ET3K;
        VGA.svga.set_clock = SetClock_ET3K;
        VGA.svga.get_clock = GetClock_ET3K;
        VGA.svga.accepts_mode = AcceptsMode_ET3K;
        VGA.VGA_SetClock(0, 25175);
        VGA.VGA_SetClock(1, 28322);
        VGA.VGA_SetClock(2, 32400);
        VGA.VGA_SetClock(3, 35900);
        VGA.VGA_SetClock(4, 39900);
        VGA.VGA_SetClock(5, 44700);
        VGA.VGA_SetClock(6, 31400);
        VGA.VGA_SetClock(7, 37500);
        IoHandler.IO_RegisterReadHandler(973, read_p3cd_et3k, 1);
        IoHandler.IO_RegisterWriteHandler(973, write_p3cd_et3k, 1);
        VGA.vga.vmemsize = 524288;
        int rom_base = Memory.PhysMake(49152, 0);
        Memory.phys_writeb(rom_base + 117, 32);
        Memory.phys_writeb(rom_base + 118, 84);
        Memory.phys_writeb(rom_base + 119, 115);
        Memory.phys_writeb(rom_base + 120, 101);
        Memory.phys_writeb(rom_base + 121, 110);
        Memory.phys_writeb(rom_base + 122, 103);
        Memory.phys_writeb(rom_base + 123, 32);
    }

    private static class SVGA_ET3K_DATA {
        public int store_3d4_1b;
        public int store_3d4_1c;
        public int store_3d4_1d;
        public int store_3d4_1e;
        public int store_3d4_1f;
        public int store_3d4_20;
        public int store_3d4_21;
        public int store_3d4_23;
        public int store_3d4_24;
        public int store_3d4_25;
        public int store_3c0_16;
        public int store_3c0_17;
        public int store_3c4_06;
        public int store_3c4_07;
        public int[] clockFreq = new int[8];
        public int biosMode;

        private SVGA_ET3K_DATA() {
        }
    }

    private static class SVGA_ET4K_DATA {
        public boolean extensionsEnabled = true;
        public int store_3d4_31;
        public int store_3d4_32;
        public int store_3d4_33;
        public int store_3d4_34;
        public int store_3d4_35;
        public int store_3d4_36;
        public int store_3d4_37;
        public int store_3d4_3f;
        public int store_3c0_16;
        public int store_3c0_17;
        public int store_3c4_06;
        public int store_3c4_07;
        public int[] clockFreq = new int[16];
        public int biosMode;

        private SVGA_ET4K_DATA() {
        }
    }
}

