/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.Dos_DTA;
import jdos.dos.Dos_files;
import jdos.dos.DriveManager;
import jdos.gui.Mapper;
import jdos.hardware.Cmos;
import jdos.hardware.Memory;
import jdos.misc.Log;
import jdos.util.FileIO;
import jdos.util.LongRef;

public class Bios_disk {
    public static final int BIOS_MAX_DISK = 10;
    public static final int MAX_SWAPPABLE_DISKS = 20;
    private static final int MAX_HDD_IMAGES = 2;
    private static final int MAX_DISK_IMAGES = 4;
    private static diskGeo[] DiskGeometryList = new diskGeo[]{new diskGeo(160L, 8, 1, 40, 0), new diskGeo(180L, 9, 1, 40, 0), new diskGeo(200L, 10, 1, 40, 0), new diskGeo(320L, 8, 2, 40, 1), new diskGeo(360L, 9, 2, 40, 1), new diskGeo(400L, 10, 2, 40, 1), new diskGeo(720L, 9, 2, 80, 3), new diskGeo(1200L, 15, 2, 80, 2), new diskGeo(1440L, 18, 2, 80, 4), new diskGeo(2880L, 36, 2, 80, 6), new diskGeo(0L, 0, 0, 0, 0)};
    private static int call_int13;
    private static int diskparm0;
    private static int diskparm1;
    private static short last_status;
    private static short last_drive;
    public static int imgDTASeg;
    public static int imgDTAPtr;
    public static Dos_DTA imgDTA;
    private static boolean killRead;
    private static boolean swapping_requested;
    public static imageDisk[] imageDiskList;
    public static imageDisk[] diskSwap;
    public static int swapPosition;
    private static Mapper.MAPPER_Handler swapInNextDisk;
    private static Callback.Handler INT13_DiskHandler;

    public static void updateDPT() {
        LongRef tmpheads = new LongRef(0L);
        LongRef tmpcyl = new LongRef(0L);
        LongRef tmpsect = new LongRef(0L);
        LongRef tmpsize = new LongRef(0L);
        if (imageDiskList[2] != null) {
            int dp0physaddr = Callback.CALLBACK_PhysPointer(diskparm0);
            imageDiskList[2].Get_Geometry(tmpheads, tmpcyl, tmpsect, tmpsize);
            Memory.phys_writew(dp0physaddr, (int)tmpcyl.value);
            Memory.phys_writeb(dp0physaddr + 2, (short)tmpheads.value);
            Memory.phys_writew(dp0physaddr + 3, 0);
            Memory.phys_writew(dp0physaddr + 5, -1);
            Memory.phys_writeb(dp0physaddr + 7, 0);
            Memory.phys_writeb(dp0physaddr + 8, (short)(0xC0 | (Bios_disk.imageDiskList[2].heads > 8L ? 1 : 0)));
            Memory.phys_writeb(dp0physaddr + 9, 0);
            Memory.phys_writeb(dp0physaddr + 10, 0);
            Memory.phys_writeb(dp0physaddr + 11, 0);
            Memory.phys_writew(dp0physaddr + 12, (int)tmpcyl.value);
            Memory.phys_writeb(dp0physaddr + 14, (short)tmpsect.value);
        }
        if (imageDiskList[3] != null) {
            int dp1physaddr = Callback.CALLBACK_PhysPointer(diskparm1);
            imageDiskList[3].Get_Geometry(tmpheads, tmpcyl, tmpsect, tmpsize);
            Memory.phys_writew(dp1physaddr, (int)tmpcyl.value);
            Memory.phys_writeb(dp1physaddr + 2, (short)tmpheads.value);
            Memory.phys_writeb(dp1physaddr + 14, (short)tmpsect.value);
        }
    }

    public static void swapInDisks() {
        boolean allNull = true;
        int diskcount = 0;
        int swapPos = swapPosition;
        for (int i = 0; i < 20; ++i) {
            if (diskSwap[i] == null) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            return;
        }
        while (diskcount < 2) {
            if (diskSwap[swapPos] != null) {
                Log.log_msg("Loaded disk " + diskcount + " from swaplist position " + swapPos + " - \"" + Bios_disk.diskSwap[swapPos].diskname + "\"");
                Bios_disk.imageDiskList[diskcount] = diskSwap[swapPos];
                ++diskcount;
            }
            if (++swapPos < 20) continue;
            swapPos = 0;
        }
    }

    public static boolean getSwapRequest() {
        boolean sreq = swapping_requested;
        swapping_requested = false;
        return sreq;
    }

    private static int GetDosDriveNumber(int biosNum) {
        switch (biosNum) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 128: {
                return 2;
            }
            case 129: {
                return 3;
            }
            case 130: {
                return 4;
            }
            case 131: {
                return 5;
            }
        }
        return 127;
    }

    static boolean driveInactive(int driveNum) {
        if (driveNum >= 4) {
            Log.log(19, 2, "Disk " + driveNum + " non-existant");
            last_status = 1;
            Callback.CALLBACK_SCF(true);
            return true;
        }
        if (imageDiskList[driveNum] == null) {
            Log.log(19, 2, "Disk " + driveNum + " not active");
            last_status = 1;
            Callback.CALLBACK_SCF(true);
            return true;
        }
        if (!Bios_disk.imageDiskList[driveNum].active) {
            Log.log(19, 2, "Disk " + driveNum + " not active");
            last_status = 1;
            Callback.CALLBACK_SCF(true);
            return true;
        }
        return false;
    }

    public static void BIOS_CloseDisks() {
        imageDiskList = null;
        diskSwap = null;
    }

    public static void BIOS_SetupDisks() {
        int i;
        imageDiskList = new imageDisk[4];
        diskSwap = new imageDisk[20];
        call_int13 = Callback.CALLBACK_Allocate();
        Callback.CALLBACK_Setup(call_int13, INT13_DiskHandler, 5, "Int 13 Bios disk");
        Memory.RealSetVec(19, Callback.CALLBACK_RealPointer(call_int13));
        for (i = 0; i < 4; ++i) {
            Bios_disk.imageDiskList[i] = null;
        }
        for (i = 0; i < 20; ++i) {
            Bios_disk.diskSwap[i] = null;
        }
        diskparm0 = Callback.CALLBACK_Allocate();
        diskparm1 = Callback.CALLBACK_Allocate();
        swapPosition = 0;
        Memory.RealSetVec(65, Callback.CALLBACK_RealPointer(diskparm0));
        Memory.RealSetVec(70, Callback.CALLBACK_RealPointer(diskparm1));
        int dp0physaddr = Callback.CALLBACK_PhysPointer(diskparm0);
        int dp1physaddr = Callback.CALLBACK_PhysPointer(diskparm1);
        for (i = 0; i < 16; ++i) {
            Memory.phys_writeb(dp0physaddr + i, 0);
            Memory.phys_writeb(dp1physaddr + i, 0);
        }
        imgDTASeg = 0;
        Memory.mem_writeb(1141, 2);
        Mapper.MAPPER_AddHandler(swapInNextDisk, 3, 1, "swapimg", "Swap Image");
        killRead = false;
        swapping_requested = false;
    }

    static {
        swapInNextDisk = new Mapper.MAPPER_Handler(){

            public void call(boolean pressed) {
                if (!pressed) {
                    return;
                }
                DriveManager.CycleAllDisks();
                Log.log_msg("Diskcaching reset for normal mounted drives.");
                for (int i = 0; i < 26; ++i) {
                    if (Dos_files.Drives[i] == null) continue;
                    Dos_files.Drives[i].EmptyCache();
                }
                if (diskSwap[++swapPosition] == null) {
                    swapPosition = 0;
                }
                Bios_disk.swapInDisks();
                swapping_requested = true;
            }
        };
        INT13_DiskHandler = new Callback.Handler(){

            public String getName() {
                return "Bios.INT13_DiskHandler";
            }

            public int call() {
                int i;
                byte[] sectbuf = new byte[512];
                last_drive = CPU_Regs.reg_edx.low();
                int drivenum = Bios_disk.GetDosDriveNumber(last_drive);
                boolean any_images = false;
                for (i = 0; i < 4; ++i) {
                    if (imageDiskList[i] == null) continue;
                    any_images = true;
                }
                Callback.CALLBACK_SIF(true);
                switch (CPU_Regs.reg_eax.high()) {
                    case 0: {
                        if (any_images && Bios_disk.driveInactive(drivenum)) {
                            if ((Dosbox.machine == 1 || Dosbox.machine == 3) && (imageDiskList[0] != null && Bios_disk.imageDiskList[0].active || imageDiskList[1] != null && Bios_disk.imageDiskList[1].active)) {
                                last_status = (short)0;
                                Callback.CALLBACK_SCF(false);
                            }
                            return 0;
                        }
                        last_status = (short)0;
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 1: {
                        if (last_status != 0) {
                            CPU_Regs.reg_eax.high(last_status);
                            Callback.CALLBACK_SCF(true);
                            break;
                        }
                        CPU_Regs.reg_eax.high(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 2: {
                        if (CPU_Regs.reg_eax.low() == 0) {
                            CPU_Regs.reg_eax.high(1);
                            Callback.CALLBACK_SCF(true);
                            return 0;
                        }
                        if (!any_images && (CPU_Regs.reg_edx.low() & 0x80) == 128 && CPU_Regs.reg_edx.high() == 0 && (CPU_Regs.reg_ecx.low() & 0x3F) == 1) {
                            CPU_Regs.reg_eax.high(0);
                            Callback.CALLBACK_SCF(false);
                            return 0;
                        }
                        if (Bios_disk.driveInactive(drivenum)) {
                            CPU_Regs.reg_eax.high(255);
                            Callback.CALLBACK_SCF(true);
                            return 0;
                        }
                        int segat = CPU.Segs_ESval;
                        int bufptr = CPU_Regs.reg_ebx.word();
                        for (i = 0; i < CPU_Regs.reg_eax.low(); ++i) {
                            last_status = imageDiskList[drivenum].Read_Sector(CPU_Regs.reg_edx.high(), CPU_Regs.reg_ecx.high() | (CPU_Regs.reg_ecx.low() & 0xC0) << 2, (CPU_Regs.reg_ecx.low() & 0x3F) + i, sectbuf);
                            if (last_status != 0 || killRead) {
                                Log.log_msg("Error in disk read");
                                killRead = false;
                                CPU_Regs.reg_eax.high(4);
                                Callback.CALLBACK_SCF(true);
                                return 0;
                            }
                            for (int t = 0; t < 512; ++t) {
                                Memory.real_writeb(segat, bufptr, sectbuf[t]);
                                ++bufptr;
                            }
                        }
                        CPU_Regs.reg_eax.high(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 3: {
                        if (Bios_disk.driveInactive(drivenum)) {
                            CPU_Regs.reg_eax.high(255);
                            Callback.CALLBACK_SCF(true);
                            return 0;
                        }
                        int bufptr = CPU_Regs.reg_ebx.word();
                        for (i = 0; i < CPU_Regs.reg_eax.low(); ++i) {
                            int t = 0;
                            while ((long)t < imageDiskList[drivenum].getSectSize()) {
                                sectbuf[t] = (byte)Memory.real_readb(CPU.Segs_ESval, bufptr);
                                ++bufptr;
                                ++t;
                            }
                            last_status = imageDiskList[drivenum].Write_Sector(CPU_Regs.reg_edx.high(), CPU_Regs.reg_ecx.high() | (CPU_Regs.reg_ecx.low() & 0xC0) << 2, (CPU_Regs.reg_ecx.low() & 0x3F) + i, sectbuf);
                            if (last_status == 0) continue;
                            Callback.CALLBACK_SCF(true);
                            return 0;
                        }
                        CPU_Regs.reg_eax.high(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 4: {
                        if (CPU_Regs.reg_eax.low() == 0) {
                            CPU_Regs.reg_eax.high(1);
                            Callback.CALLBACK_SCF(true);
                            return 0;
                        }
                        if (Bios_disk.driveInactive(drivenum)) {
                            return 0;
                        }
                        CPU_Regs.reg_eax.high(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 8: {
                        if (Bios_disk.driveInactive(drivenum)) {
                            last_status = (short)7;
                            CPU_Regs.reg_eax.high(last_status);
                            Callback.CALLBACK_SCF(true);
                            return 0;
                        }
                        CPU_Regs.reg_eax.word(0);
                        CPU_Regs.reg_ebx.low(imageDiskList[drivenum].GetBiosType());
                        LongRef tmpheads = new LongRef(0L);
                        LongRef tmpcyl = new LongRef(0L);
                        LongRef tmpsect = new LongRef(0L);
                        LongRef tmpsize = new LongRef(0L);
                        imageDiskList[drivenum].Get_Geometry(tmpheads, tmpcyl, tmpsect, tmpsize);
                        if (tmpcyl.value == 0L) {
                            Log.log(19, 2, "INT13 DrivParm: cylinder count zero!");
                        } else {
                            --tmpcyl.value;
                        }
                        if (tmpheads.value == 0L) {
                            Log.log(19, 2, "INT13 DrivParm: head count zero!");
                        } else {
                            --tmpheads.value;
                        }
                        CPU_Regs.reg_ecx.high((int)(tmpcyl.value & 0xFFL));
                        CPU_Regs.reg_ecx.low((int)(tmpcyl.value >> 2 & 0xC0L | tmpsect.value & 0x3FL));
                        CPU_Regs.reg_edx.high((int)tmpheads.value);
                        last_status = (short)0;
                        if ((CPU_Regs.reg_edx.low() & 0x80) != 0) {
                            CPU_Regs.reg_edx.low(0);
                            if (imageDiskList[2] != null) {
                                CPU_Regs.reg_edx.low(CPU_Regs.reg_edx.low() + 1);
                            }
                            if (imageDiskList[3] != null) {
                                CPU_Regs.reg_edx.low(CPU_Regs.reg_edx.low() + 1);
                            }
                        } else {
                            CPU_Regs.reg_edx.low(0);
                            if (imageDiskList[0] != null) {
                                CPU_Regs.reg_edx.low(CPU_Regs.reg_edx.low() + 1);
                            }
                            if (imageDiskList[1] != null) {
                                CPU_Regs.reg_edx.low(CPU_Regs.reg_edx.low() + 1);
                            }
                        }
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 17: {
                        CPU_Regs.reg_eax.high(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    case 23: {
                        killRead = true;
                        CPU_Regs.reg_eax.high(0);
                        Callback.CALLBACK_SCF(false);
                        break;
                    }
                    default: {
                        Log.log(19, 2, "INT13: Function " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " called on drive " + Integer.toString(CPU_Regs.reg_edx.low(), 16) + " (dos drive " + drivenum + ")");
                        CPU_Regs.reg_eax.high(255);
                        Callback.CALLBACK_SCF(true);
                    }
                }
                return 0;
            }
        };
    }

    public static class imageDisk {
        public boolean hardDrive;
        public boolean active;
        public FileIO diskimg;
        public String diskname;
        public short floppytype;
        public long sector_size = 512L;
        public long heads = 0L;
        public long cylinders = 0L;
        public long sectors = 0L;

        public short Read_Sector(long head, long cylinder, long sector, byte[] data) {
            long sectnum = (cylinder * this.heads + head) * this.sectors + sector - 1L;
            return this.Read_AbsoluteSector(sectnum, data, 0);
        }

        public short Read_AbsoluteSector(long sectnum, byte[] data, int off) {
            long bytenum = sectnum * this.sector_size;
            try {
                this.diskimg.seek(bytenum);
                this.diskimg.read(data, off, (int)this.sector_size);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }

        public short Write_Sector(long head, long cylinder, long sector, byte[] data) {
            long sectnum = (cylinder * this.heads + head) * this.sectors + sector - 1L;
            return this.Write_AbsoluteSector(sectnum, data, 0);
        }

        public short Write_AbsoluteSector(long sectnum, byte[] data, int off) {
            long bytenum = sectnum * this.sector_size;
            int ret = (int)this.sector_size;
            try {
                this.diskimg.seek(bytenum);
                this.diskimg.write(data, off, (int)this.sector_size);
            }
            catch (Exception e) {
                ret = 0;
                e.printStackTrace();
            }
            return (short)(ret > 0 ? 0 : 5);
        }

        public imageDisk(FileIO imgFile, String imgName, long imgSizeK, boolean isHardDisk) {
            this.diskimg = imgFile;
            this.diskname = imgName;
            this.active = false;
            this.hardDrive = isHardDisk;
            if (!isHardDisk) {
                int i = 0;
                boolean founddisk = false;
                while (DiskGeometryList[i].ksize != 0L) {
                    if (DiskGeometryList[i].ksize == imgSizeK || DiskGeometryList[i].ksize + 1L == imgSizeK) {
                        if (DiskGeometryList[i].ksize != imgSizeK) {
                            Log.log_msg("ImageLoader: image file with additional data, might not load!");
                        }
                        founddisk = true;
                        this.active = true;
                        this.floppytype = (short)i;
                        this.heads = DiskGeometryList[i].headscyl;
                        this.cylinders = DiskGeometryList[i].cylcount;
                        this.sectors = DiskGeometryList[i].secttrack;
                        break;
                    }
                    i = (short)(i + 1);
                }
                if (!founddisk) {
                    this.active = false;
                } else {
                    int equipment = Memory.mem_readw(1040);
                    if ((equipment & 1) != 0) {
                        int numofdisks = equipment >> 6 & 3;
                        if (++numofdisks > 1) {
                            numofdisks = 1;
                        }
                        equipment &= 0xFFFFFF3F;
                        equipment |= numofdisks << 6;
                    } else {
                        equipment |= 1;
                    }
                    Memory.mem_writew(1040, equipment);
                    Cmos.CMOS_SetRegister(20, (short)(equipment & 0xFF));
                }
            }
        }

        public void Set_Geometry(long setHeads, long setCyl, long setSect, long setSectSize) {
            this.heads = setHeads;
            this.cylinders = setCyl;
            this.sectors = setSect;
            this.sector_size = setSectSize;
            this.active = true;
        }

        public void Get_Geometry(LongRef getHeads, LongRef getCyl, LongRef getSect, LongRef getSectSize) {
            getHeads.value = this.heads;
            getCyl.value = this.cylinders;
            getSect.value = this.sectors;
            getSectSize.value = this.sector_size;
        }

        public short GetBiosType() {
            if (!this.hardDrive) {
                return (short)DiskGeometryList[this.floppytype].biosval;
            }
            return 0;
        }

        public long getSectSize() {
            return this.sector_size;
        }
    }

    public static class diskGeo {
        public long ksize;
        public int secttrack;
        public int headscyl;
        public int cylcount;
        public int biosval;

        public diskGeo(long ksize, int secttrack, int headscyl, int cylcount, int biosval) {
            this.ksize = ksize;
            this.secttrack = secttrack;
            this.headscyl = headscyl;
            this.cylcount = cylcount;
            this.biosval = biosval;
        }
    }
}

