/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.cpu.Paging;
import jdos.dos.DOS_Device;
import jdos.dos.Dos_devices;
import jdos.dos.Dos_tables;
import jdos.hardware.DMA;
import jdos.hardware.IO;
import jdos.hardware.Memory;
import jdos.ints.Bios;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.IntRef;
import jdos.util.LongRef;

public class EMS
extends Module_base {
    private static final int EMM_PAGEFRAME = 57344;
    private static final int EMM_PAGEFRAME4K = 224;
    private static final int EMM_MAX_HANDLES = 200;
    private static final int EMM_PAGE_SIZE = 16384;
    private static final int EMM_MAX_PAGES = 2048;
    private static final int EMM_MAX_PHYS = 4;
    private static final int EMM_VERSION = 64;
    private static final int EMM_MINOR_VERSION = 0;
    private static final int GEMMIS_VERSION = 1;
    private static final int EMM_SYSTEM_HANDLE = 0;
    private static final int NULL_HANDLE = 65535;
    private static final int NULL_PAGE = 65535;
    private static final int ENABLE_VCPI = 1;
    private static final int ENABLE_V86_STARTUP = 0;
    private static final int EMM_NO_ERROR = 0;
    private static final int EMM_SOFT_MAL = 128;
    private static final int EMM_HARD_MAL = 129;
    private static final int EMM_INVALID_HANDLE = 131;
    private static final int EMM_FUNC_NOSUP = 132;
    private static final int EMM_OUT_OF_HANDLES = 133;
    private static final int EMM_SAVEMAP_ERROR = 134;
    private static final int EMM_OUT_OF_PHYS = 135;
    private static final int EMM_OUT_OF_LOG = 136;
    private static final int EMM_ZERO_PAGES = 137;
    private static final int EMM_LOG_OUT_RANGE = 138;
    private static final int EMM_ILL_PHYS = 139;
    private static final int EMM_PAGE_MAP_SAVED = 141;
    private static final int EMM_NO_SAVED_PAGE_MAP = 142;
    private static final int EMM_INVALID_SUB = 143;
    private static final int EMM_FEAT_NOSUP = 145;
    private static final int EMM_MOVE_OVLAP = 146;
    private static final int EMM_MOVE_OVLAPI = 151;
    private static final int EMM_NOT_FOUND = 160;
    private static final EMM_Handle[] emm_handles = new EMM_Handle[200];
    private static final EMM_Mapping[] emm_mappings = new EMM_Mapping[4];
    private static final EMM_Mapping[] emm_segmentmappings = new EMM_Mapping[64];
    private static int GEMMIS_seg;
    private static Vcpi vcpi;
    private static Callback.Handler INT67_Handler;
    private static Callback.Handler VCPI_PM_Handler;
    private static Callback.Handler V86_Monitor;
    private static Callback.Handler INT4B_Handler;
    private DOS_Device emm_device = null;
    private static int ems_baseseg;
    private int old4b_pointer;
    private int old67_pointer;
    private Callback call_vdma = new Callback();
    private Callback call_vcpi = new Callback();
    private Callback call_v86mon = new Callback();
    int call_int67;
    int ems_type = 0;
    static EMS test;
    public static Section.SectionFunction EMS_ShutDown;
    public static Section.SectionFunction EMS_Init;

    private static int EMM_GetFreePages() {
        int count = Memory.MEM_FreeTotal() / 4;
        if (count > Short.MAX_VALUE) {
            count = Short.MAX_VALUE;
        }
        return count;
    }

    private static boolean ValidHandle(int handle) {
        if (handle >= 200) {
            return false;
        }
        return EMS.emm_handles[handle].pages != 65535;
    }

    private static short EMM_AllocateMemory(int pages, IntRef dhandle, boolean can_allocate_zpages) {
        if (pages == 0 && !can_allocate_zpages) {
            return 137;
        }
        if (Memory.MEM_FreeTotal() / 4 < pages) {
            return 136;
        }
        int handle = 1;
        while (EMS.emm_handles[handle].pages != 65535) {
            if (++handle < 200) continue;
            return 133;
        }
        int mem = 0;
        if (pages != 0 && (mem = Memory.MEM_AllocatePages(pages * 4, false)) == 0) {
            Log.exit("EMS:Memory allocation failure");
        }
        EMS.emm_handles[handle].pages = pages;
        EMS.emm_handles[handle].mem = mem;
        dhandle.value = handle;
        return 0;
    }

    private static short EMM_AllocateSystemHandle(int pages) {
        int mem;
        if (Memory.MEM_FreeTotal() / 4 < pages) {
            return 136;
        }
        int handle = 0;
        if (EMS.emm_handles[handle].pages != 65535) {
            Memory.MEM_ReleasePages(EMS.emm_handles[handle].mem);
        }
        if ((mem = Memory.MEM_AllocatePages(pages * 4, false)) == 0) {
            Log.exit("EMS:System handle memory allocation failure");
        }
        EMS.emm_handles[handle].pages = pages;
        EMS.emm_handles[handle].mem = mem;
        return 0;
    }

    static short EMM_ReallocatePages(int handle, int pages) {
        if (!EMS.ValidHandle(handle)) {
            return 131;
        }
        if (EMS.emm_handles[handle].pages != 0) {
            IntRef mem = new IntRef(EMS.emm_handles[handle].mem);
            if (!Memory.MEM_ReAllocatePages(mem, pages * 4, false)) {
                return 136;
            }
            EMS.emm_handles[handle].mem = mem.value;
        } else {
            int mem = Memory.MEM_AllocatePages(pages * 4, false);
            if (mem == 0) {
                Log.exit("EMS:Memory allocation failure during reallocation");
            }
            EMS.emm_handles[handle].mem = mem;
        }
        EMS.emm_handles[handle].pages = pages;
        return 0;
    }

    private static short EMM_MapPage(int phys_page, int handle, int log_page) {
        if (phys_page >= 4) {
            return 139;
        }
        if (log_page == 65535) {
            emm_mappings[phys_page].handle(65535);
            emm_mappings[phys_page].page(65535);
            for (int i = 0; i < 4; ++i) {
                Paging.PAGING_MapPage(224 + phys_page * 4 + i, 224 + phys_page * 4 + i);
            }
            Paging.PAGING_ClearTLB();
            return 0;
        }
        if (!EMS.ValidHandle(handle)) {
            return 131;
        }
        if (log_page < EMS.emm_handles[handle].pages) {
            emm_mappings[phys_page].handle(handle);
            emm_mappings[phys_page].page(log_page);
            int memh = Memory.MEM_NextHandleAt(EMS.emm_handles[handle].mem, log_page * 4);
            for (int i = 0; i < 4; ++i) {
                Paging.PAGING_MapPage(224 + phys_page * 4 + i, memh);
                memh = Memory.MEM_NextHandle(memh);
            }
            Paging.PAGING_ClearTLB();
            return 0;
        }
        return 138;
    }

    private static short EMM_MapSegment(int segment, int handle, int log_page) {
        if (segment >= 40960 && segment < 45056 || segment >= 53248 && segment < 61440) {
            int tphysPage = (segment - 57344) / 1024;
            if (log_page == 65535) {
                if (tphysPage >= 0 && tphysPage < 4) {
                    emm_mappings[tphysPage].handle(65535);
                    emm_mappings[tphysPage].page(65535);
                } else {
                    emm_segmentmappings[segment >> 10].handle(65535);
                    emm_segmentmappings[segment >> 10].page(65535);
                }
                for (int i = 0; i < 4; ++i) {
                    Paging.PAGING_MapPage(segment * 16 / 4096 + i, segment * 16 / 4096 + i);
                }
                Paging.PAGING_ClearTLB();
                return 0;
            }
            if (!EMS.ValidHandle(handle)) {
                return 131;
            }
            if (log_page < EMS.emm_handles[handle].pages) {
                if (tphysPage >= 0 && tphysPage < 4) {
                    emm_mappings[tphysPage].handle(handle);
                    emm_mappings[tphysPage].page(log_page);
                } else {
                    emm_segmentmappings[segment >> 10].handle(handle);
                    emm_segmentmappings[segment >> 10].page(log_page);
                }
                int memh = Memory.MEM_NextHandleAt(EMS.emm_handles[handle].mem, log_page * 4);
                for (int i = 0; i < 4; ++i) {
                    Paging.PAGING_MapPage(segment * 16 / 4096 + i, memh);
                    memh = Memory.MEM_NextHandle(memh);
                }
                Paging.PAGING_ClearTLB();
                return 0;
            }
            return 138;
        }
        return 139;
    }

    private static short EMM_ReleaseMemory(int handle) {
        if (!EMS.ValidHandle(handle)) {
            return 131;
        }
        if (EMS.emm_handles[handle].pages != 0) {
            Memory.MEM_ReleasePages(EMS.emm_handles[handle].mem);
        }
        EMS.emm_handles[handle].mem = 0;
        EMS.emm_handles[handle].pages = handle == 0 ? 0 : 65535;
        EMS.emm_handles[handle].saved_page_map = false;
        EMS.emm_handles[handle].name = "";
        return 0;
    }

    private static short EMM_SavePageMap(int handle) {
        if ((handle >= 200 || EMS.emm_handles[handle].pages == 65535) && handle != 0) {
            return 131;
        }
        if (EMS.emm_handles[handle].saved_page_map) {
            return 141;
        }
        for (int i = 0; i < 4; ++i) {
            EMS.emm_handles[handle].page_map[i].page(emm_mappings[i].page());
            EMS.emm_handles[handle].page_map[i].handle(emm_mappings[i].handle());
        }
        EMS.emm_handles[handle].saved_page_map = true;
        return 0;
    }

    private static short EMM_RestoreMappingTable() {
        int i;
        for (i = 0; i < 64; ++i) {
            if (i >= 56 && i < 60) continue;
            short s = EMS.EMM_MapSegment(i << 10, emm_segmentmappings[i].handle(), emm_segmentmappings[i].page());
        }
        for (i = 0; i < 4; ++i) {
            short result = EMS.EMM_MapPage(i, emm_mappings[i].handle(), emm_mappings[i].page());
        }
        return 0;
    }

    private static short EMM_RestorePageMap(int handle) {
        if ((handle >= 200 || EMS.emm_handles[handle].pages == 65535) && handle != 0) {
            return 131;
        }
        if (!EMS.emm_handles[handle].saved_page_map) {
            return 142;
        }
        EMS.emm_handles[handle].saved_page_map = false;
        for (int i = 0; i < 4; ++i) {
            emm_mappings[i].page(EMS.emm_handles[handle].page_map[i].page());
            emm_mappings[i].handle(EMS.emm_handles[handle].page_map[i].handle());
        }
        return EMS.EMM_RestoreMappingTable();
    }

    private static short EMM_GetPagesForAllHandles(int table, IntRef handles) {
        handles.value = 0;
        for (int i = 0; i < 200; ++i) {
            if (EMS.emm_handles[i].pages == 65535) continue;
            ++handles.value;
            Memory.mem_writew(table, i);
            Memory.mem_writew(table + 2, EMS.emm_handles[i].pages);
            table += 4;
        }
        return 0;
    }

    private static short EMM_PartialPageMapping() {
        switch (CPU_Regs.reg_eax.low()) {
            case 0: {
                int list = CPU.Segs_DSphys + CPU_Regs.reg_esi.word();
                int data = CPU.Segs_ESphys + CPU_Regs.reg_edi.word();
                int count = Memory.mem_readw(list);
                list += 2;
                Memory.mem_writew(data, count);
                data += 2;
                while (count > 0) {
                    int segment = Memory.mem_readw(list);
                    list += 2;
                    if (segment >= 57344 && segment < 61440) {
                        int page = (segment - 57344) / 1024;
                        Memory.mem_writew(data, segment);
                        Memory.MEM_BlockWrite(data += 2, EMS.emm_mappings[page].data, 4);
                        data += 4;
                    } else if (segment >= 53248 && segment < 57344 || segment >= 40960 && segment < 45056) {
                        Memory.mem_writew(data, segment);
                        Memory.MEM_BlockWrite(data += 2, EMS.emm_segmentmappings[segment >> 10].data, 4);
                        data += 4;
                    } else {
                        return 139;
                    }
                    --count;
                }
                break;
            }
            case 1: {
                int data = CPU.Segs_DSphys + CPU_Regs.reg_esi.word();
                int count = Memory.mem_readw(data);
                data += 2;
                while (count > 0) {
                    int segment = Memory.mem_readw(data);
                    data += 2;
                    if (segment >= 57344 && segment < 61440) {
                        int page = (segment - 57344) / 1024;
                        Memory.MEM_BlockRead(data, EMS.emm_mappings[page].data, 4);
                    } else if (segment >= 53248 && segment < 57344 || segment >= 40960 && segment < 45056) {
                        Memory.MEM_BlockRead(data, EMS.emm_segmentmappings[segment >> 10].data, 4);
                    } else {
                        return 139;
                    }
                    data += 4;
                    --count;
                }
                return EMS.EMM_RestoreMappingTable();
            }
            case 2: {
                CPU_Regs.reg_eax.low((short)(2 + CPU_Regs.reg_ebx.word() * 6));
                break;
            }
            default: {
                Log.log(21, 2, "EMS:Call " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
                return 132;
            }
        }
        return 0;
    }

    private static short HandleNameSearch() {
        int handle = 0;
        switch (CPU_Regs.reg_eax.low()) {
            case 0: {
                CPU_Regs.reg_eax.low(0);
                int data = CPU.Segs_ESphys + CPU_Regs.reg_edi.word();
                for (handle = 0; handle < 200; ++handle) {
                    if (EMS.emm_handles[handle].pages == 65535) continue;
                    CPU_Regs.reg_eax.low(CPU_Regs.reg_eax.low() + 1);
                    Memory.mem_writew(data, handle);
                    Memory.MEM_BlockWrite(data + 2, EMS.emm_handles[handle].name, 8);
                    data += 10;
                }
                break;
            }
            case 1: {
                String name = Memory.MEM_StrCopy(CPU.Segs_DSphys + CPU_Regs.reg_esi.word(), 8);
                for (handle = 0; handle < 200; ++handle) {
                    if (EMS.emm_handles[handle].pages == 65535 || !name.equalsIgnoreCase(EMS.emm_handles[handle].name)) continue;
                    CPU_Regs.reg_edx.word(handle);
                    return 0;
                }
                return 160;
            }
            case 2: {
                CPU_Regs.reg_ebx.word(200);
                break;
            }
            default: {
                Log.log(21, 2, "EMS:Call " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
                return 143;
            }
        }
        return 0;
    }

    private static short GetSetHandleName() {
        int handle = CPU_Regs.reg_edx.word();
        switch (CPU_Regs.reg_eax.low()) {
            case 0: {
                if (handle >= 200 || EMS.emm_handles[handle].pages == 65535) {
                    return 131;
                }
                Memory.MEM_BlockWrite(CPU.Segs_ESphys + CPU_Regs.reg_edi.word(), EMS.emm_handles[handle].name, 8);
                break;
            }
            case 1: {
                if (handle >= 200 || EMS.emm_handles[handle].pages == 65535) {
                    return 131;
                }
                EMS.emm_handles[handle].name = Memory.MEM_BlockRead(CPU.Segs_ESphys + CPU_Regs.reg_edi.word(), 8);
                break;
            }
            default: {
                Log.log(21, 2, "EMS:Call " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
                return 143;
            }
        }
        return 0;
    }

    private static void LoadMoveRegion(int data, MoveRegion region) {
        region.bytes = Memory.mem_readd(data + 0);
        region.src_type = Memory.mem_readb(data + 4);
        region.src_handle = Memory.mem_readw(data + 5);
        region.src_offset = Memory.mem_readw(data + 7);
        region.src_page_seg = Memory.mem_readw(data + 9);
        region.dest_type = Memory.mem_readb(data + 11);
        region.dest_handle = Memory.mem_readw(data + 12);
        region.dest_offset = Memory.mem_readw(data + 14);
        region.dest_page_seg = Memory.mem_readw(data + 16);
    }

    private static short MemoryRegion() {
        int pages;
        MoveRegion region = new MoveRegion();
        byte[] buf_src = new byte[4096];
        byte[] buf_dest = new byte[4096];
        if (CPU_Regs.reg_eax.low() > 1) {
            Log.log(21, 2, "EMS:Call " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
            return 132;
        }
        EMS.LoadMoveRegion(CPU.Segs_DSphys + CPU_Regs.reg_esi.word(), region);
        int src_mem = 0;
        int dest_mem = 0;
        int src_handle = 0;
        int dest_handle = 0;
        int src_off = 0;
        int dest_off = 0;
        int src_remain = 0;
        int dest_remain = 0;
        if (region.src_type == 0) {
            src_mem = region.src_page_seg * 16 + region.src_offset;
        } else {
            if (!EMS.ValidHandle(region.src_handle)) {
                return 131;
            }
            if ((long)(EMS.emm_handles[region.src_handle].pages * 16384) < (long)(region.src_page_seg * 16384 + region.src_offset) + region.bytes) {
                return 138;
            }
            src_handle = EMS.emm_handles[region.src_handle].mem;
            for (pages = region.src_page_seg * 4 + region.src_offset / 4096; pages > 0; --pages) {
                src_handle = Memory.MEM_NextHandle(src_handle);
            }
            src_off = region.src_offset & 0xFFF;
            src_remain = 4096 - src_off;
        }
        if (region.dest_type == 0) {
            dest_mem = region.dest_page_seg * 16 + region.dest_offset;
        } else {
            if (!EMS.ValidHandle(region.dest_handle)) {
                return 131;
            }
            if ((long)(EMS.emm_handles[region.dest_handle].pages * 16384) < (long)(region.dest_page_seg * 16384 + region.dest_offset) + region.bytes) {
                return 138;
            }
            dest_handle = EMS.emm_handles[region.dest_handle].mem;
            for (pages = region.dest_page_seg * 4 + region.dest_offset / 4096; pages > 0; --pages) {
                dest_handle = Memory.MEM_NextHandle(dest_handle);
            }
            dest_off = region.dest_offset & 0xFFF;
            dest_remain = 4096 - dest_off;
        }
        while (region.bytes > 0L) {
            int toread = region.bytes > 4096L ? 4096 : (int)region.bytes;
            if (region.src_type == 0) {
                Memory.MEM_BlockRead(src_mem, buf_src, toread);
            } else if (toread < src_remain) {
                Memory.MEM_BlockRead(src_handle * 4096 + src_off, buf_src, toread);
            } else {
                Memory.MEM_BlockRead(src_handle * 4096 + src_off, buf_src, src_remain);
                Memory.MEM_BlockRead(Memory.MEM_NextHandle(src_handle) * 4096, buf_src, src_remain, toread - src_remain);
            }
            if (CPU_Regs.reg_eax.low() == 1) {
                if (region.dest_type == 0) {
                    Memory.MEM_BlockRead(dest_mem, buf_dest, toread);
                } else if (toread < dest_remain) {
                    Memory.MEM_BlockRead(dest_handle * 4096 + dest_off, buf_dest, toread);
                } else {
                    Memory.MEM_BlockRead(dest_handle * 4096 + dest_off, buf_dest, dest_remain);
                    Memory.MEM_BlockRead(Memory.MEM_NextHandle(dest_handle) * 4096, buf_dest, dest_remain, toread - dest_remain);
                }
                if (region.src_type == 0) {
                    Memory.MEM_BlockWrite(src_mem, buf_dest, toread);
                } else if (toread < src_remain) {
                    Memory.MEM_BlockWrite(src_handle * 4096 + src_off, buf_dest, toread);
                } else {
                    Memory.MEM_BlockWrite(src_handle * 4096 + src_off, buf_dest, src_remain);
                    Memory.MEM_BlockWrite(Memory.MEM_NextHandle(src_handle) * 4096, buf_dest, src_remain, toread - src_remain);
                }
            }
            if (region.dest_type == 0) {
                Memory.MEM_BlockWrite(dest_mem, buf_src, toread);
            } else if (toread < dest_remain) {
                Memory.MEM_BlockWrite(dest_handle * 4096 + dest_off, buf_src, toread);
            } else {
                Memory.MEM_BlockWrite(dest_handle * 4096 + dest_off, buf_src, dest_remain);
                Memory.MEM_BlockWrite(Memory.MEM_NextHandle(dest_handle) * 4096, buf_src, dest_remain, toread - dest_remain);
            }
            if (region.src_type == 0) {
                src_mem += toread;
            } else {
                src_handle = Memory.MEM_NextHandle(src_handle);
            }
            if (region.dest_type == 0) {
                dest_mem += toread;
            } else {
                dest_handle = Memory.MEM_NextHandle(dest_handle);
            }
            region.bytes -= (long)toread;
        }
        return 0;
    }

    private static void SetupVCPI() {
        EMS.vcpi.enabled = false;
        EMS.vcpi.ems_handle = 0;
        EMS.vcpi.enabled = true;
        EMS.vcpi.pic1_remapping = (short)8;
        EMS.vcpi.pic2_remapping = (short)112;
        EMS.vcpi.private_area = EMS.emm_handles[EMS.vcpi.ems_handle].mem << 12;
        Memory.mem_writed(EMS.vcpi.private_area + 0, 0);
        Memory.mem_writed(EMS.vcpi.private_area + 4, 0);
        int ldt_address = EMS.vcpi.private_area + 4096;
        int ldt_limit = 255;
        int ldt_desc_part = (ldt_address & 0xFFFF) << 16 | ldt_limit;
        Memory.mem_writed(EMS.vcpi.private_area + 8, ldt_desc_part);
        ldt_desc_part = (ldt_address & 0xFF0000) >> 16 | ldt_address & 0xFF000000 | 0x8200;
        Memory.mem_writed(EMS.vcpi.private_area + 12, ldt_desc_part);
        int tss_address = EMS.vcpi.private_area + 12288;
        int tss_desc_part = (tss_address & 0xFFFF) << 16 | 0x268;
        Memory.mem_writed(EMS.vcpi.private_area + 16, tss_desc_part);
        tss_desc_part = (tss_address & 0xFF0000) >> 16 | tss_address & 0xFF000000 | 0x8900;
        Memory.mem_writed(EMS.vcpi.private_area + 20, tss_desc_part);
        Memory.mem_writed(EMS.vcpi.private_area + 4096, 0);
        Memory.mem_writed(EMS.vcpi.private_area + 4100, 0);
        int cs_desc_part = (EMS.vcpi.private_area & 0xFFFF) << 16 | 0xFFFF;
        Memory.mem_writed(EMS.vcpi.private_area + 4104, cs_desc_part);
        cs_desc_part = (EMS.vcpi.private_area & 0xFF0000) >> 16 | EMS.vcpi.private_area & 0xFF000000 | 0x9A00;
        Memory.mem_writed(EMS.vcpi.private_area + 4108, cs_desc_part);
        int ds_desc_part = (EMS.vcpi.private_area & 0xFFFF) << 16 | 0xFFFF;
        Memory.mem_writed(EMS.vcpi.private_area + 4112, ds_desc_part);
        ds_desc_part = (EMS.vcpi.private_area & 0xFF0000) >> 16 | EMS.vcpi.private_area & 0xFF000000 | 0x9200;
        Memory.mem_writed(EMS.vcpi.private_area + 4116, ds_desc_part);
        for (int int_ct = 0; int_ct < 256; ++int_ct) {
            Memory.mem_writeb(EMS.vcpi.private_area + 10240 + int_ct * 4 + 0, 232);
            Memory.mem_writew(EMS.vcpi.private_area + 10240 + int_ct * 4 + 1, 1533 - int_ct * 4);
            Memory.mem_writeb(EMS.vcpi.private_area + 10240 + int_ct * 4 + 3, 207);
            Memory.mem_writed(EMS.vcpi.private_area + 8192 + int_ct * 8 + 0, 0xC0000 | 10240 + int_ct * 4);
            Memory.mem_writed(EMS.vcpi.private_area + 8192 + int_ct * 8 + 4, 60928);
        }
        for (int tse_ct = 0; tse_ct < 616; ++tse_ct) {
            Memory.mem_writeb(EMS.vcpi.private_area + 12288, 0);
        }
        Memory.mem_writed(EMS.vcpi.private_area + 12292, 8192);
        Memory.mem_writed(EMS.vcpi.private_area + 12296, 20);
        Memory.mem_writed(EMS.vcpi.private_area + 12390, 104);
    }

    static int GetEMSType(Section_prop section) {
        int rtype = 0;
        String emstypestr = section.Get_string("ems");
        rtype = emstypestr.equalsIgnoreCase("true") ? 1 : (emstypestr.equalsIgnoreCase("emsboard") ? 2 : (emstypestr.equalsIgnoreCase("emm386") ? 3 : 0));
        return rtype;
    }

    EMS(Section configuration) {
        super(configuration);
        int i;
        this.call_vdma.Install(INT4B_Handler, 3, "Int 4b vdma");
        this.call_vdma.Set_RealVec(75);
        EMS.vcpi.enabled = false;
        GEMMIS_seg = 0;
        Section_prop section = (Section_prop)configuration;
        this.ems_type = EMS.GetEMSType(section);
        if (this.ems_type <= 0) {
            return;
        }
        if (Dosbox.machine == 3) {
            this.ems_type = 0;
            Log.log_msg("EMS disabled for PCJr machine");
            return;
        }
        Bios.BIOS_ZeroExtendedSize(true);
        if (ems_baseseg == 0) {
            ems_baseseg = Dos_tables.DOS_GetMemory(2);
        }
        String emsname = "EMMXXXX0";
        Memory.MEM_BlockWrite(Memory.PhysMake(ems_baseseg, 10), emsname, emsname.length() + 1);
        this.call_int67 = Callback.CALLBACK_Allocate();
        Callback.CALLBACK_Setup(this.call_int67, INT67_Handler, 3, Memory.PhysMake(ems_baseseg, 4), "Int 67 ems");
        IntRef o = new IntRef(this.old67_pointer);
        Memory.RealSetVec(103, Memory.RealMake(ems_baseseg, 4), o);
        this.old67_pointer = o.value;
        this.emm_device = new device_EMM(this.ems_type != 2);
        Dos_devices.DOS_AddDevice(this.emm_device);
        for (i = 0; i < 200; ++i) {
            EMS.emm_handles[i].mem = 0;
            EMS.emm_handles[i].pages = 65535;
            EMS.emm_handles[i].name = "";
        }
        for (i = 0; i < 4; ++i) {
            emm_mappings[i].page(65535);
            emm_mappings[i].handle(65535);
        }
        for (i = 0; i < 64; ++i) {
            emm_segmentmappings[i].page(65535);
            emm_segmentmappings[i].handle(65535);
        }
        EMS.EMM_AllocateSystemHandle(8);
        if (this.ems_type == 3) {
            DMA.DMA_SetWrapping(-1);
        }
        if (this.ems_type != 2) {
            this.call_vcpi.Install(VCPI_PM_Handler, 4, "VCPI PM");
            EMS.vcpi.pm_interface = this.call_vcpi.Get_callback() * 32;
            EMS.SetupVCPI();
            if (!EMS.vcpi.enabled) {
                return;
            }
            this.call_v86mon.Install(V86_Monitor, 3, "V86 Monitor");
            Memory.mem_writeb(EMS.vcpi.private_area + 11776, 254);
            Memory.mem_writeb(EMS.vcpi.private_area + 11777, 56);
            Memory.mem_writew(EMS.vcpi.private_area + 11778, this.call_v86mon.Get_callback());
            Memory.mem_writeb(EMS.vcpi.private_area + 11780, 102);
            Memory.mem_writeb(EMS.vcpi.private_area + 11781, 207);
        }
    }

    void close() {
        if (this.ems_type <= 0) {
            return;
        }
        Bios.BIOS_ZeroExtendedSize(false);
        if (this.emm_device != null) {
            Dos_devices.DOS_DelDevice(this.emm_device);
            this.emm_device = null;
        }
        GEMMIS_seg = 0;
        byte[] buf = new byte[32];
        Memory.MEM_BlockWrite(Memory.PhysMake(ems_baseseg, 0), buf, 32);
        Memory.RealSetVec(103, this.old67_pointer);
        if (EMS.emm_handles[0].pages != 65535) {
            Memory.MEM_ReleasePages(EMS.emm_handles[0].mem);
        }
        if (!EMS.vcpi.enabled) {
            return;
        }
        if (CPU.cpu.pmode && CPU_Regs.GETFLAG(131072) != 0) {
            CPU.CPU_SET_CRX(0, 0);
            CPU.CPU_SET_CRX(3, 0);
            CPU_Regs.flags &= 0xFFFDCFFF;
            CPU.CPU_LIDT(1023, 0);
            CPU.CPU_SetCPL(0);
        }
    }

    static {
        vcpi = new Vcpi();
        INT67_Handler = new Callback.Handler(){

            public String getName() {
                return "EMS.INT67_Handler";
            }

            public int call() {
                block0 : switch (CPU_Regs.reg_eax.high()) {
                    case 64: {
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 65: {
                        CPU_Regs.reg_ebx.word(57344);
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 66: {
                        CPU_Regs.reg_edx.word(Memory.MEM_TotalPages() / 4);
                        CPU_Regs.reg_ebx.word(EMS.EMM_GetFreePages());
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 67: {
                        IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                        CPU_Regs.reg_eax.high(EMS.EMM_AllocateMemory(CPU_Regs.reg_ebx.word(), dx, false));
                        CPU_Regs.reg_edx.word(dx.value);
                        break;
                    }
                    case 68: {
                        CPU_Regs.reg_eax.high(EMS.EMM_MapPage(CPU_Regs.reg_eax.low(), CPU_Regs.reg_edx.word(), CPU_Regs.reg_ebx.word()));
                        break;
                    }
                    case 69: {
                        CPU_Regs.reg_eax.high(EMS.EMM_ReleaseMemory(CPU_Regs.reg_edx.word()));
                        break;
                    }
                    case 70: {
                        CPU_Regs.reg_eax.high(0);
                        CPU_Regs.reg_eax.low(64);
                        break;
                    }
                    case 71: {
                        CPU_Regs.reg_eax.high(EMS.EMM_SavePageMap(CPU_Regs.reg_edx.word()));
                        break;
                    }
                    case 72: {
                        CPU_Regs.reg_eax.high(EMS.EMM_RestorePageMap(CPU_Regs.reg_edx.word()));
                        break;
                    }
                    case 75: {
                        CPU_Regs.reg_ebx.word(0);
                        for (int i = 0; i < 200; ++i) {
                            if (emm_handles[i].pages == 65535) continue;
                            CPU_Regs.reg_ebx.word(CPU_Regs.reg_ebx.word() + 1);
                        }
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 76: {
                        if (!EMS.ValidHandle(CPU_Regs.reg_edx.word())) {
                            CPU_Regs.reg_eax.high(131);
                            break;
                        }
                        CPU_Regs.reg_ebx.word(emm_handles[CPU_Regs.reg_edx.word()].pages);
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 77: {
                        IntRef bx = new IntRef(CPU_Regs.reg_ebx.word());
                        CPU_Regs.reg_eax.high(EMS.EMM_GetPagesForAllHandles(CPU.Segs_ESphys + CPU_Regs.reg_edi.word(), bx));
                        CPU_Regs.reg_ebx.word(bx.value);
                        break;
                    }
                    case 78: {
                        switch (CPU_Regs.reg_eax.low()) {
                            case 0: {
                                int offset = CPU.Segs_ESphys + CPU_Regs.reg_edi.word();
                                for (int j = 0; j < emm_mappings.length; ++j) {
                                    Memory.MEM_BlockWrite(offset + j * 4, emm_mappings[j].data, 4);
                                }
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 1: {
                                int offset = CPU.Segs_DSphys + CPU_Regs.reg_esi.word();
                                for (int j = 0; j < emm_mappings.length; ++j) {
                                    Memory.MEM_BlockRead(offset + j * 4, emm_mappings[j].data, 4);
                                }
                                CPU_Regs.reg_eax.high(EMS.EMM_RestoreMappingTable());
                                break block0;
                            }
                            case 2: {
                                int j;
                                int offset = CPU.Segs_ESphys + CPU_Regs.reg_edi.word();
                                for (j = 0; j < emm_mappings.length; ++j) {
                                    Memory.MEM_BlockWrite(offset + j * 4, emm_mappings[j].data, 4);
                                }
                                offset = CPU.Segs_DSphys + CPU_Regs.reg_esi.word();
                                for (j = 0; j < emm_mappings.length; ++j) {
                                    Memory.MEM_BlockRead(offset + j * 4, emm_mappings[j].data, 4);
                                }
                                CPU_Regs.reg_eax.high(EMS.EMM_RestoreMappingTable());
                                break block0;
                            }
                            case 3: {
                                CPU_Regs.reg_eax.low(4 * emm_mappings.length);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                        }
                        Log.log(21, 2, "EMS:Call " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
                        CPU_Regs.reg_eax.high(143);
                        break;
                    }
                    case 79: {
                        CPU_Regs.reg_eax.high(EMS.EMM_PartialPageMapping());
                        break;
                    }
                    case 80: {
                        CPU_Regs.reg_eax.high(0);
                        block30 : switch (CPU_Regs.reg_eax.low()) {
                            case 0: {
                                int data = CPU.Segs_DSphys + CPU_Regs.reg_esi.word();
                                for (int i = 0; i < CPU_Regs.reg_ecx.word(); ++i) {
                                    int logPage = Memory.mem_readw(data);
                                    int physPage = Memory.mem_readw(data += 2);
                                    data += 2;
                                    CPU_Regs.reg_eax.high(EMS.EMM_MapPage(physPage, CPU_Regs.reg_edx.word(), logPage));
                                    if (CPU_Regs.reg_eax.high() != 0) break block30;
                                }
                                break block0;
                            }
                            case 1: {
                                int data = CPU.Segs_DSphys + CPU_Regs.reg_esi.word();
                                for (int i = 0; i < CPU_Regs.reg_ecx.word(); ++i) {
                                    int logPage = Memory.mem_readw(data);
                                    CPU_Regs.reg_eax.high(EMS.EMM_MapSegment(Memory.mem_readw(data += 2), CPU_Regs.reg_edx.word(), logPage));
                                    data += 2;
                                    if (CPU_Regs.reg_eax.high() != 0) break block30;
                                }
                                break block0;
                            }
                            default: {
                                Log.log(21, 2, "EMS:Call " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " Subfunction " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
                                CPU_Regs.reg_eax.high(143);
                                break;
                            }
                        }
                        break;
                    }
                    case 81: {
                        CPU_Regs.reg_eax.high(EMS.EMM_ReallocatePages(CPU_Regs.reg_edx.word(), CPU_Regs.reg_ebx.word()));
                        break;
                    }
                    case 83: {
                        CPU_Regs.reg_eax.high(EMS.GetSetHandleName());
                        break;
                    }
                    case 84: {
                        CPU_Regs.reg_eax.high(EMS.HandleNameSearch());
                        break;
                    }
                    case 87: {
                        CPU_Regs.reg_eax.high(EMS.MemoryRegion());
                        if (CPU_Regs.reg_eax.high() == 0) break;
                        Log.log(21, 2, "EMS:Function 57 move failed");
                        break;
                    }
                    case 88: {
                        if (CPU_Regs.reg_eax.low() == 0) {
                            int data = CPU.Segs_ESphys + CPU_Regs.reg_edi.word();
                            int step = 1024;
                            for (int i = 0; i < 4; ++i) {
                                Memory.mem_writew(data, 57344 + step * i);
                                Memory.mem_writew(data += 2, i);
                                data += 2;
                            }
                        }
                        CPU_Regs.reg_ecx.word(4);
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 90: {
                        if (CPU_Regs.reg_eax.low() <= 1) {
                            IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                            CPU_Regs.reg_eax.high(EMS.EMM_AllocateMemory(CPU_Regs.reg_ebx.word(), dx, true));
                            CPU_Regs.reg_edx.word(dx.value);
                            break;
                        }
                        Log.log(21, 2, "EMS:Call 5A subfct " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
                        CPU_Regs.reg_eax.high(143);
                        break;
                    }
                    case 222: {
                        if (!vcpi.enabled) {
                            Log.log(21, 2, "EMS:VCPI Call " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " not supported");
                            CPU_Regs.reg_eax.high(132);
                            break;
                        }
                        switch (CPU_Regs.reg_eax.low()) {
                            case 0: {
                                if (CPU_Regs.reg_ecx.word() == 0 && CPU_Regs.reg_edi.word() == 18 || CPU.cpu.pmode && (CPU_Regs.flags & 0x20000) != 0) {
                                    CPU_Regs.reg_eax.high(0);
                                    CPU_Regs.reg_ebx.word(256);
                                    break block0;
                                }
                                CPU_Regs.reg_eax.high(132);
                                break block0;
                            }
                            case 1: {
                                int ct;
                                for (ct = 0; ct < 255; ++ct) {
                                    Memory.real_writeb(CPU.Segs_ESval, CPU_Regs.reg_edi.word() + ct * 4 + 0, 103);
                                    Memory.real_writew(CPU.Segs_ESval, CPU_Regs.reg_edi.word() + ct * 4 + 1, ct * 16);
                                    Memory.real_writeb(CPU.Segs_ESval, CPU_Regs.reg_edi.word() + ct * 4 + 3, 0);
                                }
                                for (ct = 255; ct < 256; ++ct) {
                                    Memory.real_writeb(CPU.Segs_ESval, CPU_Regs.reg_edi.word() + ct * 4 + 0, 103);
                                    Memory.real_writew(CPU.Segs_ESval, CPU_Regs.reg_edi.word() + ct * 4 + 1, (ct - 255) * 16 + 4352);
                                    Memory.real_writeb(CPU.Segs_ESval, CPU_Regs.reg_edi.word() + ct * 4 + 3, 0);
                                }
                                for (ct = 0; ct < 4; ++ct) {
                                    int handle = emm_mappings[ct].handle();
                                    if (handle == 65535) continue;
                                    int memh = Memory.MEM_NextHandleAt(emm_handles[handle].mem, emm_mappings[ct].page() * 4);
                                    int entry_addr = CPU_Regs.reg_edi.word() + 896 + ct * 16;
                                    Memory.real_writew(CPU.Segs_ESval, entry_addr + 0 + 1, (memh + 0) * 16);
                                    Memory.real_writew(CPU.Segs_ESval, entry_addr + 4 + 1, (memh + 1) * 16);
                                    Memory.real_writew(CPU.Segs_ESval, entry_addr + 8 + 1, (memh + 2) * 16);
                                    Memory.real_writew(CPU.Segs_ESval, entry_addr + 12 + 1, (memh + 3) * 16);
                                }
                                CPU_Regs.reg_edi.word(CPU_Regs.reg_edi.word() + 1024);
                                int cbseg_low = (Callback.CALLBACK_GetBase() & 0xFFFF) << 16;
                                int cbseg_high = (Callback.CALLBACK_GetBase() & 0x1F0000) >> 16;
                                Memory.real_writed(CPU.Segs_DSval, CPU_Regs.reg_esi.word() + 0, 0xFFFF | cbseg_low);
                                Memory.real_writed(CPU.Segs_DSval, CPU_Regs.reg_esi.word() + 4, 0x9A00 | cbseg_high);
                                Memory.real_writed(CPU.Segs_DSval, CPU_Regs.reg_esi.word() + 8, 65535);
                                Memory.real_writed(CPU.Segs_DSval, CPU_Regs.reg_esi.word() + 12, 37376);
                                Memory.real_writed(CPU.Segs_DSval, CPU_Regs.reg_esi.word() + 16, 65535);
                                Memory.real_writed(CPU.Segs_DSval, CPU_Regs.reg_esi.word() + 20, 37376);
                                CPU_Regs.reg_ebx.dword = vcpi.pm_interface & 0xFFFF;
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 2: {
                                CPU_Regs.reg_edx.dword = Memory.MEM_TotalPages() * 4096 - 1 & 0xFFFFF000;
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 3: {
                                CPU_Regs.reg_edx.dword = Memory.MEM_FreeTotal();
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 4: {
                                int mem = Memory.MEM_AllocatePages(1, false);
                                if (mem != 0) {
                                    CPU_Regs.reg_edx.dword = mem << 12;
                                    CPU_Regs.reg_eax.high(0);
                                    break block0;
                                }
                                CPU_Regs.reg_eax.high(136);
                                break block0;
                            }
                            case 5: {
                                Memory.MEM_ReleasePages(CPU_Regs.reg_edx.dword >>> 12);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 6: {
                                if (CPU_Regs.reg_ecx.word() << 8 >= 57344 && CPU_Regs.reg_ecx.word() << 8 < 61440) {
                                    int mem_seg = CPU_Regs.reg_ecx.word() << 8;
                                    int phys_page = mem_seg < 58368 ? 0 : (mem_seg < 59392 ? 1 : (mem_seg < 60416 ? 2 : 3));
                                    int handle = emm_mappings[phys_page].handle();
                                    if (handle == 65535) {
                                        CPU_Regs.reg_eax.high(139);
                                        break block0;
                                    }
                                    int memh = Memory.MEM_NextHandleAt(emm_handles[handle].mem, emm_mappings[phys_page].page() * 4);
                                    CPU_Regs.reg_edx.dword = memh + (CPU_Regs.reg_ecx.word() & 3) << 12;
                                } else {
                                    CPU_Regs.reg_edx.dword = CPU_Regs.reg_ecx.word() << 12;
                                }
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 10: {
                                CPU_Regs.reg_ebx.word(vcpi.pic1_remapping);
                                CPU_Regs.reg_ecx.word(vcpi.pic2_remapping);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 11: {
                                CPU_Regs.flags &= 0xFFFFFDFF;
                                vcpi.pic1_remapping = (short)(CPU_Regs.reg_ebx.word() & 0xFF);
                                vcpi.pic2_remapping = (short)(CPU_Regs.reg_ecx.word() & 0xFF);
                                CPU_Regs.reg_eax.high(0);
                                break block0;
                            }
                            case 12: {
                                CPU_Regs.flags &= 0xFFFFFDFF;
                                CPU.CPU_SetCPL(0);
                                int new_cr3 = Memory.mem_readd(CPU_Regs.reg_esi.dword);
                                int new_gdt_addr = Memory.mem_readd(CPU_Regs.reg_esi.dword + 4);
                                int new_idt_addr = Memory.mem_readd(CPU_Regs.reg_esi.dword + 8);
                                int new_ldt = Memory.mem_readw(CPU_Regs.reg_esi.dword + 12);
                                int new_tr = Memory.mem_readw(CPU_Regs.reg_esi.dword + 14);
                                int new_eip = Memory.mem_readd(CPU_Regs.reg_esi.dword + 16);
                                int new_cs = Memory.mem_readw(CPU_Regs.reg_esi.dword + 20);
                                int new_gdt_limit = Memory.mem_readw(new_gdt_addr);
                                int new_gdt_base = Memory.mem_readd(new_gdt_addr + 2);
                                int new_idt_limit = Memory.mem_readw(new_idt_addr);
                                int new_idt_base = Memory.mem_readd(new_idt_addr + 2);
                                long new_cr0 = CPU.CPU_GET_CRX(0) | 1;
                                if (new_cr3 != 0) {
                                    new_cr0 |= 0x80000000L;
                                }
                                CPU.CPU_SET_CRX(0, (int)new_cr0);
                                CPU.CPU_SET_CRX(3, new_cr3);
                                int tbaddr = new_gdt_base + (new_tr & 0xFFF8) + 5;
                                short tb = Memory.mem_readb(tbaddr);
                                Memory.mem_writeb(tbaddr, tb & 0xFD);
                                CPU.CPU_LGDT(new_gdt_limit, new_gdt_base);
                                CPU.CPU_LIDT(new_idt_limit, new_idt_base);
                                if (CPU.CPU_LLDT(new_ldt)) {
                                    Log.log_msg("VCPI:Could not load LDT with " + Integer.toString(new_ldt, 16));
                                }
                                if (CPU.CPU_LTR(new_tr)) {
                                    Log.log_msg("VCPI:Could not load TR with " + Integer.toString(new_tr, 16));
                                }
                                CPU.CPU_SetSegGeneralDS(0);
                                CPU.CPU_SetSegGeneralES(0);
                                CPU.CPU_SetSegGeneralFS(0);
                                CPU.CPU_SetSegGeneralGS(0);
                                CPU_Regs.flags &= 0xFFFDBFFF;
                                CPU_Regs.flags |= 0x3000;
                                CPU.CPU_JMP(true, new_cs, new_eip, 0);
                                break block0;
                            }
                        }
                        Log.log(21, 2, "EMS:VCPI Call " + Integer.toString(CPU_Regs.reg_eax.word(), 16) + " not supported");
                        CPU_Regs.reg_eax.high(132);
                        break;
                    }
                    default: {
                        Log.log(21, 2, "EMS:Call " + Integer.toString(CPU_Regs.reg_eax.high(), 16) + " not supported");
                        CPU_Regs.reg_eax.high(132);
                    }
                }
                return 0;
            }
        };
        VCPI_PM_Handler = new Callback.Handler(){

            public String getName() {
                return "EMS.VCPI_PM_Handler";
            }

            public int call() {
                switch (CPU_Regs.reg_eax.word()) {
                    case 56835: {
                        CPU_Regs.reg_edx.dword = Memory.MEM_FreeTotal();
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 56836: {
                        int mem = Memory.MEM_AllocatePages(1, false);
                        if (mem != 0) {
                            CPU_Regs.reg_edx.dword = mem << 12;
                            CPU_Regs.reg_eax.high(0);
                            break;
                        }
                        CPU_Regs.reg_eax.high(136);
                        break;
                    }
                    case 56837: {
                        Memory.MEM_ReleasePages(CPU_Regs.reg_edx.dword >>> 12);
                        CPU_Regs.reg_eax.high(0);
                        break;
                    }
                    case 56844: {
                        CPU_Regs.flags &= 0xFFFFFDFF;
                        Memory.mem_writed(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask) + 16, 143362);
                        CPU.CPU_SET_CRX(0, CPU.CPU_GET_CRX(0) & 0x7FFFFFF7);
                        CPU.CPU_SET_CRX(3, 0);
                        int tbaddr = vcpi.private_area + 0 + 16 + 5;
                        short tb = Memory.mem_readb(tbaddr);
                        Memory.mem_writeb(tbaddr, tb & 0xFD);
                        CPU.CPU_LGDT(255, vcpi.private_area + 0);
                        CPU.CPU_LIDT(2047, vcpi.private_area + 8192);
                        if (CPU.CPU_LLDT(8)) {
                            Log.log_msg("VCPI:Could not load LDT");
                        }
                        if (CPU.CPU_LTR(16)) {
                            Log.log_msg("VCPI:Could not load TR");
                        }
                        CPU_Regs.flags &= 0xFFFFBFFF;
                        CPU_Regs.reg_esp.dword += 8;
                        CPU.CPU_IRET(true, 0);
                        break;
                    }
                    default: {
                        Log.log(21, 1, "Unhandled VCPI-function " + Integer.toString(CPU_Regs.reg_eax.low(), 16) + " in protected mode");
                    }
                }
                return 0;
            }
        };
        V86_Monitor = new Callback.Handler(){

            public String getName() {
                return "EMS.V86_Monitor";
            }

            public int call() {
                int int_num = Memory.mem_readw(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask)) - 10243;
                if (int_num == 52 && (CPU_Regs.reg_esp.word() & 0xFFFF) != 8154) {
                    CPU_Regs.reg_esp.dword += 6;
                    int v86_cs = Memory.mem_readw(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 4 & CPU.cpu.stack.mask));
                    int v86_ip = Memory.mem_readw(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
                    short v86_opcode = Memory.mem_readb((v86_cs << 4) + v86_ip);
                    block0 : switch (v86_opcode) {
                        case 15: {
                            v86_opcode = Memory.mem_readb((v86_cs << 4) + v86_ip + 1);
                            switch (v86_opcode) {
                                case 32: {
                                    short rm_val = Memory.mem_readb((v86_cs << 4) + v86_ip + 2);
                                    int which = rm_val >> 3 & 7;
                                    if (rm_val < 192 || rm_val >= 232) {
                                        Log.exit("Invalid opcode 0x0f 0x20 " + Integer.toString(rm_val, 16) + " caused a protection fault!");
                                    }
                                    int crx = CPU.CPU_GET_CRX(which);
                                    switch (rm_val & 7) {
                                        case 0: {
                                            CPU_Regs.reg_eax.dword = crx;
                                            break;
                                        }
                                        case 1: {
                                            CPU_Regs.reg_ecx.dword = crx;
                                            break;
                                        }
                                        case 2: {
                                            CPU_Regs.reg_edx.dword = crx;
                                            break;
                                        }
                                        case 3: {
                                            CPU_Regs.reg_ebx.dword = crx;
                                            break;
                                        }
                                        case 4: {
                                            CPU_Regs.reg_esp.dword = crx;
                                            break;
                                        }
                                        case 5: {
                                            CPU_Regs.reg_ebp.dword = crx;
                                            break;
                                        }
                                        case 6: {
                                            CPU_Regs.reg_esi.dword = crx;
                                            break;
                                        }
                                        case 7: {
                                            CPU_Regs.reg_edi.dword = crx;
                                        }
                                    }
                                    Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 3);
                                    break block0;
                                }
                                case 34: {
                                    short rm_val = Memory.mem_readb((v86_cs << 4) + v86_ip + 2);
                                    int which = rm_val >> 3 & 7;
                                    if (rm_val < 192 || rm_val >= 232) {
                                        Log.exit("Invalid opcode 0x0f 0x22 " + Integer.toString(rm_val, 16) + " caused a protection fault!");
                                    }
                                    int crx = 0;
                                    switch (rm_val & 7) {
                                        case 0: {
                                            crx = CPU_Regs.reg_eax.dword;
                                            break;
                                        }
                                        case 1: {
                                            crx = CPU_Regs.reg_ecx.dword;
                                            break;
                                        }
                                        case 2: {
                                            crx = CPU_Regs.reg_edx.dword;
                                            break;
                                        }
                                        case 3: {
                                            crx = CPU_Regs.reg_ebx.dword;
                                            break;
                                        }
                                        case 4: {
                                            crx = CPU_Regs.reg_esp.dword;
                                            break;
                                        }
                                        case 5: {
                                            crx = CPU_Regs.reg_ebp.dword;
                                            break;
                                        }
                                        case 6: {
                                            crx = CPU_Regs.reg_esi.dword;
                                            break;
                                        }
                                        case 7: {
                                            crx = CPU_Regs.reg_edi.dword;
                                        }
                                    }
                                    if (which == 0) {
                                        crx |= 1;
                                    }
                                    CPU.CPU_SET_CRX(which, crx);
                                    Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 3);
                                    break block0;
                                }
                            }
                            Log.exit("Unhandled opcode 0x0f " + Integer.toString(v86_opcode, 16) + " caused a protection fault!");
                            break;
                        }
                        case 228: {
                            CPU_Regs.reg_eax.low((short)(IO.IO_ReadB(Memory.mem_readb((v86_cs << 4) + v86_ip + 1)) & 0xFF));
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 2);
                            break;
                        }
                        case 229: {
                            CPU_Regs.reg_eax.word(IO.IO_ReadW(Memory.mem_readb((v86_cs << 4) + v86_ip + 1)) & 0xFFFF);
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 2);
                            break;
                        }
                        case 230: {
                            IO.IO_WriteB(Memory.mem_readb((v86_cs << 4) + v86_ip + 1), CPU_Regs.reg_eax.low());
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 2);
                            break;
                        }
                        case 231: {
                            IO.IO_WriteW(Memory.mem_readb((v86_cs << 4) + v86_ip + 1), CPU_Regs.reg_eax.word());
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 2);
                            break;
                        }
                        case 236: {
                            CPU_Regs.reg_eax.low((short)(IO.IO_ReadB(CPU_Regs.reg_edx.word()) & 0xFF));
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 1);
                            break;
                        }
                        case 237: {
                            CPU_Regs.reg_eax.word(IO.IO_ReadW(CPU_Regs.reg_edx.word()) & 0xFFFF);
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 1);
                            break;
                        }
                        case 238: {
                            IO.IO_WriteB(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.low());
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 1);
                            break;
                        }
                        case 239: {
                            IO.IO_WriteW(CPU_Regs.reg_edx.word(), CPU_Regs.reg_eax.word());
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 1);
                            break;
                        }
                        case 240: {
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 1);
                            break;
                        }
                        case 244: {
                            CPU_Regs.flags |= 0x200;
                            CPU.CPU_HLT(CPU_Regs.reg_eip);
                            Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), v86_ip + 1);
                            break;
                        }
                        default: {
                            Log.exit("Unhandled opcode " + Integer.toString(v86_opcode, 16) + " caused a protection fault!");
                        }
                    }
                    return 0;
                }
                int vint_vector_seg = Memory.mem_readw(CPU.Segs_DSval + int_num + 2);
                int vint_vector_ofs = Memory.mem_readw(int_num);
                CPU_Regs.reg_esp.dword = CPU_Regs.reg_esp.word() != 8154 ? (CPU_Regs.reg_esp.dword += 14) : (CPU_Regs.reg_esp.dword += 2);
                int return_ip = Memory.mem_readw(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask));
                int return_cs = Memory.mem_readw(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 4 & CPU.cpu.stack.mask));
                int return_eflags = Memory.mem_readd(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 8 & CPU.cpu.stack.mask));
                Memory.mem_writed(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword & CPU.cpu.stack.mask), vint_vector_ofs);
                Memory.mem_writed(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 4 & CPU.cpu.stack.mask), vint_vector_seg);
                Memory.mem_writed(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 8 & CPU.cpu.stack.mask), return_eflags & 0xFFFFFCFF);
                int v86_ss = Memory.mem_readw(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 16 & CPU.cpu.stack.mask));
                int v86_sp = Memory.mem_readw(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 12 & CPU.cpu.stack.mask)) - 6;
                Memory.mem_writew(CPU.Segs_SSphys + (CPU_Regs.reg_esp.dword + 12 & CPU.cpu.stack.mask), v86_sp);
                Memory.mem_writew((v86_ss << 4) + v86_sp + 0, return_ip);
                Memory.mem_writew((v86_ss << 4) + v86_sp + 2, return_cs);
                Memory.mem_writew((v86_ss << 4) + v86_sp + 4, return_eflags & 0xFFFF);
                return 0;
            }
        };
        INT4B_Handler = new Callback.Handler(){

            public String getName() {
                return "EMS.INT4B_Handler";
            }

            public int call() {
                switch (CPU_Regs.reg_eax.high()) {
                    case 129: {
                        Callback.CALLBACK_SCF(true);
                        CPU_Regs.reg_eax.word(1);
                        break;
                    }
                    default: {
                        Log.log(21, 1, "Unhandled interrupt 4B function " + Integer.toString(CPU_Regs.reg_eax.high(), 16));
                    }
                }
                return 0;
            }
        };
        EMS_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                int i;
                test.close();
                test = null;
                for (i = 0; i < emm_handles.length; ++i) {
                    emm_handles[i] = null;
                }
                for (i = 0; i < emm_mappings.length; ++i) {
                    emm_mappings[i] = null;
                }
                for (i = 0; i < emm_segmentmappings.length; ++i) {
                    emm_segmentmappings[i] = null;
                }
            }
        };
        EMS_Init = new Section.SectionFunction(){

            public void call(Section section) {
                int i;
                for (i = 0; i < emm_handles.length; ++i) {
                    emm_handles[i] = new EMM_Handle();
                }
                for (i = 0; i < emm_mappings.length; ++i) {
                    emm_mappings[i] = new EMM_Mapping();
                }
                for (i = 0; i < emm_segmentmappings.length; ++i) {
                    emm_segmentmappings[i] = new EMM_Mapping();
                }
                test = new EMS(section);
                section.AddDestroyFunction(EMS_ShutDown, true);
            }
        };
    }

    private static class MoveRegion {
        long bytes;
        short src_type;
        int src_handle;
        int src_offset;
        int src_page_seg;
        short dest_type;
        int dest_handle;
        int dest_offset;
        int dest_page_seg;

        private MoveRegion() {
        }
    }

    private static class Vcpi {
        boolean enabled;
        int ems_handle;
        int pm_interface;
        int private_area;
        short pic1_remapping;
        short pic2_remapping;

        private Vcpi() {
        }
    }

    private static class device_EMM
    extends DOS_Device {
        private short cache;
        private boolean is_emm386;

        public device_EMM(boolean is_emm386_avail) {
            this.is_emm386 = is_emm386_avail;
            this.SetName("EMMXXXX0");
            GEMMIS_seg = 0;
        }

        public boolean Read(byte[] data, IntRef size) {
            return false;
        }

        public boolean Write(byte[] data, IntRef size) {
            Log.log(12, 0, "EMS:Write to device");
            return false;
        }

        public boolean Seek(LongRef pos, int type) {
            return false;
        }

        public boolean Close() {
            return false;
        }

        public int GetInformation() {
            return 49280;
        }

        public boolean ReadFromControlChannel(int bufptr, int size, IntRef retcode) {
            short subfct = Memory.mem_readb(bufptr);
            switch (subfct) {
                case 0: {
                    if (size != 6) {
                        return false;
                    }
                    Memory.mem_writew(bufptr + 0, 35);
                    Memory.mem_writed(bufptr + 2, 0);
                    retcode.value = 6;
                    return true;
                }
                case 1: {
                    int frct;
                    if (!this.is_emm386) {
                        return false;
                    }
                    if (size != 6) {
                        return false;
                    }
                    if (GEMMIS_seg == 0) {
                        GEMMIS_seg = Dos_tables.DOS_GetMemory(32);
                    }
                    int GEMMIS_addr = Memory.PhysMake(GEMMIS_seg, 0);
                    Memory.mem_writew(GEMMIS_addr + 0, 4);
                    Memory.mem_writew(GEMMIS_addr + 2, 413);
                    Memory.mem_writew(GEMMIS_addr + 4, 1);
                    Memory.mem_writed(GEMMIS_addr + 6, 0);
                    for (frct = 0; frct < 56; ++frct) {
                        Memory.mem_writeb(GEMMIS_addr + 10 + frct * 6, 0);
                        Memory.mem_writeb(GEMMIS_addr + 11 + frct * 6, 255);
                        Memory.mem_writew(GEMMIS_addr + 12 + frct * 6, 65535);
                        Memory.mem_writeb(GEMMIS_addr + 14 + frct * 6, 255);
                        Memory.mem_writeb(GEMMIS_addr + 15 + frct * 6, 170);
                    }
                    for (frct = 0; frct < 4; ++frct) {
                        int frnr = (frct + 56) * 6;
                        Memory.mem_writeb(GEMMIS_addr + 10 + frnr, 3);
                        Memory.mem_writeb(GEMMIS_addr + 11 + frnr, 255);
                        Memory.mem_writew(GEMMIS_addr + 12 + frnr, Short.MAX_VALUE);
                        Memory.mem_writeb(GEMMIS_addr + 14 + frnr, (short)(frct & 0xFF));
                        Memory.mem_writeb(GEMMIS_addr + 15 + frnr, 0);
                    }
                    for (frct = 60; frct < 60; ++frct) {
                        Memory.mem_writeb(GEMMIS_addr + 10 + frct * 6, 0);
                        Memory.mem_writeb(GEMMIS_addr + 11 + frct * 6, 255);
                        Memory.mem_writew(GEMMIS_addr + 12 + frct * 6, 65535);
                        Memory.mem_writeb(GEMMIS_addr + 14 + frct * 6, 255);
                        Memory.mem_writeb(GEMMIS_addr + 15 + frct * 6, 170);
                    }
                    Memory.mem_writeb(GEMMIS_addr + 394, 116);
                    Memory.mem_writeb(GEMMIS_addr + 395, 0);
                    Memory.mem_writeb(GEMMIS_addr + 396, 1);
                    Memory.mem_writew(GEMMIS_addr + 397, 0);
                    Memory.mem_writed(GEMMIS_addr + 399, 0);
                    Memory.mem_writed(GEMMIS_addr + 403, 0);
                    if (emm_handles[0].pages != 65535) {
                        Memory.mem_writew(GEMMIS_addr + 407, (emm_handles[0].pages + 3) / 4);
                        Memory.mem_writed(GEMMIS_addr + 409, emm_handles[0].mem << 12);
                    } else {
                        Memory.mem_writew(GEMMIS_addr + 407, 1);
                        Memory.mem_writed(GEMMIS_addr + 409, 0x110000);
                    }
                    Memory.mem_writed(bufptr + 0, GEMMIS_seg << 4);
                    Memory.mem_writew(bufptr + 4, 1);
                    retcode.value = 6;
                    return true;
                }
                case 2: {
                    if (!this.is_emm386) {
                        return false;
                    }
                    if (size != 2) {
                        return false;
                    }
                    Memory.mem_writeb(bufptr + 0, 4);
                    Memory.mem_writeb(bufptr + 1, 0);
                    retcode.value = 2;
                    return true;
                }
                case 3: {
                    if (!this.is_emm386) {
                        return false;
                    }
                    return false;
                }
            }
            return false;
        }

        public boolean WriteToControlChannel(int bufptr, int size, IntRef retcode) {
            return true;
        }
    }

    private static class EMM_Handle {
        int pages;
        int mem;
        String name = "";
        boolean saved_page_map;
        EMM_Mapping[] page_map = new EMM_Mapping[4];

        public EMM_Handle() {
            for (int i = 0; i < this.page_map.length; ++i) {
                this.page_map[i] = new EMM_Mapping();
            }
        }
    }

    private static class EMM_Mapping {
        static final int size = 4;
        byte[] data = new byte[4];

        private EMM_Mapping() {
        }

        int handle() {
            return this.data[0] & 0xFF | (this.data[1] & 0xFF) << 8;
        }

        int page() {
            return this.data[2] & 0xFF | (this.data[3] & 0xFF) << 8;
        }

        void handle(int val) {
            this.data[0] = (byte)(val & 0xFF);
            this.data[1] = (byte)(val >> 8 & 0xFF);
        }

        void page(int val) {
            this.data[2] = (byte)(val & 0xFF);
            this.data[3] = (byte)(val >> 8 & 0xFF);
        }
    }
}

