/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.ints.Int10;
import jdos.ints.Int10_modes;
import jdos.misc.Log;
import jdos.util.IntRef;

public class Int10_misc {
    public static void INT10_GetFuncStateInformation(int save) {
        int i;
        Memory.mem_writed(save, Int10.int10.rom.static_state);
        for (i = 0; i < 30; ++i) {
            Memory.mem_writeb(save + 4 + i, Memory.real_readb(64, 73 + i));
        }
        Memory.mem_writeb(save + 34, Memory.real_readb(64, 132) + 1);
        for (i = 1; i < 3; ++i) {
            Memory.mem_writeb(save + 34 + i, Memory.real_readb(64, 132 + i));
        }
        for (i = 37; i < 64; ++i) {
            Memory.mem_writeb(save + i, 0);
        }
        int dccode = 0;
        int vsavept = Memory.real_readd(64, 168);
        int svstable = Memory.real_readd(Memory.RealSeg(vsavept), Memory.RealOff(vsavept) + 16);
        if (svstable != 0) {
            int dcctable = Memory.real_readd(Memory.RealSeg(svstable), Memory.RealOff(svstable) + 2);
            short entries = Memory.real_readb(Memory.RealSeg(dcctable), Memory.RealOff(dcctable) + 0);
            short idx = Memory.real_readb(64, 138);
            if (idx < entries) {
                int dccentry = Memory.real_readw(Memory.RealSeg(dcctable), Memory.RealOff(dcctable) + 4 + idx * 2);
                dccode = (dccentry & 0xFF) == 0 ? (int)((short)(dccentry >> 8 & 0xFF)) : (int)((short)(dccentry & 0xFF));
            }
        }
        Memory.mem_writeb(save + 37, dccode);
        int col_count = 0;
        switch (Int10_modes.CurMode.type) {
            case 9: {
                if (Int10_modes.CurMode.mode == 7) {
                    col_count = 1;
                    break;
                }
                col_count = 16;
                break;
            }
            case 0: {
                col_count = 2;
                break;
            }
            case 1: {
                col_count = 4;
                break;
            }
            case 2: {
                if (Int10_modes.CurMode.mode == 17 || Int10_modes.CurMode.mode == 15) {
                    col_count = 2;
                    break;
                }
                col_count = 16;
                break;
            }
            case 3: {
                col_count = 256;
                break;
            }
            default: {
                Log.log(4, 2, "Get Func State illegal mode type " + Int10_modes.CurMode.type);
            }
        }
        Memory.mem_writew(save + 39, col_count);
        Memory.mem_writeb(save + 41, Int10_modes.CurMode.ptotal);
        switch (Int10_modes.CurMode.sheight) {
            case 200: {
                Memory.mem_writeb(save + 42, 0);
                break;
            }
            case 350: {
                Memory.mem_writeb(save + 42, 1);
                break;
            }
            case 400: {
                Memory.mem_writeb(save + 42, 2);
                break;
            }
            case 480: {
                Memory.mem_writeb(save + 42, 3);
            }
        }
        if (Int10_modes.CurMode.type == 9) {
            Memory.mem_writeb(save + 45, 33);
        } else {
            Memory.mem_writeb(save + 45, 1);
        }
        Memory.mem_writeb(save + 49, 3);
    }

    public static int INT10_EGA_RIL_GetVersionPt() {
        return Memory.RealMake(49152, 48);
    }

    private static void EGA_RIL(int dx, IntRef port, IntRef regs) {
        port.value = 0;
        regs.value = 0;
        switch (dx) {
            case 0: {
                port.value = Memory.real_readw(64, 99);
                regs.value = 25;
                break;
            }
            case 8: {
                port.value = 964;
                regs.value = 5;
                break;
            }
            case 16: {
                port.value = 974;
                regs.value = 9;
                break;
            }
            case 24: {
                port.value = 960;
                regs.value = 20;
                break;
            }
            case 32: {
                port.value = 962;
                break;
            }
            case 40: {
                port.value = Memory.real_readw(64, 99) + 6;
                break;
            }
            case 48: {
                port.value = 972;
                break;
            }
            case 56: {
                port.value = 970;
                break;
            }
            default: {
                Log.log(4, 2, "unknown RIL port selection " + Integer.toString(dx, 16));
            }
        }
    }

    public static short INT10_EGA_RIL_ReadRegister(short bl, int dx) {
        IntRef port = new IntRef(0);
        IntRef regs = new IntRef(0);
        Int10_misc.EGA_RIL(dx, port, regs);
        if (regs.value == 0) {
            if (port.value != 0) {
                bl = IoHandler.IO_Read(port.value);
            }
        } else {
            if (port.value == 960) {
                IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
            }
            IoHandler.IO_Write(port.value, bl);
            bl = IoHandler.IO_Read(port.value + 1);
            if (port.value == 960) {
                IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
            }
            Log.log(4, 0, "EGA RIL read used with multi-reg");
        }
        return bl;
    }

    public static short INT10_EGA_RIL_WriteRegister(short bl, short bh, int dx) {
        IntRef port = new IntRef(0);
        IntRef regs = new IntRef(0);
        Int10_misc.EGA_RIL(dx, port, regs);
        if (regs.value == 0) {
            if (port.value != 0) {
                IoHandler.IO_Write(port.value, bl);
            }
        } else {
            if (port.value == 960) {
                IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
                IoHandler.IO_Write(port.value, bl);
                IoHandler.IO_Write(port.value, bh);
            } else {
                IoHandler.IO_Write(port.value, bl);
                IoHandler.IO_Write(port.value + 1, bh);
            }
            bl = bh;
            Log.log(4, 0, "EGA RIL write used with multi-reg");
        }
        return bl;
    }

    public static void INT10_EGA_RIL_ReadRegisterRange(short ch, short cl, int dx, int dst) {
        IntRef port = new IntRef(0);
        IntRef regs = new IntRef(0);
        Int10_misc.EGA_RIL(dx, port, regs);
        if (regs.value == 0) {
            Log.log(4, 2, "EGA RIL range read with port " + Integer.toString(port.value, 16) + " called");
        } else if (ch < regs.value) {
            if (ch + cl > regs.value) {
                cl = (short)(regs.value - ch);
            }
            for (int i = 0; i < cl; ++i) {
                if (port.value == 960) {
                    IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
                }
                IoHandler.IO_Write(port.value, ch + i);
                Memory.mem_writeb(dst++, IoHandler.IO_Read(port.value + 1));
            }
            if (port.value == 960) {
                IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
            }
        } else {
            Log.log(4, 2, "EGA RIL range read from " + Integer.toString(port.value, 16) + " for invalid register " + Integer.toString(ch, 16));
        }
    }

    public static void INT10_EGA_RIL_WriteRegisterRange(short ch, short cl, int dx, int src) {
        IntRef port = new IntRef(0);
        IntRef regs = new IntRef(0);
        Int10_misc.EGA_RIL(dx, port, regs);
        if (regs.value == 0) {
            Log.log(4, 2, "EGA RIL range write called with port " + Integer.toString(port.value, 16));
        } else if (ch < regs.value) {
            if (ch + cl > regs.value) {
                cl = (short)(regs.value - ch);
            }
            if (port.value == 960) {
                IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
                for (int i = 0; i < cl; ++i) {
                    IoHandler.IO_Write(port.value, ch + i);
                    IoHandler.IO_Write(port.value, Memory.mem_readb(src++));
                }
            } else {
                for (int i = 0; i < cl; ++i) {
                    IoHandler.IO_Write(port.value, ch + i);
                    IoHandler.IO_Write(port.value + 1, Memory.mem_readb(src++));
                }
            }
        } else {
            Log.log(4, 2, "EGA RIL range write to " + Integer.toString(port.value, 16) + " with invalid register " + Integer.toString(ch, 16));
        }
    }

    public static void INT10_EGA_RIL_ReadRegisterSet(int cx, int tbl) {
        for (int i = 0; i < cx; ++i) {
            short vl = Memory.mem_readb(tbl + 2);
            Int10_misc.INT10_EGA_RIL_ReadRegister(vl, Memory.mem_readw(tbl));
            Memory.mem_writeb(tbl + 3, vl);
            tbl += 4;
        }
    }

    public static void INT10_EGA_RIL_WriteRegisterSet(int cx, int tbl) {
        IntRef port = new IntRef(0);
        IntRef regs = new IntRef(0);
        for (int i = 0; i < cx; ++i) {
            Int10_misc.EGA_RIL(Memory.mem_readw(tbl), port, regs);
            short vl = Memory.mem_readb(tbl + 3);
            if (regs.value == 0) {
                if (port.value != 0) {
                    IoHandler.IO_Write(port.value, vl);
                }
            } else {
                short idx = Memory.mem_readb(tbl + 2);
                if (port.value == 960) {
                    IoHandler.IO_Read(Memory.real_readw(64, 99) + 6);
                    IoHandler.IO_Write(port.value, idx);
                    IoHandler.IO_Write(port.value, vl);
                } else {
                    IoHandler.IO_Write(port.value, idx);
                    IoHandler.IO_Write(port.value + 1, vl);
                }
            }
            tbl += 4;
        }
    }
}

