/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.hardware.IO;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.hardware.VGA;
import jdos.hardware.VGA_dac;
import jdos.hardware.VGA_other;
import jdos.ints.Int10;
import jdos.ints.Int10_char;
import jdos.ints.Int10_memory;
import jdos.ints.Int10_pal;
import jdos.ints.Mouse;
import jdos.misc.Log;

public class Int10_modes {
    public static final int _EGA_HALF_CLOCK = 1;
    public static final int _EGA_LINE_DOUBLE = 2;
    public static final int _VGA_PIXEL_DOUBLE = 4;
    public static final int SEQ_REGS = 5;
    public static final int GFX_REGS = 9;
    public static final int ATT_REGS = 21;
    public static Int10.VideoModeBlock[] ModeList_VGA = new Int10.VideoModeBlock[]{new Int10.VideoModeBlock(0, 9, 360, 400, 40, 25, 9, 16, 8, 753664, 2048, 50, 449, 40, 400, 1), new Int10.VideoModeBlock(1, 9, 360, 400, 40, 25, 9, 16, 8, 753664, 2048, 50, 449, 40, 400, 1), new Int10.VideoModeBlock(2, 9, 720, 400, 80, 25, 9, 16, 8, 753664, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(3, 9, 720, 400, 80, 25, 9, 16, 8, 753664, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(4, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(5, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(6, 0, 640, 200, 80, 25, 8, 8, 1, 753664, 16384, 100, 449, 80, 400, 3), new Int10.VideoModeBlock(7, 9, 720, 400, 80, 25, 9, 16, 8, 720896, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(13, 2, 320, 200, 40, 25, 8, 8, 8, 655360, 8192, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(14, 2, 640, 200, 80, 25, 8, 8, 4, 655360, 16384, 100, 449, 80, 400, 2), new Int10.VideoModeBlock(15, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(16, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(17, 2, 640, 480, 80, 30, 8, 16, 1, 655360, 40960, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(18, 2, 640, 480, 80, 30, 8, 16, 1, 655360, 40960, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(19, 3, 320, 200, 40, 25, 8, 8, 1, 655360, 8192, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(84, 9, 1056, 688, 132, 43, 8, 16, 1, 753664, 16384, 192, 800, 132, 688, 0), new Int10.VideoModeBlock(85, 9, 1056, 400, 132, 25, 8, 16, 1, 753664, 8192, 192, 449, 132, 400, 0), new Int10.VideoModeBlock(105, 5, 640, 480, 80, 30, 8, 16, 1, 655360, 65536, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(106, 4, 800, 600, 100, 37, 8, 16, 1, 655360, 65536, 128, 663, 100, 600, 0), new Int10.VideoModeBlock(256, 5, 640, 400, 80, 25, 8, 16, 1, 655360, 65536, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(257, 5, 640, 480, 80, 30, 8, 16, 1, 655360, 65536, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(258, 4, 800, 600, 100, 37, 8, 16, 1, 655360, 65536, 132, 628, 100, 600, 0), new Int10.VideoModeBlock(259, 5, 800, 600, 100, 37, 8, 16, 1, 655360, 65536, 132, 628, 100, 600, 0), new Int10.VideoModeBlock(260, 4, 1024, 768, 128, 48, 8, 16, 1, 655360, 65536, 168, 806, 128, 768, 0), new Int10.VideoModeBlock(261, 5, 1024, 768, 128, 48, 8, 16, 1, 655360, 65536, 168, 806, 128, 768, 0), new Int10.VideoModeBlock(262, 4, 1280, 1024, 160, 64, 8, 16, 1, 655360, 65536, 212, 1066, 160, 1024, 0), new Int10.VideoModeBlock(263, 5, 1280, 1024, 160, 64, 8, 16, 1, 655360, 65536, 212, 1066, 160, 1024, 0), new Int10.VideoModeBlock(269, 6, 320, 200, 40, 25, 8, 8, 1, 655360, 65536, 100, 449, 80, 400, 6), new Int10.VideoModeBlock(270, 7, 320, 200, 40, 25, 8, 8, 1, 655360, 65536, 100, 449, 80, 400, 6), new Int10.VideoModeBlock(271, 8, 320, 200, 40, 25, 8, 8, 1, 655360, 65536, 50, 449, 40, 400, 6), new Int10.VideoModeBlock(272, 6, 640, 480, 80, 30, 8, 16, 1, 655360, 65536, 200, 525, 160, 480, 0), new Int10.VideoModeBlock(273, 7, 640, 480, 80, 30, 8, 16, 1, 655360, 65536, 200, 525, 160, 480, 0), new Int10.VideoModeBlock(274, 8, 640, 480, 80, 30, 8, 16, 1, 655360, 65536, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(275, 6, 800, 600, 100, 37, 8, 16, 1, 655360, 65536, 264, 628, 200, 600, 0), new Int10.VideoModeBlock(276, 7, 800, 600, 100, 37, 8, 16, 1, 655360, 65536, 264, 628, 200, 600, 0), new Int10.VideoModeBlock(277, 8, 800, 600, 100, 37, 8, 16, 1, 655360, 65536, 132, 628, 100, 600, 0), new Int10.VideoModeBlock(278, 6, 1024, 768, 128, 48, 8, 16, 1, 655360, 65536, 336, 806, 256, 768, 0), new Int10.VideoModeBlock(279, 7, 1024, 768, 128, 48, 8, 16, 1, 655360, 65536, 336, 806, 256, 768, 0), new Int10.VideoModeBlock(280, 8, 1024, 768, 128, 48, 8, 16, 1, 655360, 65536, 168, 806, 128, 768, 0), new Int10.VideoModeBlock(336, 5, 320, 200, 40, 25, 8, 8, 1, 655360, 65536, 100, 449, 80, 400, 6), new Int10.VideoModeBlock(337, 5, 320, 240, 40, 30, 8, 8, 1, 655360, 65536, 100, 525, 80, 480, 6), new Int10.VideoModeBlock(338, 5, 320, 400, 40, 50, 8, 8, 1, 655360, 65536, 100, 449, 80, 400, 4), new Int10.VideoModeBlock(339, 5, 320, 480, 40, 60, 8, 8, 1, 655360, 65536, 100, 525, 80, 480, 4), new Int10.VideoModeBlock(352, 6, 320, 240, 40, 30, 8, 8, 1, 655360, 65536, 100, 525, 80, 480, 6), new Int10.VideoModeBlock(353, 6, 320, 400, 40, 50, 8, 8, 1, 655360, 65536, 100, 449, 80, 400, 4), new Int10.VideoModeBlock(354, 6, 320, 480, 40, 60, 8, 8, 1, 655360, 65536, 100, 525, 80, 480, 4), new Int10.VideoModeBlock(357, 6, 640, 400, 80, 25, 8, 16, 1, 655360, 65536, 200, 449, 160, 400, 0), new Int10.VideoModeBlock(368, 7, 320, 240, 40, 30, 8, 8, 1, 655360, 65536, 100, 525, 80, 480, 6), new Int10.VideoModeBlock(369, 7, 320, 400, 40, 50, 8, 8, 1, 655360, 65536, 100, 449, 80, 400, 4), new Int10.VideoModeBlock(370, 7, 320, 480, 40, 60, 8, 8, 1, 655360, 65536, 100, 525, 80, 480, 4), new Int10.VideoModeBlock(373, 7, 640, 400, 80, 25, 8, 16, 1, 655360, 65536, 200, 449, 160, 400, 0), new Int10.VideoModeBlock(400, 8, 320, 240, 40, 30, 8, 8, 1, 655360, 65536, 50, 525, 40, 480, 6), new Int10.VideoModeBlock(401, 8, 320, 400, 40, 50, 8, 8, 1, 655360, 65536, 50, 449, 40, 400, 4), new Int10.VideoModeBlock(402, 8, 320, 480, 40, 60, 8, 8, 1, 655360, 65536, 50, 525, 40, 480, 4), new Int10.VideoModeBlock(519, 5, 1152, 864, 160, 64, 8, 16, 1, 655360, 65536, 182, 948, 144, 864, 0), new Int10.VideoModeBlock(521, 6, 1152, 864, 160, 64, 8, 16, 1, 655360, 65536, 364, 948, 288, 864, 0), new Int10.VideoModeBlock(522, 7, 1152, 864, 160, 64, 8, 16, 1, 655360, 65536, 364, 948, 288, 864, 0), new Int10.VideoModeBlock(531, 8, 640, 400, 80, 25, 8, 16, 1, 655360, 65536, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(546, 5, 848, 480, 80, 30, 8, 16, 1, 655360, 65536, 132, 525, 106, 480, 0), new Int10.VideoModeBlock(547, 6, 848, 480, 80, 30, 8, 16, 1, 655360, 65536, 264, 525, 212, 480, 0), new Int10.VideoModeBlock(548, 7, 848, 480, 80, 30, 8, 16, 1, 655360, 65536, 264, 525, 212, 480, 0), new Int10.VideoModeBlock(549, 8, 848, 480, 80, 30, 8, 16, 1, 655360, 65536, 132, 525, 106, 480, 0), new Int10.VideoModeBlock(65535, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)};
    private static Int10.VideoModeBlock[] ModeList_VGA_Text_200lines = new Int10.VideoModeBlock[]{new Int10.VideoModeBlock(0, 9, 320, 200, 40, 25, 8, 8, 8, 753664, 2048, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(1, 9, 320, 200, 40, 25, 8, 8, 8, 753664, 2048, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(2, 9, 640, 200, 80, 25, 8, 8, 8, 753664, 4096, 100, 449, 80, 400, 2), new Int10.VideoModeBlock(3, 9, 640, 200, 80, 25, 8, 8, 8, 753664, 4096, 100, 449, 80, 400, 2)};
    private static Int10.VideoModeBlock[] ModeList_VGA_Text_350lines = new Int10.VideoModeBlock[]{new Int10.VideoModeBlock(0, 9, 320, 350, 40, 25, 8, 14, 8, 753664, 2048, 50, 449, 40, 350, 1), new Int10.VideoModeBlock(1, 9, 320, 350, 40, 25, 8, 14, 8, 753664, 2048, 50, 449, 40, 350, 1), new Int10.VideoModeBlock(2, 9, 640, 350, 80, 25, 8, 14, 8, 753664, 4096, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(3, 9, 640, 350, 80, 25, 8, 14, 8, 753664, 4096, 100, 449, 80, 350, 0)};
    private static Int10.VideoModeBlock[] ModeList_VGA_Tseng = new Int10.VideoModeBlock[]{new Int10.VideoModeBlock(0, 9, 360, 400, 40, 25, 9, 16, 8, 753664, 2048, 50, 449, 40, 400, 1), new Int10.VideoModeBlock(1, 9, 360, 400, 40, 25, 9, 16, 8, 753664, 2048, 50, 449, 40, 400, 1), new Int10.VideoModeBlock(2, 9, 720, 400, 80, 25, 9, 16, 8, 753664, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(3, 9, 720, 400, 80, 25, 9, 16, 8, 753664, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(4, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(5, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(6, 0, 640, 200, 80, 25, 8, 8, 1, 753664, 16384, 100, 449, 80, 400, 3), new Int10.VideoModeBlock(7, 9, 720, 400, 80, 25, 9, 16, 8, 720896, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(13, 2, 320, 200, 40, 25, 8, 8, 8, 655360, 8192, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(14, 2, 640, 200, 80, 25, 8, 8, 4, 655360, 16384, 100, 449, 80, 400, 2), new Int10.VideoModeBlock(15, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(16, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(17, 2, 640, 480, 80, 30, 8, 16, 1, 655360, 40960, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(18, 2, 640, 480, 80, 30, 8, 16, 1, 655360, 40960, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(19, 3, 320, 200, 40, 25, 8, 8, 1, 655360, 8192, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(24, 9, 1056, 688, 132, 44, 8, 8, 1, 720896, 16384, 192, 800, 132, 704, 0), new Int10.VideoModeBlock(25, 9, 1056, 400, 132, 25, 8, 16, 1, 720896, 8192, 192, 449, 132, 400, 0), new Int10.VideoModeBlock(26, 9, 1056, 400, 132, 28, 8, 16, 1, 720896, 8192, 192, 449, 132, 448, 0), new Int10.VideoModeBlock(34, 9, 1056, 688, 132, 44, 8, 8, 1, 753664, 16384, 192, 800, 132, 704, 0), new Int10.VideoModeBlock(35, 9, 1056, 400, 132, 25, 8, 16, 1, 753664, 8192, 192, 449, 132, 400, 0), new Int10.VideoModeBlock(36, 9, 1056, 400, 132, 28, 8, 16, 1, 753664, 8192, 192, 449, 132, 448, 0), new Int10.VideoModeBlock(37, 4, 640, 480, 80, 30, 8, 16, 1, 655360, 40960, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(41, 4, 800, 600, 100, 37, 8, 16, 1, 655360, 40960, 128, 663, 100, 600, 0), new Int10.VideoModeBlock(45, 5, 640, 350, 80, 21, 8, 16, 1, 655360, 65536, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(46, 5, 640, 480, 80, 30, 8, 16, 1, 655360, 65536, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(47, 5, 640, 400, 80, 25, 8, 16, 1, 655360, 65536, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(48, 5, 800, 600, 100, 37, 8, 16, 1, 655360, 65536, 128, 663, 100, 600, 0), new Int10.VideoModeBlock(54, 4, 960, 720, 120, 45, 8, 16, 1, 655360, 40960, 120, 800, 120, 720, 0), new Int10.VideoModeBlock(55, 4, 1024, 768, 128, 48, 8, 16, 1, 655360, 40960, 128, 800, 128, 768, 0), new Int10.VideoModeBlock(56, 5, 1024, 768, 128, 48, 8, 16, 1, 655360, 65536, 128, 800, 128, 768, 0), new Int10.VideoModeBlock(61, 4, 1280, 1024, 160, 64, 8, 16, 1, 655360, 40960, 160, 1152, 160, 1024, 0), new Int10.VideoModeBlock(62, 4, 1280, 960, 160, 60, 8, 16, 1, 655360, 40960, 160, 1024, 160, 960, 0), new Int10.VideoModeBlock(106, 4, 800, 600, 100, 37, 8, 16, 1, 655360, 40960, 128, 663, 100, 600, 0), new Int10.VideoModeBlock(65535, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)};
    private static Int10.VideoModeBlock[] ModeList_VGA_Paradise = new Int10.VideoModeBlock[]{new Int10.VideoModeBlock(0, 9, 360, 400, 40, 25, 9, 16, 8, 753664, 2048, 50, 449, 40, 400, 1), new Int10.VideoModeBlock(1, 9, 360, 400, 40, 25, 9, 16, 8, 753664, 2048, 50, 449, 40, 400, 1), new Int10.VideoModeBlock(2, 9, 720, 400, 80, 25, 9, 16, 8, 753664, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(3, 9, 720, 400, 80, 25, 9, 16, 8, 753664, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(4, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(5, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(6, 0, 640, 200, 80, 25, 8, 8, 1, 753664, 16384, 100, 449, 80, 400, 3), new Int10.VideoModeBlock(7, 9, 720, 400, 80, 25, 9, 16, 8, 720896, 4096, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(13, 2, 320, 200, 40, 25, 8, 8, 8, 655360, 8192, 50, 449, 40, 400, 3), new Int10.VideoModeBlock(14, 2, 640, 200, 80, 25, 8, 8, 4, 655360, 16384, 100, 449, 80, 400, 2), new Int10.VideoModeBlock(15, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(16, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 100, 449, 80, 350, 0), new Int10.VideoModeBlock(17, 2, 640, 480, 80, 30, 8, 16, 1, 655360, 40960, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(18, 2, 640, 480, 80, 30, 8, 16, 1, 655360, 40960, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(19, 3, 320, 200, 40, 25, 8, 8, 1, 655360, 8192, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(84, 9, 1056, 688, 132, 43, 8, 9, 1, 720896, 16384, 192, 720, 132, 688, 0), new Int10.VideoModeBlock(85, 9, 1056, 400, 132, 25, 8, 16, 1, 720896, 8192, 192, 449, 132, 400, 0), new Int10.VideoModeBlock(86, 9, 1056, 688, 132, 43, 8, 9, 1, 720896, 16384, 192, 720, 132, 688, 0), new Int10.VideoModeBlock(87, 9, 1056, 400, 132, 25, 8, 16, 1, 720896, 8192, 192, 449, 132, 400, 0), new Int10.VideoModeBlock(88, 4, 800, 600, 100, 37, 8, 16, 1, 655360, 40960, 128, 663, 100, 600, 0), new Int10.VideoModeBlock(93, 4, 1024, 768, 128, 48, 8, 16, 1, 655360, 65536, 128, 800, 128, 768, 0), new Int10.VideoModeBlock(94, 5, 640, 400, 80, 25, 8, 16, 1, 655360, 65536, 100, 449, 80, 400, 0), new Int10.VideoModeBlock(95, 5, 640, 480, 80, 30, 8, 16, 1, 655360, 65536, 100, 525, 80, 480, 0), new Int10.VideoModeBlock(65535, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)};
    private static Int10.VideoModeBlock[] ModeList_EGA = new Int10.VideoModeBlock[]{new Int10.VideoModeBlock(0, 9, 320, 350, 40, 25, 8, 14, 8, 753664, 2048, 50, 366, 40, 350, 1), new Int10.VideoModeBlock(1, 9, 320, 350, 40, 25, 8, 14, 8, 753664, 2048, 50, 366, 40, 350, 1), new Int10.VideoModeBlock(2, 9, 640, 350, 80, 25, 8, 14, 8, 753664, 4096, 96, 366, 80, 350, 0), new Int10.VideoModeBlock(3, 9, 640, 350, 80, 25, 8, 14, 8, 753664, 4096, 96, 366, 80, 350, 0), new Int10.VideoModeBlock(4, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 60, 262, 40, 200, 3), new Int10.VideoModeBlock(5, 1, 320, 200, 40, 25, 8, 8, 1, 753664, 16384, 60, 262, 40, 200, 3), new Int10.VideoModeBlock(6, 0, 640, 200, 80, 25, 8, 8, 1, 753664, 16384, 120, 262, 80, 200, 2), new Int10.VideoModeBlock(7, 9, 720, 350, 80, 25, 9, 14, 8, 720896, 4096, 120, 440, 80, 350, 0), new Int10.VideoModeBlock(13, 2, 320, 200, 40, 25, 8, 8, 8, 655360, 8192, 60, 262, 40, 200, 3), new Int10.VideoModeBlock(14, 2, 640, 200, 80, 25, 8, 8, 4, 655360, 16384, 120, 262, 80, 200, 2), new Int10.VideoModeBlock(15, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 96, 366, 80, 350, 0), new Int10.VideoModeBlock(16, 2, 640, 350, 80, 25, 8, 14, 2, 655360, 32768, 96, 366, 80, 350, 0), new Int10.VideoModeBlock(65535, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)};
    private static Int10.VideoModeBlock[] ModeList_OTHER = new Int10.VideoModeBlock[]{new Int10.VideoModeBlock(0, 9, 320, 400, 40, 25, 8, 8, 8, 753664, 2048, 56, 31, 40, 25, 0), new Int10.VideoModeBlock(1, 9, 320, 400, 40, 25, 8, 8, 8, 753664, 2048, 56, 31, 40, 25, 0), new Int10.VideoModeBlock(2, 9, 640, 400, 80, 25, 8, 8, 4, 753664, 4096, 113, 31, 80, 25, 0), new Int10.VideoModeBlock(3, 9, 640, 400, 80, 25, 8, 8, 4, 753664, 4096, 113, 31, 80, 25, 0), new Int10.VideoModeBlock(4, 1, 320, 200, 40, 25, 8, 8, 4, 753664, 2048, 56, 127, 40, 100, 0), new Int10.VideoModeBlock(5, 1, 320, 200, 40, 25, 8, 8, 4, 753664, 2048, 56, 127, 40, 100, 0), new Int10.VideoModeBlock(6, 0, 640, 200, 80, 25, 8, 8, 4, 753664, 2048, 56, 127, 40, 100, 0), new Int10.VideoModeBlock(8, 15, 160, 200, 20, 25, 8, 8, 8, 753664, 8192, 56, 127, 40, 100, 0), new Int10.VideoModeBlock(9, 15, 320, 200, 40, 25, 8, 8, 8, 753664, 8192, 113, 63, 80, 50, 0), new Int10.VideoModeBlock(10, 1, 640, 200, 80, 25, 8, 8, 8, 753664, 8192, 113, 63, 80, 50, 0), new Int10.VideoModeBlock(65535, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)};
    private static Int10.VideoModeBlock Hercules_Mode = new Int10.VideoModeBlock(7, 9, 640, 400, 80, 25, 8, 14, 1, 720896, 4096, 97, 25, 80, 25, 0);
    private static byte[][] text_palette = new byte[][]{{0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 42, 0}, {42, 42, 42}, {0, 0, 21}, {0, 0, 63}, {0, 42, 21}, {0, 42, 63}, {42, 0, 21}, {42, 0, 63}, {42, 42, 21}, {42, 42, 63}, {0, 21, 0}, {0, 21, 42}, {0, 63, 0}, {0, 63, 42}, {42, 21, 0}, {42, 21, 42}, {42, 63, 0}, {42, 63, 42}, {0, 21, 21}, {0, 21, 63}, {0, 63, 21}, {0, 63, 63}, {42, 21, 21}, {42, 21, 63}, {42, 63, 21}, {42, 63, 63}, {21, 0, 0}, {21, 0, 42}, {21, 42, 0}, {21, 42, 42}, {63, 0, 0}, {63, 0, 42}, {63, 42, 0}, {63, 42, 42}, {21, 0, 21}, {21, 0, 63}, {21, 42, 21}, {21, 42, 63}, {63, 0, 21}, {63, 0, 63}, {63, 42, 21}, {63, 42, 63}, {21, 21, 0}, {21, 21, 42}, {21, 63, 0}, {21, 63, 42}, {63, 21, 0}, {63, 21, 42}, {63, 63, 0}, {63, 63, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}};
    private static byte[][] mtext_palette = new byte[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}};
    private static byte[][] mtext_s3_palette = new byte[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {42, 42, 42}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}, {63, 63, 63}};
    private static byte[][] ega_palette = new byte[][]{{0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}};
    private static byte[][] cga_palette = new byte[][]{{0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}};
    private static byte[][] cga_palette_2 = new byte[][]{{0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}};
    private static byte[][] vga_palette = new byte[][]{{0, 0, 0}, {0, 0, 42}, {0, 42, 0}, {0, 42, 42}, {42, 0, 0}, {42, 0, 42}, {42, 21, 0}, {42, 42, 42}, {21, 21, 21}, {21, 21, 63}, {21, 63, 21}, {21, 63, 63}, {63, 21, 21}, {63, 21, 63}, {63, 63, 21}, {63, 63, 63}, {0, 0, 0}, {5, 5, 5}, {8, 8, 8}, {11, 11, 11}, {14, 14, 14}, {17, 17, 17}, {20, 20, 20}, {24, 24, 24}, {28, 28, 28}, {32, 32, 32}, {36, 36, 36}, {40, 40, 40}, {45, 45, 45}, {50, 50, 50}, {56, 56, 56}, {63, 63, 63}, {0, 0, 63}, {16, 0, 63}, {31, 0, 63}, {47, 0, 63}, {63, 0, 63}, {63, 0, 47}, {63, 0, 31}, {63, 0, 16}, {63, 0, 0}, {63, 16, 0}, {63, 31, 0}, {63, 47, 0}, {63, 63, 0}, {47, 63, 0}, {31, 63, 0}, {16, 63, 0}, {0, 63, 0}, {0, 63, 16}, {0, 63, 31}, {0, 63, 47}, {0, 63, 63}, {0, 47, 63}, {0, 31, 63}, {0, 16, 63}, {31, 31, 63}, {39, 31, 63}, {47, 31, 63}, {55, 31, 63}, {63, 31, 63}, {63, 31, 55}, {63, 31, 47}, {63, 31, 39}, {63, 31, 31}, {63, 39, 31}, {63, 47, 31}, {63, 55, 31}, {63, 63, 31}, {55, 63, 31}, {47, 63, 31}, {39, 63, 31}, {31, 63, 31}, {31, 63, 39}, {31, 63, 47}, {31, 63, 55}, {31, 63, 63}, {31, 55, 63}, {31, 47, 63}, {31, 39, 63}, {45, 45, 63}, {49, 45, 63}, {54, 45, 63}, {58, 45, 63}, {63, 45, 63}, {63, 45, 58}, {63, 45, 54}, {63, 45, 49}, {63, 45, 45}, {63, 49, 45}, {63, 54, 45}, {63, 58, 45}, {63, 63, 45}, {58, 63, 45}, {54, 63, 45}, {49, 63, 45}, {45, 63, 45}, {45, 63, 49}, {45, 63, 54}, {45, 63, 58}, {45, 63, 63}, {45, 58, 63}, {45, 54, 63}, {45, 49, 63}, {0, 0, 28}, {7, 0, 28}, {14, 0, 28}, {21, 0, 28}, {28, 0, 28}, {28, 0, 21}, {28, 0, 14}, {28, 0, 7}, {28, 0, 0}, {28, 7, 0}, {28, 14, 0}, {28, 21, 0}, {28, 28, 0}, {21, 28, 0}, {14, 28, 0}, {7, 28, 0}, {0, 28, 0}, {0, 28, 7}, {0, 28, 14}, {0, 28, 21}, {0, 28, 28}, {0, 21, 28}, {0, 14, 28}, {0, 7, 28}, {14, 14, 28}, {17, 14, 28}, {21, 14, 28}, {24, 14, 28}, {28, 14, 28}, {28, 14, 24}, {28, 14, 21}, {28, 14, 17}, {28, 14, 14}, {28, 17, 14}, {28, 21, 14}, {28, 24, 14}, {28, 28, 14}, {24, 28, 14}, {21, 28, 14}, {17, 28, 14}, {14, 28, 14}, {14, 28, 17}, {14, 28, 21}, {14, 28, 24}, {14, 28, 28}, {14, 24, 28}, {14, 21, 28}, {14, 17, 28}, {20, 20, 28}, {22, 20, 28}, {24, 20, 28}, {26, 20, 28}, {28, 20, 28}, {28, 20, 26}, {28, 20, 24}, {28, 20, 22}, {28, 20, 20}, {28, 22, 20}, {28, 24, 20}, {28, 26, 20}, {28, 28, 20}, {26, 28, 20}, {24, 28, 20}, {22, 28, 20}, {20, 28, 20}, {20, 28, 22}, {20, 28, 24}, {20, 28, 26}, {20, 28, 28}, {20, 26, 28}, {20, 24, 28}, {20, 22, 28}, {0, 0, 16}, {4, 0, 16}, {8, 0, 16}, {12, 0, 16}, {16, 0, 16}, {16, 0, 12}, {16, 0, 8}, {16, 0, 4}, {16, 0, 0}, {16, 4, 0}, {16, 8, 0}, {16, 12, 0}, {16, 16, 0}, {12, 16, 0}, {8, 16, 0}, {4, 16, 0}, {0, 16, 0}, {0, 16, 4}, {0, 16, 8}, {0, 16, 12}, {0, 16, 16}, {0, 12, 16}, {0, 8, 16}, {0, 4, 16}, {8, 8, 16}, {10, 8, 16}, {12, 8, 16}, {14, 8, 16}, {16, 8, 16}, {16, 8, 14}, {16, 8, 12}, {16, 8, 10}, {16, 8, 8}, {16, 10, 8}, {16, 12, 8}, {16, 14, 8}, {16, 16, 8}, {14, 16, 8}, {12, 16, 8}, {10, 16, 8}, {8, 16, 8}, {8, 16, 10}, {8, 16, 12}, {8, 16, 14}, {8, 16, 16}, {8, 14, 16}, {8, 12, 16}, {8, 10, 16}, {11, 11, 16}, {12, 11, 16}, {13, 11, 16}, {15, 11, 16}, {16, 11, 16}, {16, 11, 15}, {16, 11, 13}, {16, 11, 12}, {16, 11, 11}, {16, 12, 11}, {16, 13, 11}, {16, 15, 11}, {16, 16, 11}, {15, 16, 11}, {13, 16, 11}, {12, 16, 11}, {11, 16, 11}, {11, 16, 12}, {11, 16, 13}, {11, 16, 15}, {11, 16, 16}, {11, 15, 16}, {11, 13, 16}, {11, 12, 16}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    public static Int10.VideoModeBlock CurMode;

    private static boolean SetCurMode(Int10.VideoModeBlock[] modeblock, int mode) {
        int i = 0;
        while (modeblock[i].mode != 65535) {
            if (modeblock[i].mode != mode) {
                ++i;
                continue;
            }
            if (!Int10.int10.vesa_oldvbe || Int10_modes.ModeList_VGA[i].mode < 288) {
                CurMode = modeblock[i];
                return true;
            }
            return false;
        }
        return false;
    }

    private static void FinishSetMode(boolean clearmem) {
        int ct;
        if (clearmem) {
            switch (Int10_modes.CurMode.type) {
                case 0: 
                case 1: 
                case 15: {
                    for (ct = 0; ct < 16384; ++ct) {
                        Memory.real_writew(47104, ct * 2, 0);
                    }
                    break;
                }
                case 9: {
                    int seg = Int10_modes.CurMode.mode == 7 ? 45056 : 47104;
                    for (int ct2 = 0; ct2 < 16384; ++ct2) {
                        Memory.real_writew(seg, ct2 * 2, 1824);
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    Memory.host_zeroset(VGA.vga.mem.linear, VGA.vga.vmemsize);
                    Memory.host_zeroset(VGA.vga.fastmem, VGA.vga.vmemsize << 1);
                }
            }
        }
        if (Int10_modes.CurMode.mode < 128) {
            Memory.real_writeb(64, 73, Int10_modes.CurMode.mode);
        } else {
            Memory.real_writeb(64, 73, Int10_modes.CurMode.mode - 152);
        }
        Memory.real_writew(64, 74, Int10_modes.CurMode.twidth);
        Memory.real_writew(64, 76, Int10_modes.CurMode.plength);
        Memory.real_writew(64, 99, Int10_modes.CurMode.mode == 7 || Int10_modes.CurMode.mode == 15 ? 948 : 980);
        Memory.real_writeb(64, 132, Int10_modes.CurMode.theight - 1);
        Memory.real_writew(64, 133, Int10_modes.CurMode.cheight);
        Memory.real_writeb(64, 135, 0x60 | (clearmem ? 0 : 128));
        Memory.real_writeb(64, 136, 9);
        if (Dosbox.IS_VGA_ARCH()) {
            Memory.real_writeb(64, 138, 11);
        }
        Memory.real_writed(64, 168, Int10.int10.rom.video_save_pointers);
        if (Int10_modes.CurMode.type == 9) {
            Int10_char.INT10_SetCursorShape((short)6, (short)7);
        }
        for (ct = 0; ct < 8; ++ct) {
            Int10_char.INT10_SetCursorPos((short)0, (short)0, (short)ct);
        }
        Int10_char.INT10_SetActivePage((short)0);
        switch (Int10_modes.CurMode.cheight) {
            case 8: {
                Memory.RealSetVec(67, Int10.int10.rom.font_8_first);
                break;
            }
            case 14: {
                Memory.RealSetVec(67, Int10.int10.rom.font_14);
                break;
            }
            case 16: {
                Memory.RealSetVec(67, Int10.int10.rom.font_16);
            }
        }
        Mouse.Mouse_NewVideoMode();
    }

    public static boolean INT10_SetVideoMode_OTHER(int mode, boolean clearmem) {
        int ct;
        switch (Dosbox.machine) {
            case 1: {
                if (mode > 6) {
                    return false;
                }
            }
            case 2: 
            case 3: {
                if (mode > 10) {
                    return false;
                }
                if (mode == 7) {
                    mode = 0;
                }
                if (Int10_modes.SetCurMode(ModeList_OTHER, mode)) break;
                Log.log(4, 2, "Trying to set illegal mode " + Integer.toString(mode, 16));
                return false;
            }
            case 0: {
                if ((Memory.real_readw(64, 16) & 0x30) != 48) {
                    return false;
                }
                CurMode = Hercules_Mode;
                mode = 7;
            }
        }
        int crtc_base = Dosbox.machine == 0 ? 948 : 980;
        IO.IO_WriteW(crtc_base, 0 | Int10_modes.CurMode.htotal << 8);
        IO.IO_WriteW(crtc_base, 1 | Int10_modes.CurMode.hdispend << 8);
        IO.IO_WriteW(crtc_base, 2 | Int10_modes.CurMode.hdispend + 1 << 8);
        IO.IO_WriteW(crtc_base, 2563);
        IO.IO_WriteW(crtc_base, 4 | Int10_modes.CurMode.vtotal << 8);
        IO.IO_WriteW(crtc_base, 1541);
        IO.IO_WriteW(crtc_base, 6 | Int10_modes.CurMode.vdispend << 8);
        IO.IO_WriteW(crtc_base, 7 | Int10_modes.CurMode.vdispend + (Int10_modes.CurMode.vtotal - Int10_modes.CurMode.vdispend) / 2 - 1 << 8);
        int scanline = 8;
        switch (Int10_modes.CurMode.type) {
            case 9: {
                if (Dosbox.machine == 0) {
                    scanline = 14;
                    break;
                }
                scanline = 8;
                break;
            }
            case 0: {
                scanline = 2;
                break;
            }
            case 1: {
                if (Int10_modes.CurMode.mode != 10) {
                    scanline = 2;
                    break;
                }
                scanline = 4;
                break;
            }
            case 15: {
                scanline = Int10_modes.CurMode.mode != 9 ? 2 : 4;
            }
        }
        IO.IO_WriteW(crtc_base, 9 | scanline - 1 << 8);
        for (ct = 0; ct < 16; ++ct) {
            VGA_dac.VGA_DAC_SetEntry(ct, cga_palette[ct][0], cga_palette[ct][1], cga_palette[ct][2]);
        }
        for (ct = 0; ct < 16; ct = (int)((short)(ct + 1))) {
            VGA_dac.VGA_DAC_CombineColor(ct, ct);
        }
        byte[] mode_control_list = new byte[]{44, 40, 45, 41, 42, 46, 30, 41, 42, 43, 59};
        byte[] mode_control_list_pcjr = new byte[]{12, 8, 13, 9, 10, 14, 14, 9, 26, 27, 11};
        switch (Dosbox.machine) {
            case 0: {
                IO.IO_WriteB(952, 40);
                VGA_other.Herc_Palette();
                VGA_dac.VGA_DAC_CombineColor(0, 0);
                VGA_dac.VGA_DAC_CombineColor(1, 7);
                Memory.real_writeb(64, 101, 41);
                break;
            }
            case 1: {
                short mode_control = mode_control_list[Int10_modes.CurMode.mode];
                int color_select = Int10_modes.CurMode.mode == 6 ? 63 : 48;
                IO.IO_WriteB(984, mode_control);
                IO.IO_WriteB(985, color_select);
                Memory.real_writeb(64, 101, mode_control);
                Memory.real_writeb(64, 102, color_select);
                break;
            }
            case 2: {
                IO.IO_WriteB(986, 1);
                IO.IO_WriteB(990, 15);
                IO.IO_WriteB(986, 2);
                IO.IO_WriteB(990, 0);
                IO.IO_WriteB(986, 3);
                switch (Int10_modes.CurMode.mode) {
                    case 8: {
                        IO.IO_WriteB(990, 20);
                        break;
                    }
                    case 9: {
                        IO.IO_WriteB(990, 20);
                        break;
                    }
                    case 10: {
                        IO.IO_WriteB(990, 12);
                        break;
                    }
                    default: {
                        IO.IO_WriteB(990, 0);
                    }
                }
                IO.IO_WriteB(986, 5);
                IO.IO_WriteB(990, 0);
                IO.IO_WriteB(986, 8);
                IO.IO_WriteB(990, 0);
                int crtpage = Int10_modes.CurMode.mode >= 9 ? 246 : 63;
                IO.IO_WriteB(991, crtpage);
                Memory.real_writeb(64, 138, crtpage);
                short mode_control = mode_control_list[Int10_modes.CurMode.mode];
                int color_select = Int10_modes.CurMode.mode == 6 || Int10_modes.CurMode.mode == 10 ? 63 : 48;
                IO.IO_WriteB(984, mode_control);
                IO.IO_WriteB(985, color_select);
                Memory.real_writeb(64, 101, mode_control);
                Memory.real_writeb(64, 102, color_select);
                break;
            }
            case 3: {
                IO.IO_ReadB(986);
                IO.IO_WriteB(986, 1);
                IO.IO_WriteB(986, 15);
                IO.IO_WriteB(986, 2);
                IO.IO_WriteB(986, 0);
                IO.IO_WriteB(986, 3);
                if (Int10_modes.CurMode.mode <= 4) {
                    IO.IO_WriteB(986, 2);
                } else if (Int10_modes.CurMode.mode == 6) {
                    IO.IO_WriteB(986, 8);
                } else {
                    IO.IO_WriteB(986, 0);
                }
                int crtpage = Int10_modes.CurMode.mode < 4 ? 63 : (Int10_modes.CurMode.mode >= 9 ? 246 : 127);
                IO.IO_WriteB(991, crtpage);
                Memory.real_writeb(64, 138, crtpage);
                short mode_control = mode_control_list_pcjr[Int10_modes.CurMode.mode];
                IO.IO_WriteB(986, 0);
                IO.IO_WriteB(986, mode_control);
                Memory.real_writeb(64, 101, mode_control);
                int color_select = Int10_modes.CurMode.mode == 6 || Int10_modes.CurMode.mode == 10 ? 63 : 48;
                IO.IO_WriteB(985, color_select);
                Memory.real_writeb(64, 102, color_select);
            }
        }
        int vparams = Memory.RealGetVec(29);
        if (vparams != Memory.RealMake(61440, 61604) && mode < 8) {
            int crtc_block_index = 0;
            crtc_block_index = mode < 2 ? 0 : (mode < 4 ? 1 : (mode < 7 ? 2 : (mode == 7 ? 3 : (mode < 9 ? 2 : 3))));
            for (int i = 0; i < 16; ++i) {
                IO.IO_WriteW(crtc_base, i | Memory.real_readb(Memory.RealSeg(vparams), Memory.RealOff(vparams) + i + crtc_block_index * 16) << 8);
            }
        }
        Int10_modes.FinishSetMode(clearmem);
        return true;
    }

    private static void att_text16(short[] att_data) {
        if (Int10_modes.CurMode.mode == 7) {
            att_data[0] = 0;
            att_data[8] = 16;
            for (int i = 1; i < 8; ++i) {
                att_data[i] = 8;
                att_data[i + 8] = 24;
            }
        } else {
            for (int ct = 0; ct < 8; ct = (int)((short)(ct + 1))) {
                att_data[ct] = ct;
                att_data[ct + 8] = (short)(ct + 56);
            }
            if (Dosbox.IS_VGA_ARCH()) {
                att_data[6] = 20;
            }
        }
    }

    public static boolean INT10_SetVideoMode(int mode) {
        int ct;
        int i;
        int offset;
        int vblank_trim;
        int vretrace;
        int ct2;
        boolean clearmem = true;
        if (mode >= 256) {
            if ((mode & 0x4000) != 0 && Int10.int10.vesa_nolfb) {
                return false;
            }
            if ((mode & 0x8000) != 0) {
                clearmem = false;
            }
            mode &= 0xFFF;
        }
        if (mode < 256 && (mode & 0x80) != 0) {
            clearmem = false;
            mode -= 128;
        }
        Int10.int10.vesa_setmode = 65535;
        if (!Dosbox.IS_EGAVGA_ARCH()) {
            return Int10_modes.INT10_SetVideoMode_OTHER(mode, clearmem);
        }
        short modeset_ctl = Memory.real_readb(64, 137);
        if (Dosbox.IS_VGA_ARCH()) {
            if (VGA.svga.accepts_mode != null && !VGA.svga.accepts_mode.call(mode)) {
                return false;
            }
            switch (Dosbox.svgaCard) {
                case 2: 
                case 3: {
                    if (Int10_modes.SetCurMode(ModeList_VGA_Tseng, mode)) break;
                    Log.log(4, 2, "VGA:Trying to set illegal mode " + Integer.toString(mode, 16));
                    return false;
                }
                case 4: {
                    if (Int10_modes.SetCurMode(ModeList_VGA_Paradise, mode)) break;
                    Log.log(4, 2, "VGA:Trying to set illegal mode " + Integer.toString(mode, 16));
                    return false;
                }
                default: {
                    if (Int10_modes.SetCurMode(ModeList_VGA, mode)) break;
                    Log.log(4, 2, "VGA:Trying to set illegal mode " + Integer.toString(mode, 16));
                    return false;
                }
            }
            if (Int10_modes.CurMode.type == 9) {
                if ((modeset_ctl & 0x90) == 128) {
                    if (Int10_modes.CurMode.mode <= 3) {
                        CurMode = ModeList_VGA_Text_200lines[Int10_modes.CurMode.mode];
                    }
                } else if ((modeset_ctl & 0x90) == 0 && Int10_modes.CurMode.mode <= 3) {
                    CurMode = ModeList_VGA_Text_350lines[Int10_modes.CurMode.mode];
                }
            }
        } else if (!Int10_modes.SetCurMode(ModeList_EGA, mode)) {
            Log.log(4, 2, "EGA:Trying to set illegal mode " + Integer.toString(mode, 16));
            return false;
        }
        boolean mono_mode = mode == 7 || mode == 15;
        int crtc_base = mono_mode ? 948 : 980;
        if (Dosbox.IS_VGA_ARCH() && Dosbox.svgaCard == 1) {
            IoHandler.IO_Write(crtc_base, 83);
            IoHandler.IO_Write(crtc_base + 1, 0);
        }
        int misc_output = 2 | (mono_mode ? 0 : 1);
        if (Int10_modes.CurMode.type == 9 && Int10_modes.CurMode.cwidth == 9) {
            misc_output |= 4;
        }
        switch (Int10_modes.CurMode.vdispend) {
            case 400: {
                misc_output |= 0x60;
                break;
            }
            case 480: {
                misc_output |= 0xE0;
                break;
            }
            case 350: {
                misc_output |= 0xA0;
                break;
            }
            default: {
                misc_output |= 0x60;
            }
        }
        IoHandler.IO_Write(962, misc_output);
        short[] seq_data = new short[5];
        seq_data[1] = (short)(seq_data[1] | 1);
        if ((Int10_modes.CurMode.special & 1) != 0) {
            seq_data[1] = (short)(seq_data[1] | 8);
        }
        if (Dosbox.machine == 4 && (Int10_modes.CurMode.special & 1) != 0) {
            seq_data[1] = (short)(seq_data[1] | 2);
        }
        seq_data[4] = (short)(seq_data[4] | 2);
        switch (Int10_modes.CurMode.type) {
            case 9: {
                if (Int10_modes.CurMode.cwidth == 9) {
                    seq_data[1] = (short)(seq_data[1] & 0xFFFFFFFE);
                }
                seq_data[2] = (short)(seq_data[2] | 3);
                seq_data[4] = (short)(seq_data[4] | 1);
                if (!Dosbox.IS_VGA_ARCH()) break;
                seq_data[4] = (short)(seq_data[4] | 4);
                break;
            }
            case 0: {
                seq_data[2] = (short)(seq_data[2] | 0xF);
                if (Dosbox.machine != 4) break;
                seq_data[4] = (short)(seq_data[4] | 4);
                break;
            }
            case 1: {
                if (Dosbox.machine != 4) break;
                seq_data[2] = (short)(seq_data[2] | 3);
                break;
            }
            case 2: 
            case 4: {
                seq_data[2] = (short)(seq_data[2] | 0xF);
                if (Dosbox.machine != 4) break;
                seq_data[4] = (short)(seq_data[4] | 4);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                seq_data[2] = (short)(seq_data[2] | 0xF);
                seq_data[4] = (short)(seq_data[4] | 0xC);
            }
        }
        for (ct2 = 0; ct2 < 5; ct2 = (int)((short)(ct2 + 1))) {
            IoHandler.IO_Write(964, ct2);
            IoHandler.IO_Write(965, seq_data[ct2]);
        }
        VGA.vga.config.compatible_chain4 = true;
        IoHandler.IO_Write(crtc_base, 17);
        IoHandler.IO_Write(crtc_base + 1, IoHandler.IO_Read(crtc_base + 1) & 0x7F);
        for (ct2 = 0; ct2 <= 24; ct2 = (int)((byte)(ct2 + 1))) {
            IoHandler.IO_Write(crtc_base, ct2);
            IoHandler.IO_Write(crtc_base + 1, 0);
        }
        int overflow = 0;
        int max_scanline = 0;
        int ver_overflow = 0;
        int hor_overflow = 0;
        IoHandler.IO_Write(crtc_base, 0);
        IoHandler.IO_Write(crtc_base + 1, Int10_modes.CurMode.htotal - 5);
        hor_overflow = (short)(hor_overflow | (Int10_modes.CurMode.htotal - 5 & 0x100) >> 8);
        IoHandler.IO_Write(crtc_base, 1);
        IoHandler.IO_Write(crtc_base + 1, Int10_modes.CurMode.hdispend - 1);
        hor_overflow = (short)(hor_overflow | (Int10_modes.CurMode.hdispend - 1 & 0x100) >> 7);
        IoHandler.IO_Write(crtc_base, 2);
        IoHandler.IO_Write(crtc_base + 1, Int10_modes.CurMode.hdispend);
        hor_overflow = (short)(hor_overflow | (Int10_modes.CurMode.hdispend & 0x100) >> 6);
        int blank_end = Int10_modes.CurMode.htotal - 2 & 0x7F;
        IoHandler.IO_Write(crtc_base, 3);
        IoHandler.IO_Write(crtc_base + 1, 0x80 | blank_end & 0x1F);
        int ret_start = (Int10_modes.CurMode.special & 1) != 0 && Int10_modes.CurMode.type != 0 ? Int10_modes.CurMode.hdispend + 3 : (Int10_modes.CurMode.type == 9 ? Int10_modes.CurMode.hdispend + 5 : Int10_modes.CurMode.hdispend + 4);
        IoHandler.IO_Write(crtc_base, 4);
        IoHandler.IO_Write(crtc_base + 1, ret_start);
        hor_overflow = (short)(hor_overflow | (ret_start & 0x100) >> 4);
        int ret_end = (Int10_modes.CurMode.special & 1) != 0 ? (Int10_modes.CurMode.type == 0 ? 0 : ((Int10_modes.CurMode.special & 2) != 0 ? Int10_modes.CurMode.htotal - 18 & 0x1F : Int10_modes.CurMode.htotal - 18 & 0x1F | 0x20)) : (Int10_modes.CurMode.type == 9 ? Int10_modes.CurMode.htotal - 3 & 0x1F : Int10_modes.CurMode.htotal - 4 & 0x1F);
        IoHandler.IO_Write(crtc_base, 5);
        IoHandler.IO_Write(crtc_base + 1, ret_end | (blank_end & 0x20) << 2);
        IoHandler.IO_Write(crtc_base, 6);
        IoHandler.IO_Write(crtc_base + 1, Int10_modes.CurMode.vtotal - 2);
        overflow = (short)(overflow | (Int10_modes.CurMode.vtotal - 2 & 0x100) >> 8);
        overflow = (short)(overflow | (Int10_modes.CurMode.vtotal - 2 & 0x200) >> 4);
        ver_overflow = (short)(ver_overflow | (Int10_modes.CurMode.vtotal - 2 & 0x400) >> 10);
        if (Dosbox.IS_VGA_ARCH()) {
            switch (Int10_modes.CurMode.vdispend) {
                case 400: {
                    vretrace = Int10_modes.CurMode.vdispend + 12;
                    break;
                }
                case 480: {
                    vretrace = Int10_modes.CurMode.vdispend + 10;
                    break;
                }
                case 350: {
                    vretrace = Int10_modes.CurMode.vdispend + 37;
                    break;
                }
                default: {
                    vretrace = Int10_modes.CurMode.vdispend + 12;
                    break;
                }
            }
        } else {
            switch (Int10_modes.CurMode.vdispend) {
                case 350: {
                    vretrace = Int10_modes.CurMode.vdispend;
                    break;
                }
                default: {
                    vretrace = Int10_modes.CurMode.vdispend + 24;
                }
            }
        }
        IoHandler.IO_Write(crtc_base, 16);
        IoHandler.IO_Write(crtc_base + 1, vretrace);
        overflow = (short)(overflow | (vretrace & 0x100) >> 6);
        overflow = (short)(overflow | (vretrace & 0x200) >> 2);
        ver_overflow = (short)(ver_overflow | (vretrace & 0x400) >> 6);
        IoHandler.IO_Write(crtc_base, 17);
        IoHandler.IO_Write(crtc_base + 1, vretrace + 2 & 0xF);
        IoHandler.IO_Write(crtc_base, 18);
        IoHandler.IO_Write(crtc_base + 1, Int10_modes.CurMode.vdispend - 1);
        overflow = (short)(overflow | (Int10_modes.CurMode.vdispend - 1 & 0x100) >> 7);
        overflow = (short)(overflow | (Int10_modes.CurMode.vdispend - 1 & 0x200) >> 3);
        ver_overflow = (short)(ver_overflow | (Int10_modes.CurMode.vdispend - 1 & 0x400) >> 9);
        if (Dosbox.IS_VGA_ARCH()) {
            switch (Int10_modes.CurMode.vdispend) {
                case 400: {
                    vblank_trim = 6;
                    break;
                }
                case 480: {
                    vblank_trim = 7;
                    break;
                }
                case 350: {
                    vblank_trim = 5;
                    break;
                }
                default: {
                    vblank_trim = 8;
                    break;
                }
            }
        } else {
            switch (Int10_modes.CurMode.vdispend) {
                case 350: {
                    vblank_trim = 0;
                    break;
                }
                default: {
                    vblank_trim = 23;
                }
            }
        }
        IoHandler.IO_Write(crtc_base, 21);
        IoHandler.IO_Write(crtc_base + 1, Int10_modes.CurMode.vdispend + vblank_trim);
        overflow = (short)(overflow | (Int10_modes.CurMode.vdispend + vblank_trim & 0x100) >> 5);
        max_scanline = (short)(max_scanline | (Int10_modes.CurMode.vdispend + vblank_trim & 0x200) >> 4);
        ver_overflow = (short)(ver_overflow | (Int10_modes.CurMode.vdispend + vblank_trim & 0x400) >> 8);
        IoHandler.IO_Write(crtc_base, 22);
        IoHandler.IO_Write(crtc_base + 1, Int10_modes.CurMode.vtotal - vblank_trim - 2);
        int line_compare = Int10_modes.CurMode.vtotal < 1024 ? 1023 : 2047;
        IoHandler.IO_Write(crtc_base, 24);
        IoHandler.IO_Write(crtc_base + 1, line_compare & 0xFF);
        overflow = (short)(overflow | (line_compare & 0x100) >> 4);
        max_scanline = (short)(max_scanline | (line_compare & 0x200) >> 3);
        ver_overflow = (short)(ver_overflow | (line_compare & 0x400) >> 4);
        int underline = 0;
        if ((Int10_modes.CurMode.special & 2) != 0 && Dosbox.machine != 4) {
            max_scanline = (short)(max_scanline | 0x80);
        }
        switch (Int10_modes.CurMode.type) {
            case 9: {
                max_scanline = (short)(max_scanline | Int10_modes.CurMode.cheight - 1);
                underline = (short)(mono_mode ? 15 : 31);
                break;
            }
            case 3: {
                underline = 64;
                max_scanline = (short)(max_scanline | 1);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                underline = 96;
                break;
            }
            case 0: 
            case 1: {
                max_scanline = (short)(max_scanline | 1);
            }
        }
        if (Int10_modes.CurMode.vdispend == 350) {
            underline = 15;
        }
        IoHandler.IO_Write(crtc_base, 9);
        IoHandler.IO_Write(crtc_base + 1, max_scanline);
        IoHandler.IO_Write(crtc_base, 20);
        IoHandler.IO_Write(crtc_base + 1, underline);
        IoHandler.IO_Write(crtc_base, 7);
        IoHandler.IO_Write(crtc_base + 1, overflow);
        if (Dosbox.svgaCard == 1) {
            IoHandler.IO_Write(crtc_base, 93);
            IoHandler.IO_Write(crtc_base + 1, hor_overflow);
            IoHandler.IO_Write(crtc_base, 94);
            IoHandler.IO_Write(crtc_base + 1, ver_overflow);
        }
        switch (Int10_modes.CurMode.type) {
            case 5: {
                offset = Int10_modes.CurMode.swidth / 8;
                break;
            }
            case 6: 
            case 7: {
                offset = 2 * Int10_modes.CurMode.swidth / 8;
                break;
            }
            case 8: {
                offset = 4 * Int10_modes.CurMode.swidth / 8;
                break;
            }
            default: {
                offset = Int10_modes.CurMode.hdispend / 2;
            }
        }
        IoHandler.IO_Write(crtc_base, 19);
        IoHandler.IO_Write(crtc_base + 1, offset & 0xFF);
        if (Dosbox.svgaCard == 1) {
            IoHandler.IO_Write(crtc_base, 81);
            IoHandler.IO_Write(crtc_base + 1, (offset & 0x300) >> 4);
            IoHandler.IO_Write(crtc_base, 105);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 94);
            IoHandler.IO_Write(crtc_base + 1, ver_overflow);
        }
        int mode_control = 0;
        switch (Int10_modes.CurMode.type) {
            case 0: {
                mode_control = 194;
                break;
            }
            case 1: {
                mode_control = 162;
                break;
            }
            case 2: 
            case 4: {
                if (Int10_modes.CurMode.mode == 17) {
                    mode_control = 195;
                    break;
                }
                if (Dosbox.machine == 4) {
                    if ((Int10_modes.CurMode.special & 2) != 0) {
                        mode_control = 195;
                        break;
                    }
                    mode_control = 139;
                    break;
                }
                mode_control = 227;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                mode_control = 163;
                if ((Int10_modes.CurMode.special & 4) == 0) break;
                mode_control = (short)(mode_control | 8);
            }
        }
        IoHandler.IO_Write(crtc_base, 23);
        IoHandler.IO_Write(crtc_base + 1, mode_control);
        IoHandler.IO_Write(crtc_base, 17);
        IoHandler.IO_Write(crtc_base + 1, IoHandler.IO_Read(crtc_base + 1) | 0x80);
        if (Dosbox.svgaCard == 1) {
            int misc_control_2;
            if (Int10_modes.CurMode.mode >= 256) {
                misc_output |= 0xEF;
                int clock = Int10_modes.CurMode.vtotal * 8 * Int10_modes.CurMode.htotal * 70;
                VGA.VGA_SetClock(3, clock / 1000);
            }
            switch (Int10_modes.CurMode.type) {
                case 5: {
                    misc_control_2 = 0;
                    break;
                }
                case 6: {
                    misc_control_2 = 48;
                    break;
                }
                case 7: {
                    misc_control_2 = 80;
                    break;
                }
                case 8: {
                    misc_control_2 = 208;
                    break;
                }
                default: {
                    misc_control_2 = 0;
                }
            }
            IO.IO_WriteB(crtc_base, 103);
            IO.IO_WriteB(crtc_base + 1, misc_control_2);
        }
        IoHandler.IO_Write(962, misc_output);
        short[] gfx_data = new short[9];
        gfx_data[7] = 15;
        gfx_data[8] = 255;
        switch (Int10_modes.CurMode.type) {
            case 9: {
                gfx_data[5] = (short)(gfx_data[5] | 0x10);
                gfx_data[6] = (short)(gfx_data[6] | (mono_mode ? 10 : 14));
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                gfx_data[5] = (short)(gfx_data[5] | 0x40);
                gfx_data[6] = (short)(gfx_data[6] | 5);
                break;
            }
            case 2: 
            case 4: {
                gfx_data[6] = (short)(gfx_data[6] | 5);
                break;
            }
            case 1: {
                gfx_data[5] = (short)(gfx_data[5] | 0x20);
                gfx_data[6] = (short)(gfx_data[6] | 0xF);
                if (Dosbox.machine != 4) break;
                gfx_data[5] = (short)(gfx_data[5] | 0x10);
                break;
            }
            case 0: {
                gfx_data[6] = Dosbox.machine == 4 ? (short)(gfx_data[6] | 0xD) : (short)(gfx_data[6] | 0xF);
            }
        }
        for (int ct3 = 0; ct3 < 9; ct3 = (int)((short)(ct3 + 1))) {
            IoHandler.IO_Write(974, ct3);
            IoHandler.IO_Write(975, gfx_data[ct3]);
        }
        short[] att_data = new short[21];
        att_data[18] = 15;
        block62 : switch (Int10_modes.CurMode.type) {
            case 2: 
            case 4: {
                att_data[16] = 1;
                switch (Int10_modes.CurMode.mode) {
                    case 15: {
                        att_data[16] = (short)(att_data[16] | 0xA);
                        att_data[1] = 8;
                        att_data[4] = 24;
                        att_data[5] = 24;
                        att_data[9] = 8;
                        att_data[13] = 24;
                        break block62;
                    }
                    case 17: {
                        for (i = 1; i < 16; ++i) {
                            att_data[i] = 63;
                        }
                        break block62;
                    }
                    case 16: 
                    case 18: {
                        Int10_modes.att_text16(att_data);
                        break block62;
                    }
                }
                if (Int10_modes.CurMode.type == 4) {
                    Int10_modes.att_text16(att_data);
                    break;
                }
                for (ct = 0; ct < 8; ct = (int)((short)(ct + 1))) {
                    att_data[ct] = ct;
                    att_data[ct + 8] = (short)(ct + 16);
                }
                break;
            }
            case 15: {
                att_data[16] = 1;
                for (ct = 0; ct < 16; ct = (int)((short)(ct + 1))) {
                    att_data[ct] = ct;
                }
                break;
            }
            case 9: {
                if (Int10_modes.CurMode.cwidth == 9) {
                    att_data[19] = 8;
                    att_data[16] = 12;
                } else {
                    att_data[19] = 0;
                    att_data[16] = 8;
                }
                Memory.real_writeb(64, 102, 48);
                Int10_modes.att_text16(att_data);
                break;
            }
            case 0: {
                att_data[16] = 1;
                att_data[0] = 0;
                for (i = 1; i < 16; ++i) {
                    att_data[i] = 23;
                }
                att_data[18] = 1;
                Memory.real_writeb(64, 102, 63);
                break;
            }
            case 1: {
                att_data[16] = 1;
                att_data[0] = 0;
                att_data[1] = 19;
                att_data[2] = 21;
                att_data[3] = 23;
                att_data[4] = 2;
                att_data[5] = 4;
                att_data[6] = 6;
                att_data[7] = 7;
                for (ct = 8; ct < 16; ct = (int)((short)(ct + 1))) {
                    att_data[ct] = (short)(ct + 8);
                }
                Memory.real_writeb(64, 102, 48);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                for (ct = 0; ct < 16; ct = (int)((short)(ct + 1))) {
                    att_data[ct] = ct;
                }
                att_data[16] = 65;
            }
        }
        IoHandler.IO_Read(mono_mode ? 954 : 986);
        if ((modeset_ctl & 8) == 0) {
            for (ct = 0; ct < 21; ct = (int)((short)(ct + 1))) {
                IoHandler.IO_Write(960, ct);
                IoHandler.IO_Write(960, att_data[ct]);
            }
            VGA.vga.config.pel_panning = 0;
            IoHandler.IO_Write(960, 32);
            IoHandler.IO_Write(960, 0);
            IoHandler.IO_Write(966, 255);
            IoHandler.IO_Write(968, 0);
            switch (Int10_modes.CurMode.type) {
                case 2: {
                    if (Int10_modes.CurMode.mode > 15) {
                        for (i = 0; i < 64; ++i) {
                            IoHandler.IO_Write(969, text_palette[i][0]);
                            IoHandler.IO_Write(969, text_palette[i][1]);
                            IoHandler.IO_Write(969, text_palette[i][2]);
                        }
                    } else if (Int10_modes.CurMode.mode == 15) {
                        for (i = 0; i < 64; ++i) {
                            IoHandler.IO_Write(969, mtext_s3_palette[i][0]);
                            IoHandler.IO_Write(969, mtext_s3_palette[i][1]);
                            IoHandler.IO_Write(969, mtext_s3_palette[i][2]);
                        }
                    } else {
                        for (i = 0; i < 64; ++i) {
                            IoHandler.IO_Write(969, ega_palette[i][0]);
                            IoHandler.IO_Write(969, ega_palette[i][1]);
                            IoHandler.IO_Write(969, ega_palette[i][2]);
                        }
                    }
                    break;
                }
                case 0: 
                case 1: 
                case 15: {
                    for (i = 0; i < 64; ++i) {
                        IoHandler.IO_Write(969, cga_palette_2[i][0]);
                        IoHandler.IO_Write(969, cga_palette_2[i][1]);
                        IoHandler.IO_Write(969, cga_palette_2[i][2]);
                    }
                    break;
                }
                case 9: {
                    if (Int10_modes.CurMode.mode == 7) {
                        if (Dosbox.IS_VGA_ARCH() && Dosbox.svgaCard == 1) {
                            for (i = 0; i < 64; ++i) {
                                IoHandler.IO_Write(969, mtext_s3_palette[i][0]);
                                IoHandler.IO_Write(969, mtext_s3_palette[i][1]);
                                IoHandler.IO_Write(969, mtext_s3_palette[i][2]);
                            }
                        } else {
                            for (i = 0; i < 64; ++i) {
                                IoHandler.IO_Write(969, mtext_palette[i][0]);
                                IoHandler.IO_Write(969, mtext_palette[i][1]);
                                IoHandler.IO_Write(969, mtext_palette[i][2]);
                            }
                        }
                        break;
                    }
                }
                case 4: {
                    for (i = 0; i < 64; ++i) {
                        IoHandler.IO_Write(969, text_palette[i][0]);
                        IoHandler.IO_Write(969, text_palette[i][1]);
                        IoHandler.IO_Write(969, text_palette[i][2]);
                    }
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    for (i = 0; i < 256; ++i) {
                        IoHandler.IO_Write(969, vga_palette[i][0]);
                        IoHandler.IO_Write(969, vga_palette[i][1]);
                        IoHandler.IO_Write(969, vga_palette[i][2]);
                    }
                    break;
                }
            }
            if (Dosbox.IS_VGA_ARCH() && (Memory.real_readb(64, 137) & 2) != 0) {
                Int10_pal.INT10_PerformGrayScaleSumming(0, 256);
            }
        } else {
            for (ct = 16; ct < 21; ct = (int)((short)(ct + 1))) {
                if (ct == 17) continue;
                IoHandler.IO_Write(960, ct);
                IoHandler.IO_Write(960, att_data[ct]);
            }
            VGA.vga.config.pel_panning = 0;
            IoHandler.IO_Write(960, 32);
        }
        short feature = Memory.real_readb(64, 16);
        switch (Int10_modes.CurMode.type) {
            case 0: {
                feature = (short)(feature & 0xFFFFFFCF | 0x20);
                Memory.real_writeb(64, 101, 30);
                break;
            }
            case 1: {
                feature = (short)(feature & 0xFFFFFFCF | 0x20);
                if (Int10_modes.CurMode.mode == 4) {
                    Memory.real_writeb(64, 101, 42);
                    break;
                }
                if (Int10_modes.CurMode.mode == 5) {
                    Memory.real_writeb(64, 101, 46);
                    break;
                }
                Memory.real_writeb(64, 101, 2);
                break;
            }
            case 15: {
                feature = (short)(feature & 0xFFFFFFCF | 0x20);
                break;
            }
            case 9: {
                feature = (short)(feature & 0xFFFFFFCF | 0x20);
                switch (Int10_modes.CurMode.mode) {
                    case 0: {
                        Memory.real_writeb(64, 101, 44);
                        break;
                    }
                    case 1: {
                        Memory.real_writeb(64, 101, 40);
                        break;
                    }
                    case 2: {
                        Memory.real_writeb(64, 101, 45);
                        break;
                    }
                    case 3: 
                    case 7: {
                        Memory.real_writeb(64, 101, 41);
                    }
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                feature = (short)(feature & 0xFFFFFFCF);
            }
        }
        if (Dosbox.svgaCard == 1) {
            int reg_31;
            int reg_3a;
            IoHandler.IO_Write(crtc_base, 106);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 89);
            IoHandler.IO_Write(crtc_base + 1, 192);
            IoHandler.IO_Write(crtc_base, 90);
            IoHandler.IO_Write(crtc_base + 1, 0);
            IoHandler.IO_Write(crtc_base, 107);
            IoHandler.IO_Write(crtc_base + 1, 192);
            IoHandler.IO_Write(crtc_base, 65);
            IoHandler.IO_Write(crtc_base + 1, 136);
            IoHandler.IO_Write(crtc_base, 82);
            IoHandler.IO_Write(crtc_base + 1, 128);
            IoHandler.IO_Write(964, 21);
            IoHandler.IO_Write(965, 3);
            int reg_50 = 0;
            switch (Int10_modes.CurMode.type) {
                case 6: 
                case 7: {
                    reg_50 |= 0x10;
                    break;
                }
                case 8: {
                    reg_50 |= 0x30;
                    break;
                }
            }
            switch (Int10_modes.CurMode.swidth) {
                case 640: {
                    reg_50 |= 0x40;
                    break;
                }
                case 800: {
                    reg_50 |= 0x80;
                    break;
                }
                case 1024: {
                    reg_50 |= 0;
                    break;
                }
                case 1152: {
                    reg_50 |= 1;
                    break;
                }
                case 1280: {
                    reg_50 |= 0xC0;
                    break;
                }
            }
            IO.IO_WriteB(crtc_base, 80);
            IO.IO_WriteB(crtc_base + 1, reg_50);
            switch (Int10_modes.CurMode.type) {
                case 6: 
                case 7: 
                case 8: {
                    reg_3a = 21;
                    break;
                }
                case 5: {
                    if ((Int10_modes.CurMode.special & 4) != 0) {
                        reg_3a = 5;
                        break;
                    }
                    reg_3a = 21;
                    break;
                }
                default: {
                    reg_3a = 5;
                }
            }
            switch (Int10_modes.CurMode.type) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    reg_31 = 9;
                    break;
                }
                default: {
                    reg_31 = 5;
                }
            }
            IoHandler.IO_Write(crtc_base, 58);
            IoHandler.IO_Write(crtc_base + 1, reg_3a);
            IoHandler.IO_Write(crtc_base, 49);
            IoHandler.IO_Write(crtc_base + 1, reg_31);
            IoHandler.IO_Write(crtc_base, 88);
            IoHandler.IO_Write(crtc_base + 1, 3);
            IoHandler.IO_Write(crtc_base, 56);
            IoHandler.IO_Write(crtc_base + 1, 72);
            IoHandler.IO_Write(crtc_base, 57);
            IoHandler.IO_Write(crtc_base + 1, 165);
        } else if (VGA.svga.set_video_mode != null) {
            VGA.VGA_ModeExtraData modeData = new VGA.VGA_ModeExtraData();
            modeData.ver_overflow = (short)ver_overflow;
            modeData.hor_overflow = (short)hor_overflow;
            modeData.offset = offset;
            modeData.modeNo = Int10_modes.CurMode.mode;
            modeData.htotal = Int10_modes.CurMode.htotal;
            modeData.vtotal = Int10_modes.CurMode.vtotal;
            VGA.svga.set_video_mode.call(crtc_base, modeData);
        }
        Int10_modes.FinishSetMode(clearmem);
        IoHandler.IO_Read(mono_mode ? 954 : 986);
        IoHandler.IO_Write(960, 32);
        if (Int10_modes.CurMode.type == 9) {
            Int10_memory.INT10_ReloadFont();
        }
        return true;
    }

    public static int VideoModeMemSize(int mode) {
        if (!Dosbox.IS_VGA_ARCH()) {
            return 0;
        }
        Int10.VideoModeBlock[] modelist = null;
        switch (Dosbox.svgaCard) {
            case 2: 
            case 3: {
                modelist = ModeList_VGA_Tseng;
                break;
            }
            case 4: {
                modelist = ModeList_VGA_Paradise;
                break;
            }
            default: {
                modelist = ModeList_VGA;
            }
        }
        Int10.VideoModeBlock vmodeBlock = null;
        int i = 0;
        while (modelist[i].mode != 65535) {
            if (modelist[i].mode == mode) {
                vmodeBlock = modelist[i];
                break;
            }
            ++i;
        }
        if (vmodeBlock == null) {
            return 0;
        }
        switch (vmodeBlock.type) {
            case 4: {
                return vmodeBlock.swidth * vmodeBlock.sheight / 2;
            }
            case 5: {
                return vmodeBlock.swidth * vmodeBlock.sheight;
            }
            case 6: 
            case 7: {
                return vmodeBlock.swidth * vmodeBlock.sheight * 2;
            }
            case 8: {
                return vmodeBlock.swidth * vmodeBlock.sheight * 4;
            }
            case 9: {
                return vmodeBlock.twidth * vmodeBlock.theight * 2;
            }
        }
        return 0;
    }
}

