/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.Dosbox;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.ints.Int10_modes;
import jdos.misc.Log;

public class Int10_put_pixel {
    private static short[] cga_masks = new short[]{63, 207, 243, 252};
    private static short[] cga_masks2 = new short[]{127, 191, 223, 239, 247, 251, 253, 254};
    private static boolean putpixelwarned = false;

    public static void INT10_PutPixel(int x, int y, short page, short color) {
        switch (Int10_modes.CurMode.type) {
            case 1: {
                if (Memory.real_readb(64, 73) <= 5) {
                    int off = (y >> 1) * 80 + (x >> 2);
                    if ((y & 1) != 0) {
                        off += 8192;
                    }
                    short old = Memory.real_readb(47104, off);
                    if ((color & 0x80) != 0) {
                        color = (short)(color & 3);
                        old = (short)(old ^ color << 2 * (3 - (x & 3)));
                    } else {
                        old = (short)(old & cga_masks[x & 3] | (color & 3) << 2 * (3 - (x & 3)));
                    }
                    Memory.real_writeb(47104, off, old);
                    break;
                }
                int off = (y >> 2) * 160 + (x >> 2 & 0xFFFFFFFE);
                int old = Memory.real_readw(47104, off += 8192 * (y & 3));
                if ((color & 0x80) != 0) {
                    old ^= (color & 1) << 7 - (x & 7);
                    old ^= (color & 2) >> 1 << 7 - (x & 7) + 8;
                } else {
                    old = old & ~(257 << 7 - (x & 7)) | (color & 1) << 7 - (x & 7) | (color & 2) >> 1 << 7 - (x & 7) + 8;
                }
                Memory.real_writew(47104, off, old);
                break;
            }
            case 0: {
                int off = (y >> 1) * 80 + (x >> 3);
                if ((y & 1) != 0) {
                    off += 8192;
                }
                short old = Memory.real_readb(47104, off);
                if ((color & 0x80) != 0) {
                    color = (short)(color & 1);
                    old = (short)(old ^ color << 7 - (x & 7));
                } else {
                    old = (short)(old & cga_masks2[x & 7] | (color & 1) << 7 - (x & 7));
                }
                Memory.real_writeb(47104, off, old);
                break;
            }
            case 15: {
                IoHandler.IO_Write(980, 9);
                short scanlines_m1 = IoHandler.IO_Read(981);
                int off = (y >> (scanlines_m1 == 1 ? 1 : 2)) * (Int10_modes.CurMode.swidth >> 1) + (x >> 1);
                short old = Memory.real_readb(47104, off += 8192 * (y & scanlines_m1));
                short[] p = new short[2];
                p[1] = (short)(old >> 4 & 0xF);
                p[0] = (short)(old & 0xF);
                int ind = 1 - (x & 1);
                if ((color & 0x80) != 0) {
                    int n = ind;
                    p[n] = (short)(p[n] ^ color & 0x7F);
                } else {
                    p[ind] = color;
                }
                old = (short)(p[1] << 4 | p[0]);
                Memory.real_writeb(47104, off, old);
                break;
            }
            case 4: {
                if (Dosbox.machine != 5 || Dosbox.svgaCard != 2 || Int10_modes.CurMode.swidth > 800) break;
            }
            case 2: {
                IoHandler.IO_Write(974, 8);
                short mask = (short)(128 >> (x & 7));
                IoHandler.IO_Write(975, mask);
                IoHandler.IO_Write(974, 0);
                IoHandler.IO_Write(975, color);
                IoHandler.IO_Write(974, 1);
                IoHandler.IO_Write(975, 15);
                if ((color & 0x80) != 0) {
                    IoHandler.IO_Write(974, 3);
                    IoHandler.IO_Write(975, 24);
                }
                if (Int10_modes.CurMode.plength != Memory.real_readw(64, 76)) {
                    Log.log(4, 2, "PutPixel_EGA_p: " + Integer.toString(Int10_modes.CurMode.plength, 16) + "!=" + Integer.toString(Memory.real_readw(64, 76), 16));
                }
                if (Int10_modes.CurMode.swidth != Memory.real_readw(64, 74) * 8) {
                    Log.log(4, 2, "PutPixel_EGA_w: " + Integer.toString(Int10_modes.CurMode.swidth, 16) + "!=" + Integer.toString(Memory.real_readw(64, 74) * 8, 16));
                }
                int off = 655360 + Memory.real_readw(64, 76) * page + (y * Memory.real_readw(64, 74) * 8 + x >> 3);
                Memory.mem_readb(off);
                Memory.mem_writeb(off, 255);
                IoHandler.IO_Write(974, 8);
                IoHandler.IO_Write(975, 255);
                IoHandler.IO_Write(974, 1);
                IoHandler.IO_Write(975, 0);
                if ((color & 0x80) == 0) break;
                IoHandler.IO_Write(974, 3);
                IoHandler.IO_Write(975, 0);
                break;
            }
            case 3: {
                Memory.mem_writeb(Memory.PhysMake(40960, y * 320 + x), color);
                break;
            }
            case 5: {
                if (Int10_modes.CurMode.swidth != Memory.real_readw(64, 74) * 8) {
                    Log.log(4, 2, "PutPixel_VGA_w: " + Integer.toString(Int10_modes.CurMode.swidth, 16) + "!=" + Integer.toString(Memory.real_readw(64, 74) * 8, 16));
                }
                int off = -1073741824 + y * Memory.real_readw(64, 74) * 8 + x;
                Memory.mem_writeb(off, color);
                break;
            }
            default: {
                if (putpixelwarned) break;
                putpixelwarned = true;
                Log.log(4, 2, "PutPixel unhandled mode type " + Int10_modes.CurMode.type);
            }
        }
    }

    public static short INT10_GetPixel(int x, int y, short page) {
        int color = 0;
        switch (Int10_modes.CurMode.type) {
            case 1: {
                int off = (y >> 1) * 80 + (x >> 2);
                if ((y & 1) != 0) {
                    off += 8192;
                }
                short val = Memory.real_readb(47104, off);
                color = val >> (3 - (x & 3)) * 2 & 3;
                break;
            }
            case 0: {
                int off = (y >> 1) * 80 + (x >> 3);
                if ((y & 1) != 0) {
                    off += 8192;
                }
                short val = Memory.real_readb(47104, off);
                color = val >> 7 - (x & 7) & 1;
                break;
            }
            case 2: {
                if (Int10_modes.CurMode.plength != Memory.real_readw(64, 76)) {
                    Log.log(4, 2, "GetPixel_EGA_p: " + Integer.toString(Int10_modes.CurMode.plength, 16) + "!=" + Integer.toString(Memory.real_readw(64, 76), 16));
                }
                if (Int10_modes.CurMode.swidth != Memory.real_readw(64, 74) * 8) {
                    Log.log(4, 2, "GetPixel_EGA_w: " + Integer.toString(Int10_modes.CurMode.swidth, 16) + "!=" + Integer.toString(Memory.real_readw(64, 74) * 8, 16));
                }
                int off = 655360 + Memory.real_readw(64, 76) * page + (y * Memory.real_readw(64, 74) * 8 + x >> 3);
                int shift = 7 - (x & 7);
                color = 0;
                IoHandler.IO_Write(974, 4);
                IoHandler.IO_Write(975, 0);
                color |= (Memory.mem_readb(off) >> shift & 1) << 0;
                IoHandler.IO_Write(974, 4);
                IoHandler.IO_Write(975, 1);
                color |= (Memory.mem_readb(off) >> shift & 1) << 1;
                IoHandler.IO_Write(974, 4);
                IoHandler.IO_Write(975, 2);
                color |= (Memory.mem_readb(off) >> shift & 1) << 2;
                IoHandler.IO_Write(974, 4);
                IoHandler.IO_Write(975, 3);
                color |= (Memory.mem_readb(off) >> shift & 1) << 3;
                break;
            }
            case 3: {
                color = Memory.mem_readb(Memory.PhysMake(40960, 320 * y + x));
                break;
            }
            case 5: {
                if (Int10_modes.CurMode.swidth != Memory.real_readw(64, 74) * 8) {
                    Log.log(4, 2, "GetPixel_VGA_w: " + Integer.toString(Int10_modes.CurMode.swidth, 16) + "!=" + Integer.toString(Memory.real_readw(64, 74) * 8, 16));
                }
                int off = -1073741824 + y * Memory.real_readw(64, 74) * 8 + x;
                color = Memory.mem_readb(off);
                break;
            }
            default: {
                Log.log(4, 2, "GetPixel unhandled mode type " + Int10_modes.CurMode.type);
            }
        }
        return (short)color;
    }
}

