/*
 * Decompiled with CFR 0.152.
 */
package jdos.ints;

import jdos.cpu.CPU;
import jdos.cpu.CPU_Regs;
import jdos.cpu.Callback;
import jdos.dos.Dos;
import jdos.dos.Dos_memory;
import jdos.dos.Dos_misc;
import jdos.dos.Dos_system;
import jdos.dos.Dos_tables;
import jdos.hardware.IoHandler;
import jdos.hardware.Memory;
import jdos.ints.Bios;
import jdos.ints.EMS;
import jdos.misc.Log;
import jdos.misc.setup.Module_base;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_prop;
import jdos.util.IntRef;
import jdos.util.ShortRef;

public class XMS
extends Module_base {
    private static final int XMS_HANDLES = 50;
    private static final int XMS_VERSION = 768;
    private static final int XMS_DRIVER_VERSION = 769;
    private static final int XMS_GET_VERSION = 0;
    private static final int XMS_ALLOCATE_HIGH_MEMORY = 1;
    private static final int XMS_FREE_HIGH_MEMORY = 2;
    private static final int XMS_GLOBAL_ENABLE_A20 = 3;
    private static final int XMS_GLOBAL_DISABLE_A20 = 4;
    private static final int XMS_LOCAL_ENABLE_A20 = 5;
    private static final int XMS_LOCAL_DISABLE_A20 = 6;
    private static final int XMS_QUERY_A20 = 7;
    private static final int XMS_QUERY_FREE_EXTENDED_MEMORY = 8;
    private static final int XMS_ALLOCATE_EXTENDED_MEMORY = 9;
    private static final int XMS_FREE_EXTENDED_MEMORY = 10;
    private static final int XMS_MOVE_EXTENDED_MEMORY_BLOCK = 11;
    private static final int XMS_LOCK_EXTENDED_MEMORY_BLOCK = 12;
    private static final int XMS_UNLOCK_EXTENDED_MEMORY_BLOCK = 13;
    private static final int XMS_GET_EMB_HANDLE_INFORMATION = 14;
    private static final int XMS_RESIZE_EXTENDED_MEMORY_BLOCK = 15;
    private static final int XMS_ALLOCATE_UMB = 16;
    private static final int XMS_DEALLOCATE_UMB = 17;
    private static final int XMS_QUERY_ANY_FREE_MEMORY = 136;
    private static final int XMS_ALLOCATE_ANY_MEMORY = 137;
    private static final int XMS_GET_EMB_HANDLE_INFORMATION_EXT = 142;
    private static final int XMS_RESIZE_ANY_EXTENDED_MEMORY_BLOCK = 143;
    private static final int XMS_FUNCTION_NOT_IMPLEMENTED = 128;
    private static final int HIGH_MEMORY_NOT_EXIST = 144;
    private static final int HIGH_MEMORY_IN_USE = 145;
    private static final int HIGH_MEMORY_NOT_ALLOCATED = 147;
    private static final int XMS_OUT_OF_SPACE = 160;
    private static final int XMS_OUT_OF_HANDLES = 161;
    private static final int XMS_INVALID_HANDLE = 162;
    private static final int XMS_INVALID_SOURCE_HANDLE = 163;
    private static final int XMS_INVALID_SOURCE_OFFSET = 164;
    private static final int XMS_INVALID_DEST_HANDLE = 165;
    private static final int XMS_INVALID_DEST_OFFSET = 166;
    private static final int XMS_INVALID_LENGTH = 167;
    private static final int XMS_BLOCK_NOT_LOCKED = 170;
    private static final int XMS_BLOCK_LOCKED = 171;
    private static final int UMB_ONLY_SMALLER_BLOCK = 176;
    private static final int UMB_NO_BLOCKS_AVAILABLE = 177;
    private static int xms_callback;
    private static boolean umb_available;
    private static XMS_Block[] xms_handles;
    private static Dos_system.MultiplexHandler multiplex_xms;
    private static Callback.Handler XMS_Handler;
    private Callback callbackhandler = new Callback();
    static XMS test;
    public static Section.SectionFunction XMS_ShutDown;
    public static Section.SectionFunction XMS_Init;

    private static int XMS_EnableA20(boolean enable) {
        short val = IoHandler.IO_Read(146);
        if (enable) {
            IoHandler.IO_Write(146, val | 2);
        } else {
            IoHandler.IO_Write(146, val & 0xFFFFFFFD);
        }
        return 0;
    }

    private static int XMS_GetEnabledA20() {
        return (IoHandler.IO_Read(146) & 2) > 0 ? 1 : 0;
    }

    private static boolean InvalidHandle(int handle) {
        return handle == 0 || handle >= 50 || XMS.xms_handles[handle].free;
    }

    private static int XMS_QueryFreeMemory(IntRef largestFree, IntRef totalFree) {
        totalFree.value = Memory.MEM_FreeTotal() * 4;
        largestFree.value = Memory.MEM_FreeLargest() * 4;
        if (totalFree.value == 0) {
            return 160;
        }
        return 0;
    }

    private static int XMS_AllocateMemory(int size, IntRef handle) {
        int mem;
        int index = 1;
        while (!XMS.xms_handles[index].free) {
            if (++index < 50) continue;
            return 161;
        }
        if (size != 0) {
            int pages = size / 4 + ((size & 3) != 0 ? 1 : 0);
            mem = Memory.MEM_AllocatePages(pages, true);
            if (mem == 0) {
                return 160;
            }
        } else {
            mem = Memory.MEM_GetNextFreePage();
            if (mem == 0) {
                Log.log(21, 2, "XMS:Allocate zero pages with no memory left");
            }
        }
        XMS.xms_handles[index].free = false;
        XMS.xms_handles[index].mem = mem;
        XMS.xms_handles[index].locked = 0;
        XMS.xms_handles[index].size = size;
        handle.value = index;
        return 0;
    }

    private static int XMS_FreeMemory(int handle) {
        if (XMS.InvalidHandle(handle)) {
            return 162;
        }
        Memory.MEM_ReleasePages(XMS.xms_handles[handle].mem);
        XMS.xms_handles[handle].mem = -1;
        XMS.xms_handles[handle].size = 0;
        XMS.xms_handles[handle].free = true;
        return 0;
    }

    private static int XMS_MoveMemory(int bpt) {
        int destpt;
        int srcpt;
        int length = Memory.mem_readd(bpt + 0);
        int src_handle = Memory.mem_readw(bpt + 4);
        int src = Memory.mem_readd(bpt + 6);
        int dest_handle = Memory.mem_readw(bpt + 10);
        int dest = Memory.mem_readd(bpt + 12);
        if (src_handle != 0) {
            if (XMS.InvalidHandle(src_handle)) {
                return 163;
            }
            if (src >= XMS.xms_handles[src_handle].size * 1024) {
                return 164;
            }
            if (length > XMS.xms_handles[src_handle].size * 1024 - src) {
                return 167;
            }
            srcpt = XMS.xms_handles[src_handle].mem * 4096 + src;
        } else {
            srcpt = Memory.Real2Phys(src);
        }
        if (dest_handle != 0) {
            if (XMS.InvalidHandle(dest_handle)) {
                return 165;
            }
            if (dest >= XMS.xms_handles[dest_handle].size * 1024) {
                return 166;
            }
            if (length > XMS.xms_handles[dest_handle].size * 1024 - dest) {
                return 167;
            }
            destpt = XMS.xms_handles[dest_handle].mem * 4096 + dest;
        } else {
            destpt = Memory.Real2Phys(dest);
        }
        Memory.mem_memcpy(destpt, srcpt, length);
        return 0;
    }

    private static int XMS_LockMemory(int handle, IntRef address) {
        if (XMS.InvalidHandle(handle)) {
            return 162;
        }
        if (XMS.xms_handles[handle].locked < 255) {
            XMS.xms_handles[handle].locked = (short)(XMS.xms_handles[handle].locked + 1);
        }
        address.value = XMS.xms_handles[handle].mem * 4096;
        return 0;
    }

    private static int XMS_UnlockMemory(int handle) {
        if (XMS.InvalidHandle(handle)) {
            return 162;
        }
        if (XMS.xms_handles[handle].locked != 0) {
            XMS.xms_handles[handle].locked = (short)(XMS.xms_handles[handle].locked - 1);
            return 0;
        }
        return 170;
    }

    private static int XMS_GetHandleInformation(int handle, ShortRef lockCount, ShortRef numFree, IntRef size) {
        if (XMS.InvalidHandle(handle)) {
            return 162;
        }
        lockCount.value = XMS.xms_handles[handle].locked;
        numFree.value = 0;
        for (int i = 1; i < 50; ++i) {
            if (!XMS.xms_handles[i].free) continue;
            numFree.value = (short)(numFree.value + 1);
        }
        size.value = XMS.xms_handles[handle].size;
        return 0;
    }

    private static int XMS_ResizeMemory(int handle, int newSize) {
        if (XMS.InvalidHandle(handle)) {
            return 162;
        }
        if (XMS.xms_handles[handle].locked > 0) {
            return 171;
        }
        IntRef p = new IntRef(XMS.xms_handles[handle].mem);
        int pages = newSize / 4 + ((newSize & 3) != 0 ? 1 : 0);
        if (Memory.MEM_ReAllocatePages(p, pages, true)) {
            XMS.xms_handles[handle].mem = p.value;
            XMS.xms_handles[handle].size = newSize;
            return 0;
        }
        return 160;
    }

    private static void SET_RESULT(int res) {
        XMS.SET_RESULT(res, true);
    }

    private static void SET_RESULT(int res, boolean touch_bl_on_succes) {
        if (touch_bl_on_succes || res != 0) {
            CPU_Regs.reg_ebx.low(res);
        }
        CPU_Regs.reg_eax.word(res == 0 ? 1 : 0);
    }

    public XMS(Section configuration) {
        super(configuration);
        Section_prop section = (Section_prop)configuration;
        umb_available = false;
        if (!section.Get_bool("xms")) {
            return;
        }
        Bios.BIOS_ZeroExtendedSize(true);
        Dos_misc.DOS_AddMultiplexHandler(multiplex_xms);
        xms_callback = Memory.RealMake(Dos_tables.DOS_GetMemory(1) - 1, 16);
        this.callbackhandler.Install(XMS_Handler, 16, Memory.Real2Phys(xms_callback), "XMS Handler");
        for (int i = 0; i < 50; ++i) {
            XMS.xms_handles[i] = new XMS_Block();
            XMS.xms_handles[i].free = true;
            XMS.xms_handles[i].mem = -1;
            XMS.xms_handles[i].size = 0;
            XMS.xms_handles[i].locked = 0;
        }
        XMS.xms_handles[0].free = false;
        umb_available = section.Get_bool("umb");
        boolean ems_available = EMS.GetEMSType(section) > 0;
        Dos_memory.DOS_BuildUMBChain(section.Get_bool("umb"), ems_available);
    }

    void ShutDown() {
        Section_prop section = (Section_prop)this.m_configuration;
        Dos.dos_infoblock.SetStartOfUMBChain(65535);
        if (umb_available) {
            Dos.dos_infoblock.SetUMBChainState((short)0);
            umb_available = false;
        }
        if (!section.Get_bool("xms")) {
            return;
        }
        Bios.BIOS_ZeroExtendedSize(false);
        Dos_misc.DOS_DelMultiplexHandler(multiplex_xms);
        for (int i = 1; i < 50; ++i) {
            if (XMS.xms_handles[i].free) continue;
            XMS.XMS_FreeMemory(i);
        }
    }

    static {
        xms_handles = new XMS_Block[50];
        multiplex_xms = new Dos_system.MultiplexHandler(){

            public boolean call() {
                switch (CPU_Regs.reg_eax.word()) {
                    case 17152: {
                        CPU_Regs.reg_eax.low(128);
                        return true;
                    }
                    case 17168: {
                        CPU_Regs.SegSet16ES(Memory.RealSeg(xms_callback));
                        CPU_Regs.reg_ebx.word(Memory.RealOff(xms_callback));
                        return true;
                    }
                }
                return false;
            }
        };
        XMS_Handler = new Callback.Handler(){

            public String getName() {
                return "XMS.XMS_Handler";
            }

            public int call() {
                switch (CPU_Regs.reg_eax.high() & 0xFF) {
                    case 0: {
                        CPU_Regs.reg_eax.word(768);
                        CPU_Regs.reg_ebx.word(769);
                        CPU_Regs.reg_edx.word(0);
                        break;
                    }
                    case 1: {
                        CPU_Regs.reg_eax.word(0);
                        CPU_Regs.reg_ebx.low(144);
                        break;
                    }
                    case 2: {
                        CPU_Regs.reg_eax.word(0);
                        CPU_Regs.reg_ebx.low(144);
                        break;
                    }
                    case 3: 
                    case 5: {
                        XMS.SET_RESULT(XMS.XMS_EnableA20(true));
                        break;
                    }
                    case 4: 
                    case 6: {
                        XMS.SET_RESULT(XMS.XMS_EnableA20(false));
                        break;
                    }
                    case 7: {
                        CPU_Regs.reg_eax.word(XMS.XMS_GetEnabledA20());
                        CPU_Regs.reg_ebx.low(0);
                        break;
                    }
                    case 8: {
                        IntRef ax = new IntRef(CPU_Regs.reg_eax.word());
                        IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                        CPU_Regs.reg_ebx.low(XMS.XMS_QueryFreeMemory(ax, dx));
                        CPU_Regs.reg_eax.word(ax.value);
                        CPU_Regs.reg_edx.word(dx.value);
                        break;
                    }
                    case 137: {
                        CPU_Regs.reg_edx.dword &= 0xFFFF;
                    }
                    case 9: {
                        IntRef handle = new IntRef(0);
                        XMS.SET_RESULT(XMS.XMS_AllocateMemory(CPU_Regs.reg_edx.word(), handle));
                        CPU_Regs.reg_edx.word(handle.value);
                        break;
                    }
                    case 10: {
                        XMS.SET_RESULT(XMS.XMS_FreeMemory(CPU_Regs.reg_edx.word()));
                        break;
                    }
                    case 11: {
                        XMS.SET_RESULT(XMS.XMS_MoveMemory(CPU.Segs_DSphys + CPU_Regs.reg_esi.word()), false);
                        break;
                    }
                    case 12: {
                        IntRef address = new IntRef(0);
                        int res = XMS.XMS_LockMemory(CPU_Regs.reg_edx.word(), address);
                        if (res != 0) {
                            CPU_Regs.reg_ebx.low(res);
                        }
                        CPU_Regs.reg_eax.word(res == 0 ? 1 : 0);
                        if (res != 0) break;
                        CPU_Regs.reg_ebx.word(address.value & 0xFFFF);
                        CPU_Regs.reg_edx.word(address.value >>> 16);
                        break;
                    }
                    case 13: {
                        XMS.SET_RESULT(XMS.XMS_UnlockMemory(CPU_Regs.reg_edx.word()));
                        break;
                    }
                    case 14: {
                        ShortRef bh = new ShortRef(CPU_Regs.reg_ebx.high());
                        ShortRef bl = new ShortRef(CPU_Regs.reg_ebx.low());
                        IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                        int res = XMS.XMS_GetHandleInformation(CPU_Regs.reg_edx.word(), bh, bl, dx);
                        CPU_Regs.reg_ebx.high(bh.value);
                        CPU_Regs.reg_ebx.low(bl.value);
                        CPU_Regs.reg_edx.word(dx.value);
                        XMS.SET_RESULT(res, false);
                        break;
                    }
                    case 143: {
                        if (((long)CPU_Regs.reg_ebx.dword & 0xFFFFFFFFL) > (long)CPU_Regs.reg_ebx.word()) {
                            Log.log_msg("64MB memory limit!");
                        }
                    }
                    case 15: {
                        XMS.SET_RESULT(XMS.XMS_ResizeMemory(CPU_Regs.reg_edx.word(), CPU_Regs.reg_ebx.word()));
                        break;
                    }
                    case 16: {
                        if (!umb_available) {
                            CPU_Regs.reg_eax.word(0);
                            CPU_Regs.reg_ebx.low(128);
                            break;
                        }
                        int umb_start = Dos.dos_infoblock.GetStartOfUMBChain();
                        if (umb_start == 65535) {
                            CPU_Regs.reg_eax.word(0);
                            CPU_Regs.reg_ebx.low(177);
                            CPU_Regs.reg_edx.word(0);
                            break;
                        }
                        short umb_flag = Dos.dos_infoblock.GetUMBChainState();
                        if ((umb_flag & 1) == 0) {
                            Dos_memory.DOS_LinkUMBsToMemChain(1);
                        }
                        int old_memstrat = Dos_memory.DOS_GetMemAllocStrategy() & 0xFF;
                        Dos_memory.DOS_SetMemAllocStrategy(64);
                        IntRef size = new IntRef(CPU_Regs.reg_edx.word());
                        IntRef seg = new IntRef(0);
                        if (Dos_memory.DOS_AllocateMemory(seg, size)) {
                            CPU_Regs.reg_eax.word(1);
                            CPU_Regs.reg_ebx.word(seg.value);
                        } else {
                            CPU_Regs.reg_eax.word(0);
                            if (size.value == 0) {
                                CPU_Regs.reg_ebx.low(177);
                            } else {
                                CPU_Regs.reg_ebx.low(176);
                            }
                            CPU_Regs.reg_edx.word(size.value);
                        }
                        short current_umb_flag = Dos.dos_infoblock.GetUMBChainState();
                        if ((current_umb_flag & 1) != (umb_flag & 1)) {
                            Dos_memory.DOS_LinkUMBsToMemChain(umb_flag);
                        }
                        Dos_memory.DOS_SetMemAllocStrategy(old_memstrat);
                        break;
                    }
                    case 17: {
                        if (!umb_available) {
                            CPU_Regs.reg_eax.word(0);
                            CPU_Regs.reg_ebx.low(128);
                            break;
                        }
                        if (Dos.dos_infoblock.GetStartOfUMBChain() != 65535 && Dos_memory.DOS_FreeMemory(CPU_Regs.reg_edx.word())) {
                            CPU_Regs.reg_eax.word(1);
                            break;
                        }
                        CPU_Regs.reg_eax.word(0);
                        CPU_Regs.reg_ebx.low(177);
                        break;
                    }
                    case 136: {
                        IntRef ax = new IntRef(CPU_Regs.reg_eax.word());
                        IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                        CPU_Regs.reg_ebx.low(XMS.XMS_QueryFreeMemory(ax, dx));
                        CPU_Regs.reg_eax.word(ax.value);
                        CPU_Regs.reg_edx.word(dx.value);
                        CPU_Regs.reg_eax.dword &= 0xFFFF;
                        CPU_Regs.reg_edx.dword &= 0xFFFF;
                        CPU_Regs.reg_ecx.dword = Memory.MEM_TotalPages() * 4096 - 1;
                        break;
                    }
                    case 142: {
                        ShortRef free_handles = new ShortRef(0);
                        ShortRef bh = new ShortRef(CPU_Regs.reg_ebx.high());
                        IntRef dx = new IntRef(CPU_Regs.reg_edx.word());
                        int result = XMS.XMS_GetHandleInformation(CPU_Regs.reg_edx.word(), bh, free_handles, dx);
                        CPU_Regs.reg_ebx.high(bh.value);
                        CPU_Regs.reg_edx.word(dx.value);
                        if (result != 0) {
                            CPU_Regs.reg_ebx.low(result);
                        } else {
                            CPU_Regs.reg_edx.dword &= 0xFFFF;
                            CPU_Regs.reg_ecx.word(free_handles.value);
                        }
                        CPU_Regs.reg_eax.word(result == 0 ? 1 : 0);
                        break;
                    }
                    default: {
                        Log.log(21, 2, "XMS: unknown function " + Integer.toString(CPU_Regs.reg_eax.high(), 16));
                        CPU_Regs.reg_eax.word(0);
                        CPU_Regs.reg_ebx.low(128);
                    }
                }
                return 0;
            }
        };
        XMS_ShutDown = new Section.SectionFunction(){

            public void call(Section section) {
                test.ShutDown();
                test = null;
                for (int i = 0; i < 50; ++i) {
                    xms_handles[i] = null;
                }
            }
        };
        XMS_Init = new Section.SectionFunction(){

            public void call(Section section) {
                test = new XMS(section);
                section.AddDestroyFunction(XMS_ShutDown, true);
            }
        };
    }

    private static class XMS_Block {
        int size;
        int mem;
        short locked;
        boolean free;

        private XMS_Block() {
        }
    }
}

