/*
 * Decompiled with CFR 0.152.
 */
package jdos.misc.setup;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import jdos.misc.Cross;
import jdos.misc.Log;
import jdos.misc.Msg;
import jdos.misc.setup.CommandLine;
import jdos.misc.setup.Property;
import jdos.misc.setup.Section;
import jdos.misc.setup.Section_line;
import jdos.misc.setup.Section_prop;
import jdos.misc.setup.Value;
import jdos.util.FileIOFactory;
import jdos.util.StringHelper;

public class Config {
    public static final String MAJOR_VERSION = "0.74";
    public static final String VERSION = "0.74.25b";
    public static final boolean C_DYNAMIC = true;
    public static final boolean C_DYNREC = false;
    public static final boolean C_FPU = true;
    public static final boolean C_IPX = true;
    public static final boolean C_NE2000 = true;
    public static final boolean C_DEBUG = false;
    public static final boolean C_HEAVY_DEBUG = false;
    public static final boolean USE_FULL_TLB = true;
    public static final boolean C_VGARAM_CHECKED = true;
    public static final boolean DEBUG_LOG = false;
    public static final boolean DEBUG_DEDERMINISTIC = false;
    public static final boolean IPX_DEBUGMSG = false;
    public static final boolean DYNAMIC_CORE_VERIFY = false;
    public static final boolean FAST_STRINGS = true;
    static String current_config_dir;
    public CommandLine cmdline;
    private Vector sectionlist = new Vector();
    private boolean secure_mode;
    private StartFunction _start_function;
    private static boolean first_configfile;

    public Config(CommandLine cmd) {
        this.cmdline = cmd;
        this.secure_mode = false;
    }

    public Section_line AddSection_line(String _name, Section.SectionFunction _initfunction) {
        Section_line blah = new Section_line(_name);
        blah.AddInitFunction(_initfunction);
        this.sectionlist.add(blah);
        return blah;
    }

    public Section_prop AddSection_prop(String _name, Section.SectionFunction _initfunction) {
        return this.AddSection_prop(_name, _initfunction, false);
    }

    public Section_prop AddSection_prop(String _name, Section.SectionFunction _initfunction, boolean canchange) {
        Section_prop blah = new Section_prop(_name);
        blah.AddInitFunction(_initfunction, canchange);
        this.sectionlist.add(blah);
        return blah;
    }

    public Section GetSection(int index) {
        if (index >= 0 && index < this.sectionlist.size()) {
            return (Section)this.sectionlist.elementAt(index);
        }
        return null;
    }

    public Section GetSection(String _sectionname) {
        for (int i = 0; i < this.sectionlist.size(); ++i) {
            Section s = (Section)this.sectionlist.elementAt(i);
            if (!s.GetName().equalsIgnoreCase(_sectionname)) continue;
            return s;
        }
        return null;
    }

    public Section GetSectionFromProperty(String prop) {
        for (int i = 0; i < this.sectionlist.size(); ++i) {
            Section s = (Section)this.sectionlist.elementAt(i);
            if (s.GetPropValue(prop).equals("PROP_NOT_EXIST")) continue;
            return s;
        }
        return null;
    }

    public void SetStartUp(StartFunction _function) {
        this._start_function = _function;
    }

    public void Init() {
        for (int i = 0; i < this.sectionlist.size(); ++i) {
            Section s = (Section)this.sectionlist.elementAt(i);
            s.ExecuteInit();
        }
    }

    public void Destroy() {
        for (int i = this.sectionlist.size() - 1; i >= 0; --i) {
            Section s = (Section)this.sectionlist.elementAt(i);
            s.ExecuteDestroy(true);
        }
    }

    public void StartUp() {
        this._start_function.call();
    }

    private void fprintf(OutputStream outfile, String format, String args, int maxwidth) throws IOException {
        format = StringHelper.replace(format, "%s", args);
        if (maxwidth > 0) {
            while (args.length() < maxwidth) {
                args = " " + args;
            }
            format = StringHelper.replace(format, "%" + maxwidth + "s", args);
        }
        Config.fputs(format, outfile);
    }

    public static void fputs(String str, OutputStream outfile) throws IOException {
        if (Cross.isWindows()) {
            str = StringHelper.replace(str, "\n", "\r\n");
        }
        outfile.write(str.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean PrintConfig(String configfilename) {
        FileOutputStream outfile = null;
        try {
            int k;
            outfile = new FileOutputStream(configfilename);
            this.fprintf(outfile, Msg.get("CONFIGFILE_INTRO") + "\n", VERSION, 0);
            for (k = 0; k < this.sectionlist.size(); ++k) {
                Section tel = (Section)this.sectionlist.elementAt(k);
                Section_prop sec = null;
                if (tel instanceof Section_prop) {
                    sec = (Section_prop)tel;
                }
                Config.fputs("[" + tel.GetName().toLowerCase() + "]", outfile);
                if (sec != null) {
                    Property p;
                    int maxwidth = 0;
                    int i = 0;
                    while ((p = sec.Get_prop(i++)) != null) {
                        maxwidth = Math.max(maxwidth, p.propname.length());
                    }
                    String prefix = "\n# %" + (maxwidth > 0 ? String.valueOf(maxwidth) : "") + "s";
                    String prefix2 = "\n#   ";
                    for (int l = 0; l < maxwidth; ++l) {
                        prefix2 = prefix2 + " ";
                    }
                    i = 0;
                    while ((p = sec.Get_prop(i++)) != null) {
                        String help = p.Get_help();
                        help = StringHelper.replace(help, "\n", prefix2);
                        this.fprintf(outfile, prefix + ": " + help, p.propname, maxwidth);
                        Vector values = p.GetValues();
                        if (values.isEmpty()) continue;
                        Config.fputs(prefix2 + Msg.get("CONFIG_SUGGESTED_VALUES"), outfile);
                        for (int j = 0; j < values.size(); ++j) {
                            Value v = (Value)values.elementAt(j);
                            if (v.toString().equals("%u")) continue;
                            if (j != 0) {
                                Config.fputs(",", outfile);
                            }
                            Config.fputs(" " + v.toString(), outfile);
                        }
                        Config.fputs(".", outfile);
                    }
                    Config.fputs("\n", outfile);
                } else {
                    String help = "# " + Msg.get(tel.GetName().toUpperCase() + "_CONFIGFILE_HELP");
                    StringHelper.replace(help, "\n", "\n# ");
                    Config.fputs(help, outfile);
                }
                Config.fputs("\n", outfile);
                tel.PrintData(outfile);
                Config.fputs("\n", outfile);
            }
            k = 1;
            return k != 0;
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outfile != null) {
                try {
                    outfile.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ParseConfigFile(String configfilename) {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader(FileIOFactory.openStream(configfilename)));
            String settings_type = first_configfile ? "primary" : "additional";
            first_configfile = false;
            Log.log_msg("CONFIG:Loading " + settings_type + " settings from config file " + configfilename);
            current_config_dir = FileIOFactory.getFullPath(configfilename);
            Section currentsection = null;
            while ((line = in.readLine()) != null) {
                char c;
                if ((line = line.trim()).length() == 0 || (c = line.charAt(0)) == '%' || c == '\u0000' || c == '#' || c == ' ' || c == '\n') continue;
                if (c == '[') {
                    String sec;
                    Section testsec;
                    int pos = line.indexOf(93);
                    if (pos < 0 || (testsec = this.GetSection(sec = line.substring(1, pos))) == null) continue;
                    currentsection = testsec;
                    continue;
                }
                if (currentsection == null) continue;
                currentsection.HandleInputline(line);
            }
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        current_config_dir = "";
        return false;
    }

    public void ParseEnv() {
    }

    public boolean SecureMode() {
        return this.secure_mode;
    }

    public void SwitchToSecureMode() {
        this.secure_mode = true;
    }

    static {
        first_configfile = true;
    }

    public static interface StartFunction {
        public void call();
    }
}

