/*
 * Decompiled with CFR 0.152.
 */
package jdos.misc.setup;

import jdos.misc.setup.Hex;
import jdos.util.StringHelper;

public class Value {
    private Hex _hex = new Hex();
    private boolean _bool;
    private int _int;
    private String _string;
    private double _double;
    public int type;

    public Value() {
        this.type = 0;
    }

    public Value(Hex in) {
        this._hex = new Hex(in);
        this.type = 1;
    }

    public Value(boolean in) {
        this._bool = in;
        this.type = 2;
    }

    public Value(int in) {
        this._int = in;
        this.type = 3;
    }

    public Value(double in) {
        this._double = in;
        this.type = 5;
    }

    public Value(String in) {
        this._string = in;
        this.type = 4;
    }

    public Value(Value in) {
        this.plaincopy(in);
    }

    public Value(String in, int _t) {
        this.type = 0;
        try {
            this.SetValue(in, _t);
        }
        catch (WrongType wrongType) {
            // empty catch block
        }
    }

    public void set(Hex in) throws WrongType {
        this.copy(new Value(in));
    }

    public void set(int in) throws WrongType {
        this.copy(new Value(in));
    }

    public void set(boolean in) throws WrongType {
        this.copy(new Value(in));
    }

    public void set(double in) throws WrongType {
        this.copy(new Value(in));
    }

    public void set(String in) throws WrongType {
        this.copy(new Value(in));
    }

    public void set(Value in) throws WrongType {
        this.copy(new Value(in));
    }

    public Hex getHex() throws WrongType {
        if (this.type != 1) {
            throw new WrongType();
        }
        return this._hex;
    }

    public int getInt() throws WrongType {
        if (this.type != 3) {
            throw new WrongType();
        }
        return this._int;
    }

    public boolean getBool() throws WrongType {
        if (this.type != 2) {
            throw new WrongType();
        }
        return this._bool;
    }

    public double getDouble() throws WrongType {
        if (this.type != 5) {
            throw new WrongType();
        }
        return this._double;
    }

    public String getString() throws WrongType {
        if (this.type != 4) {
            throw new WrongType();
        }
        return this._string;
    }

    public void SetValue(String in, int _type) throws WrongType {
        if (_type == 6 && this.type == 0) {
            throw new WrongType();
        }
        if (_type != 6) {
            if (this.type != 0 && this.type != _type) {
                throw new WrongType();
            }
            this.type = _type;
        }
        if (this.type == 1) {
            this._hex = new Hex(Integer.parseInt(in, 16));
        } else if (this.type == 3) {
            this._int = Integer.parseInt(in);
        } else if (this.type == 2) {
            char c = in.toLowerCase().charAt(0);
            this._bool = c != '0' && c != 'd' && c != 'f' && !in.equalsIgnoreCase("off");
        } else if (this.type == 4) {
            this._string = in;
        } else if (this.type == 5) {
            this._double = Double.parseDouble(in);
        } else {
            throw new WrongType();
        }
    }

    public void SetValue(String in) throws WrongType {
        this.SetValue(in, 6);
    }

    public String toString() {
        if (this.type == 1) {
            return Integer.toString(this._hex._hex, 16);
        }
        if (this.type == 3) {
            return Integer.toString(this._int);
        }
        if (this.type == 2) {
            return Boolean.toString(this._bool);
        }
        if (this.type == 4) {
            return this._string;
        }
        if (this.type == 5) {
            return StringHelper.format(this._double, 2);
        }
        throw new RuntimeException("ToString messed up ?");
    }

    private void copy(Value in) throws WrongType {
        if (in != this) {
            if (this.type != 0 && this.type != in.type) {
                throw new WrongType();
            }
            this.plaincopy(in);
        }
    }

    private void plaincopy(Value in) {
        this.type = in.type;
        this._int = in._int;
        this._double = in._double;
        this._bool = in._bool;
        this._hex = new Hex(in._hex);
        this._string = in._string;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Value) {
            Value other = (Value)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.type == 2) {
                return this._bool == other._bool;
            }
            if (this.type == 3) {
                return this._int == other._int;
            }
            if (this.type == 1) {
                return this._hex.equals(other._hex);
            }
            if (this.type == 5) {
                return this._double == other._double;
            }
            if (this.type == 4) {
                return this._string.equals(other._string);
            }
            throw new RuntimeException("comparing stuff that doesn't make sense");
        }
        return false;
    }

    public static final class Etype {
        static final int V_NONE = 0;
        static final int V_HEX = 1;
        static final int V_BOOL = 2;
        static final int V_INT = 3;
        static final int V_STRING = 4;
        static final int V_DOUBLE = 5;
        static final int V_CURRENT = 6;
    }

    public class WrongType
    extends RuntimeException {
    }
}

